# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...member_base.types.member import Member
from ...organization_base.types.organization import Organization
from ...token_base.types.token_id import TokenId
from ...token_base.types.token_pair import TokenPair
from .auth_code import AuthCode

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LogonResponseResult(pydantic.BaseModel):
    auth_code: AuthCode = pydantic.Field()
    """
    Authentication result
    """

    auth_msg: typing.Optional[str] = pydantic.Field(default=None)
    """
    Authentication failure message
    """

    refresh_token_id: TokenId
    token: TokenPair
    organization: Organization
    member: Member

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
