# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...common.types.base import Base
from .bridge_group_id import BridgeGroupId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class BridgeGroup(Base):
    """
    A Bridge Group represents a connection between the Synqly Saas or Embedded service and a Bridge Agent. See 'Synqly Bridge Agent' guide in Synqly docs for additional information.
    """

    id: BridgeGroupId
    fullname: str = pydantic.Field()
    """
    Full name of bridge
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the resources included in the bridge and permissions granted on those resources. Includes details of when to use this bridge along with the intended personas.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Labels applied to Bridges within the group. These labels can be used by integrations to select the groups of bridges capable of handling requests to the integration.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
