# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class FilterOperation(str, enum.Enum):
    EQUALS = "eq"
    """
    Filter for exact matches.
    """

    NOT_EQUALS = "neq"
    """
    Filter for non-matches.
    """

    GREATER_THAN = "gt"
    """
    Filter for values greater than the provided value.
    """

    LESS_THAN = "lt"
    """
    Filter for values less than the provided value.
    """

    GREATER_THAN_OR_EQUALS = "gte"
    """
    Filter for values greater than or equal to the provided value.
    """

    LESS_THAN_OR_EQUALS = "lte"
    """
    Filter for values less than or equal to the provided value.
    """

    IN = "in"
    """
    Filter to match values in the provided comma-separated list.
    """

    LIKE = "like"
    """
    Filter to match values that contain the provided value.
    """

    NOT_IN = "not in"
    """
    Filter to match values not in the provided comma-separated list.
    """

    NOT_LIKE = "not like"
    """
    Filter to match values that do not contain the provided value.
    """

    def visit(
        self,
        equals: typing.Callable[[], T_Result],
        not_equals: typing.Callable[[], T_Result],
        greater_than: typing.Callable[[], T_Result],
        less_than: typing.Callable[[], T_Result],
        greater_than_or_equals: typing.Callable[[], T_Result],
        less_than_or_equals: typing.Callable[[], T_Result],
        in_: typing.Callable[[], T_Result],
        like: typing.Callable[[], T_Result],
        not_in: typing.Callable[[], T_Result],
        not_like: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is FilterOperation.EQUALS:
            return equals()
        if self is FilterOperation.NOT_EQUALS:
            return not_equals()
        if self is FilterOperation.GREATER_THAN:
            return greater_than()
        if self is FilterOperation.LESS_THAN:
            return less_than()
        if self is FilterOperation.GREATER_THAN_OR_EQUALS:
            return greater_than_or_equals()
        if self is FilterOperation.LESS_THAN_OR_EQUALS:
            return less_than_or_equals()
        if self is FilterOperation.IN:
            return in_()
        if self is FilterOperation.LIKE:
            return like()
        if self is FilterOperation.NOT_IN:
            return not_in()
        if self is FilterOperation.NOT_LIKE:
            return not_like()
