# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...capabilities_base.types.category_id import CategoryId
from ...capabilities_base.types.provider_id import ProviderId
from .provider_operations import ProviderOperations

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ProviderCapabilities(pydantic.BaseModel):
    id: ProviderId = pydantic.Field()
    """
    Unique identifier for the Provider.
    """

    name: str = pydantic.Field()
    """
    Name of the Provider.
    """

    description: str = pydantic.Field()
    """
    Description of what this Provider does.
    """

    connector: CategoryId = pydantic.Field()
    """
    Categories that this Provider implements.
    """

    operations: typing.Optional[typing.List[ProviderOperations]] = pydantic.Field(default=None)
    """
    Operations that this Provider implements.
    """

    provider_config: typing.Dict[str, typing.Any] = pydantic.Field()
    """
    Details on the specific configuration options for this Provider.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
