# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .filter_type import FilterType

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ProviderFilter(pydantic.BaseModel):
    name: str = pydantic.Field()
    """
    Name of the filter.
    """

    type: FilterType = pydantic.Field()
    """
    Type of the value that this filter can apply to
    """

    operators: typing.List[str] = pydantic.Field()
    """
    List of operators that this filter supports.
    """

    values: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of possible values for this filter.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
