# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...capabilities_base.types.category_id import CategoryId
from .capabilities_provider_config import CapabilitiesProviderConfig
from .provider_credential_config import ProviderCredentialConfig

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Provider(pydantic.BaseModel):
    name: str = pydantic.Field()
    """
    Name of the Provider.
    """

    description: str = pydantic.Field()
    """
    Description of what this Provider does.
    """

    categories: typing.List[CategoryId] = pydantic.Field()
    """
    Categories that this Provider implements.
    """

    picture: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the icon representing this type of Provider.
    """

    supported_operations: typing.Any = pydantic.Field()
    """
    Operations that this Provider implements.
    """

    credentials: typing.List[ProviderCredentialConfig] = pydantic.Field()
    """
    List of credential types that this Provider supports.
    """

    provider_config: typing.Dict[str, CapabilitiesProviderConfig] = pydantic.Field()
    """
    Details on the specific configuration options for this Provider.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
