# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...integration_points.types.integration_point_id import IntegrationPointId
from ...providers_generated.types.provider_config import ProviderConfig
from .bridge_selector import BridgeSelector
from .webhook_config import WebhookConfig

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CreateIntegrationRequest(pydantic.BaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this Integrations (lowercase [a-z0-9_-], can be used in URLs). Also used for case insensitive duplicate name detection and default sort order. Defaults to IntegrationId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly display name for this Integrations, will auto-generate 'name' field (if 'name' is not specified). Defaults to the same value as the 'name' field if not specified.
    """

    provider_config: ProviderConfig = pydantic.Field()
    """
    Provider configuration for this Integration.
    """

    integration_point_id: typing.Optional[IntegrationPointId] = pydantic.Field(default=None)
    """
    Integration Point associated with this integration.
    """

    bridge_selector: typing.Optional[BridgeSelector] = pydantic.Field(default=None)
    """
    Use a Bridge to connect to the provider.
    """

    webhook_config: typing.Optional[WebhookConfig] = pydantic.Field(default=None)
    """
    Web hook config for this integration
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
