# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...accounts.types.account import Account
from ...integrations.types.integration import Integration
from ...organization_webhook_base.types.webhook_filter import WebhookFilter

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class OrganizationWebhookPayload(pydantic.BaseModel):
    """
    Response payload for webhook events. This payload is sent to the webhook URL when an event occurs.
    """

    event: WebhookFilter = pydantic.Field()
    """
    The event that triggered the webhook
    """

    account: typing.Optional[Account] = pydantic.Field(default=None)
    """
    The account that the event occurred in
    """

    integration: typing.Optional[Integration] = pydantic.Field(default=None)
    """
    The integration that the event occurred in
    """

    nonce: str = pydantic.Field()
    """
    A unique identifier for this webhook event
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
