# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...organization_base.types.environment import Environment
from ...organization_webhook_base.types.webhook_filter import WebhookFilter
from .organization_webhook_secret import OrganizationWebhookSecret

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CreateOrganizationWebhookRequest(pydantic.BaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly slug for this webhook
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Fullname for this webhook
    """

    environment: typing.Optional[Environment] = pydantic.Field(default=None)
    """
    Environment that the webhook is configured for. Only events for accounts associated with this environment will trigger the webhook.
    """

    filters: typing.List[WebhookFilter] = pydantic.Field()
    """
    Specifies which Webhooks to send.
    """

    url: str = pydantic.Field()
    """
    URL that webhooks will be sent to.
    """

    secret: OrganizationWebhookSecret = pydantic.Field()
    """
    Secret used for signing webhooks. This value is used to verify the authenticity of the webhook payload.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
