# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .accounts_permissions import AccountsPermissions
from .audit_permissions import AuditPermissions
from .auth_permissions import AuthPermissions
from .bridges_permissions import BridgesPermissions
from .credentials_permissions import CredentialsPermissions
from .integration_points_permissions import IntegrationPointsPermissions
from .integrations_permissions import IntegrationsPermissions
from .members_permissions import MembersPermissions
from .organization_permissions import OrganizationPermissions
from .permission_set_permissions import PermissionSetPermissions
from .read_write_permissions import ReadWritePermissions
from .roles_permissions import RolesPermissions
from .status_permissions import StatusPermissions
from .sub_orgs_permissions import SubOrgsPermissions
from .tokens_permissions import TokensPermissions
from .transforms_permissions import TransformsPermissions
from .webhooks_permissions import WebhooksPermissions

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ApiPermissionMap(pydantic.BaseModel):
    all_: typing.Optional[ReadWritePermissions] = pydantic.Field(alias="all", default=None)
    accounts: typing.Optional[AccountsPermissions] = None
    audit: typing.Optional[AuditPermissions] = None
    auth: typing.Optional[AuthPermissions] = None
    bridges: typing.Optional[BridgesPermissions] = None
    credentials: typing.Optional[CredentialsPermissions] = None
    integrations: typing.Optional[IntegrationsPermissions] = None
    integration_points: typing.Optional[IntegrationPointsPermissions] = None
    members: typing.Optional[MembersPermissions] = None
    organizations: typing.Optional[OrganizationPermissions] = None
    permission_set: typing.Optional[PermissionSetPermissions] = None
    roles: typing.Optional[RolesPermissions] = None
    status: typing.Optional[StatusPermissions] = None
    suborgs: typing.Optional[SubOrgsPermissions] = None
    tokens: typing.Optional[TokensPermissions] = None
    transforms: typing.Optional[TransformsPermissions] = None
    webhooks: typing.Optional[WebhooksPermissions] = None

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
