# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CustomFieldMapping(pydantic.BaseModel):
    name: str = pydantic.Field()
    """
    Name for the custom field that you will use in the `custom_fields` field in ticket objects within Synqly.
    """

    project_id: str = pydantic.Field()
    """
    ID of the project this field mapping is associated with. ID of "\*" is used to apply to all projects.
    """

    provider_field_path: str = pydantic.Field()
    """
    Path to or name of the custom field in the provider.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
