# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .elasticsearch_shared_secret import ElasticsearchSharedSecret

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ElasticsearchAuthOptions(pydantic.BaseModel):
    """
    Options used to control how requests are made to elasticsearch when different authentication types are used.
    """

    run_as: typing.Optional[str] = pydantic.Field(default=None)
    """
    When you have the correct permissions, this allows API requests to get made as a specific user, with all of their roles
    and permissions. When populated, this option will send the 'es-security-runas-user' header with every request made to
    the Elasticsearch API.
    """

    shared_secret: typing.Optional[ElasticsearchSharedSecret] = pydantic.Field(default=None)
    """
    Some auth cases, notably JWT auth can be configured to require sending a shared secret in the `ES-Client-Authentication`
    header. When this secret is populated, it will get added as the shared secret for every request made to Elasticsearch.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
