# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .sumo_logic_collection_url import SumoLogicCollectionUrl
from .sumo_logic_credential import SumoLogicCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SiemSumoLogic(pydantic.BaseModel):
    """
    Configuration for Sumo Logic Cloud SIEM.
    """

    auto_parse_logs: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Automatically parse logs as JSON when running log queries against Sumo Logic. Default is true.
    """

    collection_url: typing.Optional[SumoLogicCollectionUrl] = pydantic.Field(default=None)
    """
    Required if you need to send Sumo Logic events from the Synqly API.
    """

    credential: SumoLogicCredential
    siem_logs_only: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Only query for logs that have been processed into the Sumo Logic Cloud SIEM app. Default is false.
    """

    url: str = pydantic.Field()
    """
    Your Sumo Logic API endpoint. See https://help.sumologic.com/docs/api/getting-started/#sumo-logic-endpoints-by-deployment-and-firewall-security for help determining which base URL to use.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
