# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .priority_mapping import PriorityMapping
from .status_mapping import StatusMapping

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ValueMapping(pydantic.BaseModel):
    issue_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optionally restrict this value mapping to a specific issue type. If not provided, the mapping will apply to all issue types.
    """

    priority: typing.Optional[PriorityMapping] = pydantic.Field(default=None)
    """
    Remap the standard Synqly priorities to custom values.
    """

    project_id: str = pydantic.Field()
    """
    ID of the project this value mapping is associated with. ID of "\*" is used to apply to all projects.
    """

    status: typing.Optional[StatusMapping] = pydantic.Field(default=None)
    """
    Remap the standard Synqly statuses to custom values.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
