# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...accounts.types.account_id import AccountId
from ...integration_base.types.integration_id import IntegrationId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class StatusEvent(pydantic.BaseModel):
    """
    Status event object
    """

    account_id: AccountId = pydantic.Field()
    """
    Account owner
    """

    integration_id: IntegrationId = pydantic.Field()
    """
    Integration object
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time created
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message
    """

    request: int = pydantic.Field()
    """
    Request number
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
