"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosSecret = exports.RosKey = exports.RosAlias = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAliasProps`
 *
 * @param properties - the TypeScript properties of a `RosAliasProps`
 *
 * @returns the result of the validation.
 */
function RosAliasPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('aliasName', ros.requiredValidator)(properties.aliasName));
    if (properties.aliasName && (Array.isArray(properties.aliasName) || (typeof properties.aliasName) === 'string')) {
        errors.collect(ros.propertyValidator('aliasName', ros.validateLength)({
            data: properties.aliasName.length,
            min: 1,
            max: 255,
        }));
    }
    errors.collect(ros.propertyValidator('aliasName', ros.validateString)(properties.aliasName));
    errors.collect(ros.propertyValidator('keyId', ros.requiredValidator)(properties.keyId));
    errors.collect(ros.propertyValidator('keyId', ros.validateString)(properties.keyId));
    return errors.wrap('supplied properties not correct for "RosAliasProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KMS::Alias` resource
 *
 * @param properties - the TypeScript properties of a `RosAliasProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KMS::Alias` resource.
 */
// @ts-ignore TS6133
function rosAliasPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAliasPropsValidator(properties).assertSuccess();
    }
    return {
        AliasName: ros.stringToRosTemplate(properties.aliasName),
        KeyId: ros.stringToRosTemplate(properties.keyId),
    };
}
/**
 * A ROS template type:  `ALIYUN::KMS::Alias`
 */
class RosAlias extends ros.RosResource {
    /**
     * Create a new `ALIYUN::KMS::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAlias.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.aliasName = props.aliasName;
        this.keyId = props.keyId;
    }
    get rosProperties() {
        return {
            aliasName: this.aliasName,
            keyId: this.keyId,
        };
    }
    renderProperties(props) {
        return rosAliasPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAlias = RosAlias;
/**
 * The resource type name for this resource class.
 */
RosAlias.ROS_RESOURCE_TYPE_NAME = "ALIYUN::KMS::Alias";
/**
 * Determine whether the given properties match those of a `RosKeyProps`
 *
 * @param properties - the TypeScript properties of a `RosKeyProps`
 *
 * @returns the result of the validation.
 */
function RosKeyPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('protectionLevel', ros.validateString)(properties.protectionLevel));
    if (properties.description && (Array.isArray(properties.description) || (typeof properties.description) === 'string')) {
        errors.collect(ros.propertyValidator('description', ros.validateLength)({
            data: properties.description.length,
            min: 0,
            max: 8192,
        }));
    }
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('rotationInterval', ros.validateString)(properties.rotationInterval));
    if (properties.pendingWindowInDays && (typeof properties.pendingWindowInDays) !== 'object') {
        errors.collect(ros.propertyValidator('pendingWindowInDays', ros.validateRange)({
            data: properties.pendingWindowInDays,
            min: 7,
            max: 366,
        }));
    }
    errors.collect(ros.propertyValidator('pendingWindowInDays', ros.validateNumber)(properties.pendingWindowInDays));
    errors.collect(ros.propertyValidator('enableAutomaticRotation', ros.validateBoolean)(properties.enableAutomaticRotation));
    errors.collect(ros.propertyValidator('keySpec', ros.validateString)(properties.keySpec));
    errors.collect(ros.propertyValidator('enable', ros.validateBoolean)(properties.enable));
    errors.collect(ros.propertyValidator('keyUsage', ros.validateString)(properties.keyUsage));
    errors.collect(ros.propertyValidator('dkmsInstanceId', ros.validateString)(properties.dkmsInstanceId));
    return errors.wrap('supplied properties not correct for "RosKeyProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KMS::Key` resource
 *
 * @param properties - the TypeScript properties of a `RosKeyProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KMS::Key` resource.
 */
// @ts-ignore TS6133
function rosKeyPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosKeyPropsValidator(properties).assertSuccess();
    }
    return {
        Description: ros.stringToRosTemplate(properties.description),
        DKMSInstanceId: ros.stringToRosTemplate(properties.dkmsInstanceId),
        Enable: ros.booleanToRosTemplate(properties.enable),
        EnableAutomaticRotation: ros.booleanToRosTemplate(properties.enableAutomaticRotation),
        KeySpec: ros.stringToRosTemplate(properties.keySpec),
        KeyUsage: ros.stringToRosTemplate(properties.keyUsage),
        PendingWindowInDays: ros.numberToRosTemplate(properties.pendingWindowInDays),
        ProtectionLevel: ros.stringToRosTemplate(properties.protectionLevel),
        RotationInterval: ros.stringToRosTemplate(properties.rotationInterval),
    };
}
/**
 * A ROS template type:  `ALIYUN::KMS::Key`
 */
class RosKey extends ros.RosResource {
    /**
     * Create a new `ALIYUN::KMS::Key`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosKey.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrKeyId = this.getAtt('KeyId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.description = props.description;
        this.dkmsInstanceId = props.dkmsInstanceId;
        this.enable = props.enable;
        this.enableAutomaticRotation = props.enableAutomaticRotation;
        this.keySpec = props.keySpec;
        this.keyUsage = props.keyUsage;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.protectionLevel = props.protectionLevel;
        this.rotationInterval = props.rotationInterval;
    }
    get rosProperties() {
        return {
            description: this.description,
            dkmsInstanceId: this.dkmsInstanceId,
            enable: this.enable,
            enableAutomaticRotation: this.enableAutomaticRotation,
            keySpec: this.keySpec,
            keyUsage: this.keyUsage,
            pendingWindowInDays: this.pendingWindowInDays,
            protectionLevel: this.protectionLevel,
            rotationInterval: this.rotationInterval,
        };
    }
    renderProperties(props) {
        return rosKeyPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosKey = RosKey;
/**
 * The resource type name for this resource class.
 */
RosKey.ROS_RESOURCE_TYPE_NAME = "ALIYUN::KMS::Key";
/**
 * Determine whether the given properties match those of a `RosSecretProps`
 *
 * @param properties - the TypeScript properties of a `RosSecretProps`
 *
 * @returns the result of the validation.
 */
function RosSecretPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('versionId', ros.requiredValidator)(properties.versionId));
    errors.collect(ros.propertyValidator('versionId', ros.validateString)(properties.versionId));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('rotationInterval', ros.validateString)(properties.rotationInterval));
    errors.collect(ros.propertyValidator('secretType', ros.validateString)(properties.secretType));
    if (properties.secretDataType && (typeof properties.secretDataType) !== 'object') {
        errors.collect(ros.propertyValidator('secretDataType', ros.validateAllowedValues)({
            data: properties.secretDataType,
            allowedValues: ["text", "binary"],
        }));
    }
    errors.collect(ros.propertyValidator('secretDataType', ros.validateString)(properties.secretDataType));
    errors.collect(ros.propertyValidator('dkmsInstanceId', ros.validateString)(properties.dkmsInstanceId));
    if (properties.versionStages && (Array.isArray(properties.versionStages) || (typeof properties.versionStages) === 'string')) {
        errors.collect(ros.propertyValidator('versionStages', ros.validateLength)({
            data: properties.versionStages.length,
            min: 1,
            max: 7,
        }));
    }
    errors.collect(ros.propertyValidator('versionStages', ros.listValidator(ros.validateString))(properties.versionStages));
    errors.collect(ros.propertyValidator('secretName', ros.requiredValidator)(properties.secretName));
    errors.collect(ros.propertyValidator('secretName', ros.validateString)(properties.secretName));
    errors.collect(ros.propertyValidator('enableAutomaticRotation', ros.validateBoolean)(properties.enableAutomaticRotation));
    errors.collect(ros.propertyValidator('extendedConfig', ros.hashValidator(ros.validateAny))(properties.extendedConfig));
    errors.collect(ros.propertyValidator('secretData', ros.requiredValidator)(properties.secretData));
    errors.collect(ros.propertyValidator('secretData', ros.validateString)(properties.secretData));
    errors.collect(ros.propertyValidator('encryptionKeyId', ros.validateString)(properties.encryptionKeyId));
    errors.collect(ros.propertyValidator('recoveryWindowInDays', ros.validateNumber)(properties.recoveryWindowInDays));
    errors.collect(ros.propertyValidator('forceDeleteWithoutRecovery', ros.validateBoolean)(properties.forceDeleteWithoutRecovery));
    return errors.wrap('supplied properties not correct for "RosSecretProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KMS::Secret` resource
 *
 * @param properties - the TypeScript properties of a `RosSecretProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KMS::Secret` resource.
 */
// @ts-ignore TS6133
function rosSecretPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSecretPropsValidator(properties).assertSuccess();
    }
    return {
        SecretData: ros.stringToRosTemplate(properties.secretData),
        SecretName: ros.stringToRosTemplate(properties.secretName),
        VersionId: ros.stringToRosTemplate(properties.versionId),
        Description: ros.stringToRosTemplate(properties.description),
        DKMSInstanceId: ros.stringToRosTemplate(properties.dkmsInstanceId),
        EnableAutomaticRotation: ros.booleanToRosTemplate(properties.enableAutomaticRotation),
        EncryptionKeyId: ros.stringToRosTemplate(properties.encryptionKeyId),
        ExtendedConfig: ros.hashMapper(ros.objectToRosTemplate)(properties.extendedConfig),
        ForceDeleteWithoutRecovery: ros.booleanToRosTemplate(properties.forceDeleteWithoutRecovery),
        RecoveryWindowInDays: ros.numberToRosTemplate(properties.recoveryWindowInDays),
        RotationInterval: ros.stringToRosTemplate(properties.rotationInterval),
        SecretDataType: ros.stringToRosTemplate(properties.secretDataType),
        SecretType: ros.stringToRosTemplate(properties.secretType),
        VersionStages: ros.listMapper(ros.stringToRosTemplate)(properties.versionStages),
    };
}
/**
 * A ROS template type:  `ALIYUN::KMS::Secret`
 */
class RosSecret extends ros.RosResource {
    /**
     * Create a new `ALIYUN::KMS::Secret`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSecret.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = this.getAtt('Arn');
        this.attrSecretName = this.getAtt('SecretName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.secretData = props.secretData;
        this.secretName = props.secretName;
        this.versionId = props.versionId;
        this.description = props.description;
        this.dkmsInstanceId = props.dkmsInstanceId;
        this.enableAutomaticRotation = props.enableAutomaticRotation;
        this.encryptionKeyId = props.encryptionKeyId;
        this.extendedConfig = props.extendedConfig;
        this.forceDeleteWithoutRecovery = props.forceDeleteWithoutRecovery;
        this.recoveryWindowInDays = props.recoveryWindowInDays;
        this.rotationInterval = props.rotationInterval;
        this.secretDataType = props.secretDataType;
        this.secretType = props.secretType;
        this.versionStages = props.versionStages;
    }
    get rosProperties() {
        return {
            secretData: this.secretData,
            secretName: this.secretName,
            versionId: this.versionId,
            description: this.description,
            dkmsInstanceId: this.dkmsInstanceId,
            enableAutomaticRotation: this.enableAutomaticRotation,
            encryptionKeyId: this.encryptionKeyId,
            extendedConfig: this.extendedConfig,
            forceDeleteWithoutRecovery: this.forceDeleteWithoutRecovery,
            recoveryWindowInDays: this.recoveryWindowInDays,
            rotationInterval: this.rotationInterval,
            secretDataType: this.secretDataType,
            secretType: this.secretType,
            versionStages: this.versionStages,
        };
    }
    renderProperties(props) {
        return rosSecretPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSecret = RosSecret;
/**
 * The resource type name for this resource class.
 */
RosSecret.ROS_RESOURCE_TYPE_NAME = "ALIYUN::KMS::Secret";
//# sourceMappingURL=data:application/json;base64,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