"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = exports.SecretProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kms_generated_1 = require("./kms.generated");
Object.defineProperty(exports, "SecretProperty", { enumerable: true, get: function () { return kms_generated_1.RosSecret; } });
/**
 * A ROS resource type:  `ALIYUN::KMS::Secret`
 */
class Secret extends ros.Resource {
    /**
     * Create a new `ALIYUN::KMS::Secret`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSecret = new kms_generated_1.RosSecret(this, id, {
            versionId: props.versionId,
            description: props.description,
            rotationInterval: props.rotationInterval,
            secretType: props.secretType,
            secretDataType: props.secretDataType,
            dkmsInstanceId: props.dkmsInstanceId,
            versionStages: props.versionStages,
            secretName: props.secretName,
            enableAutomaticRotation: props.enableAutomaticRotation,
            extendedConfig: props.extendedConfig,
            secretData: props.secretData,
            encryptionKeyId: props.encryptionKeyId,
            recoveryWindowInDays: props.recoveryWindowInDays === undefined || props.recoveryWindowInDays === null ? 30 : props.recoveryWindowInDays,
            forceDeleteWithoutRecovery: props.forceDeleteWithoutRecovery === undefined || props.forceDeleteWithoutRecovery === null ? false : props.forceDeleteWithoutRecovery,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSecret;
        this.attrArn = rosSecret.attrArn;
        this.attrSecretName = rosSecret.attrSecretName;
    }
}
exports.Secret = Secret;
//# sourceMappingURL=data:application/json;base64,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