#
# This file is part of Invenio.
# Copyright (C) 2016-2018 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Remove version table."""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op
from sqlalchemy.dialects import mysql, postgresql

# revision identifiers, used by Alembic.
revision = "a3f5a8635cbb"
down_revision = "5b478fe7ef7f"
branch_labels = ()
depends_on = None


def upgrade():
    """Upgrade database."""
    op.drop_index(
        "ix_communities_metadata_version_end_transaction_id",
        table_name="communities_metadata_version",
    )
    op.drop_index(
        "ix_communities_metadata_version_operation_type",
        table_name="communities_metadata_version",
    )
    op.drop_index(
        "ix_communities_metadata_version_transaction_id",
        table_name="communities_metadata_version",
    )
    op.drop_table("communities_metadata_version")
    op.add_column(
        "communities_metadata", sa.Column("slug", sa.String(length=255), nullable=True)
    )
    op.create_unique_constraint(
        op.f("uq_communities_metadata_slug"), "communities_metadata", ["slug"]
    )


def downgrade():
    """Downgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        op.f("uq_communities_metadata_slug"), "communities_metadata", type_="unique"
    )
    op.drop_column("communities_metadata", "slug")
    op.create_table(
        "communities_metadata_version",
        sa.Column(
            "created",
            sa.DateTime().with_variant(mysql.DATETIME(fsp=6), "mysql"),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "updated",
            sa.DateTime().with_variant(mysql.DATETIME(fsp=6), "mysql"),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "json",
            sa.JSON()
            .with_variant(sqlalchemy_utils.types.json.JSONType(), "mysql")
            .with_variant(
                postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), "postgresql"
            )
            .with_variant(sqlalchemy_utils.types.json.JSONType(), "sqlite"),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("version_id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column(
            "bucket_id",
            sqlalchemy_utils.types.uuid.UUIDType(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint(
            "id", "transaction_id", name=op.f("pk_communities_metadata_version")
        ),
    )
    op.create_index(
        op.f("ix_communities_metadata_version_end_transaction_id"),
        "communities_metadata_version",
        ["end_transaction_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_communities_metadata_version_operation_type"),
        "communities_metadata_version",
        ["operation_type"],
        unique=False,
    )
    op.create_index(
        op.f("ix_communities_metadata_version_transaction_id"),
        "communities_metadata_version",
        ["transaction_id"],
        unique=False,
    )
