
import typer

from yzlite import cli


@cli.root_cli.command('view_audio')
def view_audio_command(
    model: str = typer.Argument(None,
                                help='''\b
One of the following:
- YZLITE model name 
- Path to model specification file (.py)
- Path to model archive file (.yzlite.zip)''',
                                metavar='<model>'
                                ),
    verbose: bool = typer.Option(False, '--verbose', '-v',
                                 help='Enable verbose console logs'
                                 ),
):
    """View the spectrograms generated by the AudioFeatureGenerator in real-time

    \b
    NOTE: This command is experimental. Use at your own risk!
    \b
    This starts a wxPython GUI that allows for viewing the spectrograms generated
    by the AudioFeatureGenerator in real-time. 
    This is useful for determining which AudioFeatureGenerator settings and data
    augmentation parameters to use with the ParallelAudioDataGenerator.
    \b
    For more details see:
    https://github.com/ReRAM-Labs/yzlite/docs/audio/audio_utilities
    """
    # Import all required packages here instead of at top
    # to help improve the CLI's responsiveness
    from yzlite.utils.audio_visualizer import run_audio_visualizer_app

    logger = cli.get_logger(verbose=verbose)
    run_audio_visualizer_app(model, logger=logger)
