import sys
from pathlib import Path

from edc_test_utils import DefaultTestSettings

app_name = "edc_sites"
base_dir = Path(__file__).absolute().parent.parent.parent
project_settings = DefaultTestSettings(
    calling_file=__file__,
    template_dirs=[base_dir / app_name / "tests" / "templates"],
    BASE_DIR=base_dir,
    DEBUG=True,
    DJANGO_CRYPTO_FIELDS_KEY_PATH=base_dir / app_name / "tests" / "etc",
    ETC_DIR=base_dir / app_name / "tests" / "etc",
    GIT_DIR=base_dir,
    AUTO_CREATE_KEYS=False,
    APP_NAME=app_name,
    SITE_ID=10,
    EDC_SITES_MODULE_NAME=f"{app_name}.tests.sites",
    SILENCED_SYSTEM_CHECKS=[
        "sites.E101",
        "edc_navbar.E002",
        "edc_navbar.E003",
        "edc_consent.E001",
        "edc_sites.E001",
        "edc_sites.E002",
        "edc_consent.E002",
    ],
    SUBJECT_VISIT_MODEL="edc_visit_tracking.subjectvisit",
    INSTALLED_APPS=[
        "django.contrib.admin",
        "django.contrib.auth",
        "django.contrib.contenttypes",
        "django.contrib.sessions",
        "django.contrib.messages",
        "django.contrib.staticfiles",
        "django.contrib.sites",
        "multisite",
        "django_crypto_fields.apps.AppConfig",
        "django_revision.apps.AppConfig",
        "edc_action_item.apps.AppConfig",
        "edc_adverse_event.apps.AppConfig",
        "adverse_event_app.apps.AppConfig",
        "edc_appointment.apps.AppConfig",
        "edc_auth.apps.AppConfig",
        "edc_dashboard.apps.AppConfig",
        "edc_data_manager.apps.AppConfig",
        "edc_facility.apps.AppConfig",
        "edc_form_runners.apps.AppConfig",
        "edc_lab.apps.AppConfig",
        "edc_list_data.apps.AppConfig",
        "edc_listboard.apps.AppConfig",
        "edc_metadata.apps.AppConfig",
        "edc_navbar.apps.AppConfig",
        "edc_notification.apps.AppConfig",
        "edc_registration.apps.AppConfig",
        "edc_review_dashboard.apps.AppConfig",
        "edc_screening.apps.AppConfig",
        "edc_sites.apps.AppConfig",
        "edc_subject_dashboard.apps.AppConfig",
        "edc_visit_schedule.apps.AppConfig",
        "edc_visit_tracking.apps.AppConfig",
        "edc_sites.tests",
        "edc_appconfig.apps.AppConfig",
    ],
    USE_I18N=True,
    USE_L10N=True,
    USE_TZ=True,
    LANGUAGE_CODE="en",
    use_test_urls=True,
    add_dashboard_middleware=True,
).settings

for k, v in project_settings.items():
    setattr(sys.modules[__name__], k, v)
