from ccxt.base.types import Entry


class ImplicitAPI:
    public_get_ping = publicGetPing = Entry('ping', 'public', 'GET', {})
    public_get_currencies = publicGetCurrencies = Entry('currencies', 'public', 'GET', {})
    public_get_currencies_symbol = publicGetCurrenciesSymbol = Entry('currencies/{symbol}', 'public', 'GET', {})
    public_get_markets = publicGetMarkets = Entry('markets', 'public', 'GET', {})
    public_get_markets_tickers = publicGetMarketsTickers = Entry('markets/tickers', 'public', 'GET', {})
    public_get_markets_summaries = publicGetMarketsSummaries = Entry('markets/summaries', 'public', 'GET', {})
    public_get_markets_marketsymbol = publicGetMarketsMarketSymbol = Entry('markets/{marketSymbol}', 'public', 'GET', {})
    public_get_markets_marketsymbol_summary = publicGetMarketsMarketSymbolSummary = Entry('markets/{marketSymbol}/summary', 'public', 'GET', {})
    public_get_markets_marketsymbol_orderbook = publicGetMarketsMarketSymbolOrderbook = Entry('markets/{marketSymbol}/orderbook', 'public', 'GET', {})
    public_get_markets_marketsymbol_trades = publicGetMarketsMarketSymbolTrades = Entry('markets/{marketSymbol}/trades', 'public', 'GET', {})
    public_get_markets_marketsymbol_ticker = publicGetMarketsMarketSymbolTicker = Entry('markets/{marketSymbol}/ticker', 'public', 'GET', {})
    public_get_markets_marketsymbol_candles_candleinterval_recent = publicGetMarketsMarketSymbolCandlesCandleIntervalRecent = Entry('markets/{marketSymbol}/candles/{candleInterval}/recent', 'public', 'GET', {})
    public_get_markets_marketsymbol_candles_candleinterval_historical_year_month_day = publicGetMarketsMarketSymbolCandlesCandleIntervalHistoricalYearMonthDay = Entry('markets/{marketSymbol}/candles/{candleInterval}/historical/{year}/{month}/{day}', 'public', 'GET', {})
    public_get_markets_marketsymbol_candles_candleinterval_historical_year_month = publicGetMarketsMarketSymbolCandlesCandleIntervalHistoricalYearMonth = Entry('markets/{marketSymbol}/candles/{candleInterval}/historical/{year}/{month}', 'public', 'GET', {})
    public_get_markets_marketsymbol_candles_candleinterval_historical_year = publicGetMarketsMarketSymbolCandlesCandleIntervalHistoricalYear = Entry('markets/{marketSymbol}/candles/{candleInterval}/historical/{year}', 'public', 'GET', {})
    private_get_account = privateGetAccount = Entry('account', 'private', 'GET', {})
    private_get_account_fees_fiat = privateGetAccountFeesFiat = Entry('account/fees/fiat', 'private', 'GET', {})
    private_get_account_fees_fiat_currencysymbol = privateGetAccountFeesFiatCurrencySymbol = Entry('account/fees/fiat/{currencySymbol}', 'private', 'GET', {})
    private_get_account_fees_trading = privateGetAccountFeesTrading = Entry('account/fees/trading', 'private', 'GET', {})
    private_get_account_fees_trading_marketsymbol = privateGetAccountFeesTradingMarketSymbol = Entry('account/fees/trading/{marketSymbol}', 'private', 'GET', {})
    private_get_account_volume = privateGetAccountVolume = Entry('account/volume', 'private', 'GET', {})
    private_get_account_permissions_markets = privateGetAccountPermissionsMarkets = Entry('account/permissions/markets', 'private', 'GET', {})
    private_get_account_permissions_markets_marketsymbol = privateGetAccountPermissionsMarketsMarketSymbol = Entry('account/permissions/markets/{marketSymbol}', 'private', 'GET', {})
    private_get_account_permissions_currencies = privateGetAccountPermissionsCurrencies = Entry('account/permissions/currencies', 'private', 'GET', {})
    private_get_account_permissions_currencies_currencysymbol = privateGetAccountPermissionsCurrenciesCurrencySymbol = Entry('account/permissions/currencies/{currencySymbol}', 'private', 'GET', {})
    private_get_addresses = privateGetAddresses = Entry('addresses', 'private', 'GET', {})
    private_get_addresses_currencysymbol = privateGetAddressesCurrencySymbol = Entry('addresses/{currencySymbol}', 'private', 'GET', {})
    private_get_balances = privateGetBalances = Entry('balances', 'private', 'GET', {})
    private_get_balances_currencysymbol = privateGetBalancesCurrencySymbol = Entry('balances/{currencySymbol}', 'private', 'GET', {})
    private_get_deposits_open = privateGetDepositsOpen = Entry('deposits/open', 'private', 'GET', {})
    private_get_deposits_closed = privateGetDepositsClosed = Entry('deposits/closed', 'private', 'GET', {})
    private_get_deposits_bytxid_txid = privateGetDepositsByTxIdTxId = Entry('deposits/ByTxId/{txId}', 'private', 'GET', {})
    private_get_deposits_depositid = privateGetDepositsDepositId = Entry('deposits/{depositId}', 'private', 'GET', {})
    private_get_executions = privateGetExecutions = Entry('executions', 'private', 'GET', {})
    private_get_executions_last_id = privateGetExecutionsLastId = Entry('executions/last-id', 'private', 'GET', {})
    private_get_executions_executionid = privateGetExecutionsExecutionId = Entry('executions/{executionId}', 'private', 'GET', {})
    private_get_orders_closed = privateGetOrdersClosed = Entry('orders/closed', 'private', 'GET', {})
    private_get_orders_open = privateGetOrdersOpen = Entry('orders/open', 'private', 'GET', {})
    private_get_orders_orderid = privateGetOrdersOrderId = Entry('orders/{orderId}', 'private', 'GET', {})
    private_get_orders_orderid_executions = privateGetOrdersOrderIdExecutions = Entry('orders/{orderId}/executions', 'private', 'GET', {})
    private_get_ping = privateGetPing = Entry('ping', 'private', 'GET', {})
    private_get_subaccounts_subaccountid = privateGetSubaccountsSubaccountId = Entry('subaccounts/{subaccountId}', 'private', 'GET', {})
    private_get_subaccounts = privateGetSubaccounts = Entry('subaccounts', 'private', 'GET', {})
    private_get_subaccounts_withdrawals_open = privateGetSubaccountsWithdrawalsOpen = Entry('subaccounts/withdrawals/open', 'private', 'GET', {})
    private_get_subaccounts_withdrawals_closed = privateGetSubaccountsWithdrawalsClosed = Entry('subaccounts/withdrawals/closed', 'private', 'GET', {})
    private_get_subaccounts_deposits_open = privateGetSubaccountsDepositsOpen = Entry('subaccounts/deposits/open', 'private', 'GET', {})
    private_get_subaccounts_deposits_closed = privateGetSubaccountsDepositsClosed = Entry('subaccounts/deposits/closed', 'private', 'GET', {})
    private_get_withdrawals_open = privateGetWithdrawalsOpen = Entry('withdrawals/open', 'private', 'GET', {})
    private_get_withdrawals_closed = privateGetWithdrawalsClosed = Entry('withdrawals/closed', 'private', 'GET', {})
    private_get_withdrawals_bytxid_txid = privateGetWithdrawalsByTxIdTxId = Entry('withdrawals/ByTxId/{txId}', 'private', 'GET', {})
    private_get_withdrawals_withdrawalid = privateGetWithdrawalsWithdrawalId = Entry('withdrawals/{withdrawalId}', 'private', 'GET', {})
    private_get_withdrawals_allowed_addresses = privateGetWithdrawalsAllowedAddresses = Entry('withdrawals/allowed-addresses', 'private', 'GET', {})
    private_get_conditional_orders_conditionalorderid = privateGetConditionalOrdersConditionalOrderId = Entry('conditional-orders/{conditionalOrderId}', 'private', 'GET', {})
    private_get_conditional_orders_closed = privateGetConditionalOrdersClosed = Entry('conditional-orders/closed', 'private', 'GET', {})
    private_get_conditional_orders_open = privateGetConditionalOrdersOpen = Entry('conditional-orders/open', 'private', 'GET', {})
    private_get_transfers_sent = privateGetTransfersSent = Entry('transfers/sent', 'private', 'GET', {})
    private_get_transfers_received = privateGetTransfersReceived = Entry('transfers/received', 'private', 'GET', {})
    private_get_transfers_transferid = privateGetTransfersTransferId = Entry('transfers/{transferId}', 'private', 'GET', {})
    private_get_funds_transfer_methods_fundstransfermethodid = privateGetFundsTransferMethodsFundsTransferMethodId = Entry('funds-transfer-methods/{fundsTransferMethodId}', 'private', 'GET', {})
    private_post_addresses = privatePostAddresses = Entry('addresses', 'private', 'POST', {})
    private_post_orders = privatePostOrders = Entry('orders', 'private', 'POST', {})
    private_post_subaccounts = privatePostSubaccounts = Entry('subaccounts', 'private', 'POST', {})
    private_post_withdrawals = privatePostWithdrawals = Entry('withdrawals', 'private', 'POST', {})
    private_post_conditional_orders = privatePostConditionalOrders = Entry('conditional-orders', 'private', 'POST', {})
    private_post_transfers = privatePostTransfers = Entry('transfers', 'private', 'POST', {})
    private_post_batch = privatePostBatch = Entry('batch', 'private', 'POST', {})
    private_delete_orders_open = privateDeleteOrdersOpen = Entry('orders/open', 'private', 'DELETE', {})
    private_delete_orders_orderid = privateDeleteOrdersOrderId = Entry('orders/{orderId}', 'private', 'DELETE', {})
    private_delete_withdrawals_withdrawalid = privateDeleteWithdrawalsWithdrawalId = Entry('withdrawals/{withdrawalId}', 'private', 'DELETE', {})
    private_delete_conditional_orders_conditionalorderid = privateDeleteConditionalOrdersConditionalOrderId = Entry('conditional-orders/{conditionalOrderId}', 'private', 'DELETE', {})
    signalr_get_negotiate = signalrGetNegotiate = Entry('negotiate', 'signalr', 'GET', {})
    signalr_get_start = signalrGetStart = Entry('start', 'signalr', 'GET', {})
