from ccxt.base.types import Entry


class ImplicitAPI:
    general_get_time = generalGetTime = Entry('time', 'general', 'GET', {'cost': 8.3334})
    account_get_wallet = accountGetWallet = Entry('wallet', 'account', 'GET', {'cost': 8.3334})
    account_get_sub_account = accountGetSubAccount = Entry('sub-account', 'account', 'GET', {'cost': 1000})
    account_get_asset_valuation = accountGetAssetValuation = Entry('asset-valuation', 'account', 'GET', {'cost': 1000})
    account_get_wallet_currency = accountGetWalletCurrency = Entry('wallet/{currency}', 'account', 'GET', {'cost': 8.3334})
    account_get_withdrawal_history = accountGetWithdrawalHistory = Entry('withdrawal/history', 'account', 'GET', {'cost': 8.3334})
    account_get_withdrawal_history_currency = accountGetWithdrawalHistoryCurrency = Entry('withdrawal/history/{currency}', 'account', 'GET', {'cost': 8.3334})
    account_get_ledger = accountGetLedger = Entry('ledger', 'account', 'GET', {'cost': 5})
    account_get_deposit_address = accountGetDepositAddress = Entry('deposit/address', 'account', 'GET', {'cost': 8.3334})
    account_get_deposit_history = accountGetDepositHistory = Entry('deposit/history', 'account', 'GET', {'cost': 8.3334})
    account_get_deposit_history_currency = accountGetDepositHistoryCurrency = Entry('deposit/history/{currency}', 'account', 'GET', {'cost': 8.3334})
    account_get_currencies = accountGetCurrencies = Entry('currencies', 'account', 'GET', {'cost': 8.3334})
    account_get_withdrawal_fee = accountGetWithdrawalFee = Entry('withdrawal/fee', 'account', 'GET', {'cost': 8.3334})
    account_get_deposit_lightning = accountGetDepositLightning = Entry('deposit-lightning', 'account', 'GET', {'cost': 50})
    account_get_withdrawal_lightning = accountGetWithdrawalLightning = Entry('withdrawal-lightning', 'account', 'GET', {'cost': 50})
    account_get_fiat_deposit_detail = accountGetFiatDepositDetail = Entry('fiat/deposit/detail', 'account', 'GET', {'cost': 5})
    account_get_fiat_deposit_details = accountGetFiatDepositDetails = Entry('fiat/deposit/details', 'account', 'GET', {'cost': 8.3334})
    account_get_fiat_withdraw_detail = accountGetFiatWithdrawDetail = Entry('fiat/withdraw/detail', 'account', 'GET', {'cost': 5})
    account_get_fiat_withdraw_details = accountGetFiatWithdrawDetails = Entry('fiat/withdraw/details', 'account', 'GET', {'cost': 8.3334})
    account_get_fiat_channel = accountGetFiatChannel = Entry('fiat/channel', 'account', 'GET', {'cost': 8.3334})
    account_post_transfer = accountPostTransfer = Entry('transfer', 'account', 'POST', {'cost': 100})
    account_post_withdrawal = accountPostWithdrawal = Entry('withdrawal', 'account', 'POST', {'cost': 8.3334})
    account_post_fiat_cancel_deposit = accountPostFiatCancelDeposit = Entry('fiat/cancel_deposit', 'account', 'POST', {'cost': 1})
    account_post_fiat_deposit = accountPostFiatDeposit = Entry('fiat/deposit', 'account', 'POST', {'cost': 8.3334})
    account_post_fiat_withdraw = accountPostFiatWithdraw = Entry('fiat/withdraw', 'account', 'POST', {'cost': 8.3334})
    account_post_fiat_cancel_withdrawal = accountPostFiatCancelWithdrawal = Entry('fiat/cancel_withdrawal', 'account', 'POST', {'cost': 1})
    otc_get_rfq_instruments = otcGetRfqInstruments = Entry('rfq/instruments', 'otc', 'GET', {'cost': 50})
    otc_get_rfq_trade = otcGetRfqTrade = Entry('rfq/trade', 'otc', 'GET', {'cost': 50})
    otc_get_rfq_history = otcGetRfqHistory = Entry('rfq/history', 'otc', 'GET', {'cost': 50})
    otc_post_rfq_quote = otcPostRfqQuote = Entry('rfq/quote', 'otc', 'POST', {'cost': 50})
    otc_post_rfq_trade = otcPostRfqTrade = Entry('rfq/trade', 'otc', 'POST', {'cost': 50})
    users_get_subaccount_info = usersGetSubaccountInfo = Entry('subaccount-info', 'users', 'GET', {'cost': 20})
    users_get_account_info = usersGetAccountInfo = Entry('account-info', 'users', 'GET', {'cost': 20})
    users_get_subaccount_apikey = usersGetSubaccountApikey = Entry('subaccount/apikey', 'users', 'GET', {'cost': 20})
    users_post_create_subaccount = usersPostCreateSubaccount = Entry('create-subaccount', 'users', 'POST', {'cost': 5})
    users_post_delete_subaccount = usersPostDeleteSubaccount = Entry('delete-subaccount', 'users', 'POST', {'cost': 5})
    users_post_subaccount_apikey = usersPostSubaccountApikey = Entry('subaccount/apikey', 'users', 'POST', {'cost': 50})
    users_post_subacount_delete_apikey = usersPostSubacountDeleteApikey = Entry('subacount/delete-apikey', 'users', 'POST', {'cost': 20})
    users_post_subacount_modify_apikey = usersPostSubacountModifyApikey = Entry('subacount/modify-apikey', 'users', 'POST', {'cost': 20})
    earning_get_offers = earningGetOffers = Entry('offers', 'earning', 'GET', {'cost': 5})
    earning_get_orders = earningGetOrders = Entry('orders', 'earning', 'GET', {'cost': 5})
    earning_get_positions = earningGetPositions = Entry('positions', 'earning', 'GET', {'cost': 8.3334})
    earning_post_purchase = earningPostPurchase = Entry('purchase', 'earning', 'POST', {'cost': 5})
    earning_post_redeem = earningPostRedeem = Entry('redeem', 'earning', 'POST', {'cost': 5})
    earning_post_cancel = earningPostCancel = Entry('cancel', 'earning', 'POST', {'cost': 5})
    spot_get_accounts = spotGetAccounts = Entry('accounts', 'spot', 'GET', {'cost': 5})
    spot_get_accounts_currency = spotGetAccountsCurrency = Entry('accounts/{currency}', 'spot', 'GET', {'cost': 5})
    spot_get_accounts_currency_ledger = spotGetAccountsCurrencyLedger = Entry('accounts/{currency}/ledger', 'spot', 'GET', {'cost': 5})
    spot_get_orders = spotGetOrders = Entry('orders', 'spot', 'GET', {'cost': 10})
    spot_get_orders_pending = spotGetOrdersPending = Entry('orders_pending', 'spot', 'GET', {'cost': 5})
    spot_get_orders_order_id = spotGetOrdersOrderId = Entry('orders/{order_id}', 'spot', 'GET', {'cost': 5})
    spot_get_orders_client_oid = spotGetOrdersClientOid = Entry('orders/{client_oid}', 'spot', 'GET', {'cost': 5})
    spot_get_trade_fee = spotGetTradeFee = Entry('trade_fee', 'spot', 'GET', {'cost': 5})
    spot_get_fills = spotGetFills = Entry('fills', 'spot', 'GET', {'cost': 10})
    spot_get_algo = spotGetAlgo = Entry('algo', 'spot', 'GET', {'cost': 5})
    spot_get_instruments = spotGetInstruments = Entry('instruments', 'spot', 'GET', {'cost': 5})
    spot_get_instruments_instrument_id_book = spotGetInstrumentsInstrumentIdBook = Entry('instruments/{instrument_id}/book', 'spot', 'GET', {'cost': 5})
    spot_get_instruments_ticker = spotGetInstrumentsTicker = Entry('instruments/ticker', 'spot', 'GET', {'cost': 5})
    spot_get_instruments_instrument_id_ticker = spotGetInstrumentsInstrumentIdTicker = Entry('instruments/{instrument_id}/ticker', 'spot', 'GET', {'cost': 5})
    spot_get_instruments_instrument_id_trades = spotGetInstrumentsInstrumentIdTrades = Entry('instruments/{instrument_id}/trades', 'spot', 'GET', {'cost': 5})
    spot_get_instruments_instrument_id_candles = spotGetInstrumentsInstrumentIdCandles = Entry('instruments/{instrument_id}/candles', 'spot', 'GET', {'cost': 5})
    spot_post_order_algo = spotPostOrderAlgo = Entry('order_algo', 'spot', 'POST', {'cost': 2.5})
    spot_post_orders = spotPostOrders = Entry('orders', 'spot', 'POST', {'cost': 1})
    spot_post_batch_orders = spotPostBatchOrders = Entry('batch_orders', 'spot', 'POST', {'cost': 2})
    spot_post_cancel_orders_order_id = spotPostCancelOrdersOrderId = Entry('cancel_orders/{order_id}', 'spot', 'POST', {'cost': 1})
    spot_post_cancel_orders_client_oid = spotPostCancelOrdersClientOid = Entry('cancel_orders/{client_oid}', 'spot', 'POST', {'cost': 1})
    spot_post_cancel_batch_algos = spotPostCancelBatchAlgos = Entry('cancel_batch_algos', 'spot', 'POST', {'cost': 5})
    spot_post_cancel_batch_orders = spotPostCancelBatchOrders = Entry('cancel_batch_orders', 'spot', 'POST', {'cost': 5})
    spot_post_amend_order_instrument_id = spotPostAmendOrderInstrumentId = Entry('amend_order/{instrument_id}', 'spot', 'POST', {'cost': 2.5})
    spot_post_amend_batch_orders = spotPostAmendBatchOrders = Entry('amend_batch_orders', 'spot', 'POST', {'cost': 5})
    margin_get_accounts = marginGetAccounts = Entry('accounts', 'margin', 'GET', {'cost': 5})
    margin_get_accounts_instrument_id = marginGetAccountsInstrumentId = Entry('accounts/{instrument_id}', 'margin', 'GET', {'cost': 5})
    margin_get_accounts_instrument_id_ledger = marginGetAccountsInstrumentIdLedger = Entry('accounts/{instrument_id}/ledger', 'margin', 'GET', {'cost': 5})
    margin_get_accounts_availability = marginGetAccountsAvailability = Entry('accounts/availability', 'margin', 'GET', {'cost': 5})
    margin_get_accounts_instrument_id_availability = marginGetAccountsInstrumentIdAvailability = Entry('accounts/{instrument_id}/availability', 'margin', 'GET', {'cost': 5})
    margin_get_accounts_borrowed = marginGetAccountsBorrowed = Entry('accounts/borrowed', 'margin', 'GET', {'cost': 5})
    margin_get_accounts_instrument_id_borrowed = marginGetAccountsInstrumentIdBorrowed = Entry('accounts/{instrument_id}/borrowed', 'margin', 'GET', {'cost': 5})
    margin_get_orders = marginGetOrders = Entry('orders', 'margin', 'GET', {'cost': 10})
    margin_get_accounts_instrument_id_leverage = marginGetAccountsInstrumentIdLeverage = Entry('accounts/{instrument_id}/leverage', 'margin', 'GET', {'cost': 1})
    margin_get_orders_order_id = marginGetOrdersOrderId = Entry('orders/{order_id}', 'margin', 'GET', {'cost': 5})
    margin_get_orders_client_oid = marginGetOrdersClientOid = Entry('orders/{client_oid}', 'margin', 'GET', {'cost': 5})
    margin_get_orders_pending = marginGetOrdersPending = Entry('orders_pending', 'margin', 'GET', {'cost': 5})
    margin_get_fills = marginGetFills = Entry('fills', 'margin', 'GET', {'cost': 10})
    margin_get_instruments_instrument_id_mark_price = marginGetInstrumentsInstrumentIdMarkPrice = Entry('instruments/{instrument_id}/mark_price', 'margin', 'GET', {'cost': 5})
    margin_post_accounts_borrow = marginPostAccountsBorrow = Entry('accounts/borrow', 'margin', 'POST', {'cost': 1})
    margin_post_accounts_repayment = marginPostAccountsRepayment = Entry('accounts/repayment', 'margin', 'POST', {'cost': 1})
    margin_post_orders = marginPostOrders = Entry('orders', 'margin', 'POST', {'cost': 1})
    margin_post_batch_orders = marginPostBatchOrders = Entry('batch_orders', 'margin', 'POST', {'cost': 2})
    margin_post_cancel_orders = marginPostCancelOrders = Entry('cancel_orders', 'margin', 'POST', {'cost': 1})
    margin_post_cancel_orders_order_id = marginPostCancelOrdersOrderId = Entry('cancel_orders/{order_id}', 'margin', 'POST', {'cost': 1})
    margin_post_cancel_orders_client_oid = marginPostCancelOrdersClientOid = Entry('cancel_orders/{client_oid}', 'margin', 'POST', {'cost': 1})
    margin_post_cancel_batch_orders = marginPostCancelBatchOrders = Entry('cancel_batch_orders', 'margin', 'POST', {'cost': 2})
    margin_post_amend_order_instrument_id = marginPostAmendOrderInstrumentId = Entry('amend_order/{instrument_id}', 'margin', 'POST', {'cost': 2.5})
    margin_post_amend_batch_orders = marginPostAmendBatchOrders = Entry('amend_batch_orders', 'margin', 'POST', {'cost': 5})
    margin_post_accounts_instrument_id_leverage = marginPostAccountsInstrumentIdLeverage = Entry('accounts/{instrument_id}/leverage', 'margin', 'POST', {'cost': 1})
    system_get_status = systemGetStatus = Entry('status', 'system', 'GET', {'cost': 250})
    market_get_oracle = marketGetOracle = Entry('oracle', 'market', 'GET', {'cost': 250})
    futures_get_position = futuresGetPosition = Entry('position', 'futures', 'GET', {})
    futures_get_instrument_id_position = futuresGetInstrumentIdPosition = Entry('{instrument_id}/position', 'futures', 'GET', {})
    futures_get_accounts = futuresGetAccounts = Entry('accounts', 'futures', 'GET', {})
    futures_get_accounts_underlying = futuresGetAccountsUnderlying = Entry('accounts/{underlying}', 'futures', 'GET', {})
    futures_get_accounts_underlying_leverage = futuresGetAccountsUnderlyingLeverage = Entry('accounts/{underlying}/leverage', 'futures', 'GET', {})
    futures_get_accounts_underlying_ledger = futuresGetAccountsUnderlyingLedger = Entry('accounts/{underlying}/ledger', 'futures', 'GET', {})
    futures_get_order_algo_instrument_id = futuresGetOrderAlgoInstrumentId = Entry('order_algo/{instrument_id}', 'futures', 'GET', {})
    futures_get_orders_instrument_id = futuresGetOrdersInstrumentId = Entry('orders/{instrument_id}', 'futures', 'GET', {})
    futures_get_orders_instrument_id_order_id = futuresGetOrdersInstrumentIdOrderId = Entry('orders/{instrument_id}/{order_id}', 'futures', 'GET', {})
    futures_get_orders_instrument_id_client_oid = futuresGetOrdersInstrumentIdClientOid = Entry('orders/{instrument_id}/{client_oid}', 'futures', 'GET', {})
    futures_get_fills = futuresGetFills = Entry('fills', 'futures', 'GET', {})
    futures_get_trade_fee = futuresGetTradeFee = Entry('trade_fee', 'futures', 'GET', {})
    futures_get_accounts_instrument_id_holds = futuresGetAccountsInstrumentIdHolds = Entry('accounts/{instrument_id}/holds', 'futures', 'GET', {})
    futures_get_instruments = futuresGetInstruments = Entry('instruments', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_book = futuresGetInstrumentsInstrumentIdBook = Entry('instruments/{instrument_id}/book', 'futures', 'GET', {})
    futures_get_instruments_ticker = futuresGetInstrumentsTicker = Entry('instruments/ticker', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_ticker = futuresGetInstrumentsInstrumentIdTicker = Entry('instruments/{instrument_id}/ticker', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_trades = futuresGetInstrumentsInstrumentIdTrades = Entry('instruments/{instrument_id}/trades', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_candles = futuresGetInstrumentsInstrumentIdCandles = Entry('instruments/{instrument_id}/candles', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_history_candles = futuresGetInstrumentsInstrumentIdHistoryCandles = Entry('instruments/{instrument_id}/history/candles', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_index = futuresGetInstrumentsInstrumentIdIndex = Entry('instruments/{instrument_id}/index', 'futures', 'GET', {})
    futures_get_rate = futuresGetRate = Entry('rate', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_estimated_price = futuresGetInstrumentsInstrumentIdEstimatedPrice = Entry('instruments/{instrument_id}/estimated_price', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_open_interest = futuresGetInstrumentsInstrumentIdOpenInterest = Entry('instruments/{instrument_id}/open_interest', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_price_limit = futuresGetInstrumentsInstrumentIdPriceLimit = Entry('instruments/{instrument_id}/price_limit', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_mark_price = futuresGetInstrumentsInstrumentIdMarkPrice = Entry('instruments/{instrument_id}/mark_price', 'futures', 'GET', {})
    futures_get_instruments_instrument_id_liquidation = futuresGetInstrumentsInstrumentIdLiquidation = Entry('instruments/{instrument_id}/liquidation', 'futures', 'GET', {})
    futures_post_accounts_underlying_leverage = futuresPostAccountsUnderlyingLeverage = Entry('accounts/{underlying}/leverage', 'futures', 'POST', {})
    futures_post_order = futuresPostOrder = Entry('order', 'futures', 'POST', {})
    futures_post_amend_order_instrument_id = futuresPostAmendOrderInstrumentId = Entry('amend_order/{instrument_id}', 'futures', 'POST', {})
    futures_post_orders = futuresPostOrders = Entry('orders', 'futures', 'POST', {})
    futures_post_cancel_order_instrument_id_order_id = futuresPostCancelOrderInstrumentIdOrderId = Entry('cancel_order/{instrument_id}/{order_id}', 'futures', 'POST', {})
    futures_post_cancel_order_instrument_id_client_oid = futuresPostCancelOrderInstrumentIdClientOid = Entry('cancel_order/{instrument_id}/{client_oid}', 'futures', 'POST', {})
    futures_post_cancel_batch_orders_instrument_id = futuresPostCancelBatchOrdersInstrumentId = Entry('cancel_batch_orders/{instrument_id}', 'futures', 'POST', {})
    futures_post_accounts_margin_mode = futuresPostAccountsMarginMode = Entry('accounts/margin_mode', 'futures', 'POST', {})
    futures_post_close_position = futuresPostClosePosition = Entry('close_position', 'futures', 'POST', {})
    futures_post_cancel_all = futuresPostCancelAll = Entry('cancel_all', 'futures', 'POST', {})
    futures_post_order_algo = futuresPostOrderAlgo = Entry('order_algo', 'futures', 'POST', {})
    futures_post_cancel_algos = futuresPostCancelAlgos = Entry('cancel_algos', 'futures', 'POST', {})
    swap_get_position = swapGetPosition = Entry('position', 'swap', 'GET', {})
    swap_get_instrument_id_position = swapGetInstrumentIdPosition = Entry('{instrument_id}/position', 'swap', 'GET', {})
    swap_get_accounts = swapGetAccounts = Entry('accounts', 'swap', 'GET', {})
    swap_get_instrument_id_accounts = swapGetInstrumentIdAccounts = Entry('{instrument_id}/accounts', 'swap', 'GET', {})
    swap_get_accounts_instrument_id_settings = swapGetAccountsInstrumentIdSettings = Entry('accounts/{instrument_id}/settings', 'swap', 'GET', {})
    swap_get_accounts_instrument_id_ledger = swapGetAccountsInstrumentIdLedger = Entry('accounts/{instrument_id}/ledger', 'swap', 'GET', {})
    swap_get_orders_instrument_id = swapGetOrdersInstrumentId = Entry('orders/{instrument_id}', 'swap', 'GET', {})
    swap_get_orders_instrument_id_order_id = swapGetOrdersInstrumentIdOrderId = Entry('orders/{instrument_id}/{order_id}', 'swap', 'GET', {})
    swap_get_orders_instrument_id_client_oid = swapGetOrdersInstrumentIdClientOid = Entry('orders/{instrument_id}/{client_oid}', 'swap', 'GET', {})
    swap_get_fills = swapGetFills = Entry('fills', 'swap', 'GET', {})
    swap_get_accounts_instrument_id_holds = swapGetAccountsInstrumentIdHolds = Entry('accounts/{instrument_id}/holds', 'swap', 'GET', {})
    swap_get_trade_fee = swapGetTradeFee = Entry('trade_fee', 'swap', 'GET', {})
    swap_get_order_algo_instrument_id = swapGetOrderAlgoInstrumentId = Entry('order_algo/{instrument_id}', 'swap', 'GET', {})
    swap_get_instruments = swapGetInstruments = Entry('instruments', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_depth = swapGetInstrumentsInstrumentIdDepth = Entry('instruments/{instrument_id}/depth', 'swap', 'GET', {})
    swap_get_instruments_ticker = swapGetInstrumentsTicker = Entry('instruments/ticker', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_ticker = swapGetInstrumentsInstrumentIdTicker = Entry('instruments/{instrument_id}/ticker', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_trades = swapGetInstrumentsInstrumentIdTrades = Entry('instruments/{instrument_id}/trades', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_candles = swapGetInstrumentsInstrumentIdCandles = Entry('instruments/{instrument_id}/candles', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_history_candles = swapGetInstrumentsInstrumentIdHistoryCandles = Entry('instruments/{instrument_id}/history/candles', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_index = swapGetInstrumentsInstrumentIdIndex = Entry('instruments/{instrument_id}/index', 'swap', 'GET', {})
    swap_get_rate = swapGetRate = Entry('rate', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_open_interest = swapGetInstrumentsInstrumentIdOpenInterest = Entry('instruments/{instrument_id}/open_interest', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_price_limit = swapGetInstrumentsInstrumentIdPriceLimit = Entry('instruments/{instrument_id}/price_limit', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_liquidation = swapGetInstrumentsInstrumentIdLiquidation = Entry('instruments/{instrument_id}/liquidation', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_funding_time = swapGetInstrumentsInstrumentIdFundingTime = Entry('instruments/{instrument_id}/funding_time', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_mark_price = swapGetInstrumentsInstrumentIdMarkPrice = Entry('instruments/{instrument_id}/mark_price', 'swap', 'GET', {})
    swap_get_instruments_instrument_id_historical_funding_rate = swapGetInstrumentsInstrumentIdHistoricalFundingRate = Entry('instruments/{instrument_id}/historical_funding_rate', 'swap', 'GET', {})
    swap_post_accounts_instrument_id_leverage = swapPostAccountsInstrumentIdLeverage = Entry('accounts/{instrument_id}/leverage', 'swap', 'POST', {})
    swap_post_order = swapPostOrder = Entry('order', 'swap', 'POST', {})
    swap_post_amend_order_instrument_id = swapPostAmendOrderInstrumentId = Entry('amend_order/{instrument_id}', 'swap', 'POST', {})
    swap_post_orders = swapPostOrders = Entry('orders', 'swap', 'POST', {})
    swap_post_cancel_order_instrument_id_order_id = swapPostCancelOrderInstrumentIdOrderId = Entry('cancel_order/{instrument_id}/{order_id}', 'swap', 'POST', {})
    swap_post_cancel_order_instrument_id_client_oid = swapPostCancelOrderInstrumentIdClientOid = Entry('cancel_order/{instrument_id}/{client_oid}', 'swap', 'POST', {})
    swap_post_cancel_batch_orders_instrument_id = swapPostCancelBatchOrdersInstrumentId = Entry('cancel_batch_orders/{instrument_id}', 'swap', 'POST', {})
    swap_post_order_algo = swapPostOrderAlgo = Entry('order_algo', 'swap', 'POST', {})
    swap_post_cancel_algos = swapPostCancelAlgos = Entry('cancel_algos', 'swap', 'POST', {})
    swap_post_close_position = swapPostClosePosition = Entry('close_position', 'swap', 'POST', {})
    swap_post_cancel_all = swapPostCancelAll = Entry('cancel_all', 'swap', 'POST', {})
    option_get_accounts = optionGetAccounts = Entry('accounts', 'option', 'GET', {})
    option_get_position = optionGetPosition = Entry('position', 'option', 'GET', {})
    option_get_underlying_position = optionGetUnderlyingPosition = Entry('{underlying}/position', 'option', 'GET', {})
    option_get_accounts_underlying = optionGetAccountsUnderlying = Entry('accounts/{underlying}', 'option', 'GET', {})
    option_get_orders_underlying = optionGetOrdersUnderlying = Entry('orders/{underlying}', 'option', 'GET', {})
    option_get_fills_underlying = optionGetFillsUnderlying = Entry('fills/{underlying}', 'option', 'GET', {})
    option_get_accounts_underlying_ledger = optionGetAccountsUnderlyingLedger = Entry('accounts/{underlying}/ledger', 'option', 'GET', {})
    option_get_trade_fee = optionGetTradeFee = Entry('trade_fee', 'option', 'GET', {})
    option_get_orders_underlying_order_id = optionGetOrdersUnderlyingOrderId = Entry('orders/{underlying}/{order_id}', 'option', 'GET', {})
    option_get_orders_underlying_client_oid = optionGetOrdersUnderlyingClientOid = Entry('orders/{underlying}/{client_oid}', 'option', 'GET', {})
    option_get_underlying = optionGetUnderlying = Entry('underlying', 'option', 'GET', {})
    option_get_instruments_underlying = optionGetInstrumentsUnderlying = Entry('instruments/{underlying}', 'option', 'GET', {})
    option_get_instruments_underlying_summary = optionGetInstrumentsUnderlyingSummary = Entry('instruments/{underlying}/summary', 'option', 'GET', {})
    option_get_instruments_underlying_summary_instrument_id = optionGetInstrumentsUnderlyingSummaryInstrumentId = Entry('instruments/{underlying}/summary/{instrument_id}', 'option', 'GET', {})
    option_get_instruments_instrument_id_book = optionGetInstrumentsInstrumentIdBook = Entry('instruments/{instrument_id}/book', 'option', 'GET', {})
    option_get_instruments_instrument_id_trades = optionGetInstrumentsInstrumentIdTrades = Entry('instruments/{instrument_id}/trades', 'option', 'GET', {})
    option_get_instruments_instrument_id_ticker = optionGetInstrumentsInstrumentIdTicker = Entry('instruments/{instrument_id}/ticker', 'option', 'GET', {})
    option_get_instruments_instrument_id_candles = optionGetInstrumentsInstrumentIdCandles = Entry('instruments/{instrument_id}/candles', 'option', 'GET', {})
    option_post_order = optionPostOrder = Entry('order', 'option', 'POST', {})
    option_post_orders = optionPostOrders = Entry('orders', 'option', 'POST', {})
    option_post_cancel_order_underlying_order_id = optionPostCancelOrderUnderlyingOrderId = Entry('cancel_order/{underlying}/{order_id}', 'option', 'POST', {})
    option_post_cancel_order_underlying_client_oid = optionPostCancelOrderUnderlyingClientOid = Entry('cancel_order/{underlying}/{client_oid}', 'option', 'POST', {})
    option_post_cancel_batch_orders_underlying = optionPostCancelBatchOrdersUnderlying = Entry('cancel_batch_orders/{underlying}', 'option', 'POST', {})
    option_post_amend_order_underlying = optionPostAmendOrderUnderlying = Entry('amend_order/{underlying}', 'option', 'POST', {})
    option_post_amend_batch_orders_underlying = optionPostAmendBatchOrdersUnderlying = Entry('amend_batch_orders/{underlying}', 'option', 'POST', {})
    information_get_currency_long_short_ratio = informationGetCurrencyLongShortRatio = Entry('{currency}/long_short_ratio', 'information', 'GET', {})
    information_get_currency_volume = informationGetCurrencyVolume = Entry('{currency}/volume', 'information', 'GET', {})
    information_get_currency_taker = informationGetCurrencyTaker = Entry('{currency}/taker', 'information', 'GET', {})
    information_get_currency_sentiment = informationGetCurrencySentiment = Entry('{currency}/sentiment', 'information', 'GET', {})
    information_get_currency_margin = informationGetCurrencyMargin = Entry('{currency}/margin', 'information', 'GET', {})
    index_get_instrument_id_constituents = indexGetInstrumentIdConstituents = Entry('{instrument_id}/constituents', 'index', 'GET', {})
