"""
Automatically generated by "compile_syntax.py"
"""

OPCODES = {
	"script"					: {
		"name"		: 'script',
		"ver"		: 'linuxsampler',
		"category"	: 'Real-Time Instrument Script',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"count"						: {
		"name"		: 'count',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 4294967296)',
			"type"	: 'integer'
		}
	},
	"delay"						: {
		"name"		: 'delay',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"delay_ccN"					: {
		"name"		: 'delay_ccN',
		"ver"		: 'unknown',
		"category"	: 'Sample Playback',
		"modulates"	: 'delay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"delay_onccN"				: {
		"name"	: 'delay_onccN',
		"value"	: {'valid': "Alias('delay_ccN')"},
		"ver"	: 'v2'
	},
	"delay_curveccN"			: {
		"name"		: 'delay_curveccN',
		"ver"		: 'aria',
		"category"	: 'Sample Playback',
		"modulates"	: 'delay',
		"mod_type"	: 'midi_cc'
	},
	"delay_random"				: {
		"name"		: 'delay_random',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"delay_samples"				: {
		"name"		: 'delay_samples',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"delay_samples_onccN"		: {
		"name"		: 'delay_samples_onccN',
		"ver"		: 'unknown',
		"category"	: 'Sample Playback',
		"modulates"	: 'delay_samples',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"end"						: {
		"name"		: 'end',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 4294967296)',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"loop_count"				: {
		"name"		: 'loop_count',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"loopcount"					: {
		"name"	: 'loopcount',
		"value"	: {'valid': "Alias('loop_count')"},
		"ver"	: 'aria'
	},
	"loop_crossfade"			: {
		"name"		: 'loop_crossfade',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"loop_end"					: {
		"name"		: 'loop_end',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 4294967296)',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"loopend"					: {
		"name"	: 'loopend',
		"value"	: {'valid': "Alias('loop_end')"},
		"ver"	: 'v1'
	},
	"loop_lengthccN"			: {
		"name"		: 'loop_lengthccN',
		"ver"		: 'cakewalk',
		"category"	: 'Sample Playback',
		"modulates"	: 'loop_end',
		"mod_type"	: 'midi_cc'
	},
	"loop_length_onccN"			: {
		"name"	: 'loop_length_onccN',
		"value"	: {'valid': "Alias('loop_lengthccN')"},
		"ver"	: 'cakewalk'
	},
	"loop_mode"					: {
		"name"		: 'loop_mode',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['no_loop', 'one_shot', 'loop_continuous', 'loop_sustain'])",
			"type"	: 'string'
		}
	},
	"loopmode"					: {
		"name"	: 'loopmode',
		"value"	: {'valid': "Alias('loop_mode')"},
		"ver"	: 'v1'
	},
	"loop_start"				: {
		"name"		: 'loop_start',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 4294967296)',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"loopstart"					: {
		"name"	: 'loopstart',
		"value"	: {'valid': "Alias('loop_start')"},
		"ver"	: 'v1'
	},
	"loop_startccN"				: {
		"name"		: 'loop_startccN',
		"ver"		: 'cakewalk',
		"category"	: 'Sample Playback',
		"modulates"	: 'loop_start',
		"mod_type"	: 'midi_cc'
	},
	"loop_start_onccN"			: {
		"name"	: 'loop_start_onccN',
		"value"	: {'valid': "Alias('loop_startccN')"},
		"ver"	: 'cakewalk'
	},
	"loop_tune"					: {
		"name"		: 'loop_tune',
		"ver"		: 'cakewalk',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"looptune"					: {
		"name"	: 'looptune',
		"value"	: {'valid': "Alias('loop_tune')"},
		"ver"	: 'aria'
	},
	"loop_type"					: {
		"name"		: 'loop_type',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['forward', 'backward', 'alternate'])",
			"type"	: 'string'
		}
	},
	"looptype"					: {
		"name"	: 'looptype',
		"value"	: {'valid': "Alias('loop_type')"},
		"ver"	: 'aria'
	},
	"offset"					: {
		"name"		: 'offset',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 4294967296)',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"offset_ccN"				: {
		"name"		: 'offset_ccN',
		"ver"		: 'unknown',
		"category"	: 'Sample Playback',
		"modulates"	: 'offset',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 4294967296)',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"offset_onccN"				: {
		"name"	: 'offset_onccN',
		"value"	: {'valid': "Alias('offset_ccN')"},
		"ver"	: 'v2'
	},
	"offset_random"				: {
		"name"		: 'offset_random',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 4294967296)',
			"type"	: 'integer',
			"unit"	: 'sample units'
		}
	},
	"sample"					: {
		"name"		: 'sample',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"sample_fadeout"			: {
		"name"		: 'sample_fadeout',
		"ver"		: 'cakewalk',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"sync_beats"				: {
		"name"		: 'sync_beats',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 32)',
			"type"	: 'float',
			"unit"	: 'beats'
		}
	},
	"sync_offset"				: {
		"name"		: 'sync_offset',
		"ver"		: 'v1',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 32)',
			"type"	: 'float',
			"unit"	: 'beats'
		}
	},
	"delay_beats"				: {
		"name"		: 'delay_beats',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'beats'
		}
	},
	"delay_beats_onccN"			: {
		"name"		: 'delay_beats_onccN',
		"ver"		: 'aria',
		"category"	: 'Sample Playback',
		"modulates"	: 'delay_beats',
		"mod_type"	: 'midi_cc'
	},
	"delay_beats_curveccN"		: {
		"name"		: 'delay_beats_curveccN',
		"ver"		: 'aria',
		"category"	: 'Sample Playback',
		"modulates"	: 'delay_beats',
		"mod_type"	: 'midi_cc'
	},
	"delay_beats_random"		: {
		"name"		: 'delay_beats_random',
		"ver"		: 'aria',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'beats'
		}
	},
	"stop_beats"				: {
		"name"		: 'stop_beats',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'beats'
		}
	},
	"direction"					: {
		"name"		: 'direction',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['forward', 'reverse'])",
			"type"	: 'string'
		}
	},
	"md5"						: {
		"name"		: 'md5',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"reverse_loccN"				: {
		"name"		: 'reverse_loccN',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"reverse_hiccN"				: {
		"name"		: 'reverse_hiccN',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"waveguide"					: {
		"name"		: 'waveguide',
		"ver"		: 'v2',
		"category"	: 'Sample Playback',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"#define"					: {
		"name"		: '#define',
		"ver"		: 'v2',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"default_path"				: {
		"name"		: 'default_path',
		"ver"		: 'v2',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"note_offset"				: {
		"name"		: 'note_offset',
		"ver"		: 'v2',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"octave_offset"				: {
		"name"		: 'octave_offset',
		"ver"		: 'v2',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"label_ccN"					: {
		"name"		: 'label_ccN',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"label_keyN"				: {
		"name"		: 'label_keyN',
		"ver"		: 'sfizz',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"set_ccN"					: {
		"name"		: 'set_ccN',
		"ver"		: 'v2',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"#include"					: {
		"name"		: '#include',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"hint_*"					: {
		"name"		: 'hint_*',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None
	},
	"*_mod"						: {
		"name"		: '*_mod',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['add', 'mult'])",
			"type"	: 'string'
		}
	},
	"set_hdccN"					: {
		"name"		: 'set_hdccN',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"set_realccN"				: {
		"name"	: 'set_realccN',
		"value"	: {'valid': "Alias('set_hdccN')"},
		"ver"	: 'aria'
	},
	"sw_note_offset"			: {
		"name"		: 'sw_note_offset',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"sw_octave_offset"			: {
		"name"		: 'sw_octave_offset',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"global_label"				: {
		"name"		: 'global_label',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"master_label"				: {
		"name"		: 'master_label',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"group_label"				: {
		"name"		: 'group_label',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"region_label"				: {
		"name"		: 'region_label',
		"ver"		: 'aria',
		"category"	: 'Instrument Settings',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"group"						: {
		"name"		: 'group',
		"ver"		: 'v1',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-2147483648, 2147483647)',
			"type"	: 'integer'
		}
	},
	"polyphony_group"			: {
		"name"	: 'polyphony_group',
		"value"	: {'valid': "Alias('group')"},
		"ver"	: 'aria'
	},
	"off_by"					: {
		"name"		: 'off_by',
		"ver"		: 'v1',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-2147483648, 2147483647)',
			"type"	: 'integer'
		}
	},
	"offby"						: {
		"name"	: 'offby',
		"value"	: {'valid': "Alias('off_by')"},
		"ver"	: 'v1'
	},
	"off_mode"					: {
		"name"		: 'off_mode',
		"ver"		: 'v1',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['fast', 'normal', 'time'])",
			"type"	: 'string'
		}
	},
	"output"					: {
		"name"		: 'output',
		"ver"		: 'v1',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1024)',
			"type"	: 'integer'
		}
	},
	"polyphony"					: {
		"name"		: 'polyphony',
		"ver"		: 'v2',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"note_polyphony"			: {
		"name"		: 'note_polyphony',
		"ver"		: 'v2',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"polyphony_stealing"		: {
		"name"		: 'polyphony_stealing',
		"ver"		: 'aria',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"note_selfmask"				: {
		"name"		: 'note_selfmask',
		"ver"		: 'v2',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"rt_dead"					: {
		"name"		: 'rt_dead',
		"ver"		: 'v2',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"off_curve"					: {
		"name"		: 'off_curve',
		"ver"		: 'aria',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-2, 10)',
			"type"	: 'integer'
		}
	},
	"off_shape"					: {
		"name"		: 'off_shape',
		"ver"		: 'aria',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"off_time"					: {
		"name"		: 'off_time',
		"ver"		: 'aria',
		"category"	: 'Voice Lifecycle',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"key"						: {
		"name"		: 'key',
		"ver"		: 'v1',
		"category"	: 'Key Mapping',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"lokey"						: {
		"name"		: 'lokey',
		"ver"		: 'v1',
		"category"	: 'Key Mapping',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"hikey"						: {
		"name"		: 'hikey',
		"ver"		: 'v1',
		"category"	: 'Key Mapping',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"lovel"						: {
		"name"		: 'lovel',
		"ver"		: 'v1',
		"category"	: 'Key Mapping',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 127)',
			"type"	: 'integer'
		}
	},
	"hivel"						: {
		"name"		: 'hivel',
		"ver"		: 'v1',
		"category"	: 'Key Mapping',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 127)',
			"type"	: 'integer'
		}
	},
	"lochan"					: {
		"name"		: 'lochan',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 16)',
			"type"	: 'integer'
		}
	},
	"hichan"					: {
		"name"		: 'hichan',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 16)',
			"type"	: 'integer'
		}
	},
	"loccN"						: {
		"name"		: 'loccN',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"hiccN"						: {
		"name"		: 'hiccN',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"lobend"					: {
		"name"		: 'lobend',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-8192, 8192)',
			"type"	: 'integer'
		}
	},
	"hibend"					: {
		"name"		: 'hibend',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-8192, 8192)',
			"type"	: 'integer'
		}
	},
	"sostenuto_cc"				: {
		"name"		: 'sostenuto_cc',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'float'
		}
	},
	"sostenuto_lo"				: {
		"name"		: 'sostenuto_lo',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'float'
		}
	},
	"sostenuto_sw"				: {
		"name"		: 'sostenuto_sw',
		"ver"		: 'v2',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"sustain_cc"				: {
		"name"		: 'sustain_cc',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'float'
		}
	},
	"sustain_lo"				: {
		"name"		: 'sustain_lo',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'float'
		}
	},
	"sustain_sw"				: {
		"name"		: 'sustain_sw',
		"ver"		: 'v2',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"sw_lokey"					: {
		"name"		: 'sw_lokey',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_hikey"					: {
		"name"		: 'sw_hikey',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_last"					: {
		"name"		: 'sw_last',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_down"					: {
		"name"		: 'sw_down',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_up"						: {
		"name"		: 'sw_up',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_previous"				: {
		"name"		: 'sw_previous',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_vel"					: {
		"name"		: 'sw_vel',
		"ver"		: 'v1',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['current', 'previous'])",
			"type"	: 'string'
		}
	},
	"loprog"					: {
		"name"		: 'loprog',
		"ver"		: 'v2',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"hiprog"					: {
		"name"		: 'hiprog',
		"ver"		: 'v2',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"lohdccN"					: {
		"name"		: 'lohdccN',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"hihdccN"					: {
		"name"		: 'hihdccN',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"sw_default"				: {
		"name"		: 'sw_default',
		"ver"		: 'v2',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_label"					: {
		"name"		: 'sw_label',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"sw_lolast"					: {
		"name"		: 'sw_lolast',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"sw_hilast"					: {
		"name"		: 'sw_hilast',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"varNN_mod"					: {
		"name"		: 'varNN_mod',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['mult', 'add'])",
			"type"	: 'string'
		}
	},
	"varNN_onccX"				: {
		"name"		: 'varNN_onccX',
		"ver"		: 'unknown',
		"category"	: 'MIDI Conditions',
		"modulates"	: 'varNN_mod',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"varNN_curveccX"			: {
		"name"		: 'varNN_curveccX',
		"ver"		: 'unknown',
		"category"	: 'MIDI Conditions',
		"modulates"	: 'varNN_mod',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"varNN_*"					: {
		"name"		: 'varNN_*',
		"ver"		: 'aria',
		"category"	: 'MIDI Conditions',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lobpm"						: {
		"name"		: 'lobpm',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 500)',
			"type"	: 'float',
			"unit"	: 'bpm'
		}
	},
	"hibpm"						: {
		"name"		: 'hibpm',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 500)',
			"type"	: 'float',
			"unit"	: 'bpm'
		}
	},
	"lochanaft"					: {
		"name"		: 'lochanaft',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"hichanaft"					: {
		"name"		: 'hichanaft',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"lopolyaft"					: {
		"name"		: 'lopolyaft',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"hipolyaft"					: {
		"name"		: 'hipolyaft',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"lorand"					: {
		"name"		: 'lorand',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"hirand"					: {
		"name"		: 'hirand',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"seq_length"				: {
		"name"		: 'seq_length',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 100)',
			"type"	: 'integer'
		}
	},
	"seq_position"				: {
		"name"		: 'seq_position',
		"ver"		: 'v1',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 100)',
			"type"	: 'integer'
		}
	},
	"lotimer"					: {
		"name"		: 'lotimer',
		"ver"		: 'v2',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"hitimer"					: {
		"name"		: 'hitimer',
		"ver"		: 'v2',
		"category"	: 'Internal Conditions',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"trigger"					: {
		"name"		: 'trigger',
		"ver"		: 'v1',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['attack', 'release', 'first', 'legato', 'release_key'])",
			"type"	: 'string'
		}
	},
	"on_loccN"					: {
		"name"		: 'on_loccN',
		"ver"		: 'v1',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"start_loccN"				: {
		"name"	: 'start_loccN',
		"value"	: {'valid': "Alias('on_loccN')"},
		"ver"	: 'v2'
	},
	"on_hiccN"					: {
		"name"		: 'on_hiccN',
		"ver"		: 'v1',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"start_hiccN"				: {
		"name"	: 'start_hiccN',
		"value"	: {'valid': "Alias('on_hiccN')"},
		"ver"	: 'v2'
	},
	"on_lohdccN"				: {
		"name"		: 'on_lohdccN',
		"ver"		: 'aria',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"start_lohdccN"				: {
		"name"	: 'start_lohdccN',
		"value"	: {'valid': "Alias('on_lohdccN')"},
		"ver"	: 'aria'
	},
	"on_hihdccN"				: {
		"name"		: 'on_hihdccN',
		"ver"		: 'aria',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"start_hihdccN"				: {
		"name"	: 'start_hihdccN',
		"value"	: {'valid': "Alias('on_hihdccN')"},
		"ver"	: 'aria'
	},
	"stop_loccN"				: {
		"name"		: 'stop_loccN',
		"ver"		: 'v2',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"stop_hiccN"				: {
		"name"		: 'stop_hiccN',
		"ver"		: 'v2',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"stop_lohdccN"				: {
		"name"		: 'stop_lohdccN',
		"ver"		: 'aria',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"stop_hihdccN"				: {
		"name"		: 'stop_hihdccN',
		"ver"		: 'aria',
		"category"	: 'Triggers',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"pan"						: {
		"name"		: 'pan',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"pan_onccN"					: {
		"name"		: 'pan_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'pan',
		"mod_type"	: 'midi_cc'
	},
	"pan_ccN"					: {
		"name"	: 'pan_ccN',
		"value"	: {'valid': "Alias('pan_onccN')"},
		"ver"	: 'aria'
	},
	"pan_curveccN"				: {
		"name"		: 'pan_curveccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'pan',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"pan_smoothccN"				: {
		"name"		: 'pan_smoothccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'pan',
		"mod_type"	: 'midi_cc'
	},
	"pan_stepccN"				: {
		"name"		: 'pan_stepccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'pan',
		"mod_type"	: 'midi_cc'
	},
	"pan_random"				: {
		"name"		: 'pan_random',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"position"					: {
		"name"		: 'position',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"position_onccN"			: {
		"name"		: 'position_onccN',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: 'position',
		"mod_type"	: 'midi_cc'
	},
	"position_curveccN"			: {
		"name"		: 'position_curveccN',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: 'position',
		"mod_type"	: 'midi_cc'
	},
	"position_smoothccN"		: {
		"name"		: 'position_smoothccN',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: 'position',
		"mod_type"	: 'midi_cc'
	},
	"position_stepccN"			: {
		"name"		: 'position_stepccN',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: 'position',
		"mod_type"	: 'midi_cc'
	},
	"position_random"			: {
		"name"		: 'position_random',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"position_keycenter"		: {
		"name"		: 'position_keycenter',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None
	},
	"position_keytrack"			: {
		"name"		: 'position_keytrack',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None
	},
	"position_veltrack"			: {
		"name"		: 'position_veltrack',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None
	},
	"volume"					: {
		"name"		: 'volume',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-144, 6)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"gain_ccN"					: {
		"name"		: 'gain_ccN',
		"ver"		: 'unknown',
		"category"	: 'Amplifier',
		"modulates"	: 'volume',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-144, 48)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"gain_onccN"				: {
		"name"	: 'gain_onccN',
		"value"	: {'valid': "Alias('gain_ccN')"},
		"ver"	: 'v2'
	},
	"volume_onccN"				: {
		"name"	: 'volume_onccN',
		"value"	: {'valid': "Alias('gain_ccN')"},
		"ver"	: 'v2'
	},
	"volume_curveccN"			: {
		"name"		: 'volume_curveccN',
		"ver"		: 'v2',
		"category"	: 'Amplifier',
		"modulates"	: 'volume',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"volume_smoothccN"			: {
		"name"		: 'volume_smoothccN',
		"ver"		: 'v2',
		"category"	: 'Amplifier',
		"modulates"	: 'volume',
		"mod_type"	: 'midi_cc'
	},
	"volume_stepccN"			: {
		"name"		: 'volume_stepccN',
		"ver"		: 'v2',
		"category"	: 'Amplifier',
		"modulates"	: 'volume',
		"mod_type"	: 'midi_cc'
	},
	"width"						: {
		"name"		: 'width',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"width_onccN"				: {
		"name"		: 'width_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'width',
		"mod_type"	: 'midi_cc'
	},
	"width_curveccN"			: {
		"name"		: 'width_curveccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'width',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"width_smoothccN"			: {
		"name"		: 'width_smoothccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'width',
		"mod_type"	: 'midi_cc'
	},
	"width_stepccN"				: {
		"name"		: 'width_stepccN',
		"ver"		: 'cakewalk',
		"category"	: 'Amplifier',
		"modulates"	: 'width',
		"mod_type"	: 'midi_cc'
	},
	"amp_keycenter"				: {
		"name"		: 'amp_keycenter',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"amp_keytrack"				: {
		"name"		: 'amp_keytrack',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-96, 12)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"amp_veltrack"				: {
		"name"		: 'amp_veltrack',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"amp_veltrack_onccN"		: {
		"name"		: 'amp_veltrack_onccN',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: 'amp_veltrack',
		"mod_type"	: 'midi_cc'
	},
	"amp_veltrack_ccN"			: {
		"name"	: 'amp_veltrack_ccN',
		"value"	: {'valid': "Alias('amp_veltrack_onccN')"},
		"ver"	: 'aria'
	},
	"amp_veltrack_curveccN"		: {
		"name"		: 'amp_veltrack_curveccN',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: 'amp_veltrack',
		"mod_type"	: 'midi_cc'
	},
	"amp_veltrack_random"		: {
		"name"		: 'amp_veltrack_random',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None
	},
	"amp_velcurve_N"			: {
		"name"		: 'amp_velcurve_N',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		},
		"index"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"amp_random"				: {
		"name"		: 'amp_random',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 24)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"gain_random"				: {
		"name"	: 'gain_random',
		"value"	: {'valid': "Alias('amp_random')"},
		"ver"	: 'cakewalk'
	},
	"rt_decay"					: {
		"name"		: 'rt_decay',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 200)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"xf_cccurve"				: {
		"name"		: 'xf_cccurve',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['gain', 'power'])",
			"type"	: 'string'
		}
	},
	"xf_keycurve"				: {
		"name"		: 'xf_keycurve',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['gain', 'power'])",
			"type"	: 'string'
		}
	},
	"xf_velcurve"				: {
		"name"		: 'xf_velcurve',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['gain', 'power'])",
			"type"	: 'string'
		}
	},
	"xfin_loccN"				: {
		"name"		: 'xfin_loccN',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfin_hiccN"				: {
		"name"		: 'xfin_hiccN',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfout_loccN"				: {
		"name"		: 'xfout_loccN',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfout_hiccN"				: {
		"name"		: 'xfout_hiccN',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfin_lokey"				: {
		"name"		: 'xfin_lokey',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfin_hikey"				: {
		"name"		: 'xfin_hikey',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfout_lokey"				: {
		"name"		: 'xfout_lokey',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfout_hikey"				: {
		"name"		: 'xfout_hikey',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfin_lovel"				: {
		"name"		: 'xfin_lovel',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfin_hivel"				: {
		"name"		: 'xfin_hivel',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfout_lovel"				: {
		"name"		: 'xfout_lovel',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"xfout_hivel"				: {
		"name"		: 'xfout_hivel',
		"ver"		: 'v1',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"phase"						: {
		"name"		: 'phase',
		"ver"		: 'v2',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['normal', 'invert'])",
			"type"	: 'string'
		}
	},
	"amplitude"					: {
		"name"		: 'amplitude',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"amplitude_onccN"			: {
		"name"		: 'amplitude_onccN',
		"ver"		: 'unknown',
		"category"	: 'Amplifier',
		"modulates"	: 'amplitude',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"amplitude_ccN"				: {
		"name"	: 'amplitude_ccN',
		"value"	: {'valid': "Alias('amplitude_onccN')"},
		"ver"	: 'unknown'
	},
	"amplitude_curveccN"		: {
		"name"		: 'amplitude_curveccN',
		"ver"		: 'unknown',
		"category"	: 'Amplifier',
		"modulates"	: 'amplitude',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"amplitude_smoothccN"		: {
		"name"		: 'amplitude_smoothccN',
		"ver"		: 'unknown',
		"category"	: 'Amplifier',
		"modulates"	: 'amplitude',
		"mod_type"	: 'midi_cc'
	},
	"global_amplitude"			: {
		"name"		: 'global_amplitude',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"master_amplitude"			: {
		"name"		: 'master_amplitude',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"group_amplitude"			: {
		"name"		: 'group_amplitude',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"pan_law"					: {
		"name"		: 'pan_law',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['mma', 'balance'])",
			"type"	: 'string'
		}
	},
	"pan_keycenter"				: {
		"name"		: 'pan_keycenter',
		"ver"		: 'v2',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"pan_keytrack"				: {
		"name"		: 'pan_keytrack',
		"ver"		: 'v2',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"pan_veltrack"				: {
		"name"		: 'pan_veltrack',
		"ver"		: 'v2',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"global_volume"				: {
		"name"		: 'global_volume',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-144, 6)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"master_volume"				: {
		"name"		: 'master_volume',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-144, 6)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"group_volume"				: {
		"name"		: 'group_volume',
		"ver"		: 'aria',
		"category"	: 'Amplifier',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-144, 6)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"eqN_bw"					: {
		"name"		: 'eqN_bw',
		"ver"		: 'v1',
		"category"	: 'EQ',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0.001, 4)',
			"type"	: 'float',
			"unit"	: 'octaves'
		}
	},
	"eqN_bwccX"					: {
		"name"		: 'eqN_bwccX',
		"ver"		: 'unknown',
		"category"	: 'EQ',
		"modulates"	: 'eqN_bw',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-4, 4)',
			"type"	: 'float',
			"unit"	: 'octaves'
		}
	},
	"eqN_bw_onccX"				: {
		"name"	: 'eqN_bw_onccX',
		"value"	: {'valid': "Alias('eqN_bwccX')"},
		"ver"	: 'v2'
	},
	"eqN_freq"					: {
		"name"		: 'eqN_freq',
		"ver"		: 'v1',
		"category"	: 'EQ',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 30000)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"eqN_freqccX"				: {
		"name"		: 'eqN_freqccX',
		"ver"		: 'unknown',
		"category"	: 'EQ',
		"modulates"	: 'eqN_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-30000, 30000)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"eqN_freq_onccX"			: {
		"name"	: 'eqN_freq_onccX',
		"value"	: {'valid': "Alias('eqN_freqccX')"},
		"ver"	: 'v2'
	},
	"eqN_vel2freq"				: {
		"name"		: 'eqN_vel2freq',
		"ver"		: 'unknown',
		"category"	: 'EQ',
		"modulates"	: 'eqN_freq',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-30000, 30000)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"eqN_gain"					: {
		"name"		: 'eqN_gain',
		"ver"		: 'v1',
		"category"	: 'EQ',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-96, 24)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"eqN_gainccX"				: {
		"name"		: 'eqN_gainccX',
		"ver"		: 'unknown',
		"category"	: 'EQ',
		"modulates"	: 'eqN_gain',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-96, 24)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"eqN_gain_onccX"			: {
		"name"	: 'eqN_gain_onccX',
		"value"	: {'valid': "Alias('eqN_gainccX')"},
		"ver"	: 'v2'
	},
	"eqN_vel2gain"				: {
		"name"		: 'eqN_vel2gain',
		"ver"		: 'unknown',
		"category"	: 'EQ',
		"modulates"	: 'eqN_gain',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-96, 24)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"eqN_dynamic"				: {
		"name"		: 'eqN_dynamic',
		"ver"		: 'aria',
		"category"	: 'EQ',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"eqN_type"					: {
		"name"		: 'eqN_type',
		"ver"		: 'v2',
		"category"	: 'EQ',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['peak', 'lshelf', 'hshelf'])",
			"type"	: 'string'
		}
	},
	"cutoff"					: {
		"name"		: 'cutoff',
		"ver"		: 'v1',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"cutoff2"					: {
		"name"	: 'cutoff2',
		"value"	: {'valid': "Alias('cutoff')"},
		"ver"	: 'v2'
	},
	"cutoff2_ccN"				: {
		"name"		: 'cutoff2_ccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"cutoff2_onccN"				: {
		"name"		: 'cutoff2_onccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"cutoff2_curveccN"			: {
		"name"		: 'cutoff2_curveccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"cutoff2_smoothccN"			: {
		"name"		: 'cutoff2_smoothccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"cutoff2_stepccN"			: {
		"name"		: 'cutoff2_stepccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"cutoff2_chanaft"			: {
		"name"		: 'cutoff2_chanaft',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"cutoff2_polyaft"			: {
		"name"		: 'cutoff2_polyaft',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"cutoff_ccN"				: {
		"name"		: 'cutoff_ccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"cutoff_onccN"				: {
		"name"	: 'cutoff_onccN',
		"value"	: {'valid': "Alias('cutoff_ccN')"},
		"ver"	: 'v2'
	},
	"cutoff_curveccN"			: {
		"name"		: 'cutoff_curveccN',
		"ver"		: 'v2',
		"category"	: 'Filter',
		"modulates"	: 'cutoff',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"cutoff_smoothccN"			: {
		"name"		: 'cutoff_smoothccN',
		"ver"		: 'v2',
		"category"	: 'Filter',
		"modulates"	: 'cutoff',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'float',
			"unit"	: 'ms'
		}
	},
	"cutoff_stepccN"			: {
		"name"		: 'cutoff_stepccN',
		"ver"		: 'v2',
		"category"	: 'Filter',
		"modulates"	: 'cutoff',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'integer'
		}
	},
	"cutoff_chanaft"			: {
		"name"		: 'cutoff_chanaft',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"cutoff_polyaft"			: {
		"name"		: 'cutoff_polyaft',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'cutoff',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"fil_gain"					: {
		"name"		: 'fil_gain',
		"ver"		: 'aria',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"fil2_gain"					: {
		"name"	: 'fil2_gain',
		"value"	: {'valid': "Alias('fil_gain')"},
		"ver"	: 'aria'
	},
	"fil2_gain_onccN"			: {
		"name"		: 'fil2_gain_onccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'fil2_gain',
		"mod_type"	: 'midi_cc'
	},
	"fil_gain_onccN"			: {
		"name"		: 'fil_gain_onccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'fil_gain',
		"mod_type"	: 'midi_cc'
	},
	"fil_keycenter"				: {
		"name"		: 'fil_keycenter',
		"ver"		: 'v1',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"fil2_keycenter"			: {
		"name"	: 'fil2_keycenter',
		"value"	: {'valid': "Alias('fil_keycenter')"},
		"ver"	: 'v2'
	},
	"fil_keytrack"				: {
		"name"		: 'fil_keytrack',
		"ver"		: 'v1',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1200)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"fil2_keytrack"				: {
		"name"	: 'fil2_keytrack',
		"value"	: {'valid': "Alias('fil_keytrack')"},
		"ver"	: 'v2'
	},
	"fil_random"				: {
		"name"		: 'fil_random',
		"ver"		: 'v1',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"cutoff_random"				: {
		"name"	: 'cutoff_random',
		"value"	: {'valid': "Alias('fil_random')"},
		"ver"	: 'v2'
	},
	"cutoff2_random"			: {
		"name"	: 'cutoff2_random',
		"value"	: {'valid': "Alias('fil_random')"},
		"ver"	: 'aria'
	},
	"fil_type"					: {
		"name"		: 'fil_type',
		"ver"		: 'v1',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['lpf_1p', 'hpf_1p', 'lpf_2p', 'hpf_2p', 'bpf_2p', 'brf_2p', 'bpf_1p', 'brf_1p', 'apf_1p', 'lpf_2p_sv', 'hpf_2p_sv', 'bpf_2p_sv', 'brf_2p_sv', 'pkf_2p', 'lpf_4p', 'hpf_4p', 'lpf_6p', 'hpf_6p', 'comb', 'pink', 'lsh', 'hsh', 'peq'])",
			"type"	: 'string'
		}
	},
	"filtype"					: {
		"name"	: 'filtype',
		"value"	: {'valid': "Alias('fil_type')"},
		"ver"	: 'v1'
	},
	"fil2_type"					: {
		"name"	: 'fil2_type',
		"value"	: {'valid': "Alias('fil_type')"},
		"ver"	: 'v2'
	},
	"fil_veltrack"				: {
		"name"		: 'fil_veltrack',
		"ver"		: 'v1',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"fil2_veltrack"				: {
		"name"	: 'fil2_veltrack',
		"value"	: {'valid': "Alias('fil_veltrack')"},
		"ver"	: 'v2'
	},
	"resonance"					: {
		"name"		: 'resonance',
		"ver"		: 'v1',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 40)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"resonance2"				: {
		"name"	: 'resonance2',
		"value"	: {'valid': "Alias('resonance')"},
		"ver"	: 'v2'
	},
	"resonance2_onccN"			: {
		"name"		: 'resonance2_onccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'resonance2',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 40)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"resonance2_ccN"			: {
		"name"	: 'resonance2_ccN',
		"value"	: {'valid': "Alias('resonance2_onccN')"},
		"ver"	: 'v2'
	},
	"resonance2_curveccN"		: {
		"name"		: 'resonance2_curveccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'resonance2',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"resonance2_smoothccN"		: {
		"name"		: 'resonance2_smoothccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'resonance2',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'float',
			"unit"	: 'ms'
		}
	},
	"resonance2_stepccN"		: {
		"name"		: 'resonance2_stepccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'resonance2',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'integer'
		}
	},
	"resonance_onccN"			: {
		"name"		: 'resonance_onccN',
		"ver"		: 'v2',
		"category"	: 'Filter',
		"modulates"	: 'resonance',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 40)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"resonance_ccN"				: {
		"name"	: 'resonance_ccN',
		"value"	: {'valid': "Alias('resonance_onccN')"},
		"ver"	: 'v2'
	},
	"resonance_curveccN"		: {
		"name"		: 'resonance_curveccN',
		"ver"		: 'v2',
		"category"	: 'Filter',
		"modulates"	: 'resonance',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"resonance_smoothccN"		: {
		"name"		: 'resonance_smoothccN',
		"ver"		: 'v2',
		"category"	: 'Filter',
		"modulates"	: 'resonance',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'float',
			"unit"	: 'ms'
		}
	},
	"resonance_stepccN"			: {
		"name"		: 'resonance_stepccN',
		"ver"		: 'v2',
		"category"	: 'Filter',
		"modulates"	: 'resonance',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'integer'
		}
	},
	"resonance_random"			: {
		"name"		: 'resonance_random',
		"ver"		: 'aria',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 40)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"noise_filter"				: {
		"name"		: 'noise_filter',
		"ver"		: 'cakewalk',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off', 'lpf_1p', 'hpf_1p', 'bpf_1p', 'brf_1p', 'apf_1p', 'lpf_2p', 'hpf_2p', 'bpf_2p', 'brf_2p', 'pkf_2p', 'lpf_4p', 'hpf_4p', 'lpf_6p', 'hpf_6p', 'comb', 'pink'])",
			"type"	: 'string'
		}
	},
	"noise_stereo"				: {
		"name"		: 'noise_stereo',
		"ver"		: 'cakewalk',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"noise_level"				: {
		"name"		: 'noise_level',
		"ver"		: 'cakewalk',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-96, 24)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"noise_level_onccN"			: {
		"name"		: 'noise_level_onccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'noise_level',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-96, 24)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"noise_level_smoothccN"		: {
		"name"		: 'noise_level_smoothccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'noise_level',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'float',
			"unit"	: 'ms'
		}
	},
	"noise_step"				: {
		"name"		: 'noise_step',
		"ver"		: 'cakewalk',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'integer'
		}
	},
	"noise_step_onccN"			: {
		"name"		: 'noise_step_onccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'noise_step',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'integer'
		}
	},
	"noise_tone"				: {
		"name"		: 'noise_tone',
		"ver"		: 'cakewalk',
		"category"	: 'Filter',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'integer'
		}
	},
	"noise_tone_onccN"			: {
		"name"		: 'noise_tone_onccN',
		"ver"		: 'unknown',
		"category"	: 'Filter',
		"modulates"	: 'noise_tone',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'integer'
		}
	},
	"bend_up"					: {
		"name"		: 'bend_up',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"bendup"					: {
		"name"	: 'bendup',
		"value"	: {'valid': "Alias('bend_up')"},
		"ver"	: 'v1'
	},
	"bend_down"					: {
		"name"		: 'bend_down',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"benddown"					: {
		"name"	: 'benddown',
		"value"	: {'valid': "Alias('bend_down')"},
		"ver"	: 'v1'
	},
	"bend_smooth"				: {
		"name"		: 'bend_smooth',
		"ver"		: 'v2',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'float',
			"unit"	: 'ms'
		}
	},
	"bend_step"					: {
		"name"		: 'bend_step',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 1200)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"bendstep"					: {
		"name"	: 'bendstep',
		"value"	: {'valid': "Alias('bend_step')"},
		"ver"	: 'v1'
	},
	"tune"						: {
		"name"		: 'tune',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"pitch"						: {
		"name"	: 'pitch',
		"value"	: {'valid': "Alias('tune')"},
		"ver"	: 'aria'
	},
	"pitch_onccN"				: {
		"name"		: 'pitch_onccN',
		"ver"		: 'v2',
		"category"	: 'Pitch',
		"modulates"	: 'tune',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"unit"	: 'cents'
		}
	},
	"tune_ccN"					: {
		"name"	: 'tune_ccN',
		"value"	: {'valid': "Alias('pitch_onccN')"},
		"ver"	: 'aria'
	},
	"tune_onccN"				: {
		"name"	: 'tune_onccN',
		"value"	: {'valid': "Alias('pitch_onccN')"},
		"ver"	: 'aria'
	},
	"pitch_curveccN"			: {
		"name"		: 'pitch_curveccN',
		"ver"		: 'v2',
		"category"	: 'Pitch',
		"modulates"	: 'tune',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"tune_curveccN"				: {
		"name"	: 'tune_curveccN',
		"value"	: {'valid': "Alias('pitch_curveccN')"},
		"ver"	: 'aria'
	},
	"pitch_smoothccN"			: {
		"name"		: 'pitch_smoothccN',
		"ver"		: 'v2',
		"category"	: 'Pitch',
		"modulates"	: 'tune',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Min(0)',
			"type"	: 'float',
			"unit"	: 'ms'
		}
	},
	"tune_smoothccN"			: {
		"name"	: 'tune_smoothccN',
		"value"	: {'valid': "Alias('pitch_smoothccN')"},
		"ver"	: 'aria'
	},
	"pitch_stepccN"				: {
		"name"		: 'pitch_stepccN',
		"ver"		: 'v2',
		"category"	: 'Pitch',
		"modulates"	: 'tune',
		"mod_type"	: 'midi_cc',
		"value"		: {'valid': 'Min(0)'}
	},
	"tune_stepccN"				: {
		"name"	: 'tune_stepccN',
		"value"	: {'valid': "Alias('pitch_stepccN')"},
		"ver"	: 'aria'
	},
	"group_tune"				: {
		"name"		: 'group_tune',
		"ver"		: 'aria',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"master_tune"				: {
		"name"		: 'master_tune',
		"ver"		: 'aria',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"global_tune"				: {
		"name"		: 'global_tune',
		"ver"		: 'aria',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"pitch_keycenter"			: {
		"name"		: 'pitch_keycenter',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"pitch_keytrack"			: {
		"name"		: 'pitch_keytrack',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'integer'
		}
	},
	"tune_keytrack"				: {
		"name"	: 'tune_keytrack',
		"value"	: {'valid': "Alias('pitch_keytrack')"},
		"ver"	: 'aria'
	},
	"pitch_random"				: {
		"name"		: 'pitch_random',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"tune_random"				: {
		"name"	: 'tune_random',
		"value"	: {'valid': "Alias('pitch_random')"},
		"ver"	: 'aria'
	},
	"pitch_veltrack"			: {
		"name"		: 'pitch_veltrack',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-9600, 9600)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"tune_veltrack"				: {
		"name"	: 'tune_veltrack',
		"value"	: {'valid': "Alias('pitch_veltrack')"},
		"ver"	: 'aria'
	},
	"transpose"					: {
		"name"		: 'transpose',
		"ver"		: 'v1',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-127, 127)',
			"type"	: 'integer'
		}
	},
	"bend_stepup"				: {
		"name"		: 'bend_stepup',
		"ver"		: 'v2',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 1200)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"bend_stepdown"				: {
		"name"		: 'bend_stepdown',
		"ver"		: 'v2',
		"category"	: 'Pitch',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 1200)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"ampeg_attack"				: {
		"name"		: 'ampeg_attack',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_attack"				: {
		"name"	: 'amp_attack',
		"value"	: {'valid': "Alias('ampeg_attack')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_attackccN"			: {
		"name"		: 'ampeg_attackccN',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_attack',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"ampeg_attack_onccN"		: {
		"name"	: 'ampeg_attack_onccN',
		"value"	: {'valid': "Alias('ampeg_attackccN')"},
		"ver"	: 'v2'
	},
	"ampeg_vel2attack"			: {
		"name"		: 'ampeg_vel2attack',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_attack',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_vel2attack"			: {
		"name"	: 'amp_vel2attack',
		"value"	: {'valid': "Alias('ampeg_vel2attack')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_decay"				: {
		"name"		: 'ampeg_decay',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_decay"					: {
		"name"	: 'amp_decay',
		"value"	: {'valid': "Alias('ampeg_decay')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_decayccN"			: {
		"name"		: 'ampeg_decayccN',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_decay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"ampeg_decay_onccN"			: {
		"name"	: 'ampeg_decay_onccN',
		"value"	: {'valid': "Alias('ampeg_decayccN')"},
		"ver"	: 'v2'
	},
	"ampeg_decay_curveccN"		: {
		"name"		: 'ampeg_decay_curveccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_decay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"ampeg_vel2decay"			: {
		"name"		: 'ampeg_vel2decay',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_decay',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_vel2decay"				: {
		"name"	: 'amp_vel2decay',
		"value"	: {'valid': "Alias('ampeg_vel2decay')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_delay"				: {
		"name"		: 'ampeg_delay',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_delay"					: {
		"name"	: 'amp_delay',
		"value"	: {'valid': "Alias('ampeg_delay')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_delayccN"			: {
		"name"		: 'ampeg_delayccN',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_delay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"ampeg_delay_onccN"			: {
		"name"	: 'ampeg_delay_onccN',
		"value"	: {'valid': "Alias('ampeg_delayccN')"},
		"ver"	: 'v2'
	},
	"ampeg_vel2delay"			: {
		"name"		: 'ampeg_vel2delay',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_delay',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_vel2delay"				: {
		"name"	: 'amp_vel2delay',
		"value"	: {'valid': "Alias('ampeg_vel2delay')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_hold"				: {
		"name"		: 'ampeg_hold',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_hold"					: {
		"name"	: 'amp_hold',
		"value"	: {'valid': "Alias('ampeg_hold')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_holdccN"				: {
		"name"		: 'ampeg_holdccN',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_hold',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"ampeg_hold_onccN"			: {
		"name"	: 'ampeg_hold_onccN',
		"value"	: {'valid': "Alias('ampeg_holdccN')"},
		"ver"	: 'v2'
	},
	"ampeg_hold_curveccN"		: {
		"name"		: 'ampeg_hold_curveccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_hold',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"ampeg_vel2hold"			: {
		"name"		: 'ampeg_vel2hold',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_hold',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_vel2hold"				: {
		"name"	: 'amp_vel2hold',
		"value"	: {'valid': "Alias('ampeg_vel2hold')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_release"				: {
		"name"		: 'ampeg_release',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_release"				: {
		"name"	: 'amp_release',
		"value"	: {'valid': "Alias('ampeg_release')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_releaseccN"			: {
		"name"		: 'ampeg_releaseccN',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_release',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"ampeg_release_onccN"		: {
		"name"	: 'ampeg_release_onccN',
		"value"	: {'valid': "Alias('ampeg_releaseccN')"},
		"ver"	: 'v2'
	},
	"ampeg_vel2release"			: {
		"name"		: 'ampeg_vel2release',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_release',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amp_vel2release"			: {
		"name"	: 'amp_vel2release',
		"value"	: {'valid': "Alias('ampeg_vel2release')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_sustain"				: {
		"name"		: 'ampeg_sustain',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"amp_sustain"				: {
		"name"	: 'amp_sustain',
		"value"	: {'valid': "Alias('ampeg_sustain')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_sustainccN"			: {
		"name"		: 'ampeg_sustainccN',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_sustain',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"ampeg_sustain_onccN"		: {
		"name"	: 'ampeg_sustain_onccN',
		"value"	: {'valid': "Alias('ampeg_sustainccN')"},
		"ver"	: 'v2'
	},
	"ampeg_sustain_curveccN"	: {
		"name"		: 'ampeg_sustain_curveccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_sustain',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"ampeg_vel2sustain"			: {
		"name"		: 'ampeg_vel2sustain',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_sustain',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"amp_vel2sustain"			: {
		"name"	: 'amp_vel2sustain',
		"value"	: {'valid': "Alias('ampeg_vel2sustain')"},
		"ver"	: 'cakewalk'
	},
	"ampeg_start"				: {
		"name"		: 'ampeg_start',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"ampeg_startccN"			: {
		"name"		: 'ampeg_startccN',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'ampeg_start',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"ampeg_start_onccN"			: {
		"name"	: 'ampeg_start_onccN',
		"value"	: {'valid': "Alias('ampeg_startccN')"},
		"ver"	: 'v2'
	},
	"ampeg_attack_shape"		: {
		"name"		: 'ampeg_attack_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"ampeg_decay_shape"			: {
		"name"		: 'ampeg_decay_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"ampeg_decay_zero"			: {
		"name"		: 'ampeg_decay_zero',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"ampeg_dynamic"				: {
		"name"		: 'ampeg_dynamic',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"ampeg_release_shape"		: {
		"name"		: 'ampeg_release_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"ampeg_release_zero"		: {
		"name"		: 'ampeg_release_zero',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"fileg_attack_shape"		: {
		"name"		: 'fileg_attack_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"fileg_decay_shape"			: {
		"name"		: 'fileg_decay_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"fileg_decay_zero"			: {
		"name"		: 'fileg_decay_zero',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"fileg_release_shape"		: {
		"name"		: 'fileg_release_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"fileg_release_zero"		: {
		"name"		: 'fileg_release_zero',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"fileg_dynamic"				: {
		"name"		: 'fileg_dynamic',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"pitcheg_attack_shape"		: {
		"name"		: 'pitcheg_attack_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"pitcheg_decay_shape"		: {
		"name"		: 'pitcheg_decay_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"pitcheg_decay_zero"		: {
		"name"		: 'pitcheg_decay_zero',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"pitcheg_release_shape"		: {
		"name"		: 'pitcheg_release_shape',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"pitcheg_release_zero"		: {
		"name"		: 'pitcheg_release_zero',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"pitcheg_dynamic"			: {
		"name"		: 'pitcheg_dynamic',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"fileg_attack"				: {
		"name"		: 'fileg_attack',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_attack"				: {
		"name"	: 'fil_attack',
		"value"	: {'valid': "Alias('fileg_attack')"},
		"ver"	: 'cakewalk'
	},
	"fileg_attack_onccN"		: {
		"name"		: 'fileg_attack_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_attack',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fileg_attackccN"			: {
		"name"	: 'fileg_attackccN',
		"value"	: {'valid': "Alias('fileg_attack_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_vel2attack"			: {
		"name"		: 'fileg_vel2attack',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_attack',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_vel2attack"			: {
		"name"	: 'fil_vel2attack',
		"value"	: {'valid': "Alias('fileg_vel2attack')"},
		"ver"	: 'cakewalk'
	},
	"fileg_decay"				: {
		"name"		: 'fileg_decay',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_decay"					: {
		"name"	: 'fil_decay',
		"value"	: {'valid': "Alias('fileg_decay')"},
		"ver"	: 'cakewalk'
	},
	"fileg_decay_onccN"			: {
		"name"		: 'fileg_decay_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_decay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"fileg_decayccN"			: {
		"name"	: 'fileg_decayccN',
		"value"	: {'valid': "Alias('fileg_decay_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_vel2decay"			: {
		"name"		: 'fileg_vel2decay',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_decay',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_vel2decay"				: {
		"name"	: 'fil_vel2decay',
		"value"	: {'valid': "Alias('fileg_vel2decay')"},
		"ver"	: 'cakewalk'
	},
	"fileg_delay"				: {
		"name"		: 'fileg_delay',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_delay"					: {
		"name"	: 'fil_delay',
		"value"	: {'valid': "Alias('fileg_delay')"},
		"ver"	: 'cakewalk'
	},
	"fileg_delay_onccN"			: {
		"name"		: 'fileg_delay_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_delay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"fileg_delayccN"			: {
		"name"	: 'fileg_delayccN',
		"value"	: {'valid': "Alias('fileg_delay_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_vel2delay"			: {
		"name"		: 'fileg_vel2delay',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_delay',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_vel2delay"				: {
		"name"	: 'fil_vel2delay',
		"value"	: {'valid': "Alias('fileg_vel2delay')"},
		"ver"	: 'cakewalk'
	},
	"fileg_depth"				: {
		"name"		: 'fileg_depth',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-12000, 12000)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"fil_depth"					: {
		"name"	: 'fil_depth',
		"value"	: {'valid': "Alias('fileg_depth')"},
		"ver"	: 'cakewalk'
	},
	"fileg_depth_onccN"			: {
		"name"		: 'fileg_depth_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-12000, 12000)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"fileg_depthccN"			: {
		"name"	: 'fileg_depthccN',
		"value"	: {'valid': "Alias('fileg_depth_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_vel2depth"			: {
		"name"		: 'fileg_vel2depth',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_depth',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-12000, 12000)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"fil_vel2depth"				: {
		"name"	: 'fil_vel2depth',
		"value"	: {'valid': "Alias('fileg_vel2depth')"},
		"ver"	: 'cakewalk'
	},
	"fileg_hold"				: {
		"name"		: 'fileg_hold',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_hold"					: {
		"name"	: 'fil_hold',
		"value"	: {'valid': "Alias('fileg_hold')"},
		"ver"	: 'cakewalk'
	},
	"fileg_hold_onccN"			: {
		"name"		: 'fileg_hold_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_hold',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"fileg_holdccN"				: {
		"name"	: 'fileg_holdccN',
		"value"	: {'valid': "Alias('fileg_hold_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_vel2hold"			: {
		"name"		: 'fileg_vel2hold',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_hold',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_vel2hold"				: {
		"name"	: 'fil_vel2hold',
		"value"	: {'valid': "Alias('fileg_vel2hold')"},
		"ver"	: 'cakewalk'
	},
	"fileg_release"				: {
		"name"		: 'fileg_release',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_release"				: {
		"name"	: 'fil_release',
		"value"	: {'valid': "Alias('fileg_release')"},
		"ver"	: 'cakewalk'
	},
	"fileg_release_onccN"		: {
		"name"		: 'fileg_release_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_release',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fileg_releaseccN"			: {
		"name"	: 'fileg_releaseccN',
		"value"	: {'valid': "Alias('fileg_release_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_vel2release"			: {
		"name"		: 'fileg_vel2release',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_release',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fil_vel2release"			: {
		"name"	: 'fil_vel2release',
		"value"	: {'valid': "Alias('fileg_vel2release')"},
		"ver"	: 'cakewalk'
	},
	"fileg_start"				: {
		"name"		: 'fileg_start',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"fileg_start_onccN"			: {
		"name"		: 'fileg_start_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_start',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fileg_startccN"			: {
		"name"	: 'fileg_startccN',
		"value"	: {'valid': "Alias('fileg_start_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_sustain"				: {
		"name"		: 'fileg_sustain',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"fil_sustain"				: {
		"name"	: 'fil_sustain',
		"value"	: {'valid': "Alias('fileg_sustain')"},
		"ver"	: 'cakewalk'
	},
	"fileg_sustain_onccN"		: {
		"name"		: 'fileg_sustain_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_sustain',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fileg_sustainccN"			: {
		"name"	: 'fileg_sustainccN',
		"value"	: {'valid': "Alias('fileg_sustain_onccN')"},
		"ver"	: 'aria'
	},
	"fileg_vel2sustain"			: {
		"name"		: 'fileg_vel2sustain',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'fileg_sustain',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"fil_vel2sustain"			: {
		"name"	: 'fil_vel2sustain',
		"value"	: {'valid': "Alias('fileg_vel2sustain')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_attack"			: {
		"name"		: 'pitcheg_attack',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_attack"				: {
		"name"	: 'pitch_attack',
		"value"	: {'valid': "Alias('pitcheg_attack')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_attack_onccN"		: {
		"name"		: 'pitcheg_attack_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_attack',
		"mod_type"	: 'midi_cc'
	},
	"pitcheg_vel2attack"		: {
		"name"		: 'pitcheg_vel2attack',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_attack',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_vel2attack"			: {
		"name"	: 'pitch_vel2attack',
		"value"	: {'valid': "Alias('pitcheg_vel2attack')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_decay"				: {
		"name"		: 'pitcheg_decay',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_decay"				: {
		"name"	: 'pitch_decay',
		"value"	: {'valid': "Alias('pitcheg_decay')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_decay_onccN"		: {
		"name"		: 'pitcheg_decay_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_decay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"pitcheg_vel2decay"			: {
		"name"		: 'pitcheg_vel2decay',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_decay',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_vel2decay"			: {
		"name"	: 'pitch_vel2decay',
		"value"	: {'valid': "Alias('pitcheg_vel2decay')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_delay"				: {
		"name"		: 'pitcheg_delay',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_delay"				: {
		"name"	: 'pitch_delay',
		"value"	: {'valid': "Alias('pitcheg_delay')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_delay_onccN"		: {
		"name"		: 'pitcheg_delay_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_delay',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"pitcheg_vel2delay"			: {
		"name"		: 'pitcheg_vel2delay',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_delay',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_vel2delay"			: {
		"name"	: 'pitch_vel2delay',
		"value"	: {'valid': "Alias('pitcheg_vel2delay')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_depth"				: {
		"name"		: 'pitcheg_depth',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-12000, 12000)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"pitch_depth"				: {
		"name"	: 'pitch_depth',
		"value"	: {'valid': "Alias('pitcheg_depth')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_depth_onccN"		: {
		"name"		: 'pitcheg_depth_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-12000, 12000)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"pitcheg_depthccN"			: {
		"name"	: 'pitcheg_depthccN',
		"value"	: {'valid': "Alias('pitcheg_depth_onccN')"},
		"ver"	: 'aria'
	},
	"pitcheg_vel2depth"			: {
		"name"		: 'pitcheg_vel2depth',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_depth',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-12000, 12000)',
			"type"	: 'integer',
			"unit"	: 'cents'
		}
	},
	"pitch_vel2depth"			: {
		"name"	: 'pitch_vel2depth',
		"value"	: {'valid': "Alias('pitcheg_vel2depth')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_hold"				: {
		"name"		: 'pitcheg_hold',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_hold"				: {
		"name"	: 'pitch_hold',
		"value"	: {'valid': "Alias('pitcheg_hold')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_hold_onccN"		: {
		"name"		: 'pitcheg_hold_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_hold',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float'
		}
	},
	"pitcheg_vel2hold"			: {
		"name"		: 'pitcheg_vel2hold',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_hold',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_vel2hold"			: {
		"name"	: 'pitch_vel2hold',
		"value"	: {'valid': "Alias('pitcheg_vel2hold')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_release"			: {
		"name"		: 'pitcheg_release',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_release"				: {
		"name"	: 'pitch_release',
		"value"	: {'valid': "Alias('pitcheg_release')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_release_onccN"		: {
		"name"		: 'pitcheg_release_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_release',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitcheg_vel2release"		: {
		"name"		: 'pitcheg_vel2release',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_release',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitch_vel2release"			: {
		"name"	: 'pitch_vel2release',
		"value"	: {'valid': "Alias('pitcheg_vel2release')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_start"				: {
		"name"		: 'pitcheg_start',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"pitcheg_start_onccN"		: {
		"name"		: 'pitcheg_start_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_start',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitcheg_sustain"			: {
		"name"		: 'pitcheg_sustain',
		"ver"		: 'v1',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"pitch_sustain"				: {
		"name"	: 'pitch_sustain',
		"value"	: {'valid': "Alias('pitcheg_sustain')"},
		"ver"	: 'cakewalk'
	},
	"pitcheg_sustain_onccN"		: {
		"name"		: 'pitcheg_sustain_onccN',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_sustain',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitcheg_vel2sustain"		: {
		"name"		: 'pitcheg_vel2sustain',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'pitcheg_sustain',
		"mod_type"	: 'velocity',
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"pitch_vel2sustain"			: {
		"name"	: 'pitch_vel2sustain',
		"value"	: {'valid': "Alias('pitcheg_vel2sustain')"},
		"ver"	: 'cakewalk'
	},
	"egN_points"				: {
		"name"		: 'egN_points',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_timeX"					: {
		"name"		: 'egN_timeX',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"egN_timeX_onccY"			: {
		"name"		: 'egN_timeX_onccY',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_timeX',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"egN_levelX"				: {
		"name"		: 'egN_levelX',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-1, 1)',
			"type"	: 'float'
		}
	},
	"egN_levelX_onccY"			: {
		"name"		: 'egN_levelX_onccY',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_levelX',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-1, 1)',
			"type"	: 'float'
		}
	},
	"egN_ampeg"					: {
		"name"		: 'egN_ampeg',
		"ver"		: 'aria',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_shapeX"				: {
		"name"		: 'egN_shapeX',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"egN_curveX"				: {
		"name"		: 'egN_curveX',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_sustain"				: {
		"name"		: 'egN_sustain',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_loop"					: {
		"name"		: 'egN_loop',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_loop_count"			: {
		"name"		: 'egN_loop_count',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_volume"				: {
		"name"		: 'egN_volume',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_volume_onccX"			: {
		"name"		: 'egN_volume_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_volume',
		"mod_type"	: 'midi_cc'
	},
	"egN_amplitude"				: {
		"name"		: 'egN_amplitude',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_amplitude_onccX"		: {
		"name"		: 'egN_amplitude_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_amplitude',
		"mod_type"	: 'midi_cc'
	},
	"egN_pan"					: {
		"name"		: 'egN_pan',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_pan_onccX"				: {
		"name"		: 'egN_pan_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_pan',
		"mod_type"	: 'midi_cc'
	},
	"egN_width"					: {
		"name"		: 'egN_width',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_width_onccX"			: {
		"name"		: 'egN_width_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_width',
		"mod_type"	: 'midi_cc'
	},
	"egN_pan_curve"				: {
		"name"		: 'egN_pan_curve',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_pan_curveccX"			: {
		"name"		: 'egN_pan_curveccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_pan_curve',
		"mod_type"	: 'midi_cc'
	},
	"egN_freq_lfoX"				: {
		"name"		: 'egN_freq_lfoX',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_depth_lfoX"			: {
		"name"		: 'egN_depth_lfoX',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_depthadd_lfoX"			: {
		"name"		: 'egN_depthadd_lfoX',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_pitch"					: {
		"name"		: 'egN_pitch',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_pitch_onccX"			: {
		"name"		: 'egN_pitch_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_pitch',
		"mod_type"	: 'midi_cc'
	},
	"egN_cutoff"				: {
		"name"		: 'egN_cutoff',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_cutoff_onccX"			: {
		"name"		: 'egN_cutoff_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_cutoff',
		"mod_type"	: 'midi_cc'
	},
	"egN_cutoff2"				: {
		"name"		: 'egN_cutoff2',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_cutoff2_onccX"			: {
		"name"		: 'egN_cutoff2_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"egN_resonance"				: {
		"name"		: 'egN_resonance',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_resonance_onccX"		: {
		"name"		: 'egN_resonance_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_resonance',
		"mod_type"	: 'midi_cc'
	},
	"egN_resonance2"			: {
		"name"		: 'egN_resonance2',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_resonance2_onccX"		: {
		"name"		: 'egN_resonance2_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_resonance2',
		"mod_type"	: 'midi_cc'
	},
	"egN_eqXfreq"				: {
		"name"		: 'egN_eqXfreq',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_eqXfreq_onccY"			: {
		"name"		: 'egN_eqXfreq_onccY',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_eqXfreq',
		"mod_type"	: 'midi_cc'
	},
	"egN_eqXbw"					: {
		"name"		: 'egN_eqXbw',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_eqXbw_onccY"			: {
		"name"		: 'egN_eqXbw_onccY',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_eqXbw',
		"mod_type"	: 'midi_cc'
	},
	"egN_eqXgain"				: {
		"name"		: 'egN_eqXgain',
		"ver"		: 'v2',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_eqXgain_onccY"			: {
		"name"		: 'egN_eqXgain_onccY',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_eqXgain',
		"mod_type"	: 'midi_cc'
	},
	"egN_decim"					: {
		"name"		: 'egN_decim',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_decim_onccX"			: {
		"name"		: 'egN_decim_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_decim',
		"mod_type"	: 'midi_cc'
	},
	"egN_bitred"				: {
		"name"		: 'egN_bitred',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_bitred_onccX"			: {
		"name"		: 'egN_bitred_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_bitred',
		"mod_type"	: 'midi_cc'
	},
	"egN_rectify"				: {
		"name"		: 'egN_rectify',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_rectify_onccX"			: {
		"name"		: 'egN_rectify_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_rectify',
		"mod_type"	: 'midi_cc'
	},
	"egN_ringmod"				: {
		"name"		: 'egN_ringmod',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_ringmod_onccX"			: {
		"name"		: 'egN_ringmod_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_ringmod',
		"mod_type"	: 'midi_cc'
	},
	"egN_noiselevel"			: {
		"name"		: 'egN_noiselevel',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_noiselevel_onccX"		: {
		"name"		: 'egN_noiselevel_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_noiselevel',
		"mod_type"	: 'midi_cc'
	},
	"egN_noisestep"				: {
		"name"		: 'egN_noisestep',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_noisestep_onccX"		: {
		"name"		: 'egN_noisestep_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_noisestep',
		"mod_type"	: 'midi_cc'
	},
	"egN_noisetone"				: {
		"name"		: 'egN_noisetone',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_noisetone_onccX"		: {
		"name"		: 'egN_noisetone_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_noisetone',
		"mod_type"	: 'midi_cc'
	},
	"egN_driveshape"			: {
		"name"		: 'egN_driveshape',
		"ver"		: 'cakewalk',
		"category"	: 'Envelope Generators',
		"modulates"	: None,
		"mod_type"	: None
	},
	"egN_driveshape_onccX"		: {
		"name"		: 'egN_driveshape_onccX',
		"ver"		: 'unknown',
		"category"	: 'Envelope Generators',
		"modulates"	: 'egN_driveshape',
		"mod_type"	: 'midi_cc'
	},
	"amplfo_delay"				: {
		"name"		: 'amplfo_delay',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amplfo_depth"				: {
		"name"		: 'amplfo_depth',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-10, 10)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"amplfo_depthccN"			: {
		"name"		: 'amplfo_depthccN',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'amplfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-10, 10)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"amplfo_depth_onccN"		: {
		"name"	: 'amplfo_depth_onccN',
		"value"	: {'valid': "Alias('amplfo_depthccN')"},
		"ver"	: 'v2'
	},
	"amplfo_depthchanaft"		: {
		"name"		: 'amplfo_depthchanaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'amplfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-10, 10)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"amplfo_depthpolyaft"		: {
		"name"		: 'amplfo_depthpolyaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'amplfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-10, 10)',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"amplfo_fade"				: {
		"name"		: 'amplfo_fade',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"amplfo_freq"				: {
		"name"		: 'amplfo_freq',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 20)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"amplfo_freqccN"			: {
		"name"		: 'amplfo_freqccN',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'amplfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"amplfo_freqchanaft"		: {
		"name"		: 'amplfo_freqchanaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'amplfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"amplfo_freqpolyaft"		: {
		"name"		: 'amplfo_freqpolyaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'amplfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"fillfo_delay"				: {
		"name"		: 'fillfo_delay',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fillfo_depth"				: {
		"name"		: 'fillfo_depth',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"fillfo_depthccN"			: {
		"name"		: 'fillfo_depthccN',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'fillfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"fillfo_depth_onccN"		: {
		"name"	: 'fillfo_depth_onccN',
		"value"	: {'valid': "Alias('fillfo_depthccN')"},
		"ver"	: 'v2'
	},
	"fillfo_depthchanaft"		: {
		"name"		: 'fillfo_depthchanaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'fillfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"fillfo_depthpolyaft"		: {
		"name"		: 'fillfo_depthpolyaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'fillfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"fillfo_fade"				: {
		"name"		: 'fillfo_fade',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"fillfo_freq"				: {
		"name"		: 'fillfo_freq',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 20)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"fillfo_freqccN"			: {
		"name"		: 'fillfo_freqccN',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'fillfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"fillfo_freqchanaft"		: {
		"name"		: 'fillfo_freqchanaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'fillfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"fillfo_freqpolyaft"		: {
		"name"		: 'fillfo_freqpolyaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'fillfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"pitchlfo_delay"			: {
		"name"		: 'pitchlfo_delay',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitchlfo_depth"			: {
		"name"		: 'pitchlfo_depth',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"pitchlfo_depthccN"			: {
		"name"		: 'pitchlfo_depthccN',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'pitchlfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"pitchlfo_depth_onccN"		: {
		"name"	: 'pitchlfo_depth_onccN',
		"value"	: {'valid': "Alias('pitchlfo_depthccN')"},
		"ver"	: 'v2'
	},
	"pitchlfo_depthchanaft"		: {
		"name"		: 'pitchlfo_depthchanaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'pitchlfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"pitchlfo_depthpolyaft"		: {
		"name"		: 'pitchlfo_depthpolyaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'pitchlfo_depth',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-1200, 1200)',
			"type"	: 'float',
			"unit"	: 'cents'
		}
	},
	"pitchlfo_fade"				: {
		"name"		: 'pitchlfo_fade',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"pitchlfo_freq"				: {
		"name"		: 'pitchlfo_freq',
		"ver"		: 'v1',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 20)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"pitchlfo_freqccN"			: {
		"name"		: 'pitchlfo_freqccN',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'pitchlfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"pitchlfo_freqchanaft"		: {
		"name"		: 'pitchlfo_freqchanaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'pitchlfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"pitchlfo_freqpolyaft"		: {
		"name"		: 'pitchlfo_freqpolyaft',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'pitchlfo_freq',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(-200, 200)',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"lfoN_freq"					: {
		"name"		: 'lfoN_freq',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"lfoN_freq_onccX"			: {
		"name"		: 'lfoN_freq_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_freq',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_freq_smoothccX"		: {
		"name"		: 'lfoN_freq_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_freq',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_freq_stepccX"			: {
		"name"		: 'lfoN_freq_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_freq',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_delay"				: {
		"name"		: 'lfoN_delay',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"lfoN_delay_onccX"			: {
		"name"		: 'lfoN_delay_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_delay',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_fade"					: {
		"name"		: 'lfoN_fade',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"lfoN_fade_onccX"			: {
		"name"		: 'lfoN_fade_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_fade',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"lfoN_phase"				: {
		"name"		: 'lfoN_phase',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'float'
		}
	},
	"lfoN_phase_onccX"			: {
		"name"		: 'lfoN_phase_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_phase',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_count"				: {
		"name"		: 'lfoN_count',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"lfoN_wave"					: {
		"name"		: 'lfoN_wave',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"lfoN_waveX"				: {
		"name"	: 'lfoN_waveX',
		"value"	: {'valid': "Alias('lfoN_wave')"},
		"ver"	: 'aria'
	},
	"lfoN_wave_onccX"			: {
		"name"		: 'lfoN_wave_onccX',
		"ver"		: 'aria',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_wave',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_steps"				: {
		"name"		: 'lfoN_steps',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"lfoN_stepX"				: {
		"name"		: 'lfoN_stepX',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-100, 100)',
			"type"	: 'float',
			"unit"	: 'percent'
		}
	},
	"lfoN_stepX_onccY"			: {
		"name"		: 'lfoN_stepX_onccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_stepX',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_smooth"				: {
		"name"		: 'lfoN_smooth',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_smooth_onccX"			: {
		"name"		: 'lfoN_smooth_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_smooth',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_volume"				: {
		"name"		: 'lfoN_volume',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_volume_onccX"			: {
		"name"		: 'lfoN_volume_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_volume',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_volume_smoothccX"		: {
		"name"		: 'lfoN_volume_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_volume',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_volume_stepccX"		: {
		"name"		: 'lfoN_volume_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_volume',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_amplitude"			: {
		"name"		: 'lfoN_amplitude',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_amplitude_onccX"		: {
		"name"		: 'lfoN_amplitude_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_amplitude',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_amplitude_smoothccX"	: {
		"name"		: 'lfoN_amplitude_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_amplitude',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_amplitude_stepccX"	: {
		"name"		: 'lfoN_amplitude_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_amplitude',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_pan"					: {
		"name"		: 'lfoN_pan',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_pan_onccX"			: {
		"name"		: 'lfoN_pan_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_pan',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_pan_smoothccX"		: {
		"name"		: 'lfoN_pan_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_pan',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_pan_stepccX"			: {
		"name"		: 'lfoN_pan_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_pan',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_width"				: {
		"name"		: 'lfoN_width',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_width_onccX"			: {
		"name"		: 'lfoN_width_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_width',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_width_smoothccX"		: {
		"name"		: 'lfoN_width_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_width',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_width_stepccX"		: {
		"name"		: 'lfoN_width_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_width',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_freq_lfoX"			: {
		"name"		: 'lfoN_freq_lfoX',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_freq_lfoX_onccY"		: {
		"name"		: 'lfoN_freq_lfoX_onccY',
		"ver"		: 'aria',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_freq_lfoX',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_depth_lfoX"			: {
		"name"		: 'lfoN_depth_lfoX',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_depthadd_lfoX"		: {
		"name"		: 'lfoN_depthadd_lfoX',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_pitch"				: {
		"name"		: 'lfoN_pitch',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_pitch_curveccX"		: {
		"name"		: 'lfoN_pitch_curveccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_pitch',
		"mod_type"	: 'midi_cc',
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"lfoN_pitch_onccX"			: {
		"name"		: 'lfoN_pitch_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_pitch',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_pitch_smoothccX"		: {
		"name"		: 'lfoN_pitch_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_pitch',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_pitch_stepccX"		: {
		"name"		: 'lfoN_pitch_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_pitch',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_cutoff"				: {
		"name"		: 'lfoN_cutoff',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_cutoff2"				: {
		"name"	: 'lfoN_cutoff2',
		"value"	: {'valid': "Alias('lfoN_cutoff')"},
		"ver"	: 'v2'
	},
	"lfoN_cutoff2_onccX"		: {
		"name"		: 'lfoN_cutoff2_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_cutoff2_smoothccX"	: {
		"name"		: 'lfoN_cutoff2_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_cutoff2_stepccX"		: {
		"name"		: 'lfoN_cutoff2_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_cutoff2',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_cutoff_onccX"			: {
		"name"		: 'lfoN_cutoff_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_cutoff',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_cutoff_smoothccX"		: {
		"name"		: 'lfoN_cutoff_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_cutoff',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_cutoff_stepccX"		: {
		"name"		: 'lfoN_cutoff_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_cutoff',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_resonance"			: {
		"name"		: 'lfoN_resonance',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_resonance2"			: {
		"name"	: 'lfoN_resonance2',
		"value"	: {'valid': "Alias('lfoN_resonance')"},
		"ver"	: 'v2'
	},
	"lfoN_resonance2_onccX"		: {
		"name"		: 'lfoN_resonance2_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_resonance2',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_resonance2_smoothccX"	: {
		"name"		: 'lfoN_resonance2_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_resonance2',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_resonance2_stepccX"	: {
		"name"		: 'lfoN_resonance2_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_resonance2',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_resonance_onccX"		: {
		"name"		: 'lfoN_resonance_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_resonance',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_resonance_smoothccX"	: {
		"name"		: 'lfoN_resonance_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_resonance',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_resonance_stepccX"	: {
		"name"		: 'lfoN_resonance_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_resonance',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXfreq"				: {
		"name"		: 'lfoN_eqXfreq',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_eqXfreq_onccY"		: {
		"name"		: 'lfoN_eqXfreq_onccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXfreq',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXfreq_smoothccY"	: {
		"name"		: 'lfoN_eqXfreq_smoothccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXfreq',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXfreq_stepccY"		: {
		"name"		: 'lfoN_eqXfreq_stepccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXfreq',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXbw"				: {
		"name"		: 'lfoN_eqXbw',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_eqXbw_onccY"			: {
		"name"		: 'lfoN_eqXbw_onccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXbw',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXbw_smoothccY"		: {
		"name"		: 'lfoN_eqXbw_smoothccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXbw',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXbw_stepccY"		: {
		"name"		: 'lfoN_eqXbw_stepccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXbw',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXgain"				: {
		"name"		: 'lfoN_eqXgain',
		"ver"		: 'v2',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_eqXgain_onccY"		: {
		"name"		: 'lfoN_eqXgain_onccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXgain',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXgain_smoothccY"	: {
		"name"		: 'lfoN_eqXgain_smoothccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXgain',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_eqXgain_stepccY"		: {
		"name"		: 'lfoN_eqXgain_stepccY',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_eqXgain',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_decim"				: {
		"name"		: 'lfoN_decim',
		"ver"		: 'cakewalk',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_decim_onccX"			: {
		"name"		: 'lfoN_decim_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_decim',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_decim_smoothccX"		: {
		"name"		: 'lfoN_decim_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_decim',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_decim_stepccX"		: {
		"name"		: 'lfoN_decim_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_decim',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_bitred"				: {
		"name"		: 'lfoN_bitred',
		"ver"		: 'cakewalk',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_bitred_onccX"			: {
		"name"		: 'lfoN_bitred_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_bitred',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_bitred_smoothccX"		: {
		"name"		: 'lfoN_bitred_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_bitred',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_bitred_stepccX"		: {
		"name"		: 'lfoN_bitred_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_bitred',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noiselevel"			: {
		"name"		: 'lfoN_noiselevel',
		"ver"		: 'cakewalk',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_noiselevel_onccX"		: {
		"name"		: 'lfoN_noiselevel_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noiselevel',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noiselevel_smoothccX"	: {
		"name"		: 'lfoN_noiselevel_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noiselevel',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noiselevel_stepccX"	: {
		"name"		: 'lfoN_noiselevel_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noiselevel',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noisestep"			: {
		"name"		: 'lfoN_noisestep',
		"ver"		: 'cakewalk',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_noisestep_onccX"		: {
		"name"		: 'lfoN_noisestep_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noisestep',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noisestep_smoothccX"	: {
		"name"		: 'lfoN_noisestep_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noisestep',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noisestep_stepccX"	: {
		"name"		: 'lfoN_noisestep_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noisestep',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noisetone"			: {
		"name"		: 'lfoN_noisetone',
		"ver"		: 'cakewalk',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_noisetone_onccX"		: {
		"name"		: 'lfoN_noisetone_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noisetone',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noisetone_smoothccX"	: {
		"name"		: 'lfoN_noisetone_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noisetone',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_noisetone_stepccX"	: {
		"name"		: 'lfoN_noisetone_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_noisetone',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_drive"				: {
		"name"		: 'lfoN_drive',
		"ver"		: 'cakewalk',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None
	},
	"lfoN_drive_onccX"			: {
		"name"		: 'lfoN_drive_onccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_drive',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_drive_smoothccX"		: {
		"name"		: 'lfoN_drive_smoothccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_drive',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_drive_stepccX"		: {
		"name"		: 'lfoN_drive_stepccX',
		"ver"		: 'unknown',
		"category"	: 'LFO',
		"modulates"	: 'lfoN_drive',
		"mod_type"	: 'midi_cc'
	},
	"lfoN_offset"				: {
		"name"		: 'lfoN_offset',
		"ver"		: 'aria',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"lfoN_offsetX"				: {
		"name"	: 'lfoN_offsetX',
		"value"	: {'valid': "Alias('lfoN_offset')"},
		"ver"	: 'aria'
	},
	"lfoN_ratio"				: {
		"name"		: 'lfoN_ratio',
		"ver"		: 'aria',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"lfoN_ratioX"				: {
		"name"	: 'lfoN_ratioX',
		"value"	: {'valid': "Alias('lfoN_ratio')"},
		"ver"	: 'aria'
	},
	"lfoN_scale"				: {
		"name"		: 'lfoN_scale',
		"ver"		: 'aria',
		"category"	: 'LFO',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"lfoN_scaleX"				: {
		"name"	: 'lfoN_scaleX',
		"value"	: {'valid': "Alias('lfoN_scale')"},
		"ver"	: 'aria'
	},
	"curve_index"				: {
		"name"		: 'curve_index',
		"ver"		: 'aria',
		"category"	: 'Curves',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 255)',
			"type"	: 'integer'
		}
	},
	"vN"						: {
		"name"		: 'vN',
		"ver"		: 'v2',
		"category"	: 'Curves',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-1, 1)',
			"type"	: 'float'
		},
		"index"		: {
			"valid"	: 'Range(0, 127)',
			"type"	: 'integer'
		}
	},
	"apan_depth"				: {
		"name"		: 'apan_depth',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"apan_depth_onccN"			: {
		"name"		: 'apan_depth_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'apan_depth',
		"mod_type"	: 'midi_cc'
	},
	"apan_dry"					: {
		"name"		: 'apan_dry',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"apan_dry_onccN"			: {
		"name"		: 'apan_dry_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'apan_dry',
		"mod_type"	: 'midi_cc'
	},
	"apan_freq"					: {
		"name"		: 'apan_freq',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"apan_freq_onccN"			: {
		"name"		: 'apan_freq_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'apan_freq',
		"mod_type"	: 'midi_cc'
	},
	"apan_phase"				: {
		"name"		: 'apan_phase',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 180)',
			"type"	: 'float',
			"unit"	: '°'
		}
	},
	"apan_phase_onccN"			: {
		"name"		: 'apan_phase_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'apan_phase',
		"mod_type"	: 'midi_cc'
	},
	"apan_waveform"				: {
		"name"		: 'apan_waveform',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"apan_wet"					: {
		"name"		: 'apan_wet',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"apan_wet_onccN"			: {
		"name"		: 'apan_wet_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'apan_wet',
		"mod_type"	: 'midi_cc'
	},
	"bitred"					: {
		"name"		: 'bitred',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"bitred_onccN"				: {
		"name"		: 'bitred_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'bitred',
		"mod_type"	: 'midi_cc'
	},
	"bitred_curveccN"			: {
		"name"		: 'bitred_curveccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'bitred',
		"mod_type"	: 'midi_cc'
	},
	"bitred_smoothccN"			: {
		"name"		: 'bitred_smoothccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'bitred',
		"mod_type"	: 'midi_cc'
	},
	"bitred_stepccN"			: {
		"name"		: 'bitred_stepccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'bitred',
		"mod_type"	: 'midi_cc'
	},
	"bus"						: {
		"name"		: 'bus',
		"ver"		: 'v2',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['main', 'aux1', 'aux2', 'aux3', 'aux4', 'aux5', 'aux6', 'aux7', 'aux8', 'fx1', 'fx2', 'fx3', 'fx4', 'midi'])",
			"type"	: 'string'
		}
	},
	"bypass_onccN"				: {
		"name"		: 'bypass_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float'
		}
	},
	"comp_attack"				: {
		"name"		: 'comp_attack',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"comp_gain"					: {
		"name"		: 'comp_gain',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"comp_ratio"				: {
		"name"		: 'comp_ratio',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"comp_release"				: {
		"name"		: 'comp_release',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"comp_stlink"				: {
		"name"		: 'comp_stlink',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"comp_threshold"			: {
		"name"		: 'comp_threshold',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'dB'
		}
	},
	"decim"						: {
		"name"		: 'decim',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"decim_onccN"				: {
		"name"		: 'decim_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'decim',
		"mod_type"	: 'midi_cc'
	},
	"decim_curveccN"			: {
		"name"		: 'decim_curveccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'decim',
		"mod_type"	: 'midi_cc'
	},
	"decim_smoothccN"			: {
		"name"		: 'decim_smoothccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'decim',
		"mod_type"	: 'midi_cc'
	},
	"decim_stepccN"				: {
		"name"		: 'decim_stepccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'decim',
		"mod_type"	: 'midi_cc'
	},
	"delay_cutoff"				: {
		"name"		: 'delay_cutoff',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"delay_cutoff_onccN"		: {
		"name"		: 'delay_cutoff_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_cutoff',
		"mod_type"	: 'midi_cc'
	},
	"delay_damphi"				: {
		"name"		: 'delay_damphi',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_damphi_onccN"		: {
		"name"		: 'delay_damphi_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_damphi',
		"mod_type"	: 'midi_cc'
	},
	"delay_damplo"				: {
		"name"		: 'delay_damplo',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_damplo_onccN"		: {
		"name"		: 'delay_damplo_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_damplo',
		"mod_type"	: 'midi_cc'
	},
	"delay_dry"					: {
		"name"		: 'delay_dry',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_dry_onccN"			: {
		"name"		: 'delay_dry_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_dry',
		"mod_type"	: 'midi_cc'
	},
	"delay_feedback"			: {
		"name"		: 'delay_feedback',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_feedback_onccN"		: {
		"name"		: 'delay_feedback_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_feedback',
		"mod_type"	: 'midi_cc'
	},
	"delay_filter"				: {
		"name"		: 'delay_filter',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"delay_input"				: {
		"name"		: 'delay_input',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_input_onccN"			: {
		"name"		: 'delay_input_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_input',
		"mod_type"	: 'midi_cc'
	},
	"delay_levelc"				: {
		"name"		: 'delay_levelc',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_levell"				: {
		"name"		: 'delay_levell',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_levelr"				: {
		"name"		: 'delay_levelr',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_lfofreq"				: {
		"name"		: 'delay_lfofreq',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"delay_lfofreq_onccN"		: {
		"name"		: 'delay_lfofreq_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_lfofreq',
		"mod_type"	: 'midi_cc'
	},
	"delay_moddepth"			: {
		"name"		: 'delay_moddepth',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_moddepth_onccN"		: {
		"name"		: 'delay_moddepth_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_moddepth',
		"mod_type"	: 'midi_cc'
	},
	"delay_mode"				: {
		"name"		: 'delay_mode',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['detune', 'chorus', 'cross', 'flanger', 'lrc', 'mod', 'multimod', 'panning', 'ping', 'rlc', 'stereo', 'tlcr'])",
			"type"	: 'string'
		}
	},
	"delay_panc"				: {
		"name"		: 'delay_panc',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_panc_onccN"			: {
		"name"		: 'delay_panc_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_panc',
		"mod_type"	: 'midi_cc'
	},
	"delay_panl"				: {
		"name"		: 'delay_panl',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_panl_onccN"			: {
		"name"		: 'delay_panl_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_panl',
		"mod_type"	: 'midi_cc'
	},
	"delay_panr"				: {
		"name"		: 'delay_panr',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_panr_onccN"			: {
		"name"		: 'delay_panr_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_panr',
		"mod_type"	: 'midi_cc'
	},
	"delay_resonance"			: {
		"name"		: 'delay_resonance',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_resonance_onccN"		: {
		"name"		: 'delay_resonance_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_resonance',
		"mod_type"	: 'midi_cc'
	},
	"delay_spread"				: {
		"name"		: 'delay_spread',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_spread_onccN"		: {
		"name"		: 'delay_spread_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_spread',
		"mod_type"	: 'midi_cc'
	},
	"delay_syncc_onccN"			: {
		"name"		: 'delay_syncc_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_syncl_onccN"			: {
		"name"		: 'delay_syncl_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_syncr_onccN"			: {
		"name"		: 'delay_syncr_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_time_tap"			: {
		"name"		: 'delay_time_tap',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_timec"				: {
		"name"		: 'delay_timec',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_timec_onccN"			: {
		"name"		: 'delay_timec_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_timec',
		"mod_type"	: 'midi_cc'
	},
	"delay_timel"				: {
		"name"		: 'delay_timel',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_timel_onccN"			: {
		"name"		: 'delay_timel_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_timel',
		"mod_type"	: 'midi_cc'
	},
	"delay_timer"				: {
		"name"		: 'delay_timer',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"delay_timer_onccN"			: {
		"name"		: 'delay_timer_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_timer',
		"mod_type"	: 'midi_cc'
	},
	"delay_wet"					: {
		"name"		: 'delay_wet',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"delay_wet_onccN"			: {
		"name"		: 'delay_wet_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'delay_wet',
		"mod_type"	: 'midi_cc'
	},
	"directtomain"				: {
		"name"		: 'directtomain',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"disto_depth"				: {
		"name"		: 'disto_depth',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"disto_depth_onccN"			: {
		"name"		: 'disto_depth_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'disto_depth',
		"mod_type"	: 'midi_cc'
	},
	"disto_dry"					: {
		"name"		: 'disto_dry',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"disto_dry_onccN"			: {
		"name"		: 'disto_dry_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'disto_dry',
		"mod_type"	: 'midi_cc'
	},
	"disto_stages"				: {
		"name"		: 'disto_stages',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"disto_tone"				: {
		"name"		: 'disto_tone',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"disto_tone_onccN"			: {
		"name"		: 'disto_tone_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'disto_tone',
		"mod_type"	: 'midi_cc'
	},
	"disto_wet"					: {
		"name"		: 'disto_wet',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"disto_wet_onccN"			: {
		"name"		: 'disto_wet_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'disto_wet',
		"mod_type"	: 'midi_cc'
	},
	"dsp_order"					: {
		"name"		: 'dsp_order',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 14)',
			"type"	: 'integer'
		}
	},
	"effect1"					: {
		"name"		: 'effect1',
		"ver"		: 'v1',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"effect2"					: {
		"name"		: 'effect2',
		"ver"		: 'v1',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"effect3"					: {
		"name"		: 'effect3',
		"ver"		: 'v2',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"effect4"					: {
		"name"		: 'effect4',
		"ver"		: 'v2',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"eq_bw"						: {
		"name"		: 'eq_bw',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"eq_bw_onccN"				: {
		"name"		: 'eq_bw_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'eq_bw',
		"mod_type"	: 'midi_cc'
	},
	"eq_freq"					: {
		"name"		: 'eq_freq',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"eq_freq_onccN"				: {
		"name"		: 'eq_freq_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'eq_freq',
		"mod_type"	: 'midi_cc'
	},
	"eq_gain"					: {
		"name"		: 'eq_gain',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"eq_gain_onccN"				: {
		"name"		: 'eq_gain_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'eq_gain',
		"mod_type"	: 'midi_cc'
	},
	"eq_type"					: {
		"name"		: 'eq_type',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"filter_cutoff"				: {
		"name"		: 'filter_cutoff',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"filter_cutoff_onccN"		: {
		"name"		: 'filter_cutoff_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'filter_cutoff',
		"mod_type"	: 'midi_cc'
	},
	"filter_resonance"			: {
		"name"		: 'filter_resonance',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"filter_resonance_onccN"	: {
		"name"		: 'filter_resonance_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'filter_resonance',
		"mod_type"	: 'midi_cc'
	},
	"filter_type"				: {
		"name"		: 'filter_type',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"fxNtomain"					: {
		"name"		: 'fxNtomain',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"fxNtomix"					: {
		"name"		: 'fxNtomix',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 100)',
			"type"	: 'float',
			"unit"	: '%'
		}
	},
	"gate_onccN"				: {
		"name"		: 'gate_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"gate_attack"				: {
		"name"		: 'gate_attack',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"gate_release"				: {
		"name"		: 'gate_release',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"gate_stlink"				: {
		"name"		: 'gate_stlink',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"gate_threshold"			: {
		"name"		: 'gate_threshold',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"internal"					: {
		"name"		: 'internal',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"param_offset"				: {
		"name"		: 'param_offset',
		"ver"		: 'aria',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"phaser_depth"				: {
		"name"		: 'phaser_depth',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"phaser_depth_onccN"		: {
		"name"		: 'phaser_depth_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'phaser_depth',
		"mod_type"	: 'midi_cc'
	},
	"phaser_feedback"			: {
		"name"		: 'phaser_feedback',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"phaser_feedback_onccN"		: {
		"name"		: 'phaser_feedback_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'phaser_feedback',
		"mod_type"	: 'midi_cc'
	},
	"phaser_freq"				: {
		"name"		: 'phaser_freq',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'Hz'
		}
	},
	"phaser_freq_onccN"			: {
		"name"		: 'phaser_freq_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'phaser_freq',
		"mod_type"	: 'midi_cc'
	},
	"phaser_phase_onccN"		: {
		"name"		: 'phaser_phase_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"phaser_stages"				: {
		"name"		: 'phaser_stages',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"phaser_waveform"			: {
		"name"		: 'phaser_waveform',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"phaser_wet"				: {
		"name"		: 'phaser_wet',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"phaser_wet_onccN"			: {
		"name"		: 'phaser_wet_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'phaser_wet',
		"mod_type"	: 'midi_cc'
	},
	"reverb_damp"				: {
		"name"		: 'reverb_damp',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"reverb_damp_onccN"			: {
		"name"		: 'reverb_damp_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'reverb_damp',
		"mod_type"	: 'midi_cc'
	},
	"reverb_dry"				: {
		"name"		: 'reverb_dry',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"reverb_dry_onccN"			: {
		"name"		: 'reverb_dry_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'reverb_dry',
		"mod_type"	: 'midi_cc'
	},
	"reverb_input"				: {
		"name"		: 'reverb_input',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"reverb_input_onccN"		: {
		"name"		: 'reverb_input_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'reverb_input',
		"mod_type"	: 'midi_cc'
	},
	"reverb_predelay"			: {
		"name"		: 'reverb_predelay',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"reverb_predelay_onccN"		: {
		"name"		: 'reverb_predelay_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'reverb_predelay',
		"mod_type"	: 'midi_cc'
	},
	"reverb_size"				: {
		"name"		: 'reverb_size',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"reverb_size_onccN"			: {
		"name"		: 'reverb_size_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'reverb_size',
		"mod_type"	: 'midi_cc'
	},
	"reverb_tone"				: {
		"name"		: 'reverb_tone',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"reverb_tone_onccN"			: {
		"name"		: 'reverb_tone_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'reverb_tone',
		"mod_type"	: 'midi_cc'
	},
	"reverb_type"				: {
		"name"		: 'reverb_type',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['chamber', 'large_hall', 'large_room', 'mid_hall', 'mid_room', 'small_hall', 'small_room'])",
			"type"	: 'string'
		}
	},
	"reverb_wet"				: {
		"name"		: 'reverb_wet',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"reverb_wet_onccN"			: {
		"name"		: 'reverb_wet_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'reverb_wet',
		"mod_type"	: 'midi_cc'
	},
	"static_cyclic_level"		: {
		"name"		: 'static_cyclic_level',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"static_cyclic_time"		: {
		"name"		: 'static_cyclic_time',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"static_filter"				: {
		"name"		: 'static_filter',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"static_level"				: {
		"name"		: 'static_level',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"static_level_onccN"		: {
		"name"		: 'static_level_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'static_level',
		"mod_type"	: 'midi_cc'
	},
	"static_random_level"		: {
		"name"		: 'static_random_level',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"static_random_maxtime"		: {
		"name"		: 'static_random_maxtime',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"static_random_mintime"		: {
		"name"		: 'static_random_mintime',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'float',
			"unit"	: 'seconds'
		}
	},
	"static_stereo"				: {
		"name"		: 'static_stereo',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"static_tone"				: {
		"name"		: 'static_tone',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"strings_number"			: {
		"name"		: 'strings_number',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"strings_wet_onccN"			: {
		"name"		: 'strings_wet_onccN',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"tdfir_dry"					: {
		"name"		: 'tdfir_dry',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"tdfir_dry_onccN"			: {
		"name"		: 'tdfir_dry_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'tdfir_dry',
		"mod_type"	: 'midi_cc'
	},
	"tdfir_gain"				: {
		"name"		: 'tdfir_gain',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"tdfir_impulse"				: {
		"name"		: 'tdfir_impulse',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None
	},
	"tdfir_wet"					: {
		"name"		: 'tdfir_wet',
		"ver"		: 'cakewalk',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {'valid': 'Range(0, 100)'}
	},
	"tdfir_wet_onccN"			: {
		"name"		: 'tdfir_wet_onccN',
		"ver"		: 'unknown',
		"category"	: 'Effects',
		"modulates"	: 'tdfir_wet',
		"mod_type"	: 'midi_cc'
	},
	"type"						: {
		"name"		: 'type',
		"ver"		: 'v2',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['apan', 'comp', 'delay', 'disto', 'eq', 'filter', 'fverb', 'gate', 'limiter', 'lofi', 'mverb', 'phaser', 'static', 'strings', 'tdfir', 'com.mda.Limiter', 'com.mda.Overdrive', 'com.mda.Leslie', 'com.mda.RingMod', 'com.mda.Delay', 'com.mda.Bandisto', 'com.mda.Ambience', 'com.mda.DubDelay', 'com.mda.Detune', 'com.mda.Dither', 'com.mda.Combo', 'com.mda.Degrade', 'com.mda.SubSynth', 'com.mda.RezFilter'])",
			"type"	: 'string'
		}
	},
	"vendor_specific"			: {
		"name"		: 'vendor_specific',
		"ver"		: 'aria',
		"category"	: 'Effects',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"load_mode"					: {
		"name"		: 'load_mode',
		"ver"		: 'cakewalk',
		"category"	: 'Loading',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 1)',
			"type"	: 'integer'
		}
	},
	"load_start"				: {
		"name"		: 'load_start',
		"ver"		: 'cakewalk',
		"category"	: 'Loading',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"load_end"					: {
		"name"		: 'load_end',
		"ver"		: 'cakewalk',
		"category"	: 'Loading',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'integer'
		}
	},
	"sample_quality"			: {
		"name"		: 'sample_quality',
		"ver"		: 'cakewalk',
		"category"	: 'Loading',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 10)',
			"type"	: 'integer'
		}
	},
	"image"						: {
		"name"		: 'image',
		"ver"		: 'cakewalk',
		"category"	: 'Loading',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Any()',
			"type"	: 'string'
		}
	},
	"oscillator"				: {
		"name"		: 'oscillator',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: "Choice(['on', 'off'])",
			"type"	: 'string'
		}
	},
	"oscillator_detune"			: {
		"name"		: 'oscillator_detune',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None
	},
	"oscillator_detune_onccN"	: {
		"name"		: 'oscillator_detune_onccN',
		"ver"		: 'unknown',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: 'oscillator_detune',
		"mod_type"	: 'midi_cc'
	},
	"oscillator_mode"			: {
		"name"		: 'oscillator_mode',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 2)',
			"type"	: 'integer'
		}
	},
	"oscillator_mod_depth"		: {
		"name"		: 'oscillator_mod_depth',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None
	},
	"oscillator_mod_depth_onccN": {
		"name"		: 'oscillator_mod_depth_onccN',
		"ver"		: 'unknown',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: 'oscillator_mod_depth',
		"mod_type"	: 'midi_cc'
	},
	"oscillator_mod_smoothccN"	: {
		"name"		: 'oscillator_mod_smoothccN',
		"ver"		: 'unknown',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: 'oscillator_mod_depth',
		"mod_type"	: 'midi_cc'
	},
	"oscillator_multi"			: {
		"name"		: 'oscillator_multi',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(1, 9)',
			"type"	: 'integer'
		}
	},
	"oscillator_phase"			: {
		"name"		: 'oscillator_phase',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(-1, 360)',
			"type"	: 'float',
			"unit"	: '°'
		}
	},
	"oscillator_quality"		: {
		"name"		: 'oscillator_quality',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None,
		"value"		: {
			"valid"	: 'Range(0, 3)',
			"type"	: 'integer'
		}
	},
	"oscillator_table_size"		: {
		"name"		: 'oscillator_table_size',
		"ver"		: 'cakewalk',
		"category"	: 'Wavetable Oscillator',
		"modulates"	: None,
		"mod_type"	: None
	}
}
