
import http.client
import json
import base64
import subprocess
import tempfile
import os
from pathlib import Path

class DeepSeekPowSolver:
    def __init__(self, token=None):
        if token is None:
            token = "Npa7Umra/HEJAxKzpa+oHE2a2+I8jBaJZRbh2sWPfIj7NZVUcSRn57gXCalBm/2g"
        
        
        if not token.startswith("Bearer "):
        	
            token = f"Bearer {token}"
        
        self.H3 = {
            'User-Agent': "DeepSeek/1.4.2 Android/34",
            'Accept': "application/json",
            'Content-Type': "application/json",
            'x-client-platform': "android",
            'x-client-version': "1.4.2",
            'x-client-locale': "ar",
            'x-rangers-id': "7094179430502815498",
            'authorization': token,
            'accept-charset': "UTF-8"
        }
        
        self.wasm_path = Path(__file__).parent / "solve_levi.wasm"
    
    def H0(self):
        
        conn = http.client.HTTPSConnection("chat.deepseek.com")
        payload = json.dumps({"target_path": "/api/v0/chat/completion"})
        
        try:
            conn.request("POST", "/api/v0/chat/create_pow_challenge", payload, self.H3)
            res = conn.getresponse()
            data = res.read()
            response_json = json.loads(data.decode("utf-8"))
            conn.close()
            
            if response_json.get("code") == 0:
                return response_json["data"]["biz_data"]["challenge"]
            else:
                return None
                
        except Exception as e:
            return None

    def SleviS(self, Fix):
        
        
        skipppp = str(self.wasm_path.absolute())
        
        js_code = f'''
const {{ readFileSync }} = require('fs');

const challenge = "{Fix['challenge']}";
const salt = "{Fix['salt']}";
const difficulty = {Fix['difficulty']};
const expire_at = {Fix['expire_at']};

async function solve() {{
    let wasmBuffer;
    try {{
        wasmBuffer = readFileSync('{skipppp}');
    }} catch (error) {{
        console.error(`[ERROR] لا يمكن قراءة ملف WASM:`, error.message);
        return;
    }}

    const imports = {{ wbg: {{}} }};
    const {{ instance }} = await WebAssembly.instantiate(wasmBuffer, imports);
    const wasm = instance.exports;
    const prefix = `${{salt}}_${{expire_at}}_`;
    
    try {{
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const textEncoder = new TextEncoder();
        const encodeString = (str) => {{
            const buf = textEncoder.encode(str);
            const ptr = wasm.__wbindgen_export_0(buf.length, 1);
            new Uint8Array(wasm.memory.buffer).set(buf, ptr);
            return {{ ptr, len: buf.length }};
        }};

        const {{ ptr: ptr0, len: len0 }} = encodeString(challenge);
        const {{ ptr: ptr1, len: len1 }} = encodeString(prefix);
        
        wasm.wasm_solve(retptr, ptr0, len0, ptr1, len1, difficulty);

        const dataView = new DataView(wasm.memory.buffer);
        const status = dataView.getInt32(retptr + 0, true);
        const value = dataView.getFloat64(retptr + 8, true);
        const answer = Math.round(value);
        
        if (status === 0) {{
            console.log("0");
        }} else {{
            console.log(answer.toString());
        }}
    }} finally {{
        wasm.__wbindgen_add_to_stack_pointer(16);
    }}
}}

solve().catch(console.error);
'''
 # Tele:@Q_B_H       
        try:
            with tempfile.NamedTemporaryFile(mode='w', suffix='.js', delete=False) as f:
                f.write(js_code)
                temp_file = f.name
            
            result = subprocess.run(['node', temp_file], capture_output=True, text=True, timeout=30)
            
            os.unlink(temp_file)
            
            if result.returncode == 0 and result.stdout.strip():
                output = result.stdout.strip()
                try:
                    answer = int(output)
                    if answer > 0:
                        return answer
                except ValueError:
                    lines = output.split('\n')
                    for line in reversed(lines):
                        line = line.strip()
                        if line and line.isdigit():
                            answer = int(line)
                            if answer > 0:
                                return answer
            return None
                
        except subprocess.TimeoutExpired:
            return None
        except Exception as e:
            return None

    def create_Fis(self, Fix, answer):
        
        pow_payload = {
            "algorithm": Fix["algorithm"],
            "challenge": Fix["challenge"],
            "salt": Fix["salt"],
            "answer": answer,
            "signature": Fix["signature"],
            "target_path": Fix["target_path"]
        }
        
        json_str = json.dumps(pow_payload, separators=(',', ':'))
        Fis = base64.b64encode(json_str.encode()).decode()
        
        return Fis

    def FiF(self):
        
        Fix = self.H0()
        if not Fix:
            return None

        answer = self.SleviS(Fix)
        if not answer:
            return None

        Fis = self.create_Fis(Fix, answer)
        
        return Fis
