import os
import sys
import logging

sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

from dotenv import load_dotenv
load_dotenv('..env')

from polytext.loader.base import BaseLoader

plain_text = "Cari lettori e studenti, un testo adatto ad un corso universitario dovrebbe rendere evidente quale sia il suo contributo alla formazione intellettuale e professionale di giovani adulti, cioè come sia in grado di fare acquisire loro nuovi strumenti di ragionamento e nuove capacità di impostare e risolvere problemi. Siamo sicuri che questo testo abbia raggiunto questo obiettivo e che il modo migliore per presentarlo sia tentare di spiegare cosa della genetica affascina noi docenti, cosa ci spinge a continui studi ed approfondimenti per illustrarla nei nostri corsi e perché riteniamo il suo insegnamento fondamentale per la formazione di ricercatori e medici moderni ed utili alla società. Il motivo di fondo è l’intrigante struttura logico-deduttiva della genetica: se i suoi fenomeni potessero essere rappresentati da punti e le connessioni logiche da linee, la genetica non sarebbe né un insieme di punti singoli (pura conoscenza di importanti fenomeni vitali) né una linea continua (serie sequenziale di informazioni più o meno approfondite ed aggiornate). La genetica attrae il nostro interesse perché ci appare come una rete neurale, dove le connessioni logiche fra contenuti rendono quegli stessi contenuti continuamente cambianti e ricchi di nuove implicazioni e significati, ognuno capace di stimolare nuove curiosità e nuove interazioni. Il primo ed importante merito culturale della genetica consiste nell’aver generato ed approfondito la conoscenza del fenomeno evolutivo e di averne dimostrato scientificamente la piena validità. L’evoluzione non è un’ipotesi, né una teoria, come i suoi detrattori ideologici insistono ad affermare senza alcuna prova, ma la cornice di riferimento di tutti i fenomeni vitali, dai molto semplici e piccoli, come i virus, agli organismi superiori e complessi, come l’uomo. L’evoluzione ci racconta la storia della vita sulla terra dal suo inizio, più di tre miliardi di anni or sono, nella sua lenta diversificazione nel corso di milioni di anni, fino a ieri, 30.000 anni fa, quando la specie umana ha dato inizio ad un suo particolare processo biologico, l’evoluzione culturale, che si è diffuso nei cinque continenti. Ogni qual volta uno studioso cerca di capire il perché di strutture e funzioni molecolari, cellulari e dell’intero organismo, trova sempre valide spiegazioni nella logica evolutiva. Questo è anche il primo e più importante contributo dato dalla genetica alla formazione della cultura collettiva moderna ed in particolare a quella di chi sta impegnandosi per diventare biologo o medico.\n\nIn secondo luogo la genetica serve concretamente alle scienze biologiche e mediche perché permette ai ricercatori di progettare esperimenti solidamente fondati sulla procedura scientifica della prova e dell’errore. Molto semplicemente, l’identificazione di “mutanti” per la struttura o la funzione oggetto della ricerca mette a disposizione organismi incapaci di esercitare la funzione “normale”, cioè preziosi strumenti per un solido confronto fra situazioni biologiche opposte e da ciò trarne conclusioni ragionate. Mentre fino a 20 anni fa gli organismi mutanti dovevano essere trovati fra quelli già presenti nello spettro di variabilità esistente in natura, e quindi potevano non essere completamente adatti allo scopo dell’esperimento, oggi, mediante procedure di biotecnologia, si progettano e si costruiscono in laboratorio organismi mutanti perfettamente adatti a servire da controlli negativi. La genetica molecolare ha permesso lo sviluppo di strumenti indispensabili alla conduzione di esperimenti innovativi e competitivi sia nel campo della biologia di base che in quello della ricerca bio-medica e bio-industriale. La conoscenza della genetica quindi è un presupposto fondante della preparazione di un ricercatore moderno.\n\nPer le caratteristiche che le sono proprie, la genetica è anche un terreno su cui basare la formazione del ragionamento clinico, tipico della pratica medica. Le scuole di medicina non dovrebbero produrre iper-specialisti che abbiano accumulato nella loro memoria solo infiniti stereotipi patologici e terapeutici, ma piuttosto medici di base in grado di utilizzare parametri razionali per lo studio del paziente come soggetto unico ed irripetibile. Come la genetica porta a pensare alla diversità biologica come interazione complessa e spesso imprevedibile fra geni ed ambiente, così la medicina dovrebbe riconoscere nel paziente una tipicità unica da inserire nelle infinite integrazioni e gradazioni delle possibilità diagnostiche e terapeutiche. La genetica d’altronde parte dalla complessità e dalle diversità per giungere a modelli sperimentali semplici ed esemplari delle situazioni biologiche sotto studio, in grado di contribuire concretamente all’avanzamento delle conoscenze scientifiche. Allo stesso modo un ragionamento clinico corretto porta ad utilizzare le nuove conoscenze biomediche per risolvere la complessità del paziente ed arrivare efficacemente ad una scelta, la migliore fra quelle possibili, comunque adatta a rispondere ai più diversi bisogni di salute.\n\nLa metodologia di apprendimento che vi proponiamo è la stessa del volume di Biologia Cellulare. Per quanto detto nel primo paragrafo, i capitoli sono tutti fra loro interconnessi, basati sui precedenti e preparatori ai successivi. Abbiamo realizzato ognuno dei capitoli come una guida articolata che porta il lettore dalla curiosità per i fenomeni ereditari di esperienza comune all’apprendimento dei processi più complessi. Nell’affrontare ogni nuovo argomento, vi suggeriamo di chiedervi quali conoscenze abbiate già (vi stupirete nello scoprire quante sono) e quali curiosità e dubbi vi restino, per farvi guidare da questi alla conoscenza di processi genetici articolati ed integrati nel quadro di logiche scientifiche semplici. Vi proponiamo anche di concludere il modulo di apprendimento con una auto-valutazione delle vostre nuove capacità di inquadrare fenomeni e di risolvere problemi genetici. Vi forniamo infine un breve elenco di siti web da cui partire, spinti dalla vostra curiosità e della vostra inventiva, per esplorare nuove conoscenze, approfondire ancora i temi che avete incontrato e quindi per svolgere ricerche in cui vi sentiate protagonisti perché avete saldamente acquisito, anche grazie a questo libro, gli strumenti di conoscenza e di interpretazione della genetica."
html_string = "/Users/andreasolfanelli/Projects/polytext/test_html.html"

def main():
    markdown_output = True
    save_transcript_chunks = True
    source = "local"

    loader = BaseLoader(
        markdown_output=markdown_output,
        save_transcript_chunks=save_transcript_chunks,
        source=source,
    )

    result_dict = loader.get_text(
        input_list=[html_string]
    )
    return result_dict

if __name__ == "__main__":
    main()