"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotSql = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines AWS IoT SQL.
 */
class IotSql {
    /**
     * Uses the original SQL version built on 2015-10-08.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20151008(sql) {
        return new IotSqlImpl('2015-10-08', sql);
    }
    /**
     * Uses the SQL version built on 2016-03-23.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20160323(sql) {
        return new IotSqlImpl('2016-03-23', sql);
    }
    /**
     * Uses the most recent beta SQL version. If you use this version, it might
     * introduce breaking changes to your rules.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVerNewestUnstable(sql) {
        return new IotSqlImpl('beta', sql);
    }
}
exports.IotSql = IotSql;
_a = JSII_RTTI_SYMBOL_1;
IotSql[_a] = { fqn: "@aws-cdk/aws-iot-alpha.IotSql", version: "2.140.0-alpha.0" };
class IotSqlImpl extends IotSql {
    constructor(version, sql) {
        super();
        this.version = version;
        this.sql = sql;
        if (sql === '') {
            throw new Error('IoT SQL string cannot be empty');
        }
    }
    bind(_scope) {
        return {
            awsIotSqlVersion: this.version,
            sql: this.sql,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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