"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const aws_iot_1 = require("aws-cdk-lib/aws-iot");
/**
 * Defines an AWS IoT Rule in this stack.
 */
class TopicRule extends core_1.Resource {
    /**
     * Import an existing AWS IoT Rule provided an ARN
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule).
     */
    static fromTopicRuleArn(scope, id, topicRuleArn) {
        const parts = core_1.Stack.of(scope).splitArn(topicRuleArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parts.resourceName) {
            throw new Error(`Missing topic rule name in ARN: '${topicRuleArn}'`);
        }
        const resourceName = parts.resourceName;
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.topicRuleArn = topicRuleArn;
                this.topicRuleName = resourceName;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: topicRuleArn,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.topicRuleName,
        });
        this.actions = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_alpha_TopicRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TopicRule);
            }
            throw error;
        }
        const sqlConfig = props.sql.bind(this);
        const resource = new aws_iot_1.CfnTopicRule(this, 'Resource', {
            ruleName: this.physicalName,
            topicRulePayload: {
                actions: core_1.Lazy.any({ produce: () => this.actions }),
                awsIotSqlVersion: sqlConfig.awsIotSqlVersion,
                description: props.description,
                errorAction: props.errorAction?._bind(this).configuration,
                ruleDisabled: props.enabled === undefined ? undefined : !props.enabled,
                sql: sqlConfig.sql,
            },
        });
        this.topicRuleArn = this.getResourceArnAttribute(resource.attrArn, {
            service: 'iot',
            resource: 'rule',
            resourceName: this.physicalName,
        });
        this.topicRuleName = this.getResourceNameAttribute(resource.ref);
        props.actions?.forEach(action => {
            this.addAction(action);
        });
    }
    /**
     * Add a action to the topic rule.
     *
     * @param action the action to associate with the topic rule.
     */
    addAction(action) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_alpha_IAction(action);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addAction);
            }
            throw error;
        }
        const { configuration } = action._bind(this);
        const keys = Object.keys(configuration);
        if (keys.length === 0) {
            throw new Error('An action property cannot be an empty object.');
        }
        if (keys.length > 1) {
            throw new Error(`An action property cannot have multiple keys, received: ${keys}`);
        }
        this.actions.push(configuration);
    }
}
exports.TopicRule = TopicRule;
_a = JSII_RTTI_SYMBOL_1;
TopicRule[_a] = { fqn: "@aws-cdk/aws-iot-alpha.TopicRule", version: "2.140.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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