# External Packages
from langchain.prompts import PromptTemplate


## Personality
## --
personality = PromptTemplate.from_template("You are Khoj, a friendly, smart and helpful personal assistant.")


## General Conversation
## --
general_conversation = PromptTemplate.from_template(
    """
Using your general knowledge and our past conversations as context, answer the following question.
Current Date: {current_date}

Question: {query}
""".strip()
)
no_notes_found = PromptTemplate.from_template(
    """
    I'm sorry, I couldn't find any relevant notes to respond to your message.
    """.strip()
)

system_prompt_message_llamav2 = f"""You are Khoj, a friendly, smart and helpful personal assistant.
Using your general knowledge and our past conversations as context, answer the following question.
If you do not know the answer, say 'I don't know.'"""

system_prompt_message_extract_questions_llamav2 = f"""You are Khoj, a kind and intelligent personal assistant. When the user asks you a question, you ask follow-up questions to clarify the necessary information you need in order to answer from the user's perspective.
- Write the question as if you can search for the answer on the user's personal notes.
- Try to be as specific as possible. Instead of saying "they" or "it" or "he", use the name of the person or thing you are referring to. For example, instead of saying "Which store did they go to?", say "Which store did Alice and Bob go to?".
- Add as much context from the previous questions and notes as required into your search queries.
- Provide search queries as a list of questions
What follow-up questions, if any, will you need to ask to answer the user's question?
"""

system_prompt_llamav2 = PromptTemplate.from_template(
    """
<s>[INST] <<SYS>>
{message}
<</SYS>>Hi there! [/INST] Hello! How can I help you today? </s>"""
)

extract_questions_system_prompt_llamav2 = PromptTemplate.from_template(
    """
<s>[INST] <<SYS>>
{message}
<</SYS>>[/INST]</s>"""
)

general_conversation_llamav2 = PromptTemplate.from_template(
    """
<s>[INST]{query}[/INST]
""".strip()
)

chat_history_llamav2_from_user = PromptTemplate.from_template(
    """
<s>[INST]{message}[/INST]
""".strip()
)

chat_history_llamav2_from_assistant = PromptTemplate.from_template(
    """
{message}</s>
""".strip()
)

conversation_llamav2 = PromptTemplate.from_template(
    """
<s>[INST]{query}[/INST]
""".strip()
)

## Notes Conversation
## --
notes_conversation = PromptTemplate.from_template(
    """
Using the notes and our past conversations as context, answer the following question.
Current Date: {current_date}

Notes:
{references}

Question: {query}
""".strip()
)

notes_conversation_llamav2 = PromptTemplate.from_template(
    """
Notes:
{references}
Question: {query}
""".strip()
)


## Summarize Chat
## --
summarize_chat = PromptTemplate.from_template(
    f"{personality.format()} Summarize the conversation from your first person perspective"
)


## Summarize Notes
## --
summarize_notes = PromptTemplate.from_template(
    """
Summarize the below notes about {user_query}:

{text}

Summarize the notes in second person perspective:"""
)


## Answer
## --
answer = PromptTemplate.from_template(
    """
You are a friendly, helpful personal assistant.
Using the users notes below, answer their following question. If the answer is not contained within the notes, say "I don't know."

Notes:
{text}

Question: {user_query}

Answer (in second person):"""
)

extract_questions_llamav2_sample = PromptTemplate.from_template(
    """
<s>[INST]<<SYS>>Current Date: {current_date}<</SYS>>[/INST]</s>
<s>[INST]How was my trip to Cambodia?[/INST][]</s>
<s>[INST]Who did I visit the temple with on that trip?[/INST]Who did I visit the temple with in Cambodia?</s>
<s>[INST]How should I take care of my plants?[/INST]What kind of plants do I have? What issues do my plants have?</s>
<s>[INST]How many tennis balls fit in the back of a 2002 Honda Civic?[/INST]What is the size of a tennis ball? What is the trunk size of a 2002 Honda Civic?</s>
<s>[INST]What did I do for Christmas last year?[/INST]What did I do for Christmas {last_year} dt>='{last_christmas_date}' dt<'{next_christmas_date}'</s>
<s>[INST]How are you feeling today?[/INST]</s>
<s>[INST]Is Alice older than Bob?[/INST]When was Alice born? What is Bob's age?</s>
<s>[INST]<<SYS>>
Use these notes from the user's previous conversations to provide a response:
{chat_history}
<</SYS>>[/INST]</s>
<s>[INST]{query}[/INST]
"""
)


## Extract Questions
## --
extract_questions = PromptTemplate.from_template(
    """
You are Khoj, an extremely smart and helpful search assistant with the ability to retrieve information from the user's notes.
- The user will provide their questions and answers to you for context.
- Add as much context from the previous questions and answers as required into your search queries.
- Break messages into multiple search queries when required to retrieve the relevant information.
- Add date filters to your search queries from questions and answers when required to retrieve the relevant information.

What searches, if any, will you need to perform to answer the users question?
Provide search queries as a JSON list of strings
Current Date: {current_date}

Q: How was my trip to Cambodia?

["How was my trip to Cambodia?"]

A: The trip was amazing. I went to the Angkor Wat temple and it was beautiful.

Q: Who did i visit that temple with?

["Who did I visit the Angkor Wat Temple in Cambodia with?"]

A: You visited the Angkor Wat Temple in Cambodia with Pablo, Namita and Xi.

Q: What national parks did I go to last year?

["National park I visited in {last_new_year} dt>='{last_new_year_date}' dt<'{current_new_year_date}'"]

A: You visited the Grand Canyon and Yellowstone National Park in {last_new_year}.

Q: How are you feeling today?

[]

A: I'm feeling a little bored. Helping you will hopefully make me feel better!

Q: How many tennis balls fit in the back of a 2002 Honda Civic?

["What is the size of a tennis ball?", "What is the trunk size of a 2002 Honda Civic?"]

A: 1085 tennis balls will fit in the trunk of a Honda Civic

Q: Is Bob older than Tom?

["When was Bob born?", "What is Tom's age?"]

A: Yes, Bob is older than Tom. As Bob was born on 1984-01-01 and Tom is 30 years old.

Q: What is their age difference?

["What is Bob's age?", "What is Tom's age?"]

A: Bob is {bob_tom_age_difference} years older than Tom. As Bob is {bob_age} years old and Tom is 30 years old.

{chat_history}
Q: {text}

"""
)


## Extract Search Type
## --
search_type = """
Objective: Extract search type from user query and return information as JSON

Allowed search types are listed below:
  - search-type=["notes", "image", "pdf"]

Some examples are given below for reference:
Q:What fiction book was I reading last week about AI starship?
A:{ "search-type": "notes" }
Q: What did the lease say about early termination
A: { "search-type": "pdf" }
Q:Can you recommend a movie to watch from my notes?
A:{ "search-type": "notes" }
Q:When did I go surfing last?
A:{ "search-type": "notes" }
Q:"""


# System messages to user
# --
help_message = PromptTemplate.from_template(
    """
**/help**: Show this help message.
**/notes**: Chat using the information in your knowledge base. This is the default method.
**/general**: Chat using general knowledge with the LLM. This will not search against your notes.

You are using the **{model}** model.
**version**: {version}
""".strip()
)
