"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cron = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a cron schedule
 */
class Cron {
    /**
     * Create a cron schedule which runs every minute
     */
    static everyMinute() {
        return Cron.schedule({ minute: '*', hour: '*', day: '*', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs every hour
     */
    static hourly() {
        return Cron.schedule({ minute: '0', hour: '*', day: '*', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs every day at midnight
     */
    static daily() {
        return Cron.schedule({ minute: '0', hour: '0', day: '*', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs every week on Sunday
     */
    static weekly() {
        return Cron.schedule({ minute: '0', hour: '0', day: '*', month: '*', weekDay: '0' });
    }
    /**
     * Create a cron schedule which runs first day of every month
     */
    static monthly() {
        return Cron.schedule({ minute: '0', hour: '0', day: '1', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs first day of January every year
     */
    static annually() {
        return Cron.schedule({ minute: '0', hour: '0', day: '1', month: '1', weekDay: '*' });
    }
    /**
     * Create a custom cron schedule from a set of cron fields
     */
    static schedule(options) {
        return new Cron(options);
    }
    ;
    constructor(cronOptions = {}) {
        const minute = fallback(cronOptions.minute, '*');
        const hour = fallback(cronOptions.hour, '*');
        const month = fallback(cronOptions.month, '*');
        const day = fallback(cronOptions.day, '*');
        const weekDay = fallback(cronOptions.weekDay, '*');
        this.expressionString = `${minute} ${hour} ${day} ${month} ${weekDay}`;
    }
}
exports.Cron = Cron;
_a = JSII_RTTI_SYMBOL_1;
Cron[_a] = { fqn: "cdk8s.Cron", version: "2.70.17" };
function fallback(x, def) {
    return x ?? def;
}
//# sourceMappingURL=data:application/json;base64,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