"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiObjectMetadataDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
const resolve_1 = require("./resolve");
/**
 * Object metadata.
 */
class ApiObjectMetadataDefinition {
    constructor(options) {
        this.name = options.name;
        this.labels = { ...(options.labels ?? {}) };
        this.annotations = { ...(options.annotations ?? {}) };
        this.namespace = options.namespace;
        this.finalizers = options.finalizers ? [...options.finalizers] : [];
        this.ownerReferences = options.ownerReferences ? [...options.ownerReferences] : [];
        this.apiObject = options.apiObject;
        this._additionalAttributes = options;
        // otherwise apiObject is passed to the resolving logic, which expectadly fails
        delete this._additionalAttributes.apiObject;
    }
    /**
     * Add a label.
     *
     * @param key - The key.
     * @param value - The value.
     */
    addLabel(key, value) {
        this.labels[key] = value;
    }
    /**
     * @returns a value of a label or undefined
     * @param key the label
     */
    getLabel(key) {
        return this.labels[key];
    }
    /**
     * Add an annotation.
     *
     * @param key - The key.
     * @param value - The value.
     */
    addAnnotation(key, value) {
        this.annotations[key] = value;
    }
    /**
     * Add one or more finalizers.
     *
     * @param finalizers the finalizers
     */
    addFinalizers(...finalizers) {
        this.finalizers.push(...finalizers);
    }
    /**
     * Add an owner.
     *
     * @param owner the owner
     */
    addOwnerReference(owner) {
        this.ownerReferences.push(owner);
    }
    /**
     * Adds an arbitrary key/value to the object metadata.
     * @param key Metadata key
     * @param value Metadata value
     */
    add(key, value) {
        this._additionalAttributes[key] = value;
    }
    /**
     * Synthesizes a k8s ObjectMeta for this metadata set.
     */
    toJson() {
        const sanitize = (x) => (0, _util_1.sanitizeValue)(x, { filterEmptyArrays: true, filterEmptyObjects: true });
        return sanitize((0, resolve_1.resolve)([], {
            ...this._additionalAttributes,
            name: this.name,
            namespace: this.namespace,
            annotations: this.annotations,
            finalizers: this.finalizers,
            ownerReferences: this.ownerReferences,
            labels: this.labels,
        }, this.apiObject));
    }
}
exports.ApiObjectMetadataDefinition = ApiObjectMetadataDefinition;
_a = JSII_RTTI_SYMBOL_1;
ApiObjectMetadataDefinition[_a] = { fqn: "cdk8s.ApiObjectMetadataDefinition", version: "2.70.17" };
//# sourceMappingURL=data:application/json;base64,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