"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import insightproto.proto.jobs.v1.jobs_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class LogEntry(google.protobuf.message.Message):
    """LogEntry represents a single log entry with timestamp and message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TS_FIELD_NUMBER: builtins.int
    MSG_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    msg: builtins.str
    """the log line message"""
    level: builtins.str
    """the log level (e.g. info, debug, error)"""
    @property
    def ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the timestamp of the log line"""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """the labels for the log line"""

    def __init__(
        self,
        *,
        ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        msg: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        level: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ts", b"ts"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["labels", b"labels", "level", b"level", "msg", b"msg", "ts", b"ts"]) -> None: ...

global___LogEntry = LogEntry

@typing.final
class LogDetail(google.protobuf.message.Message):
    """LogDetail contains details for a logs-type timeline event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGS_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    query: builtins.str
    """the query used to capture the logs e.g. the logql"""
    text: builtins.str
    """a text summary of the captured logs"""
    link: builtins.str
    """the link to view the logs in the source"""
    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogEntry]:
        """the captured logs"""

    def __init__(
        self,
        *,
        logs: collections.abc.Iterable[global___LogEntry] | None = ...,
        query: builtins.str = ...,
        text: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["link", b"link", "logs", b"logs", "query", b"query", "text", b"text"]) -> None: ...

global___LogDetail = LogDetail

@typing.final
class Annotations(google.protobuf.message.Message):
    """Annotations represents chart annotations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    START_TIMESTAMP_FIELD_NUMBER: builtins.int
    END_TIMESTAMP_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    Y_AXIS_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """unique identifier for the annotation"""
    type: builtins.str
    """type of annotation: 'line', 'area', 'point'"""
    label: builtins.str
    """display label for the annotation"""
    color: builtins.str
    """color for the annotation (hex, rgb, or CSS variable)"""
    value: builtins.float
    """value for horizontal line annotations"""
    y_axis_id: builtins.str
    """y-axis identifier for dual-axis charts"""
    @property
    def start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """start timestamp for the annotation (required for line/point, optional for area)"""

    @property
    def end_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """end timestamp for area annotations"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        type: builtins.str = ...,
        start_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        label: builtins.str = ...,
        color: builtins.str = ...,
        value: builtins.float | None = ...,
        y_axis_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_end_timestamp", b"_end_timestamp", "_start_timestamp", b"_start_timestamp", "_value", b"_value", "_y_axis_id", b"_y_axis_id", "end_timestamp", b"end_timestamp", "start_timestamp", b"start_timestamp", "value", b"value", "y_axis_id", b"y_axis_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_end_timestamp", b"_end_timestamp", "_start_timestamp", b"_start_timestamp", "_value", b"_value", "_y_axis_id", b"_y_axis_id", "color", b"color", "end_timestamp", b"end_timestamp", "id", b"id", "label", b"label", "start_timestamp", b"start_timestamp", "type", b"type", "value", b"value", "y_axis_id", b"y_axis_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_end_timestamp", b"_end_timestamp"]) -> typing.Literal["end_timestamp"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_start_timestamp", b"_start_timestamp"]) -> typing.Literal["start_timestamp"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_value", b"_value"]) -> typing.Literal["value"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_y_axis_id", b"_y_axis_id"]) -> typing.Literal["y_axis_id"] | None: ...

global___Annotations = Annotations

@typing.final
class Series(google.protobuf.message.Message):
    """Series represents a data series in a chart"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATA_KEY_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    Y_AXIS_ID_FIELD_NUMBER: builtins.int
    STROKE_WIDTH_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    data_key: builtins.str
    """key to identify the data field in MetricData"""
    label: builtins.str
    """display label for the series"""
    type: builtins.str
    """chart type: 'line', 'bar', 'area', 'scatter'"""
    y_axis_id: builtins.str
    """y-axis identifier for dual-axis charts ('left' or 'right')"""
    stroke_width: builtins.int
    """line thickness in pixels"""
    color: builtins.str
    """color for the series (hex, rgb, or CSS variable)"""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """labels attached to the metric as key-value pairs"""

    def __init__(
        self,
        *,
        data_key: builtins.str = ...,
        label: builtins.str = ...,
        type: builtins.str = ...,
        y_axis_id: builtins.str = ...,
        stroke_width: builtins.int = ...,
        color: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["color", b"color", "data_key", b"data_key", "label", b"label", "labels", b"labels", "stroke_width", b"stroke_width", "type", b"type", "y_axis_id", b"y_axis_id"]) -> None: ...

global___Series = Series

@typing.final
class MetricData(google.protobuf.message.Message):
    """MetricData represents metric data points"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ValuesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TS_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def ts(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """timestamp for the data point"""

    @property
    def values(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """key-value pairs of series ids to their string values"""

    def __init__(
        self,
        *,
        ts: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        values: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ts", b"ts"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ts", b"ts", "values", b"values"]) -> None: ...

global___MetricData = MetricData

@typing.final
class Layout(google.protobuf.message.Message):
    """Layout represents chart layout configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LEFT_X_AXIS_LABEL_FIELD_NUMBER: builtins.int
    RIGHT_Y_AXIS_LABEL_FIELD_NUMBER: builtins.int
    left_x_axis_label: builtins.str
    """label for the left/primary y-axis"""
    right_y_axis_label: builtins.str
    """label for the right/secondary y-axis"""
    def __init__(
        self,
        *,
        left_x_axis_label: builtins.str = ...,
        right_y_axis_label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["left_x_axis_label", b"left_x_axis_label", "right_y_axis_label", b"right_y_axis_label"]) -> None: ...

global___Layout = Layout

@typing.final
class MetricDetail(google.protobuf.message.Message):
    """MetricDetail represents the collection ot metric values"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    SERIES_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    LAYOUT_FIELD_NUMBER: builtins.int
    query: builtins.str
    """the query used to capture the metrics"""
    text: builtins.str
    """a text summary of the captured metrics"""
    link: builtins.str
    """the link to view the metrics in the source"""
    title: builtins.str
    """the title of the graph"""
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Annotations]:
        """the list of annotations to attach to the graph"""

    @property
    def series(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Series]:
        """the series to render"""

    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MetricData]:
        """the metric data"""

    @property
    def layout(self) -> global___Layout:
        """the layout customisations"""

    def __init__(
        self,
        *,
        query: builtins.str = ...,
        text: builtins.str = ...,
        link: builtins.str = ...,
        title: builtins.str = ...,
        annotations: collections.abc.Iterable[global___Annotations] | None = ...,
        series: collections.abc.Iterable[global___Series] | None = ...,
        data: collections.abc.Iterable[global___MetricData] | None = ...,
        layout: global___Layout | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_layout", b"_layout", "layout", b"layout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_layout", b"_layout", "annotations", b"annotations", "data", b"data", "layout", b"layout", "link", b"link", "query", b"query", "series", b"series", "text", b"text", "title", b"title"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_layout", b"_layout"]) -> typing.Literal["layout"] | None: ...

global___MetricDetail = MetricDetail

@typing.final
class User(google.protobuf.message.Message):
    """User contains information about a user (author, committer, approver, etc.)"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """display name of the user"""
    user: builtins.str
    """username or handle"""
    image: builtins.str
    """URL to user's profile image/avatar"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        user: builtins.str = ...,
        image: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image", b"image", "name", b"name", "user", b"user"]) -> None: ...

global___User = User

@typing.final
class CodeDetail(google.protobuf.message.Message):
    """CodeDetail contains details for a code-type timeline event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_NAME_FIELD_NUMBER: builtins.int
    FILE_PATH_FIELD_NUMBER: builtins.int
    FILE_TYPE_FIELD_NUMBER: builtins.int
    LINE_START_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    COMMIT_FIELD_NUMBER: builtins.int
    AUTHOR_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    HIGHLIGHTED_LINES_FIELD_NUMBER: builtins.int
    file_name: builtins.str
    """name of the file"""
    file_path: builtins.str
    """full path to the file"""
    file_type: builtins.str
    """file extension or type"""
    line_start: builtins.int
    """starting line number for the code snippet"""
    code: builtins.str
    """the actual code content"""
    commit: builtins.str
    """commit hash or identifier"""
    text: builtins.str
    """descriptive text about the code change"""
    link: builtins.str
    """link to view the code in the source system"""
    @property
    def author(self) -> global___User:
        """author of the code change"""

    @property
    def highlighted_lines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """line numbers to highlight in the code snippet"""

    def __init__(
        self,
        *,
        file_name: builtins.str = ...,
        file_path: builtins.str = ...,
        file_type: builtins.str = ...,
        line_start: builtins.int = ...,
        code: builtins.str = ...,
        commit: builtins.str = ...,
        author: global___User | None = ...,
        text: builtins.str = ...,
        link: builtins.str = ...,
        highlighted_lines: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["author", b"author"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["author", b"author", "code", b"code", "commit", b"commit", "file_name", b"file_name", "file_path", b"file_path", "file_type", b"file_type", "highlighted_lines", b"highlighted_lines", "line_start", b"line_start", "link", b"link", "text", b"text"]) -> None: ...

global___CodeDetail = CodeDetail

@typing.final
class MergeRequestDetail(google.protobuf.message.Message):
    """MergeRequestDetail contains details for a merge-request-type timeline event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUTHOR_FIELD_NUMBER: builtins.int
    APPROVERS_FIELD_NUMBER: builtins.int
    OPENED_FIELD_NUMBER: builtins.int
    MERGED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    status: builtins.str
    """current status: 'open', 'merged', 'closed'"""
    text: builtins.str
    """descriptive text about the merge request"""
    link: builtins.str
    """link to view the merge request"""
    @property
    def author(self) -> global___User:
        """author of the merge request"""

    @property
    def approvers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]:
        """users who approved the merge request"""

    @property
    def opened(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """timestamp when the merge request was opened"""

    @property
    def merged(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """timestamp when the merge request was merged"""

    def __init__(
        self,
        *,
        author: global___User | None = ...,
        approvers: collections.abc.Iterable[global___User] | None = ...,
        opened: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        merged: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: builtins.str = ...,
        text: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["author", b"author", "merged", b"merged", "opened", b"opened"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["approvers", b"approvers", "author", b"author", "link", b"link", "merged", b"merged", "opened", b"opened", "status", b"status", "text", b"text"]) -> None: ...

global___MergeRequestDetail = MergeRequestDetail

@typing.final
class CIDetail(google.protobuf.message.Message):
    """CIDetail contains details for a CI-type timeline event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_ID_FIELD_NUMBER: builtins.int
    JOB_ID_FIELD_NUMBER: builtins.int
    LOG_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    pipeline_id: builtins.str
    """identifier for the CI pipeline"""
    job_id: builtins.str
    """identifier for the specific job within the pipeline"""
    log: builtins.str
    """log output from the CI job"""
    text: builtins.str
    """descriptive text about the CI event"""
    link: builtins.str
    """link to view the CI job details"""
    def __init__(
        self,
        *,
        pipeline_id: builtins.str = ...,
        job_id: builtins.str = ...,
        log: builtins.str = ...,
        text: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["job_id", b"job_id", "link", b"link", "log", b"log", "pipeline_id", b"pipeline_id", "text", b"text"]) -> None: ...

global___CIDetail = CIDetail

@typing.final
class KnowledgeDetail(google.protobuf.message.Message):
    """KnowledgeDetail contains details for a knowledge-type timeline event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    text: builtins.str
    """descriptive text about the knowledge item"""
    link: builtins.str
    """link to the knowledge resource"""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["link", b"link", "text", b"text"]) -> None: ...

global___KnowledgeDetail = KnowledgeDetail

@typing.final
class TicketDetail(google.protobuf.message.Message):
    """TicketDetail contains details for a ticket-type timeline event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    TICKET_ID_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    AUTHOR_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """identifier for the project containing the ticket"""
    ticket_id: builtins.str
    """unique identifier for the ticket"""
    text: builtins.str
    """descriptive text about the ticket"""
    link: builtins.str
    """link to view the ticket"""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """tags or labels associated with the ticket"""

    @property
    def author(self) -> global___User:
        """author or creator of the ticket"""

    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
        ticket_id: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        author: global___User | None = ...,
        text: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["author", b"author"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["author", b"author", "link", b"link", "project_id", b"project_id", "tags", b"tags", "text", b"text", "ticket_id", b"ticket_id"]) -> None: ...

global___TicketDetail = TicketDetail

@typing.final
class TriggerDetail(google.protobuf.message.Message):
    """TriggerDetail contains information about the source of a trigger event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_SOURCE_FIELD_NUMBER: builtins.int
    TRIGGER_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    trigger_source: builtins.str
    """deprecated see trigger"""
    text: builtins.str
    """descriptive text about the trigger event"""
    link: builtins.str
    """link to view the trigger source"""
    @property
    def trigger(self) -> insightproto.proto.jobs.v1.jobs_pb2.Trigger:
        """the trigger info for the investigation"""

    def __init__(
        self,
        *,
        trigger_source: builtins.str = ...,
        trigger: insightproto.proto.jobs.v1.jobs_pb2.Trigger | None = ...,
        text: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["trigger", b"trigger"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["link", b"link", "text", b"text", "trigger", b"trigger", "trigger_source", b"trigger_source"]) -> None: ...

global___TriggerDetail = TriggerDetail

@typing.final
class GenericDetail(google.protobuf.message.Message):
    """GenericDetail contains details for a generic data-type timeline event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    text: builtins.str
    """descriptive text about the generic event"""
    link: builtins.str
    """link to view more details about the event"""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["link", b"link", "text", b"text"]) -> None: ...

global___GenericDetail = GenericDetail
