# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawOpenTelemetryIngestionClient, RawOpenTelemetryIngestionClient


class OpenTelemetryIngestionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOpenTelemetryIngestionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOpenTelemetryIngestionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOpenTelemetryIngestionClient
        """
        return self._raw_client

    def receive_protobuf_traces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            default response

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.open_telemetry_ingestion.receive_protobuf_traces()
        """
        _response = self._raw_client.receive_protobuf_traces(request_options=request_options)
        return _response.data


class AsyncOpenTelemetryIngestionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOpenTelemetryIngestionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOpenTelemetryIngestionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOpenTelemetryIngestionClient
        """
        return self._raw_client

    async def receive_protobuf_traces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            default response

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.open_telemetry_ingestion.receive_protobuf_traces()
        asyncio.run(main())
        """
        _response = await self._raw_client.receive_protobuf_traces(request_options=request_options)
        return _response.data
