# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawRedirectClient, RawRedirectClient


class RedirectClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRedirectClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRedirectClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRedirectClient
        """
        return self._raw_client

    def datasets_redirect(
        self,
        *,
        dataset_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset redirect url

        Parameters
        ----------
        dataset_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.redirect.datasets_redirect(dataset_id='dataset_id', path='path', )
        """
        _response = self._raw_client.datasets_redirect(
            dataset_id=dataset_id, path=path, workspace_name=workspace_name, request_options=request_options
        )
        return _response.data

    def experiments_redirect(
        self,
        *,
        dataset_id: str,
        experiment_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create experiment redirect url

        Parameters
        ----------
        dataset_id : str

        experiment_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.redirect.experiments_redirect(dataset_id='dataset_id', experiment_id='experiment_id', path='path', )
        """
        _response = self._raw_client.experiments_redirect(
            dataset_id=dataset_id,
            experiment_id=experiment_id,
            path=path,
            workspace_name=workspace_name,
            request_options=request_options,
        )
        return _response.data

    def optimizations_redirect(
        self,
        *,
        dataset_id: str,
        optimization_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create optimization redirect url

        Parameters
        ----------
        dataset_id : str

        optimization_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.redirect.optimizations_redirect(dataset_id='dataset_id', optimization_id='optimization_id', path='path', )
        """
        _response = self._raw_client.optimizations_redirect(
            dataset_id=dataset_id,
            optimization_id=optimization_id,
            path=path,
            workspace_name=workspace_name,
            request_options=request_options,
        )
        return _response.data

    def projects_redirect(
        self,
        *,
        trace_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create project redirect url

        Parameters
        ----------
        trace_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.redirect.projects_redirect(trace_id='trace_id', path='path', )
        """
        _response = self._raw_client.projects_redirect(
            trace_id=trace_id, path=path, workspace_name=workspace_name, request_options=request_options
        )
        return _response.data


class AsyncRedirectClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRedirectClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRedirectClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRedirectClient
        """
        return self._raw_client

    async def datasets_redirect(
        self,
        *,
        dataset_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create dataset redirect url

        Parameters
        ----------
        dataset_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.redirect.datasets_redirect(dataset_id='dataset_id', path='path', )
        asyncio.run(main())
        """
        _response = await self._raw_client.datasets_redirect(
            dataset_id=dataset_id, path=path, workspace_name=workspace_name, request_options=request_options
        )
        return _response.data

    async def experiments_redirect(
        self,
        *,
        dataset_id: str,
        experiment_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create experiment redirect url

        Parameters
        ----------
        dataset_id : str

        experiment_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.redirect.experiments_redirect(dataset_id='dataset_id', experiment_id='experiment_id', path='path', )
        asyncio.run(main())
        """
        _response = await self._raw_client.experiments_redirect(
            dataset_id=dataset_id,
            experiment_id=experiment_id,
            path=path,
            workspace_name=workspace_name,
            request_options=request_options,
        )
        return _response.data

    async def optimizations_redirect(
        self,
        *,
        dataset_id: str,
        optimization_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create optimization redirect url

        Parameters
        ----------
        dataset_id : str

        optimization_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.redirect.optimizations_redirect(dataset_id='dataset_id', optimization_id='optimization_id', path='path', )
        asyncio.run(main())
        """
        _response = await self._raw_client.optimizations_redirect(
            dataset_id=dataset_id,
            optimization_id=optimization_id,
            path=path,
            workspace_name=workspace_name,
            request_options=request_options,
        )
        return _response.data

    async def projects_redirect(
        self,
        *,
        trace_id: str,
        path: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create project redirect url

        Parameters
        ----------
        trace_id : str

        path : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.redirect.projects_redirect(trace_id='trace_id', path='path', )
        asyncio.run(main())
        """
        _response = await self._raw_client.projects_redirect(
            trace_id=trace_id, path=path, workspace_name=workspace_name, request_options=request_options
        )
        return _response.data
