# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.bi_information_response import BiInformationResponse
from ..types.spans_count_response import SpansCountResponse
from ..types.trace_count_response import TraceCountResponse
from .raw_client import AsyncRawSystemUsageClient, RawSystemUsageClient


class SystemUsageClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSystemUsageClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSystemUsageClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSystemUsageClient
        """
        return self._raw_client

    def get_dataset_bi_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> BiInformationResponse:
        """
        Get datasets information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Datasets BiInformationResponse resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.system_usage.get_dataset_bi_info()
        """
        _response = self._raw_client.get_dataset_bi_info(request_options=request_options)
        return _response.data

    def get_experiment_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> BiInformationResponse:
        """
        Get experiments information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Experiments BiInformationResponse resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.system_usage.get_experiment_bi_info()
        """
        _response = self._raw_client.get_experiment_bi_info(request_options=request_options)
        return _response.data

    def get_spans_bi_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> BiInformationResponse:
        """
        Get spans information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Spans BiInformationResponse resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.system_usage.get_spans_bi_info()
        """
        _response = self._raw_client.get_spans_bi_info(request_options=request_options)
        return _response.data

    def get_spans_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SpansCountResponse:
        """
        Get spans count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SpansCountResponse
            SpanCountResponse resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.system_usage.get_spans_count_for_workspaces()
        """
        _response = self._raw_client.get_spans_count_for_workspaces(request_options=request_options)
        return _response.data

    def get_traces_bi_info(self, *, request_options: typing.Optional[RequestOptions] = None) -> BiInformationResponse:
        """
        Get traces information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Traces BiInformationResponse resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.system_usage.get_traces_bi_info()
        """
        _response = self._raw_client.get_traces_bi_info(request_options=request_options)
        return _response.data

    def get_traces_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TraceCountResponse:
        """
        Get traces count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TraceCountResponse
            TraceCountResponse resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.system_usage.get_traces_count_for_workspaces()
        """
        _response = self._raw_client.get_traces_count_for_workspaces(request_options=request_options)
        return _response.data


class AsyncSystemUsageClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSystemUsageClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSystemUsageClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSystemUsageClient
        """
        return self._raw_client

    async def get_dataset_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> BiInformationResponse:
        """
        Get datasets information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Datasets BiInformationResponse resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.system_usage.get_dataset_bi_info()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_dataset_bi_info(request_options=request_options)
        return _response.data

    async def get_experiment_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> BiInformationResponse:
        """
        Get experiments information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Experiments BiInformationResponse resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.system_usage.get_experiment_bi_info()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_experiment_bi_info(request_options=request_options)
        return _response.data

    async def get_spans_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> BiInformationResponse:
        """
        Get spans information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Spans BiInformationResponse resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.system_usage.get_spans_bi_info()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_spans_bi_info(request_options=request_options)
        return _response.data

    async def get_spans_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SpansCountResponse:
        """
        Get spans count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SpansCountResponse
            SpanCountResponse resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.system_usage.get_spans_count_for_workspaces()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_spans_count_for_workspaces(request_options=request_options)
        return _response.data

    async def get_traces_bi_info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> BiInformationResponse:
        """
        Get traces information for BI events per user per workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BiInformationResponse
            Traces BiInformationResponse resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.system_usage.get_traces_bi_info()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_traces_bi_info(request_options=request_options)
        return _response.data

    async def get_traces_count_for_workspaces(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TraceCountResponse:
        """
        Get traces count on previous day for all available workspaces

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TraceCountResponse
            TraceCountResponse resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.system_usage.get_traces_count_for_workspaces()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_traces_count_for_workspaces(request_options=request_options)
        return _response.data
