"""
AuraGyt Python SDK
Biometric authentication and identity verification SDK for Python
"""

from .sdk import AuraGytSDK
from .api_client import APIClient
from .exceptions import (
    AuraGytError,
    NetworkError,
    AuthenticationError,
    ValidationError,
    ServiceUnavailableError,
)
from .types import (
    SDKConfig,
    FaceDetectionResult,
    FaceVerificationResult,
    FaceSearchResult,
    FaceSearchMatch,
    LivenessCheckResult,
    EnrollmentResult,
    AuthTokens,
    User,
    RiskScoreResult,
)

# Export modules for advanced usage
from . import face, liveness, authentication, risk

__version__ = "1.0.0"
__all__ = [
    "AuraGytSDK",
    "APIClient",
    "AuraGytError",
    "NetworkError",
    "AuthenticationError",
    "ValidationError",
    "ServiceUnavailableError",
    "SDKConfig",
    "FaceDetectionResult",
    "FaceVerificationResult",
    "FaceSearchResult",
    "FaceSearchMatch",
    "LivenessCheckResult",
    "EnrollmentResult",
    "AuthTokens",
    "User",
    "RiskScoreResult",
    "face",
    "liveness",
    "authentication",
    "risk",
]

