"""
AuraGyt SDK Main Class
Main entry point for the SDK
"""

from .api_client import APIClient
from .face import FaceRecognition
from .liveness import LivenessDetection
from .authentication import Authentication
from .risk import RiskManagement
from .types import SDKConfig


class AuraGytSDK:
    """Main SDK class for AuraGyt biometric authentication"""

    def __init__(self, config: SDKConfig = None):
        """
        Initialize AuraGyt SDK

        Args:
            config: SDK configuration dictionary with optional keys:
                - api_key: API key for authentication
                - base_url: Base URL for API (default: http://localhost:8000)
                - timeout: Request timeout in seconds (default: 30)
                - retries: Number of retries (default: 3)
                - retry_delay: Delay between retries in seconds (default: 1)
                - access_token: Access token for authenticated requests
        """
        if config is None:
            config = {}

        self.api_client = APIClient(config)
        self.face = FaceRecognition(self.api_client)
        self.liveness = LivenessDetection(self.api_client)
        self.auth = Authentication(self.api_client)
        self.risk = RiskManagement(self.api_client)

    @classmethod
    def create(cls, config: SDKConfig = None) -> "AuraGytSDK":
        """
        Create a new SDK instance

        Args:
            config: SDK configuration dictionary

        Returns:
            AuraGytSDK instance
        """
        return cls(config)

