"""
Type definitions for AuraGyt SDK
"""

from typing import Dict, List, Optional, TypedDict, Union
from dataclasses import dataclass


class SDKConfig(TypedDict, total=False):
    """SDK configuration options"""

    api_key: Optional[str]
    base_url: Optional[str]
    timeout: Optional[int]
    retries: Optional[int]
    retry_delay: Optional[int]
    access_token: Optional[str]


@dataclass
class FaceDetectionResult:
    """Face detection result"""

    bbox: List[float]  # [x, y, width, height]
    confidence: float
    landmarks: Optional[List[List[float]]] = None


@dataclass
class FaceVerificationResult:
    """Face verification result"""

    is_match: bool
    similarity_score: float
    threshold: float


@dataclass
class FaceSearchMatch:
    """Face search match result"""

    user_id: str
    similarity_score: float
    template_id: str


@dataclass
class FaceSearchResult:
    """Face search result"""

    matches: List[FaceSearchMatch]


@dataclass
class LivenessCheckResult:
    """Liveness check result"""

    is_live: bool
    liveness_score: float
    challenge_type: Optional[str] = None  # 'blink', 'head_movement', 'none'
    spoofing_detected: bool = False
    spoofing_score: float = 0.0


@dataclass
class EnrollmentResult:
    """Face enrollment result"""

    template_id: str
    quality_score: float
    success: bool


@dataclass
class AuthTokens:
    """Authentication tokens"""

    access_token: str
    refresh_token: str
    token_type: str
    expires_in: int


@dataclass
class User:
    """User information"""

    id: str
    email: str
    is_verified: bool
    is_active: bool


@dataclass
class RiskScoreResult:
    """Risk score result"""

    risk_score: float
    risk_level: str  # 'low', 'medium', 'high'
    factors: Dict[str, float]


