/* File: _eposlhcmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Mon Jan 16 17:30:24 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_eposlhc_error;
static PyObject *_eposlhc_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _eposlhc_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _eposlhc_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _eposlhc_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int float_from_pyobj(float* v,PyObject *obj,const char *errmess) {
    double d=0.0;
    if (double_from_pyobj(&d,obj,errmess)) {
        *v = (float)d;
        return 1;
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(aaset,AASET)(int*);
extern void F_FUNC(hepmcstore,HEPMCSTORE)(void);
extern void F_FUNC(afinal,AFINAL)(void);
extern void F_FUNC(ainit,AINIT)(void);
extern void F_FUNC(aepos,AEPOS)(int*);
extern void F_WRAPPEDFUNC(idtrafo,IDTRAFO)(int*,string,string,int*,size_t,size_t);
extern void F_FUNC(initepos,INITEPOS)(float*,string,int*,int*,int*,size_t);
extern void F_FUNC(initeposevt,INITEPOSEVT)(float*,float*,int*,int*,int*);
extern void F_WRAPPEDFUNC(getcharge,GETCHARGE)(float*,int*);
extern void F_FUNC(xsection,XSECTION)(double*,double*,double*,double*,double*,double*);
extern void F_FUNC(npyrng,NPYRNG)(double*);
extern void F_FUNC(rmmard,RMMARD)(double*,int*,int*);
extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t);
extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** aaset ***********************************/
static char doc_f2py_rout__eposlhc_aaset[] = "\
aaset(iop)\n\nWrapper for ``aaset``.\
\n\nParameters\n----------\n"
"iop : input int";
/* extern void F_FUNC(aaset,AASET)(int*); */
static PyObject *f2py_rout__eposlhc_aaset(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iop = 0;
  PyObject *iop_capi = Py_None;
  static char *capi_kwlist[] = {"iop",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_eposlhc.aaset",\
    capi_kwlist,&iop_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iop */
    f2py_success = int_from_pyobj(&iop,iop_capi,"_eposlhc.aaset() 1st argument (iop) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iop);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iop*/
  /* End of cleaning variable iop */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of aaset ********************************/

/********************************* hepmcstore *********************************/
static char doc_f2py_rout__eposlhc_hepmcstore[] = "\
hepmcstore()\n\nWrapper for ``hepmcstore``.\
\n";
/* extern void F_FUNC(hepmcstore,HEPMCSTORE)(void); */
static PyObject *f2py_rout__eposlhc_hepmcstore(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_eposlhc.hepmcstore",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of hepmcstore *****************************/

/*********************************** afinal ***********************************/
static char doc_f2py_rout__eposlhc_afinal[] = "\
afinal()\n\nWrapper for ``afinal``.\
\n";
/* extern void F_FUNC(afinal,AFINAL)(void); */
static PyObject *f2py_rout__eposlhc_afinal(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_eposlhc.afinal",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of afinal *******************************/

/*********************************** ainit ***********************************/
static char doc_f2py_rout__eposlhc_ainit[] = "\
ainit()\n\nWrapper for ``ainit``.\
\n";
/* extern void F_FUNC(ainit,AINIT)(void); */
static PyObject *f2py_rout__eposlhc_ainit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_eposlhc.ainit",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of ainit ********************************/

/*********************************** aepos ***********************************/
static char doc_f2py_rout__eposlhc_aepos[] = "\
aepos(nin)\n\nWrapper for ``aepos``.\
\n\nParameters\n----------\n"
"nin : input int";
/* extern void F_FUNC(aepos,AEPOS)(int*); */
static PyObject *f2py_rout__eposlhc_aepos(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nin = 0;
  PyObject *nin_capi = Py_None;
  static char *capi_kwlist[] = {"nin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_eposlhc.aepos",\
    capi_kwlist,&nin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nin */
    f2py_success = int_from_pyobj(&nin,nin_capi,"_eposlhc.aepos() 1st argument (nin) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nin);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nin*/
  /* End of cleaning variable nin */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of aepos ********************************/

/********************************** idtrafo **********************************/
static char doc_f2py_rout__eposlhc_idtrafo[] = "\
idtrafo = idtrafo(code1,code2,idi)\n\nWrapper for ``idtrafo``.\
\n\nParameters\n----------\n"
"code1 : input string(len=3)\n"
"code2 : input string(len=3)\n"
"idi : input int\n"
"\nReturns\n-------\n"
"idtrafo : int";
/* extern void F_WRAPPEDFUNC(idtrafo,IDTRAFO)(int*,string,string,int*,size_t,size_t); */
static PyObject *f2py_rout__eposlhc_idtrafo(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,string,string,int*,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int idtrafo = 0;
  string code1 = NULL;
  int slen(code1);
  PyObject *code1_capi = Py_None;
  string code2 = NULL;
  int slen(code2);
  PyObject *code2_capi = Py_None;
  int idi = 0;
  PyObject *idi_capi = Py_None;
  static char *capi_kwlist[] = {"code1","code2","idi",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_eposlhc.idtrafo",\
    capi_kwlist,&code1_capi,&code2_capi,&idi_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable code1 */
  slen(code1) = 3;
  f2py_success = string_from_pyobj(&code1,&slen(code1),"",code1_capi,"string_from_pyobj failed in converting 1st argument `code1' of _eposlhc.idtrafo to C string");
  if (f2py_success) {
  /* Processing variable code2 */
  slen(code2) = 3;
  f2py_success = string_from_pyobj(&code2,&slen(code2),"",code2_capi,"string_from_pyobj failed in converting 2nd argument `code2' of _eposlhc.idtrafo to C string");
  if (f2py_success) {
  /* Processing variable idi */
    f2py_success = int_from_pyobj(&idi,idi_capi,"_eposlhc.idtrafo() 3rd argument (idi) can't be converted to int");
  if (f2py_success) {
  /* Processing variable idtrafo */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&idtrafo,code1,code2,&idi,slen(code1),slen(code2));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",idtrafo);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable idtrafo */
  } /*if (f2py_success) of idi*/
  /* End of cleaning variable idi */
    STRINGFREE(code2);
  }  /*if (f2py_success) of code2*/
  /* End of cleaning variable code2 */
    STRINGFREE(code1);
  }  /*if (f2py_success) of code1*/
  /* End of cleaning variable code1 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of idtrafo *******************************/

/********************************** initepos **********************************/
static char doc_f2py_rout__eposlhc_initepos[] = "\
initepos(emax,datpath,lpath,idbg,iou)\n\nWrapper for ``initepos``.\
\n\nParameters\n----------\n"
"emax : input float\n"
"datpath : input string(len=-1)\n"
"lpath : input int\n"
"idbg : input int\n"
"iou : input int";
/* extern void F_FUNC(initepos,INITEPOS)(float*,string,int*,int*,int*,size_t); */
static PyObject *f2py_rout__eposlhc_initepos(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,string,int*,int*,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  float emax = 0;
  PyObject *emax_capi = Py_None;
  string datpath = NULL;
  int slen(datpath);
  PyObject *datpath_capi = Py_None;
  int lpath = 0;
  PyObject *lpath_capi = Py_None;
  int idbg = 0;
  PyObject *idbg_capi = Py_None;
  int iou = 0;
  PyObject *iou_capi = Py_None;
  static char *capi_kwlist[] = {"emax","datpath","lpath","idbg","iou",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|:_eposlhc.initepos",\
    capi_kwlist,&emax_capi,&datpath_capi,&lpath_capi,&idbg_capi,&iou_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable emax */
    f2py_success = float_from_pyobj(&emax,emax_capi,"_eposlhc.initepos() 1st argument (emax) can't be converted to float");
  if (f2py_success) {
  /* Processing variable datpath */
  slen(datpath) = -1;
  f2py_success = string_from_pyobj(&datpath,&slen(datpath),"",datpath_capi,"string_from_pyobj failed in converting 2nd argument `datpath' of _eposlhc.initepos to C string");
  if (f2py_success) {
  /* Processing variable lpath */
    f2py_success = int_from_pyobj(&lpath,lpath_capi,"_eposlhc.initepos() 3rd argument (lpath) can't be converted to int");
  if (f2py_success) {
  /* Processing variable idbg */
    f2py_success = int_from_pyobj(&idbg,idbg_capi,"_eposlhc.initepos() 4th argument (idbg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iou */
    f2py_success = int_from_pyobj(&iou,iou_capi,"_eposlhc.initepos() 5th argument (iou) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&emax,datpath,&lpath,&idbg,&iou,slen(datpath));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iou*/
  /* End of cleaning variable iou */
  } /*if (f2py_success) of idbg*/
  /* End of cleaning variable idbg */
  } /*if (f2py_success) of lpath*/
  /* End of cleaning variable lpath */
    STRINGFREE(datpath);
  }  /*if (f2py_success) of datpath*/
  /* End of cleaning variable datpath */
  } /*if (f2py_success) of emax*/
  /* End of cleaning variable emax */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of initepos ******************************/

/******************************** initeposevt ********************************/
static char doc_f2py_rout__eposlhc_initeposevt[] = "\
initeposevt(ecm,ela,ippdg,itpdg,ifram)\n\nWrapper for ``initeposevt``.\
\n\nParameters\n----------\n"
"ecm : input float\n"
"ela : input float\n"
"ippdg : input int\n"
"itpdg : input int\n"
"ifram : input int";
/* extern void F_FUNC(initeposevt,INITEPOSEVT)(float*,float*,int*,int*,int*); */
static PyObject *f2py_rout__eposlhc_initeposevt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,float*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  float ecm = 0;
  PyObject *ecm_capi = Py_None;
  float ela = 0;
  PyObject *ela_capi = Py_None;
  int ippdg = 0;
  PyObject *ippdg_capi = Py_None;
  int itpdg = 0;
  PyObject *itpdg_capi = Py_None;
  int ifram = 0;
  PyObject *ifram_capi = Py_None;
  static char *capi_kwlist[] = {"ecm","ela","ippdg","itpdg","ifram",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|:_eposlhc.initeposevt",\
    capi_kwlist,&ecm_capi,&ela_capi,&ippdg_capi,&itpdg_capi,&ifram_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ecm */
    f2py_success = float_from_pyobj(&ecm,ecm_capi,"_eposlhc.initeposevt() 1st argument (ecm) can't be converted to float");
  if (f2py_success) {
  /* Processing variable ela */
    f2py_success = float_from_pyobj(&ela,ela_capi,"_eposlhc.initeposevt() 2nd argument (ela) can't be converted to float");
  if (f2py_success) {
  /* Processing variable ippdg */
    f2py_success = int_from_pyobj(&ippdg,ippdg_capi,"_eposlhc.initeposevt() 3rd argument (ippdg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable itpdg */
    f2py_success = int_from_pyobj(&itpdg,itpdg_capi,"_eposlhc.initeposevt() 4th argument (itpdg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ifram */
    f2py_success = int_from_pyobj(&ifram,ifram_capi,"_eposlhc.initeposevt() 5th argument (ifram) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ecm,&ela,&ippdg,&itpdg,&ifram);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ifram*/
  /* End of cleaning variable ifram */
  } /*if (f2py_success) of itpdg*/
  /* End of cleaning variable itpdg */
  } /*if (f2py_success) of ippdg*/
  /* End of cleaning variable ippdg */
  } /*if (f2py_success) of ela*/
  /* End of cleaning variable ela */
  } /*if (f2py_success) of ecm*/
  /* End of cleaning variable ecm */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of initeposevt *****************************/

/********************************* getcharge *********************************/
static char doc_f2py_rout__eposlhc_getcharge[] = "\
getcharge = getcharge(idpdg)\n\nWrapper for ``getcharge``.\
\n\nParameters\n----------\n"
"idpdg : input int\n"
"\nReturns\n-------\n"
"getcharge : float";
/* extern void F_WRAPPEDFUNC(getcharge,GETCHARGE)(float*,int*); */
static PyObject *f2py_rout__eposlhc_getcharge(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  float getcharge = 0;
  int idpdg = 0;
  PyObject *idpdg_capi = Py_None;
  static char *capi_kwlist[] = {"idpdg",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_eposlhc.getcharge",\
    capi_kwlist,&idpdg_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable idpdg */
    f2py_success = int_from_pyobj(&idpdg,idpdg_capi,"_eposlhc.getcharge() 1st argument (idpdg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable getcharge */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&getcharge,&idpdg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("f",getcharge);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable getcharge */
  } /*if (f2py_success) of idpdg*/
  /* End of cleaning variable idpdg */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of getcharge ******************************/

/********************************** xsection **********************************/
static char doc_f2py_rout__eposlhc_xsection[] = "\
xsigtot,xsigine,xsigela,xsigdd,xsigsd,xsloela = xsection()\n\nWrapper for ``xsection``.\
\n\nReturns\n-------\n"
"xsigtot : float\n"
"xsigine : float\n"
"xsigela : float\n"
"xsigdd : float\n"
"xsigsd : float\n"
"xsloela : float";
/* extern void F_FUNC(xsection,XSECTION)(double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout__eposlhc_xsection(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double xsigtot = 0;
  double xsigine = 0;
  double xsigela = 0;
  double xsigdd = 0;
  double xsigsd = 0;
  double xsloela = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_eposlhc.xsection",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable xsigtot */
  /* Processing variable xsigine */
  /* Processing variable xsigela */
  /* Processing variable xsigdd */
  /* Processing variable xsigsd */
  /* Processing variable xsloela */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&xsigtot,&xsigine,&xsigela,&xsigdd,&xsigsd,&xsloela);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("dddddd",xsigtot,xsigine,xsigela,xsigdd,xsigsd,xsloela);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable xsloela */
  /* End of cleaning variable xsigsd */
  /* End of cleaning variable xsigdd */
  /* End of cleaning variable xsigela */
  /* End of cleaning variable xsigine */
  /* End of cleaning variable xsigtot */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of xsection ******************************/

/*********************************** npyrng ***********************************/
static char doc_f2py_rout__eposlhc_npyrng[] = "\
npyrng(rval)\n\nWrapper for ``npyrng``.\
\n\nParameters\n----------\n"
"rval : input float";
/* extern void F_FUNC(npyrng,NPYRNG)(double*); */
static PyObject *f2py_rout__eposlhc_npyrng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rval = 0;
  PyObject *rval_capi = Py_None;
  static char *capi_kwlist[] = {"rval",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_eposlhc.npyrng",\
    capi_kwlist,&rval_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rval */
    f2py_success = double_from_pyobj(&rval,rval_capi,"_eposlhc.npyrng() 1st argument (rval) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rval);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of rval*/
  /* End of cleaning variable rval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of npyrng *******************************/

/*********************************** rmmard ***********************************/
static char doc_f2py_rout__eposlhc_rmmard[] = "\
rmmard(rvec,lenv,iseq)\n\nWrapper for ``rmmard``.\
\n\nParameters\n----------\n"
"rvec : input rank-1 array('d') with bounds (*)\n"
"lenv : input int\n"
"iseq : input int";
/* extern void F_FUNC(rmmard,RMMARD)(double*,int*,int*); */
static PyObject *f2py_rout__eposlhc_rmmard(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *rvec = NULL;
  npy_intp rvec_Dims[1] = {-1};
  const int rvec_Rank = 1;
  PyArrayObject *capi_rvec_tmp = NULL;
  int capi_rvec_intent = 0;
  PyObject *rvec_capi = Py_None;
  int lenv = 0;
  PyObject *lenv_capi = Py_None;
  int iseq = 0;
  PyObject *iseq_capi = Py_None;
  static char *capi_kwlist[] = {"rvec","lenv","iseq",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_eposlhc.rmmard",\
    capi_kwlist,&rvec_capi,&lenv_capi,&iseq_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rvec */
  ;
  capi_rvec_intent |= F2PY_INTENT_IN;
  capi_rvec_tmp = array_from_pyobj(NPY_DOUBLE,rvec_Dims,rvec_Rank,capi_rvec_intent,rvec_capi);
  if (capi_rvec_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _eposlhc_error,"failed in converting 1st argument `rvec' of _eposlhc.rmmard to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rvec = (double *)(PyArray_DATA(capi_rvec_tmp));

  /* Processing variable lenv */
    f2py_success = int_from_pyobj(&lenv,lenv_capi,"_eposlhc.rmmard() 2nd argument (lenv) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iseq */
    f2py_success = int_from_pyobj(&iseq,iseq_capi,"_eposlhc.rmmard() 3rd argument (iseq) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(rvec,&lenv,&iseq);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iseq*/
  /* End of cleaning variable iseq */
  } /*if (f2py_success) of lenv*/
  /* End of cleaning variable lenv */
  if((PyObject *)capi_rvec_tmp!=rvec_capi) {
    Py_XDECREF(capi_rvec_tmp); }
  }  /*if (capi_rvec_tmp == NULL) ... else of rvec*/
  /* End of cleaning variable rvec */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of rmmard *******************************/

/***************************** chromo_openlogfile *****************************/
static char doc_f2py_rout__eposlhc_chromo_openlogfile[] = "\
chromo_openlogfile(fname,opunit)\n\nWrapper for ``chromo_openlogfile``.\
\n\nParameters\n----------\n"
"fname : input string(len=300)\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t); */
static PyObject *f2py_rout__eposlhc_chromo_openlogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string fname = NULL;
  int slen(fname);
  PyObject *fname_capi = Py_None;
  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"fname","opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_eposlhc.chromo_openlogfile",\
    capi_kwlist,&fname_capi,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fname */
  slen(fname) = 300;
  f2py_success = string_from_pyobj(&fname,&slen(fname),"",fname_capi,"string_from_pyobj failed in converting 1st argument `fname' of _eposlhc.chromo_openlogfile to C string");
  if (f2py_success) {
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_eposlhc.chromo_openlogfile() 2nd argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(fname,&opunit,slen(fname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
    STRINGFREE(fname);
  }  /*if (f2py_success) of fname*/
  /* End of cleaning variable fname */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_openlogfile *************************/

/**************************** chromo_closelogfile ****************************/
static char doc_f2py_rout__eposlhc_chromo_closelogfile[] = "\
chromo_closelogfile(opunit)\n\nWrapper for ``chromo_closelogfile``.\
\n\nParameters\n----------\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*); */
static PyObject *f2py_rout__eposlhc_chromo_closelogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_eposlhc.chromo_closelogfile",\
    capi_kwlist,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_eposlhc.chromo_closelogfile() 1st argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&opunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_closelogfile *************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_cevt_def[] = {
  {"phievt",0,{{-1}},NPY_FLOAT},
  {"nevt",0,{{-1}},NPY_INT},
  {"bimevt",0,{{-1}},NPY_FLOAT},
  {"kolevt",0,{{-1}},NPY_INT},
  {"koievt",0,{{-1}},NPY_INT},
  {"pmxevt",0,{{-1}},NPY_FLOAT},
  {"egyevt",0,{{-1}},NPY_FLOAT},
  {"npjevt",0,{{-1}},NPY_INT},
  {"ntgevt",0,{{-1}},NPY_INT},
  {"npnevt",0,{{-1}},NPY_INT},
  {"nppevt",0,{{-1}},NPY_INT},
  {"ntnevt",0,{{-1}},NPY_INT},
  {"ntpevt",0,{{-1}},NPY_INT},
  {"jpnevt",0,{{-1}},NPY_INT},
  {"jppevt",0,{{-1}},NPY_INT},
  {"jtnevt",0,{{-1}},NPY_INT},
  {"jtpevt",0,{{-1}},NPY_INT},
  {"xbjevt",0,{{-1}},NPY_FLOAT},
  {"qsqevt",0,{{-1}},NPY_FLOAT},
  {"nglevt",0,{{-1}},NPY_INT},
  {"zppevt",0,{{-1}},NPY_FLOAT},
  {"zptevt",0,{{-1}},NPY_FLOAT},
  {"minfra",0,{{-1}},NPY_INT},
  {"maxfra",0,{{-1}},NPY_INT},
  {"kohevt",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cevt(char *phievt,char *nevt,char *bimevt,char *kolevt,char *koievt,char *pmxevt,char *egyevt,char *npjevt,char *ntgevt,char *npnevt,char *nppevt,char *ntnevt,char *ntpevt,char *jpnevt,char *jppevt,char *jtnevt,char *jtpevt,char *xbjevt,char *qsqevt,char *nglevt,char *zppevt,char *zptevt,char *minfra,char *maxfra,char *kohevt) {
  int i_f2py=0;
  f2py_cevt_def[i_f2py++].data = phievt;
  f2py_cevt_def[i_f2py++].data = nevt;
  f2py_cevt_def[i_f2py++].data = bimevt;
  f2py_cevt_def[i_f2py++].data = kolevt;
  f2py_cevt_def[i_f2py++].data = koievt;
  f2py_cevt_def[i_f2py++].data = pmxevt;
  f2py_cevt_def[i_f2py++].data = egyevt;
  f2py_cevt_def[i_f2py++].data = npjevt;
  f2py_cevt_def[i_f2py++].data = ntgevt;
  f2py_cevt_def[i_f2py++].data = npnevt;
  f2py_cevt_def[i_f2py++].data = nppevt;
  f2py_cevt_def[i_f2py++].data = ntnevt;
  f2py_cevt_def[i_f2py++].data = ntpevt;
  f2py_cevt_def[i_f2py++].data = jpnevt;
  f2py_cevt_def[i_f2py++].data = jppevt;
  f2py_cevt_def[i_f2py++].data = jtnevt;
  f2py_cevt_def[i_f2py++].data = jtpevt;
  f2py_cevt_def[i_f2py++].data = xbjevt;
  f2py_cevt_def[i_f2py++].data = qsqevt;
  f2py_cevt_def[i_f2py++].data = nglevt;
  f2py_cevt_def[i_f2py++].data = zppevt;
  f2py_cevt_def[i_f2py++].data = zptevt;
  f2py_cevt_def[i_f2py++].data = minfra;
  f2py_cevt_def[i_f2py++].data = maxfra;
  f2py_cevt_def[i_f2py++].data = kohevt;
}
extern void F_FUNC(f2pyinitcevt,F2PYINITCEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cevt(void) {
  F_FUNC(f2pyinitcevt,F2PYINITCEVT)(f2py_setup_cevt);
}

static FortranDataDef f2py_c2evt_def[] = {
  {"ng1evt",0,{{-1}},NPY_INT},
  {"ng2evt",0,{{-1}},NPY_INT},
  {"rglevt",0,{{-1}},NPY_FLOAT},
  {"sglevt",0,{{-1}},NPY_FLOAT},
  {"eglevt",0,{{-1}},NPY_FLOAT},
  {"fglevt",0,{{-1}},NPY_FLOAT},
  {"ikoevt",0,{{-1}},NPY_INT},
  {"typevt",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_c2evt(char *ng1evt,char *ng2evt,char *rglevt,char *sglevt,char *eglevt,char *fglevt,char *ikoevt,char *typevt) {
  int i_f2py=0;
  f2py_c2evt_def[i_f2py++].data = ng1evt;
  f2py_c2evt_def[i_f2py++].data = ng2evt;
  f2py_c2evt_def[i_f2py++].data = rglevt;
  f2py_c2evt_def[i_f2py++].data = sglevt;
  f2py_c2evt_def[i_f2py++].data = eglevt;
  f2py_c2evt_def[i_f2py++].data = fglevt;
  f2py_c2evt_def[i_f2py++].data = ikoevt;
  f2py_c2evt_def[i_f2py++].data = typevt;
}
extern void F_FUNC(f2pyinitc2evt,F2PYINITC2EVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_c2evt(void) {
  F_FUNC(f2pyinitc2evt,F2PYINITC2EVT)(f2py_setup_c2evt);
}

static FortranDataDef f2py_cptl_def[] = {
  {"nptl",0,{{-1}},NPY_INT},
  {"pptl",2,{{5,200000}},NPY_FLOAT},
  {"iorptl",1,{{200000}},NPY_INT},
  {"idptl",1,{{200000}},NPY_INT},
  {"istptl",1,{{200000}},NPY_INT},
  {"tivptl",2,{{2,200000}},NPY_FLOAT},
  {"ifrptl",2,{{2,200000}},NPY_INT},
  {"jorptl",1,{{200000}},NPY_INT},
  {"xorptl",2,{{4,200000}},NPY_FLOAT},
  {"ibptl",2,{{4,200000}},NPY_INT},
  {"ityptl",1,{{200000}},NPY_INT},
  {NULL}
};
static void f2py_setup_cptl(char *nptl,char *pptl,char *iorptl,char *idptl,char *istptl,char *tivptl,char *ifrptl,char *jorptl,char *xorptl,char *ibptl,char *ityptl) {
  int i_f2py=0;
  f2py_cptl_def[i_f2py++].data = nptl;
  f2py_cptl_def[i_f2py++].data = pptl;
  f2py_cptl_def[i_f2py++].data = iorptl;
  f2py_cptl_def[i_f2py++].data = idptl;
  f2py_cptl_def[i_f2py++].data = istptl;
  f2py_cptl_def[i_f2py++].data = tivptl;
  f2py_cptl_def[i_f2py++].data = ifrptl;
  f2py_cptl_def[i_f2py++].data = jorptl;
  f2py_cptl_def[i_f2py++].data = xorptl;
  f2py_cptl_def[i_f2py++].data = ibptl;
  f2py_cptl_def[i_f2py++].data = ityptl;
}
extern void F_FUNC(f2pyinitcptl,F2PYINITCPTL)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cptl(void) {
  F_FUNC(f2pyinitcptl,F2PYINITCPTL)(f2py_setup_cptl);
}

static FortranDataDef f2py_c1ptl_def[] = {
  {"ekievt",0,{{-1}},NPY_FLOAT},
  {"itsptl",1,{{200000}},NPY_INT},
  {NULL}
};
static void f2py_setup_c1ptl(char *ekievt,char *itsptl) {
  int i_f2py=0;
  f2py_c1ptl_def[i_f2py++].data = ekievt;
  f2py_c1ptl_def[i_f2py++].data = itsptl;
}
extern void F_FUNC(f2pyinitc1ptl,F2PYINITC1PTL)(void(*)(char*,char*));
static void f2py_init_c1ptl(void) {
  F_FUNC(f2pyinitc1ptl,F2PYINITC1PTL)(f2py_setup_c1ptl);
}

static FortranDataDef f2py_c2ptl_def[] = {
  {"iaaptl",1,{{200000}},NPY_INT},
  {"radptl",1,{{200000}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_c2ptl(char *iaaptl,char *radptl) {
  int i_f2py=0;
  f2py_c2ptl_def[i_f2py++].data = iaaptl;
  f2py_c2ptl_def[i_f2py++].data = radptl;
}
extern void F_FUNC(f2pyinitc2ptl,F2PYINITC2PTL)(void(*)(char*,char*));
static void f2py_init_c2ptl(void) {
  F_FUNC(f2pyinitc2ptl,F2PYINITC2PTL)(f2py_setup_c2ptl);
}

static FortranDataDef f2py_c3ptl_def[] = {
  {"desptl",1,{{200000}},NPY_FLOAT},
  {"dezptl",1,{{200000}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_c3ptl(char *desptl,char *dezptl) {
  int i_f2py=0;
  f2py_c3ptl_def[i_f2py++].data = desptl;
  f2py_c3ptl_def[i_f2py++].data = dezptl;
}
extern void F_FUNC(f2pyinitc3ptl,F2PYINITC3PTL)(void(*)(char*,char*));
static void f2py_init_c3ptl(void) {
  F_FUNC(f2pyinitc3ptl,F2PYINITC3PTL)(f2py_setup_c3ptl);
}

static FortranDataDef f2py_c4ptl_def[] = {
  {"nptlbd",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_c4ptl(char *nptlbd) {
  int i_f2py=0;
  f2py_c4ptl_def[i_f2py++].data = nptlbd;
}
extern void F_FUNC(f2pyinitc4ptl,F2PYINITC4PTL)(void(*)(char*));
static void f2py_init_c4ptl(void) {
  F_FUNC(f2pyinitc4ptl,F2PYINITC4PTL)(f2py_setup_c4ptl);
}

static FortranDataDef f2py_c6ptl_def[] = {
  {"rinptl",1,{{200000}},NPY_FLOAT},
  {"vrad",0,{{-1}},NPY_FLOAT},
  {"inbxxx",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_c6ptl(char *rinptl,char *vrad,char *inbxxx) {
  int i_f2py=0;
  f2py_c6ptl_def[i_f2py++].data = rinptl;
  f2py_c6ptl_def[i_f2py++].data = vrad;
  f2py_c6ptl_def[i_f2py++].data = inbxxx;
}
extern void F_FUNC(f2pyinitc6ptl,F2PYINITC6PTL)(void(*)(char*,char*,char*));
static void f2py_init_c6ptl(void) {
  F_FUNC(f2pyinitc6ptl,F2PYINITC6PTL)(f2py_setup_c6ptl);
}

static FortranDataDef f2py_c8ptl_def[] = {
  {"qsqptl",1,{{200000}},NPY_FLOAT},
  {"zpaptl",2,{{2,200000}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_c8ptl(char *qsqptl,char *zpaptl) {
  int i_f2py=0;
  f2py_c8ptl_def[i_f2py++].data = qsqptl;
  f2py_c8ptl_def[i_f2py++].data = zpaptl;
}
extern void F_FUNC(f2pyinitc8ptl,F2PYINITC8PTL)(void(*)(char*,char*));
static void f2py_init_c8ptl(void) {
  F_FUNC(f2pyinitc8ptl,F2PYINITC8PTL)(f2py_setup_c8ptl);
}

static FortranDataDef f2py_hepevt_def[] = {
  {"nevhep",0,{{-1}},NPY_INT},
  {"nhep",0,{{-1}},NPY_INT},
  {"isthep",1,{{9990}},NPY_INT},
  {"idhep",1,{{9990}},NPY_INT},
  {"jmohep",2,{{2,9990}},NPY_INT},
  {"jdahep",2,{{2,9990}},NPY_INT},
  {"phep",2,{{5,9990}},NPY_DOUBLE},
  {"vhep",2,{{4,9990}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepevt(char *nevhep,char *nhep,char *isthep,char *idhep,char *jmohep,char *jdahep,char *phep,char *vhep) {
  int i_f2py=0;
  f2py_hepevt_def[i_f2py++].data = nevhep;
  f2py_hepevt_def[i_f2py++].data = nhep;
  f2py_hepevt_def[i_f2py++].data = isthep;
  f2py_hepevt_def[i_f2py++].data = idhep;
  f2py_hepevt_def[i_f2py++].data = jmohep;
  f2py_hepevt_def[i_f2py++].data = jdahep;
  f2py_hepevt_def[i_f2py++].data = phep;
  f2py_hepevt_def[i_f2py++].data = vhep;
}
extern void F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepevt(void) {
  F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(f2py_setup_hepevt);
}

static FortranDataDef f2py_files_def[] = {
  {"ifop",0,{{-1}},NPY_INT},
  {"ifmt",0,{{-1}},NPY_INT},
  {"ifch",0,{{-1}},NPY_INT},
  {"ifcx",0,{{-1}},NPY_INT},
  {"ifhi",0,{{-1}},NPY_INT},
  {"ifdt",0,{{-1}},NPY_INT},
  {"ifcp",0,{{-1}},NPY_INT},
  {"ifdr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_files(char *ifop,char *ifmt,char *ifch,char *ifcx,char *ifhi,char *ifdt,char *ifcp,char *ifdr) {
  int i_f2py=0;
  f2py_files_def[i_f2py++].data = ifop;
  f2py_files_def[i_f2py++].data = ifmt;
  f2py_files_def[i_f2py++].data = ifch;
  f2py_files_def[i_f2py++].data = ifcx;
  f2py_files_def[i_f2py++].data = ifhi;
  f2py_files_def[i_f2py++].data = ifdt;
  f2py_files_def[i_f2py++].data = ifcp;
  f2py_files_def[i_f2py++].data = ifdr;
}
extern void F_FUNC(f2pyinitfiles,F2PYINITFILES)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_files(void) {
  F_FUNC(f2pyinitfiles,F2PYINITFILES)(f2py_setup_files);
}

static FortranDataDef f2py_files2_def[] = {
  {"ifin",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_files2(char *ifin) {
  int i_f2py=0;
  f2py_files2_def[i_f2py++].data = ifin;
}
extern void F_FUNC(f2pyinitfiles2,F2PYINITFILES2)(void(*)(char*));
static void f2py_init_files2(void) {
  F_FUNC(f2pyinitfiles2,F2PYINITFILES2)(f2py_setup_files2);
}

static FortranDataDef f2py_fname_def[] = {
  {"fnch",1,{{500}},NPY_STRING},
  {"fnhi",1,{{500}},NPY_STRING},
  {"fndt",1,{{500}},NPY_STRING},
  {"fnii",1,{{500}},NPY_STRING},
  {"fnid",1,{{500}},NPY_STRING},
  {"fnie",1,{{500}},NPY_STRING},
  {"fnrj",1,{{500}},NPY_STRING},
  {"fnmt",1,{{500}},NPY_STRING},
  {"fngrv",1,{{500}},NPY_STRING},
  {"fncp",1,{{500}},NPY_STRING},
  {"fnnx",1,{{500}},NPY_STRING},
  {"fncs",1,{{500}},NPY_STRING},
  {"fndr",1,{{500}},NPY_STRING},
  {"fnhpf",1,{{500}},NPY_STRING},
  {NULL}
};
static void f2py_setup_fname(char *fnch,char *fnhi,char *fndt,char *fnii,char *fnid,char *fnie,char *fnrj,char *fnmt,char *fngrv,char *fncp,char *fnnx,char *fncs,char *fndr,char *fnhpf) {
  int i_f2py=0;
  f2py_fname_def[i_f2py++].data = fnch;
  f2py_fname_def[i_f2py++].data = fnhi;
  f2py_fname_def[i_f2py++].data = fndt;
  f2py_fname_def[i_f2py++].data = fnii;
  f2py_fname_def[i_f2py++].data = fnid;
  f2py_fname_def[i_f2py++].data = fnie;
  f2py_fname_def[i_f2py++].data = fnrj;
  f2py_fname_def[i_f2py++].data = fnmt;
  f2py_fname_def[i_f2py++].data = fngrv;
  f2py_fname_def[i_f2py++].data = fncp;
  f2py_fname_def[i_f2py++].data = fnnx;
  f2py_fname_def[i_f2py++].data = fncs;
  f2py_fname_def[i_f2py++].data = fndr;
  f2py_fname_def[i_f2py++].data = fnhpf;
}
extern void F_FUNC(f2pyinitfname,F2PYINITFNAME)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_fname(void) {
  F_FUNC(f2pyinitfname,F2PYINITFNAME)(f2py_setup_fname);
}

static FortranDataDef f2py_nfname_def[] = {
  {"nfnch",0,{{-1}},NPY_INT},
  {"nfnhi",0,{{-1}},NPY_INT},
  {"nfndt",0,{{-1}},NPY_INT},
  {"nfnii",0,{{-1}},NPY_INT},
  {"nfnid",0,{{-1}},NPY_INT},
  {"nfnie",0,{{-1}},NPY_INT},
  {"nfnrj",0,{{-1}},NPY_INT},
  {"nfnmt",0,{{-1}},NPY_INT},
  {"nfngrv",0,{{-1}},NPY_INT},
  {"nfncp",0,{{-1}},NPY_INT},
  {"nfnnx",0,{{-1}},NPY_INT},
  {"nfncs",0,{{-1}},NPY_INT},
  {"nfndr",0,{{-1}},NPY_INT},
  {"nfnhpf",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_nfname(char *nfnch,char *nfnhi,char *nfndt,char *nfnii,char *nfnid,char *nfnie,char *nfnrj,char *nfnmt,char *nfngrv,char *nfncp,char *nfnnx,char *nfncs,char *nfndr,char *nfnhpf) {
  int i_f2py=0;
  f2py_nfname_def[i_f2py++].data = nfnch;
  f2py_nfname_def[i_f2py++].data = nfnhi;
  f2py_nfname_def[i_f2py++].data = nfndt;
  f2py_nfname_def[i_f2py++].data = nfnii;
  f2py_nfname_def[i_f2py++].data = nfnid;
  f2py_nfname_def[i_f2py++].data = nfnie;
  f2py_nfname_def[i_f2py++].data = nfnrj;
  f2py_nfname_def[i_f2py++].data = nfnmt;
  f2py_nfname_def[i_f2py++].data = nfngrv;
  f2py_nfname_def[i_f2py++].data = nfncp;
  f2py_nfname_def[i_f2py++].data = nfnnx;
  f2py_nfname_def[i_f2py++].data = nfncs;
  f2py_nfname_def[i_f2py++].data = nfndr;
  f2py_nfname_def[i_f2py++].data = nfnhpf;
}
extern void F_FUNC(f2pyinitnfname,F2PYINITNFNAME)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_nfname(void) {
  F_FUNC(f2pyinitnfname,F2PYINITNFNAME)(f2py_setup_nfname);
}

static FortranDataDef f2py_fname2_def[] = {
  {"fnin",1,{{500}},NPY_STRING},
  {NULL}
};
static void f2py_setup_fname2(char *fnin) {
  int i_f2py=0;
  f2py_fname2_def[i_f2py++].data = fnin;
}
extern void F_FUNC(f2pyinitfname2,F2PYINITFNAME2)(void(*)(char*));
static void f2py_init_fname2(void) {
  F_FUNC(f2pyinitfname2,F2PYINITFNAME2)(f2py_setup_fname2);
}

static FortranDataDef f2py_nfname2_def[] = {
  {"nfnin",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_nfname2(char *nfnin) {
  int i_f2py=0;
  f2py_nfname2_def[i_f2py++].data = nfnin;
}
extern void F_FUNC(f2pyinitnfname2,F2PYINITNFNAME2)(void(*)(char*));
static void f2py_init_nfname2(void) {
  F_FUNC(f2pyinitnfname2,F2PYINITNFNAME2)(f2py_setup_nfname2);
}

static FortranDataDef f2py_resc2_def[] = {
  {"delvol",0,{{-1}},NPY_FLOAT},
  {"deleps",0,{{-1}},NPY_FLOAT},
  {"dlzeta",0,{{-1}},NPY_FLOAT},
  {"etafac",0,{{-1}},NPY_FLOAT},
  {"facnuc",0,{{-1}},NPY_FLOAT},
  {"taurea",0,{{-1}},NPY_FLOAT},
  {"epscri",1,{{3}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_resc2(char *delvol,char *deleps,char *dlzeta,char *etafac,char *facnuc,char *taurea,char *epscri) {
  int i_f2py=0;
  f2py_resc2_def[i_f2py++].data = delvol;
  f2py_resc2_def[i_f2py++].data = deleps;
  f2py_resc2_def[i_f2py++].data = dlzeta;
  f2py_resc2_def[i_f2py++].data = etafac;
  f2py_resc2_def[i_f2py++].data = facnuc;
  f2py_resc2_def[i_f2py++].data = taurea;
  f2py_resc2_def[i_f2py++].data = epscri;
}
extern void F_FUNC(f2pyinitresc2,F2PYINITRESC2)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_resc2(void) {
  F_FUNC(f2pyinitresc2,F2PYINITRESC2)(f2py_setup_resc2);
}

static FortranDataDef f2py_resc4_def[] = {
  {"epsdfm",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_resc4(char *epsdfm) {
  int i_f2py=0;
  f2py_resc4_def[i_f2py++].data = epsdfm;
}
extern void F_FUNC(f2pyinitresc4,F2PYINITRESC4)(void(*)(char*));
static void f2py_init_resc4(void) {
  F_FUNC(f2pyinitresc4,F2PYINITRESC4)(f2py_setup_resc4);
}

static FortranDataDef f2py_hydr1_def[] = {
  {"hydt",1,{{3}},NPY_STRING},
  {NULL}
};
static void f2py_setup_hydr1(char *hydt) {
  int i_f2py=0;
  f2py_hydr1_def[i_f2py++].data = hydt;
}
extern void F_FUNC(f2pyinithydr1,F2PYINITHYDR1)(void(*)(char*));
static void f2py_init_hydr1(void) {
  F_FUNC(f2pyinithydr1,F2PYINITHYDR1)(f2py_setup_hydr1);
}

static FortranDataDef f2py_frag1_def[] = {
  {"ndecay",0,{{-1}},NPY_INT},
  {"maxres",0,{{-1}},NPY_INT},
  {"pud",0,{{-1}},NPY_FLOAT},
  {"pmqu",0,{{-1}},NPY_FLOAT},
  {"pmqd",0,{{-1}},NPY_FLOAT},
  {"pmqs",0,{{-1}},NPY_FLOAT},
  {"pmqc",0,{{-1}},NPY_FLOAT},
  {"pmqq",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_frag1(char *ndecay,char *maxres,char *pud,char *pmqu,char *pmqd,char *pmqs,char *pmqc,char *pmqq) {
  int i_f2py=0;
  f2py_frag1_def[i_f2py++].data = ndecay;
  f2py_frag1_def[i_f2py++].data = maxres;
  f2py_frag1_def[i_f2py++].data = pud;
  f2py_frag1_def[i_f2py++].data = pmqu;
  f2py_frag1_def[i_f2py++].data = pmqd;
  f2py_frag1_def[i_f2py++].data = pmqs;
  f2py_frag1_def[i_f2py++].data = pmqc;
  f2py_frag1_def[i_f2py++].data = pmqq;
}
extern void F_FUNC(f2pyinitfrag1,F2PYINITFRAG1)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_frag1(void) {
  F_FUNC(f2pyinitfrag1,F2PYINITFRAG1)(f2py_setup_frag1);
}

static FortranDataDef f2py_frag2_def[] = {
  {"pdiqua",0,{{-1}},NPY_FLOAT},
  {"delrex",0,{{-1}},NPY_FLOAT},
  {"ptfraqq",0,{{-1}},NPY_FLOAT},
  {"ptfra",0,{{-1}},NPY_FLOAT},
  {"ptfrasr",0,{{-1}},NPY_FLOAT},
  {"ioptf",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_frag2(char *pdiqua,char *delrex,char *ptfraqq,char *ptfra,char *ptfrasr,char *ioptf) {
  int i_f2py=0;
  f2py_frag2_def[i_f2py++].data = pdiqua;
  f2py_frag2_def[i_f2py++].data = delrex;
  f2py_frag2_def[i_f2py++].data = ptfraqq;
  f2py_frag2_def[i_f2py++].data = ptfra;
  f2py_frag2_def[i_f2py++].data = ptfrasr;
  f2py_frag2_def[i_f2py++].data = ioptf;
}
extern void F_FUNC(f2pyinitfrag2,F2PYINITFRAG2)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_frag2(void) {
  F_FUNC(f2pyinitfrag2,F2PYINITFRAG2)(f2py_setup_frag2);
}

static FortranDataDef f2py_frag3_def[] = {
  {"aouni",0,{{-1}},NPY_FLOAT},
  {"pbreak",0,{{-1}},NPY_FLOAT},
  {"fkappa",0,{{-1}},NPY_FLOAT},
  {"itflav",0,{{-1}},NPY_INT},
  {"strcut",0,{{-1}},NPY_FLOAT},
  {"diqcut",0,{{-1}},NPY_FLOAT},
  {"fkappag",0,{{-1}},NPY_FLOAT},
  {"pbreakg",0,{{-1}},NPY_FLOAT},
  {"zetacut",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_frag3(char *aouni,char *pbreak,char *fkappa,char *itflav,char *strcut,char *diqcut,char *fkappag,char *pbreakg,char *zetacut) {
  int i_f2py=0;
  f2py_frag3_def[i_f2py++].data = aouni;
  f2py_frag3_def[i_f2py++].data = pbreak;
  f2py_frag3_def[i_f2py++].data = fkappa;
  f2py_frag3_def[i_f2py++].data = itflav;
  f2py_frag3_def[i_f2py++].data = strcut;
  f2py_frag3_def[i_f2py++].data = diqcut;
  f2py_frag3_def[i_f2py++].data = fkappag;
  f2py_frag3_def[i_f2py++].data = pbreakg;
  f2py_frag3_def[i_f2py++].data = zetacut;
}
extern void F_FUNC(f2pyinitfrag3,F2PYINITFRAG3)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_frag3(void) {
  F_FUNC(f2pyinitfrag3,F2PYINITFRAG3)(f2py_setup_frag3);
}

static FortranDataDef f2py_frag4_def[] = {
  {"difud",0,{{-1}},NPY_FLOAT},
  {"difus",0,{{-1}},NPY_FLOAT},
  {"difuc",0,{{-1}},NPY_FLOAT},
  {"pudd",0,{{-1}},NPY_FLOAT},
  {"puds",0,{{-1}},NPY_FLOAT},
  {"pudc",0,{{-1}},NPY_FLOAT},
  {"difuuu",0,{{-1}},NPY_FLOAT},
  {"difuud",0,{{-1}},NPY_FLOAT},
  {"difuus",0,{{-1}},NPY_FLOAT},
  {"difuuc",0,{{-1}},NPY_FLOAT},
  {"difudd",0,{{-1}},NPY_FLOAT},
  {"difuds",0,{{-1}},NPY_FLOAT},
  {"difudc",0,{{-1}},NPY_FLOAT},
  {"difuss",0,{{-1}},NPY_FLOAT},
  {"difusc",0,{{-1}},NPY_FLOAT},
  {"difucc",0,{{-1}},NPY_FLOAT},
  {"nrflav",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_frag4(char *difud,char *difus,char *difuc,char *pudd,char *puds,char *pudc,char *difuuu,char *difuud,char *difuus,char *difuuc,char *difudd,char *difuds,char *difudc,char *difuss,char *difusc,char *difucc,char *nrflav) {
  int i_f2py=0;
  f2py_frag4_def[i_f2py++].data = difud;
  f2py_frag4_def[i_f2py++].data = difus;
  f2py_frag4_def[i_f2py++].data = difuc;
  f2py_frag4_def[i_f2py++].data = pudd;
  f2py_frag4_def[i_f2py++].data = puds;
  f2py_frag4_def[i_f2py++].data = pudc;
  f2py_frag4_def[i_f2py++].data = difuuu;
  f2py_frag4_def[i_f2py++].data = difuud;
  f2py_frag4_def[i_f2py++].data = difuus;
  f2py_frag4_def[i_f2py++].data = difuuc;
  f2py_frag4_def[i_f2py++].data = difudd;
  f2py_frag4_def[i_f2py++].data = difuds;
  f2py_frag4_def[i_f2py++].data = difudc;
  f2py_frag4_def[i_f2py++].data = difuss;
  f2py_frag4_def[i_f2py++].data = difusc;
  f2py_frag4_def[i_f2py++].data = difucc;
  f2py_frag4_def[i_f2py++].data = nrflav;
}
extern void F_FUNC(f2pyinitfrag4,F2PYINITFRAG4)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_frag4(void) {
  F_FUNC(f2pyinitfrag4,F2PYINITFRAG4)(f2py_setup_frag4);
}

static FortranDataDef f2py_frag5_def[] = {
  {"qmass",1,{{7}},NPY_FLOAT},
  {"isospin",1,{{7}},NPY_INT},
  {NULL}
};
static void f2py_setup_frag5(char *qmass,char *isospin) {
  int i_f2py=0;
  f2py_frag5_def[i_f2py++].data = qmass;
  f2py_frag5_def[i_f2py++].data = isospin;
}
extern void F_FUNC(f2pyinitfrag5,F2PYINITFRAG5)(void(*)(char*,char*));
static void f2py_init_frag5(void) {
  F_FUNC(f2pyinitfrag5,F2PYINITFRAG5)(f2py_setup_frag5);
}

static FortranDataDef f2py_hadr1_def[] = {
  {"pnll",0,{{-1}},NPY_FLOAT},
  {"ptq",0,{{-1}},NPY_FLOAT},
  {"exmass",0,{{-1}},NPY_FLOAT},
  {"cutmss",0,{{-1}},NPY_FLOAT},
  {"wproj",0,{{-1}},NPY_FLOAT},
  {"wtarg",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr1(char *pnll,char *ptq,char *exmass,char *cutmss,char *wproj,char *wtarg) {
  int i_f2py=0;
  f2py_hadr1_def[i_f2py++].data = pnll;
  f2py_hadr1_def[i_f2py++].data = ptq;
  f2py_hadr1_def[i_f2py++].data = exmass;
  f2py_hadr1_def[i_f2py++].data = cutmss;
  f2py_hadr1_def[i_f2py++].data = wproj;
  f2py_hadr1_def[i_f2py++].data = wtarg;
}
extern void F_FUNC(f2pyinithadr1,F2PYINITHADR1)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr1(void) {
  F_FUNC(f2pyinithadr1,F2PYINITHADR1)(f2py_setup_hadr1);
}

static FortranDataDef f2py_hadr10_def[] = {
  {"rstrau",1,{{4}},NPY_FLOAT},
  {"rstrad",1,{{4}},NPY_FLOAT},
  {"rstras",1,{{4}},NPY_FLOAT},
  {"rstrac",1,{{4}},NPY_FLOAT},
  {"rstrasi",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr10(char *rstrau,char *rstrad,char *rstras,char *rstrac,char *rstrasi) {
  int i_f2py=0;
  f2py_hadr10_def[i_f2py++].data = rstrau;
  f2py_hadr10_def[i_f2py++].data = rstrad;
  f2py_hadr10_def[i_f2py++].data = rstras;
  f2py_hadr10_def[i_f2py++].data = rstrac;
  f2py_hadr10_def[i_f2py++].data = rstrasi;
}
extern void F_FUNC(f2pyinithadr10,F2PYINITHADR10)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_hadr10(void) {
  F_FUNC(f2pyinithadr10,F2PYINITHADR10)(f2py_setup_hadr10);
}

static FortranDataDef f2py_wgtqrk_def[] = {
  {"wgtqqq",1,{{4}},NPY_FLOAT},
  {"wgtval",0,{{-1}},NPY_FLOAT},
  {"wgtsea",0,{{-1}},NPY_FLOAT},
  {"wgtdiq",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_wgtqrk(char *wgtqqq,char *wgtval,char *wgtsea,char *wgtdiq) {
  int i_f2py=0;
  f2py_wgtqrk_def[i_f2py++].data = wgtqqq;
  f2py_wgtqrk_def[i_f2py++].data = wgtval;
  f2py_wgtqrk_def[i_f2py++].data = wgtsea;
  f2py_wgtqrk_def[i_f2py++].data = wgtdiq;
}
extern void F_FUNC(f2pyinitwgtqrk,F2PYINITWGTQRK)(void(*)(char*,char*,char*,char*));
static void f2py_init_wgtqrk(void) {
  F_FUNC(f2pyinitwgtqrk,F2PYINITWGTQRK)(f2py_setup_wgtqrk);
}

static FortranDataDef f2py_time1_def[] = {
  {"timeini",0,{{-1}},NPY_DOUBLE},
  {"timefin",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_time1(char *timeini,char *timefin) {
  int i_f2py=0;
  f2py_time1_def[i_f2py++].data = timeini;
  f2py_time1_def[i_f2py++].data = timefin;
}
extern void F_FUNC(f2pyinittime1,F2PYINITTIME1)(void(*)(char*,char*));
static void f2py_init_time1(void) {
  F_FUNC(f2pyinittime1,F2PYINITTIME1)(f2py_setup_time1);
}

static FortranDataDef f2py_ciotst_def[] = {
  {"iotst1",0,{{-1}},NPY_INT},
  {"iotst2",0,{{-1}},NPY_INT},
  {"iotst3",0,{{-1}},NPY_INT},
  {"iotst4",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ciotst(char *iotst1,char *iotst2,char *iotst3,char *iotst4) {
  int i_f2py=0;
  f2py_ciotst_def[i_f2py++].data = iotst1;
  f2py_ciotst_def[i_f2py++].data = iotst2;
  f2py_ciotst_def[i_f2py++].data = iotst3;
  f2py_ciotst_def[i_f2py++].data = iotst4;
}
extern void F_FUNC(f2pyinitciotst,F2PYINITCIOTST)(void(*)(char*,char*,char*,char*));
static void f2py_init_ciotst(void) {
  F_FUNC(f2pyinitciotst,F2PYINITCIOTST)(f2py_setup_ciotst);
}

static FortranDataDef f2py_resc1_def[] = {
  {"taumin",0,{{-1}},NPY_FLOAT},
  {"deltau",0,{{-1}},NPY_FLOAT},
  {"factau",0,{{-1}},NPY_FLOAT},
  {"numtau",0,{{-1}},NPY_FLOAT},
  {"amsiac",0,{{-1}},NPY_FLOAT},
  {"amprif",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_resc1(char *taumin,char *deltau,char *factau,char *numtau,char *amsiac,char *amprif) {
  int i_f2py=0;
  f2py_resc1_def[i_f2py++].data = taumin;
  f2py_resc1_def[i_f2py++].data = deltau;
  f2py_resc1_def[i_f2py++].data = factau;
  f2py_resc1_def[i_f2py++].data = numtau;
  f2py_resc1_def[i_f2py++].data = amsiac;
  f2py_resc1_def[i_f2py++].data = amprif;
}
extern void F_FUNC(f2pyinitresc1,F2PYINITRESC1)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_resc1(void) {
  F_FUNC(f2pyinitresc1,F2PYINITRESC1)(f2py_setup_resc1);
}

static FortranDataDef f2py_resc3_def[] = {
  {"dscale",0,{{-1}},NPY_FLOAT},
  {"cepara",0,{{-1}},NPY_FLOAT},
  {"iceopt",0,{{-1}},NPY_INT},
  {"delamf",0,{{-1}},NPY_FLOAT},
  {"deuamf",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_resc3(char *dscale,char *cepara,char *iceopt,char *delamf,char *deuamf) {
  int i_f2py=0;
  f2py_resc3_def[i_f2py++].data = dscale;
  f2py_resc3_def[i_f2py++].data = cepara;
  f2py_resc3_def[i_f2py++].data = iceopt;
  f2py_resc3_def[i_f2py++].data = delamf;
  f2py_resc3_def[i_f2py++].data = deuamf;
}
extern void F_FUNC(f2pyinitresc3,F2PYINITRESC3)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_resc3(void) {
  F_FUNC(f2pyinitresc3,F2PYINITRESC3)(f2py_setup_resc3);
}

static FortranDataDef f2py_sprio_def[] = {
  {"ispherio",0,{{-1}},NPY_INT},
  {"icotabm",0,{{-1}},NPY_INT},
  {"icotabr",0,{{-1}},NPY_INT},
  {"icocore",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_sprio(char *ispherio,char *icotabm,char *icotabr,char *icocore) {
  int i_f2py=0;
  f2py_sprio_def[i_f2py++].data = ispherio;
  f2py_sprio_def[i_f2py++].data = icotabm;
  f2py_sprio_def[i_f2py++].data = icotabr;
  f2py_sprio_def[i_f2py++].data = icocore;
}
extern void F_FUNC(f2pyinitsprio,F2PYINITSPRIO)(void(*)(char*,char*,char*,char*));
static void f2py_init_sprio(void) {
  F_FUNC(f2pyinitsprio,F2PYINITSPRIO)(f2py_setup_sprio);
}

static FortranDataDef f2py_urqm1_def[] = {
  {"iurqmd",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_urqm1(char *iurqmd) {
  int i_f2py=0;
  f2py_urqm1_def[i_f2py++].data = iurqmd;
}
extern void F_FUNC(f2pyiniturqm1,F2PYINITURQM1)(void(*)(char*));
static void f2py_init_urqm1(void) {
  F_FUNC(f2pyiniturqm1,F2PYINITURQM1)(f2py_setup_urqm1);
}

static FortranDataDef f2py_incon_def[] = {
  {"cutico",0,{{-1}},NPY_FLOAT},
  {"dssico",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_incon(char *cutico,char *dssico) {
  int i_f2py=0;
  f2py_incon_def[i_f2py++].data = cutico;
  f2py_incon_def[i_f2py++].data = dssico;
}
extern void F_FUNC(f2pyinitincon,F2PYINITINCON)(void(*)(char*,char*));
static void f2py_init_incon(void) {
  F_FUNC(f2pyinitincon,F2PYINITINCON)(f2py_setup_incon);
}

static FortranDataDef f2py_othe1_def[] = {
  {"istore",0,{{-1}},NPY_INT},
  {"istmax",0,{{-1}},NPY_INT},
  {"gaumx",0,{{-1}},NPY_FLOAT},
  {"irescl",0,{{-1}},NPY_INT},
  {"ntrymx",0,{{-1}},NPY_INT},
  {"nclean",0,{{-1}},NPY_INT},
  {"iopdg",0,{{-1}},NPY_INT},
  {"ioidch",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_othe1(char *istore,char *istmax,char *gaumx,char *irescl,char *ntrymx,char *nclean,char *iopdg,char *ioidch) {
  int i_f2py=0;
  f2py_othe1_def[i_f2py++].data = istore;
  f2py_othe1_def[i_f2py++].data = istmax;
  f2py_othe1_def[i_f2py++].data = gaumx;
  f2py_othe1_def[i_f2py++].data = irescl;
  f2py_othe1_def[i_f2py++].data = ntrymx;
  f2py_othe1_def[i_f2py++].data = nclean;
  f2py_othe1_def[i_f2py++].data = iopdg;
  f2py_othe1_def[i_f2py++].data = ioidch;
}
extern void F_FUNC(f2pyinitothe1,F2PYINITOTHE1)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_othe1(void) {
  F_FUNC(f2pyinitothe1,F2PYINITOTHE1)(f2py_setup_othe1);
}

static FortranDataDef f2py_othe2_def[] = {
  {"ifrade",0,{{-1}},NPY_INT},
  {"iframe",0,{{-1}},NPY_INT},
  {"idecay",0,{{-1}},NPY_INT},
  {"jdecay",0,{{-1}},NPY_INT},
  {"iremn",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_othe2(char *ifrade,char *iframe,char *idecay,char *jdecay,char *iremn) {
  int i_f2py=0;
  f2py_othe2_def[i_f2py++].data = ifrade;
  f2py_othe2_def[i_f2py++].data = iframe;
  f2py_othe2_def[i_f2py++].data = idecay;
  f2py_othe2_def[i_f2py++].data = jdecay;
  f2py_othe2_def[i_f2py++].data = iremn;
}
extern void F_FUNC(f2pyinitothe2,F2PYINITOTHE2)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_othe2(void) {
  F_FUNC(f2pyinitothe2,F2PYINITOTHE2)(f2py_setup_othe2);
}

static FortranDataDef f2py_othe3_def[] = {
  {"jframe",0,{{-1}},NPY_INT},
  {"kframe",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_othe3(char *jframe,char *kframe) {
  int i_f2py=0;
  f2py_othe3_def[i_f2py++].data = jframe;
  f2py_othe3_def[i_f2py++].data = kframe;
}
extern void F_FUNC(f2pyinitothe3,F2PYINITOTHE3)(void(*)(char*,char*));
static void f2py_init_othe3(void) {
  F_FUNC(f2pyinitothe3,F2PYINITOTHE3)(f2py_setup_othe3);
}

static FortranDataDef f2py_othe4_def[] = {
  {"iselect",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_othe4(char *iselect) {
  int i_f2py=0;
  f2py_othe4_def[i_f2py++].data = iselect;
}
extern void F_FUNC(f2pyinitothe4,F2PYINITOTHE4)(void(*)(char*));
static void f2py_init_othe4(void) {
  F_FUNC(f2pyinitothe4,F2PYINITOTHE4)(f2py_setup_othe4);
}

static FortranDataDef f2py_jpsif_def[] = {
  {"jpsi",0,{{-1}},NPY_INT},
  {"jpsifi",0,{{-1}},NPY_INT},
  {"taumx",0,{{-1}},NPY_FLOAT},
  {"nsttau",0,{{-1}},NPY_INT},
  {"sigj",0,{{-1}},NPY_FLOAT},
  {"ijphis",0,{{-1}},NPY_INT},
  {"ijtauan",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_jpsif(char *jpsi,char *jpsifi,char *taumx,char *nsttau,char *sigj,char *ijphis,char *ijtauan) {
  int i_f2py=0;
  f2py_jpsif_def[i_f2py++].data = jpsi;
  f2py_jpsif_def[i_f2py++].data = jpsifi;
  f2py_jpsif_def[i_f2py++].data = taumx;
  f2py_jpsif_def[i_f2py++].data = nsttau;
  f2py_jpsif_def[i_f2py++].data = sigj;
  f2py_jpsif_def[i_f2py++].data = ijphis;
  f2py_jpsif_def[i_f2py++].data = ijtauan;
}
extern void F_FUNC(f2pyinitjpsif,F2PYINITJPSIF)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_jpsif(void) {
  F_FUNC(f2pyinitjpsif,F2PYINITJPSIF)(f2py_setup_jpsif);
}

static FortranDataDef f2py_strlt_def[] = {
  {"iopenu",0,{{-1}},NPY_INT},
  {"themas",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_strlt(char *iopenu,char *themas) {
  int i_f2py=0;
  f2py_strlt_def[i_f2py++].data = iopenu;
  f2py_strlt_def[i_f2py++].data = themas;
}
extern void F_FUNC(f2pyinitstrlt,F2PYINITSTRLT)(void(*)(char*,char*));
static void f2py_init_strlt(void) {
  F_FUNC(f2pyinitstrlt,F2PYINITSTRLT)(f2py_setup_strlt);
}

static FortranDataDef f2py_appli_def[] = {
  {"iappl",0,{{-1}},NPY_INT},
  {"model",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_appli(char *iappl,char *model) {
  int i_f2py=0;
  f2py_appli_def[i_f2py++].data = iappl;
  f2py_appli_def[i_f2py++].data = model;
}
extern void F_FUNC(f2pyinitappli,F2PYINITAPPLI)(void(*)(char*,char*));
static void f2py_init_appli(void) {
  F_FUNC(f2pyinitappli,F2PYINITAPPLI)(f2py_setup_appli);
}

static FortranDataDef f2py_events_def[] = {
  {"nevent",0,{{-1}},NPY_INT},
  {"nfull",0,{{-1}},NPY_INT},
  {"nfreeze",0,{{-1}},NPY_INT},
  {"ninicon",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_events(char *nevent,char *nfull,char *nfreeze,char *ninicon) {
  int i_f2py=0;
  f2py_events_def[i_f2py++].data = nevent;
  f2py_events_def[i_f2py++].data = nfull;
  f2py_events_def[i_f2py++].data = nfreeze;
  f2py_events_def[i_f2py++].data = ninicon;
}
extern void F_FUNC(f2pyinitevents,F2PYINITEVENTS)(void(*)(char*,char*,char*,char*));
static void f2py_init_events(void) {
  F_FUNC(f2pyinitevents,F2PYINITEVENTS)(f2py_setup_events);
}

static FortranDataDef f2py_enrgy_def[] = {
  {"egymin",0,{{-1}},NPY_FLOAT},
  {"egymax",0,{{-1}},NPY_FLOAT},
  {"elab",0,{{-1}},NPY_FLOAT},
  {"ecms",0,{{-1}},NPY_FLOAT},
  {"ekin",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_enrgy(char *egymin,char *egymax,char *elab,char *ecms,char *ekin) {
  int i_f2py=0;
  f2py_enrgy_def[i_f2py++].data = egymin;
  f2py_enrgy_def[i_f2py++].data = egymax;
  f2py_enrgy_def[i_f2py++].data = elab;
  f2py_enrgy_def[i_f2py++].data = ecms;
  f2py_enrgy_def[i_f2py++].data = ekin;
}
extern void F_FUNC(f2pyinitenrgy,F2PYINITENRGY)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_enrgy(void) {
  F_FUNC(f2pyinitenrgy,F2PYINITENRGY)(f2py_setup_enrgy);
}

static FortranDataDef f2py_prnt1_def[] = {
  {"iprmpt",0,{{-1}},NPY_INT},
  {"ish",0,{{-1}},NPY_INT},
  {"ishsub",0,{{-1}},NPY_INT},
  {"irandm",0,{{-1}},NPY_INT},
  {"irewch",0,{{-1}},NPY_INT},
  {"iecho",0,{{-1}},NPY_INT},
  {"modsho",0,{{-1}},NPY_INT},
  {"idensi",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_prnt1(char *iprmpt,char *ish,char *ishsub,char *irandm,char *irewch,char *iecho,char *modsho,char *idensi) {
  int i_f2py=0;
  f2py_prnt1_def[i_f2py++].data = iprmpt;
  f2py_prnt1_def[i_f2py++].data = ish;
  f2py_prnt1_def[i_f2py++].data = ishsub;
  f2py_prnt1_def[i_f2py++].data = irandm;
  f2py_prnt1_def[i_f2py++].data = irewch;
  f2py_prnt1_def[i_f2py++].data = iecho;
  f2py_prnt1_def[i_f2py++].data = modsho;
  f2py_prnt1_def[i_f2py++].data = idensi;
}
extern void F_FUNC(f2pyinitprnt1,F2PYINITPRNT1)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_prnt1(void) {
  F_FUNC(f2pyinitprnt1,F2PYINITPRNT1)(f2py_setup_prnt1);
}

static FortranDataDef f2py_lept1_def[] = {
  {"engy",0,{{-1}},NPY_FLOAT},
  {"elepti",0,{{-1}},NPY_FLOAT},
  {"elepto",0,{{-1}},NPY_FLOAT},
  {"angmue",0,{{-1}},NPY_FLOAT},
  {"icinpu",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_lept1(char *engy,char *elepti,char *elepto,char *angmue,char *icinpu) {
  int i_f2py=0;
  f2py_lept1_def[i_f2py++].data = engy;
  f2py_lept1_def[i_f2py++].data = elepti;
  f2py_lept1_def[i_f2py++].data = elepto;
  f2py_lept1_def[i_f2py++].data = angmue;
  f2py_lept1_def[i_f2py++].data = icinpu;
}
extern void F_FUNC(f2pyinitlept1,F2PYINITLEPT1)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_lept1(void) {
  F_FUNC(f2pyinitlept1,F2PYINITLEPT1)(f2py_setup_lept1);
}

static FortranDataDef f2py_nucl1_def[] = {
  {"laproj",0,{{-1}},NPY_INT},
  {"maproj",0,{{-1}},NPY_INT},
  {"latarg",0,{{-1}},NPY_INT},
  {"matarg",0,{{-1}},NPY_INT},
  {"core",0,{{-1}},NPY_FLOAT},
  {"fctrmx",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_nucl1(char *laproj,char *maproj,char *latarg,char *matarg,char *core,char *fctrmx) {
  int i_f2py=0;
  f2py_nucl1_def[i_f2py++].data = laproj;
  f2py_nucl1_def[i_f2py++].data = maproj;
  f2py_nucl1_def[i_f2py++].data = latarg;
  f2py_nucl1_def[i_f2py++].data = matarg;
  f2py_nucl1_def[i_f2py++].data = core;
  f2py_nucl1_def[i_f2py++].data = fctrmx;
}
extern void F_FUNC(f2pyinitnucl1,F2PYINITNUCL1)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_nucl1(void) {
  F_FUNC(f2pyinitnucl1,F2PYINITNUCL1)(f2py_setup_nucl1);
}

static FortranDataDef f2py_nucl2_def[] = {
  {"bmaxim",0,{{-1}},NPY_FLOAT},
  {"bminim",0,{{-1}},NPY_FLOAT},
  {"phimax",0,{{-1}},NPY_FLOAT},
  {"phimin",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_nucl2(char *bmaxim,char *bminim,char *phimax,char *phimin) {
  int i_f2py=0;
  f2py_nucl2_def[i_f2py++].data = bmaxim;
  f2py_nucl2_def[i_f2py++].data = bminim;
  f2py_nucl2_def[i_f2py++].data = phimax;
  f2py_nucl2_def[i_f2py++].data = phimin;
}
extern void F_FUNC(f2pyinitnucl2,F2PYINITNUCL2)(void(*)(char*,char*,char*,char*));
static void f2py_init_nucl2(void) {
  F_FUNC(f2pyinitnucl2,F2PYINITNUCL2)(f2py_setup_nucl2);
}

static FortranDataDef f2py_wana1_def[] = {
  {"ymximi",0,{{-1}},NPY_FLOAT},
  {"imihis",0,{{-1}},NPY_INT},
  {"iclhis",0,{{-1}},NPY_INT},
  {"iwtime",0,{{-1}},NPY_INT},
  {"wtimet",0,{{-1}},NPY_FLOAT},
  {"wtimei",0,{{-1}},NPY_FLOAT},
  {"wtimea",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_wana1(char *ymximi,char *imihis,char *iclhis,char *iwtime,char *wtimet,char *wtimei,char *wtimea) {
  int i_f2py=0;
  f2py_wana1_def[i_f2py++].data = ymximi;
  f2py_wana1_def[i_f2py++].data = imihis;
  f2py_wana1_def[i_f2py++].data = iclhis;
  f2py_wana1_def[i_f2py++].data = iwtime;
  f2py_wana1_def[i_f2py++].data = wtimet;
  f2py_wana1_def[i_f2py++].data = wtimei;
  f2py_wana1_def[i_f2py++].data = wtimea;
}
extern void F_FUNC(f2pyinitwana1,F2PYINITWANA1)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_wana1(void) {
  F_FUNC(f2pyinitwana1,F2PYINITWANA1)(f2py_setup_wana1);
}

static FortranDataDef f2py_wana2_def[] = {
  {"isphis",0,{{-1}},NPY_INT},
  {"ispall",0,{{-1}},NPY_INT},
  {"wtmini",0,{{-1}},NPY_FLOAT},
  {"wtstep",0,{{-1}},NPY_FLOAT},
  {"iwcent",0,{{-1}},NPY_INT},
  {"iana",0,{{-1}},NPY_INT},
  {"nbdky",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_wana2(char *isphis,char *ispall,char *wtmini,char *wtstep,char *iwcent,char *iana,char *nbdky) {
  int i_f2py=0;
  f2py_wana2_def[i_f2py++].data = isphis;
  f2py_wana2_def[i_f2py++].data = ispall;
  f2py_wana2_def[i_f2py++].data = wtmini;
  f2py_wana2_def[i_f2py++].data = wtstep;
  f2py_wana2_def[i_f2py++].data = iwcent;
  f2py_wana2_def[i_f2py++].data = iana;
  f2py_wana2_def[i_f2py++].data = nbdky;
}
extern void F_FUNC(f2pyinitwana2,F2PYINITWANA2)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_wana2(void) {
  F_FUNC(f2pyinitwana2,F2PYINITWANA2)(f2py_setup_wana2);
}

static FortranDataDef f2py_drop4_def[] = {
  {"asuhax",1,{{7}},NPY_FLOAT},
  {"asuhay",1,{{7}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_drop4(char *asuhax,char *asuhay) {
  int i_f2py=0;
  f2py_drop4_def[i_f2py++].data = asuhax;
  f2py_drop4_def[i_f2py++].data = asuhay;
}
extern void F_FUNC(f2pyinitdrop4,F2PYINITDROP4)(void(*)(char*,char*));
static void f2py_init_drop4(void) {
  F_FUNC(f2pyinitdrop4,F2PYINITDROP4)(f2py_setup_drop4);
}

static FortranDataDef f2py_gribo_def[] = {
  {"grigam",0,{{-1}},NPY_FLOAT},
  {"grirsq",0,{{-1}},NPY_FLOAT},
  {"gridel",0,{{-1}},NPY_FLOAT},
  {"grislo",0,{{-1}},NPY_FLOAT},
  {"gricel",0,{{-1}},NPY_FLOAT},
  {"sigppi",0,{{-1}},NPY_FLOAT},
  {"sigppd",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_gribo(char *grigam,char *grirsq,char *gridel,char *grislo,char *gricel,char *sigppi,char *sigppd) {
  int i_f2py=0;
  f2py_gribo_def[i_f2py++].data = grigam;
  f2py_gribo_def[i_f2py++].data = grirsq;
  f2py_gribo_def[i_f2py++].data = gridel;
  f2py_gribo_def[i_f2py++].data = grislo;
  f2py_gribo_def[i_f2py++].data = gricel;
  f2py_gribo_def[i_f2py++].data = sigppi;
  f2py_gribo_def[i_f2py++].data = sigppd;
}
extern void F_FUNC(f2pyinitgribo,F2PYINITGRIBO)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_gribo(void) {
  F_FUNC(f2pyinitgribo,F2PYINITGRIBO)(f2py_setup_gribo);
}

static FortranDataDef f2py_drop3_def[] = {
  {"bag4rt",0,{{-1}},NPY_FLOAT},
  {"dezzer",0,{{-1}},NPY_FLOAT},
  {"amuseg",0,{{-1}},NPY_FLOAT},
  {"taunll",0,{{-1}},NPY_FLOAT},
  {"yradmx",0,{{-1}},NPY_FLOAT},
  {"facts",0,{{-1}},NPY_FLOAT},
  {"factb",0,{{-1}},NPY_FLOAT},
  {"factq",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_drop3(char *bag4rt,char *dezzer,char *amuseg,char *taunll,char *yradmx,char *facts,char *factb,char *factq) {
  int i_f2py=0;
  f2py_drop3_def[i_f2py++].data = bag4rt;
  f2py_drop3_def[i_f2py++].data = dezzer;
  f2py_drop3_def[i_f2py++].data = amuseg;
  f2py_drop3_def[i_f2py++].data = taunll;
  f2py_drop3_def[i_f2py++].data = yradmx;
  f2py_drop3_def[i_f2py++].data = facts;
  f2py_drop3_def[i_f2py++].data = factb;
  f2py_drop3_def[i_f2py++].data = factq;
}
extern void F_FUNC(f2pyinitdrop3,F2PYINITDROP3)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_drop3(void) {
  F_FUNC(f2pyinitdrop3,F2PYINITDROP3)(f2py_setup_drop3);
}

static FortranDataDef f2py_drop2_def[] = {
  {"rcoll",0,{{-1}},NPY_FLOAT},
  {"ylongmx",0,{{-1}},NPY_FLOAT},
  {"nsegsu",0,{{-1}},NPY_INT},
  {"nsegce",0,{{-1}},NPY_INT},
  {"facecc",0,{{-1}},NPY_FLOAT},
  {"yradpp",0,{{-1}},NPY_FLOAT},
  {"yradmi",0,{{-1}},NPY_FLOAT},
  {"yrmaxi",0,{{-1}},NPY_FLOAT},
  {"fradflii",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_drop2(char *rcoll,char *ylongmx,char *nsegsu,char *nsegce,char *facecc,char *yradpp,char *yradmi,char *yrmaxi,char *fradflii) {
  int i_f2py=0;
  f2py_drop2_def[i_f2py++].data = rcoll;
  f2py_drop2_def[i_f2py++].data = ylongmx;
  f2py_drop2_def[i_f2py++].data = nsegsu;
  f2py_drop2_def[i_f2py++].data = nsegce;
  f2py_drop2_def[i_f2py++].data = facecc;
  f2py_drop2_def[i_f2py++].data = yradpp;
  f2py_drop2_def[i_f2py++].data = yradmi;
  f2py_drop2_def[i_f2py++].data = yrmaxi;
  f2py_drop2_def[i_f2py++].data = fradflii;
}
extern void F_FUNC(f2pyinitdrop2,F2PYINITDROP2)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_drop2(void) {
  F_FUNC(f2pyinitdrop2,F2PYINITDROP2)(f2py_setup_drop2);
}

static FortranDataDef f2py_drop7_def[] = {
  {"ptclu",0,{{-1}},NPY_FLOAT},
  {"yradpi",0,{{-1}},NPY_FLOAT},
  {"yradpx",0,{{-1}},NPY_FLOAT},
  {"fploss",0,{{-1}},NPY_FLOAT},
  {"fvisco",0,{{-1}},NPY_FLOAT},
  {"fplmin",0,{{-1}},NPY_FLOAT},
  {"ioclude",0,{{-1}},NPY_INT},
  {"iocluin",0,{{-1}},NPY_INT},
  {"ioquen",0,{{-1}},NPY_INT},
  {"iohole",0,{{-1}},NPY_INT},
  {"kigrid",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_drop7(char *ptclu,char *yradpi,char *yradpx,char *fploss,char *fvisco,char *fplmin,char *ioclude,char *iocluin,char *ioquen,char *iohole,char *kigrid) {
  int i_f2py=0;
  f2py_drop7_def[i_f2py++].data = ptclu;
  f2py_drop7_def[i_f2py++].data = yradpi;
  f2py_drop7_def[i_f2py++].data = yradpx;
  f2py_drop7_def[i_f2py++].data = fploss;
  f2py_drop7_def[i_f2py++].data = fvisco;
  f2py_drop7_def[i_f2py++].data = fplmin;
  f2py_drop7_def[i_f2py++].data = ioclude;
  f2py_drop7_def[i_f2py++].data = iocluin;
  f2py_drop7_def[i_f2py++].data = ioquen;
  f2py_drop7_def[i_f2py++].data = iohole;
  f2py_drop7_def[i_f2py++].data = kigrid;
}
extern void F_FUNC(f2pyinitdrop7,F2PYINITDROP7)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_drop7(void) {
  F_FUNC(f2pyinitdrop7,F2PYINITDROP7)(f2py_setup_drop7);
}

static FortranDataDef f2py_drop8_def[] = {
  {"fsgrid",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_drop8(char *fsgrid) {
  int i_f2py=0;
  f2py_drop8_def[i_f2py++].data = fsgrid;
}
extern void F_FUNC(f2pyinitdrop8,F2PYINITDROP8)(void(*)(char*));
static void f2py_init_drop8(void) {
  F_FUNC(f2pyinitdrop8,F2PYINITDROP8)(f2py_setup_drop8);
}

static FortranDataDef f2py_metr1_def[] = {
  {"iospec",0,{{-1}},NPY_INT},
  {"iocova",0,{{-1}},NPY_INT},
  {"iopair",0,{{-1}},NPY_INT},
  {"iozero",0,{{-1}},NPY_INT},
  {"ioflac",0,{{-1}},NPY_INT},
  {"iomom",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_metr1(char *iospec,char *iocova,char *iopair,char *iozero,char *ioflac,char *iomom) {
  int i_f2py=0;
  f2py_metr1_def[i_f2py++].data = iospec;
  f2py_metr1_def[i_f2py++].data = iocova;
  f2py_metr1_def[i_f2py++].data = iopair;
  f2py_metr1_def[i_f2py++].data = iozero;
  f2py_metr1_def[i_f2py++].data = ioflac;
  f2py_metr1_def[i_f2py++].data = iomom;
}
extern void F_FUNC(f2pyinitmetr1,F2PYINITMETR1)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_metr1(void) {
  F_FUNC(f2pyinitmetr1,F2PYINITMETR1)(f2py_setup_metr1);
}

static FortranDataDef f2py_metr2_def[] = {
  {"nadd",0,{{-1}},NPY_INT},
  {"iograc",0,{{-1}},NPY_INT},
  {"iocite",0,{{-1}},NPY_INT},
  {"ioceau",0,{{-1}},NPY_INT},
  {"iociau",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_metr2(char *nadd,char *iograc,char *iocite,char *ioceau,char *iociau) {
  int i_f2py=0;
  f2py_metr2_def[i_f2py++].data = nadd;
  f2py_metr2_def[i_f2py++].data = iograc;
  f2py_metr2_def[i_f2py++].data = iocite;
  f2py_metr2_def[i_f2py++].data = ioceau;
  f2py_metr2_def[i_f2py++].data = iociau;
}
extern void F_FUNC(f2pyinitmetr2,F2PYINITMETR2)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_metr2(void) {
  F_FUNC(f2pyinitmetr2,F2PYINITMETR2)(f2py_setup_metr2);
}

static FortranDataDef f2py_hadr2_def[] = {
  {"iomodl",0,{{-1}},NPY_INT},
  {"idproj",0,{{-1}},NPY_INT},
  {"idtarg",0,{{-1}},NPY_INT},
  {"wexcit",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr2(char *iomodl,char *idproj,char *idtarg,char *wexcit) {
  int i_f2py=0;
  f2py_hadr2_def[i_f2py++].data = iomodl;
  f2py_hadr2_def[i_f2py++].data = idproj;
  f2py_hadr2_def[i_f2py++].data = idtarg;
  f2py_hadr2_def[i_f2py++].data = wexcit;
}
extern void F_FUNC(f2pyinithadr2,F2PYINITHADR2)(void(*)(char*,char*,char*,char*));
static void f2py_init_hadr2(void) {
  F_FUNC(f2pyinithadr2,F2PYINITHADR2)(f2py_setup_hadr2);
}

static FortranDataDef f2py_hadr25_def[] = {
  {"idprojin",0,{{-1}},NPY_INT},
  {"idtargin",0,{{-1}},NPY_INT},
  {"rexdifi",1,{{4}},NPY_FLOAT},
  {"rexndii",1,{{4}},NPY_FLOAT},
  {"irdmpr",0,{{-1}},NPY_INT},
  {"isoproj",0,{{-1}},NPY_INT},
  {"isotarg",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_hadr25(char *idprojin,char *idtargin,char *rexdifi,char *rexndii,char *irdmpr,char *isoproj,char *isotarg) {
  int i_f2py=0;
  f2py_hadr25_def[i_f2py++].data = idprojin;
  f2py_hadr25_def[i_f2py++].data = idtargin;
  f2py_hadr25_def[i_f2py++].data = rexdifi;
  f2py_hadr25_def[i_f2py++].data = rexndii;
  f2py_hadr25_def[i_f2py++].data = irdmpr;
  f2py_hadr25_def[i_f2py++].data = isoproj;
  f2py_hadr25_def[i_f2py++].data = isotarg;
}
extern void F_FUNC(f2pyinithadr25,F2PYINITHADR25)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr25(void) {
  F_FUNC(f2pyinithadr25,F2PYINITHADR25)(f2py_setup_hadr25);
}

static FortranDataDef f2py_metr3_def[] = {
  {"iostat",0,{{-1}},NPY_INT},
  {"ioinco",0,{{-1}},NPY_INT},
  {"ionlat",0,{{-1}},NPY_INT},
  {"ioobsv",0,{{-1}},NPY_INT},
  {"iosngl",0,{{-1}},NPY_INT},
  {"iorejz",0,{{-1}},NPY_INT},
  {"iompar",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_metr3(char *iostat,char *ioinco,char *ionlat,char *ioobsv,char *iosngl,char *iorejz,char *iompar) {
  int i_f2py=0;
  f2py_metr3_def[i_f2py++].data = iostat;
  f2py_metr3_def[i_f2py++].data = ioinco;
  f2py_metr3_def[i_f2py++].data = ionlat;
  f2py_metr3_def[i_f2py++].data = ioobsv;
  f2py_metr3_def[i_f2py++].data = iosngl;
  f2py_metr3_def[i_f2py++].data = iorejz;
  f2py_metr3_def[i_f2py++].data = iompar;
}
extern void F_FUNC(f2pyinitmetr3,F2PYINITMETR3)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_metr3(void) {
  F_FUNC(f2pyinitmetr3,F2PYINITMETR3)(f2py_setup_metr3);
}

static FortranDataDef f2py_metr4_def[] = {
  {"ioinfl",0,{{-1}},NPY_INT},
  {"ioinct",0,{{-1}},NPY_INT},
  {"iowidn",0,{{-1}},NPY_INT},
  {"epsgc",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_metr4(char *ioinfl,char *ioinct,char *iowidn,char *epsgc) {
  int i_f2py=0;
  f2py_metr4_def[i_f2py++].data = ioinfl;
  f2py_metr4_def[i_f2py++].data = ioinct;
  f2py_metr4_def[i_f2py++].data = iowidn;
  f2py_metr4_def[i_f2py++].data = epsgc;
}
extern void F_FUNC(f2pyinitmetr4,F2PYINITMETR4)(void(*)(char*,char*,char*,char*));
static void f2py_init_metr4(void) {
  F_FUNC(f2pyinitmetr4,F2PYINITMETR4)(f2py_setup_metr4);
}

static FortranDataDef f2py_lept2_def[] = {
  {"nstmax",0,{{-1}},NPY_INT},
  {"prob",1,{{99}},NPY_FLOAT},
  {"icbac",2,{{99,2}},NPY_INT},
  {"icfor",2,{{99,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_lept2(char *nstmax,char *prob,char *icbac,char *icfor) {
  int i_f2py=0;
  f2py_lept2_def[i_f2py++].data = nstmax;
  f2py_lept2_def[i_f2py++].data = prob;
  f2py_lept2_def[i_f2py++].data = icbac;
  f2py_lept2_def[i_f2py++].data = icfor;
}
extern void F_FUNC(f2pyinitlept2,F2PYINITLEPT2)(void(*)(char*,char*,char*,char*));
static void f2py_init_lept2(void) {
  F_FUNC(f2pyinitlept2,F2PYINITLEPT2)(f2py_setup_lept2);
}

static FortranDataDef f2py_lept3_def[] = {
  {"iolept",0,{{-1}},NPY_INT},
  {"igampr",0,{{-1}},NPY_INT},
  {"idisco",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_lept3(char *iolept,char *igampr,char *idisco) {
  int i_f2py=0;
  f2py_lept3_def[i_f2py++].data = iolept;
  f2py_lept3_def[i_f2py++].data = igampr;
  f2py_lept3_def[i_f2py++].data = idisco;
}
extern void F_FUNC(f2pyinitlept3,F2PYINITLEPT3)(void(*)(char*,char*,char*));
static void f2py_init_lept3(void) {
  F_FUNC(f2pyinitlept3,F2PYINITLEPT3)(f2py_setup_lept3);
}

static FortranDataDef f2py_ebin_def[] = {
  {"noebin",0,{{-1}},NPY_INT},
  {"engmin",0,{{-1}},NPY_FLOAT},
  {"engmax",0,{{-1}},NPY_FLOAT},
  {"nrebin",0,{{-1}},NPY_INT},
  {"iologe",0,{{-1}},NPY_INT},
  {"iologl",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ebin(char *noebin,char *engmin,char *engmax,char *nrebin,char *iologe,char *iologl) {
  int i_f2py=0;
  f2py_ebin_def[i_f2py++].data = noebin;
  f2py_ebin_def[i_f2py++].data = engmin;
  f2py_ebin_def[i_f2py++].data = engmax;
  f2py_ebin_def[i_f2py++].data = nrebin;
  f2py_ebin_def[i_f2py++].data = iologe;
  f2py_ebin_def[i_f2py++].data = iologl;
}
extern void F_FUNC(f2pyinitebin,F2PYINITEBIN)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_ebin(void) {
  F_FUNC(f2pyinitebin,F2PYINITEBIN)(f2py_setup_ebin);
}

static FortranDataDef f2py_cnsta_def[] = {
  {"pi",0,{{-1}},NPY_FLOAT},
  {"pii",0,{{-1}},NPY_FLOAT},
  {"hquer",0,{{-1}},NPY_FLOAT},
  {"prom",0,{{-1}},NPY_FLOAT},
  {"piom",0,{{-1}},NPY_FLOAT},
  {"ainfin",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cnsta(char *pi,char *pii,char *hquer,char *prom,char *piom,char *ainfin) {
  int i_f2py=0;
  f2py_cnsta_def[i_f2py++].data = pi;
  f2py_cnsta_def[i_f2py++].data = pii;
  f2py_cnsta_def[i_f2py++].data = hquer;
  f2py_cnsta_def[i_f2py++].data = prom;
  f2py_cnsta_def[i_f2py++].data = piom;
  f2py_cnsta_def[i_f2py++].data = ainfin;
}
extern void F_FUNC(f2pyinitcnsta,F2PYINITCNSTA)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_cnsta(void) {
  F_FUNC(f2pyinitcnsta,F2PYINITCNSTA)(f2py_setup_cnsta);
}

static FortranDataDef f2py_versn_def[] = {
  {"iversn",0,{{-1}},NPY_INT},
  {"iverso",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_versn(char *iversn,char *iverso) {
  int i_f2py=0;
  f2py_versn_def[i_f2py++].data = iversn;
  f2py_versn_def[i_f2py++].data = iverso;
}
extern void F_FUNC(f2pyinitversn,F2PYINITVERSN)(void(*)(char*,char*));
static void f2py_init_versn(void) {
  F_FUNC(f2pyinitversn,F2PYINITVERSN)(f2py_setup_versn);
}

static FortranDataDef f2py_accum_def[] = {
  {"imsg",0,{{-1}},NPY_INT},
  {"jerr",1,{{10}},NPY_INT},
  {"ntevt",0,{{-1}},NPY_INT},
  {"nrevt",0,{{-1}},NPY_INT},
  {"naevt",0,{{-1}},NPY_INT},
  {"nrstr",0,{{-1}},NPY_INT},
  {"nrptl",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_accum(char *imsg,char *jerr,char *ntevt,char *nrevt,char *naevt,char *nrstr,char *nrptl) {
  int i_f2py=0;
  f2py_accum_def[i_f2py++].data = imsg;
  f2py_accum_def[i_f2py++].data = jerr;
  f2py_accum_def[i_f2py++].data = ntevt;
  f2py_accum_def[i_f2py++].data = nrevt;
  f2py_accum_def[i_f2py++].data = naevt;
  f2py_accum_def[i_f2py++].data = nrstr;
  f2py_accum_def[i_f2py++].data = nrptl;
}
extern void F_FUNC(f2pyinitaccum,F2PYINITACCUM)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_accum(void) {
  F_FUNC(f2pyinitaccum,F2PYINITACCUM)(f2py_setup_accum);
}

static FortranDataDef f2py_accum2_def[] = {
  {"nglacc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_accum2(char *nglacc) {
  int i_f2py=0;
  f2py_accum2_def[i_f2py++].data = nglacc;
}
extern void F_FUNC(f2pyinitaccum2,F2PYINITACCUM2)(void(*)(char*));
static void f2py_init_accum2(void) {
  F_FUNC(f2pyinitaccum2,F2PYINITACCUM2)(f2py_setup_accum2);
}

static FortranDataDef f2py_cptlu_def[] = {
  {"nptlu",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cptlu(char *nptlu) {
  int i_f2py=0;
  f2py_cptlu_def[i_f2py++].data = nptlu;
}
extern void F_FUNC(f2pyinitcptlu,F2PYINITCPTLU)(void(*)(char*));
static void f2py_init_cptlu(void) {
  F_FUNC(f2pyinitcptlu,F2PYINITCPTLU)(f2py_setup_cptlu);
}

static FortranDataDef f2py_cnrclu_def[] = {
  {"nrclu",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cnrclu(char *nrclu) {
  int i_f2py=0;
  f2py_cnrclu_def[i_f2py++].data = nrclu;
}
extern void F_FUNC(f2pyinitcnrclu,F2PYINITCNRCLU)(void(*)(char*));
static void f2py_init_cnrclu(void) {
  F_FUNC(f2pyinitcnrclu,F2PYINITCNRCLU)(f2py_setup_cnrclu);
}

static FortranDataDef f2py_drop6_def[] = {
  {"tecm",0,{{-1}},NPY_FLOAT},
  {"volu",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_drop6(char *tecm,char *volu) {
  int i_f2py=0;
  f2py_drop6_def[i_f2py++].data = tecm;
  f2py_drop6_def[i_f2py++].data = volu;
}
extern void F_FUNC(f2pyinitdrop6,F2PYINITDROP6)(void(*)(char*,char*));
static void f2py_init_drop6(void) {
  F_FUNC(f2pyinitdrop6,F2PYINITDROP6)(f2py_setup_drop6);
}

static FortranDataDef f2py_metr5_def[] = {
  {"iterma",0,{{-1}},NPY_INT},
  {"iternc",0,{{-1}},NPY_INT},
  {"iterpr",0,{{-1}},NPY_INT},
  {"iterpl",0,{{-1}},NPY_INT},
  {"iozinc",0,{{-1}},NPY_INT},
  {"iozevt",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_metr5(char *iterma,char *iternc,char *iterpr,char *iterpl,char *iozinc,char *iozevt) {
  int i_f2py=0;
  f2py_metr5_def[i_f2py++].data = iterma;
  f2py_metr5_def[i_f2py++].data = iternc;
  f2py_metr5_def[i_f2py++].data = iterpr;
  f2py_metr5_def[i_f2py++].data = iterpl;
  f2py_metr5_def[i_f2py++].data = iozinc;
  f2py_metr5_def[i_f2py++].data = iozevt;
}
extern void F_FUNC(f2pyinitmetr5,F2PYINITMETR5)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_metr5(void) {
  F_FUNC(f2pyinitmetr5,F2PYINITMETR5)(f2py_setup_metr5);
}

static FortranDataDef f2py_metr6_def[] = {
  {"epsr",0,{{-1}},NPY_FLOAT},
  {"keepr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_metr6(char *epsr,char *keepr) {
  int i_f2py=0;
  f2py_metr6_def[i_f2py++].data = epsr;
  f2py_metr6_def[i_f2py++].data = keepr;
}
extern void F_FUNC(f2pyinitmetr6,F2PYINITMETR6)(void(*)(char*,char*));
static void f2py_init_metr6(void) {
  F_FUNC(f2pyinitmetr6,F2PYINITMETR6)(f2py_setup_metr6);
}

static FortranDataDef f2py_drop5_def[] = {
  {"keu",0,{{-1}},NPY_INT},
  {"ked",0,{{-1}},NPY_INT},
  {"kes",0,{{-1}},NPY_INT},
  {"kec",0,{{-1}},NPY_INT},
  {"keb",0,{{-1}},NPY_INT},
  {"ket",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_drop5(char *keu,char *ked,char *kes,char *kec,char *keb,char *ket) {
  int i_f2py=0;
  f2py_drop5_def[i_f2py++].data = keu;
  f2py_drop5_def[i_f2py++].data = ked;
  f2py_drop5_def[i_f2py++].data = kes;
  f2py_drop5_def[i_f2py++].data = kec;
  f2py_drop5_def[i_f2py++].data = keb;
  f2py_drop5_def[i_f2py++].data = ket;
}
extern void F_FUNC(f2pyinitdrop5,F2PYINITDROP5)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_drop5(void) {
  F_FUNC(f2pyinitdrop5,F2PYINITDROP5)(f2py_setup_drop5);
}

static FortranDataDef f2py_cseed_def[] = {
  {"seedi",0,{{-1}},NPY_DOUBLE},
  {"seedj",0,{{-1}},NPY_DOUBLE},
  {"seedj2",0,{{-1}},NPY_DOUBLE},
  {"seedc",0,{{-1}},NPY_DOUBLE},
  {"iseqini",0,{{-1}},NPY_INT},
  {"iseqsim",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cseed(char *seedi,char *seedj,char *seedj2,char *seedc,char *iseqini,char *iseqsim) {
  int i_f2py=0;
  f2py_cseed_def[i_f2py++].data = seedi;
  f2py_cseed_def[i_f2py++].data = seedj;
  f2py_cseed_def[i_f2py++].data = seedj2;
  f2py_cseed_def[i_f2py++].data = seedc;
  f2py_cseed_def[i_f2py++].data = iseqini;
  f2py_cseed_def[i_f2py++].data = iseqsim;
}
extern void F_FUNC(f2pyinitcseed,F2PYINITCSEED)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_cseed(void) {
  F_FUNC(f2pyinitcseed,F2PYINITCSEED)(f2py_setup_cseed);
}

static FortranDataDef f2py_cjintc_def[] = {
  {"clust",3,{{4,10,16}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cjintc(char *clust) {
  int i_f2py=0;
  f2py_cjintc_def[i_f2py++].data = clust;
}
extern void F_FUNC(f2pyinitcjintc,F2PYINITCJINTC)(void(*)(char*));
static void f2py_init_cjintc(void) {
  F_FUNC(f2pyinitcjintc,F2PYINITCJINTC)(f2py_setup_cjintc);
}

static FortranDataDef f2py_cjintd_def[] = {
  {"volsum",1,{{4}},NPY_FLOAT},
  {"vo2sum",1,{{4}},NPY_FLOAT},
  {"nclsum",1,{{4}},NPY_INT},
  {NULL}
};
static void f2py_setup_cjintd(char *volsum,char *vo2sum,char *nclsum) {
  int i_f2py=0;
  f2py_cjintd_def[i_f2py++].data = volsum;
  f2py_cjintd_def[i_f2py++].data = vo2sum;
  f2py_cjintd_def[i_f2py++].data = nclsum;
}
extern void F_FUNC(f2pyinitcjintd,F2PYINITCJINTD)(void(*)(char*,char*,char*));
static void f2py_init_cjintd(void) {
  F_FUNC(f2pyinitcjintd,F2PYINITCJINTD)(f2py_setup_cjintd);
}

static FortranDataDef f2py_ciutot_def[] = {
  {"iutotc",0,{{-1}},NPY_INT},
  {"iutote",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ciutot(char *iutotc,char *iutote) {
  int i_f2py=0;
  f2py_ciutot_def[i_f2py++].data = iutotc;
  f2py_ciutot_def[i_f2py++].data = iutote;
}
extern void F_FUNC(f2pyinitciutot,F2PYINITCIUTOT)(void(*)(char*,char*));
static void f2py_init_ciutot(void) {
  F_FUNC(f2pyinitciutot,F2PYINITCIUTOT)(f2py_setup_ciutot);
}

static FortranDataDef f2py_copen_def[] = {
  {"nopen",0,{{-1}},NPY_INT},
  {"nopenr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_copen(char *nopen,char *nopenr) {
  int i_f2py=0;
  f2py_copen_def[i_f2py++].data = nopen;
  f2py_copen_def[i_f2py++].data = nopenr;
}
extern void F_FUNC(f2pyinitcopen,F2PYINITCOPEN)(void(*)(char*,char*));
static void f2py_init_copen(void) {
  F_FUNC(f2pyinitcopen,F2PYINITCOPEN)(f2py_setup_copen);
}

static FortranDataDef f2py_kopen_def[] = {
  {"kchopen",0,{{-1}},NPY_INT},
  {"khiopen",0,{{-1}},NPY_INT},
  {"kdtopen",0,{{-1}},NPY_INT},
  {"kcpopen",0,{{-1}},NPY_INT},
  {"klgopen",0,{{-1}},NPY_INT},
  {"knxopen",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_kopen(char *kchopen,char *khiopen,char *kdtopen,char *kcpopen,char *klgopen,char *knxopen) {
  int i_f2py=0;
  f2py_kopen_def[i_f2py++].data = kchopen;
  f2py_kopen_def[i_f2py++].data = khiopen;
  f2py_kopen_def[i_f2py++].data = kdtopen;
  f2py_kopen_def[i_f2py++].data = kcpopen;
  f2py_kopen_def[i_f2py++].data = klgopen;
  f2py_kopen_def[i_f2py++].data = knxopen;
}
extern void F_FUNC(f2pyinitkopen,F2PYINITKOPEN)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_kopen(void) {
  F_FUNC(f2pyinitkopen,F2PYINITKOPEN)(f2py_setup_kopen);
}

static FortranDataDef f2py_vana1_def[] = {
  {"xvaria",1,{{6}},NPY_STRING},
  {"yvaria",1,{{6}},NPY_STRING},
  {"normal",0,{{-1}},NPY_INT},
  {"xminim",0,{{-1}},NPY_FLOAT},
  {"xmaxim",0,{{-1}},NPY_FLOAT},
  {"nrbins",0,{{-1}},NPY_INT},
  {"hisfac",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_vana1(char *xvaria,char *yvaria,char *normal,char *xminim,char *xmaxim,char *nrbins,char *hisfac) {
  int i_f2py=0;
  f2py_vana1_def[i_f2py++].data = xvaria;
  f2py_vana1_def[i_f2py++].data = yvaria;
  f2py_vana1_def[i_f2py++].data = normal;
  f2py_vana1_def[i_f2py++].data = xminim;
  f2py_vana1_def[i_f2py++].data = xmaxim;
  f2py_vana1_def[i_f2py++].data = nrbins;
  f2py_vana1_def[i_f2py++].data = hisfac;
}
extern void F_FUNC(f2pyinitvana1,F2PYINITVANA1)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_vana1(void) {
  F_FUNC(f2pyinitvana1,F2PYINITVANA1)(f2py_setup_vana1);
}

static FortranDataDef f2py_vana3_def[] = {
  {"iologb",0,{{-1}},NPY_INT},
  {"iocnxb",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_vana3(char *iologb,char *iocnxb) {
  int i_f2py=0;
  f2py_vana3_def[i_f2py++].data = iologb;
  f2py_vana3_def[i_f2py++].data = iocnxb;
}
extern void F_FUNC(f2pyinitvana3,F2PYINITVANA3)(void(*)(char*,char*));
static void f2py_init_vana3(void) {
  F_FUNC(f2pyinitvana3,F2PYINITVANA3)(f2py_setup_vana3);
}

static FortranDataDef f2py_nodcy_def[] = {
  {"nrnody",0,{{-1}},NPY_INT},
  {"nody",1,{{200}},NPY_INT},
  {NULL}
};
static void f2py_setup_nodcy(char *nrnody,char *nody) {
  int i_f2py=0;
  f2py_nodcy_def[i_f2py++].data = nrnody;
  f2py_nodcy_def[i_f2py++].data = nody;
}
extern void F_FUNC(f2pyinitnodcy,F2PYINITNODCY)(void(*)(char*,char*));
static void f2py_init_nodcy(void) {
  F_FUNC(f2pyinitnodcy,F2PYINITNODCY)(f2py_setup_nodcy);
}

static FortranDataDef f2py_ctdcy_def[] = {
  {"ctaumin",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_ctdcy(char *ctaumin) {
  int i_f2py=0;
  f2py_ctdcy_def[i_f2py++].data = ctaumin;
}
extern void F_FUNC(f2pyinitctdcy,F2PYINITCTDCY)(void(*)(char*));
static void f2py_init_ctdcy(void) {
  F_FUNC(f2pyinitctdcy,F2PYINITCTDCY)(f2py_setup_ctdcy);
}

static FortranDataDef f2py_prnt2_def[] = {
  {"nrpri",0,{{-1}},NPY_INT},
  {"subpri",2,{{200,20}},NPY_STRING},
  {"ishpri",1,{{200}},NPY_INT},
  {NULL}
};
static void f2py_setup_prnt2(char *nrpri,char *subpri,char *ishpri) {
  int i_f2py=0;
  f2py_prnt2_def[i_f2py++].data = nrpri;
  f2py_prnt2_def[i_f2py++].data = subpri;
  f2py_prnt2_def[i_f2py++].data = ishpri;
}
extern void F_FUNC(f2pyinitprnt2,F2PYINITPRNT2)(void(*)(char*,char*,char*));
static void f2py_init_prnt2(void) {
  F_FUNC(f2pyinitprnt2,F2PYINITPRNT2)(f2py_setup_prnt2);
}

static FortranDataDef f2py_prnt3_def[] = {
  {"ishevt",0,{{-1}},NPY_INT},
  {"ixtau",0,{{-1}},NPY_INT},
  {"iwseed",0,{{-1}},NPY_INT},
  {"jwseed",0,{{-1}},NPY_INT},
  {"ixgeometry",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_prnt3(char *ishevt,char *ixtau,char *iwseed,char *jwseed,char *ixgeometry) {
  int i_f2py=0;
  f2py_prnt3_def[i_f2py++].data = ishevt;
  f2py_prnt3_def[i_f2py++].data = ixtau;
  f2py_prnt3_def[i_f2py++].data = iwseed;
  f2py_prnt3_def[i_f2py++].data = jwseed;
  f2py_prnt3_def[i_f2py++].data = ixgeometry;
}
extern void F_FUNC(f2pyinitprnt3,F2PYINITPRNT3)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_prnt3(void) {
  F_FUNC(f2pyinitprnt3,F2PYINITPRNT3)(f2py_setup_prnt3);
}

static FortranDataDef f2py_vana4_def[] = {
  {"ar",2,{{10000,5}},NPY_FLOAT},
  {"ary",2,{{10000,20}},NPY_FLOAT},
  {"ardy",2,{{10000,20}},NPY_FLOAT},
  {"ionoerr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_vana4(char *ar,char *ary,char *ardy,char *ionoerr) {
  int i_f2py=0;
  f2py_vana4_def[i_f2py++].data = ar;
  f2py_vana4_def[i_f2py++].data = ary;
  f2py_vana4_def[i_f2py++].data = ardy;
  f2py_vana4_def[i_f2py++].data = ionoerr;
}
extern void F_FUNC(f2pyinitvana4,F2PYINITVANA4)(void(*)(char*,char*,char*,char*));
static void f2py_init_vana4(void) {
  F_FUNC(f2pyinitvana4,F2PYINITVANA4)(f2py_setup_vana4);
}

static FortranDataDef f2py_xpars_def[] = {
  {"xpar1",0,{{-1}},NPY_FLOAT},
  {"xpar2",0,{{-1}},NPY_FLOAT},
  {"xpar3",0,{{-1}},NPY_FLOAT},
  {"xpar4",0,{{-1}},NPY_FLOAT},
  {"xpar5",0,{{-1}},NPY_FLOAT},
  {"xpar6",0,{{-1}},NPY_FLOAT},
  {"xpar7",0,{{-1}},NPY_FLOAT},
  {"xpar8",0,{{-1}},NPY_FLOAT},
  {"xpar99",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_xpars(char *xpar1,char *xpar2,char *xpar3,char *xpar4,char *xpar5,char *xpar6,char *xpar7,char *xpar8,char *xpar99) {
  int i_f2py=0;
  f2py_xpars_def[i_f2py++].data = xpar1;
  f2py_xpars_def[i_f2py++].data = xpar2;
  f2py_xpars_def[i_f2py++].data = xpar3;
  f2py_xpars_def[i_f2py++].data = xpar4;
  f2py_xpars_def[i_f2py++].data = xpar5;
  f2py_xpars_def[i_f2py++].data = xpar6;
  f2py_xpars_def[i_f2py++].data = xpar7;
  f2py_xpars_def[i_f2py++].data = xpar8;
  f2py_xpars_def[i_f2py++].data = xpar99;
}
extern void F_FUNC(f2pyinitxpars,F2PYINITXPARS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_xpars(void) {
  F_FUNC(f2pyinitxpars,F2PYINITXPARS)(f2py_setup_xpars);
}

static FortranDataDef f2py_khist_def[] = {
  {"khisto",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_khist(char *khisto) {
  int i_f2py=0;
  f2py_khist_def[i_f2py++].data = khisto;
}
extern void F_FUNC(f2pyinitkhist,F2PYINITKHIST)(void(*)(char*));
static void f2py_init_khist(void) {
  F_FUNC(f2pyinitkhist,F2PYINITKHIST)(f2py_setup_khist);
}

static FortranDataDef f2py_ctcor_def[] = {
  {"nctcor",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ctcor(char *nctcor) {
  int i_f2py=0;
  f2py_ctcor_def[i_f2py++].data = nctcor;
}
extern void F_FUNC(f2pyinitctcor,F2PYINITCTCOR)(void(*)(char*));
static void f2py_init_ctcor(void) {
  F_FUNC(f2pyinitctcor,F2PYINITCTCOR)(f2py_setup_ctcor);
}

static FortranDataDef f2py_ccttim_def[] = {
  {"ncttim",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ccttim(char *ncttim) {
  int i_f2py=0;
  f2py_ccttim_def[i_f2py++].data = ncttim;
}
extern void F_FUNC(f2pyinitccttim,F2PYINITCCTTIM)(void(*)(char*));
static void f2py_init_ccttim(void) {
  F_FUNC(f2pyinitccttim,F2PYINITCCTTIM)(f2py_setup_ccttim);
}

static FortranDataDef f2py_densi_def[] = {
  {"kdensi",4,{{10,60,40,10}},NPY_INT},
  {"tauv",1,{{10}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_densi(char *kdensi,char *tauv) {
  int i_f2py=0;
  f2py_densi_def[i_f2py++].data = kdensi;
  f2py_densi_def[i_f2py++].data = tauv;
}
extern void F_FUNC(f2pyinitdensi,F2PYINITDENSI)(void(*)(char*,char*));
static void f2py_init_densi(void) {
  F_FUNC(f2pyinitdensi,F2PYINITDENSI)(f2py_setup_densi);
}

static FortranDataDef f2py_cjinti_def[] = {
  {"iorsce",0,{{-1}},NPY_INT},
  {"iorsdf",0,{{-1}},NPY_INT},
  {"iorshh",0,{{-1}},NPY_INT},
  {"ionudi",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cjinti(char *iorsce,char *iorsdf,char *iorshh,char *ionudi) {
  int i_f2py=0;
  f2py_cjinti_def[i_f2py++].data = iorsce;
  f2py_cjinti_def[i_f2py++].data = iorsdf;
  f2py_cjinti_def[i_f2py++].data = iorshh;
  f2py_cjinti_def[i_f2py++].data = ionudi;
}
extern void F_FUNC(f2pyinitcjinti,F2PYINITCJINTI)(void(*)(char*,char*,char*,char*));
static void f2py_init_cjinti(void) {
  F_FUNC(f2pyinitcjinti,F2PYINITCJINTI)(f2py_setup_cjinti);
}

static FortranDataDef f2py_camim_def[] = {
  {"amimfs",0,{{-1}},NPY_FLOAT},
  {"amimel",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_camim(char *amimfs,char *amimel) {
  int i_f2py=0;
  f2py_camim_def[i_f2py++].data = amimfs;
  f2py_camim_def[i_f2py++].data = amimel;
}
extern void F_FUNC(f2pyinitcamim,F2PYINITCAMIM)(void(*)(char*,char*));
static void f2py_init_camim(void) {
  F_FUNC(f2pyinitcamim,F2PYINITCAMIM)(f2py_setup_camim);
}

static FortranDataDef f2py_craddf_def[] = {
  {"scr",0,{{-1}},NPY_FLOAT},
  {"scs",0,{{-1}},NPY_FLOAT},
  {"hacore",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_craddf(char *scr,char *scs,char *hacore) {
  int i_f2py=0;
  f2py_craddf_def[i_f2py++].data = scr;
  f2py_craddf_def[i_f2py++].data = scs;
  f2py_craddf_def[i_f2py++].data = hacore;
}
extern void F_FUNC(f2pyinitcraddf,F2PYINITCRADDF)(void(*)(char*,char*,char*));
static void f2py_init_craddf(void) {
  F_FUNC(f2pyinitcraddf,F2PYINITCRADDF)(f2py_setup_craddf);
}

static FortranDataDef f2py_ckoll_def[] = {
  {"iokoll",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ckoll(char *iokoll) {
  int i_f2py=0;
  f2py_ckoll_def[i_f2py++].data = iokoll;
}
extern void F_FUNC(f2pyinitckoll,F2PYINITCKOLL)(void(*)(char*));
static void f2py_init_ckoll(void) {
  F_FUNC(f2pyinitckoll,F2PYINITCKOLL)(f2py_setup_ckoll);
}

static FortranDataDef f2py_cncnt_def[] = {
  {"ncnt",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cncnt(char *ncnt) {
  int i_f2py=0;
  f2py_cncnt_def[i_f2py++].data = ncnt;
}
extern void F_FUNC(f2pyinitcncnt,F2PYINITCNCNT)(void(*)(char*));
static void f2py_init_cncnt(void) {
  F_FUNC(f2pyinitcncnt,F2PYINITCNCNT)(f2py_setup_cncnt);
}

static FortranDataDef f2py_cicnt_def[] = {
  {"inicnt",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cicnt(char *inicnt) {
  int i_f2py=0;
  f2py_cicnt_def[i_f2py++].data = inicnt;
}
extern void F_FUNC(f2pyinitcicnt,F2PYINITCICNT)(void(*)(char*));
static void f2py_init_cicnt(void) {
  F_FUNC(f2pyinitcicnt,F2PYINITCICNT)(f2py_setup_cicnt);
}

static FortranDataDef f2py_cnemsi_def[] = {
  {"nemsi",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cnemsi(char *nemsi) {
  int i_f2py=0;
  f2py_cnemsi_def[i_f2py++].data = nemsi;
}
extern void F_FUNC(f2pyinitcnemsi,F2PYINITCNEMSI)(void(*)(char*));
static void f2py_init_cnemsi(void) {
  F_FUNC(f2pyinitcnemsi,F2PYINITCNEMSI)(f2py_setup_cnemsi);
}

static FortranDataDef f2py_ems1_def[] = {
  {"iemspl",0,{{-1}},NPY_INT},
  {"iemsct",0,{{-1}},NPY_INT},
  {"gfactor",0,{{-1}},NPY_FLOAT},
  {"gwidth",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_ems1(char *iemspl,char *iemsct,char *gfactor,char *gwidth) {
  int i_f2py=0;
  f2py_ems1_def[i_f2py++].data = iemspl;
  f2py_ems1_def[i_f2py++].data = iemsct;
  f2py_ems1_def[i_f2py++].data = gfactor;
  f2py_ems1_def[i_f2py++].data = gwidth;
}
extern void F_FUNC(f2pyinitems1,F2PYINITEMS1)(void(*)(char*,char*,char*,char*));
static void f2py_init_ems1(void) {
  F_FUNC(f2pyinitems1,F2PYINITEMS1)(f2py_setup_ems1);
}

static FortranDataDef f2py_chadron_def[] = {
  {"amproj",0,{{-1}},NPY_FLOAT},
  {"amtarg",0,{{-1}},NPY_FLOAT},
  {"ypjtl",0,{{-1}},NPY_FLOAT},
  {"yhaha",0,{{-1}},NPY_FLOAT},
  {"pnullx",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_chadron(char *amproj,char *amtarg,char *ypjtl,char *yhaha,char *pnullx) {
  int i_f2py=0;
  f2py_chadron_def[i_f2py++].data = amproj;
  f2py_chadron_def[i_f2py++].data = amtarg;
  f2py_chadron_def[i_f2py++].data = ypjtl;
  f2py_chadron_def[i_f2py++].data = yhaha;
  f2py_chadron_def[i_f2py++].data = pnullx;
}
extern void F_FUNC(f2pyinitchadron,F2PYINITCHADRON)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_chadron(void) {
  F_FUNC(f2pyinitchadron,F2PYINITCHADRON)(f2py_setup_chadron);
}

static FortranDataDef f2py_vana5_def[] = {
  {"xshift",0,{{-1}},NPY_FLOAT},
  {"etacut",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_vana5(char *xshift,char *etacut) {
  int i_f2py=0;
  f2py_vana5_def[i_f2py++].data = xshift;
  f2py_vana5_def[i_f2py++].data = etacut;
}
extern void F_FUNC(f2pyinitvana5,F2PYINITVANA5)(void(*)(char*,char*));
static void f2py_init_vana5(void) {
  F_FUNC(f2pyinitvana5,F2PYINITVANA5)(f2py_setup_vana5);
}

static FortranDataDef f2py_nucl5_def[] = {
  {"rnucl",2,{{20,2}},NPY_DOUBLE},
  {"bnucl",2,{{20,4}},NPY_FLOAT},
  {"xbtot",1,{{4}},NPY_FLOAT},
  {"ixbdens",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_nucl5(char *rnucl,char *bnucl,char *xbtot,char *ixbdens) {
  int i_f2py=0;
  f2py_nucl5_def[i_f2py++].data = rnucl;
  f2py_nucl5_def[i_f2py++].data = bnucl;
  f2py_nucl5_def[i_f2py++].data = xbtot;
  f2py_nucl5_def[i_f2py++].data = ixbdens;
}
extern void F_FUNC(f2pyinitnucl5,F2PYINITNUCL5)(void(*)(char*,char*,char*,char*));
static void f2py_init_nucl5(void) {
  F_FUNC(f2pyinitnucl5,F2PYINITNUCL5)(f2py_setup_nucl5);
}

static FortranDataDef f2py_nucl6_def[] = {
  {"infragm",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_nucl6(char *infragm) {
  int i_f2py=0;
  f2py_nucl6_def[i_f2py++].data = infragm;
}
extern void F_FUNC(f2pyinitnucl6,F2PYINITNUCL6)(void(*)(char*));
static void f2py_init_nucl6(void) {
  F_FUNC(f2pyinitnucl6,F2PYINITNUCL6)(f2py_setup_nucl6);
}

static FortranDataDef f2py_nucl4_def[] = {
  {"nrnucl",1,{{2}},NPY_INT},
  {"drnucl",1,{{2}},NPY_FLOAT},
  {"rnuclo",2,{{20,2}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_nucl4(char *nrnucl,char *drnucl,char *rnuclo) {
  int i_f2py=0;
  f2py_nucl4_def[i_f2py++].data = nrnucl;
  f2py_nucl4_def[i_f2py++].data = drnucl;
  f2py_nucl4_def[i_f2py++].data = rnuclo;
}
extern void F_FUNC(f2pyinitnucl4,F2PYINITNUCL4)(void(*)(char*,char*,char*));
static void f2py_init_nucl4(void) {
  F_FUNC(f2pyinitnucl4,F2PYINITNUCL4)(f2py_setup_nucl4);
}

static FortranDataDef f2py_sig_def[] = {
  {"xsig",1,{{7}},NPY_FLOAT},
  {"xpom",1,{{7}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_sig(char *xsig,char *xpom) {
  int i_f2py=0;
  f2py_sig_def[i_f2py++].data = xsig;
  f2py_sig_def[i_f2py++].data = xpom;
}
extern void F_FUNC(f2pyinitsig,F2PYINITSIG)(void(*)(char*,char*));
static void f2py_init_sig(void) {
  F_FUNC(f2pyinitsig,F2PYINITSIG)(f2py_setup_sig);
}

static FortranDataDef f2py_metr7_def[] = {
  {"ktnbod",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_metr7(char *ktnbod) {
  int i_f2py=0;
  f2py_metr7_def[i_f2py++].data = ktnbod;
}
extern void F_FUNC(f2pyinitmetr7,F2PYINITMETR7)(void(*)(char*));
static void f2py_init_metr7(void) {
  F_FUNC(f2pyinitmetr7,F2PYINITMETR7)(f2py_setup_metr7);
}

static FortranDataDef f2py_hadr3_def[] = {
  {"iregge",0,{{-1}},NPY_INT},
  {"isopom",0,{{-1}},NPY_INT},
  {"ishpom",0,{{-1}},NPY_INT},
  {"iscreen",0,{{-1}},NPY_INT},
  {"nprmax",0,{{-1}},NPY_INT},
  {"inueff",0,{{-1}},NPY_INT},
  {"irmdrop",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_hadr3(char *iregge,char *isopom,char *ishpom,char *iscreen,char *nprmax,char *inueff,char *irmdrop) {
  int i_f2py=0;
  f2py_hadr3_def[i_f2py++].data = iregge;
  f2py_hadr3_def[i_f2py++].data = isopom;
  f2py_hadr3_def[i_f2py++].data = ishpom;
  f2py_hadr3_def[i_f2py++].data = iscreen;
  f2py_hadr3_def[i_f2py++].data = nprmax;
  f2py_hadr3_def[i_f2py++].data = inueff;
  f2py_hadr3_def[i_f2py++].data = irmdrop;
}
extern void F_FUNC(f2pyinithadr3,F2PYINITHADR3)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr3(void) {
  F_FUNC(f2pyinithadr3,F2PYINITHADR3)(f2py_setup_hadr3);
}

static FortranDataDef f2py_hadr5_def[] = {
  {"sigtot",0,{{-1}},NPY_FLOAT},
  {"sigcut",0,{{-1}},NPY_FLOAT},
  {"sigela",0,{{-1}},NPY_FLOAT},
  {"sloela",0,{{-1}},NPY_FLOAT},
  {"sigsd",0,{{-1}},NPY_FLOAT},
  {"sigine",0,{{-1}},NPY_FLOAT},
  {"sigdif",0,{{-1}},NPY_FLOAT},
  {"sigineaa",0,{{-1}},NPY_FLOAT},
  {"sigtotaa",0,{{-1}},NPY_FLOAT},
  {"sigelaaa",0,{{-1}},NPY_FLOAT},
  {"sigcutaa",0,{{-1}},NPY_FLOAT},
  {"sigdd",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr5(char *sigtot,char *sigcut,char *sigela,char *sloela,char *sigsd,char *sigine,char *sigdif,char *sigineaa,char *sigtotaa,char *sigelaaa,char *sigcutaa,char *sigdd) {
  int i_f2py=0;
  f2py_hadr5_def[i_f2py++].data = sigtot;
  f2py_hadr5_def[i_f2py++].data = sigcut;
  f2py_hadr5_def[i_f2py++].data = sigela;
  f2py_hadr5_def[i_f2py++].data = sloela;
  f2py_hadr5_def[i_f2py++].data = sigsd;
  f2py_hadr5_def[i_f2py++].data = sigine;
  f2py_hadr5_def[i_f2py++].data = sigdif;
  f2py_hadr5_def[i_f2py++].data = sigineaa;
  f2py_hadr5_def[i_f2py++].data = sigtotaa;
  f2py_hadr5_def[i_f2py++].data = sigelaaa;
  f2py_hadr5_def[i_f2py++].data = sigcutaa;
  f2py_hadr5_def[i_f2py++].data = sigdd;
}
extern void F_FUNC(f2pyinithadr5,F2PYINITHADR5)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr5(void) {
  F_FUNC(f2pyinithadr5,F2PYINITHADR5)(f2py_setup_hadr5);
}

static FortranDataDef f2py_hadr6_def[] = {
  {"intpol",0,{{-1}},NPY_INT},
  {"isigma",0,{{-1}},NPY_INT},
  {"iomega",0,{{-1}},NPY_INT},
  {"isetcs",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_hadr6(char *intpol,char *isigma,char *iomega,char *isetcs) {
  int i_f2py=0;
  f2py_hadr6_def[i_f2py++].data = intpol;
  f2py_hadr6_def[i_f2py++].data = isigma;
  f2py_hadr6_def[i_f2py++].data = iomega;
  f2py_hadr6_def[i_f2py++].data = isetcs;
}
extern void F_FUNC(f2pyinithadr6,F2PYINITHADR6)(void(*)(char*,char*,char*,char*));
static void f2py_init_hadr6(void) {
  F_FUNC(f2pyinithadr6,F2PYINITHADR6)(f2py_setup_hadr6);
}

static FortranDataDef f2py_hadr4_def[] = {
  {"alppom",0,{{-1}},NPY_FLOAT},
  {"slopom",0,{{-1}},NPY_FLOAT},
  {"gamhad",1,{{4}},NPY_FLOAT},
  {"r2had",1,{{4}},NPY_FLOAT},
  {"chad",1,{{4}},NPY_FLOAT},
  {"wdiff",1,{{4}},NPY_FLOAT},
  {"gamtil",0,{{-1}},NPY_FLOAT},
  {"facdif",0,{{-1}},NPY_FLOAT},
  {"facmc",0,{{-1}},NPY_FLOAT},
  {"r2hads",1,{{4}},NPY_FLOAT},
  {"gamhads",1,{{4}},NPY_FLOAT},
  {"slopoms",0,{{-1}},NPY_FLOAT},
  {"isplit",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_hadr4(char *alppom,char *slopom,char *gamhad,char *r2had,char *chad,char *wdiff,char *gamtil,char *facdif,char *facmc,char *r2hads,char *gamhads,char *slopoms,char *isplit) {
  int i_f2py=0;
  f2py_hadr4_def[i_f2py++].data = alppom;
  f2py_hadr4_def[i_f2py++].data = slopom;
  f2py_hadr4_def[i_f2py++].data = gamhad;
  f2py_hadr4_def[i_f2py++].data = r2had;
  f2py_hadr4_def[i_f2py++].data = chad;
  f2py_hadr4_def[i_f2py++].data = wdiff;
  f2py_hadr4_def[i_f2py++].data = gamtil;
  f2py_hadr4_def[i_f2py++].data = facdif;
  f2py_hadr4_def[i_f2py++].data = facmc;
  f2py_hadr4_def[i_f2py++].data = r2hads;
  f2py_hadr4_def[i_f2py++].data = gamhads;
  f2py_hadr4_def[i_f2py++].data = slopoms;
  f2py_hadr4_def[i_f2py++].data = isplit;
}
extern void F_FUNC(f2pyinithadr4,F2PYINITHADR4)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr4(void) {
  F_FUNC(f2pyinithadr4,F2PYINITHADR4)(f2py_setup_hadr4);
}

static FortranDataDef f2py_hadr42_def[] = {
  {"gamhadsi",1,{{4}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr42(char *gamhadsi) {
  int i_f2py=0;
  f2py_hadr42_def[i_f2py++].data = gamhadsi;
}
extern void F_FUNC(f2pyinithadr42,F2PYINITHADR42)(void(*)(char*));
static void f2py_init_hadr42(void) {
  F_FUNC(f2pyinithadr42,F2PYINITHADR42)(f2py_setup_hadr42);
}

static FortranDataDef f2py_hadr7_def[] = {
  {"alpreg",0,{{-1}},NPY_FLOAT},
  {"sloreg",0,{{-1}},NPY_FLOAT},
  {"gamreg",0,{{-1}},NPY_FLOAT},
  {"r2reg",0,{{-1}},NPY_FLOAT},
  {"ptdiff",0,{{-1}},NPY_FLOAT},
  {"ptsend",0,{{-1}},NPY_FLOAT},
  {"xminremn",0,{{-1}},NPY_FLOAT},
  {"xmindiff",0,{{-1}},NPY_FLOAT},
  {"ptsecu",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr7(char *alpreg,char *sloreg,char *gamreg,char *r2reg,char *ptdiff,char *ptsend,char *xminremn,char *xmindiff,char *ptsecu) {
  int i_f2py=0;
  f2py_hadr7_def[i_f2py++].data = alpreg;
  f2py_hadr7_def[i_f2py++].data = sloreg;
  f2py_hadr7_def[i_f2py++].data = gamreg;
  f2py_hadr7_def[i_f2py++].data = r2reg;
  f2py_hadr7_def[i_f2py++].data = ptdiff;
  f2py_hadr7_def[i_f2py++].data = ptsend;
  f2py_hadr7_def[i_f2py++].data = xminremn;
  f2py_hadr7_def[i_f2py++].data = xmindiff;
  f2py_hadr7_def[i_f2py++].data = ptsecu;
}
extern void F_FUNC(f2pyinithadr7,F2PYINITHADR7)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr7(void) {
  F_FUNC(f2pyinithadr7,F2PYINITHADR7)(f2py_setup_hadr7);
}

static FortranDataDef f2py_hadr8_def[] = {
  {"alpqua",0,{{-1}},NPY_FLOAT},
  {"alppar",0,{{-1}},NPY_FLOAT},
  {"alpsea",0,{{-1}},NPY_FLOAT},
  {"alpval",0,{{-1}},NPY_FLOAT},
  {"alpdiq",0,{{-1}},NPY_FLOAT},
  {"alplea",1,{{4}},NPY_FLOAT},
  {"alpdif",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr8(char *alpqua,char *alppar,char *alpsea,char *alpval,char *alpdiq,char *alplea,char *alpdif) {
  int i_f2py=0;
  f2py_hadr8_def[i_f2py++].data = alpqua;
  f2py_hadr8_def[i_f2py++].data = alppar;
  f2py_hadr8_def[i_f2py++].data = alpsea;
  f2py_hadr8_def[i_f2py++].data = alpval;
  f2py_hadr8_def[i_f2py++].data = alpdiq;
  f2py_hadr8_def[i_f2py++].data = alplea;
  f2py_hadr8_def[i_f2py++].data = alpdif;
}
extern void F_FUNC(f2pyinithadr8,F2PYINITHADR8)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr8(void) {
  F_FUNC(f2pyinithadr8,F2PYINITHADR8)(f2py_setup_hadr8);
}

static FortranDataDef f2py_hadr14_def[] = {
  {"alpndi",0,{{-1}},NPY_FLOAT},
  {"alpdi",0,{{-1}},NPY_FLOAT},
  {"ptsendi",0,{{-1}},NPY_FLOAT},
  {"zdrinc",0,{{-1}},NPY_FLOAT},
  {"zmsinc",0,{{-1}},NPY_FLOAT},
  {"ptsems",0,{{-1}},NPY_FLOAT},
  {"irzptn",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_hadr14(char *alpndi,char *alpdi,char *ptsendi,char *zdrinc,char *zmsinc,char *ptsems,char *irzptn) {
  int i_f2py=0;
  f2py_hadr14_def[i_f2py++].data = alpndi;
  f2py_hadr14_def[i_f2py++].data = alpdi;
  f2py_hadr14_def[i_f2py++].data = ptsendi;
  f2py_hadr14_def[i_f2py++].data = zdrinc;
  f2py_hadr14_def[i_f2py++].data = zmsinc;
  f2py_hadr14_def[i_f2py++].data = ptsems;
  f2py_hadr14_def[i_f2py++].data = irzptn;
}
extern void F_FUNC(f2pyinithadr14,F2PYINITHADR14)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr14(void) {
  F_FUNC(f2pyinithadr14,F2PYINITHADR14)(f2py_setup_hadr14);
}

static FortranDataDef f2py_hadr15_def[] = {
  {"zbcut",0,{{-1}},NPY_FLOAT},
  {"zopinc",0,{{-1}},NPY_FLOAT},
  {"zipinc",0,{{-1}},NPY_FLOAT},
  {"zoeinc",0,{{-1}},NPY_FLOAT},
  {"xmxrem",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr15(char *zbcut,char *zopinc,char *zipinc,char *zoeinc,char *xmxrem) {
  int i_f2py=0;
  f2py_hadr15_def[i_f2py++].data = zbcut;
  f2py_hadr15_def[i_f2py++].data = zopinc;
  f2py_hadr15_def[i_f2py++].data = zipinc;
  f2py_hadr15_def[i_f2py++].data = zoeinc;
  f2py_hadr15_def[i_f2py++].data = xmxrem;
}
extern void F_FUNC(f2pyinithadr15,F2PYINITHADR15)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_hadr15(void) {
  F_FUNC(f2pyinithadr15,F2PYINITHADR15)(f2py_setup_hadr15);
}

static FortranDataDef f2py_hadr16_def[] = {
  {"fkainc",0,{{-1}},NPY_FLOAT},
  {"fkamax",0,{{-1}},NPY_FLOAT},
  {"zodinc",0,{{-1}},NPY_FLOAT},
  {"zbrmax",0,{{-1}},NPY_FLOAT},
  {"zdfinc",0,{{-1}},NPY_FLOAT},
  {"xzcut",0,{{-1}},NPY_FLOAT},
  {"ptvpom",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr16(char *fkainc,char *fkamax,char *zodinc,char *zbrmax,char *zdfinc,char *xzcut,char *ptvpom) {
  int i_f2py=0;
  f2py_hadr16_def[i_f2py++].data = fkainc;
  f2py_hadr16_def[i_f2py++].data = fkamax;
  f2py_hadr16_def[i_f2py++].data = zodinc;
  f2py_hadr16_def[i_f2py++].data = zbrmax;
  f2py_hadr16_def[i_f2py++].data = zdfinc;
  f2py_hadr16_def[i_f2py++].data = xzcut;
  f2py_hadr16_def[i_f2py++].data = ptvpom;
}
extern void F_FUNC(f2pyinithadr16,F2PYINITHADR16)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr16(void) {
  F_FUNC(f2pyinithadr16,F2PYINITHADR16)(f2py_setup_hadr16);
}

static FortranDataDef f2py_hadr17_def[] = {
  {"edmaxi",0,{{-1}},NPY_FLOAT},
  {"epmaxi",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr17(char *edmaxi,char *epmaxi) {
  int i_f2py=0;
  f2py_hadr17_def[i_f2py++].data = edmaxi;
  f2py_hadr17_def[i_f2py++].data = epmaxi;
}
extern void F_FUNC(f2pyinithadr17,F2PYINITHADR17)(void(*)(char*,char*));
static void f2py_init_hadr17(void) {
  F_FUNC(f2pyinithadr17,F2PYINITHADR17)(f2py_setup_hadr17);
}

static FortranDataDef f2py_hadr9_def[] = {
  {"ammsqq",0,{{-1}},NPY_FLOAT},
  {"ammsqd",0,{{-1}},NPY_FLOAT},
  {"ammsdd",0,{{-1}},NPY_FLOAT},
  {"cumpom",0,{{-1}},NPY_FLOAT},
  {"rexndi",1,{{4}},NPY_FLOAT},
  {"rexdif",1,{{4}},NPY_FLOAT},
  {"reminv",0,{{-1}},NPY_FLOAT},
  {"rexpdif",1,{{4}},NPY_FLOAT},
  {"rexres",1,{{4}},NPY_FLOAT},
  {"zrminc",0,{{-1}},NPY_FLOAT},
  {"rexndf",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_hadr9(char *ammsqq,char *ammsqd,char *ammsdd,char *cumpom,char *rexndi,char *rexdif,char *reminv,char *rexpdif,char *rexres,char *zrminc,char *rexndf) {
  int i_f2py=0;
  f2py_hadr9_def[i_f2py++].data = ammsqq;
  f2py_hadr9_def[i_f2py++].data = ammsqd;
  f2py_hadr9_def[i_f2py++].data = ammsdd;
  f2py_hadr9_def[i_f2py++].data = cumpom;
  f2py_hadr9_def[i_f2py++].data = rexndi;
  f2py_hadr9_def[i_f2py++].data = rexdif;
  f2py_hadr9_def[i_f2py++].data = reminv;
  f2py_hadr9_def[i_f2py++].data = rexpdif;
  f2py_hadr9_def[i_f2py++].data = rexres;
  f2py_hadr9_def[i_f2py++].data = zrminc;
  f2py_hadr9_def[i_f2py++].data = rexndf;
}
extern void F_FUNC(f2pyinithadr9,F2PYINITHADR9)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hadr9(void) {
  F_FUNC(f2pyinithadr9,F2PYINITHADR9)(f2py_setup_hadr9);
}

static FortranDataDef f2py_had10_def[] = {
  {"iclpro",0,{{-1}},NPY_INT},
  {"icltar",0,{{-1}},NPY_INT},
  {"iclegy",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_had10(char *iclpro,char *icltar,char *iclegy) {
  int i_f2py=0;
  f2py_had10_def[i_f2py++].data = iclpro;
  f2py_had10_def[i_f2py++].data = icltar;
  f2py_had10_def[i_f2py++].data = iclegy;
}
extern void F_FUNC(f2pyinithad10,F2PYINITHAD10)(void(*)(char*,char*,char*));
static void f2py_init_had10(void) {
  F_FUNC(f2pyinithad10,F2PYINITHAD10)(f2py_setup_had10);
}

static FortranDataDef f2py_had11_def[] = {
  {"iclpro1",0,{{-1}},NPY_INT},
  {"iclpro2",0,{{-1}},NPY_INT},
  {"icltar1",0,{{-1}},NPY_INT},
  {"icltar2",0,{{-1}},NPY_INT},
  {"iclegy1",0,{{-1}},NPY_INT},
  {"iclegy2",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_had11(char *iclpro1,char *iclpro2,char *icltar1,char *icltar2,char *iclegy1,char *iclegy2) {
  int i_f2py=0;
  f2py_had11_def[i_f2py++].data = iclpro1;
  f2py_had11_def[i_f2py++].data = iclpro2;
  f2py_had11_def[i_f2py++].data = icltar1;
  f2py_had11_def[i_f2py++].data = icltar2;
  f2py_had11_def[i_f2py++].data = iclegy1;
  f2py_had11_def[i_f2py++].data = iclegy2;
}
extern void F_FUNC(f2pyinithad11,F2PYINITHAD11)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_had11(void) {
  F_FUNC(f2pyinithad11,F2PYINITHAD11)(f2py_setup_had11);
}

static FortranDataDef f2py_had12_def[] = {
  {"egylow",0,{{-1}},NPY_FLOAT},
  {"egyfac",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_had12(char *egylow,char *egyfac) {
  int i_f2py=0;
  f2py_had12_def[i_f2py++].data = egylow;
  f2py_had12_def[i_f2py++].data = egyfac;
}
extern void F_FUNC(f2pyinithad12,F2PYINITHAD12)(void(*)(char*,char*));
static void f2py_init_had12(void) {
  F_FUNC(f2pyinithad12,F2PYINITHAD12)(f2py_setup_had12);
}

static FortranDataDef f2py_had13_def[] = {
  {"amdrmax",0,{{-1}},NPY_FLOAT},
  {"amdrmin",0,{{-1}},NPY_FLOAT},
  {"alpdro",1,{{3}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_had13(char *amdrmax,char *amdrmin,char *alpdro) {
  int i_f2py=0;
  f2py_had13_def[i_f2py++].data = amdrmax;
  f2py_had13_def[i_f2py++].data = amdrmin;
  f2py_had13_def[i_f2py++].data = alpdro;
}
extern void F_FUNC(f2pyinithad13,F2PYINITHAD13)(void(*)(char*,char*,char*));
static void f2py_init_had13(void) {
  F_FUNC(f2pyinithad13,F2PYINITHAD13)(f2py_setup_had13);
}

static FortranDataDef f2py_had14_def[] = {
  {"alpcoso",0,{{-1}},NPY_FLOAT},
  {"alpcose",0,{{-1}},NPY_FLOAT},
  {"betcoso",0,{{-1}},NPY_FLOAT},
  {"betcose",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_had14(char *alpcoso,char *alpcose,char *betcoso,char *betcose) {
  int i_f2py=0;
  f2py_had14_def[i_f2py++].data = alpcoso;
  f2py_had14_def[i_f2py++].data = alpcose;
  f2py_had14_def[i_f2py++].data = betcoso;
  f2py_had14_def[i_f2py++].data = betcose;
}
extern void F_FUNC(f2pyinithad14,F2PYINITHAD14)(void(*)(char*,char*,char*,char*));
static void f2py_init_had14(void) {
  F_FUNC(f2pyinithad14,F2PYINITHAD14)(f2py_setup_had14);
}

static FortranDataDef f2py_emsx1_def[] = {
  {"accept",0,{{-1}},NPY_FLOAT},
  {"reject",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_emsx1(char *accept,char *reject) {
  int i_f2py=0;
  f2py_emsx1_def[i_f2py++].data = accept;
  f2py_emsx1_def[i_f2py++].data = reject;
}
extern void F_FUNC(f2pyinitemsx1,F2PYINITEMSX1)(void(*)(char*,char*));
static void f2py_init_emsx1(void) {
  F_FUNC(f2pyinitemsx1,F2PYINITEMSX1)(f2py_setup_emsx1);
}

static FortranDataDef f2py_xems1_def[] = {
  {"iemspr",0,{{-1}},NPY_INT},
  {"iemspm",0,{{-1}},NPY_INT},
  {"iemspx",0,{{-1}},NPY_INT},
  {"iemsrx",0,{{-1}},NPY_INT},
  {"iemspu",0,{{-1}},NPY_INT},
  {"iemsi2",0,{{-1}},NPY_INT},
  {"iemspbx",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_xems1(char *iemspr,char *iemspm,char *iemspx,char *iemsrx,char *iemspu,char *iemsi2,char *iemspbx) {
  int i_f2py=0;
  f2py_xems1_def[i_f2py++].data = iemspr;
  f2py_xems1_def[i_f2py++].data = iemspm;
  f2py_xems1_def[i_f2py++].data = iemspx;
  f2py_xems1_def[i_f2py++].data = iemsrx;
  f2py_xems1_def[i_f2py++].data = iemspu;
  f2py_xems1_def[i_f2py++].data = iemsi2;
  f2py_xems1_def[i_f2py++].data = iemspbx;
}
extern void F_FUNC(f2pyinitxems1,F2PYINITXEMS1)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_xems1(void) {
  F_FUNC(f2pyinitxems1,F2PYINITXEMS1)(f2py_setup_xems1);
}

static FortranDataDef f2py_xems2_def[] = {
  {"iemsse",0,{{-1}},NPY_INT},
  {"iemsi1",0,{{-1}},NPY_INT},
  {"iemsb",0,{{-1}},NPY_INT},
  {"iemsbg",0,{{-1}},NPY_INT},
  {"ioems",0,{{-1}},NPY_INT},
  {"iemsdr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_xems2(char *iemsse,char *iemsi1,char *iemsb,char *iemsbg,char *ioems,char *iemsdr) {
  int i_f2py=0;
  f2py_xems2_def[i_f2py++].data = iemsse;
  f2py_xems2_def[i_f2py++].data = iemsi1;
  f2py_xems2_def[i_f2py++].data = iemsb;
  f2py_xems2_def[i_f2py++].data = iemsbg;
  f2py_xems2_def[i_f2py++].data = ioems;
  f2py_xems2_def[i_f2py++].data = iemsdr;
}
extern void F_FUNC(f2pyinitxems2,F2PYINITXEMS2)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_xems2(void) {
  F_FUNC(f2pyinitxems2,F2PYINITXEMS2)(f2py_setup_xems2);
}

static FortranDataDef f2py_xspatim_def[] = {
  {"ispacetime",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_xspatim(char *ispacetime) {
  int i_f2py=0;
  f2py_xspatim_def[i_f2py++].data = ispacetime;
}
extern void F_FUNC(f2pyinitxspatim,F2PYINITXSPATIM)(void(*)(char*));
static void f2py_init_xspatim(void) {
  F_FUNC(f2pyinitxspatim,F2PYINITXSPATIM)(f2py_setup_xspatim);
}

static FortranDataDef f2py_psar10_def[] = {
  {"difnuc",1,{{250}},NPY_FLOAT},
  {"radnuc",1,{{250}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_psar10(char *difnuc,char *radnuc) {
  int i_f2py=0;
  f2py_psar10_def[i_f2py++].data = difnuc;
  f2py_psar10_def[i_f2py++].data = radnuc;
}
extern void F_FUNC(f2pyinitpsar10,F2PYINITPSAR10)(void(*)(char*,char*));
static void f2py_init_psar10(void) {
  F_FUNC(f2pyinitpsar10,F2PYINITPSAR10)(f2py_setup_psar10);
}

static FortranDataDef f2py_cbarray_def[] = {
  {"barray",1,{{100}},NPY_FLOAT},
  {"nbarray",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cbarray(char *barray,char *nbarray) {
  int i_f2py=0;
  f2py_cbarray_def[i_f2py++].data = barray;
  f2py_cbarray_def[i_f2py++].data = nbarray;
}
extern void F_FUNC(f2pyinitcbarray,F2PYINITCBARRAY)(void(*)(char*,char*));
static void f2py_init_cbarray(void) {
  F_FUNC(f2pyinitcbarray,F2PYINITCBARRAY)(f2py_setup_cbarray);
}

static FortranDataDef f2py_nxsair_def[] = {
  {"airznxs",1,{{3}},NPY_FLOAT},
  {"airanxs",1,{{3}},NPY_FLOAT},
  {"airwnxs",1,{{3}},NPY_FLOAT},
  {"airavznxs",0,{{-1}},NPY_FLOAT},
  {"airavanxs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_nxsair(char *airznxs,char *airanxs,char *airwnxs,char *airavznxs,char *airavanxs) {
  int i_f2py=0;
  f2py_nxsair_def[i_f2py++].data = airznxs;
  f2py_nxsair_def[i_f2py++].data = airanxs;
  f2py_nxsair_def[i_f2py++].data = airwnxs;
  f2py_nxsair_def[i_f2py++].data = airavznxs;
  f2py_nxsair_def[i_f2py++].data = airavanxs;
}
extern void F_FUNC(f2pyinitnxsair,F2PYINITNXSAIR)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_nxsair(void) {
  F_FUNC(f2pyinitnxsair,F2PYINITNXSAIR)(f2py_setup_nxsair);
}

static FortranDataDef f2py_mod2incs_def[] = {
  {"qgsincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod2incs(char *qgsincs) {
  int i_f2py=0;
  f2py_mod2incs_def[i_f2py++].data = qgsincs;
}
extern void F_FUNC(f2pyinitmod2incs,F2PYINITMOD2INCS)(void(*)(char*));
static void f2py_init_mod2incs(void) {
  F_FUNC(f2pyinitmod2incs,F2PYINITMOD2INCS)(f2py_setup_mod2incs);
}

static FortranDataDef f2py_mod3incs_def[] = {
  {"gheincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod3incs(char *gheincs) {
  int i_f2py=0;
  f2py_mod3incs_def[i_f2py++].data = gheincs;
}
extern void F_FUNC(f2pyinitmod3incs,F2PYINITMOD3INCS)(void(*)(char*));
static void f2py_init_mod3incs(void) {
  F_FUNC(f2pyinitmod3incs,F2PYINITMOD3INCS)(f2py_setup_mod3incs);
}

static FortranDataDef f2py_mod4incs_def[] = {
  {"pytincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod4incs(char *pytincs) {
  int i_f2py=0;
  f2py_mod4incs_def[i_f2py++].data = pytincs;
}
extern void F_FUNC(f2pyinitmod4incs,F2PYINITMOD4INCS)(void(*)(char*));
static void f2py_init_mod4incs(void) {
  F_FUNC(f2pyinitmod4incs,F2PYINITMOD4INCS)(f2py_setup_mod4incs);
}

static FortranDataDef f2py_mod5incs_def[] = {
  {"hijincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod5incs(char *hijincs) {
  int i_f2py=0;
  f2py_mod5incs_def[i_f2py++].data = hijincs;
}
extern void F_FUNC(f2pyinitmod5incs,F2PYINITMOD5INCS)(void(*)(char*));
static void f2py_init_mod5incs(void) {
  F_FUNC(f2pyinitmod5incs,F2PYINITMOD5INCS)(f2py_setup_mod5incs);
}

static FortranDataDef f2py_mod6incs_def[] = {
  {"sibincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod6incs(char *sibincs) {
  int i_f2py=0;
  f2py_mod6incs_def[i_f2py++].data = sibincs;
}
extern void F_FUNC(f2pyinitmod6incs,F2PYINITMOD6INCS)(void(*)(char*));
static void f2py_init_mod6incs(void) {
  F_FUNC(f2pyinitmod6incs,F2PYINITMOD6INCS)(f2py_setup_mod6incs);
}

static FortranDataDef f2py_mod7incs_def[] = {
  {"qgsiiincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod7incs(char *qgsiiincs) {
  int i_f2py=0;
  f2py_mod7incs_def[i_f2py++].data = qgsiiincs;
}
extern void F_FUNC(f2pyinitmod7incs,F2PYINITMOD7INCS)(void(*)(char*));
static void f2py_init_mod7incs(void) {
  F_FUNC(f2pyinitmod7incs,F2PYINITMOD7INCS)(f2py_setup_mod7incs);
}

static FortranDataDef f2py_mod8incs_def[] = {
  {"phoincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod8incs(char *phoincs) {
  int i_f2py=0;
  f2py_mod8incs_def[i_f2py++].data = phoincs;
}
extern void F_FUNC(f2pyinitmod8incs,F2PYINITMOD8INCS)(void(*)(char*));
static void f2py_init_mod8incs(void) {
  F_FUNC(f2pyinitmod8incs,F2PYINITMOD8INCS)(f2py_setup_mod8incs);
}

static FortranDataDef f2py_mod9incs_def[] = {
  {"fluincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod9incs(char *fluincs) {
  int i_f2py=0;
  f2py_mod9incs_def[i_f2py++].data = fluincs;
}
extern void F_FUNC(f2pyinitmod9incs,F2PYINITMOD9INCS)(void(*)(char*));
static void f2py_init_mod9incs(void) {
  F_FUNC(f2pyinitmod9incs,F2PYINITMOD9INCS)(f2py_setup_mod9incs);
}

static FortranDataDef f2py_mod10incs_def[] = {
  {"urqincs",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_mod10incs(char *urqincs) {
  int i_f2py=0;
  f2py_mod10incs_def[i_f2py++].data = urqincs;
}
extern void F_FUNC(f2pyinitmod10incs,F2PYINITMOD10INCS)(void(*)(char*));
static void f2py_init_mod10incs(void) {
  F_FUNC(f2pyinitmod10incs,F2PYINITMOD10INCS)(f2py_setup_mod10incs);
}

static FortranDataDef f2py_testpom_def[] = {
  {"antot",0,{{-1}},NPY_FLOAT},
  {"ansh",0,{{-1}},NPY_FLOAT},
  {"ansf",0,{{-1}},NPY_FLOAT},
  {"pp4max",0,{{-1}},NPY_FLOAT},
  {"pp4ini",0,{{-1}},NPY_FLOAT},
  {"andropl",0,{{-1}},NPY_FLOAT},
  {"anstrg0",0,{{-1}},NPY_FLOAT},
  {"anshf",0,{{-1}},NPY_FLOAT},
  {"ansff",0,{{-1}},NPY_FLOAT},
  {"antotf",0,{{-1}},NPY_FLOAT},
  {"anstrg1",0,{{-1}},NPY_FLOAT},
  {"anreso0",0,{{-1}},NPY_FLOAT},
  {"anreso1",0,{{-1}},NPY_FLOAT},
  {"anghadr",0,{{-1}},NPY_FLOAT},
  {"antotre",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_testpom(char *antot,char *ansh,char *ansf,char *pp4max,char *pp4ini,char *andropl,char *anstrg0,char *anshf,char *ansff,char *antotf,char *anstrg1,char *anreso0,char *anreso1,char *anghadr,char *antotre) {
  int i_f2py=0;
  f2py_testpom_def[i_f2py++].data = antot;
  f2py_testpom_def[i_f2py++].data = ansh;
  f2py_testpom_def[i_f2py++].data = ansf;
  f2py_testpom_def[i_f2py++].data = pp4max;
  f2py_testpom_def[i_f2py++].data = pp4ini;
  f2py_testpom_def[i_f2py++].data = andropl;
  f2py_testpom_def[i_f2py++].data = anstrg0;
  f2py_testpom_def[i_f2py++].data = anshf;
  f2py_testpom_def[i_f2py++].data = ansff;
  f2py_testpom_def[i_f2py++].data = antotf;
  f2py_testpom_def[i_f2py++].data = anstrg1;
  f2py_testpom_def[i_f2py++].data = anreso0;
  f2py_testpom_def[i_f2py++].data = anreso1;
  f2py_testpom_def[i_f2py++].data = anghadr;
  f2py_testpom_def[i_f2py++].data = antotre;
}
extern void F_FUNC(f2pyinittestpom,F2PYINITTESTPOM)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_testpom(void) {
  F_FUNC(f2pyinittestpom,F2PYINITTESTPOM)(f2py_setup_testpom);
}

static FortranDataDef f2py_cdiff_def[] = {
  {"anintdiff",0,{{-1}},NPY_FLOAT},
  {"anintsdif",0,{{-1}},NPY_FLOAT},
  {"anintine",0,{{-1}},NPY_FLOAT},
  {"sigineex",0,{{-1}},NPY_FLOAT},
  {"sigdifex",0,{{-1}},NPY_FLOAT},
  {"sigsdex",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cdiff(char *anintdiff,char *anintsdif,char *anintine,char *sigineex,char *sigdifex,char *sigsdex) {
  int i_f2py=0;
  f2py_cdiff_def[i_f2py++].data = anintdiff;
  f2py_cdiff_def[i_f2py++].data = anintsdif;
  f2py_cdiff_def[i_f2py++].data = anintine;
  f2py_cdiff_def[i_f2py++].data = sigineex;
  f2py_cdiff_def[i_f2py++].data = sigdifex;
  f2py_cdiff_def[i_f2py++].data = sigsdex;
}
extern void F_FUNC(f2pyinitcdiff,F2PYINITCDIFF)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_cdiff(void) {
  F_FUNC(f2pyinitcdiff,F2PYINITCDIFF)(f2py_setup_cdiff);
}

static FortranDataDef f2py_cepszer_def[] = {
  {"epszero",0,{{-1}},NPY_FLOAT},
  {"alpff",1,{{4}},NPY_FLOAT},
  {"betff",1,{{2}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cepszer(char *epszero,char *alpff,char *betff) {
  int i_f2py=0;
  f2py_cepszer_def[i_f2py++].data = epszero;
  f2py_cepszer_def[i_f2py++].data = alpff;
  f2py_cepszer_def[i_f2py++].data = betff;
}
extern void F_FUNC(f2pyinitcepszer,F2PYINITCEPSZER)(void(*)(char*,char*,char*));
static void f2py_init_cepszer(void) {
  F_FUNC(f2pyinitcepszer,F2PYINITCEPSZER)(f2py_setup_cepszer);
}

static FortranDataDef f2py_cgss_def[] = {
  {"tgss",2,{{7,7}},NPY_FLOAT},
  {"wgss",2,{{7,7}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cgss(char *tgss,char *wgss) {
  int i_f2py=0;
  f2py_cgss_def[i_f2py++].data = tgss;
  f2py_cgss_def[i_f2py++].data = wgss;
}
extern void F_FUNC(f2pyinitcgss,F2PYINITCGSS)(void(*)(char*,char*));
static void f2py_init_cgss(void) {
  F_FUNC(f2pyinitcgss,F2PYINITCGSS)(f2py_setup_cgss);
}

static FortranDataDef f2py_dparams_def[] = {
  {"alpds",4,{{2,100,4,4}},NPY_FLOAT},
  {"alpdps",4,{{2,100,4,4}},NPY_FLOAT},
  {"alpdpps",4,{{2,100,4,4}},NPY_FLOAT},
  {"betds",4,{{2,100,4,4}},NPY_FLOAT},
  {"betdps",4,{{2,100,4,4}},NPY_FLOAT},
  {"betdpps",4,{{2,100,4,4}},NPY_FLOAT},
  {"gamds",4,{{2,100,4,4}},NPY_FLOAT},
  {"delds",4,{{2,100,4,4}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_dparams(char *alpds,char *alpdps,char *alpdpps,char *betds,char *betdps,char *betdpps,char *gamds,char *delds) {
  int i_f2py=0;
  f2py_dparams_def[i_f2py++].data = alpds;
  f2py_dparams_def[i_f2py++].data = alpdps;
  f2py_dparams_def[i_f2py++].data = alpdpps;
  f2py_dparams_def[i_f2py++].data = betds;
  f2py_dparams_def[i_f2py++].data = betdps;
  f2py_dparams_def[i_f2py++].data = betdpps;
  f2py_dparams_def[i_f2py++].data = gamds;
  f2py_dparams_def[i_f2py++].data = delds;
}
extern void F_FUNC(f2pyinitdparams,F2PYINITDPARAMS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_dparams(void) {
  F_FUNC(f2pyinitdparams,F2PYINITDPARAMS)(f2py_setup_dparams);
}

static FortranDataDef f2py_dparam_def[] = {
  {"alpd",3,{{3,4,4}},NPY_FLOAT},
  {"alpdp",3,{{3,4,4}},NPY_FLOAT},
  {"alpdpp",3,{{3,4,4}},NPY_FLOAT},
  {"betd",3,{{3,4,4}},NPY_FLOAT},
  {"betdp",3,{{3,4,4}},NPY_FLOAT},
  {"betdpp",3,{{3,4,4}},NPY_FLOAT},
  {"gamd",3,{{3,4,4}},NPY_FLOAT},
  {"deld",3,{{3,4,4}},NPY_FLOAT},
  {"idxdmin",0,{{-1}},NPY_INT},
  {"bmxdif",2,{{4,4}},NPY_FLOAT},
  {"bkmxndif",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_dparam(char *alpd,char *alpdp,char *alpdpp,char *betd,char *betdp,char *betdpp,char *gamd,char *deld,char *idxdmin,char *bmxdif,char *bkmxndif) {
  int i_f2py=0;
  f2py_dparam_def[i_f2py++].data = alpd;
  f2py_dparam_def[i_f2py++].data = alpdp;
  f2py_dparam_def[i_f2py++].data = alpdpp;
  f2py_dparam_def[i_f2py++].data = betd;
  f2py_dparam_def[i_f2py++].data = betdp;
  f2py_dparam_def[i_f2py++].data = betdpp;
  f2py_dparam_def[i_f2py++].data = gamd;
  f2py_dparam_def[i_f2py++].data = deld;
  f2py_dparam_def[i_f2py++].data = idxdmin;
  f2py_dparam_def[i_f2py++].data = bmxdif;
  f2py_dparam_def[i_f2py++].data = bkmxndif;
}
extern void F_FUNC(f2pyinitdparam,F2PYINITDPARAM)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_dparam(void) {
  F_FUNC(f2pyinitdparam,F2PYINITDPARAM)(f2py_setup_dparam);
}

static FortranDataDef f2py_dparuni_def[] = {
  {"alpuni",2,{{3,2}},NPY_DOUBLE},
  {"betuni",2,{{3,2}},NPY_DOUBLE},
  {"betpuni",2,{{3,2}},NPY_DOUBLE},
  {"fpuni",0,{{-1}},NPY_DOUBLE},
  {"ftuni",0,{{-1}},NPY_DOUBLE},
  {"epspuni",1,{{3}},NPY_DOUBLE},
  {"zzpuni",0,{{-1}},NPY_DOUBLE},
  {"epstuni",1,{{3}},NPY_DOUBLE},
  {"zztuni",0,{{-1}},NPY_DOUBLE},
  {"betfom",0,{{-1}},NPY_DOUBLE},
  {"alpfom",0,{{-1}},NPY_FLOAT},
  {"alpfomi",0,{{-1}},NPY_FLOAT},
  {"gamfom",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_dparuni(char *alpuni,char *betuni,char *betpuni,char *fpuni,char *ftuni,char *epspuni,char *zzpuni,char *epstuni,char *zztuni,char *betfom,char *alpfom,char *alpfomi,char *gamfom) {
  int i_f2py=0;
  f2py_dparuni_def[i_f2py++].data = alpuni;
  f2py_dparuni_def[i_f2py++].data = betuni;
  f2py_dparuni_def[i_f2py++].data = betpuni;
  f2py_dparuni_def[i_f2py++].data = fpuni;
  f2py_dparuni_def[i_f2py++].data = ftuni;
  f2py_dparuni_def[i_f2py++].data = epspuni;
  f2py_dparuni_def[i_f2py++].data = zzpuni;
  f2py_dparuni_def[i_f2py++].data = epstuni;
  f2py_dparuni_def[i_f2py++].data = zztuni;
  f2py_dparuni_def[i_f2py++].data = betfom;
  f2py_dparuni_def[i_f2py++].data = alpfom;
  f2py_dparuni_def[i_f2py++].data = alpfomi;
  f2py_dparuni_def[i_f2py++].data = gamfom;
}
extern void F_FUNC(f2pyinitdparuni,F2PYINITDPARUNI)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_dparuni(void) {
  F_FUNC(f2pyinitdparuni,F2PYINITDPARUNI)(f2py_setup_dparuni);
}

static FortranDataDef f2py_crvar_def[] = {
  {"idlead",0,{{-1}},NPY_INT},
  {"ilprtg",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_crvar(char *idlead,char *ilprtg) {
  int i_f2py=0;
  f2py_crvar_def[i_f2py++].data = idlead;
  f2py_crvar_def[i_f2py++].data = ilprtg;
}
extern void F_FUNC(f2pyinitcrvar,F2PYINITCRVAR)(void(*)(char*,char*));
static void f2py_init_crvar(void) {
  F_FUNC(f2pyinitcrvar,F2PYINITCRVAR)(f2py_setup_crvar);
}

static FortranDataDef f2py_lhctune_def[] = {
  {"ilhc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_lhctune(char *ilhc) {
  int i_f2py=0;
  f2py_lhctune_def[i_f2py++].data = ilhc;
}
extern void F_FUNC(f2pyinitlhctune,F2PYINITLHCTUNE)(void(*)(char*));
static void f2py_init_lhctune(void) {
  F_FUNC(f2pyinitlhctune,F2PYINITLHCTUNE)(f2py_setup_lhctune);
}

static FortranDataDef f2py_parvar_def[] = {
  {"xmindf",0,{{-1}},NPY_DOUBLE},
  {"xmaxdf",0,{{-1}},NPY_DOUBLE},
  {"xfitmin",0,{{-1}},NPY_DOUBLE},
  {"xshmin",0,{{-1}},NPY_DOUBLE},
  {"xggfit",0,{{-1}},NPY_DOUBLE},
  {"nmcxdf",0,{{-1}},NPY_INT},
  {"nmcbdf",0,{{-1}},NPY_INT},
  {"nptf",0,{{-1}},NPY_INT},
  {"smaxdf",0,{{-1}},NPY_FLOAT},
  {"bmaxdf",0,{{-1}},NPY_FLOAT},
  {"sfshlim",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_parvar(char *xmindf,char *xmaxdf,char *xfitmin,char *xshmin,char *xggfit,char *nmcxdf,char *nmcbdf,char *nptf,char *smaxdf,char *bmaxdf,char *sfshlim) {
  int i_f2py=0;
  f2py_parvar_def[i_f2py++].data = xmindf;
  f2py_parvar_def[i_f2py++].data = xmaxdf;
  f2py_parvar_def[i_f2py++].data = xfitmin;
  f2py_parvar_def[i_f2py++].data = xshmin;
  f2py_parvar_def[i_f2py++].data = xggfit;
  f2py_parvar_def[i_f2py++].data = nmcxdf;
  f2py_parvar_def[i_f2py++].data = nmcbdf;
  f2py_parvar_def[i_f2py++].data = nptf;
  f2py_parvar_def[i_f2py++].data = smaxdf;
  f2py_parvar_def[i_f2py++].data = bmaxdf;
  f2py_parvar_def[i_f2py++].data = sfshlim;
}
extern void F_FUNC(f2pyinitparvar,F2PYINITPARVAR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_parvar(void) {
  F_FUNC(f2pyinitparvar,F2PYINITPARVAR)(f2py_setup_parvar);
}

static FortranDataDef f2py_fitpar_def[] = {
  {"numpardf",0,{{-1}},NPY_INT},
  {"pardf",2,{{30,4}},NPY_FLOAT},
  {"numdatadf",0,{{-1}},NPY_INT},
  {"nummindf",0,{{-1}},NPY_INT},
  {"datafitd",2,{{100,3}},NPY_FLOAT},
  {"fpardf",0,{{-1}},NPY_FLOAT},
  {"betac",0,{{-1}},NPY_FLOAT},
  {"betae",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_fitpar(char *numpardf,char *pardf,char *numdatadf,char *nummindf,char *datafitd,char *fpardf,char *betac,char *betae) {
  int i_f2py=0;
  f2py_fitpar_def[i_f2py++].data = numpardf;
  f2py_fitpar_def[i_f2py++].data = pardf;
  f2py_fitpar_def[i_f2py++].data = numdatadf;
  f2py_fitpar_def[i_f2py++].data = nummindf;
  f2py_fitpar_def[i_f2py++].data = datafitd;
  f2py_fitpar_def[i_f2py++].data = fpardf;
  f2py_fitpar_def[i_f2py++].data = betac;
  f2py_fitpar_def[i_f2py++].data = betae;
}
extern void F_FUNC(f2pyinitfitpar,F2PYINITFITPAR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_fitpar(void) {
  F_FUNC(f2pyinitfitpar,F2PYINITFITPAR)(f2py_setup_fitpar);
}

static FortranDataDef f2py_epspar_def[] = {
  {"epscrw",0,{{-1}},NPY_FLOAT},
  {"epscrp",0,{{-1}},NPY_FLOAT},
  {"egyscr",0,{{-1}},NPY_FLOAT},
  {"iscreeni",0,{{-1}},NPY_INT},
  {"epscrs",0,{{-1}},NPY_FLOAT},
  {"epscrx",0,{{-1}},NPY_FLOAT},
  {"epscrh",0,{{-1}},NPY_FLOAT},
  {"znurho",0,{{-1}},NPY_FLOAT},
  {"zbrads",0,{{-1}},NPY_FLOAT},
  {"epscrd",0,{{-1}},NPY_FLOAT},
  {"bglaubx",0,{{-1}},NPY_FLOAT},
  {"b2xscr",0,{{-1}},NPY_FLOAT},
  {"fegypp",0,{{-1}},NPY_FLOAT},
  {"zbcutx",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_epspar(char *epscrw,char *epscrp,char *egyscr,char *iscreeni,char *epscrs,char *epscrx,char *epscrh,char *znurho,char *zbrads,char *epscrd,char *bglaubx,char *b2xscr,char *fegypp,char *zbcutx) {
  int i_f2py=0;
  f2py_epspar_def[i_f2py++].data = epscrw;
  f2py_epspar_def[i_f2py++].data = epscrp;
  f2py_epspar_def[i_f2py++].data = egyscr;
  f2py_epspar_def[i_f2py++].data = iscreeni;
  f2py_epspar_def[i_f2py++].data = epscrs;
  f2py_epspar_def[i_f2py++].data = epscrx;
  f2py_epspar_def[i_f2py++].data = epscrh;
  f2py_epspar_def[i_f2py++].data = znurho;
  f2py_epspar_def[i_f2py++].data = zbrads;
  f2py_epspar_def[i_f2py++].data = epscrd;
  f2py_epspar_def[i_f2py++].data = bglaubx;
  f2py_epspar_def[i_f2py++].data = b2xscr;
  f2py_epspar_def[i_f2py++].data = fegypp;
  f2py_epspar_def[i_f2py++].data = zbcutx;
}
extern void F_FUNC(f2pyinitepspar,F2PYINITEPSPAR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_epspar(void) {
  F_FUNC(f2pyinitepspar,F2PYINITEPSPAR)(f2py_setup_epspar);
}

static FortranDataDef f2py_psar1_def[] = {
  {"icdp",0,{{-1}},NPY_INT},
  {"icdt",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_psar1(char *icdp,char *icdt) {
  int i_f2py=0;
  f2py_psar1_def[i_f2py++].data = icdp;
  f2py_psar1_def[i_f2py++].data = icdt;
}
extern void F_FUNC(f2pyinitpsar1,F2PYINITPSAR1)(void(*)(char*,char*));
static void f2py_init_psar1(void) {
  F_FUNC(f2pyinitpsar1,F2PYINITPSAR1)(f2py_setup_psar1);
}

static FortranDataDef f2py_psar3_def[] = {
  {"dels",0,{{-1}},NPY_FLOAT},
  {"alfp",0,{{-1}},NPY_FLOAT},
  {"ffrr",0,{{-1}},NPY_FLOAT},
  {"delh",0,{{-1}},NPY_FLOAT},
  {"r3pom",0,{{-1}},NPY_FLOAT},
  {"r4pom",0,{{-1}},NPY_FLOAT},
  {"alpasf",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_psar3(char *dels,char *alfp,char *ffrr,char *delh,char *r3pom,char *r4pom,char *alpasf) {
  int i_f2py=0;
  f2py_psar3_def[i_f2py++].data = dels;
  f2py_psar3_def[i_f2py++].data = alfp;
  f2py_psar3_def[i_f2py++].data = ffrr;
  f2py_psar3_def[i_f2py++].data = delh;
  f2py_psar3_def[i_f2py++].data = r3pom;
  f2py_psar3_def[i_f2py++].data = r4pom;
  f2py_psar3_def[i_f2py++].data = alpasf;
}
extern void F_FUNC(f2pyinitpsar3,F2PYINITPSAR3)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_psar3(void) {
  F_FUNC(f2pyinitpsar3,F2PYINITPSAR3)(f2py_setup_psar3);
}

static FortranDataDef f2py_psar5_def[] = {
  {"qcdlam",0,{{-1}},NPY_FLOAT},
  {"q2min",0,{{-1}},NPY_FLOAT},
  {"q2ini",0,{{-1}},NPY_FLOAT},
  {"q2fin",0,{{-1}},NPY_FLOAT},
  {"pt2cut",0,{{-1}},NPY_FLOAT},
  {"betpom",0,{{-1}},NPY_FLOAT},
  {"glusea",0,{{-1}},NPY_FLOAT},
  {"naflav",0,{{-1}},NPY_INT},
  {"alfe",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_psar5(char *qcdlam,char *q2min,char *q2ini,char *q2fin,char *pt2cut,char *betpom,char *glusea,char *naflav,char *alfe) {
  int i_f2py=0;
  f2py_psar5_def[i_f2py++].data = qcdlam;
  f2py_psar5_def[i_f2py++].data = q2min;
  f2py_psar5_def[i_f2py++].data = q2ini;
  f2py_psar5_def[i_f2py++].data = q2fin;
  f2py_psar5_def[i_f2py++].data = pt2cut;
  f2py_psar5_def[i_f2py++].data = betpom;
  f2py_psar5_def[i_f2py++].data = glusea;
  f2py_psar5_def[i_f2py++].data = naflav;
  f2py_psar5_def[i_f2py++].data = alfe;
}
extern void F_FUNC(f2pyinitpsar5,F2PYINITPSAR5)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_psar5(void) {
  F_FUNC(f2pyinitpsar5,F2PYINITPSAR5)(f2py_setup_psar5);
}

static FortranDataDef f2py_psar8_def[] = {
  {"stmass",0,{{-1}},NPY_FLOAT},
  {"amhadr",1,{{8}},NPY_FLOAT},
  {"qcmass",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_psar8(char *stmass,char *amhadr,char *qcmass) {
  int i_f2py=0;
  f2py_psar8_def[i_f2py++].data = stmass;
  f2py_psar8_def[i_f2py++].data = amhadr;
  f2py_psar8_def[i_f2py++].data = qcmass;
}
extern void F_FUNC(f2pyinitpsar8,F2PYINITPSAR8)(void(*)(char*,char*,char*));
static void f2py_init_psar8(void) {
  F_FUNC(f2pyinitpsar8,F2PYINITPSAR8)(f2py_setup_psar8);
}

static FortranDataDef f2py_psar12_def[] = {
  {"ydmin",0,{{-1}},NPY_FLOAT},
  {"ydmax",0,{{-1}},NPY_FLOAT},
  {"qdmin",0,{{-1}},NPY_FLOAT},
  {"qdmax",0,{{-1}},NPY_FLOAT},
  {"themin",0,{{-1}},NPY_FLOAT},
  {"themax",0,{{-1}},NPY_FLOAT},
  {"elomin",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_psar12(char *ydmin,char *ydmax,char *qdmin,char *qdmax,char *themin,char *themax,char *elomin) {
  int i_f2py=0;
  f2py_psar12_def[i_f2py++].data = ydmin;
  f2py_psar12_def[i_f2py++].data = ydmax;
  f2py_psar12_def[i_f2py++].data = qdmin;
  f2py_psar12_def[i_f2py++].data = qdmax;
  f2py_psar12_def[i_f2py++].data = themin;
  f2py_psar12_def[i_f2py++].data = themax;
  f2py_psar12_def[i_f2py++].data = elomin;
}
extern void F_FUNC(f2pyinitpsar12,F2PYINITPSAR12)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_psar12(void) {
  F_FUNC(f2pyinitpsar12,F2PYINITPSAR12)(f2py_setup_psar12);
}

static FortranDataDef f2py_psar14_def[] = {
  {"factk",0,{{-1}},NPY_FLOAT},
  {"factgam",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_psar14(char *factk,char *factgam) {
  int i_f2py=0;
  f2py_psar14_def[i_f2py++].data = factk;
  f2py_psar14_def[i_f2py++].data = factgam;
}
extern void F_FUNC(f2pyinitpsar14,F2PYINITPSAR14)(void(*)(char*,char*));
static void f2py_init_psar14(void) {
  F_FUNC(f2pyinitpsar14,F2PYINITPSAR14)(f2py_setup_psar14);
}

static FortranDataDef f2py_psar16_def[] = {
  {"cyfus",0,{{-1}},NPY_DOUBLE},
  {"cyscr",0,{{-1}},NPY_DOUBLE},
  {"cydif",0,{{-1}},NPY_DOUBLE},
  {"cxfus",0,{{-1}},NPY_DOUBLE},
  {"cxdif",0,{{-1}},NPY_DOUBLE},
  {"cxscr",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_psar16(char *cyfus,char *cyscr,char *cydif,char *cxfus,char *cxdif,char *cxscr) {
  int i_f2py=0;
  f2py_psar16_def[i_f2py++].data = cyfus;
  f2py_psar16_def[i_f2py++].data = cyscr;
  f2py_psar16_def[i_f2py++].data = cydif;
  f2py_psar16_def[i_f2py++].data = cxfus;
  f2py_psar16_def[i_f2py++].data = cxdif;
  f2py_psar16_def[i_f2py++].data = cxscr;
}
extern void F_FUNC(f2pyinitpsar16,F2PYINITPSAR16)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_psar16(void) {
  F_FUNC(f2pyinitpsar16,F2PYINITPSAR16)(f2py_setup_psar16);
}

static FortranDataDef f2py_cgamsoft_def[] = {
  {"gamsoft",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cgamsoft(char *gamsoft) {
  int i_f2py=0;
  f2py_cgamsoft_def[i_f2py++].data = gamsoft;
}
extern void F_FUNC(f2pyinitcgamsoft,F2PYINITCGAMSOFT)(void(*)(char*));
static void f2py_init_cgamsoft(void) {
  F_FUNC(f2pyinitcgamsoft,F2PYINITCGAMSOFT)(f2py_setup_cgamsoft);
}

static FortranDataDef f2py_record_def[] = {
  {"maxrec",1,{{2}},NPY_INT},
  {"irecty",2,{{30,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_record(char *maxrec,char *irecty) {
  int i_f2py=0;
  f2py_record_def[i_f2py++].data = maxrec;
  f2py_record_def[i_f2py++].data = irecty;
}
extern void F_FUNC(f2pyinitrecord,F2PYINITRECORD)(void(*)(char*,char*));
static void f2py_init_record(void) {
  F_FUNC(f2pyinitrecord,F2PYINITRECORD)(f2py_setup_record);
}

static FortranDataDef f2py_cfacmss_def[] = {
  {"facmss",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cfacmss(char *facmss) {
  int i_f2py=0;
  f2py_cfacmss_def[i_f2py++].data = facmss;
}
extern void F_FUNC(f2pyinitcfacmss,F2PYINITCFACMSS)(void(*)(char*));
static void f2py_init_cfacmss(void) {
  F_FUNC(f2pyinitcfacmss,F2PYINITCFACMSS)(f2py_setup_cfacmss);
}

static FortranDataDef f2py_cr3pomi_def[] = {
  {"r3pomi",0,{{-1}},NPY_FLOAT},
  {"r4pomi",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cr3pomi(char *r3pomi,char *r4pomi) {
  int i_f2py=0;
  f2py_cr3pomi_def[i_f2py++].data = r3pomi;
  f2py_cr3pomi_def[i_f2py++].data = r4pomi;
}
extern void F_FUNC(f2pyinitcr3pomi,F2PYINITCR3POMI)(void(*)(char*,char*));
static void f2py_init_cr3pomi(void) {
  F_FUNC(f2pyinitcr3pomi,F2PYINITCR3POMI)(f2py_setup_cr3pomi);
}

static FortranDataDef f2py_cifset_def[] = {
  {"ifset",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cifset(char *ifset) {
  int i_f2py=0;
  f2py_cifset_def[i_f2py++].data = ifset;
}
extern void F_FUNC(f2pyinitcifset,F2PYINITCIFSET)(void(*)(char*));
static void f2py_init_cifset(void) {
  F_FUNC(f2pyinitcifset,F2PYINITCIFSET)(f2py_setup_cifset);
}

static FortranDataDef f2py_ems12_def[] = {
  {"iodiba",0,{{-1}},NPY_INT},
  {"bidiba",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_ems12(char *iodiba,char *bidiba) {
  int i_f2py=0;
  f2py_ems12_def[i_f2py++].data = iodiba;
  f2py_ems12_def[i_f2py++].data = bidiba;
}
extern void F_FUNC(f2pyinitems12,F2PYINITEMS12)(void(*)(char*,char*));
static void f2py_init_ems12(void) {
  F_FUNC(f2pyinitems12,F2PYINITEMS12)(f2py_setup_ems12);
}

static FortranDataDef f2py_qgsfname_def[] = {
  {"fndat",1,{{500}},NPY_STRING},
  {"fnncs",1,{{500}},NPY_STRING},
  {"ifdat",0,{{-1}},NPY_INT},
  {"ifncs",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgsfname(char *fndat,char *fnncs,char *ifdat,char *ifncs) {
  int i_f2py=0;
  f2py_qgsfname_def[i_f2py++].data = fndat;
  f2py_qgsfname_def[i_f2py++].data = fnncs;
  f2py_qgsfname_def[i_f2py++].data = ifdat;
  f2py_qgsfname_def[i_f2py++].data = ifncs;
}
extern void F_FUNC(f2pyinitqgsfname,F2PYINITQGSFNAME)(void(*)(char*,char*,char*,char*));
static void f2py_init_qgsfname(void) {
  F_FUNC(f2pyinitqgsfname,F2PYINITQGSFNAME)(f2py_setup_qgsfname);
}

static FortranDataDef f2py_qgsiifname_def[] = {
  {"fniidat",1,{{500}},NPY_STRING},
  {"fniincs",1,{{500}},NPY_STRING},
  {"ifiidat",0,{{-1}},NPY_INT},
  {"ifiincs",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgsiifname(char *fniidat,char *fniincs,char *ifiidat,char *ifiincs) {
  int i_f2py=0;
  f2py_qgsiifname_def[i_f2py++].data = fniidat;
  f2py_qgsiifname_def[i_f2py++].data = fniincs;
  f2py_qgsiifname_def[i_f2py++].data = ifiidat;
  f2py_qgsiifname_def[i_f2py++].data = ifiincs;
}
extern void F_FUNC(f2pyinitqgsiifname,F2PYINITQGSIIFNAME)(void(*)(char*,char*,char*,char*));
static void f2py_init_qgsiifname(void) {
  F_FUNC(f2pyinitqgsiifname,F2PYINITQGSIIFNAME)(f2py_setup_qgsiifname);
}

static FortranDataDef f2py_qgsii03fname_def[] = {
  {"fnii03dat",1,{{500}},NPY_STRING},
  {"fnii03ncs",1,{{500}},NPY_STRING},
  {"ifii03dat",0,{{-1}},NPY_INT},
  {"ifii03ncs",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgsii03fname(char *fnii03dat,char *fnii03ncs,char *ifii03dat,char *ifii03ncs) {
  int i_f2py=0;
  f2py_qgsii03fname_def[i_f2py++].data = fnii03dat;
  f2py_qgsii03fname_def[i_f2py++].data = fnii03ncs;
  f2py_qgsii03fname_def[i_f2py++].data = ifii03dat;
  f2py_qgsii03fname_def[i_f2py++].data = ifii03ncs;
}
extern void F_FUNC(f2pyinitqgsii03fname,F2PYINITQGSII03FNAME)(void(*)(char*,char*,char*,char*));
static void f2py_init_qgsii03fname(void) {
  F_FUNC(f2pyinitqgsii03fname,F2PYINITQGSII03FNAME)(f2py_setup_qgsii03fname);
}

static FortranDataDef f2py_ghecsquel_def[] = {
  {"anquasiel",0,{{-1}},NPY_FLOAT},
  {"iquasiel",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ghecsquel(char *anquasiel,char *iquasiel) {
  int i_f2py=0;
  f2py_ghecsquel_def[i_f2py++].data = anquasiel;
  f2py_ghecsquel_def[i_f2py++].data = iquasiel;
}
extern void F_FUNC(f2pyinitghecsquel,F2PYINITGHECSQUEL)(void(*)(char*,char*));
static void f2py_init_ghecsquel(void) {
  F_FUNC(f2pyinitghecsquel,F2PYINITGHECSQUEL)(f2py_setup_ghecsquel);
}

static FortranDataDef f2py_cbincond_def[] = {
  {"nozero",0,{{-1}},NPY_INT},
  {"ibmin",0,{{-1}},NPY_INT},
  {"ibmax",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_cbincond(char *nozero,char *ibmin,char *ibmax) {
  int i_f2py=0;
  f2py_cbincond_def[i_f2py++].data = nozero;
  f2py_cbincond_def[i_f2py++].data = ibmin;
  f2py_cbincond_def[i_f2py++].data = ibmax;
}
extern void F_FUNC(f2pyinitcbincond,F2PYINITCBINCOND)(void(*)(char*,char*,char*));
static void f2py_init_cbincond(void) {
  F_FUNC(f2pyinitcbincond,F2PYINITCBINCOND)(f2py_setup_cbincond);
}

static FortranDataDef f2py_photrans_def[] = {
  {"phoele",1,{{4}},NPY_FLOAT},
  {"ebeam",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_photrans(char *phoele,char *ebeam) {
  int i_f2py=0;
  f2py_photrans_def[i_f2py++].data = phoele;
  f2py_photrans_def[i_f2py++].data = ebeam;
}
extern void F_FUNC(f2pyinitphotrans,F2PYINITPHOTRANS)(void(*)(char*,char*));
static void f2py_init_photrans(void) {
  F_FUNC(f2pyinitphotrans,F2PYINITPHOTRANS)(f2py_setup_photrans);
}

static FortranDataDef f2py_producetab_def[] = {
  {"producetables",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_producetab(char *producetables) {
  int i_f2py=0;
  f2py_producetab_def[i_f2py++].data = producetables;
}
extern void F_FUNC(f2pyinitproducetab,F2PYINITPRODUCETAB)(void(*)(char*));
static void f2py_init_producetab(void) {
  F_FUNC(f2pyinitproducetab,F2PYINITPRODUCETAB)(f2py_setup_producetab);
}

static FortranDataDef f2py_geom_def[] = {
  {"rmproj",0,{{-1}},NPY_FLOAT},
  {"rmtarg",0,{{-1}},NPY_FLOAT},
  {"bmax",0,{{-1}},NPY_FLOAT},
  {"bkmx",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_geom(char *rmproj,char *rmtarg,char *bmax,char *bkmx) {
  int i_f2py=0;
  f2py_geom_def[i_f2py++].data = rmproj;
  f2py_geom_def[i_f2py++].data = rmtarg;
  f2py_geom_def[i_f2py++].data = bmax;
  f2py_geom_def[i_f2py++].data = bkmx;
}
extern void F_FUNC(f2pyinitgeom,F2PYINITGEOM)(void(*)(char*,char*,char*,char*));
static void f2py_init_geom(void) {
  F_FUNC(f2pyinitgeom,F2PYINITGEOM)(f2py_setup_geom);
}

static FortranDataDef f2py_cgampr_def[] = {
  {"pgampr",1,{{5}},NPY_DOUBLE},
  {"rgampr",1,{{4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cgampr(char *pgampr,char *rgampr) {
  int i_f2py=0;
  f2py_cgampr_def[i_f2py++].data = pgampr;
  f2py_cgampr_def[i_f2py++].data = rgampr;
}
extern void F_FUNC(f2pyinitcgampr,F2PYINITCGAMPR)(void(*)(char*,char*));
static void f2py_init_cgampr(void) {
  F_FUNC(f2pyinitcgampr,F2PYINITCGAMPR)(f2py_setup_cgampr);
}

static FortranDataDef f2py_comega_def[] = {
  {"om1int",1,{{11250}},NPY_DOUBLE},
  {"om1intc",1,{{11250}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_comega(char *om1int,char *om1intc) {
  int i_f2py=0;
  f2py_comega_def[i_f2py++].data = om1int;
  f2py_comega_def[i_f2py++].data = om1intc;
}
extern void F_FUNC(f2pyinitcomega,F2PYINITCOMEGA)(void(*)(char*,char*));
static void f2py_init_comega(void) {
  F_FUNC(f2pyinitcomega,F2PYINITCOMEGA)(f2py_setup_comega);
}

static FortranDataDef f2py_comtilde_def[] = {
  {"atilde",2,{{3,11250}},NPY_DOUBLE},
  {"btildep",2,{{3,11250}},NPY_DOUBLE},
  {"btildepp",2,{{3,11250}},NPY_DOUBLE},
  {"ntymin",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_comtilde(char *atilde,char *btildep,char *btildepp,char *ntymin) {
  int i_f2py=0;
  f2py_comtilde_def[i_f2py++].data = atilde;
  f2py_comtilde_def[i_f2py++].data = btildep;
  f2py_comtilde_def[i_f2py++].data = btildepp;
  f2py_comtilde_def[i_f2py++].data = ntymin;
}
extern void F_FUNC(f2pyinitcomtilde,F2PYINITCOMTILDE)(void(*)(char*,char*,char*,char*));
static void f2py_init_comtilde(void) {
  F_FUNC(f2pyinitcomtilde,F2PYINITCOMTILDE)(f2py_setup_comtilde);
}

static FortranDataDef f2py_col_def[] = {
  {"koll",0,{{-1}},NPY_INT},
  {"iproj",1,{{11250}},NPY_INT},
  {"itarg",1,{{11250}},NPY_INT},
  {"coord",2,{{4,11250}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_col(char *koll,char *iproj,char *itarg,char *coord) {
  int i_f2py=0;
  f2py_col_def[i_f2py++].data = koll;
  f2py_col_def[i_f2py++].data = iproj;
  f2py_col_def[i_f2py++].data = itarg;
  f2py_col_def[i_f2py++].data = coord;
}
extern void F_FUNC(f2pyinitcol,F2PYINITCOL)(void(*)(char*,char*,char*,char*));
static void f2py_init_col(void) {
  F_FUNC(f2pyinitcol,F2PYINITCOL)(f2py_setup_col);
}

static FortranDataDef f2py_col1_def[] = {
  {"kremn",3,{{210,210,2}},NPY_INT},
  {"lremn",2,{{210,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_col1(char *kremn,char *lremn) {
  int i_f2py=0;
  f2py_col1_def[i_f2py++].data = kremn;
  f2py_col1_def[i_f2py++].data = lremn;
}
extern void F_FUNC(f2pyinitcol1,F2PYINITCOL1)(void(*)(char*,char*));
static void f2py_init_col1(void) {
  F_FUNC(f2pyinitcol1,F2PYINITCOL1)(f2py_setup_col1);
}

static FortranDataDef f2py_col6_def[] = {
  {"kproj3",2,{{210,210}},NPY_INT},
  {"ktarg3",2,{{210,210}},NPY_INT},
  {"lproj3",1,{{210}},NPY_INT},
  {"ltarg3",1,{{210}},NPY_INT},
  {"epsilongp",2,{{11250,2}},NPY_FLOAT},
  {"epsilongt",2,{{11250,2}},NPY_FLOAT},
  {"epsilongs",2,{{11250,2}},NPY_FLOAT},
  {"gammav",1,{{11250}},NPY_DOUBLE},
  {"epsilongf",1,{{11250}},NPY_FLOAT},
  {"epsilongb",1,{{11250}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_col6(char *kproj3,char *ktarg3,char *lproj3,char *ltarg3,char *epsilongp,char *epsilongt,char *epsilongs,char *gammav,char *epsilongf,char *epsilongb) {
  int i_f2py=0;
  f2py_col6_def[i_f2py++].data = kproj3;
  f2py_col6_def[i_f2py++].data = ktarg3;
  f2py_col6_def[i_f2py++].data = lproj3;
  f2py_col6_def[i_f2py++].data = ltarg3;
  f2py_col6_def[i_f2py++].data = epsilongp;
  f2py_col6_def[i_f2py++].data = epsilongt;
  f2py_col6_def[i_f2py++].data = epsilongs;
  f2py_col6_def[i_f2py++].data = gammav;
  f2py_col6_def[i_f2py++].data = epsilongf;
  f2py_col6_def[i_f2py++].data = epsilongb;
}
extern void F_FUNC(f2pyinitcol6,F2PYINITCOL6)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_col6(void) {
  F_FUNC(f2pyinitcol6,F2PYINITCOL6)(f2py_setup_col6);
}

static FortranDataDef f2py_col4_def[] = {
  {"bk",1,{{11250}},NPY_FLOAT},
  {"bhpr",2,{{150,11250}},NPY_FLOAT},
  {"bkx",1,{{11250}},NPY_FLOAT},
  {"bky",1,{{11250}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_col4(char *bk,char *bhpr,char *bkx,char *bky) {
  int i_f2py=0;
  f2py_col4_def[i_f2py++].data = bk;
  f2py_col4_def[i_f2py++].data = bhpr;
  f2py_col4_def[i_f2py++].data = bkx;
  f2py_col4_def[i_f2py++].data = bky;
}
extern void F_FUNC(f2pyinitcol4,F2PYINITCOL4)(void(*)(char*,char*,char*,char*));
static void f2py_init_col4(void) {
  F_FUNC(f2pyinitcol4,F2PYINITCOL4)(f2py_setup_col4);
}

static FortranDataDef f2py_col7_def[] = {
  {"zparremn",2,{{11250,2}},NPY_FLOAT},
  {"pominck",1,{{11250}},NPY_DOUBLE},
  {"xzcutpar",1,{{11250}},NPY_DOUBLE},
  {"xxnuc",3,{{210,2,11250}},NPY_DOUBLE},
  {"npnuc",3,{{210,2,11250}},NPY_INT},
  {"irnuc",3,{{210,2,11250}},NPY_INT},
  {"knucnt",2,{{2,11250}},NPY_INT},
  {NULL}
};
static void f2py_setup_col7(char *zparremn,char *pominck,char *xzcutpar,char *xxnuc,char *npnuc,char *irnuc,char *knucnt) {
  int i_f2py=0;
  f2py_col7_def[i_f2py++].data = zparremn;
  f2py_col7_def[i_f2py++].data = pominck;
  f2py_col7_def[i_f2py++].data = xzcutpar;
  f2py_col7_def[i_f2py++].data = xxnuc;
  f2py_col7_def[i_f2py++].data = npnuc;
  f2py_col7_def[i_f2py++].data = irnuc;
  f2py_col7_def[i_f2py++].data = knucnt;
}
extern void F_FUNC(f2pyinitcol7,F2PYINITCOL7)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_col7(void) {
  F_FUNC(f2pyinitcol7,F2PYINITCOL7)(f2py_setup_col7);
}

static FortranDataDef f2py_cems3_def[] = {
  {"nprt",1,{{11250}},NPY_INT},
  {"npr",2,{{4,11250}},NPY_INT},
  {NULL}
};
static void f2py_setup_cems3(char *nprt,char *npr) {
  int i_f2py=0;
  f2py_cems3_def[i_f2py++].data = nprt;
  f2py_cems3_def[i_f2py++].data = npr;
}
extern void F_FUNC(f2pyinitcems3,F2PYINITCEMS3)(void(*)(char*,char*));
static void f2py_init_cems3(void) {
  F_FUNC(f2pyinitcems3,F2PYINITCEMS3)(f2py_setup_cems3);
}

static FortranDataDef f2py_cems4_def[] = {
  {"nprmx",1,{{11250}},NPY_INT},
  {NULL}
};
static void f2py_setup_cems4(char *nprmx) {
  int i_f2py=0;
  f2py_cems4_def[i_f2py++].data = nprmx;
}
extern void F_FUNC(f2pyinitcems4,F2PYINITCEMS4)(void(*)(char*));
static void f2py_init_cems4(void) {
  F_FUNC(f2pyinitcems4,F2PYINITCEMS4)(f2py_setup_cems4);
}

static FortranDataDef f2py_cems2_def[] = {
  {"itpr",1,{{11250}},NPY_INT},
  {"idpr",2,{{150,11250}},NPY_INT},
  {"ivpr",2,{{150,11250}},NPY_INT},
  {"idfpr",2,{{150,11250}},NPY_INT},
  {"nvpr",2,{{150,11250}},NPY_INT},
  {"nbkpr",2,{{150,11250}},NPY_INT},
  {NULL}
};
static void f2py_setup_cems2(char *itpr,char *idpr,char *ivpr,char *idfpr,char *nvpr,char *nbkpr) {
  int i_f2py=0;
  f2py_cems2_def[i_f2py++].data = itpr;
  f2py_cems2_def[i_f2py++].data = idpr;
  f2py_cems2_def[i_f2py++].data = ivpr;
  f2py_cems2_def[i_f2py++].data = idfpr;
  f2py_cems2_def[i_f2py++].data = nvpr;
  f2py_cems2_def[i_f2py++].data = nbkpr;
}
extern void F_FUNC(f2pyinitcems2,F2PYINITCEMS2)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_cems2(void) {
  F_FUNC(f2pyinitcems2,F2PYINITCEMS2)(f2py_setup_cems2);
}

static FortranDataDef f2py_cems1_def[] = {
  {"xpr",2,{{150,11250}},NPY_DOUBLE},
  {"ypr",2,{{150,11250}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cems1(char *xpr,char *ypr) {
  int i_f2py=0;
  f2py_cems1_def[i_f2py++].data = xpr;
  f2py_cems1_def[i_f2py++].data = ypr;
}
extern void F_FUNC(f2pyinitcems1,F2PYINITCEMS1)(void(*)(char*,char*));
static void f2py_init_cems1(void) {
  F_FUNC(f2pyinitcems1,F2PYINITCEMS1)(f2py_setup_cems1);
}

static FortranDataDef f2py_cems1c_def[] = {
  {"xppr",2,{{150,11250}},NPY_DOUBLE},
  {"xmpr",2,{{150,11250}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cems1c(char *xppr,char *xmpr) {
  int i_f2py=0;
  f2py_cems1c_def[i_f2py++].data = xppr;
  f2py_cems1c_def[i_f2py++].data = xmpr;
}
extern void F_FUNC(f2pyinitcems1c,F2PYINITCEMS1C)(void(*)(char*,char*));
static void f2py_init_cems1c(void) {
  F_FUNC(f2pyinitcems1c,F2PYINITCEMS1C)(f2py_setup_cems1c);
}

static FortranDataDef f2py_cems1d_def[] = {
  {"xpprbor",2,{{150,11250}},NPY_DOUBLE},
  {"xmprbor",2,{{150,11250}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cems1d(char *xpprbor,char *xmprbor) {
  int i_f2py=0;
  f2py_cems1d_def[i_f2py++].data = xpprbor;
  f2py_cems1d_def[i_f2py++].data = xmprbor;
}
extern void F_FUNC(f2pyinitcems1d,F2PYINITCEMS1D)(void(*)(char*,char*));
static void f2py_init_cems1d(void) {
  F_FUNC(f2pyinitcems1d,F2PYINITCEMS1D)(f2py_setup_cems1d);
}

static FortranDataDef f2py_cems1e_def[] = {
  {"nemispr",3,{{2,150,11250}},NPY_INT},
  {"ptprboo",3,{{2,150,11250}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cems1e(char *nemispr,char *ptprboo) {
  int i_f2py=0;
  f2py_cems1e_def[i_f2py++].data = nemispr;
  f2py_cems1e_def[i_f2py++].data = ptprboo;
}
extern void F_FUNC(f2pyinitcems1e,F2PYINITCEMS1E)(void(*)(char*,char*));
static void f2py_init_cems1e(void) {
  F_FUNC(f2pyinitcems1e,F2PYINITCEMS1E)(f2py_setup_cems1e);
}

static FortranDataDef f2py_cems7_def[] = {
  {"xp1pr",2,{{150,11250}},NPY_DOUBLE},
  {"xp2pr",2,{{150,11250}},NPY_DOUBLE},
  {"xm1pr",2,{{150,11250}},NPY_DOUBLE},
  {"xm2pr",2,{{150,11250}},NPY_DOUBLE},
  {"idp1pr",2,{{150,11250}},NPY_INT},
  {"idp2pr",2,{{150,11250}},NPY_INT},
  {"idm1pr",2,{{150,11250}},NPY_INT},
  {"idm2pr",2,{{150,11250}},NPY_INT},
  {NULL}
};
static void f2py_setup_cems7(char *xp1pr,char *xp2pr,char *xm1pr,char *xm2pr,char *idp1pr,char *idp2pr,char *idm1pr,char *idm2pr) {
  int i_f2py=0;
  f2py_cems7_def[i_f2py++].data = xp1pr;
  f2py_cems7_def[i_f2py++].data = xp2pr;
  f2py_cems7_def[i_f2py++].data = xm1pr;
  f2py_cems7_def[i_f2py++].data = xm2pr;
  f2py_cems7_def[i_f2py++].data = idp1pr;
  f2py_cems7_def[i_f2py++].data = idp2pr;
  f2py_cems7_def[i_f2py++].data = idm1pr;
  f2py_cems7_def[i_f2py++].data = idm2pr;
}
extern void F_FUNC(f2pyinitcems7,F2PYINITCEMS7)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cems7(void) {
  F_FUNC(f2pyinitcems7,F2PYINITCEMS7)(f2py_setup_cems7);
}

static FortranDataDef f2py_cems8_def[] = {
  {"xxp1pr",2,{{150,11250}},NPY_DOUBLE},
  {"xyp1pr",2,{{150,11250}},NPY_DOUBLE},
  {"xxp2pr",2,{{150,11250}},NPY_DOUBLE},
  {"xyp2pr",2,{{150,11250}},NPY_DOUBLE},
  {"xxm1pr",2,{{150,11250}},NPY_DOUBLE},
  {"xym1pr",2,{{150,11250}},NPY_DOUBLE},
  {"xxm2pr",2,{{150,11250}},NPY_DOUBLE},
  {"xym2pr",2,{{150,11250}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cems8(char *xxp1pr,char *xyp1pr,char *xxp2pr,char *xyp2pr,char *xxm1pr,char *xym1pr,char *xxm2pr,char *xym2pr) {
  int i_f2py=0;
  f2py_cems8_def[i_f2py++].data = xxp1pr;
  f2py_cems8_def[i_f2py++].data = xyp1pr;
  f2py_cems8_def[i_f2py++].data = xxp2pr;
  f2py_cems8_def[i_f2py++].data = xyp2pr;
  f2py_cems8_def[i_f2py++].data = xxm1pr;
  f2py_cems8_def[i_f2py++].data = xym1pr;
  f2py_cems8_def[i_f2py++].data = xxm2pr;
  f2py_cems8_def[i_f2py++].data = xym2pr;
}
extern void F_FUNC(f2pyinitcems8,F2PYINITCEMS8)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cems8(void) {
  F_FUNC(f2pyinitcems8,F2PYINITCEMS8)(f2py_setup_cems8);
}

static FortranDataDef f2py_cems11_def[] = {
  {"xme",1,{{210}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cems11(char *xme) {
  int i_f2py=0;
  f2py_cems11_def[i_f2py++].data = xme;
}
extern void F_FUNC(f2pyinitcems11,F2PYINITCEMS11)(void(*)(char*));
static void f2py_init_cems11(void) {
  F_FUNC(f2pyinitcems11,F2PYINITCEMS11)(f2py_setup_cems11);
}

static FortranDataDef f2py_cems22_def[] = {
  {"idhpr",2,{{150,11250}},NPY_INT},
  {"idrpr",2,{{150,11250}},NPY_INT},
  {"idsppr",2,{{150,11250}},NPY_INT},
  {"idstpr",2,{{150,11250}},NPY_INT},
  {NULL}
};
static void f2py_setup_cems22(char *idhpr,char *idrpr,char *idsppr,char *idstpr) {
  int i_f2py=0;
  f2py_cems22_def[i_f2py++].data = idhpr;
  f2py_cems22_def[i_f2py++].data = idrpr;
  f2py_cems22_def[i_f2py++].data = idsppr;
  f2py_cems22_def[i_f2py++].data = idstpr;
}
extern void F_FUNC(f2pyinitcems22,F2PYINITCEMS22)(void(*)(char*,char*,char*,char*));
static void f2py_init_cems22(void) {
  F_FUNC(f2pyinitcems22,F2PYINITCEMS22)(f2py_setup_cems22);
}

static FortranDataDef f2py_remn4_def[] = {
  {"jcpval",3,{{4,2,210}},NPY_INT},
  {"jctval",3,{{4,2,210}},NPY_INT},
  {NULL}
};
static void f2py_setup_remn4(char *jcpval,char *jctval) {
  int i_f2py=0;
  f2py_remn4_def[i_f2py++].data = jcpval;
  f2py_remn4_def[i_f2py++].data = jctval;
}
extern void F_FUNC(f2pyinitremn4,F2PYINITREMN4)(void(*)(char*,char*));
static void f2py_init_remn4(void) {
  F_FUNC(f2pyinitremn4,F2PYINITREMN4)(f2py_setup_remn4);
}

static FortranDataDef f2py_remn3_def[] = {
  {"jcpref",3,{{4,2,210}},NPY_INT},
  {"jctref",3,{{4,2,210}},NPY_INT},
  {NULL}
};
static void f2py_setup_remn3(char *jcpref,char *jctref) {
  int i_f2py=0;
  f2py_remn3_def[i_f2py++].data = jcpref;
  f2py_remn3_def[i_f2py++].data = jctref;
}
extern void F_FUNC(f2pyinitremn3,F2PYINITREMN3)(void(*)(char*,char*));
static void f2py_init_remn3(void) {
  F_FUNC(f2pyinitremn3,F2PYINITREMN3)(f2py_setup_remn3);
}

static FortranDataDef f2py_remn2_def[] = {
  {"zzremn",2,{{210,2}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_remn2(char *zzremn) {
  int i_f2py=0;
  f2py_remn2_def[i_f2py++].data = zzremn;
}
extern void F_FUNC(f2pyinitremn2,F2PYINITREMN2)(void(*)(char*));
static void f2py_init_remn2(void) {
  F_FUNC(f2pyinitremn2,F2PYINITREMN2)(f2py_setup_remn2);
}

static FortranDataDef f2py_remn_def[] = {
  {"icremn",3,{{2,210,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_remn(char *icremn) {
  int i_f2py=0;
  f2py_remn_def[i_f2py++].data = icremn;
}
extern void F_FUNC(f2pyinitremn,F2PYINITREMN)(void(*)(char*));
static void f2py_init_remn(void) {
  F_FUNC(f2pyinitremn,F2PYINITREMN)(f2py_setup_remn);
}

static FortranDataDef f2py_cemsr_def[] = {
  {"xpz",2,{{210,2}},NPY_DOUBLE},
  {"xmz",2,{{210,2}},NPY_DOUBLE},
  {"xxz",2,{{210,2}},NPY_DOUBLE},
  {"xyz",2,{{210,2}},NPY_DOUBLE},
  {"idz",2,{{210,2}},NPY_INT},
  {"ivz",2,{{210,2}},NPY_INT},
  {"isz",2,{{210,2}},NPY_INT},
  {"iaz",2,{{210,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_cemsr(char *xpz,char *xmz,char *xxz,char *xyz,char *idz,char *ivz,char *isz,char *iaz) {
  int i_f2py=0;
  f2py_cemsr_def[i_f2py++].data = xpz;
  f2py_cemsr_def[i_f2py++].data = xmz;
  f2py_cemsr_def[i_f2py++].data = xxz;
  f2py_cemsr_def[i_f2py++].data = xyz;
  f2py_cemsr_def[i_f2py++].data = idz;
  f2py_cemsr_def[i_f2py++].data = ivz;
  f2py_cemsr_def[i_f2py++].data = isz;
  f2py_cemsr_def[i_f2py++].data = iaz;
}
extern void F_FUNC(f2pyinitcemsr,F2PYINITCEMSR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cemsr(void) {
  F_FUNC(f2pyinitcemsr,F2PYINITCEMSR)(f2py_setup_cemsr);
}

static FortranDataDef f2py_cemsr1_def[] = {
  {"xzmn",2,{{210,2}},NPY_DOUBLE},
  {"xzmx",2,{{210,2}},NPY_DOUBLE},
  {"xpzmx",2,{{210,2}},NPY_DOUBLE},
  {"xmzmx",2,{{210,2}},NPY_DOUBLE},
  {"xpzmn",2,{{210,2}},NPY_DOUBLE},
  {"xmzmn",2,{{210,2}},NPY_DOUBLE},
  {"xzos",2,{{210,2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cemsr1(char *xzmn,char *xzmx,char *xpzmx,char *xmzmx,char *xpzmn,char *xmzmn,char *xzos) {
  int i_f2py=0;
  f2py_cemsr1_def[i_f2py++].data = xzmn;
  f2py_cemsr1_def[i_f2py++].data = xzmx;
  f2py_cemsr1_def[i_f2py++].data = xpzmx;
  f2py_cemsr1_def[i_f2py++].data = xmzmx;
  f2py_cemsr1_def[i_f2py++].data = xpzmn;
  f2py_cemsr1_def[i_f2py++].data = xmzmn;
  f2py_cemsr1_def[i_f2py++].data = xzos;
}
extern void F_FUNC(f2pyinitcemsr1,F2PYINITCEMSR1)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cemsr1(void) {
  F_FUNC(f2pyinitcemsr1,F2PYINITCEMSR1)(f2py_setup_cemsr1);
}

static FortranDataDef f2py_cemsr3_def[] = {
  {"kolp",1,{{210}},NPY_INT},
  {"kolt",1,{{210}},NPY_INT},
  {"npp",1,{{210}},NPY_INT},
  {"npt",1,{{210}},NPY_INT},
  {NULL}
};
static void f2py_setup_cemsr3(char *kolp,char *kolt,char *npp,char *npt) {
  int i_f2py=0;
  f2py_cemsr3_def[i_f2py++].data = kolp;
  f2py_cemsr3_def[i_f2py++].data = kolt;
  f2py_cemsr3_def[i_f2py++].data = npp;
  f2py_cemsr3_def[i_f2py++].data = npt;
}
extern void F_FUNC(f2pyinitcemsr3,F2PYINITCEMSR3)(void(*)(char*,char*,char*,char*));
static void f2py_init_cemsr3(void) {
  F_FUNC(f2pyinitcemsr3,F2PYINITCEMSR3)(f2py_setup_cemsr3);
}

static FortranDataDef f2py_cemsr4_def[] = {
  {"iez",2,{{210,2}},NPY_INT},
  {"ifz",2,{{210,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_cemsr4(char *iez,char *ifz) {
  int i_f2py=0;
  f2py_cemsr4_def[i_f2py++].data = iez;
  f2py_cemsr4_def[i_f2py++].data = ifz;
}
extern void F_FUNC(f2pyinitcemsr4,F2PYINITCEMSR4)(void(*)(char*,char*));
static void f2py_init_cemsr4(void) {
  F_FUNC(f2pyinitcemsr4,F2PYINITCEMSR4)(f2py_setup_cemsr4);
}

static FortranDataDef f2py_cems12_def[] = {
  {"ammn",1,{{20}},NPY_DOUBLE},
  {"amprmn",1,{{20}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cems12(char *ammn,char *amprmn) {
  int i_f2py=0;
  f2py_cems12_def[i_f2py++].data = ammn;
  f2py_cems12_def[i_f2py++].data = amprmn;
}
extern void F_FUNC(f2pyinitcems12,F2PYINITCEMS12)(void(*)(char*,char*));
static void f2py_init_cems12(void) {
  F_FUNC(f2pyinitcems12,F2PYINITCEMS12)(f2py_setup_cems12);
}

static FortranDataDef f2py_cemsr6_def[] = {
  {"amzmn",2,{{2,2}},NPY_DOUBLE},
  {"amemn",2,{{2,7}},NPY_DOUBLE},
  {"amemx",1,{{3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cemsr6(char *amzmn,char *amemn,char *amemx) {
  int i_f2py=0;
  f2py_cemsr6_def[i_f2py++].data = amzmn;
  f2py_cemsr6_def[i_f2py++].data = amemn;
  f2py_cemsr6_def[i_f2py++].data = amemx;
}
extern void F_FUNC(f2pyinitcemsr6,F2PYINITCEMSR6)(void(*)(char*,char*,char*));
static void f2py_init_cemsr6(void) {
  F_FUNC(f2pyinitcemsr6,F2PYINITCEMSR6)(f2py_setup_cemsr6);
}

static FortranDataDef f2py_cemsr13_def[] = {
  {"xis",0,{{-1}},NPY_DOUBLE},
  {"delxi",0,{{-1}},NPY_DOUBLE},
  {"ddelx",0,{{-1}},NPY_DOUBLE},
  {"r3pompi",0,{{-1}},NPY_DOUBLE},
  {"r3pommi",0,{{-1}},NPY_DOUBLE},
  {"r3pompi3",0,{{-1}},NPY_DOUBLE},
  {"r3pommi3",0,{{-1}},NPY_DOUBLE},
  {"ucfpro",0,{{-1}},NPY_FLOAT},
  {"ucftar",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cemsr13(char *xis,char *delxi,char *ddelx,char *r3pompi,char *r3pommi,char *r3pompi3,char *r3pommi3,char *ucfpro,char *ucftar) {
  int i_f2py=0;
  f2py_cemsr13_def[i_f2py++].data = xis;
  f2py_cemsr13_def[i_f2py++].data = delxi;
  f2py_cemsr13_def[i_f2py++].data = ddelx;
  f2py_cemsr13_def[i_f2py++].data = r3pompi;
  f2py_cemsr13_def[i_f2py++].data = r3pommi;
  f2py_cemsr13_def[i_f2py++].data = r3pompi3;
  f2py_cemsr13_def[i_f2py++].data = r3pommi3;
  f2py_cemsr13_def[i_f2py++].data = ucfpro;
  f2py_cemsr13_def[i_f2py++].data = ucftar;
}
extern void F_FUNC(f2pyinitcemsr13,F2PYINITCEMSR13)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cemsr13(void) {
  F_FUNC(f2pyinitcemsr13,F2PYINITCEMSR13)(f2py_setup_cemsr13);
}

static FortranDataDef f2py_emsstore_def[] = {
  {"xxpr",0,{{-1}},NPY_DOUBLE},
  {"xxpr0",0,{{-1}},NPY_DOUBLE},
  {"yx",0,{{-1}},NPY_DOUBLE},
  {"yx0",0,{{-1}},NPY_DOUBLE},
  {"xxppr",0,{{-1}},NPY_DOUBLE},
  {"xxmpr",0,{{-1}},NPY_DOUBLE},
  {"xxppr0",0,{{-1}},NPY_DOUBLE},
  {"xxmpr0",0,{{-1}},NPY_DOUBLE},
  {"xmtx",0,{{-1}},NPY_DOUBLE},
  {"xmtx0",0,{{-1}},NPY_DOUBLE},
  {"xmtlx",0,{{-1}},NPY_DOUBLE},
  {"xmtlx0",0,{{-1}},NPY_DOUBLE},
  {"xppx",0,{{-1}},NPY_DOUBLE},
  {"xppx0",0,{{-1}},NPY_DOUBLE},
  {"xpplx",0,{{-1}},NPY_DOUBLE},
  {"xpplx0",0,{{-1}},NPY_DOUBLE},
  {"itx",0,{{-1}},NPY_INT},
  {"itx0",0,{{-1}},NPY_INT},
  {"idx",0,{{-1}},NPY_INT},
  {"idx0",0,{{-1}},NPY_INT},
  {"iepst",1,{{210}},NPY_INT},
  {"ietst",1,{{210}},NPY_INT},
  {"npplx0",0,{{-1}},NPY_INT},
  {"nptlx0",0,{{-1}},NPY_INT},
  {"npplx",0,{{-1}},NPY_INT},
  {"nptlx",0,{{-1}},NPY_INT},
  {"nppx",0,{{-1}},NPY_INT},
  {"nppx0",0,{{-1}},NPY_INT},
  {"nptx",0,{{-1}},NPY_INT},
  {"nptx0",0,{{-1}},NPY_INT},
  {"nprx",1,{{4}},NPY_INT},
  {"nprx0",1,{{4}},NPY_INT},
  {"nprtx",0,{{-1}},NPY_INT},
  {"nprtx0",0,{{-1}},NPY_INT},
  {"xppst",1,{{210}},NPY_DOUBLE},
  {"xmpst",1,{{210}},NPY_DOUBLE},
  {"xposst",1,{{210}},NPY_DOUBLE},
  {"xpest",1,{{210}},NPY_DOUBLE},
  {"xppstx0",0,{{-1}},NPY_DOUBLE},
  {"xmpstx0",0,{{-1}},NPY_DOUBLE},
  {"xppstx",0,{{-1}},NPY_DOUBLE},
  {"xmpstx",0,{{-1}},NPY_DOUBLE},
  {"xmtst",1,{{210}},NPY_DOUBLE},
  {"xptst",1,{{210}},NPY_DOUBLE},
  {"xtosst",1,{{210}},NPY_DOUBLE},
  {"xmest",1,{{210}},NPY_DOUBLE},
  {"xmtstx0",0,{{-1}},NPY_DOUBLE},
  {"xptstx0",0,{{-1}},NPY_DOUBLE},
  {"xmtstx",0,{{-1}},NPY_DOUBLE},
  {"xptstx",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_emsstore(char *xxpr,char *xxpr0,char *yx,char *yx0,char *xxppr,char *xxmpr,char *xxppr0,char *xxmpr0,char *xmtx,char *xmtx0,char *xmtlx,char *xmtlx0,char *xppx,char *xppx0,char *xpplx,char *xpplx0,char *itx,char *itx0,char *idx,char *idx0,char *iepst,char *ietst,char *npplx0,char *nptlx0,char *npplx,char *nptlx,char *nppx,char *nppx0,char *nptx,char *nptx0,char *nprx,char *nprx0,char *nprtx,char *nprtx0,char *xppst,char *xmpst,char *xposst,char *xpest,char *xppstx0,char *xmpstx0,char *xppstx,char *xmpstx,char *xmtst,char *xptst,char *xtosst,char *xmest,char *xmtstx0,char *xptstx0,char *xmtstx,char *xptstx) {
  int i_f2py=0;
  f2py_emsstore_def[i_f2py++].data = xxpr;
  f2py_emsstore_def[i_f2py++].data = xxpr0;
  f2py_emsstore_def[i_f2py++].data = yx;
  f2py_emsstore_def[i_f2py++].data = yx0;
  f2py_emsstore_def[i_f2py++].data = xxppr;
  f2py_emsstore_def[i_f2py++].data = xxmpr;
  f2py_emsstore_def[i_f2py++].data = xxppr0;
  f2py_emsstore_def[i_f2py++].data = xxmpr0;
  f2py_emsstore_def[i_f2py++].data = xmtx;
  f2py_emsstore_def[i_f2py++].data = xmtx0;
  f2py_emsstore_def[i_f2py++].data = xmtlx;
  f2py_emsstore_def[i_f2py++].data = xmtlx0;
  f2py_emsstore_def[i_f2py++].data = xppx;
  f2py_emsstore_def[i_f2py++].data = xppx0;
  f2py_emsstore_def[i_f2py++].data = xpplx;
  f2py_emsstore_def[i_f2py++].data = xpplx0;
  f2py_emsstore_def[i_f2py++].data = itx;
  f2py_emsstore_def[i_f2py++].data = itx0;
  f2py_emsstore_def[i_f2py++].data = idx;
  f2py_emsstore_def[i_f2py++].data = idx0;
  f2py_emsstore_def[i_f2py++].data = iepst;
  f2py_emsstore_def[i_f2py++].data = ietst;
  f2py_emsstore_def[i_f2py++].data = npplx0;
  f2py_emsstore_def[i_f2py++].data = nptlx0;
  f2py_emsstore_def[i_f2py++].data = npplx;
  f2py_emsstore_def[i_f2py++].data = nptlx;
  f2py_emsstore_def[i_f2py++].data = nppx;
  f2py_emsstore_def[i_f2py++].data = nppx0;
  f2py_emsstore_def[i_f2py++].data = nptx;
  f2py_emsstore_def[i_f2py++].data = nptx0;
  f2py_emsstore_def[i_f2py++].data = nprx;
  f2py_emsstore_def[i_f2py++].data = nprx0;
  f2py_emsstore_def[i_f2py++].data = nprtx;
  f2py_emsstore_def[i_f2py++].data = nprtx0;
  f2py_emsstore_def[i_f2py++].data = xppst;
  f2py_emsstore_def[i_f2py++].data = xmpst;
  f2py_emsstore_def[i_f2py++].data = xposst;
  f2py_emsstore_def[i_f2py++].data = xpest;
  f2py_emsstore_def[i_f2py++].data = xppstx0;
  f2py_emsstore_def[i_f2py++].data = xmpstx0;
  f2py_emsstore_def[i_f2py++].data = xppstx;
  f2py_emsstore_def[i_f2py++].data = xmpstx;
  f2py_emsstore_def[i_f2py++].data = xmtst;
  f2py_emsstore_def[i_f2py++].data = xptst;
  f2py_emsstore_def[i_f2py++].data = xtosst;
  f2py_emsstore_def[i_f2py++].data = xmest;
  f2py_emsstore_def[i_f2py++].data = xmtstx0;
  f2py_emsstore_def[i_f2py++].data = xptstx0;
  f2py_emsstore_def[i_f2py++].data = xmtstx;
  f2py_emsstore_def[i_f2py++].data = xptstx;
}
extern void F_FUNC(f2pyinitemsstore,F2PYINITEMSSTORE)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_emsstore(void) {
  F_FUNC(f2pyinitemsstore,F2PYINITEMSSTORE)(f2py_setup_emsstore);
}

static FortranDataDef f2py_factori_def[] = {
  {"facto",1,{{151}},NPY_DOUBLE},
  {"fctrl",1,{{151}},NPY_DOUBLE},
  {"nfctrl",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_factori(char *facto,char *fctrl,char *nfctrl) {
  int i_f2py=0;
  f2py_factori_def[i_f2py++].data = facto;
  f2py_factori_def[i_f2py++].data = fctrl;
  f2py_factori_def[i_f2py++].data = nfctrl;
}
extern void F_FUNC(f2pyinitfactori,F2PYINITFACTORI)(void(*)(char*,char*,char*));
static void f2py_init_factori(void) {
  F_FUNC(f2pyinitfactori,F2PYINITFACTORI)(f2py_setup_factori);
}

static FortranDataDef f2py_cquama_def[] = {
  {"quama",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cquama(char *quama) {
  int i_f2py=0;
  f2py_cquama_def[i_f2py++].data = quama;
}
extern void F_FUNC(f2pyinitcquama,F2PYINITCQUAMA)(void(*)(char*));
static void f2py_init_cquama(void) {
  F_FUNC(f2pyinitcquama,F2PYINITCQUAMA)(f2py_setup_cquama);
}

static FortranDataDef f2py_cptj_def[] = {
  {"xptj",1,{{129}},NPY_FLOAT},
  {"qptj",1,{{129}},NPY_FLOAT},
  {"wptj",1,{{129}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_cptj(char *xptj,char *qptj,char *wptj) {
  int i_f2py=0;
  f2py_cptj_def[i_f2py++].data = xptj;
  f2py_cptj_def[i_f2py++].data = qptj;
  f2py_cptj_def[i_f2py++].data = wptj;
}
extern void F_FUNC(f2pyinitcptj,F2PYINITCPTJ)(void(*)(char*,char*,char*));
static void f2py_init_cptj(void) {
  F_FUNC(f2pyinitcptj,F2PYINITCPTJ)(f2py_setup_cptj);
}

static FortranDataDef f2py_cttaus_def[] = {
  {"tpro",0,{{-1}},NPY_DOUBLE},
  {"zpro",0,{{-1}},NPY_DOUBLE},
  {"ttar",0,{{-1}},NPY_DOUBLE},
  {"ztar",0,{{-1}},NPY_DOUBLE},
  {"ttaus",0,{{-1}},NPY_DOUBLE},
  {"detap",0,{{-1}},NPY_DOUBLE},
  {"detat",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cttaus(char *tpro,char *zpro,char *ttar,char *ztar,char *ttaus,char *detap,char *detat) {
  int i_f2py=0;
  f2py_cttaus_def[i_f2py++].data = tpro;
  f2py_cttaus_def[i_f2py++].data = zpro;
  f2py_cttaus_def[i_f2py++].data = ttar;
  f2py_cttaus_def[i_f2py++].data = ztar;
  f2py_cttaus_def[i_f2py++].data = ttaus;
  f2py_cttaus_def[i_f2py++].data = detap;
  f2py_cttaus_def[i_f2py++].data = detat;
}
extern void F_FUNC(f2pyinitcttaus,F2PYINITCTTAUS)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cttaus(void) {
  F_FUNC(f2pyinitcttaus,F2PYINITCTTAUS)(f2py_setup_cttaus);
}

static FortranDataDef f2py_ctain_def[] = {
  {"mtain",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ctain(char *mtain) {
  int i_f2py=0;
  f2py_ctain_def[i_f2py++].data = mtain;
}
extern void F_FUNC(f2pyinitctain,F2PYINITCTAIN)(void(*)(char*));
static void f2py_init_ctain(void) {
  F_FUNC(f2pyinitctain,F2PYINITCTAIN)(f2py_setup_ctain);
}

static FortranDataDef f2py_geom1_def[] = {
  {"rcproj",0,{{-1}},NPY_DOUBLE},
  {"rctarg",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_geom1(char *rcproj,char *rctarg) {
  int i_f2py=0;
  f2py_geom1_def[i_f2py++].data = rcproj;
  f2py_geom1_def[i_f2py++].data = rctarg;
}
extern void F_FUNC(f2pyinitgeom1,F2PYINITGEOM1)(void(*)(char*,char*));
static void f2py_init_geom1(void) {
  F_FUNC(f2pyinitgeom1,F2PYINITGEOM1)(f2py_setup_geom1);
}

static FortranDataDef f2py_emnpass_def[] = {
  {"eppass",2,{{210,4}},NPY_DOUBLE},
  {"etpass",2,{{210,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_emnpass(char *eppass,char *etpass) {
  int i_f2py=0;
  f2py_emnpass_def[i_f2py++].data = eppass;
  f2py_emnpass_def[i_f2py++].data = etpass;
}
extern void F_FUNC(f2pyinitemnpass,F2PYINITEMNPASS)(void(*)(char*,char*));
static void f2py_init_emnpass(void) {
  F_FUNC(f2pyinitemnpass,F2PYINITEMNPASS)(f2py_setup_emnpass);
}

static FortranDataDef f2py_ighnx_def[] = {
  {"ighenex",1,{{35}},NPY_INT},
  {NULL}
};
static void f2py_setup_ighnx(char *ighenex) {
  int i_f2py=0;
  f2py_ighnx_def[i_f2py++].data = ighenex;
}
extern void F_FUNC(f2pyinitighnx,F2PYINITIGHNX)(void(*)(char*));
static void f2py_init_ighnx(void) {
  F_FUNC(f2pyinitighnx,F2PYINITIGHNX)(f2py_setup_ighnx);
}

static FortranDataDef f2py_npy_def[] = {
  {"bitgen",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_npy(char *bitgen) {
  int i_f2py=0;
  f2py_npy_def[i_f2py++].data = bitgen;
}
extern void F_FUNC(f2pyinitnpy,F2PYINITNPY)(void(*)(char*));
static void f2py_init_npy(void) {
  F_FUNC(f2pyinitnpy,F2PYINITNPY)(f2py_setup_npy);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"aaset",-1,{{-1}},0,(char *)F_FUNC(aaset,AASET),(f2py_init_func)f2py_rout__eposlhc_aaset,doc_f2py_rout__eposlhc_aaset},
  {"hepmcstore",-1,{{-1}},0,(char *)F_FUNC(hepmcstore,HEPMCSTORE),(f2py_init_func)f2py_rout__eposlhc_hepmcstore,doc_f2py_rout__eposlhc_hepmcstore},
  {"afinal",-1,{{-1}},0,(char *)F_FUNC(afinal,AFINAL),(f2py_init_func)f2py_rout__eposlhc_afinal,doc_f2py_rout__eposlhc_afinal},
  {"ainit",-1,{{-1}},0,(char *)F_FUNC(ainit,AINIT),(f2py_init_func)f2py_rout__eposlhc_ainit,doc_f2py_rout__eposlhc_ainit},
  {"aepos",-1,{{-1}},0,(char *)F_FUNC(aepos,AEPOS),(f2py_init_func)f2py_rout__eposlhc_aepos,doc_f2py_rout__eposlhc_aepos},
  {"idtrafo",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(idtrafo,IDTRAFO),(f2py_init_func)f2py_rout__eposlhc_idtrafo,doc_f2py_rout__eposlhc_idtrafo},
  {"initepos",-1,{{-1}},0,(char *)F_FUNC(initepos,INITEPOS),(f2py_init_func)f2py_rout__eposlhc_initepos,doc_f2py_rout__eposlhc_initepos},
  {"initeposevt",-1,{{-1}},0,(char *)F_FUNC(initeposevt,INITEPOSEVT),(f2py_init_func)f2py_rout__eposlhc_initeposevt,doc_f2py_rout__eposlhc_initeposevt},
  {"getcharge",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(getcharge,GETCHARGE),(f2py_init_func)f2py_rout__eposlhc_getcharge,doc_f2py_rout__eposlhc_getcharge},
  {"xsection",-1,{{-1}},0,(char *)F_FUNC(xsection,XSECTION),(f2py_init_func)f2py_rout__eposlhc_xsection,doc_f2py_rout__eposlhc_xsection},
  {"npyrng",-1,{{-1}},0,(char *)F_FUNC(npyrng,NPYRNG),(f2py_init_func)f2py_rout__eposlhc_npyrng,doc_f2py_rout__eposlhc_npyrng},
  {"rmmard",-1,{{-1}},0,(char *)F_FUNC(rmmard,RMMARD),(f2py_init_func)f2py_rout__eposlhc_rmmard,doc_f2py_rout__eposlhc_rmmard},
  {"chromo_openlogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE),(f2py_init_func)f2py_rout__eposlhc_chromo_openlogfile,doc_f2py_rout__eposlhc_chromo_openlogfile},
  {"chromo_closelogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE),(f2py_init_func)f2py_rout__eposlhc_chromo_closelogfile,doc_f2py_rout__eposlhc_chromo_closelogfile},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_eposlhc",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__eposlhc(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = _eposlhc_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _eposlhc (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module '_eposlhc' is auto-generated with f2py (version:2).\nFunctions:\n"
"  aaset(iop)\n"
"  hepmcstore()\n"
"  afinal()\n"
"  ainit()\n"
"  aepos(nin)\n"
"  idtrafo = idtrafo(code1,code2,idi)\n"
"  initepos(emax,datpath,lpath,idbg,iou)\n"
"  initeposevt(ecm,ela,ippdg,itpdg,ifram)\n"
"  getcharge = getcharge(idpdg)\n"
"  xsigtot,xsigine,xsigela,xsigdd,xsigsd,xsloela = xsection()\n"
"  npyrng(rval)\n"
"  rmmard(rvec,lenv,iseq)\n"
"  chromo_openlogfile(fname,opunit)\n"
"  chromo_closelogfile(opunit)\n"
"COMMON blocks:\n""  /cevt/ phievt,nevt,bimevt,kolevt,koievt,pmxevt,egyevt,npjevt,ntgevt,npnevt,nppevt,ntnevt,ntpevt,jpnevt,jppevt,jtnevt,jtpevt,xbjevt,qsqevt,nglevt,zppevt,zptevt,minfra,maxfra,kohevt\n""  /c2evt/ ng1evt,ng2evt,rglevt,sglevt,eglevt,fglevt,ikoevt,typevt\n""  /cptl/ nptl,pptl(5,200000),iorptl(200000),idptl(200000),istptl(200000),tivptl(2,200000),ifrptl(2,200000),jorptl(200000),xorptl(4,200000),ibptl(4,200000),ityptl(200000)\n""  /c1ptl/ ekievt,itsptl(200000)\n""  /c2ptl/ iaaptl(200000),radptl(200000)\n""  /c3ptl/ desptl(200000),dezptl(200000)\n""  /c4ptl/ nptlbd\n""  /c6ptl/ rinptl(200000),vrad,inbxxx\n""  /c8ptl/ qsqptl(200000),zpaptl(2,200000)\n""  /hepevt/ nevhep,nhep,isthep(9990),idhep(9990),jmohep(2,9990),jdahep(2,9990),phep(5,9990),vhep(4,9990)\n""  /files/ ifop,ifmt,ifch,ifcx,ifhi,ifdt,ifcp,ifdr\n""  /files2/ ifin\n""  /fname/ fnch(500),fnhi(500),fndt(500),fnii(500),fnid(500),fnie(500),fnrj(500),fnmt(500),fngrv(500),fncp(500),fnnx(500),fncs(500),fndr(500),fnhpf(500)\n""  /nfname/ nfnch,nfnhi,nfndt,nfnii,nfnid,nfnie,nfnrj,nfnmt,nfngrv,nfncp,nfnnx,nfncs,nfndr,nfnhpf\n""  /fname2/ fnin(500)\n""  /nfname2/ nfnin\n""  /resc2/ delvol,deleps,dlzeta,etafac,facnuc,taurea,epscri(3)\n""  /resc4/ epsdfm\n""  /hydr1/ hydt(3)\n""  /frag1/ ndecay,maxres,pud,pmqu,pmqd,pmqs,pmqc,pmqq\n""  /frag2/ pdiqua,delrex,ptfraqq,ptfra,ptfrasr,ioptf\n""  /frag3/ aouni,pbreak,fkappa,itflav,strcut,diqcut,fkappag,pbreakg,zetacut\n""  /frag4/ difud,difus,difuc,pudd,puds,pudc,difuuu,difuud,difuus,difuuc,difudd,difuds,difudc,difuss,difusc,difucc,nrflav\n""  /frag5/ qmass(7),isospin(7)\n""  /hadr1/ pnll,ptq,exmass,cutmss,wproj,wtarg\n""  /hadr10/ rstrau(4),rstrad(4),rstras(4),rstrac(4),rstrasi\n""  /wgtqrk/ wgtqqq(4),wgtval,wgtsea,wgtdiq\n""  /time1/ timeini,timefin\n""  /ciotst/ iotst1,iotst2,iotst3,iotst4\n""  /resc1/ taumin,deltau,factau,numtau,amsiac,amprif\n""  /resc3/ dscale,cepara,iceopt,delamf,deuamf\n""  /sprio/ ispherio,icotabm,icotabr,icocore\n""  /urqm1/ iurqmd\n""  /incon/ cutico,dssico\n""  /othe1/ istore,istmax,gaumx,irescl,ntrymx,nclean,iopdg,ioidch\n""  /othe2/ ifrade,iframe,idecay,jdecay,iremn\n""  /othe3/ jframe,kframe\n""  /othe4/ iselect\n""  /jpsif/ jpsi,jpsifi,taumx,nsttau,sigj,ijphis,ijtauan\n""  /strlt/ iopenu,themas\n""  /appli/ iappl,model\n""  /events/ nevent,nfull,nfreeze,ninicon\n""  /enrgy/ egymin,egymax,elab,ecms,ekin\n""  /prnt1/ iprmpt,ish,ishsub,irandm,irewch,iecho,modsho,idensi\n""  /lept1/ engy,elepti,elepto,angmue,icinpu\n""  /nucl1/ laproj,maproj,latarg,matarg,core,fctrmx\n""  /nucl2/ bmaxim,bminim,phimax,phimin\n""  /wana1/ ymximi,imihis,iclhis,iwtime,wtimet,wtimei,wtimea\n""  /wana2/ isphis,ispall,wtmini,wtstep,iwcent,iana,nbdky\n""  /drop4/ asuhax(7),asuhay(7)\n""  /gribo/ grigam,grirsq,gridel,grislo,gricel,sigppi,sigppd\n""  /drop3/ bag4rt,dezzer,amuseg,taunll,yradmx,facts,factb,factq\n""  /drop2/ rcoll,ylongmx,nsegsu,nsegce,facecc,yradpp,yradmi,yrmaxi,fradflii\n""  /drop7/ ptclu,yradpi,yradpx,fploss,fvisco,fplmin,ioclude,iocluin,ioquen,iohole,kigrid\n""  /drop8/ fsgrid\n""  /metr1/ iospec,iocova,iopair,iozero,ioflac,iomom\n""  /metr2/ nadd,iograc,iocite,ioceau,iociau\n""  /hadr2/ iomodl,idproj,idtarg,wexcit\n""  /hadr25/ idprojin,idtargin,rexdifi(4),rexndii(4),irdmpr,isoproj,isotarg\n""  /metr3/ iostat,ioinco,ionlat,ioobsv,iosngl,iorejz,iompar\n""  /metr4/ ioinfl,ioinct,iowidn,epsgc\n""  /lept2/ nstmax,prob(99),icbac(99,2),icfor(99,2)\n""  /lept3/ iolept,igampr,idisco\n""  /ebin/ noebin,engmin,engmax,nrebin,iologe,iologl\n""  /cnsta/ pi,pii,hquer,prom,piom,ainfin\n""  /versn/ iversn,iverso\n""  /accum/ imsg,jerr(10),ntevt,nrevt,naevt,nrstr,nrptl\n""  /accum2/ nglacc\n""  /cptlu/ nptlu\n""  /cnrclu/ nrclu\n""  /drop6/ tecm,volu\n""  /metr5/ iterma,iternc,iterpr,iterpl,iozinc,iozevt\n""  /metr6/ epsr,keepr\n""  /drop5/ keu,ked,kes,kec,keb,ket\n""  /cseed/ seedi,seedj,seedj2,seedc,iseqini,iseqsim\n""  /cjintc/ clust(4,10,16)\n""  /cjintd/ volsum(4),vo2sum(4),nclsum(4)\n""  /ciutot/ iutotc,iutote\n""  /copen/ nopen,nopenr\n""  /kopen/ kchopen,khiopen,kdtopen,kcpopen,klgopen,knxopen\n""  /vana1/ xvaria(6),yvaria(6),normal,xminim,xmaxim,nrbins,hisfac\n""  /vana3/ iologb,iocnxb\n""  /nodcy/ nrnody,nody(200)\n""  /ctdcy/ ctaumin\n""  /prnt2/ nrpri,subpri(200,20),ishpri(200)\n""  /prnt3/ ishevt,ixtau,iwseed,jwseed,ixgeometry\n""  /vana4/ ar(10000,5),ary(10000,20),ardy(10000,20),ionoerr\n""  /xpars/ xpar1,xpar2,xpar3,xpar4,xpar5,xpar6,xpar7,xpar8,xpar99\n""  /khist/ khisto\n""  /ctcor/ nctcor\n""  /ccttim/ ncttim\n""  /densi/ kdensi(10,60,40,10),tauv(10)\n""  /cjinti/ iorsce,iorsdf,iorshh,ionudi\n""  /camim/ amimfs,amimel\n""  /craddf/ scr,scs,hacore\n""  /ckoll/ iokoll\n""  /cncnt/ ncnt\n""  /cicnt/ inicnt\n""  /cnemsi/ nemsi\n""  /ems1/ iemspl,iemsct,gfactor,gwidth\n""  /chadron/ amproj,amtarg,ypjtl,yhaha,pnullx\n""  /vana5/ xshift,etacut\n""  /nucl5/ rnucl(20,2),bnucl(20,4),xbtot(4),ixbdens\n""  /nucl6/ infragm\n""  /nucl4/ nrnucl(2),drnucl(2),rnuclo(20,2)\n""  /sig/ xsig(7),xpom(7)\n""  /metr7/ ktnbod\n""  /hadr3/ iregge,isopom,ishpom,iscreen,nprmax,inueff,irmdrop\n""  /hadr5/ sigtot,sigcut,sigela,sloela,sigsd,sigine,sigdif,sigineaa,sigtotaa,sigelaaa,sigcutaa,sigdd\n""  /hadr6/ intpol,isigma,iomega,isetcs\n""  /hadr4/ alppom,slopom,gamhad(4),r2had(4),chad(4),wdiff(4),gamtil,facdif,facmc,r2hads(4),gamhads(4),slopoms,isplit\n""  /hadr42/ gamhadsi(4)\n""  /hadr7/ alpreg,sloreg,gamreg,r2reg,ptdiff,ptsend,xminremn,xmindiff,ptsecu\n""  /hadr8/ alpqua,alppar,alpsea,alpval,alpdiq,alplea(4),alpdif\n""  /hadr14/ alpndi,alpdi,ptsendi,zdrinc,zmsinc,ptsems,irzptn\n""  /hadr15/ zbcut,zopinc,zipinc,zoeinc,xmxrem\n""  /hadr16/ fkainc,fkamax,zodinc,zbrmax,zdfinc,xzcut,ptvpom\n""  /hadr17/ edmaxi,epmaxi\n""  /hadr9/ ammsqq,ammsqd,ammsdd,cumpom,rexndi(4),rexdif(4),reminv,rexpdif(4),rexres(4),zrminc,rexndf\n""  /had10/ iclpro,icltar,iclegy\n""  /had11/ iclpro1,iclpro2,icltar1,icltar2,iclegy1,iclegy2\n""  /had12/ egylow,egyfac\n""  /had13/ amdrmax,amdrmin,alpdro(3)\n""  /had14/ alpcoso,alpcose,betcoso,betcose\n""  /emsx1/ accept,reject\n""  /xems1/ iemspr,iemspm,iemspx,iemsrx,iemspu,iemsi2,iemspbx\n""  /xems2/ iemsse,iemsi1,iemsb,iemsbg,ioems,iemsdr\n""  /xspatim/ ispacetime\n""  /psar10/ difnuc(250),radnuc(250)\n""  /cbarray/ barray(100),nbarray\n""  /nxsair/ airznxs(3),airanxs(3),airwnxs(3),airavznxs,airavanxs\n""  /mod2incs/ qgsincs\n""  /mod3incs/ gheincs\n""  /mod4incs/ pytincs\n""  /mod5incs/ hijincs\n""  /mod6incs/ sibincs\n""  /mod7incs/ qgsiiincs\n""  /mod8incs/ phoincs\n""  /mod9incs/ fluincs\n""  /mod10incs/ urqincs\n""  /testpom/ antot,ansh,ansf,pp4max,pp4ini,andropl,anstrg0,anshf,ansff,antotf,anstrg1,anreso0,anreso1,anghadr,antotre\n""  /cdiff/ anintdiff,anintsdif,anintine,sigineex,sigdifex,sigsdex\n""  /cepszer/ epszero,alpff(4),betff(2)\n""  /cgss/ tgss(7,7),wgss(7,7)\n""  /dparams/ alpds(2,100,4,4),alpdps(2,100,4,4),alpdpps(2,100,4,4),betds(2,100,4,4),betdps(2,100,4,4),betdpps(2,100,4,4),gamds(2,100,4,4),delds(2,100,4,4)\n""  /dparam/ alpd(3,4,4),alpdp(3,4,4),alpdpp(3,4,4),betd(3,4,4),betdp(3,4,4),betdpp(3,4,4),gamd(3,4,4),deld(3,4,4),idxdmin,bmxdif(4,4),bkmxndif\n""  /dparuni/ alpuni(3,2),betuni(3,2),betpuni(3,2),fpuni,ftuni,epspuni(3),zzpuni,epstuni(3),zztuni,betfom,alpfom,alpfomi,gamfom\n""  /crvar/ idlead,ilprtg\n""  /lhctune/ ilhc\n""  /parvar/ xmindf,xmaxdf,xfitmin,xshmin,xggfit,nmcxdf,nmcbdf,nptf,smaxdf,bmaxdf,sfshlim\n""  /fitpar/ numpardf,pardf(30,4),numdatadf,nummindf,datafitd(100,3),fpardf,betac,betae\n""  /epspar/ epscrw,epscrp,egyscr,iscreeni,epscrs,epscrx,epscrh,znurho,zbrads,epscrd,bglaubx,b2xscr,fegypp,zbcutx\n""  /psar1/ icdp,icdt\n""  /psar3/ dels,alfp,ffrr,delh,r3pom,r4pom,alpasf\n""  /psar5/ qcdlam,q2min,q2ini,q2fin,pt2cut,betpom,glusea,naflav,alfe\n""  /psar8/ stmass,amhadr(8),qcmass\n""  /psar12/ ydmin,ydmax,qdmin,qdmax,themin,themax,elomin\n""  /psar14/ factk,factgam\n""  /psar16/ cyfus,cyscr,cydif,cxfus,cxdif,cxscr\n""  /cgamsoft/ gamsoft\n""  /record/ maxrec(2),irecty(30,2)\n""  /cfacmss/ facmss\n""  /cr3pomi/ r3pomi,r4pomi\n""  /cifset/ ifset\n""  /ems12/ iodiba,bidiba\n""  /qgsfname/ fndat(500),fnncs(500),ifdat,ifncs\n""  /qgsiifname/ fniidat(500),fniincs(500),ifiidat,ifiincs\n""  /qgsii03fname/ fnii03dat(500),fnii03ncs(500),ifii03dat,ifii03ncs\n""  /ghecsquel/ anquasiel,iquasiel\n""  /cbincond/ nozero,ibmin,ibmax\n""  /photrans/ phoele(4),ebeam\n""  /producetab/ producetables\n""  /geom/ rmproj,rmtarg,bmax,bkmx\n""  /cgampr/ pgampr(5),rgampr(4)\n""  /comega/ om1int(11250),om1intc(11250)\n""  /comtilde/ atilde(3,11250),btildep(3,11250),btildepp(3,11250),ntymin\n""  /col/ koll,iproj(11250),itarg(11250),coord(4,11250)\n""  /col1/ kremn(210,210,2),lremn(210,2)\n""  /col6/ kproj3(210,210),ktarg3(210,210),lproj3(210),ltarg3(210),epsilongp(11250,2),epsilongt(11250,2),epsilongs(11250,2),gammav(11250),epsilongf(11250),epsilongb(11250)\n""  /col4/ bk(11250),bhpr(150,11250),bkx(11250),bky(11250)\n""  /col7/ zparremn(11250,2),pominck(11250),xzcutpar(11250),xxnuc(210,2,11250),npnuc(210,2,11250),irnuc(210,2,11250),knucnt(2,11250)\n""  /cems3/ nprt(11250),npr(4,11250)\n""  /cems4/ nprmx(11250)\n""  /cems2/ itpr(11250),idpr(150,11250),ivpr(150,11250),idfpr(150,11250),nvpr(150,11250),nbkpr(150,11250)\n""  /cems1/ xpr(150,11250),ypr(150,11250)\n""  /cems1c/ xppr(150,11250),xmpr(150,11250)\n""  /cems1d/ xpprbor(150,11250),xmprbor(150,11250)\n""  /cems1e/ nemispr(2,150,11250),ptprboo(2,150,11250)\n""  /cems7/ xp1pr(150,11250),xp2pr(150,11250),xm1pr(150,11250),xm2pr(150,11250),idp1pr(150,11250),idp2pr(150,11250),idm1pr(150,11250),idm2pr(150,11250)\n""  /cems8/ xxp1pr(150,11250),xyp1pr(150,11250),xxp2pr(150,11250),xyp2pr(150,11250),xxm1pr(150,11250),xym1pr(150,11250),xxm2pr(150,11250),xym2pr(150,11250)\n""  /cems11/ xme(210)\n""  /cems22/ idhpr(150,11250),idrpr(150,11250),idsppr(150,11250),idstpr(150,11250)\n""  /remn4/ jcpval(4,2,210),jctval(4,2,210)\n""  /remn3/ jcpref(4,2,210),jctref(4,2,210)\n""  /remn2/ zzremn(210,2)\n""  /remn/ icremn(2,210,2)\n""  /cemsr/ xpz(210,2),xmz(210,2),xxz(210,2),xyz(210,2),idz(210,2),ivz(210,2),isz(210,2),iaz(210,2)\n""  /cemsr1/ xzmn(210,2),xzmx(210,2),xpzmx(210,2),xmzmx(210,2),xpzmn(210,2),xmzmn(210,2),xzos(210,2)\n""  /cemsr3/ kolp(210),kolt(210),npp(210),npt(210)\n""  /cemsr4/ iez(210,2),ifz(210,2)\n""  /cems12/ ammn(20),amprmn(20)\n""  /cemsr6/ amzmn(2,2),amemn(2,7),amemx(3)\n""  /cemsr13/ xis,delxi,ddelx,r3pompi,r3pommi,r3pompi3,r3pommi3,ucfpro,ucftar\n""  /emsstore/ xxpr,xxpr0,yx,yx0,xxppr,xxmpr,xxppr0,xxmpr0,xmtx,xmtx0,xmtlx,xmtlx0,xppx,xppx0,xpplx,xpplx0,itx,itx0,idx,idx0,iepst(210),ietst(210),npplx0,nptlx0,npplx,nptlx,nppx,nppx0,nptx,nptx0,nprx(4),nprx0(4),nprtx,nprtx0,xppst(210),xmpst(210),xposst(210),xpest(210),xppstx0,xmpstx0,xppstx,xmpstx,xmtst(210),xptst(210),xtosst(210),xmest(210),xmtstx0,xptstx0,xmtstx,xptstx\n""  /factori/ facto(151),fctrl(151),nfctrl\n""  /cquama/ quama\n""  /cptj/ xptj(129),qptj(129),wptj(129)\n""  /cttaus/ tpro,zpro,ttar,ztar,ttaus,detap,detat\n""  /ctain/ mtain\n""  /geom1/ rcproj,rctarg\n""  /emnpass/ eppass(210,4),etpass(210,4)\n""  /ighnx/ ighenex(35)\n""  /npy/ bitgen\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _eposlhc_error = PyErr_NewException ("_eposlhc.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__eposlhc_error", _eposlhc_error);
  Py_DECREF(_eposlhc_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }






    {
      extern int F_FUNC(idtrafo,IDTRAFO)(void);
      PyObject* o = PyDict_GetItemString(d,"idtrafo");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(idtrafo,IDTRAFO),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("idtrafo");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    



    {
      extern float F_FUNC(getcharge,GETCHARGE)(void);
      PyObject* o = PyDict_GetItemString(d,"getcharge");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(getcharge,GETCHARGE),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("getcharge");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    





/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_cevt_def,f2py_init_cevt);
  F2PyDict_SetItemString(d, "cevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_c2evt_def,f2py_init_c2evt);
  F2PyDict_SetItemString(d, "c2evt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cptl_def,f2py_init_cptl);
  F2PyDict_SetItemString(d, "cptl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_c1ptl_def,f2py_init_c1ptl);
  F2PyDict_SetItemString(d, "c1ptl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_c2ptl_def,f2py_init_c2ptl);
  F2PyDict_SetItemString(d, "c2ptl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_c3ptl_def,f2py_init_c3ptl);
  F2PyDict_SetItemString(d, "c3ptl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_c4ptl_def,f2py_init_c4ptl);
  F2PyDict_SetItemString(d, "c4ptl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_c6ptl_def,f2py_init_c6ptl);
  F2PyDict_SetItemString(d, "c6ptl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_c8ptl_def,f2py_init_c8ptl);
  F2PyDict_SetItemString(d, "c8ptl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepevt_def,f2py_init_hepevt);
  F2PyDict_SetItemString(d, "hepevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_files_def,f2py_init_files);
  F2PyDict_SetItemString(d, "files", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_files2_def,f2py_init_files2);
  F2PyDict_SetItemString(d, "files2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_fname_def,f2py_init_fname);
  F2PyDict_SetItemString(d, "fname", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nfname_def,f2py_init_nfname);
  F2PyDict_SetItemString(d, "nfname", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_fname2_def,f2py_init_fname2);
  F2PyDict_SetItemString(d, "fname2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nfname2_def,f2py_init_nfname2);
  F2PyDict_SetItemString(d, "nfname2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_resc2_def,f2py_init_resc2);
  F2PyDict_SetItemString(d, "resc2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_resc4_def,f2py_init_resc4);
  F2PyDict_SetItemString(d, "resc4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hydr1_def,f2py_init_hydr1);
  F2PyDict_SetItemString(d, "hydr1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frag1_def,f2py_init_frag1);
  F2PyDict_SetItemString(d, "frag1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frag2_def,f2py_init_frag2);
  F2PyDict_SetItemString(d, "frag2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frag3_def,f2py_init_frag3);
  F2PyDict_SetItemString(d, "frag3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frag4_def,f2py_init_frag4);
  F2PyDict_SetItemString(d, "frag4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frag5_def,f2py_init_frag5);
  F2PyDict_SetItemString(d, "frag5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr1_def,f2py_init_hadr1);
  F2PyDict_SetItemString(d, "hadr1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr10_def,f2py_init_hadr10);
  F2PyDict_SetItemString(d, "hadr10", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_wgtqrk_def,f2py_init_wgtqrk);
  F2PyDict_SetItemString(d, "wgtqrk", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_time1_def,f2py_init_time1);
  F2PyDict_SetItemString(d, "time1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ciotst_def,f2py_init_ciotst);
  F2PyDict_SetItemString(d, "ciotst", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_resc1_def,f2py_init_resc1);
  F2PyDict_SetItemString(d, "resc1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_resc3_def,f2py_init_resc3);
  F2PyDict_SetItemString(d, "resc3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_sprio_def,f2py_init_sprio);
  F2PyDict_SetItemString(d, "sprio", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_urqm1_def,f2py_init_urqm1);
  F2PyDict_SetItemString(d, "urqm1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_incon_def,f2py_init_incon);
  F2PyDict_SetItemString(d, "incon", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_othe1_def,f2py_init_othe1);
  F2PyDict_SetItemString(d, "othe1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_othe2_def,f2py_init_othe2);
  F2PyDict_SetItemString(d, "othe2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_othe3_def,f2py_init_othe3);
  F2PyDict_SetItemString(d, "othe3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_othe4_def,f2py_init_othe4);
  F2PyDict_SetItemString(d, "othe4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_jpsif_def,f2py_init_jpsif);
  F2PyDict_SetItemString(d, "jpsif", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_strlt_def,f2py_init_strlt);
  F2PyDict_SetItemString(d, "strlt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_appli_def,f2py_init_appli);
  F2PyDict_SetItemString(d, "appli", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_events_def,f2py_init_events);
  F2PyDict_SetItemString(d, "events", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_enrgy_def,f2py_init_enrgy);
  F2PyDict_SetItemString(d, "enrgy", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_prnt1_def,f2py_init_prnt1);
  F2PyDict_SetItemString(d, "prnt1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_lept1_def,f2py_init_lept1);
  F2PyDict_SetItemString(d, "lept1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nucl1_def,f2py_init_nucl1);
  F2PyDict_SetItemString(d, "nucl1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nucl2_def,f2py_init_nucl2);
  F2PyDict_SetItemString(d, "nucl2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_wana1_def,f2py_init_wana1);
  F2PyDict_SetItemString(d, "wana1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_wana2_def,f2py_init_wana2);
  F2PyDict_SetItemString(d, "wana2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_drop4_def,f2py_init_drop4);
  F2PyDict_SetItemString(d, "drop4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_gribo_def,f2py_init_gribo);
  F2PyDict_SetItemString(d, "gribo", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_drop3_def,f2py_init_drop3);
  F2PyDict_SetItemString(d, "drop3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_drop2_def,f2py_init_drop2);
  F2PyDict_SetItemString(d, "drop2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_drop7_def,f2py_init_drop7);
  F2PyDict_SetItemString(d, "drop7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_drop8_def,f2py_init_drop8);
  F2PyDict_SetItemString(d, "drop8", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_metr1_def,f2py_init_metr1);
  F2PyDict_SetItemString(d, "metr1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_metr2_def,f2py_init_metr2);
  F2PyDict_SetItemString(d, "metr2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr2_def,f2py_init_hadr2);
  F2PyDict_SetItemString(d, "hadr2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr25_def,f2py_init_hadr25);
  F2PyDict_SetItemString(d, "hadr25", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_metr3_def,f2py_init_metr3);
  F2PyDict_SetItemString(d, "metr3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_metr4_def,f2py_init_metr4);
  F2PyDict_SetItemString(d, "metr4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_lept2_def,f2py_init_lept2);
  F2PyDict_SetItemString(d, "lept2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_lept3_def,f2py_init_lept3);
  F2PyDict_SetItemString(d, "lept3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ebin_def,f2py_init_ebin);
  F2PyDict_SetItemString(d, "ebin", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cnsta_def,f2py_init_cnsta);
  F2PyDict_SetItemString(d, "cnsta", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_versn_def,f2py_init_versn);
  F2PyDict_SetItemString(d, "versn", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_accum_def,f2py_init_accum);
  F2PyDict_SetItemString(d, "accum", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_accum2_def,f2py_init_accum2);
  F2PyDict_SetItemString(d, "accum2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cptlu_def,f2py_init_cptlu);
  F2PyDict_SetItemString(d, "cptlu", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cnrclu_def,f2py_init_cnrclu);
  F2PyDict_SetItemString(d, "cnrclu", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_drop6_def,f2py_init_drop6);
  F2PyDict_SetItemString(d, "drop6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_metr5_def,f2py_init_metr5);
  F2PyDict_SetItemString(d, "metr5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_metr6_def,f2py_init_metr6);
  F2PyDict_SetItemString(d, "metr6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_drop5_def,f2py_init_drop5);
  F2PyDict_SetItemString(d, "drop5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cseed_def,f2py_init_cseed);
  F2PyDict_SetItemString(d, "cseed", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cjintc_def,f2py_init_cjintc);
  F2PyDict_SetItemString(d, "cjintc", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cjintd_def,f2py_init_cjintd);
  F2PyDict_SetItemString(d, "cjintd", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ciutot_def,f2py_init_ciutot);
  F2PyDict_SetItemString(d, "ciutot", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_copen_def,f2py_init_copen);
  F2PyDict_SetItemString(d, "copen", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_kopen_def,f2py_init_kopen);
  F2PyDict_SetItemString(d, "kopen", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_vana1_def,f2py_init_vana1);
  F2PyDict_SetItemString(d, "vana1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_vana3_def,f2py_init_vana3);
  F2PyDict_SetItemString(d, "vana3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nodcy_def,f2py_init_nodcy);
  F2PyDict_SetItemString(d, "nodcy", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ctdcy_def,f2py_init_ctdcy);
  F2PyDict_SetItemString(d, "ctdcy", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_prnt2_def,f2py_init_prnt2);
  F2PyDict_SetItemString(d, "prnt2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_prnt3_def,f2py_init_prnt3);
  F2PyDict_SetItemString(d, "prnt3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_vana4_def,f2py_init_vana4);
  F2PyDict_SetItemString(d, "vana4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_xpars_def,f2py_init_xpars);
  F2PyDict_SetItemString(d, "xpars", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_khist_def,f2py_init_khist);
  F2PyDict_SetItemString(d, "khist", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ctcor_def,f2py_init_ctcor);
  F2PyDict_SetItemString(d, "ctcor", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ccttim_def,f2py_init_ccttim);
  F2PyDict_SetItemString(d, "ccttim", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_densi_def,f2py_init_densi);
  F2PyDict_SetItemString(d, "densi", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cjinti_def,f2py_init_cjinti);
  F2PyDict_SetItemString(d, "cjinti", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_camim_def,f2py_init_camim);
  F2PyDict_SetItemString(d, "camim", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_craddf_def,f2py_init_craddf);
  F2PyDict_SetItemString(d, "craddf", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ckoll_def,f2py_init_ckoll);
  F2PyDict_SetItemString(d, "ckoll", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cncnt_def,f2py_init_cncnt);
  F2PyDict_SetItemString(d, "cncnt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cicnt_def,f2py_init_cicnt);
  F2PyDict_SetItemString(d, "cicnt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cnemsi_def,f2py_init_cnemsi);
  F2PyDict_SetItemString(d, "cnemsi", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ems1_def,f2py_init_ems1);
  F2PyDict_SetItemString(d, "ems1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_chadron_def,f2py_init_chadron);
  F2PyDict_SetItemString(d, "chadron", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_vana5_def,f2py_init_vana5);
  F2PyDict_SetItemString(d, "vana5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nucl5_def,f2py_init_nucl5);
  F2PyDict_SetItemString(d, "nucl5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nucl6_def,f2py_init_nucl6);
  F2PyDict_SetItemString(d, "nucl6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nucl4_def,f2py_init_nucl4);
  F2PyDict_SetItemString(d, "nucl4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_sig_def,f2py_init_sig);
  F2PyDict_SetItemString(d, "sig", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_metr7_def,f2py_init_metr7);
  F2PyDict_SetItemString(d, "metr7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr3_def,f2py_init_hadr3);
  F2PyDict_SetItemString(d, "hadr3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr5_def,f2py_init_hadr5);
  F2PyDict_SetItemString(d, "hadr5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr6_def,f2py_init_hadr6);
  F2PyDict_SetItemString(d, "hadr6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr4_def,f2py_init_hadr4);
  F2PyDict_SetItemString(d, "hadr4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr42_def,f2py_init_hadr42);
  F2PyDict_SetItemString(d, "hadr42", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr7_def,f2py_init_hadr7);
  F2PyDict_SetItemString(d, "hadr7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr8_def,f2py_init_hadr8);
  F2PyDict_SetItemString(d, "hadr8", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr14_def,f2py_init_hadr14);
  F2PyDict_SetItemString(d, "hadr14", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr15_def,f2py_init_hadr15);
  F2PyDict_SetItemString(d, "hadr15", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr16_def,f2py_init_hadr16);
  F2PyDict_SetItemString(d, "hadr16", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr17_def,f2py_init_hadr17);
  F2PyDict_SetItemString(d, "hadr17", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hadr9_def,f2py_init_hadr9);
  F2PyDict_SetItemString(d, "hadr9", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_had10_def,f2py_init_had10);
  F2PyDict_SetItemString(d, "had10", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_had11_def,f2py_init_had11);
  F2PyDict_SetItemString(d, "had11", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_had12_def,f2py_init_had12);
  F2PyDict_SetItemString(d, "had12", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_had13_def,f2py_init_had13);
  F2PyDict_SetItemString(d, "had13", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_had14_def,f2py_init_had14);
  F2PyDict_SetItemString(d, "had14", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_emsx1_def,f2py_init_emsx1);
  F2PyDict_SetItemString(d, "emsx1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_xems1_def,f2py_init_xems1);
  F2PyDict_SetItemString(d, "xems1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_xems2_def,f2py_init_xems2);
  F2PyDict_SetItemString(d, "xems2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_xspatim_def,f2py_init_xspatim);
  F2PyDict_SetItemString(d, "xspatim", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar10_def,f2py_init_psar10);
  F2PyDict_SetItemString(d, "psar10", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cbarray_def,f2py_init_cbarray);
  F2PyDict_SetItemString(d, "cbarray", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nxsair_def,f2py_init_nxsair);
  F2PyDict_SetItemString(d, "nxsair", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod2incs_def,f2py_init_mod2incs);
  F2PyDict_SetItemString(d, "mod2incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod3incs_def,f2py_init_mod3incs);
  F2PyDict_SetItemString(d, "mod3incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod4incs_def,f2py_init_mod4incs);
  F2PyDict_SetItemString(d, "mod4incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod5incs_def,f2py_init_mod5incs);
  F2PyDict_SetItemString(d, "mod5incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod6incs_def,f2py_init_mod6incs);
  F2PyDict_SetItemString(d, "mod6incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod7incs_def,f2py_init_mod7incs);
  F2PyDict_SetItemString(d, "mod7incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod8incs_def,f2py_init_mod8incs);
  F2PyDict_SetItemString(d, "mod8incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod9incs_def,f2py_init_mod9incs);
  F2PyDict_SetItemString(d, "mod9incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mod10incs_def,f2py_init_mod10incs);
  F2PyDict_SetItemString(d, "mod10incs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_testpom_def,f2py_init_testpom);
  F2PyDict_SetItemString(d, "testpom", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cdiff_def,f2py_init_cdiff);
  F2PyDict_SetItemString(d, "cdiff", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cepszer_def,f2py_init_cepszer);
  F2PyDict_SetItemString(d, "cepszer", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cgss_def,f2py_init_cgss);
  F2PyDict_SetItemString(d, "cgss", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_dparams_def,f2py_init_dparams);
  F2PyDict_SetItemString(d, "dparams", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_dparam_def,f2py_init_dparam);
  F2PyDict_SetItemString(d, "dparam", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_dparuni_def,f2py_init_dparuni);
  F2PyDict_SetItemString(d, "dparuni", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_crvar_def,f2py_init_crvar);
  F2PyDict_SetItemString(d, "crvar", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_lhctune_def,f2py_init_lhctune);
  F2PyDict_SetItemString(d, "lhctune", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_parvar_def,f2py_init_parvar);
  F2PyDict_SetItemString(d, "parvar", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_fitpar_def,f2py_init_fitpar);
  F2PyDict_SetItemString(d, "fitpar", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_epspar_def,f2py_init_epspar);
  F2PyDict_SetItemString(d, "epspar", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar1_def,f2py_init_psar1);
  F2PyDict_SetItemString(d, "psar1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar3_def,f2py_init_psar3);
  F2PyDict_SetItemString(d, "psar3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar5_def,f2py_init_psar5);
  F2PyDict_SetItemString(d, "psar5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar8_def,f2py_init_psar8);
  F2PyDict_SetItemString(d, "psar8", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar12_def,f2py_init_psar12);
  F2PyDict_SetItemString(d, "psar12", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar14_def,f2py_init_psar14);
  F2PyDict_SetItemString(d, "psar14", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_psar16_def,f2py_init_psar16);
  F2PyDict_SetItemString(d, "psar16", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cgamsoft_def,f2py_init_cgamsoft);
  F2PyDict_SetItemString(d, "cgamsoft", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_record_def,f2py_init_record);
  F2PyDict_SetItemString(d, "record", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cfacmss_def,f2py_init_cfacmss);
  F2PyDict_SetItemString(d, "cfacmss", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cr3pomi_def,f2py_init_cr3pomi);
  F2PyDict_SetItemString(d, "cr3pomi", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cifset_def,f2py_init_cifset);
  F2PyDict_SetItemString(d, "cifset", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ems12_def,f2py_init_ems12);
  F2PyDict_SetItemString(d, "ems12", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgsfname_def,f2py_init_qgsfname);
  F2PyDict_SetItemString(d, "qgsfname", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgsiifname_def,f2py_init_qgsiifname);
  F2PyDict_SetItemString(d, "qgsiifname", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgsii03fname_def,f2py_init_qgsii03fname);
  F2PyDict_SetItemString(d, "qgsii03fname", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ghecsquel_def,f2py_init_ghecsquel);
  F2PyDict_SetItemString(d, "ghecsquel", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cbincond_def,f2py_init_cbincond);
  F2PyDict_SetItemString(d, "cbincond", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_photrans_def,f2py_init_photrans);
  F2PyDict_SetItemString(d, "photrans", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_producetab_def,f2py_init_producetab);
  F2PyDict_SetItemString(d, "producetab", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_geom_def,f2py_init_geom);
  F2PyDict_SetItemString(d, "geom", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cgampr_def,f2py_init_cgampr);
  F2PyDict_SetItemString(d, "cgampr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_comega_def,f2py_init_comega);
  F2PyDict_SetItemString(d, "comega", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_comtilde_def,f2py_init_comtilde);
  F2PyDict_SetItemString(d, "comtilde", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_col_def,f2py_init_col);
  F2PyDict_SetItemString(d, "col", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_col1_def,f2py_init_col1);
  F2PyDict_SetItemString(d, "col1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_col6_def,f2py_init_col6);
  F2PyDict_SetItemString(d, "col6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_col4_def,f2py_init_col4);
  F2PyDict_SetItemString(d, "col4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_col7_def,f2py_init_col7);
  F2PyDict_SetItemString(d, "col7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems3_def,f2py_init_cems3);
  F2PyDict_SetItemString(d, "cems3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems4_def,f2py_init_cems4);
  F2PyDict_SetItemString(d, "cems4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems2_def,f2py_init_cems2);
  F2PyDict_SetItemString(d, "cems2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems1_def,f2py_init_cems1);
  F2PyDict_SetItemString(d, "cems1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems1c_def,f2py_init_cems1c);
  F2PyDict_SetItemString(d, "cems1c", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems1d_def,f2py_init_cems1d);
  F2PyDict_SetItemString(d, "cems1d", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems1e_def,f2py_init_cems1e);
  F2PyDict_SetItemString(d, "cems1e", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems7_def,f2py_init_cems7);
  F2PyDict_SetItemString(d, "cems7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems8_def,f2py_init_cems8);
  F2PyDict_SetItemString(d, "cems8", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems11_def,f2py_init_cems11);
  F2PyDict_SetItemString(d, "cems11", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems22_def,f2py_init_cems22);
  F2PyDict_SetItemString(d, "cems22", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_remn4_def,f2py_init_remn4);
  F2PyDict_SetItemString(d, "remn4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_remn3_def,f2py_init_remn3);
  F2PyDict_SetItemString(d, "remn3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_remn2_def,f2py_init_remn2);
  F2PyDict_SetItemString(d, "remn2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_remn_def,f2py_init_remn);
  F2PyDict_SetItemString(d, "remn", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cemsr_def,f2py_init_cemsr);
  F2PyDict_SetItemString(d, "cemsr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cemsr1_def,f2py_init_cemsr1);
  F2PyDict_SetItemString(d, "cemsr1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cemsr3_def,f2py_init_cemsr3);
  F2PyDict_SetItemString(d, "cemsr3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cemsr4_def,f2py_init_cemsr4);
  F2PyDict_SetItemString(d, "cemsr4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cems12_def,f2py_init_cems12);
  F2PyDict_SetItemString(d, "cems12", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cemsr6_def,f2py_init_cemsr6);
  F2PyDict_SetItemString(d, "cemsr6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cemsr13_def,f2py_init_cemsr13);
  F2PyDict_SetItemString(d, "cemsr13", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_emsstore_def,f2py_init_emsstore);
  F2PyDict_SetItemString(d, "emsstore", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_factori_def,f2py_init_factori);
  F2PyDict_SetItemString(d, "factori", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cquama_def,f2py_init_cquama);
  F2PyDict_SetItemString(d, "cquama", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cptj_def,f2py_init_cptj);
  F2PyDict_SetItemString(d, "cptj", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cttaus_def,f2py_init_cttaus);
  F2PyDict_SetItemString(d, "cttaus", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ctain_def,f2py_init_ctain);
  F2PyDict_SetItemString(d, "ctain", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_geom1_def,f2py_init_geom1);
  F2PyDict_SetItemString(d, "geom1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_emnpass_def,f2py_init_emnpass);
  F2PyDict_SetItemString(d, "emnpass", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ighnx_def,f2py_init_ighnx);
  F2PyDict_SetItemString(d, "ighnx", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_npy_def,f2py_init_npy);
  F2PyDict_SetItemString(d, "npy", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_eposlhc");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
