/* File: _pythia6module.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Mon Jan 16 17:33:01 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_pythia6_error;
static PyObject *_pythia6_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _pythia6_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _pythia6_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _pythia6_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(pyhepc,PYHEPC)(int*);
extern void F_FUNC(pyinit,PYINIT)(string,string,string,double*,size_t,size_t,size_t);
extern void F_FUNC(pyevnt,PYEVNT)(void);
extern void F_FUNC(pyevnw,PYEVNW)(void);
extern void F_FUNC(pystat,PYSTAT)(int*);
extern void F_FUNC(pytune,PYTUNE)(int*);
extern void F_FUNC(pyexec,PYEXEC)(void);
extern void F_WRAPPEDFUNC(pychge,PYCHGE)(int*,int*);
extern void F_WRAPPEDFUNC(pycomp,PYCOMP)(int*,int*);
extern void F_FUNC(pyedit,PYEDIT)(int*);
extern void F_FUNC(pylist,PYLIST)(int*);
extern void F_WRAPPEDFUNC(pyk,PYK)(int*,int*,int*);
extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t);
extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*);
extern void F_FUNC(npyrng,NPYRNG)(double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** pyhepc ***********************************/
static char doc_f2py_rout__pythia6_pyhepc[] = "\
pyhepc(mconv)\n\nWrapper for ``pyhepc``.\
\n\nParameters\n----------\n"
"mconv : input int";
/* extern void F_FUNC(pyhepc,PYHEPC)(int*); */
static PyObject *f2py_rout__pythia6_pyhepc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int mconv = 0;
  PyObject *mconv_capi = Py_None;
  static char *capi_kwlist[] = {"mconv",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.pyhepc",\
    capi_kwlist,&mconv_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mconv */
    f2py_success = int_from_pyobj(&mconv,mconv_capi,"_pythia6.pyhepc() 1st argument (mconv) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&mconv);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of mconv*/
  /* End of cleaning variable mconv */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pyhepc *******************************/

/*********************************** pyinit ***********************************/
static char doc_f2py_rout__pythia6_pyinit[] = "\
pyinit(frame,beam,target,win)\n\nWrapper for ``pyinit``.\
\n\nParameters\n----------\n"
"frame : input string(len=-1)\n"
"beam : input string(len=-1)\n"
"target : input string(len=-1)\n"
"win : input float";
/* extern void F_FUNC(pyinit,PYINIT)(string,string,string,double*,size_t,size_t,size_t); */
static PyObject *f2py_rout__pythia6_pyinit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,string,double*,size_t,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string frame = NULL;
  int slen(frame);
  PyObject *frame_capi = Py_None;
  string beam = NULL;
  int slen(beam);
  PyObject *beam_capi = Py_None;
  string target = NULL;
  int slen(target);
  PyObject *target_capi = Py_None;
  double win = 0;
  PyObject *win_capi = Py_None;
  static char *capi_kwlist[] = {"frame","beam","target","win",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:_pythia6.pyinit",\
    capi_kwlist,&frame_capi,&beam_capi,&target_capi,&win_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable frame */
  slen(frame) = -1;
  f2py_success = string_from_pyobj(&frame,&slen(frame),"",frame_capi,"string_from_pyobj failed in converting 1st argument `frame' of _pythia6.pyinit to C string");
  if (f2py_success) {
  /* Processing variable beam */
  slen(beam) = -1;
  f2py_success = string_from_pyobj(&beam,&slen(beam),"",beam_capi,"string_from_pyobj failed in converting 2nd argument `beam' of _pythia6.pyinit to C string");
  if (f2py_success) {
  /* Processing variable target */
  slen(target) = -1;
  f2py_success = string_from_pyobj(&target,&slen(target),"",target_capi,"string_from_pyobj failed in converting 3rd argument `target' of _pythia6.pyinit to C string");
  if (f2py_success) {
  /* Processing variable win */
    f2py_success = double_from_pyobj(&win,win_capi,"_pythia6.pyinit() 4th argument (win) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(frame,beam,target,&win,slen(frame),slen(beam),slen(target));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of win*/
  /* End of cleaning variable win */
    STRINGFREE(target);
  }  /*if (f2py_success) of target*/
  /* End of cleaning variable target */
    STRINGFREE(beam);
  }  /*if (f2py_success) of beam*/
  /* End of cleaning variable beam */
    STRINGFREE(frame);
  }  /*if (f2py_success) of frame*/
  /* End of cleaning variable frame */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pyinit *******************************/

/*********************************** pyevnt ***********************************/
static char doc_f2py_rout__pythia6_pyevnt[] = "\
pyevnt()\n\nWrapper for ``pyevnt``.\
\n";
/* extern void F_FUNC(pyevnt,PYEVNT)(void); */
static PyObject *f2py_rout__pythia6_pyevnt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_pythia6.pyevnt",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pyevnt *******************************/

/*********************************** pyevnw ***********************************/
static char doc_f2py_rout__pythia6_pyevnw[] = "\
pyevnw()\n\nWrapper for ``pyevnw``.\
\n";
/* extern void F_FUNC(pyevnw,PYEVNW)(void); */
static PyObject *f2py_rout__pythia6_pyevnw(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_pythia6.pyevnw",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pyevnw *******************************/

/*********************************** pystat ***********************************/
static char doc_f2py_rout__pythia6_pystat[] = "\
pystat(mstat)\n\nWrapper for ``pystat``.\
\n\nParameters\n----------\n"
"mstat : input int";
/* extern void F_FUNC(pystat,PYSTAT)(int*); */
static PyObject *f2py_rout__pythia6_pystat(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int mstat = 0;
  PyObject *mstat_capi = Py_None;
  static char *capi_kwlist[] = {"mstat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.pystat",\
    capi_kwlist,&mstat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mstat */
    f2py_success = int_from_pyobj(&mstat,mstat_capi,"_pythia6.pystat() 1st argument (mstat) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&mstat);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of mstat*/
  /* End of cleaning variable mstat */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pystat *******************************/

/*********************************** pytune ***********************************/
static char doc_f2py_rout__pythia6_pytune[] = "\
pytune(mytune)\n\nWrapper for ``pytune``.\
\n\nParameters\n----------\n"
"mytune : input int";
/* extern void F_FUNC(pytune,PYTUNE)(int*); */
static PyObject *f2py_rout__pythia6_pytune(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int mytune = 0;
  PyObject *mytune_capi = Py_None;
  static char *capi_kwlist[] = {"mytune",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.pytune",\
    capi_kwlist,&mytune_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mytune */
    f2py_success = int_from_pyobj(&mytune,mytune_capi,"_pythia6.pytune() 1st argument (mytune) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&mytune);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of mytune*/
  /* End of cleaning variable mytune */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pytune *******************************/

/*********************************** pyexec ***********************************/
static char doc_f2py_rout__pythia6_pyexec[] = "\
pyexec()\n\nWrapper for ``pyexec``.\
\n";
/* extern void F_FUNC(pyexec,PYEXEC)(void); */
static PyObject *f2py_rout__pythia6_pyexec(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_pythia6.pyexec",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pyexec *******************************/

/*********************************** pychge ***********************************/
static char doc_f2py_rout__pythia6_pychge[] = "\
pychge = pychge(kf)\n\nWrapper for ``pychge``.\
\n\nParameters\n----------\n"
"kf : input int\n"
"\nReturns\n-------\n"
"pychge : int";
/* extern void F_WRAPPEDFUNC(pychge,PYCHGE)(int*,int*); */
static PyObject *f2py_rout__pythia6_pychge(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int pychge = 0;
  int kf = 0;
  PyObject *kf_capi = Py_None;
  static char *capi_kwlist[] = {"kf",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.pychge",\
    capi_kwlist,&kf_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable kf */
    f2py_success = int_from_pyobj(&kf,kf_capi,"_pythia6.pychge() 1st argument (kf) can't be converted to int");
  if (f2py_success) {
  /* Processing variable pychge */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&pychge,&kf);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",pychge);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable pychge */
  } /*if (f2py_success) of kf*/
  /* End of cleaning variable kf */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pychge *******************************/

/*********************************** pycomp ***********************************/
static char doc_f2py_rout__pythia6_pycomp[] = "\
pycomp = pycomp(kf)\n\nWrapper for ``pycomp``.\
\n\nParameters\n----------\n"
"kf : input int\n"
"\nReturns\n-------\n"
"pycomp : int";
/* extern void F_WRAPPEDFUNC(pycomp,PYCOMP)(int*,int*); */
static PyObject *f2py_rout__pythia6_pycomp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int pycomp = 0;
  int kf = 0;
  PyObject *kf_capi = Py_None;
  static char *capi_kwlist[] = {"kf",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.pycomp",\
    capi_kwlist,&kf_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable kf */
    f2py_success = int_from_pyobj(&kf,kf_capi,"_pythia6.pycomp() 1st argument (kf) can't be converted to int");
  if (f2py_success) {
  /* Processing variable pycomp */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&pycomp,&kf);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",pycomp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable pycomp */
  } /*if (f2py_success) of kf*/
  /* End of cleaning variable kf */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pycomp *******************************/

/*********************************** pyedit ***********************************/
static char doc_f2py_rout__pythia6_pyedit[] = "\
pyedit(medit)\n\nWrapper for ``pyedit``.\
\n\nParameters\n----------\n"
"medit : input int";
/* extern void F_FUNC(pyedit,PYEDIT)(int*); */
static PyObject *f2py_rout__pythia6_pyedit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int medit = 0;
  PyObject *medit_capi = Py_None;
  static char *capi_kwlist[] = {"medit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.pyedit",\
    capi_kwlist,&medit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable medit */
    f2py_success = int_from_pyobj(&medit,medit_capi,"_pythia6.pyedit() 1st argument (medit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&medit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of medit*/
  /* End of cleaning variable medit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pyedit *******************************/

/*********************************** pylist ***********************************/
static char doc_f2py_rout__pythia6_pylist[] = "\
pylist(mlist)\n\nWrapper for ``pylist``.\
\n\nParameters\n----------\n"
"mlist : input int";
/* extern void F_FUNC(pylist,PYLIST)(int*); */
static PyObject *f2py_rout__pythia6_pylist(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int mlist = 0;
  PyObject *mlist_capi = Py_None;
  static char *capi_kwlist[] = {"mlist",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.pylist",\
    capi_kwlist,&mlist_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mlist */
    f2py_success = int_from_pyobj(&mlist,mlist_capi,"_pythia6.pylist() 1st argument (mlist) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&mlist);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of mlist*/
  /* End of cleaning variable mlist */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pylist *******************************/

/************************************ pyk ************************************/
static char doc_f2py_rout__pythia6_pyk[] = "\
pyk = pyk(i,j)\n\nWrapper for ``pyk``.\
\n\nParameters\n----------\n"
"i : input int\n"
"j : input int\n"
"\nReturns\n-------\n"
"pyk : int";
/* extern void F_WRAPPEDFUNC(pyk,PYK)(int*,int*,int*); */
static PyObject *f2py_rout__pythia6_pyk(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int pyk = 0;
  int i = 0;
  PyObject *i_capi = Py_None;
  int j = 0;
  PyObject *j_capi = Py_None;
  static char *capi_kwlist[] = {"i","j",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_pythia6.pyk",\
    capi_kwlist,&i_capi,&j_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"_pythia6.pyk() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable j */
    f2py_success = int_from_pyobj(&j,j_capi,"_pythia6.pyk() 2nd argument (j) can't be converted to int");
  if (f2py_success) {
  /* Processing variable pyk */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&pyk,&i,&j);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",pyk);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable pyk */
  } /*if (f2py_success) of j*/
  /* End of cleaning variable j */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of pyk *********************************/

/***************************** chromo_openlogfile *****************************/
static char doc_f2py_rout__pythia6_chromo_openlogfile[] = "\
chromo_openlogfile(fname,opunit)\n\nWrapper for ``chromo_openlogfile``.\
\n\nParameters\n----------\n"
"fname : input string(len=300)\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t); */
static PyObject *f2py_rout__pythia6_chromo_openlogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string fname = NULL;
  int slen(fname);
  PyObject *fname_capi = Py_None;
  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"fname","opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_pythia6.chromo_openlogfile",\
    capi_kwlist,&fname_capi,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fname */
  slen(fname) = 300;
  f2py_success = string_from_pyobj(&fname,&slen(fname),"",fname_capi,"string_from_pyobj failed in converting 1st argument `fname' of _pythia6.chromo_openlogfile to C string");
  if (f2py_success) {
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_pythia6.chromo_openlogfile() 2nd argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(fname,&opunit,slen(fname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
    STRINGFREE(fname);
  }  /*if (f2py_success) of fname*/
  /* End of cleaning variable fname */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_openlogfile *************************/

/**************************** chromo_closelogfile ****************************/
static char doc_f2py_rout__pythia6_chromo_closelogfile[] = "\
chromo_closelogfile(opunit)\n\nWrapper for ``chromo_closelogfile``.\
\n\nParameters\n----------\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*); */
static PyObject *f2py_rout__pythia6_chromo_closelogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.chromo_closelogfile",\
    capi_kwlist,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_pythia6.chromo_closelogfile() 1st argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&opunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_closelogfile *************************/

/*********************************** npyrng ***********************************/
static char doc_f2py_rout__pythia6_npyrng[] = "\
npyrng(rval)\n\nWrapper for ``npyrng``.\
\n\nParameters\n----------\n"
"rval : input float";
/* extern void F_FUNC(npyrng,NPYRNG)(double*); */
static PyObject *f2py_rout__pythia6_npyrng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rval = 0;
  PyObject *rval_capi = Py_None;
  static char *capi_kwlist[] = {"rval",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_pythia6.npyrng",\
    capi_kwlist,&rval_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rval */
    f2py_success = double_from_pyobj(&rval,rval_capi,"_pythia6.npyrng() 1st argument (rval) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rval);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of rval*/
  /* End of cleaning variable rval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of npyrng *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_pydat1_def[] = {
  {"mstu",1,{{200}},NPY_INT},
  {"paru",1,{{200}},NPY_DOUBLE},
  {"mstj",1,{{200}},NPY_INT},
  {"parj",1,{{200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pydat1(char *mstu,char *paru,char *mstj,char *parj) {
  int i_f2py=0;
  f2py_pydat1_def[i_f2py++].data = mstu;
  f2py_pydat1_def[i_f2py++].data = paru;
  f2py_pydat1_def[i_f2py++].data = mstj;
  f2py_pydat1_def[i_f2py++].data = parj;
}
extern void F_FUNC(f2pyinitpydat1,F2PYINITPYDAT1)(void(*)(char*,char*,char*,char*));
static void f2py_init_pydat1(void) {
  F_FUNC(f2pyinitpydat1,F2PYINITPYDAT1)(f2py_setup_pydat1);
}

static FortranDataDef f2py_pydat2_def[] = {
  {"kchg",2,{{500,4}},NPY_INT},
  {"pmas",2,{{500,4}},NPY_DOUBLE},
  {"parf",1,{{2000}},NPY_DOUBLE},
  {"vckm",2,{{4,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pydat2(char *kchg,char *pmas,char *parf,char *vckm) {
  int i_f2py=0;
  f2py_pydat2_def[i_f2py++].data = kchg;
  f2py_pydat2_def[i_f2py++].data = pmas;
  f2py_pydat2_def[i_f2py++].data = parf;
  f2py_pydat2_def[i_f2py++].data = vckm;
}
extern void F_FUNC(f2pyinitpydat2,F2PYINITPYDAT2)(void(*)(char*,char*,char*,char*));
static void f2py_init_pydat2(void) {
  F_FUNC(f2pyinitpydat2,F2PYINITPYDAT2)(f2py_setup_pydat2);
}

static FortranDataDef f2py_pydat3_def[] = {
  {"mdcy",2,{{500,3}},NPY_INT},
  {"mdme",2,{{8000,2}},NPY_INT},
  {"brat",1,{{8000}},NPY_DOUBLE},
  {"kfdp",2,{{8000,5}},NPY_INT},
  {NULL}
};
static void f2py_setup_pydat3(char *mdcy,char *mdme,char *brat,char *kfdp) {
  int i_f2py=0;
  f2py_pydat3_def[i_f2py++].data = mdcy;
  f2py_pydat3_def[i_f2py++].data = mdme;
  f2py_pydat3_def[i_f2py++].data = brat;
  f2py_pydat3_def[i_f2py++].data = kfdp;
}
extern void F_FUNC(f2pyinitpydat3,F2PYINITPYDAT3)(void(*)(char*,char*,char*,char*));
static void f2py_init_pydat3(void) {
  F_FUNC(f2pyinitpydat3,F2PYINITPYDAT3)(f2py_setup_pydat3);
}

static FortranDataDef f2py_pydat4_def[] = {
  {"chaf",3,{{500,2,16}},NPY_STRING},
  {NULL}
};
static void f2py_setup_pydat4(char *chaf) {
  int i_f2py=0;
  f2py_pydat4_def[i_f2py++].data = chaf;
}
extern void F_FUNC(f2pyinitpydat4,F2PYINITPYDAT4)(void(*)(char*));
static void f2py_init_pydat4(void) {
  F_FUNC(f2pyinitpydat4,F2PYINITPYDAT4)(f2py_setup_pydat4);
}

static FortranDataDef f2py_pydatr_def[] = {
  {"mrpy",1,{{6}},NPY_INT},
  {"rrpy",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pydatr(char *mrpy,char *rrpy) {
  int i_f2py=0;
  f2py_pydatr_def[i_f2py++].data = mrpy;
  f2py_pydatr_def[i_f2py++].data = rrpy;
}
extern void F_FUNC(f2pyinitpydatr,F2PYINITPYDATR)(void(*)(char*,char*));
static void f2py_init_pydatr(void) {
  F_FUNC(f2pyinitpydatr,F2PYINITPYDATR)(f2py_setup_pydatr);
}

static FortranDataDef f2py_pysubs_def[] = {
  {"msel",0,{{-1}},NPY_INT},
  {"mselpd",0,{{-1}},NPY_INT},
  {"msub",1,{{500}},NPY_INT},
  {"kfin",2,{{2,81}},NPY_INT},
  {"ckin",1,{{200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pysubs(char *msel,char *mselpd,char *msub,char *kfin,char *ckin) {
  int i_f2py=0;
  f2py_pysubs_def[i_f2py++].data = msel;
  f2py_pysubs_def[i_f2py++].data = mselpd;
  f2py_pysubs_def[i_f2py++].data = msub;
  f2py_pysubs_def[i_f2py++].data = kfin;
  f2py_pysubs_def[i_f2py++].data = ckin;
}
extern void F_FUNC(f2pyinitpysubs,F2PYINITPYSUBS)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_pysubs(void) {
  F_FUNC(f2pyinitpysubs,F2PYINITPYSUBS)(f2py_setup_pysubs);
}

static FortranDataDef f2py_pypars_def[] = {
  {"mstp",1,{{200}},NPY_INT},
  {"parp",1,{{200}},NPY_DOUBLE},
  {"msti",1,{{200}},NPY_INT},
  {"pari",1,{{200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pypars(char *mstp,char *parp,char *msti,char *pari) {
  int i_f2py=0;
  f2py_pypars_def[i_f2py++].data = mstp;
  f2py_pypars_def[i_f2py++].data = parp;
  f2py_pypars_def[i_f2py++].data = msti;
  f2py_pypars_def[i_f2py++].data = pari;
}
extern void F_FUNC(f2pyinitpypars,F2PYINITPYPARS)(void(*)(char*,char*,char*,char*));
static void f2py_init_pypars(void) {
  F_FUNC(f2pyinitpypars,F2PYINITPYPARS)(f2py_setup_pypars);
}

static FortranDataDef f2py_pyint1_def[] = {
  {"mint",1,{{400}},NPY_INT},
  {"vint",1,{{400}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint1(char *mint,char *vint) {
  int i_f2py=0;
  f2py_pyint1_def[i_f2py++].data = mint;
  f2py_pyint1_def[i_f2py++].data = vint;
}
extern void F_FUNC(f2pyinitpyint1,F2PYINITPYINT1)(void(*)(char*,char*));
static void f2py_init_pyint1(void) {
  F_FUNC(f2pyinitpyint1,F2PYINITPYINT1)(f2py_setup_pyint1);
}

static FortranDataDef f2py_pyint2_def[] = {
  {"iset",1,{{500}},NPY_INT},
  {"kfpr",2,{{500,2}},NPY_INT},
  {"coef",2,{{500,20}},NPY_DOUBLE},
  {"icol",3,{{40,4,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_pyint2(char *iset,char *kfpr,char *coef,char *icol) {
  int i_f2py=0;
  f2py_pyint2_def[i_f2py++].data = iset;
  f2py_pyint2_def[i_f2py++].data = kfpr;
  f2py_pyint2_def[i_f2py++].data = coef;
  f2py_pyint2_def[i_f2py++].data = icol;
}
extern void F_FUNC(f2pyinitpyint2,F2PYINITPYINT2)(void(*)(char*,char*,char*,char*));
static void f2py_init_pyint2(void) {
  F_FUNC(f2pyinitpyint2,F2PYINITPYINT2)(f2py_setup_pyint2);
}

static FortranDataDef f2py_pyint3_def[] = {
  {"xsfx",2,{{2,81}},NPY_DOUBLE},
  {"isig",2,{{1000,3}},NPY_INT},
  {"sigh",1,{{1000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint3(char *xsfx,char *isig,char *sigh) {
  int i_f2py=0;
  f2py_pyint3_def[i_f2py++].data = xsfx;
  f2py_pyint3_def[i_f2py++].data = isig;
  f2py_pyint3_def[i_f2py++].data = sigh;
}
extern void F_FUNC(f2pyinitpyint3,F2PYINITPYINT3)(void(*)(char*,char*,char*));
static void f2py_init_pyint3(void) {
  F_FUNC(f2pyinitpyint3,F2PYINITPYINT3)(f2py_setup_pyint3);
}

static FortranDataDef f2py_pyint4_def[] = {
  {"mwid",1,{{500}},NPY_INT},
  {"wids",2,{{500,5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint4(char *mwid,char *wids) {
  int i_f2py=0;
  f2py_pyint4_def[i_f2py++].data = mwid;
  f2py_pyint4_def[i_f2py++].data = wids;
}
extern void F_FUNC(f2pyinitpyint4,F2PYINITPYINT4)(void(*)(char*,char*));
static void f2py_init_pyint4(void) {
  F_FUNC(f2pyinitpyint4,F2PYINITPYINT4)(f2py_setup_pyint4);
}

static FortranDataDef f2py_pyint5_def[] = {
  {"ngenpd",0,{{-1}},NPY_INT},
  {"ngen",2,{{501,3}},NPY_INT},
  {"xsec",2,{{501,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint5(char *ngenpd,char *ngen,char *xsec) {
  int i_f2py=0;
  f2py_pyint5_def[i_f2py++].data = ngenpd;
  f2py_pyint5_def[i_f2py++].data = ngen;
  f2py_pyint5_def[i_f2py++].data = xsec;
}
extern void F_FUNC(f2pyinitpyint5,F2PYINITPYINT5)(void(*)(char*,char*,char*));
static void f2py_init_pyint5(void) {
  F_FUNC(f2pyinitpyint5,F2PYINITPYINT5)(f2py_setup_pyint5);
}

static FortranDataDef f2py_pyint6_def[] = {
  {"proc",2,{{501,28}},NPY_STRING},
  {NULL}
};
static void f2py_setup_pyint6(char *proc) {
  int i_f2py=0;
  f2py_pyint6_def[i_f2py++].data = proc;
}
extern void F_FUNC(f2pyinitpyint6,F2PYINITPYINT6)(void(*)(char*));
static void f2py_init_pyint6(void) {
  F_FUNC(f2pyinitpyint6,F2PYINITPYINT6)(f2py_setup_pyint6);
}

static FortranDataDef f2py_pyint7_def[] = {
  {"sigt",3,{{7,7,6}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint7(char *sigt) {
  int i_f2py=0;
  f2py_pyint7_def[i_f2py++].data = sigt;
}
extern void F_FUNC(f2pyinitpyint7,F2PYINITPYINT7)(void(*)(char*));
static void f2py_init_pyint7(void) {
  F_FUNC(f2pyinitpyint7,F2PYINITPYINT7)(f2py_setup_pyint7);
}

static FortranDataDef f2py_pymssm_def[] = {
  {"imss",1,{{100}},NPY_INT},
  {"rmss",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pymssm(char *imss,char *rmss) {
  int i_f2py=0;
  f2py_pymssm_def[i_f2py++].data = imss;
  f2py_pymssm_def[i_f2py++].data = rmss;
}
extern void F_FUNC(f2pyinitpymssm,F2PYINITPYMSSM)(void(*)(char*,char*));
static void f2py_init_pymssm(void) {
  F_FUNC(f2pyinitpymssm,F2PYINITPYMSSM)(f2py_setup_pymssm);
}

static FortranDataDef f2py_pyssmt_def[] = {
  {"zmix",2,{{4,4}},NPY_DOUBLE},
  {"umix",2,{{2,2}},NPY_DOUBLE},
  {"vmix",2,{{2,2}},NPY_DOUBLE},
  {"smz",1,{{4}},NPY_DOUBLE},
  {"smw",1,{{2}},NPY_DOUBLE},
  {"sfmix",2,{{16,4}},NPY_DOUBLE},
  {"zmixi",2,{{4,4}},NPY_DOUBLE},
  {"umixi",2,{{2,2}},NPY_DOUBLE},
  {"vmixi",2,{{2,2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyssmt(char *zmix,char *umix,char *vmix,char *smz,char *smw,char *sfmix,char *zmixi,char *umixi,char *vmixi) {
  int i_f2py=0;
  f2py_pyssmt_def[i_f2py++].data = zmix;
  f2py_pyssmt_def[i_f2py++].data = umix;
  f2py_pyssmt_def[i_f2py++].data = vmix;
  f2py_pyssmt_def[i_f2py++].data = smz;
  f2py_pyssmt_def[i_f2py++].data = smw;
  f2py_pyssmt_def[i_f2py++].data = sfmix;
  f2py_pyssmt_def[i_f2py++].data = zmixi;
  f2py_pyssmt_def[i_f2py++].data = umixi;
  f2py_pyssmt_def[i_f2py++].data = vmixi;
}
extern void F_FUNC(f2pyinitpyssmt,F2PYINITPYSSMT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_pyssmt(void) {
  F_FUNC(f2pyinitpyssmt,F2PYINITPYSSMT)(f2py_setup_pyssmt);
}

static FortranDataDef f2py_pymsrv_def[] = {
  {"rvlam",3,{{3,3,3}},NPY_DOUBLE},
  {"rvlamp",3,{{3,3,3}},NPY_DOUBLE},
  {"rvlamb",3,{{3,3,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pymsrv(char *rvlam,char *rvlamp,char *rvlamb) {
  int i_f2py=0;
  f2py_pymsrv_def[i_f2py++].data = rvlam;
  f2py_pymsrv_def[i_f2py++].data = rvlamp;
  f2py_pymsrv_def[i_f2py++].data = rvlamb;
}
extern void F_FUNC(f2pyinitpymsrv,F2PYINITPYMSRV)(void(*)(char*,char*,char*));
static void f2py_init_pymsrv(void) {
  F_FUNC(f2pyinitpymsrv,F2PYINITPYMSRV)(f2py_setup_pymsrv);
}

static FortranDataDef f2py_pytcsm_def[] = {
  {"itcm",1,{{100}},NPY_INT},
  {"rtcm",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pytcsm(char *itcm,char *rtcm) {
  int i_f2py=0;
  f2py_pytcsm_def[i_f2py++].data = itcm;
  f2py_pytcsm_def[i_f2py++].data = rtcm;
}
extern void F_FUNC(f2pyinitpytcsm,F2PYINITPYTCSM)(void(*)(char*,char*));
static void f2py_init_pytcsm(void) {
  F_FUNC(f2pyinitpytcsm,F2PYINITPYTCSM)(f2py_setup_pytcsm);
}

static FortranDataDef f2py_pypued_def[] = {
  {"iued",1,{{100}},NPY_INT},
  {"rued",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pypued(char *iued,char *rued) {
  int i_f2py=0;
  f2py_pypued_def[i_f2py++].data = iued;
  f2py_pypued_def[i_f2py++].data = rued;
}
extern void F_FUNC(f2pyinitpypued,F2PYINITPYPUED)(void(*)(char*,char*));
static void f2py_init_pypued(void) {
  F_FUNC(f2pyinitpypued,F2PYINITPYPUED)(f2py_setup_pypued);
}

static FortranDataDef f2py_pybins_def[] = {
  {"ihist",1,{{4}},NPY_INT},
  {"indx",1,{{1000}},NPY_INT},
  {"bin",1,{{20000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pybins(char *ihist,char *indx,char *bin) {
  int i_f2py=0;
  f2py_pybins_def[i_f2py++].data = ihist;
  f2py_pybins_def[i_f2py++].data = indx;
  f2py_pybins_def[i_f2py++].data = bin;
}
extern void F_FUNC(f2pyinitpybins,F2PYINITPYBINS)(void(*)(char*,char*,char*));
static void f2py_init_pybins(void) {
  F_FUNC(f2pyinitpybins,F2PYINITPYBINS)(f2py_setup_pybins);
}

static FortranDataDef f2py_pylh3p_def[] = {
  {"modsel",1,{{200}},NPY_INT},
  {"parmin",1,{{100}},NPY_DOUBLE},
  {"parext",1,{{200}},NPY_DOUBLE},
  {"rmsoft",1,{{101}},NPY_DOUBLE},
  {"au",2,{{3,3}},NPY_DOUBLE},
  {"ad",2,{{3,3}},NPY_DOUBLE},
  {"ae",2,{{3,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pylh3p(char *modsel,char *parmin,char *parext,char *rmsoft,char *au,char *ad,char *ae) {
  int i_f2py=0;
  f2py_pylh3p_def[i_f2py++].data = modsel;
  f2py_pylh3p_def[i_f2py++].data = parmin;
  f2py_pylh3p_def[i_f2py++].data = parext;
  f2py_pylh3p_def[i_f2py++].data = rmsoft;
  f2py_pylh3p_def[i_f2py++].data = au;
  f2py_pylh3p_def[i_f2py++].data = ad;
  f2py_pylh3p_def[i_f2py++].data = ae;
}
extern void F_FUNC(f2pyinitpylh3p,F2PYINITPYLH3P)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_pylh3p(void) {
  F_FUNC(f2pyinitpylh3p,F2PYINITPYLH3P)(f2py_setup_pylh3p);
}

static FortranDataDef f2py_pylh3c_def[] = {
  {"cpro",2,{{2,12}},NPY_STRING},
  {"cver",2,{{2,12}},NPY_STRING},
  {NULL}
};
static void f2py_setup_pylh3c(char *cpro,char *cver) {
  int i_f2py=0;
  f2py_pylh3c_def[i_f2py++].data = cpro;
  f2py_pylh3c_def[i_f2py++].data = cver;
}
extern void F_FUNC(f2pyinitpylh3c,F2PYINITPYLH3C)(void(*)(char*,char*));
static void f2py_init_pylh3c(void) {
  F_FUNC(f2pyinitpylh3c,F2PYINITPYLH3C)(f2py_setup_pylh3c);
}

static FortranDataDef f2py_pyjets_def[] = {
  {"n",0,{{-1}},NPY_INT},
  {"npad",0,{{-1}},NPY_INT},
  {"k",2,{{4000,5}},NPY_INT},
  {"p",2,{{4000,5}},NPY_DOUBLE},
  {"v",2,{{4000,5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyjets(char *n,char *npad,char *k,char *p,char *v) {
  int i_f2py=0;
  f2py_pyjets_def[i_f2py++].data = n;
  f2py_pyjets_def[i_f2py++].data = npad;
  f2py_pyjets_def[i_f2py++].data = k;
  f2py_pyjets_def[i_f2py++].data = p;
  f2py_pyjets_def[i_f2py++].data = v;
}
extern void F_FUNC(f2pyinitpyjets,F2PYINITPYJETS)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_pyjets(void) {
  F_FUNC(f2pyinitpyjets,F2PYINITPYJETS)(f2py_setup_pyjets);
}

static FortranDataDef f2py_hepevt_def[] = {
  {"nevhep",0,{{-1}},NPY_INT},
  {"nhep",0,{{-1}},NPY_INT},
  {"isthep",1,{{4000}},NPY_INT},
  {"idhep",1,{{4000}},NPY_INT},
  {"jmohep",2,{{2,4000}},NPY_INT},
  {"jdahep",2,{{2,4000}},NPY_INT},
  {"phep",2,{{5,4000}},NPY_DOUBLE},
  {"vhep",2,{{4,4000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepevt(char *nevhep,char *nhep,char *isthep,char *idhep,char *jmohep,char *jdahep,char *phep,char *vhep) {
  int i_f2py=0;
  f2py_hepevt_def[i_f2py++].data = nevhep;
  f2py_hepevt_def[i_f2py++].data = nhep;
  f2py_hepevt_def[i_f2py++].data = isthep;
  f2py_hepevt_def[i_f2py++].data = idhep;
  f2py_hepevt_def[i_f2py++].data = jmohep;
  f2py_hepevt_def[i_f2py++].data = jdahep;
  f2py_hepevt_def[i_f2py++].data = phep;
  f2py_hepevt_def[i_f2py++].data = vhep;
}
extern void F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepevt(void) {
  F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(f2py_setup_hepevt);
}

static FortranDataDef f2py_w50511_def[] = {
  {"nptype",0,{{-1}},NPY_INT},
  {"ngroup",0,{{-1}},NPY_INT},
  {"nset",0,{{-1}},NPY_INT},
  {"mode",0,{{-1}},NPY_INT},
  {"nfl",0,{{-1}},NPY_INT},
  {"lo",0,{{-1}},NPY_INT},
  {"tmas",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_w50511(char *nptype,char *ngroup,char *nset,char *mode,char *nfl,char *lo,char *tmas) {
  int i_f2py=0;
  f2py_w50511_def[i_f2py++].data = nptype;
  f2py_w50511_def[i_f2py++].data = ngroup;
  f2py_w50511_def[i_f2py++].data = nset;
  f2py_w50511_def[i_f2py++].data = mode;
  f2py_w50511_def[i_f2py++].data = nfl;
  f2py_w50511_def[i_f2py++].data = lo;
  f2py_w50511_def[i_f2py++].data = tmas;
}
extern void F_FUNC(f2pyinitw50511,F2PYINITW50511)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_w50511(void) {
  F_FUNC(f2pyinitw50511,F2PYINITW50511)(f2py_setup_w50511);
}

static FortranDataDef f2py_w50512_def[] = {
  {"qcdl4",0,{{-1}},NPY_DOUBLE},
  {"qcdl5",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_w50512(char *qcdl4,char *qcdl5) {
  int i_f2py=0;
  f2py_w50512_def[i_f2py++].data = qcdl4;
  f2py_w50512_def[i_f2py++].data = qcdl5;
}
extern void F_FUNC(f2pyinitw50512,F2PYINITW50512)(void(*)(char*,char*));
static void f2py_init_w50512(void) {
  F_FUNC(f2pyinitw50512,F2PYINITW50512)(f2py_setup_w50512);
}

static FortranDataDef f2py_pypart_def[] = {
  {"npart",0,{{-1}},NPY_INT},
  {"npartd",0,{{-1}},NPY_INT},
  {"ipart",1,{{1000}},NPY_INT},
  {"ptpart",1,{{1000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pypart(char *npart,char *npartd,char *ipart,char *ptpart) {
  int i_f2py=0;
  f2py_pypart_def[i_f2py++].data = npart;
  f2py_pypart_def[i_f2py++].data = npartd;
  f2py_pypart_def[i_f2py++].data = ipart;
  f2py_pypart_def[i_f2py++].data = ptpart;
}
extern void F_FUNC(f2pyinitpypart,F2PYINITPYPART)(void(*)(char*,char*,char*,char*));
static void f2py_init_pypart(void) {
  F_FUNC(f2pyinitpypart,F2PYINITPYPART)(f2py_setup_pypart);
}

static FortranDataDef f2py_pyctag_def[] = {
  {"nct",0,{{-1}},NPY_INT},
  {"mct",2,{{4000,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_pyctag(char *nct,char *mct) {
  int i_f2py=0;
  f2py_pyctag_def[i_f2py++].data = nct;
  f2py_pyctag_def[i_f2py++].data = mct;
}
extern void F_FUNC(f2pyinitpyctag,F2PYINITPYCTAG)(void(*)(char*,char*));
static void f2py_init_pyctag(void) {
  F_FUNC(f2pyinitpyctag,F2PYINITPYCTAG)(f2py_setup_pyctag);
}

static FortranDataDef f2py_pyintm_def[] = {
  {"kfival",2,{{2,3}},NPY_INT},
  {"nmi",1,{{2}},NPY_INT},
  {"imi",3,{{2,800,2}},NPY_INT},
  {"nvc",2,{{2,13}},NPY_INT},
  {"xassoc",3,{{2,13,240}},NPY_DOUBLE},
  {"xpsvc",2,{{13,242}},NPY_DOUBLE},
  {"pvctot",2,{{2,3}},NPY_DOUBLE},
  {"xmi",2,{{2,240}},NPY_DOUBLE},
  {"pt2mi",1,{{240}},NPY_DOUBLE},
  {"imisep",1,{{241}},NPY_INT},
  {NULL}
};
static void f2py_setup_pyintm(char *kfival,char *nmi,char *imi,char *nvc,char *xassoc,char *xpsvc,char *pvctot,char *xmi,char *pt2mi,char *imisep) {
  int i_f2py=0;
  f2py_pyintm_def[i_f2py++].data = kfival;
  f2py_pyintm_def[i_f2py++].data = nmi;
  f2py_pyintm_def[i_f2py++].data = imi;
  f2py_pyintm_def[i_f2py++].data = nvc;
  f2py_pyintm_def[i_f2py++].data = xassoc;
  f2py_pyintm_def[i_f2py++].data = xpsvc;
  f2py_pyintm_def[i_f2py++].data = pvctot;
  f2py_pyintm_def[i_f2py++].data = xmi;
  f2py_pyintm_def[i_f2py++].data = pt2mi;
  f2py_pyintm_def[i_f2py++].data = imisep;
}
extern void F_FUNC(f2pyinitpyintm,F2PYINITPYINTM)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_pyintm(void) {
  F_FUNC(f2pyinitpyintm,F2PYINITPYINTM)(f2py_setup_pyintm);
}

static FortranDataDef f2py_hepeup_def[] = {
  {"nup",0,{{-1}},NPY_INT},
  {"idprup",0,{{-1}},NPY_INT},
  {"xwgtup",0,{{-1}},NPY_DOUBLE},
  {"scalup",0,{{-1}},NPY_DOUBLE},
  {"aqedup",0,{{-1}},NPY_DOUBLE},
  {"aqcdup",0,{{-1}},NPY_DOUBLE},
  {"idup",1,{{500}},NPY_INT},
  {"istup",1,{{500}},NPY_INT},
  {"mothup",2,{{2,500}},NPY_INT},
  {"icolup",2,{{2,500}},NPY_INT},
  {"pup",2,{{5,500}},NPY_DOUBLE},
  {"vtimup",1,{{500}},NPY_DOUBLE},
  {"spinup",1,{{500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepeup(char *nup,char *idprup,char *xwgtup,char *scalup,char *aqedup,char *aqcdup,char *idup,char *istup,char *mothup,char *icolup,char *pup,char *vtimup,char *spinup) {
  int i_f2py=0;
  f2py_hepeup_def[i_f2py++].data = nup;
  f2py_hepeup_def[i_f2py++].data = idprup;
  f2py_hepeup_def[i_f2py++].data = xwgtup;
  f2py_hepeup_def[i_f2py++].data = scalup;
  f2py_hepeup_def[i_f2py++].data = aqedup;
  f2py_hepeup_def[i_f2py++].data = aqcdup;
  f2py_hepeup_def[i_f2py++].data = idup;
  f2py_hepeup_def[i_f2py++].data = istup;
  f2py_hepeup_def[i_f2py++].data = mothup;
  f2py_hepeup_def[i_f2py++].data = icolup;
  f2py_hepeup_def[i_f2py++].data = pup;
  f2py_hepeup_def[i_f2py++].data = vtimup;
  f2py_hepeup_def[i_f2py++].data = spinup;
}
extern void F_FUNC(f2pyinithepeup,F2PYINITHEPEUP)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepeup(void) {
  F_FUNC(f2pyinithepeup,F2PYINITHEPEUP)(f2py_setup_hepeup);
}

static FortranDataDef f2py_npy_def[] = {
  {"bitgen",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_npy(char *bitgen) {
  int i_f2py=0;
  f2py_npy_def[i_f2py++].data = bitgen;
}
extern void F_FUNC(f2pyinitnpy,F2PYINITNPY)(void(*)(char*));
static void f2py_init_npy(void) {
  F_FUNC(f2pyinitnpy,F2PYINITNPY)(f2py_setup_npy);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"pyhepc",-1,{{-1}},0,(char *)F_FUNC(pyhepc,PYHEPC),(f2py_init_func)f2py_rout__pythia6_pyhepc,doc_f2py_rout__pythia6_pyhepc},
  {"pyinit",-1,{{-1}},0,(char *)F_FUNC(pyinit,PYINIT),(f2py_init_func)f2py_rout__pythia6_pyinit,doc_f2py_rout__pythia6_pyinit},
  {"pyevnt",-1,{{-1}},0,(char *)F_FUNC(pyevnt,PYEVNT),(f2py_init_func)f2py_rout__pythia6_pyevnt,doc_f2py_rout__pythia6_pyevnt},
  {"pyevnw",-1,{{-1}},0,(char *)F_FUNC(pyevnw,PYEVNW),(f2py_init_func)f2py_rout__pythia6_pyevnw,doc_f2py_rout__pythia6_pyevnw},
  {"pystat",-1,{{-1}},0,(char *)F_FUNC(pystat,PYSTAT),(f2py_init_func)f2py_rout__pythia6_pystat,doc_f2py_rout__pythia6_pystat},
  {"pytune",-1,{{-1}},0,(char *)F_FUNC(pytune,PYTUNE),(f2py_init_func)f2py_rout__pythia6_pytune,doc_f2py_rout__pythia6_pytune},
  {"pyexec",-1,{{-1}},0,(char *)F_FUNC(pyexec,PYEXEC),(f2py_init_func)f2py_rout__pythia6_pyexec,doc_f2py_rout__pythia6_pyexec},
  {"pychge",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(pychge,PYCHGE),(f2py_init_func)f2py_rout__pythia6_pychge,doc_f2py_rout__pythia6_pychge},
  {"pycomp",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(pycomp,PYCOMP),(f2py_init_func)f2py_rout__pythia6_pycomp,doc_f2py_rout__pythia6_pycomp},
  {"pyedit",-1,{{-1}},0,(char *)F_FUNC(pyedit,PYEDIT),(f2py_init_func)f2py_rout__pythia6_pyedit,doc_f2py_rout__pythia6_pyedit},
  {"pylist",-1,{{-1}},0,(char *)F_FUNC(pylist,PYLIST),(f2py_init_func)f2py_rout__pythia6_pylist,doc_f2py_rout__pythia6_pylist},
  {"pyk",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(pyk,PYK),(f2py_init_func)f2py_rout__pythia6_pyk,doc_f2py_rout__pythia6_pyk},
  {"chromo_openlogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE),(f2py_init_func)f2py_rout__pythia6_chromo_openlogfile,doc_f2py_rout__pythia6_chromo_openlogfile},
  {"chromo_closelogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE),(f2py_init_func)f2py_rout__pythia6_chromo_closelogfile,doc_f2py_rout__pythia6_chromo_closelogfile},
  {"npyrng",-1,{{-1}},0,(char *)F_FUNC(npyrng,NPYRNG),(f2py_init_func)f2py_rout__pythia6_npyrng,doc_f2py_rout__pythia6_npyrng},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_pythia6",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__pythia6(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = _pythia6_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _pythia6 (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module '_pythia6' is auto-generated with f2py (version:2).\nFunctions:\n"
"  pyhepc(mconv)\n"
"  pyinit(frame,beam,target,win)\n"
"  pyevnt()\n"
"  pyevnw()\n"
"  pystat(mstat)\n"
"  pytune(mytune)\n"
"  pyexec()\n"
"  pychge = pychge(kf)\n"
"  pycomp = pycomp(kf)\n"
"  pyedit(medit)\n"
"  pylist(mlist)\n"
"  pyk = pyk(i,j)\n"
"  chromo_openlogfile(fname,opunit)\n"
"  chromo_closelogfile(opunit)\n"
"  npyrng(rval)\n"
"COMMON blocks:\n""  /pydat1/ mstu(200),paru(200),mstj(200),parj(200)\n""  /pydat2/ kchg(500,4),pmas(500,4),parf(2000),vckm(4,4)\n""  /pydat3/ mdcy(500,3),mdme(8000,2),brat(8000),kfdp(8000,5)\n""  /pydat4/ chaf(500,2,16)\n""  /pydatr/ mrpy(6),rrpy(100)\n""  /pysubs/ msel,mselpd,msub(500),kfin(2,81),ckin(200)\n""  /pypars/ mstp(200),parp(200),msti(200),pari(200)\n""  /pyint1/ mint(400),vint(400)\n""  /pyint2/ iset(500),kfpr(500,2),coef(500,20),icol(40,4,2)\n""  /pyint3/ xsfx(2,81),isig(1000,3),sigh(1000)\n""  /pyint4/ mwid(500),wids(500,5)\n""  /pyint5/ ngenpd,ngen(501,3),xsec(501,3)\n""  /pyint6/ proc(501,28)\n""  /pyint7/ sigt(7,7,6)\n""  /pymssm/ imss(100),rmss(100)\n""  /pyssmt/ zmix(4,4),umix(2,2),vmix(2,2),smz(4),smw(2),sfmix(16,4),zmixi(4,4),umixi(2,2),vmixi(2,2)\n""  /pymsrv/ rvlam(3,3,3),rvlamp(3,3,3),rvlamb(3,3,3)\n""  /pytcsm/ itcm(100),rtcm(100)\n""  /pypued/ iued(100),rued(100)\n""  /pybins/ ihist(4),indx(1000),bin(20000)\n""  /pylh3p/ modsel(200),parmin(100),parext(200),rmsoft(101),au(3,3),ad(3,3),ae(3,3)\n""  /pylh3c/ cpro(2,12),cver(2,12)\n""  /pyjets/ n,npad,k(4000,5),p(4000,5),v(4000,5)\n""  /hepevt/ nevhep,nhep,isthep(4000),idhep(4000),jmohep(2,4000),jdahep(2,4000),phep(5,4000),vhep(4,4000)\n""  /w50511/ nptype,ngroup,nset,mode,nfl,lo,tmas\n""  /w50512/ qcdl4,qcdl5\n""  /pypart/ npart,npartd,ipart(1000),ptpart(1000)\n""  /pyctag/ nct,mct(4000,2)\n""  /pyintm/ kfival(2,3),nmi(2),imi(2,800,2),nvc(2,13),xassoc(2,13,240),xpsvc(13,242),pvctot(2,3),xmi(2,240),pt2mi(240),imisep(241)\n""  /hepeup/ nup,idprup,xwgtup,scalup,aqedup,aqcdup,idup(500),istup(500),mothup(2,500),icolup(2,500),pup(5,500),vtimup(500),spinup(500)\n""  /npy/ bitgen\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _pythia6_error = PyErr_NewException ("_pythia6.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__pythia6_error", _pythia6_error);
  Py_DECREF(_pythia6_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }








    {
      extern int F_FUNC(pychge,PYCHGE)(void);
      PyObject* o = PyDict_GetItemString(d,"pychge");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(pychge,PYCHGE),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("pychge");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern int F_FUNC(pycomp,PYCOMP)(void);
      PyObject* o = PyDict_GetItemString(d,"pycomp");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(pycomp,PYCOMP),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("pycomp");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    



    {
      extern int F_FUNC(pyk,PYK)(void);
      PyObject* o = PyDict_GetItemString(d,"pyk");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(pyk,PYK),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("pyk");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    



/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_pydat1_def,f2py_init_pydat1);
  F2PyDict_SetItemString(d, "pydat1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydat2_def,f2py_init_pydat2);
  F2PyDict_SetItemString(d, "pydat2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydat3_def,f2py_init_pydat3);
  F2PyDict_SetItemString(d, "pydat3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydat4_def,f2py_init_pydat4);
  F2PyDict_SetItemString(d, "pydat4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydatr_def,f2py_init_pydatr);
  F2PyDict_SetItemString(d, "pydatr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pysubs_def,f2py_init_pysubs);
  F2PyDict_SetItemString(d, "pysubs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pypars_def,f2py_init_pypars);
  F2PyDict_SetItemString(d, "pypars", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint1_def,f2py_init_pyint1);
  F2PyDict_SetItemString(d, "pyint1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint2_def,f2py_init_pyint2);
  F2PyDict_SetItemString(d, "pyint2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint3_def,f2py_init_pyint3);
  F2PyDict_SetItemString(d, "pyint3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint4_def,f2py_init_pyint4);
  F2PyDict_SetItemString(d, "pyint4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint5_def,f2py_init_pyint5);
  F2PyDict_SetItemString(d, "pyint5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint6_def,f2py_init_pyint6);
  F2PyDict_SetItemString(d, "pyint6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint7_def,f2py_init_pyint7);
  F2PyDict_SetItemString(d, "pyint7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pymssm_def,f2py_init_pymssm);
  F2PyDict_SetItemString(d, "pymssm", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyssmt_def,f2py_init_pyssmt);
  F2PyDict_SetItemString(d, "pyssmt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pymsrv_def,f2py_init_pymsrv);
  F2PyDict_SetItemString(d, "pymsrv", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pytcsm_def,f2py_init_pytcsm);
  F2PyDict_SetItemString(d, "pytcsm", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pypued_def,f2py_init_pypued);
  F2PyDict_SetItemString(d, "pypued", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pybins_def,f2py_init_pybins);
  F2PyDict_SetItemString(d, "pybins", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pylh3p_def,f2py_init_pylh3p);
  F2PyDict_SetItemString(d, "pylh3p", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pylh3c_def,f2py_init_pylh3c);
  F2PyDict_SetItemString(d, "pylh3c", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyjets_def,f2py_init_pyjets);
  F2PyDict_SetItemString(d, "pyjets", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepevt_def,f2py_init_hepevt);
  F2PyDict_SetItemString(d, "hepevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_w50511_def,f2py_init_w50511);
  F2PyDict_SetItemString(d, "w50511", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_w50512_def,f2py_init_w50512);
  F2PyDict_SetItemString(d, "w50512", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pypart_def,f2py_init_pypart);
  F2PyDict_SetItemString(d, "pypart", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyctag_def,f2py_init_pyctag);
  F2PyDict_SetItemString(d, "pyctag", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyintm_def,f2py_init_pyintm);
  F2PyDict_SetItemString(d, "pyintm", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepeup_def,f2py_init_hepeup);
  F2PyDict_SetItemString(d, "hepeup", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_npy_def,f2py_init_npy);
  F2PyDict_SetItemString(d, "npy", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_pythia6");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
