/* File: _qgs01module.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Mon Jan 16 17:30:53 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_qgs01_error;
static PyObject *_qgs01_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _qgs01_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _qgs01_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _qgs01_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(psaini,PSAINI)(string,size_t);
extern void F_FUNC(psconf,PSCONF)(void);
extern void F_FUNC(xxaini,XXAINI)(double*,int*,int*,int*);
extern void F_FUNC(xxreg,XXREG)(double*,int*);
extern void F_WRAPPEDFUNC(sectnu,SECTNU)(double*,double*,int*,int*);
extern void F_FUNC(cqgsini,CQGSINI)(string,int*,int*,size_t);
extern void F_FUNC(chepevt,CHEPEVT)(void);
extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t);
extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*);
extern void F_FUNC(npyrng,NPYRNG)(double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** psaini ***********************************/
static char doc_f2py_rout__qgs01_psaini[] = "\
psaini(datdir)\n\nWrapper for ``psaini``.\
\n\nParameters\n----------\n"
"datdir : input string(len=256)";
/* extern void F_FUNC(psaini,PSAINI)(string,size_t); */
static PyObject *f2py_rout__qgs01_psaini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string datdir = NULL;
  int slen(datdir);
  PyObject *datdir_capi = Py_None;
  static char *capi_kwlist[] = {"datdir",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_qgs01.psaini",\
    capi_kwlist,&datdir_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable datdir */
  slen(datdir) = 256;
  f2py_success = string_from_pyobj(&datdir,&slen(datdir),"",datdir_capi,"string_from_pyobj failed in converting 1st argument `datdir' of _qgs01.psaini to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(datdir,slen(datdir));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(datdir);
  }  /*if (f2py_success) of datdir*/
  /* End of cleaning variable datdir */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of psaini *******************************/

/*********************************** psconf ***********************************/
static char doc_f2py_rout__qgs01_psconf[] = "\
psconf()\n\nWrapper for ``psconf``.\
\n";
/* extern void F_FUNC(psconf,PSCONF)(void); */
static PyObject *f2py_rout__qgs01_psconf(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_qgs01.psconf",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of psconf *******************************/

/*********************************** xxaini ***********************************/
static char doc_f2py_rout__qgs01_xxaini[] = "\
xxaini(e0n,icp0,iap,iat)\n\nWrapper for ``xxaini``.\
\n\nParameters\n----------\n"
"e0n : input float\n"
"icp0 : input int\n"
"iap : input int\n"
"iat : input int";
/* extern void F_FUNC(xxaini,XXAINI)(double*,int*,int*,int*); */
static PyObject *f2py_rout__qgs01_xxaini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double e0n = 0;
  PyObject *e0n_capi = Py_None;
  int icp0 = 0;
  PyObject *icp0_capi = Py_None;
  int iap = 0;
  PyObject *iap_capi = Py_None;
  int iat = 0;
  PyObject *iat_capi = Py_None;
  static char *capi_kwlist[] = {"e0n","icp0","iap","iat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:_qgs01.xxaini",\
    capi_kwlist,&e0n_capi,&icp0_capi,&iap_capi,&iat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable e0n */
    f2py_success = double_from_pyobj(&e0n,e0n_capi,"_qgs01.xxaini() 1st argument (e0n) can't be converted to double");
  if (f2py_success) {
  /* Processing variable icp0 */
    f2py_success = int_from_pyobj(&icp0,icp0_capi,"_qgs01.xxaini() 2nd argument (icp0) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iap */
    f2py_success = int_from_pyobj(&iap,iap_capi,"_qgs01.xxaini() 3rd argument (iap) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iat */
    f2py_success = int_from_pyobj(&iat,iat_capi,"_qgs01.xxaini() 4th argument (iat) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&e0n,&icp0,&iap,&iat);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iat*/
  /* End of cleaning variable iat */
  } /*if (f2py_success) of iap*/
  /* End of cleaning variable iap */
  } /*if (f2py_success) of icp0*/
  /* End of cleaning variable icp0 */
  } /*if (f2py_success) of e0n*/
  /* End of cleaning variable e0n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of xxaini *******************************/

/*********************************** xxreg ***********************************/
static char doc_f2py_rout__qgs01_xxreg[] = "\
xxreg(ep0,ic)\n\nWrapper for ``xxreg``.\
\n\nParameters\n----------\n"
"ep0 : input rank-1 array('d') with bounds (4)\n"
"ic : input int";
/* extern void F_FUNC(xxreg,XXREG)(double*,int*); */
static PyObject *f2py_rout__qgs01_xxreg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *ep0 = NULL;
  npy_intp ep0_Dims[1] = {-1};
  const int ep0_Rank = 1;
  PyArrayObject *capi_ep0_tmp = NULL;
  int capi_ep0_intent = 0;
  PyObject *ep0_capi = Py_None;
  int ic = 0;
  PyObject *ic_capi = Py_None;
  static char *capi_kwlist[] = {"ep0","ic",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_qgs01.xxreg",\
    capi_kwlist,&ep0_capi,&ic_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ep0 */
  ep0_Dims[0]=4;
  capi_ep0_intent |= F2PY_INTENT_IN;
  capi_ep0_tmp = array_from_pyobj(NPY_DOUBLE,ep0_Dims,ep0_Rank,capi_ep0_intent,ep0_capi);
  if (capi_ep0_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _qgs01_error,"failed in converting 1st argument `ep0' of _qgs01.xxreg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ep0 = (double *)(PyArray_DATA(capi_ep0_tmp));

  /* Processing variable ic */
    f2py_success = int_from_pyobj(&ic,ic_capi,"_qgs01.xxreg() 2nd argument (ic) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ep0,&ic);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ic*/
  /* End of cleaning variable ic */
  if((PyObject *)capi_ep0_tmp!=ep0_capi) {
    Py_XDECREF(capi_ep0_tmp); }
  }  /*if (capi_ep0_tmp == NULL) ... else of ep0*/
  /* End of cleaning variable ep0 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of xxreg ********************************/

/*********************************** sectnu ***********************************/
static char doc_f2py_rout__qgs01_sectnu[] = "\
sectnu = sectnu(e0n,iap,iat)\n\nWrapper for ``sectnu``.\
\n\nParameters\n----------\n"
"e0n : input float\n"
"iap : input int\n"
"iat : input int\n"
"\nReturns\n-------\n"
"sectnu : float";
/* extern void F_WRAPPEDFUNC(sectnu,SECTNU)(double*,double*,int*,int*); */
static PyObject *f2py_rout__qgs01_sectnu(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double sectnu = 0;
  double e0n = 0;
  PyObject *e0n_capi = Py_None;
  int iap = 0;
  PyObject *iap_capi = Py_None;
  int iat = 0;
  PyObject *iat_capi = Py_None;
  static char *capi_kwlist[] = {"e0n","iap","iat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_qgs01.sectnu",\
    capi_kwlist,&e0n_capi,&iap_capi,&iat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable e0n */
    f2py_success = double_from_pyobj(&e0n,e0n_capi,"_qgs01.sectnu() 1st argument (e0n) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iap */
    f2py_success = int_from_pyobj(&iap,iap_capi,"_qgs01.sectnu() 2nd argument (iap) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iat */
    f2py_success = int_from_pyobj(&iat,iat_capi,"_qgs01.sectnu() 3rd argument (iat) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sectnu */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&sectnu,&e0n,&iap,&iat);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",sectnu);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable sectnu */
  } /*if (f2py_success) of iat*/
  /* End of cleaning variable iat */
  } /*if (f2py_success) of iap*/
  /* End of cleaning variable iap */
  } /*if (f2py_success) of e0n*/
  /* End of cleaning variable e0n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of sectnu *******************************/

/********************************** cqgsini **********************************/
static char doc_f2py_rout__qgs01_cqgsini[] = "\
cqgsini(datdir,lun,debugnum)\n\nWrapper for ``cqgsini``.\
\n\nParameters\n----------\n"
"datdir : input string(len=256)\n"
"lun : input int\n"
"debugnum : input int";
/* extern void F_FUNC(cqgsini,CQGSINI)(string,int*,int*,size_t); */
static PyObject *f2py_rout__qgs01_cqgsini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string datdir = NULL;
  int slen(datdir);
  PyObject *datdir_capi = Py_None;
  int lun = 0;
  PyObject *lun_capi = Py_None;
  int debugnum = 0;
  PyObject *debugnum_capi = Py_None;
  static char *capi_kwlist[] = {"datdir","lun","debugnum",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_qgs01.cqgsini",\
    capi_kwlist,&datdir_capi,&lun_capi,&debugnum_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable datdir */
  slen(datdir) = 256;
  f2py_success = string_from_pyobj(&datdir,&slen(datdir),"",datdir_capi,"string_from_pyobj failed in converting 1st argument `datdir' of _qgs01.cqgsini to C string");
  if (f2py_success) {
  /* Processing variable lun */
    f2py_success = int_from_pyobj(&lun,lun_capi,"_qgs01.cqgsini() 2nd argument (lun) can't be converted to int");
  if (f2py_success) {
  /* Processing variable debugnum */
    f2py_success = int_from_pyobj(&debugnum,debugnum_capi,"_qgs01.cqgsini() 3rd argument (debugnum) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(datdir,&lun,&debugnum,slen(datdir));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of debugnum*/
  /* End of cleaning variable debugnum */
  } /*if (f2py_success) of lun*/
  /* End of cleaning variable lun */
    STRINGFREE(datdir);
  }  /*if (f2py_success) of datdir*/
  /* End of cleaning variable datdir */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of cqgsini *******************************/

/********************************** chepevt **********************************/
static char doc_f2py_rout__qgs01_chepevt[] = "\
chepevt()\n\nWrapper for ``chepevt``.\
\n";
/* extern void F_FUNC(chepevt,CHEPEVT)(void); */
static PyObject *f2py_rout__qgs01_chepevt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_qgs01.chepevt",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of chepevt *******************************/

/***************************** chromo_openlogfile *****************************/
static char doc_f2py_rout__qgs01_chromo_openlogfile[] = "\
chromo_openlogfile(fname,opunit)\n\nWrapper for ``chromo_openlogfile``.\
\n\nParameters\n----------\n"
"fname : input string(len=300)\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t); */
static PyObject *f2py_rout__qgs01_chromo_openlogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string fname = NULL;
  int slen(fname);
  PyObject *fname_capi = Py_None;
  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"fname","opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_qgs01.chromo_openlogfile",\
    capi_kwlist,&fname_capi,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fname */
  slen(fname) = 300;
  f2py_success = string_from_pyobj(&fname,&slen(fname),"",fname_capi,"string_from_pyobj failed in converting 1st argument `fname' of _qgs01.chromo_openlogfile to C string");
  if (f2py_success) {
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_qgs01.chromo_openlogfile() 2nd argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(fname,&opunit,slen(fname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
    STRINGFREE(fname);
  }  /*if (f2py_success) of fname*/
  /* End of cleaning variable fname */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_openlogfile *************************/

/**************************** chromo_closelogfile ****************************/
static char doc_f2py_rout__qgs01_chromo_closelogfile[] = "\
chromo_closelogfile(opunit)\n\nWrapper for ``chromo_closelogfile``.\
\n\nParameters\n----------\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*); */
static PyObject *f2py_rout__qgs01_chromo_closelogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_qgs01.chromo_closelogfile",\
    capi_kwlist,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_qgs01.chromo_closelogfile() 1st argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&opunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_closelogfile *************************/

/*********************************** npyrng ***********************************/
static char doc_f2py_rout__qgs01_npyrng[] = "\
npyrng(rval)\n\nWrapper for ``npyrng``.\
\n\nParameters\n----------\n"
"rval : input float";
/* extern void F_FUNC(npyrng,NPYRNG)(double*); */
static PyObject *f2py_rout__qgs01_npyrng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rval = 0;
  PyObject *rval_capi = Py_None;
  static char *capi_kwlist[] = {"rval",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_qgs01.npyrng",\
    capi_kwlist,&rval_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rval */
    f2py_success = double_from_pyobj(&rval,rval_capi,"_qgs01.npyrng() 1st argument (rval) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rval);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of rval*/
  /* End of cleaning variable rval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of npyrng *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_xsect_def[] = {
  {"gsect",3,{{10,5,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_xsect(char *gsect) {
  int i_f2py=0;
  f2py_xsect_def[i_f2py++].data = gsect;
}
extern void F_FUNC(f2pyinitxsect,F2PYINITXSECT)(void(*)(char*));
static void f2py_init_xsect(void) {
  F_FUNC(f2pyinitxsect,F2PYINITXSECT)(f2py_setup_xsect);
}

static FortranDataDef f2py_area1_def[] = {
  {"ia",1,{{2}},NPY_INT},
  {"icz",0,{{-1}},NPY_INT},
  {"icp",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_area1(char *ia,char *icz,char *icp) {
  int i_f2py=0;
  f2py_area1_def[i_f2py++].data = ia;
  f2py_area1_def[i_f2py++].data = icz;
  f2py_area1_def[i_f2py++].data = icp;
}
extern void F_FUNC(f2pyinitarea1,F2PYINITAREA1)(void(*)(char*,char*,char*));
static void f2py_init_area1(void) {
  F_FUNC(f2pyinitarea1,F2PYINITAREA1)(f2py_setup_area1);
}

static FortranDataDef f2py_area5_def[] = {
  {"rd",1,{{2}},NPY_DOUBLE},
  {"cr1",1,{{2}},NPY_DOUBLE},
  {"cr2",1,{{2}},NPY_DOUBLE},
  {"cr3",1,{{2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area5(char *rd,char *cr1,char *cr2,char *cr3) {
  int i_f2py=0;
  f2py_area5_def[i_f2py++].data = rd;
  f2py_area5_def[i_f2py++].data = cr1;
  f2py_area5_def[i_f2py++].data = cr2;
  f2py_area5_def[i_f2py++].data = cr3;
}
extern void F_FUNC(f2pyinitarea5,F2PYINITAREA5)(void(*)(char*,char*,char*,char*));
static void f2py_init_area5(void) {
  F_FUNC(f2pyinitarea5,F2PYINITAREA5)(f2py_setup_area5);
}

static FortranDataDef f2py_area6_def[] = {
  {"pi",0,{{-1}},NPY_DOUBLE},
  {"bm",0,{{-1}},NPY_DOUBLE},
  {"am",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area6(char *pi,char *bm,char *am) {
  int i_f2py=0;
  f2py_area6_def[i_f2py++].data = pi;
  f2py_area6_def[i_f2py++].data = bm;
  f2py_area6_def[i_f2py++].data = am;
}
extern void F_FUNC(f2pyinitarea6,F2PYINITAREA6)(void(*)(char*,char*,char*));
static void f2py_init_area6(void) {
  F_FUNC(f2pyinitarea6,F2PYINITAREA6)(f2py_setup_area6);
}

static FortranDataDef f2py_area7_def[] = {
  {"rp1",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area7(char *rp1) {
  int i_f2py=0;
  f2py_area7_def[i_f2py++].data = rp1;
}
extern void F_FUNC(f2pyinitarea7,F2PYINITAREA7)(void(*)(char*));
static void f2py_init_area7(void) {
  F_FUNC(f2pyinitarea7,F2PYINITAREA7)(f2py_setup_area7);
}

static FortranDataDef f2py_area10_def[] = {
  {"stmass",0,{{-1}},NPY_DOUBLE},
  {"am0",0,{{-1}},NPY_DOUBLE},
  {"amn",0,{{-1}},NPY_DOUBLE},
  {"amk",0,{{-1}},NPY_DOUBLE},
  {"amc",0,{{-1}},NPY_DOUBLE},
  {"amlamc",0,{{-1}},NPY_DOUBLE},
  {"amlam",0,{{-1}},NPY_DOUBLE},
  {"ameta",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area10(char *stmass,char *am0,char *amn,char *amk,char *amc,char *amlamc,char *amlam,char *ameta) {
  int i_f2py=0;
  f2py_area10_def[i_f2py++].data = stmass;
  f2py_area10_def[i_f2py++].data = am0;
  f2py_area10_def[i_f2py++].data = amn;
  f2py_area10_def[i_f2py++].data = amk;
  f2py_area10_def[i_f2py++].data = amc;
  f2py_area10_def[i_f2py++].data = amlamc;
  f2py_area10_def[i_f2py++].data = amlam;
  f2py_area10_def[i_f2py++].data = ameta;
}
extern void F_FUNC(f2pyinitarea10,F2PYINITAREA10)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_area10(void) {
  F_FUNC(f2pyinitarea10,F2PYINITAREA10)(f2py_setup_area10);
}

static FortranDataDef f2py_area15_def[] = {
  {"fp",1,{{5}},NPY_DOUBLE},
  {"rq",1,{{5}},NPY_DOUBLE},
  {"cd",1,{{5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area15(char *fp,char *rq,char *cd) {
  int i_f2py=0;
  f2py_area15_def[i_f2py++].data = fp;
  f2py_area15_def[i_f2py++].data = rq;
  f2py_area15_def[i_f2py++].data = cd;
}
extern void F_FUNC(f2pyinitarea15,F2PYINITAREA15)(void(*)(char*,char*,char*));
static void f2py_init_area15(void) {
  F_FUNC(f2pyinitarea15,F2PYINITAREA15)(f2py_setup_area15);
}

static FortranDataDef f2py_area16_def[] = {
  {"cc",1,{{5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area16(char *cc) {
  int i_f2py=0;
  f2py_area16_def[i_f2py++].data = cc;
}
extern void F_FUNC(f2pyinitarea16,F2PYINITAREA16)(void(*)(char*));
static void f2py_init_area16(void) {
  F_FUNC(f2pyinitarea16,F2PYINITAREA16)(f2py_setup_area16);
}

static FortranDataDef f2py_area17_def[] = {
  {"del",0,{{-1}},NPY_DOUBLE},
  {"rs",0,{{-1}},NPY_DOUBLE},
  {"rs0",0,{{-1}},NPY_DOUBLE},
  {"fs",0,{{-1}},NPY_DOUBLE},
  {"alfp",0,{{-1}},NPY_DOUBLE},
  {"rr",0,{{-1}},NPY_DOUBLE},
  {"sh",0,{{-1}},NPY_DOUBLE},
  {"delh",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area17(char *del,char *rs,char *rs0,char *fs,char *alfp,char *rr,char *sh,char *delh) {
  int i_f2py=0;
  f2py_area17_def[i_f2py++].data = del;
  f2py_area17_def[i_f2py++].data = rs;
  f2py_area17_def[i_f2py++].data = rs0;
  f2py_area17_def[i_f2py++].data = fs;
  f2py_area17_def[i_f2py++].data = alfp;
  f2py_area17_def[i_f2py++].data = rr;
  f2py_area17_def[i_f2py++].data = sh;
  f2py_area17_def[i_f2py++].data = delh;
}
extern void F_FUNC(f2pyinitarea17,F2PYINITAREA17)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_area17(void) {
  F_FUNC(f2pyinitarea17,F2PYINITAREA17)(f2py_setup_area17);
}

static FortranDataDef f2py_area18_def[] = {
  {"alm",0,{{-1}},NPY_DOUBLE},
  {"qt0",0,{{-1}},NPY_DOUBLE},
  {"qlog",0,{{-1}},NPY_DOUBLE},
  {"qll",0,{{-1}},NPY_DOUBLE},
  {"aqt0",0,{{-1}},NPY_DOUBLE},
  {"qtf",0,{{-1}},NPY_DOUBLE},
  {"bet",0,{{-1}},NPY_DOUBLE},
  {"amj0",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area18(char *alm,char *qt0,char *qlog,char *qll,char *aqt0,char *qtf,char *bet,char *amj0) {
  int i_f2py=0;
  f2py_area18_def[i_f2py++].data = alm;
  f2py_area18_def[i_f2py++].data = qt0;
  f2py_area18_def[i_f2py++].data = qlog;
  f2py_area18_def[i_f2py++].data = qll;
  f2py_area18_def[i_f2py++].data = aqt0;
  f2py_area18_def[i_f2py++].data = qtf;
  f2py_area18_def[i_f2py++].data = bet;
  f2py_area18_def[i_f2py++].data = amj0;
}
extern void F_FUNC(f2pyinitarea18,F2PYINITAREA18)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_area18(void) {
  F_FUNC(f2pyinitarea18,F2PYINITAREA18)(f2py_setup_area18);
}

static FortranDataDef f2py_area19_def[] = {
  {"ahl",1,{{5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area19(char *ahl) {
  int i_f2py=0;
  f2py_area19_def[i_f2py++].data = ahl;
}
extern void F_FUNC(f2pyinitarea19,F2PYINITAREA19)(void(*)(char*));
static void f2py_init_area19(void) {
  F_FUNC(f2pyinitarea19,F2PYINITAREA19)(f2py_setup_area19);
}

static FortranDataDef f2py_area22_def[] = {
  {"sjv0",0,{{-1}},NPY_DOUBLE},
  {"fjs0",2,{{5,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area22(char *sjv0,char *fjs0) {
  int i_f2py=0;
  f2py_area22_def[i_f2py++].data = sjv0;
  f2py_area22_def[i_f2py++].data = fjs0;
}
extern void F_FUNC(f2pyinitarea22,F2PYINITAREA22)(void(*)(char*,char*));
static void f2py_init_area22(void) {
  F_FUNC(f2pyinitarea22,F2PYINITAREA22)(f2py_setup_area22);
}

static FortranDataDef f2py_area23_def[] = {
  {"rjv",1,{{50}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area23(char *rjv) {
  int i_f2py=0;
  f2py_area23_def[i_f2py++].data = rjv;
}
extern void F_FUNC(f2pyinitarea23,F2PYINITAREA23)(void(*)(char*));
static void f2py_init_area23(void) {
  F_FUNC(f2pyinitarea23,F2PYINITAREA23)(f2py_setup_area23);
}

static FortranDataDef f2py_area24_def[] = {
  {"rjs",3,{{50,5,10}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area24(char *rjs) {
  int i_f2py=0;
  f2py_area24_def[i_f2py++].data = rjs;
}
extern void F_FUNC(f2pyinitarea24,F2PYINITAREA24)(void(*)(char*));
static void f2py_init_area24(void) {
  F_FUNC(f2pyinitarea24,F2PYINITAREA24)(f2py_setup_area24);
}

static FortranDataDef f2py_area27_def[] = {
  {"fp0",1,{{5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area27(char *fp0) {
  int i_f2py=0;
  f2py_area27_def[i_f2py++].data = fp0;
}
extern void F_FUNC(f2pyinitarea27,F2PYINITAREA27)(void(*)(char*));
static void f2py_init_area27(void) {
  F_FUNC(f2pyinitarea27,F2PYINITAREA27)(f2py_setup_area27);
}

static FortranDataDef f2py_area28_def[] = {
  {"arr",1,{{4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area28(char *arr) {
  int i_f2py=0;
  f2py_area28_def[i_f2py++].data = arr;
}
extern void F_FUNC(f2pyinitarea28,F2PYINITAREA28)(void(*)(char*));
static void f2py_init_area28(void) {
  F_FUNC(f2pyinitarea28,F2PYINITAREA28)(f2py_setup_area28);
}

static FortranDataDef f2py_area29_def[] = {
  {"cstot",3,{{17,17,68}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area29(char *cstot) {
  int i_f2py=0;
  f2py_area29_def[i_f2py++].data = cstot;
}
extern void F_FUNC(f2pyinitarea29,F2PYINITAREA29)(void(*)(char*));
static void f2py_init_area29(void) {
  F_FUNC(f2pyinitarea29,F2PYINITAREA29)(f2py_setup_area29);
}

static FortranDataDef f2py_area30_def[] = {
  {"cs0",3,{{17,17,68}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area30(char *cs0) {
  int i_f2py=0;
  f2py_area30_def[i_f2py++].data = cs0;
}
extern void F_FUNC(f2pyinitarea30,F2PYINITAREA30)(void(*)(char*));
static void f2py_init_area30(void) {
  F_FUNC(f2pyinitarea30,F2PYINITAREA30)(f2py_setup_area30);
}

static FortranDataDef f2py_area31_def[] = {
  {"csborn",2,{{17,68}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area31(char *csborn) {
  int i_f2py=0;
  f2py_area31_def[i_f2py++].data = csborn;
}
extern void F_FUNC(f2pyinitarea31,F2PYINITAREA31)(void(*)(char*));
static void f2py_init_area31(void) {
  F_FUNC(f2pyinitarea31,F2PYINITAREA31)(f2py_setup_area31);
}

static FortranDataDef f2py_area32_def[] = {
  {"csq",3,{{17,2,2}},NPY_DOUBLE},
  {"csbq",3,{{17,2,2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area32(char *csq,char *csbq) {
  int i_f2py=0;
  f2py_area32_def[i_f2py++].data = csq;
  f2py_area32_def[i_f2py++].data = csbq;
}
extern void F_FUNC(f2pyinitarea32,F2PYINITAREA32)(void(*)(char*,char*));
static void f2py_init_area32(void) {
  F_FUNC(f2pyinitarea32,F2PYINITAREA32)(f2py_setup_area32);
}

static FortranDataDef f2py_area33_def[] = {
  {"fsud",2,{{10,2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area33(char *fsud) {
  int i_f2py=0;
  f2py_area33_def[i_f2py++].data = fsud;
}
extern void F_FUNC(f2pyinitarea33,F2PYINITAREA33)(void(*)(char*));
static void f2py_init_area33(void) {
  F_FUNC(f2pyinitarea33,F2PYINITAREA33)(f2py_setup_area33);
}

static FortranDataDef f2py_area34_def[] = {
  {"qrt",3,{{10,101,2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area34(char *qrt) {
  int i_f2py=0;
  f2py_area34_def[i_f2py++].data = qrt;
}
extern void F_FUNC(f2pyinitarea34,F2PYINITAREA34)(void(*)(char*));
static void f2py_init_area34(void) {
  F_FUNC(f2pyinitarea34,F2PYINITAREA34)(f2py_setup_area34);
}

static FortranDataDef f2py_area35_def[] = {
  {"sjv",2,{{10,5}},NPY_DOUBLE},
  {"fjs",3,{{10,5,15}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area35(char *sjv,char *fjs) {
  int i_f2py=0;
  f2py_area35_def[i_f2py++].data = sjv;
  f2py_area35_def[i_f2py++].data = fjs;
}
extern void F_FUNC(f2pyinitarea35,F2PYINITAREA35)(void(*)(char*,char*));
static void f2py_init_area35(void) {
  F_FUNC(f2pyinitarea35,F2PYINITAREA35)(f2py_setup_area35);
}

static FortranDataDef f2py_area39_def[] = {
  {"jcalc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_area39(char *jcalc) {
  int i_f2py=0;
  f2py_area39_def[i_f2py++].data = jcalc;
}
extern void F_FUNC(f2pyinitarea39,F2PYINITAREA39)(void(*)(char*));
static void f2py_init_area39(void) {
  F_FUNC(f2pyinitarea39,F2PYINITAREA39)(f2py_setup_area39);
}

static FortranDataDef f2py_area40_def[] = {
  {"jdifr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_area40(char *jdifr) {
  int i_f2py=0;
  f2py_area40_def[i_f2py++].data = jdifr;
}
extern void F_FUNC(f2pyinitarea40,F2PYINITAREA40)(void(*)(char*));
static void f2py_init_area40(void) {
  F_FUNC(f2pyinitarea40,F2PYINITAREA40)(f2py_setup_area40);
}

static FortranDataDef f2py_area41_def[] = {
  {"ty",2,{{5,7}},NPY_STRING},
  {NULL}
};
static void f2py_setup_area41(char *ty) {
  int i_f2py=0;
  f2py_area41_def[i_f2py++].data = ty;
}
extern void F_FUNC(f2pyinitarea41,F2PYINITAREA41)(void(*)(char*));
static void f2py_init_area41(void) {
  F_FUNC(f2pyinitarea41,F2PYINITAREA41)(f2py_setup_area41);
}

static FortranDataDef f2py_area43_def[] = {
  {"moniou",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_area43(char *moniou) {
  int i_f2py=0;
  f2py_area43_def[i_f2py++].data = moniou;
}
extern void F_FUNC(f2pyinitarea43,F2PYINITAREA43)(void(*)(char*));
static void f2py_init_area43(void) {
  F_FUNC(f2pyinitarea43,F2PYINITAREA43)(f2py_setup_area43);
}

static FortranDataDef f2py_debug_def[] = {
  {"debug",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_debug(char *debug) {
  int i_f2py=0;
  f2py_debug_def[i_f2py++].data = debug;
}
extern void F_FUNC(f2pyinitdebug,F2PYINITDEBUG)(void(*)(char*));
static void f2py_init_debug(void) {
  F_FUNC(f2pyinitdebug,F2PYINITDEBUG)(f2py_setup_debug);
}

static FortranDataDef f2py_area44_def[] = {
  {"gz",3,{{10,5,4}},NPY_DOUBLE},
  {"gzp",3,{{10,5,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area44(char *gz,char *gzp) {
  int i_f2py=0;
  f2py_area44_def[i_f2py++].data = gz;
  f2py_area44_def[i_f2py++].data = gzp;
}
extern void F_FUNC(f2pyinitarea44,F2PYINITAREA44)(void(*)(char*,char*));
static void f2py_init_area44(void) {
  F_FUNC(f2pyinitarea44,F2PYINITAREA44)(f2py_setup_area44);
}

static FortranDataDef f2py_ar1_def[] = {
  {"anorm",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ar1(char *anorm) {
  int i_f2py=0;
  f2py_ar1_def[i_f2py++].data = anorm;
}
extern void F_FUNC(f2pyinitar1,F2PYINITAR1)(void(*)(char*));
static void f2py_init_ar1(void) {
  F_FUNC(f2pyinitar1,F2PYINITAR1)(f2py_setup_ar1);
}

static FortranDataDef f2py_ar2_def[] = {
  {"rrr",0,{{-1}},NPY_DOUBLE},
  {"rrrm",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ar2(char *rrr,char *rrrm) {
  int i_f2py=0;
  f2py_ar2_def[i_f2py++].data = rrr;
  f2py_ar2_def[i_f2py++].data = rrrm;
}
extern void F_FUNC(f2pyinitar2,F2PYINITAR2)(void(*)(char*,char*));
static void f2py_init_ar2(void) {
  F_FUNC(f2pyinitar2,F2PYINITAR2)(f2py_setup_ar2);
}

static FortranDataDef f2py_area48_def[] = {
  {"asect",3,{{10,6,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area48(char *asect) {
  int i_f2py=0;
  f2py_area48_def[i_f2py++].data = asect;
}
extern void F_FUNC(f2pyinitarea48,F2PYINITAREA48)(void(*)(char*));
static void f2py_init_area48(void) {
  F_FUNC(f2pyinitarea48,F2PYINITAREA48)(f2py_setup_area48);
}

static FortranDataDef f2py_version_def[] = {
  {"version",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_version(char *version) {
  int i_f2py=0;
  f2py_version_def[i_f2py++].data = version;
}
extern void F_FUNC(f2pyinitversion,F2PYINITVERSION)(void(*)(char*));
static void f2py_init_version(void) {
  F_FUNC(f2pyinitversion,F2PYINITVERSION)(f2py_setup_version);
}

static FortranDataDef f2py_area2_def[] = {
  {"s",0,{{-1}},NPY_DOUBLE},
  {"y0",0,{{-1}},NPY_DOUBLE},
  {"wp0",0,{{-1}},NPY_DOUBLE},
  {"wm0",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area2(char *s,char *y0,char *wp0,char *wm0) {
  int i_f2py=0;
  f2py_area2_def[i_f2py++].data = s;
  f2py_area2_def[i_f2py++].data = y0;
  f2py_area2_def[i_f2py++].data = wp0;
  f2py_area2_def[i_f2py++].data = wm0;
}
extern void F_FUNC(f2pyinitarea2,F2PYINITAREA2)(void(*)(char*,char*,char*,char*));
static void f2py_init_area2(void) {
  F_FUNC(f2pyinitarea2,F2PYINITAREA2)(f2py_setup_area2);
}

static FortranDataDef f2py_area9_def[] = {
  {"lqa",1,{{56}},NPY_INT},
  {"lqb",1,{{56}},NPY_INT},
  {"nqs",1,{{1000}},NPY_INT},
  {"ias",1,{{1000}},NPY_INT},
  {"ibs",1,{{1000}},NPY_INT},
  {"lha",1,{{56}},NPY_INT},
  {"lhb",1,{{56}},NPY_INT},
  {"zh",1,{{4000}},NPY_DOUBLE},
  {"iah",1,{{4000}},NPY_INT},
  {"ibh",1,{{4000}},NPY_INT},
  {"iqh",1,{{4000}},NPY_INT},
  {"lva",1,{{56}},NPY_INT},
  {"lvb",1,{{56}},NPY_INT},
  {NULL}
};
static void f2py_setup_area9(char *lqa,char *lqb,char *nqs,char *ias,char *ibs,char *lha,char *lhb,char *zh,char *iah,char *ibh,char *iqh,char *lva,char *lvb) {
  int i_f2py=0;
  f2py_area9_def[i_f2py++].data = lqa;
  f2py_area9_def[i_f2py++].data = lqb;
  f2py_area9_def[i_f2py++].data = nqs;
  f2py_area9_def[i_f2py++].data = ias;
  f2py_area9_def[i_f2py++].data = ibs;
  f2py_area9_def[i_f2py++].data = lha;
  f2py_area9_def[i_f2py++].data = lhb;
  f2py_area9_def[i_f2py++].data = zh;
  f2py_area9_def[i_f2py++].data = iah;
  f2py_area9_def[i_f2py++].data = ibh;
  f2py_area9_def[i_f2py++].data = iqh;
  f2py_area9_def[i_f2py++].data = lva;
  f2py_area9_def[i_f2py++].data = lvb;
}
extern void F_FUNC(f2pyinitarea9,F2PYINITAREA9)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_area9(void) {
  F_FUNC(f2pyinitarea9,F2PYINITAREA9)(f2py_setup_area9);
}

static FortranDataDef f2py_area11_def[] = {
  {"b10",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area11(char *b10) {
  int i_f2py=0;
  f2py_area11_def[i_f2py++].data = b10;
}
extern void F_FUNC(f2pyinitarea11,F2PYINITAREA11)(void(*)(char*));
static void f2py_init_area11(void) {
  F_FUNC(f2pyinitarea11,F2PYINITAREA11)(f2py_setup_area11);
}

static FortranDataDef f2py_area12_def[] = {
  {"nsp",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_area12(char *nsp) {
  int i_f2py=0;
  f2py_area12_def[i_f2py++].data = nsp;
}
extern void F_FUNC(f2pyinitarea12,F2PYINITAREA12)(void(*)(char*));
static void f2py_init_area12(void) {
  F_FUNC(f2pyinitarea12,F2PYINITAREA12)(f2py_setup_area12);
}

static FortranDataDef f2py_area45_def[] = {
  {"gdt",0,{{-1}},NPY_DOUBLE},
  {"gdp",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area45(char *gdt,char *gdp) {
  int i_f2py=0;
  f2py_area45_def[i_f2py++].data = gdt;
  f2py_area45_def[i_f2py++].data = gdp;
}
extern void F_FUNC(f2pyinitarea45,F2PYINITAREA45)(void(*)(char*,char*));
static void f2py_init_area45(void) {
  F_FUNC(f2pyinitarea45,F2PYINITAREA45)(f2py_setup_area45);
}

static FortranDataDef f2py_area99_def[] = {
  {"nwt",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_area99(char *nwt) {
  int i_f2py=0;
  f2py_area99_def[i_f2py++].data = nwt;
}
extern void F_FUNC(f2pyinitarea99,F2PYINITAREA99)(void(*)(char*));
static void f2py_init_area99(void) {
  F_FUNC(f2pyinitarea99,F2PYINITAREA99)(f2py_setup_area99);
}

static FortranDataDef f2py_area4_def[] = {
  {"ey0",1,{{3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area4(char *ey0) {
  int i_f2py=0;
  f2py_area4_def[i_f2py++].data = ey0;
}
extern void F_FUNC(f2pyinitarea4,F2PYINITAREA4)(void(*)(char*));
static void f2py_init_area4(void) {
  F_FUNC(f2pyinitarea4,F2PYINITAREA4)(f2py_setup_area4);
}

static FortranDataDef f2py_area14_def[] = {
  {"esp",2,{{4,95000}},NPY_DOUBLE},
  {"ich",1,{{95000}},NPY_INT},
  {NULL}
};
static void f2py_setup_area14(char *esp,char *ich) {
  int i_f2py=0;
  f2py_area14_def[i_f2py++].data = esp;
  f2py_area14_def[i_f2py++].data = ich;
}
extern void F_FUNC(f2pyinitarea14,F2PYINITAREA14)(void(*)(char*,char*));
static void f2py_init_area14(void) {
  F_FUNC(f2pyinitarea14,F2PYINITAREA14)(f2py_setup_area14);
}

static FortranDataDef f2py_ar3_def[] = {
  {"x1",1,{{7}},NPY_DOUBLE},
  {"a1",1,{{7}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ar3(char *x1,char *a1) {
  int i_f2py=0;
  f2py_ar3_def[i_f2py++].data = x1;
  f2py_ar3_def[i_f2py++].data = a1;
}
extern void F_FUNC(f2pyinitar3,F2PYINITAR3)(void(*)(char*,char*));
static void f2py_init_ar3(void) {
  F_FUNC(f2pyinitar3,F2PYINITAR3)(f2py_setup_ar3);
}

static FortranDataDef f2py_ar5_def[] = {
  {"x5",1,{{2}},NPY_DOUBLE},
  {"a5",1,{{2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ar5(char *x5,char *a5) {
  int i_f2py=0;
  f2py_ar5_def[i_f2py++].data = x5;
  f2py_ar5_def[i_f2py++].data = a5;
}
extern void F_FUNC(f2pyinitar5,F2PYINITAR5)(void(*)(char*,char*));
static void f2py_init_ar5(void) {
  F_FUNC(f2pyinitar5,F2PYINITAR5)(f2py_setup_ar5);
}

static FortranDataDef f2py_ar8_def[] = {
  {"x2",1,{{4}},NPY_DOUBLE},
  {"a2",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ar8(char *x2,char *a2) {
  int i_f2py=0;
  f2py_ar8_def[i_f2py++].data = x2;
  f2py_ar8_def[i_f2py++].data = a2;
}
extern void F_FUNC(f2pyinitar8,F2PYINITAR8)(void(*)(char*,char*));
static void f2py_init_ar8(void) {
  F_FUNC(f2pyinitar8,F2PYINITAR8)(f2py_setup_ar8);
}

static FortranDataDef f2py_ar9_def[] = {
  {"x9",1,{{3}},NPY_DOUBLE},
  {"a9",1,{{3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ar9(char *x9,char *a9) {
  int i_f2py=0;
  f2py_ar9_def[i_f2py++].data = x9;
  f2py_ar9_def[i_f2py++].data = a9;
}
extern void F_FUNC(f2pyinitar9,F2PYINITAR9)(void(*)(char*,char*));
static void f2py_init_ar9(void) {
  F_FUNC(f2pyinitar9,F2PYINITAR9)(f2py_setup_ar9);
}

static FortranDataDef f2py_area8_def[] = {
  {"wwm",0,{{-1}},NPY_DOUBLE},
  {"be",1,{{4}},NPY_DOUBLE},
  {"dc",1,{{5}},NPY_DOUBLE},
  {"deta",0,{{-1}},NPY_DOUBLE},
  {"almpt",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_area8(char *wwm,char *be,char *dc,char *deta,char *almpt) {
  int i_f2py=0;
  f2py_area8_def[i_f2py++].data = wwm;
  f2py_area8_def[i_f2py++].data = be;
  f2py_area8_def[i_f2py++].data = dc;
  f2py_area8_def[i_f2py++].data = deta;
  f2py_area8_def[i_f2py++].data = almpt;
}
extern void F_FUNC(f2pyinitarea8,F2PYINITAREA8)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_area8(void) {
  F_FUNC(f2pyinitarea8,F2PYINITAREA8)(f2py_setup_area8);
}

static FortranDataDef f2py_hepevt_def[] = {
  {"nevhep",0,{{-1}},NPY_INT},
  {"nhep",0,{{-1}},NPY_INT},
  {"isthep",1,{{95000}},NPY_INT},
  {"idhep",1,{{95000}},NPY_INT},
  {"jmohep",2,{{2,95000}},NPY_INT},
  {"jdahep",2,{{2,95000}},NPY_INT},
  {"phep",2,{{5,95000}},NPY_DOUBLE},
  {"vhep",2,{{4,95000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepevt(char *nevhep,char *nhep,char *isthep,char *idhep,char *jmohep,char *jdahep,char *phep,char *vhep) {
  int i_f2py=0;
  f2py_hepevt_def[i_f2py++].data = nevhep;
  f2py_hepevt_def[i_f2py++].data = nhep;
  f2py_hepevt_def[i_f2py++].data = isthep;
  f2py_hepevt_def[i_f2py++].data = idhep;
  f2py_hepevt_def[i_f2py++].data = jmohep;
  f2py_hepevt_def[i_f2py++].data = jdahep;
  f2py_hepevt_def[i_f2py++].data = phep;
  f2py_hepevt_def[i_f2py++].data = vhep;
}
extern void F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepevt(void) {
  F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(f2py_setup_hepevt);
}

static FortranDataDef f2py_qgchg_def[] = {
  {"ichg",1,{{95000}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgchg(char *ichg) {
  int i_f2py=0;
  f2py_qgchg_def[i_f2py++].data = ichg;
}
extern void F_FUNC(f2pyinitqgchg,F2PYINITQGCHG)(void(*)(char*));
static void f2py_init_qgchg(void) {
  F_FUNC(f2pyinitqgchg,F2PYINITQGCHG)(f2py_setup_qgchg);
}

static FortranDataDef f2py_crqgslin_def[] = {
  {"ictabl",1,{{200}},NPY_INT},
  {"iqtabl",1,{{21}},NPY_INT},
  {NULL}
};
static void f2py_setup_crqgslin(char *ictabl,char *iqtabl) {
  int i_f2py=0;
  f2py_crqgslin_def[i_f2py++].data = ictabl;
  f2py_crqgslin_def[i_f2py++].data = iqtabl;
}
extern void F_FUNC(f2pyinitcrqgslin,F2PYINITCRQGSLIN)(void(*)(char*,char*));
static void f2py_init_crqgslin(void) {
  F_FUNC(f2pyinitcrqgslin,F2PYINITCRQGSLIN)(f2py_setup_crqgslin);
}

static FortranDataDef f2py_npy_def[] = {
  {"bitgen",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_npy(char *bitgen) {
  int i_f2py=0;
  f2py_npy_def[i_f2py++].data = bitgen;
}
extern void F_FUNC(f2pyinitnpy,F2PYINITNPY)(void(*)(char*));
static void f2py_init_npy(void) {
  F_FUNC(f2pyinitnpy,F2PYINITNPY)(f2py_setup_npy);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"psaini",-1,{{-1}},0,(char *)F_FUNC(psaini,PSAINI),(f2py_init_func)f2py_rout__qgs01_psaini,doc_f2py_rout__qgs01_psaini},
  {"psconf",-1,{{-1}},0,(char *)F_FUNC(psconf,PSCONF),(f2py_init_func)f2py_rout__qgs01_psconf,doc_f2py_rout__qgs01_psconf},
  {"xxaini",-1,{{-1}},0,(char *)F_FUNC(xxaini,XXAINI),(f2py_init_func)f2py_rout__qgs01_xxaini,doc_f2py_rout__qgs01_xxaini},
  {"xxreg",-1,{{-1}},0,(char *)F_FUNC(xxreg,XXREG),(f2py_init_func)f2py_rout__qgs01_xxreg,doc_f2py_rout__qgs01_xxreg},
  {"sectnu",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(sectnu,SECTNU),(f2py_init_func)f2py_rout__qgs01_sectnu,doc_f2py_rout__qgs01_sectnu},
  {"cqgsini",-1,{{-1}},0,(char *)F_FUNC(cqgsini,CQGSINI),(f2py_init_func)f2py_rout__qgs01_cqgsini,doc_f2py_rout__qgs01_cqgsini},
  {"chepevt",-1,{{-1}},0,(char *)F_FUNC(chepevt,CHEPEVT),(f2py_init_func)f2py_rout__qgs01_chepevt,doc_f2py_rout__qgs01_chepevt},
  {"chromo_openlogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE),(f2py_init_func)f2py_rout__qgs01_chromo_openlogfile,doc_f2py_rout__qgs01_chromo_openlogfile},
  {"chromo_closelogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE),(f2py_init_func)f2py_rout__qgs01_chromo_closelogfile,doc_f2py_rout__qgs01_chromo_closelogfile},
  {"npyrng",-1,{{-1}},0,(char *)F_FUNC(npyrng,NPYRNG),(f2py_init_func)f2py_rout__qgs01_npyrng,doc_f2py_rout__qgs01_npyrng},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_qgs01",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__qgs01(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = _qgs01_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _qgs01 (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module '_qgs01' is auto-generated with f2py (version:2).\nFunctions:\n"
"  psaini(datdir)\n"
"  psconf()\n"
"  xxaini(e0n,icp0,iap,iat)\n"
"  xxreg(ep0,ic)\n"
"  sectnu = sectnu(e0n,iap,iat)\n"
"  cqgsini(datdir,lun,debugnum)\n"
"  chepevt()\n"
"  chromo_openlogfile(fname,opunit)\n"
"  chromo_closelogfile(opunit)\n"
"  npyrng(rval)\n"
"COMMON blocks:\n""  /xsect/ gsect(10,5,4)\n""  /area1/ ia(2),icz,icp\n""  /area5/ rd(2),cr1(2),cr2(2),cr3(2)\n""  /area6/ pi,bm,am\n""  /area7/ rp1\n""  /area10/ stmass,am0,amn,amk,amc,amlamc,amlam,ameta\n""  /area15/ fp(5),rq(5),cd(5)\n""  /area16/ cc(5)\n""  /area17/ del,rs,rs0,fs,alfp,rr,sh,delh\n""  /area18/ alm,qt0,qlog,qll,aqt0,qtf,bet,amj0\n""  /area19/ ahl(5)\n""  /area22/ sjv0,fjs0(5,3)\n""  /area23/ rjv(50)\n""  /area24/ rjs(50,5,10)\n""  /area27/ fp0(5)\n""  /area28/ arr(4)\n""  /area29/ cstot(17,17,68)\n""  /area30/ cs0(17,17,68)\n""  /area31/ csborn(17,68)\n""  /area32/ csq(17,2,2),csbq(17,2,2)\n""  /area33/ fsud(10,2)\n""  /area34/ qrt(10,101,2)\n""  /area35/ sjv(10,5),fjs(10,5,15)\n""  /area39/ jcalc\n""  /area40/ jdifr\n""  /area41/ ty(5,7)\n""  /area43/ moniou\n""  /debug/ debug\n""  /area44/ gz(10,5,4),gzp(10,5,4)\n""  /ar1/ anorm\n""  /ar2/ rrr,rrrm\n""  /area48/ asect(10,6,4)\n""  /version/ version\n""  /area2/ s,y0,wp0,wm0\n""  /area9/ lqa(56),lqb(56),nqs(1000),ias(1000),ibs(1000),lha(56),lhb(56),zh(4000),iah(4000),ibh(4000),iqh(4000),lva(56),lvb(56)\n""  /area11/ b10\n""  /area12/ nsp\n""  /area45/ gdt,gdp\n""  /area99/ nwt\n""  /area4/ ey0(3)\n""  /area14/ esp(4,95000),ich(95000)\n""  /ar3/ x1(7),a1(7)\n""  /ar5/ x5(2),a5(2)\n""  /ar8/ x2(4),a2\n""  /ar9/ x9(3),a9(3)\n""  /area8/ wwm,be(4),dc(5),deta,almpt\n""  /hepevt/ nevhep,nhep,isthep(95000),idhep(95000),jmohep(2,95000),jdahep(2,95000),phep(5,95000),vhep(4,95000)\n""  /qgchg/ ichg(95000)\n""  /crqgslin/ ictabl(200),iqtabl(21)\n""  /npy/ bitgen\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _qgs01_error = PyErr_NewException ("_qgs01.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__qgs01_error", _qgs01_error);
  Py_DECREF(_qgs01_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }





    {
      extern double F_FUNC(sectnu,SECTNU)(void);
      PyObject* o = PyDict_GetItemString(d,"sectnu");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(sectnu,SECTNU),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("sectnu");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    





/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_xsect_def,f2py_init_xsect);
  F2PyDict_SetItemString(d, "xsect", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area1_def,f2py_init_area1);
  F2PyDict_SetItemString(d, "area1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area5_def,f2py_init_area5);
  F2PyDict_SetItemString(d, "area5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area6_def,f2py_init_area6);
  F2PyDict_SetItemString(d, "area6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area7_def,f2py_init_area7);
  F2PyDict_SetItemString(d, "area7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area10_def,f2py_init_area10);
  F2PyDict_SetItemString(d, "area10", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area15_def,f2py_init_area15);
  F2PyDict_SetItemString(d, "area15", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area16_def,f2py_init_area16);
  F2PyDict_SetItemString(d, "area16", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area17_def,f2py_init_area17);
  F2PyDict_SetItemString(d, "area17", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area18_def,f2py_init_area18);
  F2PyDict_SetItemString(d, "area18", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area19_def,f2py_init_area19);
  F2PyDict_SetItemString(d, "area19", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area22_def,f2py_init_area22);
  F2PyDict_SetItemString(d, "area22", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area23_def,f2py_init_area23);
  F2PyDict_SetItemString(d, "area23", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area24_def,f2py_init_area24);
  F2PyDict_SetItemString(d, "area24", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area27_def,f2py_init_area27);
  F2PyDict_SetItemString(d, "area27", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area28_def,f2py_init_area28);
  F2PyDict_SetItemString(d, "area28", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area29_def,f2py_init_area29);
  F2PyDict_SetItemString(d, "area29", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area30_def,f2py_init_area30);
  F2PyDict_SetItemString(d, "area30", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area31_def,f2py_init_area31);
  F2PyDict_SetItemString(d, "area31", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area32_def,f2py_init_area32);
  F2PyDict_SetItemString(d, "area32", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area33_def,f2py_init_area33);
  F2PyDict_SetItemString(d, "area33", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area34_def,f2py_init_area34);
  F2PyDict_SetItemString(d, "area34", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area35_def,f2py_init_area35);
  F2PyDict_SetItemString(d, "area35", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area39_def,f2py_init_area39);
  F2PyDict_SetItemString(d, "area39", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area40_def,f2py_init_area40);
  F2PyDict_SetItemString(d, "area40", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area41_def,f2py_init_area41);
  F2PyDict_SetItemString(d, "area41", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area43_def,f2py_init_area43);
  F2PyDict_SetItemString(d, "area43", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_debug_def,f2py_init_debug);
  F2PyDict_SetItemString(d, "debug", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area44_def,f2py_init_area44);
  F2PyDict_SetItemString(d, "area44", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ar1_def,f2py_init_ar1);
  F2PyDict_SetItemString(d, "ar1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ar2_def,f2py_init_ar2);
  F2PyDict_SetItemString(d, "ar2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area48_def,f2py_init_area48);
  F2PyDict_SetItemString(d, "area48", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_version_def,f2py_init_version);
  F2PyDict_SetItemString(d, "version", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area2_def,f2py_init_area2);
  F2PyDict_SetItemString(d, "area2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area9_def,f2py_init_area9);
  F2PyDict_SetItemString(d, "area9", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area11_def,f2py_init_area11);
  F2PyDict_SetItemString(d, "area11", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area12_def,f2py_init_area12);
  F2PyDict_SetItemString(d, "area12", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area45_def,f2py_init_area45);
  F2PyDict_SetItemString(d, "area45", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area99_def,f2py_init_area99);
  F2PyDict_SetItemString(d, "area99", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area4_def,f2py_init_area4);
  F2PyDict_SetItemString(d, "area4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area14_def,f2py_init_area14);
  F2PyDict_SetItemString(d, "area14", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ar3_def,f2py_init_ar3);
  F2PyDict_SetItemString(d, "ar3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ar5_def,f2py_init_ar5);
  F2PyDict_SetItemString(d, "ar5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ar8_def,f2py_init_ar8);
  F2PyDict_SetItemString(d, "ar8", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ar9_def,f2py_init_ar9);
  F2PyDict_SetItemString(d, "ar9", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area8_def,f2py_init_area8);
  F2PyDict_SetItemString(d, "area8", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepevt_def,f2py_init_hepevt);
  F2PyDict_SetItemString(d, "hepevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgchg_def,f2py_init_qgchg);
  F2PyDict_SetItemString(d, "qgchg", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_crqgslin_def,f2py_init_crqgslin);
  F2PyDict_SetItemString(d, "crqgslin", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_npy_def,f2py_init_npy);
  F2PyDict_SetItemString(d, "npy", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_qgs01");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
