/* File: _qgsII03module.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Mon Jan 16 17:30:55 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_qgsII03_error;
static PyObject *_qgsII03_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _qgsII03_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _qgsII03_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _qgsII03_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(qgini,QGINI)(double*,int*,int*,int*);
extern void F_FUNC(qgconf,QGCONF)(void);
extern void F_FUNC(qgreg,QGREG)(double*,int*);
extern void F_WRAPPEDFUNC(qgsect,QGSECT)(double*,double*,int*,int*,int*);
extern void F_FUNC(cqgsini,CQGSINI)(string,int*,int*,size_t);
extern void F_FUNC(chepevt,CHEPEVT)(void);
extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t);
extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*);
extern void F_FUNC(npyrng,NPYRNG)(double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** qgini ***********************************/
static char doc_f2py_rout__qgsII03_qgini[] = "\
qgini(e0n,icp0,iap,iat)\n\nWrapper for ``qgini``.\
\n\nParameters\n----------\n"
"e0n : input float\n"
"icp0 : input int\n"
"iap : input int\n"
"iat : input int";
/* extern void F_FUNC(qgini,QGINI)(double*,int*,int*,int*); */
static PyObject *f2py_rout__qgsII03_qgini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double e0n = 0;
  PyObject *e0n_capi = Py_None;
  int icp0 = 0;
  PyObject *icp0_capi = Py_None;
  int iap = 0;
  PyObject *iap_capi = Py_None;
  int iat = 0;
  PyObject *iat_capi = Py_None;
  static char *capi_kwlist[] = {"e0n","icp0","iap","iat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:_qgsII03.qgini",\
    capi_kwlist,&e0n_capi,&icp0_capi,&iap_capi,&iat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable e0n */
    f2py_success = double_from_pyobj(&e0n,e0n_capi,"_qgsII03.qgini() 1st argument (e0n) can't be converted to double");
  if (f2py_success) {
  /* Processing variable icp0 */
    f2py_success = int_from_pyobj(&icp0,icp0_capi,"_qgsII03.qgini() 2nd argument (icp0) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iap */
    f2py_success = int_from_pyobj(&iap,iap_capi,"_qgsII03.qgini() 3rd argument (iap) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iat */
    f2py_success = int_from_pyobj(&iat,iat_capi,"_qgsII03.qgini() 4th argument (iat) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&e0n,&icp0,&iap,&iat);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iat*/
  /* End of cleaning variable iat */
  } /*if (f2py_success) of iap*/
  /* End of cleaning variable iap */
  } /*if (f2py_success) of icp0*/
  /* End of cleaning variable icp0 */
  } /*if (f2py_success) of e0n*/
  /* End of cleaning variable e0n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of qgini ********************************/

/*********************************** qgconf ***********************************/
static char doc_f2py_rout__qgsII03_qgconf[] = "\
qgconf()\n\nWrapper for ``qgconf``.\
\n";
/* extern void F_FUNC(qgconf,QGCONF)(void); */
static PyObject *f2py_rout__qgsII03_qgconf(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_qgsII03.qgconf",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of qgconf *******************************/

/*********************************** qgreg ***********************************/
static char doc_f2py_rout__qgsII03_qgreg[] = "\
qgreg(ep0,ic)\n\nWrapper for ``qgreg``.\
\n\nParameters\n----------\n"
"ep0 : input rank-1 array('d') with bounds (4)\n"
"ic : input int";
/* extern void F_FUNC(qgreg,QGREG)(double*,int*); */
static PyObject *f2py_rout__qgsII03_qgreg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *ep0 = NULL;
  npy_intp ep0_Dims[1] = {-1};
  const int ep0_Rank = 1;
  PyArrayObject *capi_ep0_tmp = NULL;
  int capi_ep0_intent = 0;
  PyObject *ep0_capi = Py_None;
  int ic = 0;
  PyObject *ic_capi = Py_None;
  static char *capi_kwlist[] = {"ep0","ic",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_qgsII03.qgreg",\
    capi_kwlist,&ep0_capi,&ic_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ep0 */
  ep0_Dims[0]=4;
  capi_ep0_intent |= F2PY_INTENT_IN;
  capi_ep0_tmp = array_from_pyobj(NPY_DOUBLE,ep0_Dims,ep0_Rank,capi_ep0_intent,ep0_capi);
  if (capi_ep0_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _qgsII03_error,"failed in converting 1st argument `ep0' of _qgsII03.qgreg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ep0 = (double *)(PyArray_DATA(capi_ep0_tmp));

  /* Processing variable ic */
    f2py_success = int_from_pyobj(&ic,ic_capi,"_qgsII03.qgreg() 2nd argument (ic) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ep0,&ic);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ic*/
  /* End of cleaning variable ic */
  if((PyObject *)capi_ep0_tmp!=ep0_capi) {
    Py_XDECREF(capi_ep0_tmp); }
  }  /*if (capi_ep0_tmp == NULL) ... else of ep0*/
  /* End of cleaning variable ep0 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of qgreg ********************************/

/*********************************** qgsect ***********************************/
static char doc_f2py_rout__qgsII03_qgsect[] = "\
qgsect = qgsect(e0n,icz,iap,iat)\n\nWrapper for ``qgsect``.\
\n\nParameters\n----------\n"
"e0n : input float\n"
"icz : input int\n"
"iap : input int\n"
"iat : input int\n"
"\nReturns\n-------\n"
"qgsect : float";
/* extern void F_WRAPPEDFUNC(qgsect,QGSECT)(double*,double*,int*,int*,int*); */
static PyObject *f2py_rout__qgsII03_qgsect(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double qgsect = 0;
  double e0n = 0;
  PyObject *e0n_capi = Py_None;
  int icz = 0;
  PyObject *icz_capi = Py_None;
  int iap = 0;
  PyObject *iap_capi = Py_None;
  int iat = 0;
  PyObject *iat_capi = Py_None;
  static char *capi_kwlist[] = {"e0n","icz","iap","iat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:_qgsII03.qgsect",\
    capi_kwlist,&e0n_capi,&icz_capi,&iap_capi,&iat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable e0n */
    f2py_success = double_from_pyobj(&e0n,e0n_capi,"_qgsII03.qgsect() 1st argument (e0n) can't be converted to double");
  if (f2py_success) {
  /* Processing variable icz */
    f2py_success = int_from_pyobj(&icz,icz_capi,"_qgsII03.qgsect() 2nd argument (icz) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iap */
    f2py_success = int_from_pyobj(&iap,iap_capi,"_qgsII03.qgsect() 3rd argument (iap) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iat */
    f2py_success = int_from_pyobj(&iat,iat_capi,"_qgsII03.qgsect() 4th argument (iat) can't be converted to int");
  if (f2py_success) {
  /* Processing variable qgsect */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&qgsect,&e0n,&icz,&iap,&iat);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",qgsect);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable qgsect */
  } /*if (f2py_success) of iat*/
  /* End of cleaning variable iat */
  } /*if (f2py_success) of iap*/
  /* End of cleaning variable iap */
  } /*if (f2py_success) of icz*/
  /* End of cleaning variable icz */
  } /*if (f2py_success) of e0n*/
  /* End of cleaning variable e0n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of qgsect *******************************/

/********************************** cqgsini **********************************/
static char doc_f2py_rout__qgsII03_cqgsini[] = "\
cqgsini(datdir,lun,debugnum)\n\nWrapper for ``cqgsini``.\
\n\nParameters\n----------\n"
"datdir : input string(len=256)\n"
"lun : input int\n"
"debugnum : input int";
/* extern void F_FUNC(cqgsini,CQGSINI)(string,int*,int*,size_t); */
static PyObject *f2py_rout__qgsII03_cqgsini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string datdir = NULL;
  int slen(datdir);
  PyObject *datdir_capi = Py_None;
  int lun = 0;
  PyObject *lun_capi = Py_None;
  int debugnum = 0;
  PyObject *debugnum_capi = Py_None;
  static char *capi_kwlist[] = {"datdir","lun","debugnum",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_qgsII03.cqgsini",\
    capi_kwlist,&datdir_capi,&lun_capi,&debugnum_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable datdir */
  slen(datdir) = 256;
  f2py_success = string_from_pyobj(&datdir,&slen(datdir),"",datdir_capi,"string_from_pyobj failed in converting 1st argument `datdir' of _qgsII03.cqgsini to C string");
  if (f2py_success) {
  /* Processing variable lun */
    f2py_success = int_from_pyobj(&lun,lun_capi,"_qgsII03.cqgsini() 2nd argument (lun) can't be converted to int");
  if (f2py_success) {
  /* Processing variable debugnum */
    f2py_success = int_from_pyobj(&debugnum,debugnum_capi,"_qgsII03.cqgsini() 3rd argument (debugnum) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(datdir,&lun,&debugnum,slen(datdir));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of debugnum*/
  /* End of cleaning variable debugnum */
  } /*if (f2py_success) of lun*/
  /* End of cleaning variable lun */
    STRINGFREE(datdir);
  }  /*if (f2py_success) of datdir*/
  /* End of cleaning variable datdir */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of cqgsini *******************************/

/********************************** chepevt **********************************/
static char doc_f2py_rout__qgsII03_chepevt[] = "\
chepevt()\n\nWrapper for ``chepevt``.\
\n";
/* extern void F_FUNC(chepevt,CHEPEVT)(void); */
static PyObject *f2py_rout__qgsII03_chepevt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_qgsII03.chepevt",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of chepevt *******************************/

/***************************** chromo_openlogfile *****************************/
static char doc_f2py_rout__qgsII03_chromo_openlogfile[] = "\
chromo_openlogfile(fname,opunit)\n\nWrapper for ``chromo_openlogfile``.\
\n\nParameters\n----------\n"
"fname : input string(len=300)\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t); */
static PyObject *f2py_rout__qgsII03_chromo_openlogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string fname = NULL;
  int slen(fname);
  PyObject *fname_capi = Py_None;
  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"fname","opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_qgsII03.chromo_openlogfile",\
    capi_kwlist,&fname_capi,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fname */
  slen(fname) = 300;
  f2py_success = string_from_pyobj(&fname,&slen(fname),"",fname_capi,"string_from_pyobj failed in converting 1st argument `fname' of _qgsII03.chromo_openlogfile to C string");
  if (f2py_success) {
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_qgsII03.chromo_openlogfile() 2nd argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(fname,&opunit,slen(fname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
    STRINGFREE(fname);
  }  /*if (f2py_success) of fname*/
  /* End of cleaning variable fname */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_openlogfile *************************/

/**************************** chromo_closelogfile ****************************/
static char doc_f2py_rout__qgsII03_chromo_closelogfile[] = "\
chromo_closelogfile(opunit)\n\nWrapper for ``chromo_closelogfile``.\
\n\nParameters\n----------\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*); */
static PyObject *f2py_rout__qgsII03_chromo_closelogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_qgsII03.chromo_closelogfile",\
    capi_kwlist,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_qgsII03.chromo_closelogfile() 1st argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&opunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_closelogfile *************************/

/*********************************** npyrng ***********************************/
static char doc_f2py_rout__qgsII03_npyrng[] = "\
npyrng(rval)\n\nWrapper for ``npyrng``.\
\n\nParameters\n----------\n"
"rval : input float";
/* extern void F_FUNC(npyrng,NPYRNG)(double*); */
static PyObject *f2py_rout__qgsII03_npyrng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rval = 0;
  PyObject *rval_capi = Py_None;
  static char *capi_kwlist[] = {"rval",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_qgsII03.npyrng",\
    capi_kwlist,&rval_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rval */
    f2py_success = double_from_pyobj(&rval,rval_capi,"_qgsII03.npyrng() 1st argument (rval) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rval);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of rval*/
  /* End of cleaning variable rval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of npyrng *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_qgarr1_def[] = {
  {"ia",1,{{2}},NPY_INT},
  {"icz",0,{{-1}},NPY_INT},
  {"icp",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr1(char *ia,char *icz,char *icp) {
  int i_f2py=0;
  f2py_qgarr1_def[i_f2py++].data = ia;
  f2py_qgarr1_def[i_f2py++].data = icz;
  f2py_qgarr1_def[i_f2py++].data = icp;
}
extern void F_FUNC(f2pyinitqgarr1,F2PYINITQGARR1)(void(*)(char*,char*,char*));
static void f2py_init_qgarr1(void) {
  F_FUNC(f2pyinitqgarr1,F2PYINITQGARR1)(f2py_setup_qgarr1);
}

static FortranDataDef f2py_qgarr2_def[] = {
  {"scm",0,{{-1}},NPY_DOUBLE},
  {"wp0",0,{{-1}},NPY_DOUBLE},
  {"wm0",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr2(char *scm,char *wp0,char *wm0) {
  int i_f2py=0;
  f2py_qgarr2_def[i_f2py++].data = scm;
  f2py_qgarr2_def[i_f2py++].data = wp0;
  f2py_qgarr2_def[i_f2py++].data = wm0;
}
extern void F_FUNC(f2pyinitqgarr2,F2PYINITQGARR2)(void(*)(char*,char*,char*));
static void f2py_init_qgarr2(void) {
  F_FUNC(f2pyinitqgarr2,F2PYINITQGARR2)(f2py_setup_qgarr2);
}

static FortranDataDef f2py_qgarr4_def[] = {
  {"ey0",1,{{3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr4(char *ey0) {
  int i_f2py=0;
  f2py_qgarr4_def[i_f2py++].data = ey0;
}
extern void F_FUNC(f2pyinitqgarr4,F2PYINITQGARR4)(void(*)(char*));
static void f2py_init_qgarr4(void) {
  F_FUNC(f2pyinitqgarr4,F2PYINITQGARR4)(f2py_setup_qgarr4);
}

static FortranDataDef f2py_qgarr5_def[] = {
  {"rnuc",1,{{2}},NPY_DOUBLE},
  {"wsnuc",1,{{2}},NPY_DOUBLE},
  {"wbnuc",1,{{2}},NPY_DOUBLE},
  {"anorm",0,{{-1}},NPY_DOUBLE},
  {"cr1",1,{{2}},NPY_DOUBLE},
  {"cr2",1,{{2}},NPY_DOUBLE},
  {"cr3",1,{{2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr5(char *rnuc,char *wsnuc,char *wbnuc,char *anorm,char *cr1,char *cr2,char *cr3) {
  int i_f2py=0;
  f2py_qgarr5_def[i_f2py++].data = rnuc;
  f2py_qgarr5_def[i_f2py++].data = wsnuc;
  f2py_qgarr5_def[i_f2py++].data = wbnuc;
  f2py_qgarr5_def[i_f2py++].data = anorm;
  f2py_qgarr5_def[i_f2py++].data = cr1;
  f2py_qgarr5_def[i_f2py++].data = cr2;
  f2py_qgarr5_def[i_f2py++].data = cr3;
}
extern void F_FUNC(f2pyinitqgarr5,F2PYINITQGARR5)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_qgarr5(void) {
  F_FUNC(f2pyinitqgarr5,F2PYINITQGARR5)(f2py_setup_qgarr5);
}

static FortranDataDef f2py_qgarr6_def[] = {
  {"pi",0,{{-1}},NPY_DOUBLE},
  {"bm",0,{{-1}},NPY_DOUBLE},
  {"amws",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr6(char *pi,char *bm,char *amws) {
  int i_f2py=0;
  f2py_qgarr6_def[i_f2py++].data = pi;
  f2py_qgarr6_def[i_f2py++].data = bm;
  f2py_qgarr6_def[i_f2py++].data = amws;
}
extern void F_FUNC(f2pyinitqgarr6,F2PYINITQGARR6)(void(*)(char*,char*,char*));
static void f2py_init_qgarr6(void) {
  F_FUNC(f2pyinitqgarr6,F2PYINITQGARR6)(f2py_setup_qgarr6);
}

static FortranDataDef f2py_qgarr7_def[] = {
  {"xa",2,{{207,3}},NPY_DOUBLE},
  {"xb",2,{{207,3}},NPY_DOUBLE},
  {"b",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr7(char *xa,char *xb,char *b) {
  int i_f2py=0;
  f2py_qgarr7_def[i_f2py++].data = xa;
  f2py_qgarr7_def[i_f2py++].data = xb;
  f2py_qgarr7_def[i_f2py++].data = b;
}
extern void F_FUNC(f2pyinitqgarr7,F2PYINITQGARR7)(void(*)(char*,char*,char*));
static void f2py_init_qgarr7(void) {
  F_FUNC(f2pyinitqgarr7,F2PYINITQGARR7)(f2py_setup_qgarr7);
}

static FortranDataDef f2py_qgarr10_def[] = {
  {"am",1,{{7}},NPY_DOUBLE},
  {"ammu",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr10(char *am,char *ammu) {
  int i_f2py=0;
  f2py_qgarr10_def[i_f2py++].data = am;
  f2py_qgarr10_def[i_f2py++].data = ammu;
}
extern void F_FUNC(f2pyinitqgarr10,F2PYINITQGARR10)(void(*)(char*,char*));
static void f2py_init_qgarr10(void) {
  F_FUNC(f2pyinitqgarr10,F2PYINITQGARR10)(f2py_setup_qgarr10);
}

static FortranDataDef f2py_qgarr15_def[] = {
  {"fp",1,{{3}},NPY_DOUBLE},
  {"rq",1,{{3}},NPY_DOUBLE},
  {"cd",2,{{2,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr15(char *fp,char *rq,char *cd) {
  int i_f2py=0;
  f2py_qgarr15_def[i_f2py++].data = fp;
  f2py_qgarr15_def[i_f2py++].data = rq;
  f2py_qgarr15_def[i_f2py++].data = cd;
}
extern void F_FUNC(f2pyinitqgarr15,F2PYINITQGARR15)(void(*)(char*,char*,char*));
static void f2py_init_qgarr15(void) {
  F_FUNC(f2pyinitqgarr15,F2PYINITQGARR15)(f2py_setup_qgarr15);
}

static FortranDataDef f2py_qgarr17_def[] = {
  {"dels",0,{{-1}},NPY_DOUBLE},
  {"alfp",0,{{-1}},NPY_DOUBLE},
  {"sigs",0,{{-1}},NPY_DOUBLE},
  {"rr",0,{{-1}},NPY_DOUBLE},
  {"r3p",0,{{-1}},NPY_DOUBLE},
  {"g3p",0,{{-1}},NPY_DOUBLE},
  {"alpd",0,{{-1}},NPY_DOUBLE},
  {"delh",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr17(char *dels,char *alfp,char *sigs,char *rr,char *r3p,char *g3p,char *alpd,char *delh) {
  int i_f2py=0;
  f2py_qgarr17_def[i_f2py++].data = dels;
  f2py_qgarr17_def[i_f2py++].data = alfp;
  f2py_qgarr17_def[i_f2py++].data = sigs;
  f2py_qgarr17_def[i_f2py++].data = rr;
  f2py_qgarr17_def[i_f2py++].data = r3p;
  f2py_qgarr17_def[i_f2py++].data = g3p;
  f2py_qgarr17_def[i_f2py++].data = alpd;
  f2py_qgarr17_def[i_f2py++].data = delh;
}
extern void F_FUNC(f2pyinitqgarr17,F2PYINITQGARR17)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_qgarr17(void) {
  F_FUNC(f2pyinitqgarr17,F2PYINITQGARR17)(f2py_setup_qgarr17);
}

static FortranDataDef f2py_qgarr43_def[] = {
  {"moniou",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr43(char *moniou) {
  int i_f2py=0;
  f2py_qgarr43_def[i_f2py++].data = moniou;
}
extern void F_FUNC(f2pyinitqgarr43,F2PYINITQGARR43)(void(*)(char*));
static void f2py_init_qgarr43(void) {
  F_FUNC(f2pyinitqgarr43,F2PYINITQGARR43)(f2py_setup_qgarr43);
}

static FortranDataDef f2py_qgarr49_def[] = {
  {"trnuc",1,{{56}},NPY_DOUBLE},
  {"twsnuc",1,{{56}},NPY_DOUBLE},
  {"twbnuc",1,{{56}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr49(char *trnuc,char *twsnuc,char *twbnuc) {
  int i_f2py=0;
  f2py_qgarr49_def[i_f2py++].data = trnuc;
  f2py_qgarr49_def[i_f2py++].data = twsnuc;
  f2py_qgarr49_def[i_f2py++].data = twbnuc;
}
extern void F_FUNC(f2pyinitqgarr49,F2PYINITQGARR49)(void(*)(char*,char*,char*));
static void f2py_init_qgarr49(void) {
  F_FUNC(f2pyinitqgarr49,F2PYINITQGARR49)(f2py_setup_qgarr49);
}

static FortranDataDef f2py_debug_def[] = {
  {"debug",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_debug(char *debug) {
  int i_f2py=0;
  f2py_debug_def[i_f2py++].data = debug;
}
extern void F_FUNC(f2pyinitdebug,F2PYINITDEBUG)(void(*)(char*));
static void f2py_init_debug(void) {
  F_FUNC(f2pyinitdebug,F2PYINITDEBUG)(f2py_setup_debug);
}

static FortranDataDef f2py_qgarr9_def[] = {
  {"iwp",1,{{207}},NPY_INT},
  {"iwt",1,{{207}},NPY_INT},
  {"lqa",1,{{207}},NPY_INT},
  {"lqb",1,{{207}},NPY_INT},
  {"iprcn",1,{{207}},NPY_INT},
  {"itgcn",1,{{207}},NPY_INT},
  {"ias",1,{{1000}},NPY_INT},
  {"ibs",1,{{1000}},NPY_INT},
  {"nqs",1,{{1000}},NPY_INT},
  {"npompr",1,{{1000}},NPY_INT},
  {"npomtg",1,{{1000}},NPY_INT},
  {"npomin",1,{{1000}},NPY_INT},
  {"nnpr",2,{{5000,1000}},NPY_INT},
  {"nntg",2,{{5000,1000}},NPY_INT},
  {"ilpr",2,{{900,1000}},NPY_INT},
  {"iltg",2,{{900,1000}},NPY_INT},
  {"lnpr",2,{{900,1000}},NPY_INT},
  {"lntg",2,{{900,1000}},NPY_INT},
  {"nbpi",2,{{1000,207}},NPY_INT},
  {"nbti",2,{{1000,207}},NPY_INT},
  {"idnpi",2,{{1000,207}},NPY_INT},
  {"idnti",2,{{1000,207}},NPY_INT},
  {"nppi",2,{{1000,207}},NPY_INT},
  {"npti",2,{{1000,207}},NPY_INT},
  {"nlpi",2,{{1000,207}},NPY_INT},
  {"nlti",2,{{1000,207}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr9(char *iwp,char *iwt,char *lqa,char *lqb,char *iprcn,char *itgcn,char *ias,char *ibs,char *nqs,char *npompr,char *npomtg,char *npomin,char *nnpr,char *nntg,char *ilpr,char *iltg,char *lnpr,char *lntg,char *nbpi,char *nbti,char *idnpi,char *idnti,char *nppi,char *npti,char *nlpi,char *nlti) {
  int i_f2py=0;
  f2py_qgarr9_def[i_f2py++].data = iwp;
  f2py_qgarr9_def[i_f2py++].data = iwt;
  f2py_qgarr9_def[i_f2py++].data = lqa;
  f2py_qgarr9_def[i_f2py++].data = lqb;
  f2py_qgarr9_def[i_f2py++].data = iprcn;
  f2py_qgarr9_def[i_f2py++].data = itgcn;
  f2py_qgarr9_def[i_f2py++].data = ias;
  f2py_qgarr9_def[i_f2py++].data = ibs;
  f2py_qgarr9_def[i_f2py++].data = nqs;
  f2py_qgarr9_def[i_f2py++].data = npompr;
  f2py_qgarr9_def[i_f2py++].data = npomtg;
  f2py_qgarr9_def[i_f2py++].data = npomin;
  f2py_qgarr9_def[i_f2py++].data = nnpr;
  f2py_qgarr9_def[i_f2py++].data = nntg;
  f2py_qgarr9_def[i_f2py++].data = ilpr;
  f2py_qgarr9_def[i_f2py++].data = iltg;
  f2py_qgarr9_def[i_f2py++].data = lnpr;
  f2py_qgarr9_def[i_f2py++].data = lntg;
  f2py_qgarr9_def[i_f2py++].data = nbpi;
  f2py_qgarr9_def[i_f2py++].data = nbti;
  f2py_qgarr9_def[i_f2py++].data = idnpi;
  f2py_qgarr9_def[i_f2py++].data = idnti;
  f2py_qgarr9_def[i_f2py++].data = nppi;
  f2py_qgarr9_def[i_f2py++].data = npti;
  f2py_qgarr9_def[i_f2py++].data = nlpi;
  f2py_qgarr9_def[i_f2py++].data = nlti;
}
extern void F_FUNC(f2pyinitqgarr9,F2PYINITQGARR9)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_qgarr9(void) {
  F_FUNC(f2pyinitqgarr9,F2PYINITQGARR9)(f2py_setup_qgarr9);
}

static FortranDataDef f2py_qgarr11_def[] = {
  {"b10",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr11(char *b10) {
  int i_f2py=0;
  f2py_qgarr11_def[i_f2py++].data = b10;
}
extern void F_FUNC(f2pyinitqgarr11,F2PYINITQGARR11)(void(*)(char*));
static void f2py_init_qgarr11(void) {
  F_FUNC(f2pyinitqgarr11,F2PYINITQGARR11)(f2py_setup_qgarr11);
}

static FortranDataDef f2py_qgarr12_def[] = {
  {"nsp",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr12(char *nsp) {
  int i_f2py=0;
  f2py_qgarr12_def[i_f2py++].data = nsp;
}
extern void F_FUNC(f2pyinitqgarr12,F2PYINITQGARR12)(void(*)(char*));
static void f2py_init_qgarr12(void) {
  F_FUNC(f2pyinitqgarr12,F2PYINITQGARR12)(f2py_setup_qgarr12);
}

static FortranDataDef f2py_qgarr13_def[] = {
  {"nsf",0,{{-1}},NPY_INT},
  {"iaf",1,{{207}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr13(char *nsf,char *iaf) {
  int i_f2py=0;
  f2py_qgarr13_def[i_f2py++].data = nsf;
  f2py_qgarr13_def[i_f2py++].data = iaf;
}
extern void F_FUNC(f2pyinitqgarr13,F2PYINITQGARR13)(void(*)(char*,char*));
static void f2py_init_qgarr13(void) {
  F_FUNC(f2pyinitqgarr13,F2PYINITQGARR13)(f2py_setup_qgarr13);
}

static FortranDataDef f2py_qgarr16_def[] = {
  {"cc",2,{{2,3}},NPY_DOUBLE},
  {"iddp",1,{{207}},NPY_INT},
  {"iddt",1,{{207}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr16(char *cc,char *iddp,char *iddt) {
  int i_f2py=0;
  f2py_qgarr16_def[i_f2py++].data = cc;
  f2py_qgarr16_def[i_f2py++].data = iddp;
  f2py_qgarr16_def[i_f2py++].data = iddt;
}
extern void F_FUNC(f2pyinitqgarr16,F2PYINITQGARR16)(void(*)(char*,char*,char*));
static void f2py_init_qgarr16(void) {
  F_FUNC(f2pyinitqgarr16,F2PYINITQGARR16)(f2py_setup_qgarr16);
}

static FortranDataDef f2py_qgarr22_def[] = {
  {"wppr",1,{{207}},NPY_DOUBLE},
  {"wmtg",1,{{207}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr22(char *wppr,char *wmtg) {
  int i_f2py=0;
  f2py_qgarr22_def[i_f2py++].data = wppr;
  f2py_qgarr22_def[i_f2py++].data = wmtg;
}
extern void F_FUNC(f2pyinitqgarr22,F2PYINITQGARR22)(void(*)(char*,char*));
static void f2py_init_qgarr22(void) {
  F_FUNC(f2pyinitqgarr22,F2PYINITQGARR22)(f2py_setup_qgarr22);
}

static FortranDataDef f2py_qgarr23_def[] = {
  {"bbpom",1,{{1000}},NPY_DOUBLE},
  {"vvxpom",1,{{1000}},NPY_DOUBLE},
  {"bpompr",2,{{1000,207}},NPY_DOUBLE},
  {"bpomtg",2,{{1000,207}},NPY_DOUBLE},
  {"vvxpr",2,{{1000,207}},NPY_DOUBLE},
  {"vvxtg",2,{{1000,207}},NPY_DOUBLE},
  {"xpompr",2,{{1000,207}},NPY_DOUBLE},
  {"xpomtg",2,{{1000,207}},NPY_DOUBLE},
  {"xpopin",2,{{5000,1000}},NPY_DOUBLE},
  {"xpomin",2,{{5000,1000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr23(char *bbpom,char *vvxpom,char *bpompr,char *bpomtg,char *vvxpr,char *vvxtg,char *xpompr,char *xpomtg,char *xpopin,char *xpomin) {
  int i_f2py=0;
  f2py_qgarr23_def[i_f2py++].data = bbpom;
  f2py_qgarr23_def[i_f2py++].data = vvxpom;
  f2py_qgarr23_def[i_f2py++].data = bpompr;
  f2py_qgarr23_def[i_f2py++].data = bpomtg;
  f2py_qgarr23_def[i_f2py++].data = vvxpr;
  f2py_qgarr23_def[i_f2py++].data = vvxtg;
  f2py_qgarr23_def[i_f2py++].data = xpompr;
  f2py_qgarr23_def[i_f2py++].data = xpomtg;
  f2py_qgarr23_def[i_f2py++].data = xpopin;
  f2py_qgarr23_def[i_f2py++].data = xpomin;
}
extern void F_FUNC(f2pyinitqgarr23,F2PYINITQGARR23)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_qgarr23(void) {
  F_FUNC(f2pyinitqgarr23,F2PYINITQGARR23)(f2py_setup_qgarr23);
}

static FortranDataDef f2py_qgarr46_def[] = {
  {"iconab",2,{{207,207}},NPY_INT},
  {"icona",1,{{207}},NPY_INT},
  {"iconb",1,{{207}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr46(char *iconab,char *icona,char *iconb) {
  int i_f2py=0;
  f2py_qgarr46_def[i_f2py++].data = iconab;
  f2py_qgarr46_def[i_f2py++].data = icona;
  f2py_qgarr46_def[i_f2py++].data = iconb;
}
extern void F_FUNC(f2pyinitqgarr46,F2PYINITQGARR46)(void(*)(char*,char*,char*));
static void f2py_init_qgarr46(void) {
  F_FUNC(f2pyinitqgarr46,F2PYINITQGARR46)(f2py_setup_qgarr46);
}

static FortranDataDef f2py_qgarr55_def[] = {
  {"nwt",0,{{-1}},NPY_INT},
  {"nwp",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr55(char *nwt,char *nwp) {
  int i_f2py=0;
  f2py_qgarr55_def[i_f2py++].data = nwt;
  f2py_qgarr55_def[i_f2py++].data = nwp;
}
extern void F_FUNC(f2pyinitqgarr55,F2PYINITQGARR55)(void(*)(char*,char*));
static void f2py_init_qgarr55(void) {
  F_FUNC(f2pyinitqgarr55,F2PYINITQGARR55)(f2py_setup_qgarr55);
}

static FortranDataDef f2py_qgarr14_def[] = {
  {"esp",2,{{4,95000}},NPY_DOUBLE},
  {"ich",1,{{95000}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgarr14(char *esp,char *ich) {
  int i_f2py=0;
  f2py_qgarr14_def[i_f2py++].data = esp;
  f2py_qgarr14_def[i_f2py++].data = ich;
}
extern void F_FUNC(f2pyinitqgarr14,F2PYINITQGARR14)(void(*)(char*,char*));
static void f2py_init_qgarr14(void) {
  F_FUNC(f2pyinitqgarr14,F2PYINITQGARR14)(f2py_setup_qgarr14);
}

static FortranDataDef f2py_qgarr21_def[] = {
  {"dmmin",1,{{3}},NPY_DOUBLE},
  {"wex",1,{{3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr21(char *dmmin,char *wex) {
  int i_f2py=0;
  f2py_qgarr21_def[i_f2py++].data = dmmin;
  f2py_qgarr21_def[i_f2py++].data = wex;
}
extern void F_FUNC(f2pyinitqgarr21,F2PYINITQGARR21)(void(*)(char*,char*));
static void f2py_init_qgarr21(void) {
  F_FUNC(f2pyinitqgarr21,F2PYINITQGARR21)(f2py_setup_qgarr21);
}

static FortranDataDef f2py_qgarr47_def[] = {
  {"gsect",3,{{10,5,6}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr47(char *gsect) {
  int i_f2py=0;
  f2py_qgarr47_def[i_f2py++].data = gsect;
}
extern void F_FUNC(f2pyinitqgarr47,F2PYINITQGARR47)(void(*)(char*));
static void f2py_init_qgarr47(void) {
  F_FUNC(f2pyinitqgarr47,F2PYINITQGARR47)(f2py_setup_qgarr47);
}

static FortranDataDef f2py_qgarr48_def[] = {
  {"asect",3,{{10,6,6}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr48(char *asect) {
  int i_f2py=0;
  f2py_qgarr48_def[i_f2py++].data = asect;
}
extern void F_FUNC(f2pyinitqgarr48,F2PYINITQGARR48)(void(*)(char*));
static void f2py_init_qgarr48(void) {
  F_FUNC(f2pyinitqgarr48,F2PYINITQGARR48)(f2py_setup_qgarr48);
}

static FortranDataDef f2py_qgarr50_def[] = {
  {"x1",1,{{7}},NPY_DOUBLE},
  {"a1",1,{{7}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr50(char *x1,char *a1) {
  int i_f2py=0;
  f2py_qgarr50_def[i_f2py++].data = x1;
  f2py_qgarr50_def[i_f2py++].data = a1;
}
extern void F_FUNC(f2pyinitqgarr50,F2PYINITQGARR50)(void(*)(char*,char*));
static void f2py_init_qgarr50(void) {
  F_FUNC(f2pyinitqgarr50,F2PYINITQGARR50)(f2py_setup_qgarr50);
}

static FortranDataDef f2py_qgarr51_def[] = {
  {"x4",1,{{2}},NPY_DOUBLE},
  {"a4",1,{{2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr51(char *x4,char *a4) {
  int i_f2py=0;
  f2py_qgarr51_def[i_f2py++].data = x4;
  f2py_qgarr51_def[i_f2py++].data = a4;
}
extern void F_FUNC(f2pyinitqgarr51,F2PYINITQGARR51)(void(*)(char*,char*));
static void f2py_init_qgarr51(void) {
  F_FUNC(f2pyinitqgarr51,F2PYINITQGARR51)(f2py_setup_qgarr51);
}

static FortranDataDef f2py_qgarr52_def[] = {
  {"x2",1,{{4}},NPY_DOUBLE},
  {"a2",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr52(char *x2,char *a2) {
  int i_f2py=0;
  f2py_qgarr52_def[i_f2py++].data = x2;
  f2py_qgarr52_def[i_f2py++].data = a2;
}
extern void F_FUNC(f2pyinitqgarr52,F2PYINITQGARR52)(void(*)(char*,char*));
static void f2py_init_qgarr52(void) {
  F_FUNC(f2pyinitqgarr52,F2PYINITQGARR52)(f2py_setup_qgarr52);
}

static FortranDataDef f2py_qgarr53_def[] = {
  {"x9",1,{{3}},NPY_DOUBLE},
  {"a9",1,{{3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_qgarr53(char *x9,char *a9) {
  int i_f2py=0;
  f2py_qgarr53_def[i_f2py++].data = x9;
  f2py_qgarr53_def[i_f2py++].data = a9;
}
extern void F_FUNC(f2pyinitqgarr53,F2PYINITQGARR53)(void(*)(char*,char*));
static void f2py_init_qgarr53(void) {
  F_FUNC(f2pyinitqgarr53,F2PYINITQGARR53)(f2py_setup_qgarr53);
}

static FortranDataDef f2py_area40_def[] = {
  {"jdifr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_area40(char *jdifr) {
  int i_f2py=0;
  f2py_area40_def[i_f2py++].data = jdifr;
}
extern void F_FUNC(f2pyinitarea40,F2PYINITAREA40)(void(*)(char*));
static void f2py_init_area40(void) {
  F_FUNC(f2pyinitarea40,F2PYINITAREA40)(f2py_setup_area40);
}

static FortranDataDef f2py_qgdebug_def[] = {
  {"debug",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgdebug(char *debug) {
  int i_f2py=0;
  f2py_qgdebug_def[i_f2py++].data = debug;
}
extern void F_FUNC(f2pyinitqgdebug,F2PYINITQGDEBUG)(void(*)(char*));
static void f2py_init_qgdebug(void) {
  F_FUNC(f2pyinitqgdebug,F2PYINITQGDEBUG)(f2py_setup_qgdebug);
}

static FortranDataDef f2py_hepevt_def[] = {
  {"nevhep",0,{{-1}},NPY_INT},
  {"nhep",0,{{-1}},NPY_INT},
  {"isthep",1,{{95000}},NPY_INT},
  {"idhep",1,{{95000}},NPY_INT},
  {"jmohep",2,{{2,95000}},NPY_INT},
  {"jdahep",2,{{2,95000}},NPY_INT},
  {"phep",2,{{5,95000}},NPY_DOUBLE},
  {"vhep",2,{{4,95000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepevt(char *nevhep,char *nhep,char *isthep,char *idhep,char *jmohep,char *jdahep,char *phep,char *vhep) {
  int i_f2py=0;
  f2py_hepevt_def[i_f2py++].data = nevhep;
  f2py_hepevt_def[i_f2py++].data = nhep;
  f2py_hepevt_def[i_f2py++].data = isthep;
  f2py_hepevt_def[i_f2py++].data = idhep;
  f2py_hepevt_def[i_f2py++].data = jmohep;
  f2py_hepevt_def[i_f2py++].data = jdahep;
  f2py_hepevt_def[i_f2py++].data = phep;
  f2py_hepevt_def[i_f2py++].data = vhep;
}
extern void F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepevt(void) {
  F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(f2py_setup_hepevt);
}

static FortranDataDef f2py_qgchg_def[] = {
  {"ichg",1,{{95000}},NPY_INT},
  {NULL}
};
static void f2py_setup_qgchg(char *ichg) {
  int i_f2py=0;
  f2py_qgchg_def[i_f2py++].data = ichg;
}
extern void F_FUNC(f2pyinitqgchg,F2PYINITQGCHG)(void(*)(char*));
static void f2py_init_qgchg(void) {
  F_FUNC(f2pyinitqgchg,F2PYINITQGCHG)(f2py_setup_qgchg);
}

static FortranDataDef f2py_crqgslin_def[] = {
  {"ictabl",1,{{200}},NPY_INT},
  {"iqtabl",1,{{21}},NPY_INT},
  {NULL}
};
static void f2py_setup_crqgslin(char *ictabl,char *iqtabl) {
  int i_f2py=0;
  f2py_crqgslin_def[i_f2py++].data = ictabl;
  f2py_crqgslin_def[i_f2py++].data = iqtabl;
}
extern void F_FUNC(f2pyinitcrqgslin,F2PYINITCRQGSLIN)(void(*)(char*,char*));
static void f2py_init_crqgslin(void) {
  F_FUNC(f2pyinitcrqgslin,F2PYINITCRQGSLIN)(f2py_setup_crqgslin);
}

static FortranDataDef f2py_npy_def[] = {
  {"bitgen",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_npy(char *bitgen) {
  int i_f2py=0;
  f2py_npy_def[i_f2py++].data = bitgen;
}
extern void F_FUNC(f2pyinitnpy,F2PYINITNPY)(void(*)(char*));
static void f2py_init_npy(void) {
  F_FUNC(f2pyinitnpy,F2PYINITNPY)(f2py_setup_npy);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"qgini",-1,{{-1}},0,(char *)F_FUNC(qgini,QGINI),(f2py_init_func)f2py_rout__qgsII03_qgini,doc_f2py_rout__qgsII03_qgini},
  {"qgconf",-1,{{-1}},0,(char *)F_FUNC(qgconf,QGCONF),(f2py_init_func)f2py_rout__qgsII03_qgconf,doc_f2py_rout__qgsII03_qgconf},
  {"qgreg",-1,{{-1}},0,(char *)F_FUNC(qgreg,QGREG),(f2py_init_func)f2py_rout__qgsII03_qgreg,doc_f2py_rout__qgsII03_qgreg},
  {"qgsect",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(qgsect,QGSECT),(f2py_init_func)f2py_rout__qgsII03_qgsect,doc_f2py_rout__qgsII03_qgsect},
  {"cqgsini",-1,{{-1}},0,(char *)F_FUNC(cqgsini,CQGSINI),(f2py_init_func)f2py_rout__qgsII03_cqgsini,doc_f2py_rout__qgsII03_cqgsini},
  {"chepevt",-1,{{-1}},0,(char *)F_FUNC(chepevt,CHEPEVT),(f2py_init_func)f2py_rout__qgsII03_chepevt,doc_f2py_rout__qgsII03_chepevt},
  {"chromo_openlogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE),(f2py_init_func)f2py_rout__qgsII03_chromo_openlogfile,doc_f2py_rout__qgsII03_chromo_openlogfile},
  {"chromo_closelogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE),(f2py_init_func)f2py_rout__qgsII03_chromo_closelogfile,doc_f2py_rout__qgsII03_chromo_closelogfile},
  {"npyrng",-1,{{-1}},0,(char *)F_FUNC(npyrng,NPYRNG),(f2py_init_func)f2py_rout__qgsII03_npyrng,doc_f2py_rout__qgsII03_npyrng},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_qgsII03",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__qgsII03(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = _qgsII03_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _qgsII03 (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module '_qgsII03' is auto-generated with f2py (version:2).\nFunctions:\n"
"  qgini(e0n,icp0,iap,iat)\n"
"  qgconf()\n"
"  qgreg(ep0,ic)\n"
"  qgsect = qgsect(e0n,icz,iap,iat)\n"
"  cqgsini(datdir,lun,debugnum)\n"
"  chepevt()\n"
"  chromo_openlogfile(fname,opunit)\n"
"  chromo_closelogfile(opunit)\n"
"  npyrng(rval)\n"
"COMMON blocks:\n""  /qgarr1/ ia(2),icz,icp\n""  /qgarr2/ scm,wp0,wm0\n""  /qgarr4/ ey0(3)\n""  /qgarr5/ rnuc(2),wsnuc(2),wbnuc(2),anorm,cr1(2),cr2(2),cr3(2)\n""  /qgarr6/ pi,bm,amws\n""  /qgarr7/ xa(207,3),xb(207,3),b\n""  /qgarr10/ am(7),ammu\n""  /qgarr15/ fp(3),rq(3),cd(2,3)\n""  /qgarr17/ dels,alfp,sigs,rr,r3p,g3p,alpd,delh\n""  /qgarr43/ moniou\n""  /qgarr49/ trnuc(56),twsnuc(56),twbnuc(56)\n""  /debug/ debug\n""  /qgarr9/ iwp(207),iwt(207),lqa(207),lqb(207),iprcn(207),itgcn(207),ias(1000),ibs(1000),nqs(1000),npompr(1000),npomtg(1000),npomin(1000),nnpr(5000,1000),nntg(5000,1000),ilpr(900,1000),iltg(900,1000),lnpr(900,1000),lntg(900,1000),nbpi(1000,207),nbti(1000,207),idnpi(1000,207),idnti(1000,207),nppi(1000,207),npti(1000,207),nlpi(1000,207),nlti(1000,207)\n""  /qgarr11/ b10\n""  /qgarr12/ nsp\n""  /qgarr13/ nsf,iaf(207)\n""  /qgarr16/ cc(2,3),iddp(207),iddt(207)\n""  /qgarr22/ wppr(207),wmtg(207)\n""  /qgarr23/ bbpom(1000),vvxpom(1000),bpompr(1000,207),bpomtg(1000,207),vvxpr(1000,207),vvxtg(1000,207),xpompr(1000,207),xpomtg(1000,207),xpopin(5000,1000),xpomin(5000,1000)\n""  /qgarr46/ iconab(207,207),icona(207),iconb(207)\n""  /qgarr55/ nwt,nwp\n""  /qgarr14/ esp(4,95000),ich(95000)\n""  /qgarr21/ dmmin(3),wex(3)\n""  /qgarr47/ gsect(10,5,6)\n""  /qgarr48/ asect(10,6,6)\n""  /qgarr50/ x1(7),a1(7)\n""  /qgarr51/ x4(2),a4(2)\n""  /qgarr52/ x2(4),a2\n""  /qgarr53/ x9(3),a9(3)\n""  /area40/ jdifr\n""  /qgdebug/ debug\n""  /hepevt/ nevhep,nhep,isthep(95000),idhep(95000),jmohep(2,95000),jdahep(2,95000),phep(5,95000),vhep(4,95000)\n""  /qgchg/ ichg(95000)\n""  /crqgslin/ ictabl(200),iqtabl(21)\n""  /npy/ bitgen\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _qgsII03_error = PyErr_NewException ("_qgsII03.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__qgsII03_error", _qgsII03_error);
  Py_DECREF(_qgsII03_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }




    {
      extern double F_FUNC(qgsect,QGSECT)(void);
      PyObject* o = PyDict_GetItemString(d,"qgsect");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(qgsect,QGSECT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("qgsect");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    





/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_qgarr1_def,f2py_init_qgarr1);
  F2PyDict_SetItemString(d, "qgarr1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr2_def,f2py_init_qgarr2);
  F2PyDict_SetItemString(d, "qgarr2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr4_def,f2py_init_qgarr4);
  F2PyDict_SetItemString(d, "qgarr4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr5_def,f2py_init_qgarr5);
  F2PyDict_SetItemString(d, "qgarr5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr6_def,f2py_init_qgarr6);
  F2PyDict_SetItemString(d, "qgarr6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr7_def,f2py_init_qgarr7);
  F2PyDict_SetItemString(d, "qgarr7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr10_def,f2py_init_qgarr10);
  F2PyDict_SetItemString(d, "qgarr10", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr15_def,f2py_init_qgarr15);
  F2PyDict_SetItemString(d, "qgarr15", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr17_def,f2py_init_qgarr17);
  F2PyDict_SetItemString(d, "qgarr17", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr43_def,f2py_init_qgarr43);
  F2PyDict_SetItemString(d, "qgarr43", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr49_def,f2py_init_qgarr49);
  F2PyDict_SetItemString(d, "qgarr49", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_debug_def,f2py_init_debug);
  F2PyDict_SetItemString(d, "debug", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr9_def,f2py_init_qgarr9);
  F2PyDict_SetItemString(d, "qgarr9", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr11_def,f2py_init_qgarr11);
  F2PyDict_SetItemString(d, "qgarr11", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr12_def,f2py_init_qgarr12);
  F2PyDict_SetItemString(d, "qgarr12", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr13_def,f2py_init_qgarr13);
  F2PyDict_SetItemString(d, "qgarr13", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr16_def,f2py_init_qgarr16);
  F2PyDict_SetItemString(d, "qgarr16", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr22_def,f2py_init_qgarr22);
  F2PyDict_SetItemString(d, "qgarr22", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr23_def,f2py_init_qgarr23);
  F2PyDict_SetItemString(d, "qgarr23", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr46_def,f2py_init_qgarr46);
  F2PyDict_SetItemString(d, "qgarr46", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr55_def,f2py_init_qgarr55);
  F2PyDict_SetItemString(d, "qgarr55", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr14_def,f2py_init_qgarr14);
  F2PyDict_SetItemString(d, "qgarr14", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr21_def,f2py_init_qgarr21);
  F2PyDict_SetItemString(d, "qgarr21", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr47_def,f2py_init_qgarr47);
  F2PyDict_SetItemString(d, "qgarr47", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr48_def,f2py_init_qgarr48);
  F2PyDict_SetItemString(d, "qgarr48", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr50_def,f2py_init_qgarr50);
  F2PyDict_SetItemString(d, "qgarr50", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr51_def,f2py_init_qgarr51);
  F2PyDict_SetItemString(d, "qgarr51", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr52_def,f2py_init_qgarr52);
  F2PyDict_SetItemString(d, "qgarr52", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgarr53_def,f2py_init_qgarr53);
  F2PyDict_SetItemString(d, "qgarr53", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_area40_def,f2py_init_area40);
  F2PyDict_SetItemString(d, "area40", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgdebug_def,f2py_init_qgdebug);
  F2PyDict_SetItemString(d, "qgdebug", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepevt_def,f2py_init_hepevt);
  F2PyDict_SetItemString(d, "hepevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_qgchg_def,f2py_init_qgchg);
  F2PyDict_SetItemString(d, "qgchg", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_crqgslin_def,f2py_init_crqgslin);
  F2PyDict_SetItemString(d, "crqgslin", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_npy_def,f2py_init_npy);
  F2PyDict_SetItemString(d, "npy", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_qgsII03");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
