/* File: _sib21module.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Mon Jan 16 17:30:40 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_sib21_error;
static PyObject *_sib21_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _sib21_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _sib21_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int float_from_pyobj(float* v,PyObject *obj,const char *errmess) {
    double d=0.0;
    if (double_from_pyobj(&d,obj,errmess)) {
        *v = (float)d;
        return 1;
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _sib21_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(sibyll,SIBYLL)(int*,int*,float*);
extern void F_FUNC_US(sib_list,SIB_LIST)(void);
extern void F_FUNC_US(sibyll_ini,SIBYLL_INI)(void);
extern void F_FUNC_US(sib_sigma_hp,SIB_SIGMA_HP)(int*,float*,float*,float*,float*,float*,float*,float*);
extern void F_FUNC_US(sib_sigma_hair,SIB_SIGMA_HAIR)(int*,float*,float*);
extern void F_FUNC(decsib,DECSIB)(void);
extern void F_FUNC(decpar,DECPAR)(int*,float*,int*,int*,float*);
extern void F_FUNC_US(int_nuc,INT_NUC)(int*,int*,float*,float*);
extern void F_FUNC_US(pdg_ini,PDG_INI)(void);
extern void F_WRAPPEDFUNC_US(isib_pdg2pid,ISIB_PDG2PID)(int*,int*);
extern void F_WRAPPEDFUNC_US(isib_pid2pdg,ISIB_PID2PDG)(int*,int*);
extern void F_FUNC(sibini,SIBINI)(void);
extern void F_FUNC(sibhep,SIBHEP)(void);
extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t);
extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*);
extern void F_FUNC(npyrng,NPYRNG)(double*);
extern void F_WRAPPEDFUNC(spgasdev,SPGASDEV)(float*,int*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** sibyll ***********************************/
static char doc_f2py_rout__sib21_sibyll[] = "\
sibyll(k_beam,iatarg,ecm)\n\nWrapper for ``sibyll``.\
\n\nParameters\n----------\n"
"k_beam : input int\n"
"iatarg : input int\n"
"ecm : input float";
/* extern void F_FUNC(sibyll,SIBYLL)(int*,int*,float*); */
static PyObject *f2py_rout__sib21_sibyll(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,float*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int k_beam = 0;
  PyObject *k_beam_capi = Py_None;
  int iatarg = 0;
  PyObject *iatarg_capi = Py_None;
  float ecm = 0;
  PyObject *ecm_capi = Py_None;
  static char *capi_kwlist[] = {"k_beam","iatarg","ecm",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_sib21.sibyll",\
    capi_kwlist,&k_beam_capi,&iatarg_capi,&ecm_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable k_beam */
    f2py_success = int_from_pyobj(&k_beam,k_beam_capi,"_sib21.sibyll() 1st argument (k_beam) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iatarg */
    f2py_success = int_from_pyobj(&iatarg,iatarg_capi,"_sib21.sibyll() 2nd argument (iatarg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ecm */
    f2py_success = float_from_pyobj(&ecm,ecm_capi,"_sib21.sibyll() 3rd argument (ecm) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&k_beam,&iatarg,&ecm);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ecm*/
  /* End of cleaning variable ecm */
  } /*if (f2py_success) of iatarg*/
  /* End of cleaning variable iatarg */
  } /*if (f2py_success) of k_beam*/
  /* End of cleaning variable k_beam */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of sibyll *******************************/

/********************************** sib_list **********************************/
static char doc_f2py_rout__sib21_sib_list[] = "\
sib_list()\n\nWrapper for ``sib_list``.\
\n";
/* extern void F_FUNC_US(sib_list,SIB_LIST)(void); */
static PyObject *f2py_rout__sib21_sib_list(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_sib21.sib_list",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of sib_list ******************************/

/********************************* sibyll_ini *********************************/
static char doc_f2py_rout__sib21_sibyll_ini[] = "\
sibyll_ini()\n\nWrapper for ``sibyll_ini``.\
\n";
/* extern void F_FUNC_US(sibyll_ini,SIBYLL_INI)(void); */
static PyObject *f2py_rout__sib21_sibyll_ini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_sib21.sibyll_ini",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of sibyll_ini *****************************/

/******************************** sib_sigma_hp ********************************/
static char doc_f2py_rout__sib21_sib_sigma_hp[] = "\
sigt,sigel,siginel,sigdif,slope,rho = sib_sigma_hp(l,sqs)\n\nWrapper for ``sib_sigma_hp``.\
\n\nParameters\n----------\n"
"l : input int\n"
"sqs : input float\n"
"\nReturns\n-------\n"
"sigt : float\n"
"sigel : float\n"
"siginel : float\n"
"sigdif : rank-1 array('f') with bounds (3)\n"
"slope : float\n"
"rho : float";
/* extern void F_FUNC_US(sib_sigma_hp,SIB_SIGMA_HP)(int*,float*,float*,float*,float*,float*,float*,float*); */
static PyObject *f2py_rout__sib21_sib_sigma_hp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,float*,float*,float*,float*,float*,float*,float*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int l = 0;
  PyObject *l_capi = Py_None;
  float sqs = 0;
  PyObject *sqs_capi = Py_None;
  float sigt = 0;
  float sigel = 0;
  float siginel = 0;
  float *sigdif = NULL;
  npy_intp sigdif_Dims[1] = {-1};
  const int sigdif_Rank = 1;
  PyArrayObject *capi_sigdif_tmp = NULL;
  int capi_sigdif_intent = 0;
  float slope = 0;
  float rho = 0;
  static char *capi_kwlist[] = {"l","sqs",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_sib21.sib_sigma_hp",\
    capi_kwlist,&l_capi,&sqs_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"_sib21.sib_sigma_hp() 1st argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sqs */
    f2py_success = float_from_pyobj(&sqs,sqs_capi,"_sib21.sib_sigma_hp() 2nd argument (sqs) can't be converted to float");
  if (f2py_success) {
  /* Processing variable sigt */
  /* Processing variable sigel */
  /* Processing variable siginel */
  /* Processing variable sigdif */
  sigdif_Dims[0]=3;
  capi_sigdif_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_sigdif_tmp = array_from_pyobj(NPY_FLOAT,sigdif_Dims,sigdif_Rank,capi_sigdif_intent,Py_None);
  if (capi_sigdif_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _sib21_error,"failed in converting hidden `sigdif' of _sib21.sib_sigma_hp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sigdif = (float *)(PyArray_DATA(capi_sigdif_tmp));

  /* Processing variable slope */
  /* Processing variable rho */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&l,&sqs,&sigt,&sigel,&siginel,sigdif,&slope,&rho);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("fffNff",sigt,sigel,siginel,capi_sigdif_tmp,slope,rho);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable rho */
  /* End of cleaning variable slope */
  }  /*if (capi_sigdif_tmp == NULL) ... else of sigdif*/
  /* End of cleaning variable sigdif */
  /* End of cleaning variable siginel */
  /* End of cleaning variable sigel */
  /* End of cleaning variable sigt */
  } /*if (f2py_success) of sqs*/
  /* End of cleaning variable sqs */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of sib_sigma_hp ****************************/

/******************************* sib_sigma_hair *******************************/
static char doc_f2py_rout__sib21_sib_sigma_hair[] = "\
sigprod = sib_sigma_hair(l,sqs)\n\nWrapper for ``sib_sigma_hair``.\
\n\nParameters\n----------\n"
"l : input int\n"
"sqs : input float\n"
"\nReturns\n-------\n"
"sigprod : float";
/* extern void F_FUNC_US(sib_sigma_hair,SIB_SIGMA_HAIR)(int*,float*,float*); */
static PyObject *f2py_rout__sib21_sib_sigma_hair(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,float*,float*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int l = 0;
  PyObject *l_capi = Py_None;
  float sqs = 0;
  PyObject *sqs_capi = Py_None;
  float sigprod = 0;
  static char *capi_kwlist[] = {"l","sqs",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_sib21.sib_sigma_hair",\
    capi_kwlist,&l_capi,&sqs_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"_sib21.sib_sigma_hair() 1st argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sqs */
    f2py_success = float_from_pyobj(&sqs,sqs_capi,"_sib21.sib_sigma_hair() 2nd argument (sqs) can't be converted to float");
  if (f2py_success) {
  /* Processing variable sigprod */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&l,&sqs,&sigprod);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("f",sigprod);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable sigprod */
  } /*if (f2py_success) of sqs*/
  /* End of cleaning variable sqs */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*************************** end of sib_sigma_hair ***************************/

/*********************************** decsib ***********************************/
static char doc_f2py_rout__sib21_decsib[] = "\
decsib()\n\nWrapper for ``decsib``.\
\n";
/* extern void F_FUNC(decsib,DECSIB)(void); */
static PyObject *f2py_rout__sib21_decsib(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_sib21.decsib",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of decsib *******************************/

/*********************************** decpar ***********************************/
static char doc_f2py_rout__sib21_decpar[] = "\
decpar(la,p0,nd,ll,p)\n\nWrapper for ``decpar``.\
\n\nParameters\n----------\n"
"la : input int\n"
"p0 : input rank-1 array('f') with bounds (5)\n"
"nd : input int\n"
"ll : input rank-1 array('i') with bounds (10)\n"
"p : input rank-2 array('f') with bounds (10,5)";
/* extern void F_FUNC(decpar,DECPAR)(int*,float*,int*,int*,float*); */
static PyObject *f2py_rout__sib21_decpar(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,float*,int*,int*,float*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int la = 0;
  PyObject *la_capi = Py_None;
  float *p0 = NULL;
  npy_intp p0_Dims[1] = {-1};
  const int p0_Rank = 1;
  PyArrayObject *capi_p0_tmp = NULL;
  int capi_p0_intent = 0;
  PyObject *p0_capi = Py_None;
  int nd = 0;
  PyObject *nd_capi = Py_None;
  int *ll = NULL;
  npy_intp ll_Dims[1] = {-1};
  const int ll_Rank = 1;
  PyArrayObject *capi_ll_tmp = NULL;
  int capi_ll_intent = 0;
  PyObject *ll_capi = Py_None;
  float *p = NULL;
  npy_intp p_Dims[2] = {-1, -1};
  const int p_Rank = 2;
  PyArrayObject *capi_p_tmp = NULL;
  int capi_p_intent = 0;
  PyObject *p_capi = Py_None;
  static char *capi_kwlist[] = {"la","p0","nd","ll","p",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|:_sib21.decpar",\
    capi_kwlist,&la_capi,&p0_capi,&nd_capi,&ll_capi,&p_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable la */
    f2py_success = int_from_pyobj(&la,la_capi,"_sib21.decpar() 1st argument (la) can't be converted to int");
  if (f2py_success) {
  /* Processing variable p0 */
  p0_Dims[0]=5;
  capi_p0_intent |= F2PY_INTENT_IN;
  capi_p0_tmp = array_from_pyobj(NPY_FLOAT,p0_Dims,p0_Rank,capi_p0_intent,p0_capi);
  if (capi_p0_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _sib21_error,"failed in converting 2nd argument `p0' of _sib21.decpar to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    p0 = (float *)(PyArray_DATA(capi_p0_tmp));

  /* Processing variable nd */
    f2py_success = int_from_pyobj(&nd,nd_capi,"_sib21.decpar() 3rd argument (nd) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ll */
  ll_Dims[0]=10;
  capi_ll_intent |= F2PY_INTENT_IN;
  capi_ll_tmp = array_from_pyobj(NPY_INT,ll_Dims,ll_Rank,capi_ll_intent,ll_capi);
  if (capi_ll_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _sib21_error,"failed in converting 4th argument `ll' of _sib21.decpar to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ll = (int *)(PyArray_DATA(capi_ll_tmp));

  /* Processing variable p */
  p_Dims[0]=10,p_Dims[1]=5;
  capi_p_intent |= F2PY_INTENT_IN;
  capi_p_tmp = array_from_pyobj(NPY_FLOAT,p_Dims,p_Rank,capi_p_intent,p_capi);
  if (capi_p_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : _sib21_error,"failed in converting 5th argument `p' of _sib21.decpar to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    p = (float *)(PyArray_DATA(capi_p_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&la,p0,&nd,ll,p);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_p_tmp!=p_capi) {
    Py_XDECREF(capi_p_tmp); }
  }  /*if (capi_p_tmp == NULL) ... else of p*/
  /* End of cleaning variable p */
  if((PyObject *)capi_ll_tmp!=ll_capi) {
    Py_XDECREF(capi_ll_tmp); }
  }  /*if (capi_ll_tmp == NULL) ... else of ll*/
  /* End of cleaning variable ll */
  } /*if (f2py_success) of nd*/
  /* End of cleaning variable nd */
  if((PyObject *)capi_p0_tmp!=p0_capi) {
    Py_XDECREF(capi_p0_tmp); }
  }  /*if (capi_p0_tmp == NULL) ... else of p0*/
  /* End of cleaning variable p0 */
  } /*if (f2py_success) of la*/
  /* End of cleaning variable la */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of decpar *******************************/

/********************************** int_nuc **********************************/
static char doc_f2py_rout__sib21_int_nuc[] = "\
int_nuc(ia,ib,sig0,sigel)\n\nWrapper for ``int_nuc``.\
\n\nParameters\n----------\n"
"ia : input int\n"
"ib : input int\n"
"sig0 : input float\n"
"sigel : input float";
/* extern void F_FUNC_US(int_nuc,INT_NUC)(int*,int*,float*,float*); */
static PyObject *f2py_rout__sib21_int_nuc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,float*,float*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int ia = 0;
  PyObject *ia_capi = Py_None;
  int ib = 0;
  PyObject *ib_capi = Py_None;
  float sig0 = 0;
  PyObject *sig0_capi = Py_None;
  float sigel = 0;
  PyObject *sigel_capi = Py_None;
  static char *capi_kwlist[] = {"ia","ib","sig0","sigel",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:_sib21.int_nuc",\
    capi_kwlist,&ia_capi,&ib_capi,&sig0_capi,&sigel_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ia */
    f2py_success = int_from_pyobj(&ia,ia_capi,"_sib21.int_nuc() 1st argument (ia) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ib */
    f2py_success = int_from_pyobj(&ib,ib_capi,"_sib21.int_nuc() 2nd argument (ib) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sig0 */
    f2py_success = float_from_pyobj(&sig0,sig0_capi,"_sib21.int_nuc() 3rd argument (sig0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable sigel */
    f2py_success = float_from_pyobj(&sigel,sigel_capi,"_sib21.int_nuc() 4th argument (sigel) can't be converted to float");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ia,&ib,&sig0,&sigel);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of sigel*/
  /* End of cleaning variable sigel */
  } /*if (f2py_success) of sig0*/
  /* End of cleaning variable sig0 */
  } /*if (f2py_success) of ib*/
  /* End of cleaning variable ib */
  } /*if (f2py_success) of ia*/
  /* End of cleaning variable ia */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of int_nuc *******************************/

/********************************** pdg_ini **********************************/
static char doc_f2py_rout__sib21_pdg_ini[] = "\
pdg_ini()\n\nWrapper for ``pdg_ini``.\
\n";
/* extern void F_FUNC_US(pdg_ini,PDG_INI)(void); */
static PyObject *f2py_rout__sib21_pdg_ini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_sib21.pdg_ini",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pdg_ini *******************************/

/******************************** isib_pdg2pid ********************************/
static char doc_f2py_rout__sib21_isib_pdg2pid[] = "\
isib_pdg2pid = isib_pdg2pid(npdg)\n\nWrapper for ``isib_pdg2pid``.\
\n\nParameters\n----------\n"
"npdg : input int\n"
"\nReturns\n-------\n"
"isib_pdg2pid : int";
/* extern void F_WRAPPEDFUNC_US(isib_pdg2pid,ISIB_PDG2PID)(int*,int*); */
static PyObject *f2py_rout__sib21_isib_pdg2pid(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int isib_pdg2pid = 0;
  int npdg = 0;
  PyObject *npdg_capi = Py_None;
  static char *capi_kwlist[] = {"npdg",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sib21.isib_pdg2pid",\
    capi_kwlist,&npdg_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable npdg */
    f2py_success = int_from_pyobj(&npdg,npdg_capi,"_sib21.isib_pdg2pid() 1st argument (npdg) can't be converted to int");
  if (f2py_success) {
  /* Processing variable isib_pdg2pid */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&isib_pdg2pid,&npdg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",isib_pdg2pid);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable isib_pdg2pid */
  } /*if (f2py_success) of npdg*/
  /* End of cleaning variable npdg */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of isib_pdg2pid ****************************/

/******************************** isib_pid2pdg ********************************/
static char doc_f2py_rout__sib21_isib_pid2pdg[] = "\
isib_pid2pdg = isib_pid2pdg(npid)\n\nWrapper for ``isib_pid2pdg``.\
\n\nParameters\n----------\n"
"npid : input int\n"
"\nReturns\n-------\n"
"isib_pid2pdg : int";
/* extern void F_WRAPPEDFUNC_US(isib_pid2pdg,ISIB_PID2PDG)(int*,int*); */
static PyObject *f2py_rout__sib21_isib_pid2pdg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int isib_pid2pdg = 0;
  int npid = 0;
  PyObject *npid_capi = Py_None;
  static char *capi_kwlist[] = {"npid",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sib21.isib_pid2pdg",\
    capi_kwlist,&npid_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable npid */
    f2py_success = int_from_pyobj(&npid,npid_capi,"_sib21.isib_pid2pdg() 1st argument (npid) can't be converted to int");
  if (f2py_success) {
  /* Processing variable isib_pid2pdg */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&isib_pid2pdg,&npid);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",isib_pid2pdg);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable isib_pid2pdg */
  } /*if (f2py_success) of npid*/
  /* End of cleaning variable npid */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of isib_pid2pdg ****************************/

/*********************************** sibini ***********************************/
static char doc_f2py_rout__sib21_sibini[] = "\
sibini()\n\nWrapper for ``sibini``.\
\n";
/* extern void F_FUNC(sibini,SIBINI)(void); */
static PyObject *f2py_rout__sib21_sibini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_sib21.sibini",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of sibini *******************************/

/*********************************** sibhep ***********************************/
static char doc_f2py_rout__sib21_sibhep[] = "\
sibhep()\n\nWrapper for ``sibhep``.\
\n";
/* extern void F_FUNC(sibhep,SIBHEP)(void); */
static PyObject *f2py_rout__sib21_sibhep(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_sib21.sibhep",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of sibhep *******************************/

/***************************** chromo_openlogfile *****************************/
static char doc_f2py_rout__sib21_chromo_openlogfile[] = "\
chromo_openlogfile(fname,opunit)\n\nWrapper for ``chromo_openlogfile``.\
\n\nParameters\n----------\n"
"fname : input string(len=300)\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t); */
static PyObject *f2py_rout__sib21_chromo_openlogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string fname = NULL;
  int slen(fname);
  PyObject *fname_capi = Py_None;
  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"fname","opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_sib21.chromo_openlogfile",\
    capi_kwlist,&fname_capi,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fname */
  slen(fname) = 300;
  f2py_success = string_from_pyobj(&fname,&slen(fname),"",fname_capi,"string_from_pyobj failed in converting 1st argument `fname' of _sib21.chromo_openlogfile to C string");
  if (f2py_success) {
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_sib21.chromo_openlogfile() 2nd argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(fname,&opunit,slen(fname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
    STRINGFREE(fname);
  }  /*if (f2py_success) of fname*/
  /* End of cleaning variable fname */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_openlogfile *************************/

/**************************** chromo_closelogfile ****************************/
static char doc_f2py_rout__sib21_chromo_closelogfile[] = "\
chromo_closelogfile(opunit)\n\nWrapper for ``chromo_closelogfile``.\
\n\nParameters\n----------\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*); */
static PyObject *f2py_rout__sib21_chromo_closelogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sib21.chromo_closelogfile",\
    capi_kwlist,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_sib21.chromo_closelogfile() 1st argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&opunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_closelogfile *************************/

/*********************************** npyrng ***********************************/
static char doc_f2py_rout__sib21_npyrng[] = "\
npyrng(rval)\n\nWrapper for ``npyrng``.\
\n\nParameters\n----------\n"
"rval : input float";
/* extern void F_FUNC(npyrng,NPYRNG)(double*); */
static PyObject *f2py_rout__sib21_npyrng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rval = 0;
  PyObject *rval_capi = Py_None;
  static char *capi_kwlist[] = {"rval",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sib21.npyrng",\
    capi_kwlist,&rval_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rval */
    f2py_success = double_from_pyobj(&rval,rval_capi,"_sib21.npyrng() 1st argument (rval) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rval);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of rval*/
  /* End of cleaning variable rval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of npyrng *******************************/

/********************************** spgasdev **********************************/
static char doc_f2py_rout__sib21_spgasdev[] = "\
spgasdev = spgasdev(dummy)\n\nWrapper for ``spgasdev``.\
\n\nParameters\n----------\n"
"dummy : input int\n"
"\nReturns\n-------\n"
"spgasdev : float";
/* extern void F_WRAPPEDFUNC(spgasdev,SPGASDEV)(float*,int*); */
static PyObject *f2py_rout__sib21_spgasdev(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  float spgasdev = 0;
  int dummy = 0;
  PyObject *dummy_capi = Py_None;
  static char *capi_kwlist[] = {"dummy",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sib21.spgasdev",\
    capi_kwlist,&dummy_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable dummy */
    f2py_success = int_from_pyobj(&dummy,dummy_capi,"_sib21.spgasdev() 1st argument (dummy) can't be converted to int");
  if (f2py_success) {
  /* Processing variable spgasdev */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&spgasdev,&dummy);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("f",spgasdev);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable spgasdev */
  } /*if (f2py_success) of dummy*/
  /* End of cleaning variable dummy */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of spgasdev ******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_s_plist_def[] = {
  {"p",2,{{8000,5}},NPY_FLOAT},
  {"llist",1,{{8000}},NPY_INT},
  {"np",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_plist(char *p,char *llist,char *np) {
  int i_f2py=0;
  f2py_s_plist_def[i_f2py++].data = p;
  f2py_s_plist_def[i_f2py++].data = llist;
  f2py_s_plist_def[i_f2py++].data = np;
}
extern void F_FUNC_US(f2pyinits_plist,F2PYINITS_PLIST)(void(*)(char*,char*,char*));
static void f2py_init_s_plist(void) {
  F_FUNC_US(f2pyinits_plist,F2PYINITS_PLIST)(f2py_setup_s_plist);
}

static FortranDataDef f2py_s_run_def[] = {
  {"sqs",0,{{-1}},NPY_FLOAT},
  {"s",0,{{-1}},NPY_FLOAT},
  {"ptmin",0,{{-1}},NPY_FLOAT},
  {"xmin",0,{{-1}},NPY_FLOAT},
  {"zmin",0,{{-1}},NPY_FLOAT},
  {"kb",0,{{-1}},NPY_INT},
  {"kt",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_run(char *sqs,char *s,char *ptmin,char *xmin,char *zmin,char *kb,char *kt) {
  int i_f2py=0;
  f2py_s_run_def[i_f2py++].data = sqs;
  f2py_s_run_def[i_f2py++].data = s;
  f2py_s_run_def[i_f2py++].data = ptmin;
  f2py_s_run_def[i_f2py++].data = xmin;
  f2py_s_run_def[i_f2py++].data = zmin;
  f2py_s_run_def[i_f2py++].data = kb;
  f2py_s_run_def[i_f2py++].data = kt;
}
extern void F_FUNC_US(f2pyinits_run,F2PYINITS_RUN)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_s_run(void) {
  F_FUNC_US(f2pyinits_run,F2PYINITS_RUN)(f2py_setup_s_run);
}

static FortranDataDef f2py_s_debug_def[] = {
  {"ncall",0,{{-1}},NPY_INT},
  {"ndebug",0,{{-1}},NPY_INT},
  {"lun",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_debug(char *ncall,char *ndebug,char *lun) {
  int i_f2py=0;
  f2py_s_debug_def[i_f2py++].data = ncall;
  f2py_s_debug_def[i_f2py++].data = ndebug;
  f2py_s_debug_def[i_f2py++].data = lun;
}
extern void F_FUNC_US(f2pyinits_debug,F2PYINITS_DEBUG)(void(*)(char*,char*,char*));
static void f2py_init_s_debug(void) {
  F_FUNC_US(f2pyinits_debug,F2PYINITS_DEBUG)(f2py_setup_s_debug);
}

static FortranDataDef f2py_s_chist_def[] = {
  {"x1j",1,{{1400}},NPY_FLOAT},
  {"x2j",1,{{1400}},NPY_FLOAT},
  {"x1jsum",1,{{20}},NPY_FLOAT},
  {"x2jsum",1,{{20}},NPY_FLOAT},
  {"ptjet",1,{{1400}},NPY_FLOAT},
  {"phijet",1,{{1400}},NPY_FLOAT},
  {"nnpjet",1,{{1400}},NPY_INT},
  {"nnpstr",1,{{40}},NPY_INT},
  {"nnsof",1,{{20}},NPY_INT},
  {"nnjet",1,{{20}},NPY_INT},
  {"jdif",1,{{20}},NPY_INT},
  {"nw",0,{{-1}},NPY_INT},
  {"njet",0,{{-1}},NPY_INT},
  {"nsof",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_chist(char *x1j,char *x2j,char *x1jsum,char *x2jsum,char *ptjet,char *phijet,char *nnpjet,char *nnpstr,char *nnsof,char *nnjet,char *jdif,char *nw,char *njet,char *nsof) {
  int i_f2py=0;
  f2py_s_chist_def[i_f2py++].data = x1j;
  f2py_s_chist_def[i_f2py++].data = x2j;
  f2py_s_chist_def[i_f2py++].data = x1jsum;
  f2py_s_chist_def[i_f2py++].data = x2jsum;
  f2py_s_chist_def[i_f2py++].data = ptjet;
  f2py_s_chist_def[i_f2py++].data = phijet;
  f2py_s_chist_def[i_f2py++].data = nnpjet;
  f2py_s_chist_def[i_f2py++].data = nnpstr;
  f2py_s_chist_def[i_f2py++].data = nnsof;
  f2py_s_chist_def[i_f2py++].data = nnjet;
  f2py_s_chist_def[i_f2py++].data = jdif;
  f2py_s_chist_def[i_f2py++].data = nw;
  f2py_s_chist_def[i_f2py++].data = njet;
  f2py_s_chist_def[i_f2py++].data = nsof;
}
extern void F_FUNC_US(f2pyinits_chist,F2PYINITS_CHIST)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_s_chist(void) {
  F_FUNC_US(f2pyinits_chist,F2PYINITS_CHIST)(f2py_setup_s_chist);
}

static FortranDataDef f2py_s_ccstr_def[] = {
  {"x1",1,{{40}},NPY_FLOAT},
  {"x2",1,{{40}},NPY_FLOAT},
  {"pxb",1,{{40}},NPY_FLOAT},
  {"pyb",1,{{40}},NPY_FLOAT},
  {"pxt",1,{{40}},NPY_FLOAT},
  {"pyt",1,{{40}},NPY_FLOAT},
  {"iflb",1,{{40}},NPY_INT},
  {"iflt",1,{{40}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_ccstr(char *x1,char *x2,char *pxb,char *pyb,char *pxt,char *pyt,char *iflb,char *iflt) {
  int i_f2py=0;
  f2py_s_ccstr_def[i_f2py++].data = x1;
  f2py_s_ccstr_def[i_f2py++].data = x2;
  f2py_s_ccstr_def[i_f2py++].data = pxb;
  f2py_s_ccstr_def[i_f2py++].data = pyb;
  f2py_s_ccstr_def[i_f2py++].data = pxt;
  f2py_s_ccstr_def[i_f2py++].data = pyt;
  f2py_s_ccstr_def[i_f2py++].data = iflb;
  f2py_s_ccstr_def[i_f2py++].data = iflt;
}
extern void F_FUNC_US(f2pyinits_ccstr,F2PYINITS_CCSTR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_s_ccstr(void) {
  F_FUNC_US(f2pyinits_ccstr,F2PYINITS_CCSTR)(f2py_setup_s_ccstr);
}

static FortranDataDef f2py_s_cldif_def[] = {
  {"ldiff",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_cldif(char *ldiff) {
  int i_f2py=0;
  f2py_s_cldif_def[i_f2py++].data = ldiff;
}
extern void F_FUNC_US(f2pyinits_cldif,F2PYINITS_CLDIF)(void(*)(char*));
static void f2py_init_s_cldif(void) {
  F_FUNC_US(f2pyinits_cldif,F2PYINITS_CLDIF)(f2py_setup_s_cldif);
}

static FortranDataDef f2py_s_cqdis_def[] = {
  {"ppt0",1,{{33}},NPY_FLOAT},
  {"ptflag",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_cqdis(char *ppt0,char *ptflag) {
  int i_f2py=0;
  f2py_s_cqdis_def[i_f2py++].data = ppt0;
  f2py_s_cqdis_def[i_f2py++].data = ptflag;
}
extern void F_FUNC_US(f2pyinits_cqdis,F2PYINITS_CQDIS)(void(*)(char*,char*));
static void f2py_init_s_cqdis(void) {
  F_FUNC_US(f2pyinits_cqdis,F2PYINITS_CQDIS)(f2py_setup_s_cqdis);
}

static FortranDataDef f2py_s_cutoff_def[] = {
  {"str_mass_val",0,{{-1}},NPY_FLOAT},
  {"str_mass_sea",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_cutoff(char *str_mass_val,char *str_mass_sea) {
  int i_f2py=0;
  f2py_s_cutoff_def[i_f2py++].data = str_mass_val;
  f2py_s_cutoff_def[i_f2py++].data = str_mass_sea;
}
extern void F_FUNC_US(f2pyinits_cutoff,F2PYINITS_CUTOFF)(void(*)(char*,char*));
static void f2py_init_s_cutoff(void) {
  F_FUNC_US(f2pyinits_cutoff,F2PYINITS_CUTOFF)(f2py_setup_s_cutoff);
}

static FortranDataDef f2py_s_plist1_def[] = {
  {"llist1",1,{{8000}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_plist1(char *llist1) {
  int i_f2py=0;
  f2py_s_plist1_def[i_f2py++].data = llist1;
}
extern void F_FUNC_US(f2pyinits_plist1,F2PYINITS_PLIST1)(void(*)(char*));
static void f2py_init_s_plist1(void) {
  F_FUNC_US(f2pyinits_plist1,F2PYINITS_PLIST1)(f2py_setup_s_plist1);
}

static FortranDataDef f2py_s_cnam_def[] = {
  {"namp",2,{{50,6}},NPY_STRING},
  {NULL}
};
static void f2py_setup_s_cnam(char *namp) {
  int i_f2py=0;
  f2py_s_cnam_def[i_f2py++].data = namp;
}
extern void F_FUNC_US(f2pyinits_cnam,F2PYINITS_CNAM)(void(*)(char*));
static void f2py_init_s_cnam(void) {
  F_FUNC_US(f2pyinits_cnam,F2PYINITS_CNAM)(f2py_setup_s_cnam);
}

static FortranDataDef f2py_s_chp_def[] = {
  {"ichp",1,{{49}},NPY_INT},
  {"istr",1,{{49}},NPY_INT},
  {"ibar",1,{{49}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_chp(char *ichp,char *istr,char *ibar) {
  int i_f2py=0;
  f2py_s_chp_def[i_f2py++].data = ichp;
  f2py_s_chp_def[i_f2py++].data = istr;
  f2py_s_chp_def[i_f2py++].data = ibar;
}
extern void F_FUNC_US(f2pyinits_chp,F2PYINITS_CHP)(void(*)(char*,char*,char*));
static void f2py_init_s_chp(void) {
  F_FUNC_US(f2pyinits_chp,F2PYINITS_CHP)(f2py_setup_s_chp);
}

static FortranDataDef f2py_s_czdis_def[] = {
  {"fa",0,{{-1}},NPY_FLOAT},
  {"fb0",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_czdis(char *fa,char *fb0) {
  int i_f2py=0;
  f2py_s_czdis_def[i_f2py++].data = fa;
  f2py_s_czdis_def[i_f2py++].data = fb0;
}
extern void F_FUNC_US(f2pyinits_czdis,F2PYINITS_CZDIS)(void(*)(char*,char*));
static void f2py_init_s_czdis(void) {
  F_FUNC_US(f2pyinits_czdis,F2PYINITS_CZDIS)(f2py_setup_s_czdis);
}

static FortranDataDef f2py_s_czdiss_def[] = {
  {"fas1",0,{{-1}},NPY_FLOAT},
  {"fas2",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_czdiss(char *fas1,char *fas2) {
  int i_f2py=0;
  f2py_s_czdiss_def[i_f2py++].data = fas1;
  f2py_s_czdiss_def[i_f2py++].data = fas2;
}
extern void F_FUNC_US(f2pyinits_czdiss,F2PYINITS_CZDISS)(void(*)(char*,char*));
static void f2py_init_s_czdiss(void) {
  F_FUNC_US(f2pyinits_czdiss,F2PYINITS_CZDISS)(f2py_setup_s_czdiss);
}

static FortranDataDef f2py_s_czlead_def[] = {
  {"clead",0,{{-1}},NPY_FLOAT},
  {"flead",0,{{-1}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_czlead(char *clead,char *flead) {
  int i_f2py=0;
  f2py_s_czlead_def[i_f2py++].data = clead;
  f2py_s_czlead_def[i_f2py++].data = flead;
}
extern void F_FUNC_US(f2pyinits_czlead,F2PYINITS_CZLEAD)(void(*)(char*,char*));
static void f2py_init_s_czlead(void) {
  F_FUNC_US(f2pyinits_czlead,F2PYINITS_CZLEAD)(f2py_setup_s_czlead);
}

static FortranDataDef f2py_s_cpspl_def[] = {
  {"cchik",2,{{3,9}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_cpspl(char *cchik) {
  int i_f2py=0;
  f2py_s_cpspl_def[i_f2py++].data = cchik;
}
extern void F_FUNC_US(f2pyinits_cpspl,F2PYINITS_CPSPL)(void(*)(char*));
static void f2py_init_s_cpspl(void) {
  F_FUNC_US(f2pyinits_cpspl,F2PYINITS_CPSPL)(f2py_setup_s_cpspl);
}

static FortranDataDef f2py_s_cflafr_def[] = {
  {"par",1,{{20}},NPY_FLOAT},
  {"ipar",1,{{10}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_cflafr(char *par,char *ipar) {
  int i_f2py=0;
  f2py_s_cflafr_def[i_f2py++].data = par;
  f2py_s_cflafr_def[i_f2py++].data = ipar;
}
extern void F_FUNC_US(f2pyinits_cflafr,F2PYINITS_CFLAFR)(void(*)(char*,char*));
static void f2py_init_s_cflafr(void) {
  F_FUNC_US(f2pyinits_cflafr,F2PYINITS_CFLAFR)(f2py_setup_s_cflafr);
}

static FortranDataDef f2py_ckfrag_def[] = {
  {"kodfrag",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ckfrag(char *kodfrag) {
  int i_f2py=0;
  f2py_ckfrag_def[i_f2py++].data = kodfrag;
}
extern void F_FUNC(f2pyinitckfrag,F2PYINITCKFRAG)(void(*)(char*));
static void f2py_init_ckfrag(void) {
  F_FUNC(f2pyinitckfrag,F2PYINITCKFRAG)(f2py_setup_ckfrag);
}

static FortranDataDef f2py_s_ccsig_def[] = {
  {"ssig",2,{{61,3}},NPY_FLOAT},
  {"pjetc",4,{{21,51,61,2}},NPY_FLOAT},
  {"ssign",2,{{61,3}},NPY_FLOAT},
  {"alint",2,{{61,3}},NPY_FLOAT},
  {"asqsmin",0,{{-1}},NPY_FLOAT},
  {"asqsmax",0,{{-1}},NPY_FLOAT},
  {"dasqs",0,{{-1}},NPY_FLOAT},
  {"nsqs",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_ccsig(char *ssig,char *pjetc,char *ssign,char *alint,char *asqsmin,char *asqsmax,char *dasqs,char *nsqs) {
  int i_f2py=0;
  f2py_s_ccsig_def[i_f2py++].data = ssig;
  f2py_s_ccsig_def[i_f2py++].data = pjetc;
  f2py_s_ccsig_def[i_f2py++].data = ssign;
  f2py_s_ccsig_def[i_f2py++].data = alint;
  f2py_s_ccsig_def[i_f2py++].data = asqsmin;
  f2py_s_ccsig_def[i_f2py++].data = asqsmax;
  f2py_s_ccsig_def[i_f2py++].data = dasqs;
  f2py_s_ccsig_def[i_f2py++].data = nsqs;
}
extern void F_FUNC_US(f2pyinits_ccsig,F2PYINITS_CCSIG)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_s_ccsig(void) {
  F_FUNC_US(f2pyinits_ccsig,F2PYINITS_CCSIG)(f2py_setup_s_ccsig);
}

static FortranDataDef f2py_s_ccsig2_def[] = {
  {"ssig_tot",2,{{61,3}},NPY_FLOAT},
  {"ssig_sd1",2,{{61,3}},NPY_FLOAT},
  {"ssig_sd2",2,{{61,3}},NPY_FLOAT},
  {"ssig_dd",2,{{61,3}},NPY_FLOAT},
  {"ssig_b",2,{{61,3}},NPY_FLOAT},
  {"ssig_rho",2,{{61,3}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_ccsig2(char *ssig_tot,char *ssig_sd1,char *ssig_sd2,char *ssig_dd,char *ssig_b,char *ssig_rho) {
  int i_f2py=0;
  f2py_s_ccsig2_def[i_f2py++].data = ssig_tot;
  f2py_s_ccsig2_def[i_f2py++].data = ssig_sd1;
  f2py_s_ccsig2_def[i_f2py++].data = ssig_sd2;
  f2py_s_ccsig2_def[i_f2py++].data = ssig_dd;
  f2py_s_ccsig2_def[i_f2py++].data = ssig_b;
  f2py_s_ccsig2_def[i_f2py++].data = ssig_rho;
}
extern void F_FUNC_US(f2pyinits_ccsig2,F2PYINITS_CCSIG2)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_s_ccsig2(void) {
  F_FUNC_US(f2pyinits_ccsig2,F2PYINITS_CCSIG2)(f2py_setup_s_ccsig2);
}

static FortranDataDef f2py_s_csydec_def[] = {
  {"cbr",1,{{102}},NPY_FLOAT},
  {"kdec",1,{{612}},NPY_INT},
  {"lbarp",1,{{49}},NPY_INT},
  {"idb",1,{{49}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_csydec(char *cbr,char *kdec,char *lbarp,char *idb) {
  int i_f2py=0;
  f2py_s_csydec_def[i_f2py++].data = cbr;
  f2py_s_csydec_def[i_f2py++].data = kdec;
  f2py_s_csydec_def[i_f2py++].data = lbarp;
  f2py_s_csydec_def[i_f2py++].data = idb;
}
extern void F_FUNC_US(f2pyinits_csydec,F2PYINITS_CSYDEC)(void(*)(char*,char*,char*,char*));
static void f2py_init_s_csydec(void) {
  F_FUNC_US(f2pyinits_csydec,F2PYINITS_CSYDEC)(f2py_setup_s_csydec);
}

static FortranDataDef f2py_s_mass1_def[] = {
  {"am",1,{{49}},NPY_FLOAT},
  {"am2",1,{{49}},NPY_FLOAT},
  {NULL}
};
static void f2py_setup_s_mass1(char *am,char *am2) {
  int i_f2py=0;
  f2py_s_mass1_def[i_f2py++].data = am;
  f2py_s_mass1_def[i_f2py++].data = am2;
}
extern void F_FUNC_US(f2pyinits_mass1,F2PYINITS_MASS1)(void(*)(char*,char*));
static void f2py_init_s_mass1(void) {
  F_FUNC_US(f2pyinits_mass1,F2PYINITS_MASS1)(f2py_setup_s_mass1);
}

static FortranDataDef f2py_fragmod_def[] = {
  {"a",3,{{10,10,20}},NPY_FLOAT},
  {"ae",3,{{10,10,20}},NPY_FLOAT},
  {"eres",2,{{10,10}},NPY_FLOAT},
  {"nflagg",2,{{10,10}},NPY_INT},
  {NULL}
};
static void f2py_setup_fragmod(char *a,char *ae,char *eres,char *nflagg) {
  int i_f2py=0;
  f2py_fragmod_def[i_f2py++].data = a;
  f2py_fragmod_def[i_f2py++].data = ae;
  f2py_fragmod_def[i_f2py++].data = eres;
  f2py_fragmod_def[i_f2py++].data = nflagg;
}
extern void F_FUNC(f2pyinitfragmod,F2PYINITFRAGMOD)(void(*)(char*,char*,char*,char*));
static void f2py_init_fragmod(void) {
  F_FUNC(f2pyinitfragmod,F2PYINITFRAGMOD)(f2py_setup_fragmod);
}

static FortranDataDef f2py_cnucms_def[] = {
  {"b",0,{{-1}},NPY_FLOAT},
  {"bmax",0,{{-1}},NPY_FLOAT},
  {"ntry",0,{{-1}},NPY_INT},
  {"na",0,{{-1}},NPY_INT},
  {"nb",0,{{-1}},NPY_INT},
  {"ni",0,{{-1}},NPY_INT},
  {"nael",0,{{-1}},NPY_INT},
  {"nbel",0,{{-1}},NPY_INT},
  {"jja",1,{{56}},NPY_INT},
  {"jjb",1,{{56}},NPY_INT},
  {"jjint",2,{{56,56}},NPY_INT},
  {"jjael",1,{{56}},NPY_INT},
  {"jjbel",1,{{56}},NPY_INT},
  {NULL}
};
static void f2py_setup_cnucms(char *b,char *bmax,char *ntry,char *na,char *nb,char *ni,char *nael,char *nbel,char *jja,char *jjb,char *jjint,char *jjael,char *jjbel) {
  int i_f2py=0;
  f2py_cnucms_def[i_f2py++].data = b;
  f2py_cnucms_def[i_f2py++].data = bmax;
  f2py_cnucms_def[i_f2py++].data = ntry;
  f2py_cnucms_def[i_f2py++].data = na;
  f2py_cnucms_def[i_f2py++].data = nb;
  f2py_cnucms_def[i_f2py++].data = ni;
  f2py_cnucms_def[i_f2py++].data = nael;
  f2py_cnucms_def[i_f2py++].data = nbel;
  f2py_cnucms_def[i_f2py++].data = jja;
  f2py_cnucms_def[i_f2py++].data = jjb;
  f2py_cnucms_def[i_f2py++].data = jjint;
  f2py_cnucms_def[i_f2py++].data = jjael;
  f2py_cnucms_def[i_f2py++].data = jjbel;
}
extern void F_FUNC(f2pyinitcnucms,F2PYINITCNUCMS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_cnucms(void) {
  F_FUNC(f2pyinitcnucms,F2PYINITCNUCMS)(f2py_setup_cnucms);
}

static FortranDataDef f2py_s_pdg2pid_def[] = {
  {"id_pdg_list",1,{{99}},NPY_INT},
  {"id_list",1,{{577}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_pdg2pid(char *id_pdg_list,char *id_list) {
  int i_f2py=0;
  f2py_s_pdg2pid_def[i_f2py++].data = id_pdg_list;
  f2py_s_pdg2pid_def[i_f2py++].data = id_list;
}
extern void F_FUNC_US(f2pyinits_pdg2pid,F2PYINITS_PDG2PID)(void(*)(char*,char*));
static void f2py_init_s_pdg2pid(void) {
  F_FUNC_US(f2pyinits_pdg2pid,F2PYINITS_PDG2PID)(f2py_setup_s_pdg2pid);
}

static FortranDataDef f2py_hepevt_def[] = {
  {"nevhep",0,{{-1}},NPY_INT},
  {"nhep",0,{{-1}},NPY_INT},
  {"isthep",1,{{8000}},NPY_INT},
  {"idhep",1,{{8000}},NPY_INT},
  {"jmohep",2,{{2,8000}},NPY_INT},
  {"jdahep",2,{{2,8000}},NPY_INT},
  {"phep",2,{{5,8000}},NPY_DOUBLE},
  {"vhep",2,{{4,8000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepevt(char *nevhep,char *nhep,char *isthep,char *idhep,char *jmohep,char *jdahep,char *phep,char *vhep) {
  int i_f2py=0;
  f2py_hepevt_def[i_f2py++].data = nevhep;
  f2py_hepevt_def[i_f2py++].data = nhep;
  f2py_hepevt_def[i_f2py++].data = isthep;
  f2py_hepevt_def[i_f2py++].data = idhep;
  f2py_hepevt_def[i_f2py++].data = jmohep;
  f2py_hepevt_def[i_f2py++].data = jdahep;
  f2py_hepevt_def[i_f2py++].data = phep;
  f2py_hepevt_def[i_f2py++].data = vhep;
}
extern void F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepevt(void) {
  F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(f2py_setup_hepevt);
}

static FortranDataDef f2py_schg_def[] = {
  {"ichg",1,{{8000}},NPY_INT},
  {NULL}
};
static void f2py_setup_schg(char *ichg) {
  int i_f2py=0;
  f2py_schg_def[i_f2py++].data = ichg;
}
extern void F_FUNC(f2pyinitschg,F2PYINITSCHG)(void(*)(char*));
static void f2py_init_schg(void) {
  F_FUNC(f2pyinitschg,F2PYINITSCHG)(f2py_setup_schg);
}

static FortranDataDef f2py_npy_def[] = {
  {"bitgen",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_npy(char *bitgen) {
  int i_f2py=0;
  f2py_npy_def[i_f2py++].data = bitgen;
}
extern void F_FUNC(f2pyinitnpy,F2PYINITNPY)(void(*)(char*));
static void f2py_init_npy(void) {
  F_FUNC(f2pyinitnpy,F2PYINITNPY)(f2py_setup_npy);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"sibyll",-1,{{-1}},0,(char *)F_FUNC(sibyll,SIBYLL),(f2py_init_func)f2py_rout__sib21_sibyll,doc_f2py_rout__sib21_sibyll},
  {"sib_list",-1,{{-1}},0,(char *)F_FUNC_US(sib_list,SIB_LIST),(f2py_init_func)f2py_rout__sib21_sib_list,doc_f2py_rout__sib21_sib_list},
  {"sibyll_ini",-1,{{-1}},0,(char *)F_FUNC_US(sibyll_ini,SIBYLL_INI),(f2py_init_func)f2py_rout__sib21_sibyll_ini,doc_f2py_rout__sib21_sibyll_ini},
  {"sib_sigma_hp",-1,{{-1}},0,(char *)F_FUNC_US(sib_sigma_hp,SIB_SIGMA_HP),(f2py_init_func)f2py_rout__sib21_sib_sigma_hp,doc_f2py_rout__sib21_sib_sigma_hp},
  {"sib_sigma_hair",-1,{{-1}},0,(char *)F_FUNC_US(sib_sigma_hair,SIB_SIGMA_HAIR),(f2py_init_func)f2py_rout__sib21_sib_sigma_hair,doc_f2py_rout__sib21_sib_sigma_hair},
  {"decsib",-1,{{-1}},0,(char *)F_FUNC(decsib,DECSIB),(f2py_init_func)f2py_rout__sib21_decsib,doc_f2py_rout__sib21_decsib},
  {"decpar",-1,{{-1}},0,(char *)F_FUNC(decpar,DECPAR),(f2py_init_func)f2py_rout__sib21_decpar,doc_f2py_rout__sib21_decpar},
  {"int_nuc",-1,{{-1}},0,(char *)F_FUNC_US(int_nuc,INT_NUC),(f2py_init_func)f2py_rout__sib21_int_nuc,doc_f2py_rout__sib21_int_nuc},
  {"pdg_ini",-1,{{-1}},0,(char *)F_FUNC_US(pdg_ini,PDG_INI),(f2py_init_func)f2py_rout__sib21_pdg_ini,doc_f2py_rout__sib21_pdg_ini},
  {"isib_pdg2pid",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(isib_pdg2pid,ISIB_PDG2PID),(f2py_init_func)f2py_rout__sib21_isib_pdg2pid,doc_f2py_rout__sib21_isib_pdg2pid},
  {"isib_pid2pdg",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(isib_pid2pdg,ISIB_PID2PDG),(f2py_init_func)f2py_rout__sib21_isib_pid2pdg,doc_f2py_rout__sib21_isib_pid2pdg},
  {"sibini",-1,{{-1}},0,(char *)F_FUNC(sibini,SIBINI),(f2py_init_func)f2py_rout__sib21_sibini,doc_f2py_rout__sib21_sibini},
  {"sibhep",-1,{{-1}},0,(char *)F_FUNC(sibhep,SIBHEP),(f2py_init_func)f2py_rout__sib21_sibhep,doc_f2py_rout__sib21_sibhep},
  {"chromo_openlogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE),(f2py_init_func)f2py_rout__sib21_chromo_openlogfile,doc_f2py_rout__sib21_chromo_openlogfile},
  {"chromo_closelogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE),(f2py_init_func)f2py_rout__sib21_chromo_closelogfile,doc_f2py_rout__sib21_chromo_closelogfile},
  {"npyrng",-1,{{-1}},0,(char *)F_FUNC(npyrng,NPYRNG),(f2py_init_func)f2py_rout__sib21_npyrng,doc_f2py_rout__sib21_npyrng},
  {"spgasdev",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(spgasdev,SPGASDEV),(f2py_init_func)f2py_rout__sib21_spgasdev,doc_f2py_rout__sib21_spgasdev},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_sib21",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__sib21(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = _sib21_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _sib21 (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module '_sib21' is auto-generated with f2py (version:2).\nFunctions:\n"
"  sibyll(k_beam,iatarg,ecm)\n"
"  sib_list()\n"
"  sibyll_ini()\n"
"  sigt,sigel,siginel,sigdif,slope,rho = sib_sigma_hp(l,sqs)\n"
"  sigprod = sib_sigma_hair(l,sqs)\n"
"  decsib()\n"
"  decpar(la,p0,nd,ll,p)\n"
"  int_nuc(ia,ib,sig0,sigel)\n"
"  pdg_ini()\n"
"  isib_pdg2pid = isib_pdg2pid(npdg)\n"
"  isib_pid2pdg = isib_pid2pdg(npid)\n"
"  sibini()\n"
"  sibhep()\n"
"  chromo_openlogfile(fname,opunit)\n"
"  chromo_closelogfile(opunit)\n"
"  npyrng(rval)\n"
"  spgasdev = spgasdev(dummy)\n"
"COMMON blocks:\n""  /s_plist/ p(8000,5),llist(8000),np\n""  /s_run/ sqs,s,ptmin,xmin,zmin,kb,kt\n""  /s_debug/ ncall,ndebug,lun\n""  /s_chist/ x1j(1400),x2j(1400),x1jsum(20),x2jsum(20),ptjet(1400),phijet(1400),nnpjet(1400),nnpstr(40),nnsof(20),nnjet(20),jdif(20),nw,njet,nsof\n""  /s_ccstr/ x1(40),x2(40),pxb(40),pyb(40),pxt(40),pyt(40),iflb(40),iflt(40)\n""  /s_cldif/ ldiff\n""  /s_cqdis/ ppt0(33),ptflag\n""  /s_cutoff/ str_mass_val,str_mass_sea\n""  /s_plist1/ llist1(8000)\n""  /s_cnam/ namp(50,6)\n""  /s_chp/ ichp(49),istr(49),ibar(49)\n""  /s_czdis/ fa,fb0\n""  /s_czdiss/ fas1,fas2\n""  /s_czlead/ clead,flead\n""  /s_cpspl/ cchik(3,9)\n""  /s_cflafr/ par(20),ipar(10)\n""  /ckfrag/ kodfrag\n""  /s_ccsig/ ssig(61,3),pjetc(21,51,61,2),ssign(61,3),alint(61,3),asqsmin,asqsmax,dasqs,nsqs\n""  /s_ccsig2/ ssig_tot(61,3),ssig_sd1(61,3),ssig_sd2(61,3),ssig_dd(61,3),ssig_b(61,3),ssig_rho(61,3)\n""  /s_csydec/ cbr(102),kdec(612),lbarp(49),idb(49)\n""  /s_mass1/ am(49),am2(49)\n""  /fragmod/ a(10,10,20),ae(10,10,20),eres(10,10),nflagg(10,10)\n""  /cnucms/ b,bmax,ntry,na,nb,ni,nael,nbel,jja(56),jjb(56),jjint(56,56),jjael(56),jjbel(56)\n""  /s_pdg2pid/ id_pdg_list(99),id_list(577)\n""  /hepevt/ nevhep,nhep,isthep(8000),idhep(8000),jmohep(2,8000),jdahep(2,8000),phep(5,8000),vhep(4,8000)\n""  /schg/ ichg(8000)\n""  /npy/ bitgen\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _sib21_error = PyErr_NewException ("_sib21.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__sib21_error", _sib21_error);
  Py_DECREF(_sib21_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }










    {
      extern int F_FUNC_US(isib_pdg2pid,ISIB_PDG2PID)(void);
      PyObject* o = PyDict_GetItemString(d,"isib_pdg2pid");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(isib_pdg2pid,ISIB_PDG2PID),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("isib_pdg2pid");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern int F_FUNC_US(isib_pid2pdg,ISIB_PID2PDG)(void);
      PyObject* o = PyDict_GetItemString(d,"isib_pid2pdg");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(isib_pid2pdg,ISIB_PID2PDG),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("isib_pid2pdg");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    






    {
      extern float F_FUNC(spgasdev,SPGASDEV)(void);
      PyObject* o = PyDict_GetItemString(d,"spgasdev");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(spgasdev,SPGASDEV),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("spgasdev");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    
/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_s_plist_def,f2py_init_s_plist);
  F2PyDict_SetItemString(d, "s_plist", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_run_def,f2py_init_s_run);
  F2PyDict_SetItemString(d, "s_run", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_debug_def,f2py_init_s_debug);
  F2PyDict_SetItemString(d, "s_debug", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_chist_def,f2py_init_s_chist);
  F2PyDict_SetItemString(d, "s_chist", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_ccstr_def,f2py_init_s_ccstr);
  F2PyDict_SetItemString(d, "s_ccstr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cldif_def,f2py_init_s_cldif);
  F2PyDict_SetItemString(d, "s_cldif", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cqdis_def,f2py_init_s_cqdis);
  F2PyDict_SetItemString(d, "s_cqdis", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cutoff_def,f2py_init_s_cutoff);
  F2PyDict_SetItemString(d, "s_cutoff", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_plist1_def,f2py_init_s_plist1);
  F2PyDict_SetItemString(d, "s_plist1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cnam_def,f2py_init_s_cnam);
  F2PyDict_SetItemString(d, "s_cnam", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_chp_def,f2py_init_s_chp);
  F2PyDict_SetItemString(d, "s_chp", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_czdis_def,f2py_init_s_czdis);
  F2PyDict_SetItemString(d, "s_czdis", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_czdiss_def,f2py_init_s_czdiss);
  F2PyDict_SetItemString(d, "s_czdiss", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_czlead_def,f2py_init_s_czlead);
  F2PyDict_SetItemString(d, "s_czlead", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cpspl_def,f2py_init_s_cpspl);
  F2PyDict_SetItemString(d, "s_cpspl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cflafr_def,f2py_init_s_cflafr);
  F2PyDict_SetItemString(d, "s_cflafr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ckfrag_def,f2py_init_ckfrag);
  F2PyDict_SetItemString(d, "ckfrag", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_ccsig_def,f2py_init_s_ccsig);
  F2PyDict_SetItemString(d, "s_ccsig", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_ccsig2_def,f2py_init_s_ccsig2);
  F2PyDict_SetItemString(d, "s_ccsig2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_csydec_def,f2py_init_s_csydec);
  F2PyDict_SetItemString(d, "s_csydec", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_mass1_def,f2py_init_s_mass1);
  F2PyDict_SetItemString(d, "s_mass1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_fragmod_def,f2py_init_fragmod);
  F2PyDict_SetItemString(d, "fragmod", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cnucms_def,f2py_init_cnucms);
  F2PyDict_SetItemString(d, "cnucms", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_pdg2pid_def,f2py_init_s_pdg2pid);
  F2PyDict_SetItemString(d, "s_pdg2pid", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepevt_def,f2py_init_hepevt);
  F2PyDict_SetItemString(d, "hepevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_schg_def,f2py_init_schg);
  F2PyDict_SetItemString(d, "schg", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_npy_def,f2py_init_npy);
  F2PyDict_SetItemString(d, "npy", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_sib21");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
