/* File: _sophiamodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Mon Jan 16 17:32:57 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_sophia_error;
static PyObject *_sophia_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _sophia_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _sophia_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _sophia_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(eventgen,EVENTGEN)(int*,double*,double*,double*,int*);
extern void F_WRAPPEDFUNC(crossection,CROSSECTION)(double*,double*,int*,int*);
extern void F_FUNC_US(print_event,PRINT_EVENT)(int*);
extern void F_WRAPPEDFUNC_US(icon_pdg_sib,ICON_PDG_SIB)(int*,int*);
extern void F_FUNC(initial,INITIAL)(int*);
extern void F_FUNC(toevt,TOEVT)(void);
extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t);
extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*);
extern void F_FUNC(npyrng,NPYRNG)(double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************************** eventgen **********************************/
static char doc_f2py_rout__sophia_eventgen[] = "\
imode = eventgen(l0,e0,eps,theta)\n\nWrapper for ``eventgen``.\
\n\nParameters\n----------\n"
"l0 : input int\n"
"e0 : input float\n"
"eps : input float\n"
"theta : input float\n"
"\nReturns\n-------\n"
"imode : int";
/* extern void F_FUNC(eventgen,EVENTGEN)(int*,double*,double*,double*,int*); */
static PyObject *f2py_rout__sophia_eventgen(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int l0 = 0;
  PyObject *l0_capi = Py_None;
  double e0 = 0;
  PyObject *e0_capi = Py_None;
  double eps = 0;
  PyObject *eps_capi = Py_None;
  double theta = 0;
  PyObject *theta_capi = Py_None;
  int imode = 0;
  static char *capi_kwlist[] = {"l0","e0","eps","theta",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:_sophia.eventgen",\
    capi_kwlist,&l0_capi,&e0_capi,&eps_capi,&theta_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable l0 */
    f2py_success = int_from_pyobj(&l0,l0_capi,"_sophia.eventgen() 1st argument (l0) can't be converted to int");
  if (f2py_success) {
  /* Processing variable e0 */
    f2py_success = double_from_pyobj(&e0,e0_capi,"_sophia.eventgen() 2nd argument (e0) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"_sophia.eventgen() 3rd argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable theta */
    f2py_success = double_from_pyobj(&theta,theta_capi,"_sophia.eventgen() 4th argument (theta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable imode */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&l0,&e0,&eps,&theta,&imode);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",imode);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable imode */
  } /*if (f2py_success) of theta*/
  /* End of cleaning variable theta */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
  } /*if (f2py_success) of e0*/
  /* End of cleaning variable e0 */
  } /*if (f2py_success) of l0*/
  /* End of cleaning variable l0 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of eventgen ******************************/

/******************************** crossection ********************************/
static char doc_f2py_rout__sophia_crossection[] = "\
crossection = crossection(x,ndir,nl0)\n\nWrapper for ``crossection``.\
\n\nParameters\n----------\n"
"x : input float\n"
"ndir : input int\n"
"nl0 : input int\n"
"\nReturns\n-------\n"
"crossection : float";
/* extern void F_WRAPPEDFUNC(crossection,CROSSECTION)(double*,double*,int*,int*); */
static PyObject *f2py_rout__sophia_crossection(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double crossection = 0;
  double x = 0;
  PyObject *x_capi = Py_None;
  int ndir = 0;
  PyObject *ndir_capi = Py_None;
  int nl0 = 0;
  PyObject *nl0_capi = Py_None;
  static char *capi_kwlist[] = {"x","ndir","nl0",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_sophia.crossection",\
    capi_kwlist,&x_capi,&ndir_capi,&nl0_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"_sophia.crossection() 1st argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ndir */
    f2py_success = int_from_pyobj(&ndir,ndir_capi,"_sophia.crossection() 2nd argument (ndir) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nl0 */
    f2py_success = int_from_pyobj(&nl0,nl0_capi,"_sophia.crossection() 3rd argument (nl0) can't be converted to int");
  if (f2py_success) {
  /* Processing variable crossection */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&crossection,&x,&ndir,&nl0);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",crossection);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable crossection */
  } /*if (f2py_success) of nl0*/
  /* End of cleaning variable nl0 */
  } /*if (f2py_success) of ndir*/
  /* End of cleaning variable ndir */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of crossection *****************************/

/******************************** print_event ********************************/
static char doc_f2py_rout__sophia_print_event[] = "\
print_event(iout)\n\nWrapper for ``print_event``.\
\n\nParameters\n----------\n"
"iout : input int";
/* extern void F_FUNC_US(print_event,PRINT_EVENT)(int*); */
static PyObject *f2py_rout__sophia_print_event(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iout = 0;
  PyObject *iout_capi = Py_None;
  static char *capi_kwlist[] = {"iout",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sophia.print_event",\
    capi_kwlist,&iout_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iout */
    f2py_success = int_from_pyobj(&iout,iout_capi,"_sophia.print_event() 1st argument (iout) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iout);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iout*/
  /* End of cleaning variable iout */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of print_event *****************************/

/******************************** icon_pdg_sib ********************************/
static char doc_f2py_rout__sophia_icon_pdg_sib[] = "\
icon_pdg_sib = icon_pdg_sib(id)\n\nWrapper for ``icon_pdg_sib``.\
\n\nParameters\n----------\n"
"id : input int\n"
"\nReturns\n-------\n"
"icon_pdg_sib : int";
/* extern void F_WRAPPEDFUNC_US(icon_pdg_sib,ICON_PDG_SIB)(int*,int*); */
static PyObject *f2py_rout__sophia_icon_pdg_sib(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int icon_pdg_sib = 0;
  int id = 0;
  PyObject *id_capi = Py_None;
  static char *capi_kwlist[] = {"id",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sophia.icon_pdg_sib",\
    capi_kwlist,&id_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable id */
    f2py_success = int_from_pyobj(&id,id_capi,"_sophia.icon_pdg_sib() 1st argument (id) can't be converted to int");
  if (f2py_success) {
  /* Processing variable icon_pdg_sib */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&icon_pdg_sib,&id);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",icon_pdg_sib);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable icon_pdg_sib */
  } /*if (f2py_success) of id*/
  /* End of cleaning variable id */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of icon_pdg_sib ****************************/

/********************************** initial **********************************/
static char doc_f2py_rout__sophia_initial[] = "\
initial(l0)\n\nWrapper for ``initial``.\
\n\nParameters\n----------\n"
"l0 : input int";
/* extern void F_FUNC(initial,INITIAL)(int*); */
static PyObject *f2py_rout__sophia_initial(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int l0 = 0;
  PyObject *l0_capi = Py_None;
  static char *capi_kwlist[] = {"l0",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sophia.initial",\
    capi_kwlist,&l0_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable l0 */
    f2py_success = int_from_pyobj(&l0,l0_capi,"_sophia.initial() 1st argument (l0) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&l0);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of l0*/
  /* End of cleaning variable l0 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of initial *******************************/

/*********************************** toevt ***********************************/
static char doc_f2py_rout__sophia_toevt[] = "\
toevt()\n\nWrapper for ``toevt``.\
\n";
/* extern void F_FUNC(toevt,TOEVT)(void); */
static PyObject *f2py_rout__sophia_toevt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_sophia.toevt",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of toevt ********************************/

/***************************** chromo_openlogfile *****************************/
static char doc_f2py_rout__sophia_chromo_openlogfile[] = "\
chromo_openlogfile(fname,opunit)\n\nWrapper for ``chromo_openlogfile``.\
\n\nParameters\n----------\n"
"fname : input string(len=300)\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t); */
static PyObject *f2py_rout__sophia_chromo_openlogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string fname = NULL;
  int slen(fname);
  PyObject *fname_capi = Py_None;
  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"fname","opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_sophia.chromo_openlogfile",\
    capi_kwlist,&fname_capi,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fname */
  slen(fname) = 300;
  f2py_success = string_from_pyobj(&fname,&slen(fname),"",fname_capi,"string_from_pyobj failed in converting 1st argument `fname' of _sophia.chromo_openlogfile to C string");
  if (f2py_success) {
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_sophia.chromo_openlogfile() 2nd argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(fname,&opunit,slen(fname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
    STRINGFREE(fname);
  }  /*if (f2py_success) of fname*/
  /* End of cleaning variable fname */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_openlogfile *************************/

/**************************** chromo_closelogfile ****************************/
static char doc_f2py_rout__sophia_chromo_closelogfile[] = "\
chromo_closelogfile(opunit)\n\nWrapper for ``chromo_closelogfile``.\
\n\nParameters\n----------\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*); */
static PyObject *f2py_rout__sophia_chromo_closelogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sophia.chromo_closelogfile",\
    capi_kwlist,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_sophia.chromo_closelogfile() 1st argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&opunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_closelogfile *************************/

/*********************************** npyrng ***********************************/
static char doc_f2py_rout__sophia_npyrng[] = "\
npyrng(rval)\n\nWrapper for ``npyrng``.\
\n\nParameters\n----------\n"
"rval : input float";
/* extern void F_FUNC(npyrng,NPYRNG)(double*); */
static PyObject *f2py_rout__sophia_npyrng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rval = 0;
  PyObject *rval_capi = Py_None;
  static char *capi_kwlist[] = {"rval",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_sophia.npyrng",\
    capi_kwlist,&rval_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rval */
    f2py_success = double_from_pyobj(&rval,rval_capi,"_sophia.npyrng() 1st argument (rval) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rval);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of rval*/
  /* End of cleaning variable rval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of npyrng *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_eg_io_def[] = {
  {"keepdc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_eg_io(char *keepdc) {
  int i_f2py=0;
  f2py_eg_io_def[i_f2py++].data = keepdc;
}
extern void F_FUNC_US(f2pyiniteg_io,F2PYINITEG_IO)(void(*)(char*));
static void f2py_init_eg_io(void) {
  F_FUNC_US(f2pyiniteg_io,F2PYINITEG_IO)(f2py_setup_eg_io);
}

static FortranDataDef f2py_s_run_def[] = {
  {"sqs",0,{{-1}},NPY_DOUBLE},
  {"s",0,{{-1}},NPY_DOUBLE},
  {"q2min",0,{{-1}},NPY_DOUBLE},
  {"xmin",0,{{-1}},NPY_DOUBLE},
  {"zmin",0,{{-1}},NPY_DOUBLE},
  {"kb",0,{{-1}},NPY_INT},
  {"kt",0,{{-1}},NPY_INT},
  {"a1",0,{{-1}},NPY_DOUBLE},
  {"a2",0,{{-1}},NPY_DOUBLE},
  {"nproc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_run(char *sqs,char *s,char *q2min,char *xmin,char *zmin,char *kb,char *kt,char *a1,char *a2,char *nproc) {
  int i_f2py=0;
  f2py_s_run_def[i_f2py++].data = sqs;
  f2py_s_run_def[i_f2py++].data = s;
  f2py_s_run_def[i_f2py++].data = q2min;
  f2py_s_run_def[i_f2py++].data = xmin;
  f2py_s_run_def[i_f2py++].data = zmin;
  f2py_s_run_def[i_f2py++].data = kb;
  f2py_s_run_def[i_f2py++].data = kt;
  f2py_s_run_def[i_f2py++].data = a1;
  f2py_s_run_def[i_f2py++].data = a2;
  f2py_s_run_def[i_f2py++].data = nproc;
}
extern void F_FUNC_US(f2pyinits_run,F2PYINITS_RUN)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_s_run(void) {
  F_FUNC_US(f2pyinits_run,F2PYINITS_RUN)(f2py_setup_s_run);
}

static FortranDataDef f2py_s_plist_def[] = {
  {"p",2,{{2000,5}},NPY_DOUBLE},
  {"llist",1,{{2000}},NPY_INT},
  {"np",0,{{-1}},NPY_INT},
  {"ideb",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_plist(char *p,char *llist,char *np,char *ideb) {
  int i_f2py=0;
  f2py_s_plist_def[i_f2py++].data = p;
  f2py_s_plist_def[i_f2py++].data = llist;
  f2py_s_plist_def[i_f2py++].data = np;
  f2py_s_plist_def[i_f2py++].data = ideb;
}
extern void F_FUNC_US(f2pyinits_plist,F2PYINITS_PLIST)(void(*)(char*,char*,char*,char*));
static void f2py_init_s_plist(void) {
  F_FUNC_US(f2pyinits_plist,F2PYINITS_PLIST)(f2py_setup_s_plist);
}

static FortranDataDef f2py_s_mass1_def[] = {
  {"am",1,{{49}},NPY_DOUBLE},
  {"am2",1,{{49}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_mass1(char *am,char *am2) {
  int i_f2py=0;
  f2py_s_mass1_def[i_f2py++].data = am;
  f2py_s_mass1_def[i_f2py++].data = am2;
}
extern void F_FUNC_US(f2pyinits_mass1,F2PYINITS_MASS1)(void(*)(char*,char*));
static void f2py_init_s_mass1(void) {
  F_FUNC_US(f2pyinits_mass1,F2PYINITS_MASS1)(f2py_setup_s_mass1);
}

static FortranDataDef f2py_s_chp_def[] = {
  {"s_life",1,{{49}},NPY_DOUBLE},
  {"ichp",1,{{49}},NPY_INT},
  {"istr",1,{{49}},NPY_INT},
  {"ibar",1,{{49}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_chp(char *s_life,char *ichp,char *istr,char *ibar) {
  int i_f2py=0;
  f2py_s_chp_def[i_f2py++].data = s_life;
  f2py_s_chp_def[i_f2py++].data = ichp;
  f2py_s_chp_def[i_f2py++].data = istr;
  f2py_s_chp_def[i_f2py++].data = ibar;
}
extern void F_FUNC_US(f2pyinits_chp,F2PYINITS_CHP)(void(*)(char*,char*,char*,char*));
static void f2py_init_s_chp(void) {
  F_FUNC_US(f2pyinits_chp,F2PYINITS_CHP)(f2py_setup_s_chp);
}

static FortranDataDef f2py_s_csydec_def[] = {
  {"cbr",1,{{102}},NPY_DOUBLE},
  {"idb",1,{{49}},NPY_INT},
  {"kdec",1,{{612}},NPY_INT},
  {"lbarp",1,{{49}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_csydec(char *cbr,char *idb,char *kdec,char *lbarp) {
  int i_f2py=0;
  f2py_s_csydec_def[i_f2py++].data = cbr;
  f2py_s_csydec_def[i_f2py++].data = idb;
  f2py_s_csydec_def[i_f2py++].data = kdec;
  f2py_s_csydec_def[i_f2py++].data = lbarp;
}
extern void F_FUNC_US(f2pyinits_csydec,F2PYINITS_CSYDEC)(void(*)(char*,char*,char*,char*));
static void f2py_init_s_csydec(void) {
  F_FUNC_US(f2pyinits_csydec,F2PYINITS_CSYDEC)(f2py_setup_s_csydec);
}

static FortranDataDef f2py_res_prop_def[] = {
  {"amres",1,{{9}},NPY_DOUBLE},
  {"sig0",1,{{9}},NPY_DOUBLE},
  {"width",1,{{9}},NPY_DOUBLE},
  {"nampres",2,{{10,6}},NPY_STRING},
  {NULL}
};
static void f2py_setup_res_prop(char *amres,char *sig0,char *width,char *nampres) {
  int i_f2py=0;
  f2py_res_prop_def[i_f2py++].data = amres;
  f2py_res_prop_def[i_f2py++].data = sig0;
  f2py_res_prop_def[i_f2py++].data = width;
  f2py_res_prop_def[i_f2py++].data = nampres;
}
extern void F_FUNC_US(f2pyinitres_prop,F2PYINITRES_PROP)(void(*)(char*,char*,char*,char*));
static void f2py_init_res_prop(void) {
  F_FUNC_US(f2pyinitres_prop,F2PYINITRES_PROP)(f2py_setup_res_prop);
}

static FortranDataDef f2py_res_propp_def[] = {
  {"amresp",1,{{9}},NPY_DOUBLE},
  {"bgammap",1,{{9}},NPY_DOUBLE},
  {"widthp",1,{{9}},NPY_DOUBLE},
  {"ratiojp",1,{{9}},NPY_DOUBLE},
  {"nampresp",2,{{10,6}},NPY_STRING},
  {NULL}
};
static void f2py_setup_res_propp(char *amresp,char *bgammap,char *widthp,char *ratiojp,char *nampresp) {
  int i_f2py=0;
  f2py_res_propp_def[i_f2py++].data = amresp;
  f2py_res_propp_def[i_f2py++].data = bgammap;
  f2py_res_propp_def[i_f2py++].data = widthp;
  f2py_res_propp_def[i_f2py++].data = ratiojp;
  f2py_res_propp_def[i_f2py++].data = nampresp;
}
extern void F_FUNC_US(f2pyinitres_propp,F2PYINITRES_PROPP)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_res_propp(void) {
  F_FUNC_US(f2pyinitres_propp,F2PYINITRES_PROPP)(f2py_setup_res_propp);
}

static FortranDataDef f2py_res_propn_def[] = {
  {"amresn",1,{{9}},NPY_DOUBLE},
  {"bgamman",1,{{9}},NPY_DOUBLE},
  {"widthn",1,{{9}},NPY_DOUBLE},
  {"ratiojn",1,{{9}},NPY_DOUBLE},
  {"nampresn",2,{{10,6}},NPY_STRING},
  {NULL}
};
static void f2py_setup_res_propn(char *amresn,char *bgamman,char *widthn,char *ratiojn,char *nampresn) {
  int i_f2py=0;
  f2py_res_propn_def[i_f2py++].data = amresn;
  f2py_res_propn_def[i_f2py++].data = bgamman;
  f2py_res_propn_def[i_f2py++].data = widthn;
  f2py_res_propn_def[i_f2py++].data = ratiojn;
  f2py_res_propn_def[i_f2py++].data = nampresn;
}
extern void F_FUNC_US(f2pyinitres_propn,F2PYINITRES_PROPN)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_res_propn(void) {
  F_FUNC_US(f2pyinitres_propn,F2PYINITRES_PROPN)(f2py_setup_res_propn);
}

static FortranDataDef f2py_crranma4_def[] = {
  {"c",1,{{8}},NPY_DOUBLE},
  {"u",2,{{97,8}},NPY_DOUBLE},
  {"ijkl",1,{{8}},NPY_INT},
  {"i97",1,{{8}},NPY_INT},
  {"j97",1,{{8}},NPY_INT},
  {"ntot",1,{{8}},NPY_INT},
  {"ntot2",1,{{8}},NPY_INT},
  {"jseq",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_crranma4(char *c,char *u,char *ijkl,char *i97,char *j97,char *ntot,char *ntot2,char *jseq) {
  int i_f2py=0;
  f2py_crranma4_def[i_f2py++].data = c;
  f2py_crranma4_def[i_f2py++].data = u;
  f2py_crranma4_def[i_f2py++].data = ijkl;
  f2py_crranma4_def[i_f2py++].data = i97;
  f2py_crranma4_def[i_f2py++].data = j97;
  f2py_crranma4_def[i_f2py++].data = ntot;
  f2py_crranma4_def[i_f2py++].data = ntot2;
  f2py_crranma4_def[i_f2py++].data = jseq;
}
extern void F_FUNC(f2pyinitcrranma4,F2PYINITCRRANMA4)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_crranma4(void) {
  F_FUNC(f2pyinitcrranma4,F2PYINITCRRANMA4)(f2py_setup_crranma4);
}

static FortranDataDef f2py_s_cnam_def[] = {
  {"namp",2,{{50,6}},NPY_STRING},
  {NULL}
};
static void f2py_setup_s_cnam(char *namp) {
  int i_f2py=0;
  f2py_s_cnam_def[i_f2py++].data = namp;
}
extern void F_FUNC_US(f2pyinits_cnam,F2PYINITS_CNAM)(void(*)(char*));
static void f2py_init_s_cnam(void) {
  F_FUNC_US(f2pyinits_cnam,F2PYINITS_CNAM)(f2py_setup_s_cnam);
}

static FortranDataDef f2py_s_resp_def[] = {
  {"cbrres1p",1,{{18}},NPY_DOUBLE},
  {"cbrres2p",1,{{36}},NPY_DOUBLE},
  {"cbrres3p",1,{{26}},NPY_DOUBLE},
  {"reslimp",1,{{36}},NPY_DOUBLE},
  {"elimitsp",1,{{9}},NPY_DOUBLE},
  {"kdecres1p",1,{{90}},NPY_INT},
  {"kdecres2p",1,{{180}},NPY_INT},
  {"kdecres3p",1,{{130}},NPY_INT},
  {"idbres1p",1,{{9}},NPY_INT},
  {"idbres2p",1,{{9}},NPY_INT},
  {"idbres3p",1,{{9}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_resp(char *cbrres1p,char *cbrres2p,char *cbrres3p,char *reslimp,char *elimitsp,char *kdecres1p,char *kdecres2p,char *kdecres3p,char *idbres1p,char *idbres2p,char *idbres3p) {
  int i_f2py=0;
  f2py_s_resp_def[i_f2py++].data = cbrres1p;
  f2py_s_resp_def[i_f2py++].data = cbrres2p;
  f2py_s_resp_def[i_f2py++].data = cbrres3p;
  f2py_s_resp_def[i_f2py++].data = reslimp;
  f2py_s_resp_def[i_f2py++].data = elimitsp;
  f2py_s_resp_def[i_f2py++].data = kdecres1p;
  f2py_s_resp_def[i_f2py++].data = kdecres2p;
  f2py_s_resp_def[i_f2py++].data = kdecres3p;
  f2py_s_resp_def[i_f2py++].data = idbres1p;
  f2py_s_resp_def[i_f2py++].data = idbres2p;
  f2py_s_resp_def[i_f2py++].data = idbres3p;
}
extern void F_FUNC_US(f2pyinits_resp,F2PYINITS_RESP)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_s_resp(void) {
  F_FUNC_US(f2pyinits_resp,F2PYINITS_RESP)(f2py_setup_s_resp);
}

static FortranDataDef f2py_s_resn_def[] = {
  {"cbrres1n",1,{{18}},NPY_DOUBLE},
  {"cbrres2n",1,{{36}},NPY_DOUBLE},
  {"cbrres3n",1,{{22}},NPY_DOUBLE},
  {"reslimn",1,{{36}},NPY_DOUBLE},
  {"elimitsn",1,{{9}},NPY_DOUBLE},
  {"kdecres1n",1,{{90}},NPY_INT},
  {"kdecres2n",1,{{180}},NPY_INT},
  {"kdecres3n",1,{{110}},NPY_INT},
  {"idbres1n",1,{{9}},NPY_INT},
  {"idbres2n",1,{{9}},NPY_INT},
  {"idbres3n",1,{{9}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_resn(char *cbrres1n,char *cbrres2n,char *cbrres3n,char *reslimn,char *elimitsn,char *kdecres1n,char *kdecres2n,char *kdecres3n,char *idbres1n,char *idbres2n,char *idbres3n) {
  int i_f2py=0;
  f2py_s_resn_def[i_f2py++].data = cbrres1n;
  f2py_s_resn_def[i_f2py++].data = cbrres2n;
  f2py_s_resn_def[i_f2py++].data = cbrres3n;
  f2py_s_resn_def[i_f2py++].data = reslimn;
  f2py_s_resn_def[i_f2py++].data = elimitsn;
  f2py_s_resn_def[i_f2py++].data = kdecres1n;
  f2py_s_resn_def[i_f2py++].data = kdecres2n;
  f2py_s_resn_def[i_f2py++].data = kdecres3n;
  f2py_s_resn_def[i_f2py++].data = idbres1n;
  f2py_s_resn_def[i_f2py++].data = idbres2n;
  f2py_s_resn_def[i_f2py++].data = idbres3n;
}
extern void F_FUNC_US(f2pyinits_resn,F2PYINITS_RESN)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_s_resn(void) {
  F_FUNC_US(f2pyinits_resn,F2PYINITS_RESN)(f2py_setup_s_resn);
}

static FortranDataDef f2py_res_flag_def[] = {
  {"fres",1,{{49}},NPY_DOUBLE},
  {"xlimres",1,{{49}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_res_flag(char *fres,char *xlimres) {
  int i_f2py=0;
  f2py_res_flag_def[i_f2py++].data = fres;
  f2py_res_flag_def[i_f2py++].data = xlimres;
}
extern void F_FUNC_US(f2pyinitres_flag,F2PYINITRES_FLAG)(void(*)(char*,char*));
static void f2py_init_res_flag(void) {
  F_FUNC_US(f2pyinitres_flag,F2PYINITRES_FLAG)(f2py_setup_res_flag);
}

static FortranDataDef f2py_s_czdis_def[] = {
  {"fa",0,{{-1}},NPY_DOUBLE},
  {"fb0",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_czdis(char *fa,char *fb0) {
  int i_f2py=0;
  f2py_s_czdis_def[i_f2py++].data = fa;
  f2py_s_czdis_def[i_f2py++].data = fb0;
}
extern void F_FUNC_US(f2pyinits_czdis,F2PYINITS_CZDIS)(void(*)(char*,char*));
static void f2py_init_s_czdis(void) {
  F_FUNC_US(f2pyinits_czdis,F2PYINITS_CZDIS)(f2py_setup_s_czdis);
}

static FortranDataDef f2py_s_czdiss_def[] = {
  {"fas1",0,{{-1}},NPY_DOUBLE},
  {"fas2",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_czdiss(char *fas1,char *fas2) {
  int i_f2py=0;
  f2py_s_czdiss_def[i_f2py++].data = fas1;
  f2py_s_czdiss_def[i_f2py++].data = fas2;
}
extern void F_FUNC_US(f2pyinits_czdiss,F2PYINITS_CZDISS)(void(*)(char*,char*));
static void f2py_init_s_czdiss(void) {
  F_FUNC_US(f2pyinits_czdiss,F2PYINITS_CZDISS)(f2py_setup_s_czdiss);
}

static FortranDataDef f2py_s_czlead_def[] = {
  {"clead",0,{{-1}},NPY_DOUBLE},
  {"flead",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_czlead(char *clead,char *flead) {
  int i_f2py=0;
  f2py_s_czlead_def[i_f2py++].data = clead;
  f2py_s_czlead_def[i_f2py++].data = flead;
}
extern void F_FUNC_US(f2pyinits_czlead,F2PYINITS_CZLEAD)(void(*)(char*,char*));
static void f2py_init_s_czlead(void) {
  F_FUNC_US(f2pyinits_czlead,F2PYINITS_CZLEAD)(f2py_setup_s_czlead);
}

static FortranDataDef f2py_s_cpspl_def[] = {
  {"cchik",2,{{3,9}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_cpspl(char *cchik) {
  int i_f2py=0;
  f2py_s_cpspl_def[i_f2py++].data = cchik;
}
extern void F_FUNC_US(f2pyinits_cpspl,F2PYINITS_CPSPL)(void(*)(char*));
static void f2py_init_s_cpspl(void) {
  F_FUNC_US(f2pyinits_cpspl,F2PYINITS_CPSPL)(f2py_setup_s_cpspl);
}

static FortranDataDef f2py_s_cqdis_def[] = {
  {"ppt0",1,{{33}},NPY_DOUBLE},
  {"ptflag",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_cqdis(char *ppt0,char *ptflag) {
  int i_f2py=0;
  f2py_s_cqdis_def[i_f2py++].data = ppt0;
  f2py_s_cqdis_def[i_f2py++].data = ptflag;
}
extern void F_FUNC_US(f2pyinits_cqdis,F2PYINITS_CQDIS)(void(*)(char*,char*));
static void f2py_init_s_cqdis(void) {
  F_FUNC_US(f2pyinits_cqdis,F2PYINITS_CQDIS)(f2py_setup_s_cqdis);
}

static FortranDataDef f2py_s_cdif0_def[] = {
  {"ffd",0,{{-1}},NPY_DOUBLE},
  {"fbd",0,{{-1}},NPY_DOUBLE},
  {"fdd",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_cdif0(char *ffd,char *fbd,char *fdd) {
  int i_f2py=0;
  f2py_s_cdif0_def[i_f2py++].data = ffd;
  f2py_s_cdif0_def[i_f2py++].data = fbd;
  f2py_s_cdif0_def[i_f2py++].data = fdd;
}
extern void F_FUNC_US(f2pyinits_cdif0,F2PYINITS_CDIF0)(void(*)(char*,char*,char*));
static void f2py_init_s_cdif0(void) {
  F_FUNC_US(f2pyinits_cdif0,F2PYINITS_CDIF0)(f2py_setup_s_cdif0);
}

static FortranDataDef f2py_s_cflafr_def[] = {
  {"par",1,{{8}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_s_cflafr(char *par) {
  int i_f2py=0;
  f2py_s_cflafr_def[i_f2py++].data = par;
}
extern void F_FUNC_US(f2pyinits_cflafr,F2PYINITS_CFLAFR)(void(*)(char*));
static void f2py_init_s_cflafr(void) {
  F_FUNC_US(f2pyinits_cflafr,F2PYINITS_CFLAFR)(f2py_setup_s_cflafr);
}

static FortranDataDef f2py_ludat1_def[] = {
  {"mstu",1,{{200}},NPY_INT},
  {"paru",1,{{200}},NPY_DOUBLE},
  {"mstj",1,{{200}},NPY_INT},
  {"parj",1,{{200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ludat1(char *mstu,char *paru,char *mstj,char *parj) {
  int i_f2py=0;
  f2py_ludat1_def[i_f2py++].data = mstu;
  f2py_ludat1_def[i_f2py++].data = paru;
  f2py_ludat1_def[i_f2py++].data = mstj;
  f2py_ludat1_def[i_f2py++].data = parj;
}
extern void F_FUNC(f2pyinitludat1,F2PYINITLUDAT1)(void(*)(char*,char*,char*,char*));
static void f2py_init_ludat1(void) {
  F_FUNC(f2pyinitludat1,F2PYINITLUDAT1)(f2py_setup_ludat1);
}

static FortranDataDef f2py_ludat2_def[] = {
  {"kchg",2,{{500,3}},NPY_INT},
  {"pmas",2,{{500,4}},NPY_DOUBLE},
  {"parf",1,{{2000}},NPY_DOUBLE},
  {"vckm",2,{{4,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ludat2(char *kchg,char *pmas,char *parf,char *vckm) {
  int i_f2py=0;
  f2py_ludat2_def[i_f2py++].data = kchg;
  f2py_ludat2_def[i_f2py++].data = pmas;
  f2py_ludat2_def[i_f2py++].data = parf;
  f2py_ludat2_def[i_f2py++].data = vckm;
}
extern void F_FUNC(f2pyinitludat2,F2PYINITLUDAT2)(void(*)(char*,char*,char*,char*));
static void f2py_init_ludat2(void) {
  F_FUNC(f2pyinitludat2,F2PYINITLUDAT2)(f2py_setup_ludat2);
}

static FortranDataDef f2py_ludat3_def[] = {
  {"mdcy",2,{{500,3}},NPY_INT},
  {"mdme",2,{{2000,2}},NPY_INT},
  {"brat",1,{{2000}},NPY_DOUBLE},
  {"kfdp",2,{{2000,5}},NPY_INT},
  {NULL}
};
static void f2py_setup_ludat3(char *mdcy,char *mdme,char *brat,char *kfdp) {
  int i_f2py=0;
  f2py_ludat3_def[i_f2py++].data = mdcy;
  f2py_ludat3_def[i_f2py++].data = mdme;
  f2py_ludat3_def[i_f2py++].data = brat;
  f2py_ludat3_def[i_f2py++].data = kfdp;
}
extern void F_FUNC(f2pyinitludat3,F2PYINITLUDAT3)(void(*)(char*,char*,char*,char*));
static void f2py_init_ludat3(void) {
  F_FUNC(f2pyinitludat3,F2PYINITLUDAT3)(f2py_setup_ludat3);
}

static FortranDataDef f2py_ludat4_def[] = {
  {"chaf",2,{{500,8}},NPY_STRING},
  {NULL}
};
static void f2py_setup_ludat4(char *chaf) {
  int i_f2py=0;
  f2py_ludat4_def[i_f2py++].data = chaf;
}
extern void F_FUNC(f2pyinitludat4,F2PYINITLUDAT4)(void(*)(char*));
static void f2py_init_ludat4(void) {
  F_FUNC(f2pyinitludat4,F2PYINITLUDAT4)(f2py_setup_ludat4);
}

static FortranDataDef f2py_ludatr_def[] = {
  {"mrlu",1,{{6}},NPY_INT},
  {"rrlu",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ludatr(char *mrlu,char *rrlu) {
  int i_f2py=0;
  f2py_ludatr_def[i_f2py++].data = mrlu;
  f2py_ludatr_def[i_f2py++].data = rrlu;
}
extern void F_FUNC(f2pyinitludatr,F2PYINITLUDATR)(void(*)(char*,char*));
static void f2py_init_ludatr(void) {
  F_FUNC(f2pyinitludatr,F2PYINITLUDATR)(f2py_setup_ludatr);
}

static FortranDataDef f2py_s_plist1_def[] = {
  {"llist1",1,{{2000}},NPY_INT},
  {NULL}
};
static void f2py_setup_s_plist1(char *llist1) {
  int i_f2py=0;
  f2py_s_plist1_def[i_f2py++].data = llist1;
}
extern void F_FUNC_US(f2pyinits_plist1,F2PYINITS_PLIST1)(void(*)(char*));
static void f2py_init_s_plist1(void) {
  F_FUNC_US(f2pyinits_plist1,F2PYINITS_PLIST1)(f2py_setup_s_plist1);
}

static FortranDataDef f2py_hepevt_def[] = {
  {"nevhep",0,{{-1}},NPY_INT},
  {"nhep",0,{{-1}},NPY_INT},
  {"isthep",1,{{2000}},NPY_INT},
  {"idhep",1,{{2000}},NPY_INT},
  {"jmohep",2,{{2,2000}},NPY_INT},
  {"jdahep",2,{{2,2000}},NPY_INT},
  {"phep",2,{{5,2000}},NPY_DOUBLE},
  {"vhep",2,{{4,2000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepevt(char *nevhep,char *nhep,char *isthep,char *idhep,char *jmohep,char *jdahep,char *phep,char *vhep) {
  int i_f2py=0;
  f2py_hepevt_def[i_f2py++].data = nevhep;
  f2py_hepevt_def[i_f2py++].data = nhep;
  f2py_hepevt_def[i_f2py++].data = isthep;
  f2py_hepevt_def[i_f2py++].data = idhep;
  f2py_hepevt_def[i_f2py++].data = jmohep;
  f2py_hepevt_def[i_f2py++].data = jdahep;
  f2py_hepevt_def[i_f2py++].data = phep;
  f2py_hepevt_def[i_f2py++].data = vhep;
}
extern void F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepevt(void) {
  F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(f2py_setup_hepevt);
}

static FortranDataDef f2py_schg_def[] = {
  {"ichg",1,{{2000}},NPY_INT},
  {"iparnt",1,{{2000}},NPY_INT},
  {NULL}
};
static void f2py_setup_schg(char *ichg,char *iparnt) {
  int i_f2py=0;
  f2py_schg_def[i_f2py++].data = ichg;
  f2py_schg_def[i_f2py++].data = iparnt;
}
extern void F_FUNC(f2pyinitschg,F2PYINITSCHG)(void(*)(char*,char*));
static void f2py_init_schg(void) {
  F_FUNC(f2pyinitschg,F2PYINITSCHG)(f2py_setup_schg);
}

static FortranDataDef f2py_npy_def[] = {
  {"bitgen",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_npy(char *bitgen) {
  int i_f2py=0;
  f2py_npy_def[i_f2py++].data = bitgen;
}
extern void F_FUNC(f2pyinitnpy,F2PYINITNPY)(void(*)(char*));
static void f2py_init_npy(void) {
  F_FUNC(f2pyinitnpy,F2PYINITNPY)(f2py_setup_npy);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"eventgen",-1,{{-1}},0,(char *)F_FUNC(eventgen,EVENTGEN),(f2py_init_func)f2py_rout__sophia_eventgen,doc_f2py_rout__sophia_eventgen},
  {"crossection",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(crossection,CROSSECTION),(f2py_init_func)f2py_rout__sophia_crossection,doc_f2py_rout__sophia_crossection},
  {"print_event",-1,{{-1}},0,(char *)F_FUNC_US(print_event,PRINT_EVENT),(f2py_init_func)f2py_rout__sophia_print_event,doc_f2py_rout__sophia_print_event},
  {"icon_pdg_sib",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(icon_pdg_sib,ICON_PDG_SIB),(f2py_init_func)f2py_rout__sophia_icon_pdg_sib,doc_f2py_rout__sophia_icon_pdg_sib},
  {"initial",-1,{{-1}},0,(char *)F_FUNC(initial,INITIAL),(f2py_init_func)f2py_rout__sophia_initial,doc_f2py_rout__sophia_initial},
  {"toevt",-1,{{-1}},0,(char *)F_FUNC(toevt,TOEVT),(f2py_init_func)f2py_rout__sophia_toevt,doc_f2py_rout__sophia_toevt},
  {"chromo_openlogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE),(f2py_init_func)f2py_rout__sophia_chromo_openlogfile,doc_f2py_rout__sophia_chromo_openlogfile},
  {"chromo_closelogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE),(f2py_init_func)f2py_rout__sophia_chromo_closelogfile,doc_f2py_rout__sophia_chromo_closelogfile},
  {"npyrng",-1,{{-1}},0,(char *)F_FUNC(npyrng,NPYRNG),(f2py_init_func)f2py_rout__sophia_npyrng,doc_f2py_rout__sophia_npyrng},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_sophia",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__sophia(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = _sophia_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _sophia (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module '_sophia' is auto-generated with f2py (version:2).\nFunctions:\n"
"  imode = eventgen(l0,e0,eps,theta)\n"
"  crossection = crossection(x,ndir,nl0)\n"
"  print_event(iout)\n"
"  icon_pdg_sib = icon_pdg_sib(id)\n"
"  initial(l0)\n"
"  toevt()\n"
"  chromo_openlogfile(fname,opunit)\n"
"  chromo_closelogfile(opunit)\n"
"  npyrng(rval)\n"
"COMMON blocks:\n""  /eg_io/ keepdc\n""  /s_run/ sqs,s,q2min,xmin,zmin,kb,kt,a1,a2,nproc\n""  /s_plist/ p(2000,5),llist(2000),np,ideb\n""  /s_mass1/ am(49),am2(49)\n""  /s_chp/ s_life(49),ichp(49),istr(49),ibar(49)\n""  /s_csydec/ cbr(102),idb(49),kdec(612),lbarp(49)\n""  /res_prop/ amres(9),sig0(9),width(9),nampres(10,6)\n""  /res_propp/ amresp(9),bgammap(9),widthp(9),ratiojp(9),nampresp(10,6)\n""  /res_propn/ amresn(9),bgamman(9),widthn(9),ratiojn(9),nampresn(10,6)\n""  /crranma4/ c(8),u(97,8),ijkl(8),i97(8),j97(8),ntot(8),ntot2(8),jseq\n""  /s_cnam/ namp(50,6)\n""  /s_resp/ cbrres1p(18),cbrres2p(36),cbrres3p(26),reslimp(36),elimitsp(9),kdecres1p(90),kdecres2p(180),kdecres3p(130),idbres1p(9),idbres2p(9),idbres3p(9)\n""  /s_resn/ cbrres1n(18),cbrres2n(36),cbrres3n(22),reslimn(36),elimitsn(9),kdecres1n(90),kdecres2n(180),kdecres3n(110),idbres1n(9),idbres2n(9),idbres3n(9)\n""  /res_flag/ fres(49),xlimres(49)\n""  /s_czdis/ fa,fb0\n""  /s_czdiss/ fas1,fas2\n""  /s_czlead/ clead,flead\n""  /s_cpspl/ cchik(3,9)\n""  /s_cqdis/ ppt0(33),ptflag\n""  /s_cdif0/ ffd,fbd,fdd\n""  /s_cflafr/ par(8)\n""  /ludat1/ mstu(200),paru(200),mstj(200),parj(200)\n""  /ludat2/ kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)\n""  /ludat3/ mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)\n""  /ludat4/ chaf(500,8)\n""  /ludatr/ mrlu(6),rrlu(100)\n""  /s_plist1/ llist1(2000)\n""  /hepevt/ nevhep,nhep,isthep(2000),idhep(2000),jmohep(2,2000),jdahep(2,2000),phep(5,2000),vhep(4,2000)\n""  /schg/ ichg(2000),iparnt(2000)\n""  /npy/ bitgen\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _sophia_error = PyErr_NewException ("_sophia.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__sophia_error", _sophia_error);
  Py_DECREF(_sophia_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }


    {
      extern double F_FUNC(crossection,CROSSECTION)(void);
      PyObject* o = PyDict_GetItemString(d,"crossection");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(crossection,CROSSECTION),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("crossection");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    


    {
      extern int F_FUNC_US(icon_pdg_sib,ICON_PDG_SIB)(void);
      PyObject* o = PyDict_GetItemString(d,"icon_pdg_sib");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(icon_pdg_sib,ICON_PDG_SIB),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("icon_pdg_sib");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    





/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_eg_io_def,f2py_init_eg_io);
  F2PyDict_SetItemString(d, "eg_io", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_run_def,f2py_init_s_run);
  F2PyDict_SetItemString(d, "s_run", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_plist_def,f2py_init_s_plist);
  F2PyDict_SetItemString(d, "s_plist", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_mass1_def,f2py_init_s_mass1);
  F2PyDict_SetItemString(d, "s_mass1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_chp_def,f2py_init_s_chp);
  F2PyDict_SetItemString(d, "s_chp", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_csydec_def,f2py_init_s_csydec);
  F2PyDict_SetItemString(d, "s_csydec", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_res_prop_def,f2py_init_res_prop);
  F2PyDict_SetItemString(d, "res_prop", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_res_propp_def,f2py_init_res_propp);
  F2PyDict_SetItemString(d, "res_propp", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_res_propn_def,f2py_init_res_propn);
  F2PyDict_SetItemString(d, "res_propn", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_crranma4_def,f2py_init_crranma4);
  F2PyDict_SetItemString(d, "crranma4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cnam_def,f2py_init_s_cnam);
  F2PyDict_SetItemString(d, "s_cnam", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_resp_def,f2py_init_s_resp);
  F2PyDict_SetItemString(d, "s_resp", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_resn_def,f2py_init_s_resn);
  F2PyDict_SetItemString(d, "s_resn", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_res_flag_def,f2py_init_res_flag);
  F2PyDict_SetItemString(d, "res_flag", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_czdis_def,f2py_init_s_czdis);
  F2PyDict_SetItemString(d, "s_czdis", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_czdiss_def,f2py_init_s_czdiss);
  F2PyDict_SetItemString(d, "s_czdiss", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_czlead_def,f2py_init_s_czlead);
  F2PyDict_SetItemString(d, "s_czlead", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cpspl_def,f2py_init_s_cpspl);
  F2PyDict_SetItemString(d, "s_cpspl", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cqdis_def,f2py_init_s_cqdis);
  F2PyDict_SetItemString(d, "s_cqdis", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cdif0_def,f2py_init_s_cdif0);
  F2PyDict_SetItemString(d, "s_cdif0", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_cflafr_def,f2py_init_s_cflafr);
  F2PyDict_SetItemString(d, "s_cflafr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ludat1_def,f2py_init_ludat1);
  F2PyDict_SetItemString(d, "ludat1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ludat2_def,f2py_init_ludat2);
  F2PyDict_SetItemString(d, "ludat2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ludat3_def,f2py_init_ludat3);
  F2PyDict_SetItemString(d, "ludat3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ludat4_def,f2py_init_ludat4);
  F2PyDict_SetItemString(d, "ludat4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ludatr_def,f2py_init_ludatr);
  F2PyDict_SetItemString(d, "ludatr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_s_plist1_def,f2py_init_s_plist1);
  F2PyDict_SetItemString(d, "s_plist1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepevt_def,f2py_init_hepevt);
  F2PyDict_SetItemString(d, "hepevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_schg_def,f2py_init_schg);
  F2PyDict_SetItemString(d, "schg", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_npy_def,f2py_init_npy);
  F2PyDict_SetItemString(d, "npy", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_sophia");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
