/* File: _urqmd34module.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Mon Jan 16 17:31:13 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_urqmd34_error;
static PyObject *_urqmd34_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _urqmd34_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _urqmd34_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _urqmd34_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC_US(norm_init,NORM_INIT)(void);
extern void F_FUNC(loginit,LOGINIT)(void);
extern void F_WRAPPEDFUNC(partname,PARTNAME)(string,int*,size_t);
extern void F_FUNC(output,OUTPUT)(int*);
extern void F_FUNC(uounit,UOUNIT)(int*,int*);
extern void F_FUNC(file14out,FILE14OUT)(int*);
extern void F_FUNC(file13out,FILE13OUT)(int*);
extern void F_FUNC(file15out,FILE15OUT)(int*,int*,double*,double*,double*);
extern void F_FUNC(f15outch,F15OUTCH)(double*);
extern void F_FUNC(f15hyin,F15HYIN)(double*);
extern void F_FUNC(f15hyout,F15HYOUT)(double*,double*);
extern void F_FUNC(f15outhy,F15OUTHY)(double*,double*);
extern void F_FUNC(f16outch,F16OUTCH)(void);
extern void F_FUNC(file16out,FILE16OUT)(void);
extern void F_FUNC(file16entry,FILE16ENTRY)(int*);
extern void F_FUNC(file16write,FILE16WRITE)(void);
extern void F_FUNC_US(osc_header,OSC_HEADER)(void);
extern void F_FUNC_US(osc99_header,OSC99_HEADER)(void);
extern void F_FUNC_US(osc_event,OSC_EVENT)(void);
extern void F_FUNC_US(osc_vis,OSC_VIS)(int*);
extern void F_FUNC_US(osc99_event,OSC99_EVENT)(int*);
extern void F_FUNC_US(osc99_coll,OSC99_COLL)(void);
extern void F_FUNC_US(osc99_eoe,OSC99_EOE)(void);
extern void F_FUNC(getoldevent,GETOLDEVENT)(void);
extern void F_FUNC(specout,SPECOUT)(int*,int*);
extern void F_WRAPPEDFUNC(ptsigtot,PTSIGTOT)(double*);
extern void F_FUNC(strini,STRINI)(void);
extern void F_FUNC(urqmd,URQMD)(int*);
extern void F_FUNC(init,INIT)(void);
extern void F_FUNC(loadwtab,LOADWTAB)(int*);
extern void F_FUNC(cascinit,CASCINIT)(int*,int*,int*);
extern void F_WRAPPEDFUNC(nucrad,NUCRAD)(double*,int*);
extern void F_FUNC(params,PARAMS)(void);
extern void F_FUNC(set0,SET0)(void);
extern void F_FUNC(urqini,URQINI)(int*,int*);
extern void F_FUNC(chepevt,CHEPEVT)(void);
extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t);
extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*);
extern void F_FUNC(npyrng,NPYRNG)(double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************************* norm_init *********************************/
static char doc_f2py_rout__urqmd34_norm_init[] = "\
norm_init()\n\nWrapper for ``norm_init``.\
\n";
/* extern void F_FUNC_US(norm_init,NORM_INIT)(void); */
static PyObject *f2py_rout__urqmd34_norm_init(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.norm_init",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of norm_init ******************************/

/********************************** loginit **********************************/
static char doc_f2py_rout__urqmd34_loginit[] = "\
loginit()\n\nWrapper for ``loginit``.\
\n";
/* extern void F_FUNC(loginit,LOGINIT)(void); */
static PyObject *f2py_rout__urqmd34_loginit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.loginit",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of loginit *******************************/

/********************************** partname **********************************/
static char doc_f2py_rout__urqmd34_partname[] = "\
partname = partname(ityp)\n\nWrapper for ``partname``.\
\n\nParameters\n----------\n"
"ityp : input int\n"
"\nReturns\n-------\n"
"partname : string(len=15)";
/* extern void F_WRAPPEDFUNC(partname,PARTNAME)(string,int*,size_t); */
static PyObject *f2py_rout__urqmd34_partname(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string partname = NULL;
  int slen(partname);
  PyObject *partname_capi = Py_None;
  int ityp = 0;
  PyObject *ityp_capi = Py_None;
  static char *capi_kwlist[] = {"ityp",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.partname",\
    capi_kwlist,&ityp_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ityp */
    f2py_success = int_from_pyobj(&ityp,ityp_capi,"_urqmd34.partname() 1st argument (ityp) can't be converted to int");
  if (f2py_success) {
  /* Processing variable partname */
  slen(partname) = 15;
  f2py_success = string_from_pyobj(&partname,&slen(partname),"",partname_capi,"string_from_pyobj failed in converting hidden `partname' of _urqmd34.partname to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(partname,&ityp,slen(partname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("y",partname);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(partname);
  }  /*if (f2py_success) of partname*/
  /* End of cleaning variable partname */
  } /*if (f2py_success) of ityp*/
  /* End of cleaning variable ityp */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of partname ******************************/

/*********************************** output ***********************************/
static char doc_f2py_rout__urqmd34_output[] = "\
output(iunit)\n\nWrapper for ``output``.\
\n\nParameters\n----------\n"
"iunit : input int";
/* extern void F_FUNC(output,OUTPUT)(int*); */
static PyObject *f2py_rout__urqmd34_output(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iunit = 0;
  PyObject *iunit_capi = Py_None;
  static char *capi_kwlist[] = {"iunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.output",\
    capi_kwlist,&iunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iunit */
    f2py_success = int_from_pyobj(&iunit,iunit_capi,"_urqmd34.output() 1st argument (iunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iunit*/
  /* End of cleaning variable iunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of output *******************************/

/*********************************** uounit ***********************************/
static char doc_f2py_rout__urqmd34_uounit[] = "\
uounit(iiunit,isunit)\n\nWrapper for ``uounit``.\
\n\nParameters\n----------\n"
"iiunit : input int\n"
"isunit : input int";
/* extern void F_FUNC(uounit,UOUNIT)(int*,int*); */
static PyObject *f2py_rout__urqmd34_uounit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iiunit = 0;
  PyObject *iiunit_capi = Py_None;
  int isunit = 0;
  PyObject *isunit_capi = Py_None;
  static char *capi_kwlist[] = {"iiunit","isunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_urqmd34.uounit",\
    capi_kwlist,&iiunit_capi,&isunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iiunit */
    f2py_success = int_from_pyobj(&iiunit,iiunit_capi,"_urqmd34.uounit() 1st argument (iiunit) can't be converted to int");
  if (f2py_success) {
  /* Processing variable isunit */
    f2py_success = int_from_pyobj(&isunit,isunit_capi,"_urqmd34.uounit() 2nd argument (isunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iiunit,&isunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of isunit*/
  /* End of cleaning variable isunit */
  } /*if (f2py_success) of iiunit*/
  /* End of cleaning variable iiunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of uounit *******************************/

/********************************* file14out *********************************/
static char doc_f2py_rout__urqmd34_file14out[] = "\
file14out(timestep)\n\nWrapper for ``file14out``.\
\n\nParameters\n----------\n"
"timestep : input int";
/* extern void F_FUNC(file14out,FILE14OUT)(int*); */
static PyObject *f2py_rout__urqmd34_file14out(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int timestep = 0;
  PyObject *timestep_capi = Py_None;
  static char *capi_kwlist[] = {"timestep",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.file14out",\
    capi_kwlist,&timestep_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable timestep */
    f2py_success = int_from_pyobj(&timestep,timestep_capi,"_urqmd34.file14out() 1st argument (timestep) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&timestep);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of timestep*/
  /* End of cleaning variable timestep */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of file14out ******************************/

/********************************* file13out *********************************/
static char doc_f2py_rout__urqmd34_file13out[] = "\
file13out(timestep)\n\nWrapper for ``file13out``.\
\n\nParameters\n----------\n"
"timestep : input int";
/* extern void F_FUNC(file13out,FILE13OUT)(int*); */
static PyObject *f2py_rout__urqmd34_file13out(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int timestep = 0;
  PyObject *timestep_capi = Py_None;
  static char *capi_kwlist[] = {"timestep",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.file13out",\
    capi_kwlist,&timestep_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable timestep */
    f2py_success = int_from_pyobj(&timestep,timestep_capi,"_urqmd34.file13out() 1st argument (timestep) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&timestep);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of timestep*/
  /* End of cleaning variable timestep */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of file13out ******************************/

/********************************* file15out *********************************/
static char doc_f2py_rout__urqmd34_file15out[] = "\
file15out(ind1,ind2,sqrts,stot,sigpart)\n\nWrapper for ``file15out``.\
\n\nParameters\n----------\n"
"ind1 : input int\n"
"ind2 : input int\n"
"sqrts : input float\n"
"stot : input float\n"
"sigpart : input float";
/* extern void F_FUNC(file15out,FILE15OUT)(int*,int*,double*,double*,double*); */
static PyObject *f2py_rout__urqmd34_file15out(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int ind1 = 0;
  PyObject *ind1_capi = Py_None;
  int ind2 = 0;
  PyObject *ind2_capi = Py_None;
  double sqrts = 0;
  PyObject *sqrts_capi = Py_None;
  double stot = 0;
  PyObject *stot_capi = Py_None;
  double sigpart = 0;
  PyObject *sigpart_capi = Py_None;
  static char *capi_kwlist[] = {"ind1","ind2","sqrts","stot","sigpart",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|:_urqmd34.file15out",\
    capi_kwlist,&ind1_capi,&ind2_capi,&sqrts_capi,&stot_capi,&sigpart_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable stot */
    f2py_success = double_from_pyobj(&stot,stot_capi,"_urqmd34.file15out() 4th argument (stot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ind1 */
    f2py_success = int_from_pyobj(&ind1,ind1_capi,"_urqmd34.file15out() 1st argument (ind1) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ind2 */
    f2py_success = int_from_pyobj(&ind2,ind2_capi,"_urqmd34.file15out() 2nd argument (ind2) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sqrts */
    f2py_success = double_from_pyobj(&sqrts,sqrts_capi,"_urqmd34.file15out() 3rd argument (sqrts) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sigpart */
    f2py_success = double_from_pyobj(&sigpart,sigpart_capi,"_urqmd34.file15out() 5th argument (sigpart) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ind1,&ind2,&sqrts,&stot,&sigpart);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of sigpart*/
  /* End of cleaning variable sigpart */
  } /*if (f2py_success) of sqrts*/
  /* End of cleaning variable sqrts */
  } /*if (f2py_success) of ind2*/
  /* End of cleaning variable ind2 */
  } /*if (f2py_success) of ind1*/
  /* End of cleaning variable ind1 */
  } /*if (f2py_success) of stot*/
  /* End of cleaning variable stot */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of file15out ******************************/

/********************************** f15outch **********************************/
static char doc_f2py_rout__urqmd34_f15outch[] = "\
f15outch(colldens)\n\nWrapper for ``f15outch``.\
\n\nParameters\n----------\n"
"colldens : input float";
/* extern void F_FUNC(f15outch,F15OUTCH)(double*); */
static PyObject *f2py_rout__urqmd34_f15outch(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double colldens = 0;
  PyObject *colldens_capi = Py_None;
  static char *capi_kwlist[] = {"colldens",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.f15outch",\
    capi_kwlist,&colldens_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable colldens */
    f2py_success = double_from_pyobj(&colldens,colldens_capi,"_urqmd34.f15outch() 1st argument (colldens) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&colldens);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of colldens*/
  /* End of cleaning variable colldens */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of f15outch ******************************/

/********************************** f15hyin **********************************/
static char doc_f2py_rout__urqmd34_f15hyin[] = "\
f15hyin(thydro_start)\n\nWrapper for ``f15hyin``.\
\n\nParameters\n----------\n"
"thydro_start : input float";
/* extern void F_FUNC(f15hyin,F15HYIN)(double*); */
static PyObject *f2py_rout__urqmd34_f15hyin(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double thydro_start = 0;
  PyObject *thydro_start_capi = Py_None;
  static char *capi_kwlist[] = {"thydro_start",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.f15hyin",\
    capi_kwlist,&thydro_start_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable thydro_start */
    f2py_success = double_from_pyobj(&thydro_start,thydro_start_capi,"_urqmd34.f15hyin() 1st argument (thydro_start) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&thydro_start);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of thydro_start*/
  /* End of cleaning variable thydro_start */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of f15hyin *******************************/

/********************************** f15hyout **********************************/
static char doc_f2py_rout__urqmd34_f15hyout[] = "\
f15hyout(thydro_start,thydro)\n\nWrapper for ``f15hyout``.\
\n\nParameters\n----------\n"
"thydro_start : input float\n"
"thydro : input float";
/* extern void F_FUNC(f15hyout,F15HYOUT)(double*,double*); */
static PyObject *f2py_rout__urqmd34_f15hyout(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double thydro_start = 0;
  PyObject *thydro_start_capi = Py_None;
  double thydro = 0;
  PyObject *thydro_capi = Py_None;
  static char *capi_kwlist[] = {"thydro_start","thydro",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_urqmd34.f15hyout",\
    capi_kwlist,&thydro_start_capi,&thydro_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable thydro_start */
    f2py_success = double_from_pyobj(&thydro_start,thydro_start_capi,"_urqmd34.f15hyout() 1st argument (thydro_start) can't be converted to double");
  if (f2py_success) {
  /* Processing variable thydro */
    f2py_success = double_from_pyobj(&thydro,thydro_capi,"_urqmd34.f15hyout() 2nd argument (thydro) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&thydro_start,&thydro);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of thydro*/
  /* End of cleaning variable thydro */
  } /*if (f2py_success) of thydro_start*/
  /* End of cleaning variable thydro_start */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of f15hyout ******************************/

/********************************** f15outhy **********************************/
static char doc_f2py_rout__urqmd34_f15outhy[] = "\
f15outhy(thydro_start,thydro)\n\nWrapper for ``f15outhy``.\
\n\nParameters\n----------\n"
"thydro_start : input float\n"
"thydro : input float";
/* extern void F_FUNC(f15outhy,F15OUTHY)(double*,double*); */
static PyObject *f2py_rout__urqmd34_f15outhy(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double thydro_start = 0;
  PyObject *thydro_start_capi = Py_None;
  double thydro = 0;
  PyObject *thydro_capi = Py_None;
  static char *capi_kwlist[] = {"thydro_start","thydro",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_urqmd34.f15outhy",\
    capi_kwlist,&thydro_start_capi,&thydro_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable thydro_start */
    f2py_success = double_from_pyobj(&thydro_start,thydro_start_capi,"_urqmd34.f15outhy() 1st argument (thydro_start) can't be converted to double");
  if (f2py_success) {
  /* Processing variable thydro */
    f2py_success = double_from_pyobj(&thydro,thydro_capi,"_urqmd34.f15outhy() 2nd argument (thydro) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&thydro_start,&thydro);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of thydro*/
  /* End of cleaning variable thydro */
  } /*if (f2py_success) of thydro_start*/
  /* End of cleaning variable thydro_start */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of f15outhy ******************************/

/********************************** f16outch **********************************/
static char doc_f2py_rout__urqmd34_f16outch[] = "\
f16outch()\n\nWrapper for ``f16outch``.\
\n";
/* extern void F_FUNC(f16outch,F16OUTCH)(void); */
static PyObject *f2py_rout__urqmd34_f16outch(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.f16outch",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of f16outch ******************************/

/********************************* file16out *********************************/
static char doc_f2py_rout__urqmd34_file16out[] = "\
file16out()\n\nWrapper for ``file16out``.\
\n";
/* extern void F_FUNC(file16out,FILE16OUT)(void); */
static PyObject *f2py_rout__urqmd34_file16out(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.file16out",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of file16out ******************************/

/******************************** file16entry ********************************/
static char doc_f2py_rout__urqmd34_file16entry[] = "\
file16entry(ind)\n\nWrapper for ``file16entry``.\
\n\nParameters\n----------\n"
"ind : input int";
/* extern void F_FUNC(file16entry,FILE16ENTRY)(int*); */
static PyObject *f2py_rout__urqmd34_file16entry(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int ind = 0;
  PyObject *ind_capi = Py_None;
  static char *capi_kwlist[] = {"ind",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.file16entry",\
    capi_kwlist,&ind_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ind */
    f2py_success = int_from_pyobj(&ind,ind_capi,"_urqmd34.file16entry() 1st argument (ind) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ind);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ind*/
  /* End of cleaning variable ind */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of file16entry *****************************/

/******************************** file16write ********************************/
static char doc_f2py_rout__urqmd34_file16write[] = "\
file16write()\n\nWrapper for ``file16write``.\
\n";
/* extern void F_FUNC(file16write,FILE16WRITE)(void); */
static PyObject *f2py_rout__urqmd34_file16write(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.file16write",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of file16write *****************************/

/********************************* osc_header *********************************/
static char doc_f2py_rout__urqmd34_osc_header[] = "\
osc_header()\n\nWrapper for ``osc_header``.\
\n";
/* extern void F_FUNC_US(osc_header,OSC_HEADER)(void); */
static PyObject *f2py_rout__urqmd34_osc_header(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.osc_header",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of osc_header *****************************/

/******************************** osc99_header ********************************/
static char doc_f2py_rout__urqmd34_osc99_header[] = "\
osc99_header()\n\nWrapper for ``osc99_header``.\
\n";
/* extern void F_FUNC_US(osc99_header,OSC99_HEADER)(void); */
static PyObject *f2py_rout__urqmd34_osc99_header(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.osc99_header",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of osc99_header ****************************/

/********************************* osc_event *********************************/
static char doc_f2py_rout__urqmd34_osc_event[] = "\
osc_event()\n\nWrapper for ``osc_event``.\
\n";
/* extern void F_FUNC_US(osc_event,OSC_EVENT)(void); */
static PyObject *f2py_rout__urqmd34_osc_event(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.osc_event",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of osc_event ******************************/

/********************************** osc_vis **********************************/
static char doc_f2py_rout__urqmd34_osc_vis[] = "\
osc_vis(timestep)\n\nWrapper for ``osc_vis``.\
\n\nParameters\n----------\n"
"timestep : input int";
/* extern void F_FUNC_US(osc_vis,OSC_VIS)(int*); */
static PyObject *f2py_rout__urqmd34_osc_vis(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int timestep = 0;
  PyObject *timestep_capi = Py_None;
  static char *capi_kwlist[] = {"timestep",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.osc_vis",\
    capi_kwlist,&timestep_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable timestep */
    f2py_success = int_from_pyobj(&timestep,timestep_capi,"_urqmd34.osc_vis() 1st argument (timestep) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&timestep);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of timestep*/
  /* End of cleaning variable timestep */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of osc_vis *******************************/

/******************************** osc99_event ********************************/
static char doc_f2py_rout__urqmd34_osc99_event[] = "\
osc99_event(ind)\n\nWrapper for ``osc99_event``.\
\n\nParameters\n----------\n"
"ind : input int";
/* extern void F_FUNC_US(osc99_event,OSC99_EVENT)(int*); */
static PyObject *f2py_rout__urqmd34_osc99_event(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int ind = 0;
  PyObject *ind_capi = Py_None;
  static char *capi_kwlist[] = {"ind",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.osc99_event",\
    capi_kwlist,&ind_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ind */
    f2py_success = int_from_pyobj(&ind,ind_capi,"_urqmd34.osc99_event() 1st argument (ind) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ind);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ind*/
  /* End of cleaning variable ind */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of osc99_event *****************************/

/********************************* osc99_coll *********************************/
static char doc_f2py_rout__urqmd34_osc99_coll[] = "\
osc99_coll()\n\nWrapper for ``osc99_coll``.\
\n";
/* extern void F_FUNC_US(osc99_coll,OSC99_COLL)(void); */
static PyObject *f2py_rout__urqmd34_osc99_coll(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.osc99_coll",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of osc99_coll *****************************/

/********************************* osc99_eoe *********************************/
static char doc_f2py_rout__urqmd34_osc99_eoe[] = "\
osc99_eoe()\n\nWrapper for ``osc99_eoe``.\
\n";
/* extern void F_FUNC_US(osc99_eoe,OSC99_EOE)(void); */
static PyObject *f2py_rout__urqmd34_osc99_eoe(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.osc99_eoe",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of osc99_eoe ******************************/

/******************************** getoldevent ********************************/
static char doc_f2py_rout__urqmd34_getoldevent[] = "\
getoldevent()\n\nWrapper for ``getoldevent``.\
\n";
/* extern void F_FUNC(getoldevent,GETOLDEVENT)(void); */
static PyObject *f2py_rout__urqmd34_getoldevent(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.getoldevent",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of getoldevent *****************************/

/********************************** specout **********************************/
static char doc_f2py_rout__urqmd34_specout[] = "\
specout(ind,iu)\n\nWrapper for ``specout``.\
\n\nParameters\n----------\n"
"ind : input int\n"
"iu : input int";
/* extern void F_FUNC(specout,SPECOUT)(int*,int*); */
static PyObject *f2py_rout__urqmd34_specout(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int ind = 0;
  PyObject *ind_capi = Py_None;
  int iu = 0;
  PyObject *iu_capi = Py_None;
  static char *capi_kwlist[] = {"ind","iu",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_urqmd34.specout",\
    capi_kwlist,&ind_capi,&iu_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iu */
    f2py_success = int_from_pyobj(&iu,iu_capi,"_urqmd34.specout() 2nd argument (iu) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ind */
    f2py_success = int_from_pyobj(&ind,ind_capi,"_urqmd34.specout() 1st argument (ind) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&ind,&iu);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ind*/
  /* End of cleaning variable ind */
  } /*if (f2py_success) of iu*/
  /* End of cleaning variable iu */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of specout *******************************/

/********************************** ptsigtot **********************************/
static char doc_f2py_rout__urqmd34_ptsigtot[] = "\
ptsigtot = ptsigtot()\n\nWrapper for ``ptsigtot``.\
\n\nReturns\n-------\n"
"ptsigtot : float";
/* extern void F_WRAPPEDFUNC(ptsigtot,PTSIGTOT)(double*); */
static PyObject *f2py_rout__urqmd34_ptsigtot(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double ptsigtot = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.ptsigtot",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable ptsigtot */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&ptsigtot);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",ptsigtot);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable ptsigtot */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of ptsigtot ******************************/

/*********************************** strini ***********************************/
static char doc_f2py_rout__urqmd34_strini[] = "\
strini()\n\nWrapper for ``strini``.\
\n";
/* extern void F_FUNC(strini,STRINI)(void); */
static PyObject *f2py_rout__urqmd34_strini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.strini",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of strini *******************************/

/*********************************** urqmd ***********************************/
static char doc_f2py_rout__urqmd34_urqmd[] = "\
urqmd(iflbmax)\n\nWrapper for ``urqmd``.\
\n\nParameters\n----------\n"
"iflbmax : input int";
/* extern void F_FUNC(urqmd,URQMD)(int*); */
static PyObject *f2py_rout__urqmd34_urqmd(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iflbmax = 0;
  PyObject *iflbmax_capi = Py_None;
  static char *capi_kwlist[] = {"iflbmax",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.urqmd",\
    capi_kwlist,&iflbmax_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iflbmax */
    f2py_success = int_from_pyobj(&iflbmax,iflbmax_capi,"_urqmd34.urqmd() 1st argument (iflbmax) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iflbmax);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iflbmax*/
  /* End of cleaning variable iflbmax */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of urqmd ********************************/

/************************************ init ************************************/
static char doc_f2py_rout__urqmd34_init[] = "\
init()\n\nWrapper for ``init``.\
\n";
/* extern void F_FUNC(init,INIT)(void); */
static PyObject *f2py_rout__urqmd34_init(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.init",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of init ********************************/

/********************************** loadwtab **********************************/
static char doc_f2py_rout__urqmd34_loadwtab[] = "\
loadwtab(io)\n\nWrapper for ``loadwtab``.\
\n\nParameters\n----------\n"
"io : input int";
/* extern void F_FUNC(loadwtab,LOADWTAB)(int*); */
static PyObject *f2py_rout__urqmd34_loadwtab(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int io = 0;
  PyObject *io_capi = Py_None;
  static char *capi_kwlist[] = {"io",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.loadwtab",\
    capi_kwlist,&io_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable io */
    f2py_success = int_from_pyobj(&io,io_capi,"_urqmd34.loadwtab() 1st argument (io) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&io);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of io*/
  /* End of cleaning variable io */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of loadwtab ******************************/

/********************************** cascinit **********************************/
static char doc_f2py_rout__urqmd34_cascinit[] = "\
cascinit(zz,aa,nucleus)\n\nWrapper for ``cascinit``.\
\n\nParameters\n----------\n"
"zz : input int\n"
"aa : input int\n"
"nucleus : input int";
/* extern void F_FUNC(cascinit,CASCINIT)(int*,int*,int*); */
static PyObject *f2py_rout__urqmd34_cascinit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int zz = 0;
  PyObject *zz_capi = Py_None;
  int aa = 0;
  PyObject *aa_capi = Py_None;
  int nucleus = 0;
  PyObject *nucleus_capi = Py_None;
  static char *capi_kwlist[] = {"zz","aa","nucleus",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:_urqmd34.cascinit",\
    capi_kwlist,&zz_capi,&aa_capi,&nucleus_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable zz */
    f2py_success = int_from_pyobj(&zz,zz_capi,"_urqmd34.cascinit() 1st argument (zz) can't be converted to int");
  if (f2py_success) {
  /* Processing variable aa */
    f2py_success = int_from_pyobj(&aa,aa_capi,"_urqmd34.cascinit() 2nd argument (aa) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nucleus */
    f2py_success = int_from_pyobj(&nucleus,nucleus_capi,"_urqmd34.cascinit() 3rd argument (nucleus) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zz,&aa,&nucleus);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nucleus*/
  /* End of cleaning variable nucleus */
  } /*if (f2py_success) of aa*/
  /* End of cleaning variable aa */
  } /*if (f2py_success) of zz*/
  /* End of cleaning variable zz */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of cascinit ******************************/

/*********************************** nucrad ***********************************/
static char doc_f2py_rout__urqmd34_nucrad[] = "\
nucrad = nucrad(aa)\n\nWrapper for ``nucrad``.\
\n\nParameters\n----------\n"
"aa : input int\n"
"\nReturns\n-------\n"
"nucrad : float";
/* extern void F_WRAPPEDFUNC(nucrad,NUCRAD)(double*,int*); */
static PyObject *f2py_rout__urqmd34_nucrad(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double nucrad = 0;
  int aa = 0;
  PyObject *aa_capi = Py_None;
  static char *capi_kwlist[] = {"aa",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.nucrad",\
    capi_kwlist,&aa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable aa */
    f2py_success = int_from_pyobj(&aa,aa_capi,"_urqmd34.nucrad() 1st argument (aa) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nucrad */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&nucrad,&aa);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",nucrad);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable nucrad */
  } /*if (f2py_success) of aa*/
  /* End of cleaning variable aa */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of nucrad *******************************/

/*********************************** params ***********************************/
static char doc_f2py_rout__urqmd34_params[] = "\
params()\n\nWrapper for ``params``.\
\n";
/* extern void F_FUNC(params,PARAMS)(void); */
static PyObject *f2py_rout__urqmd34_params(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.params",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of params *******************************/

/************************************ set0 ************************************/
static char doc_f2py_rout__urqmd34_set0[] = "\
set0()\n\nWrapper for ``set0``.\
\n";
/* extern void F_FUNC(set0,SET0)(void); */
static PyObject *f2py_rout__urqmd34_set0(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.set0",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of set0 ********************************/

/*********************************** urqini ***********************************/
static char doc_f2py_rout__urqmd34_urqini[] = "\
urqini(mdebug,iudebug)\n\nWrapper for ``urqini``.\
\n\nParameters\n----------\n"
"mdebug : input int\n"
"iudebug : input int";
/* extern void F_FUNC(urqini,URQINI)(int*,int*); */
static PyObject *f2py_rout__urqmd34_urqini(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int mdebug = 0;
  PyObject *mdebug_capi = Py_None;
  int iudebug = 0;
  PyObject *iudebug_capi = Py_None;
  static char *capi_kwlist[] = {"mdebug","iudebug",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_urqmd34.urqini",\
    capi_kwlist,&mdebug_capi,&iudebug_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mdebug */
    f2py_success = int_from_pyobj(&mdebug,mdebug_capi,"_urqmd34.urqini() 1st argument (mdebug) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iudebug */
    f2py_success = int_from_pyobj(&iudebug,iudebug_capi,"_urqmd34.urqini() 2nd argument (iudebug) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&mdebug,&iudebug);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iudebug*/
  /* End of cleaning variable iudebug */
  } /*if (f2py_success) of mdebug*/
  /* End of cleaning variable mdebug */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of urqini *******************************/

/********************************** chepevt **********************************/
static char doc_f2py_rout__urqmd34_chepevt[] = "\
chepevt()\n\nWrapper for ``chepevt``.\
\n";
/* extern void F_FUNC(chepevt,CHEPEVT)(void); */
static PyObject *f2py_rout__urqmd34_chepevt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:_urqmd34.chepevt",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of chepevt *******************************/

/***************************** chromo_openlogfile *****************************/
static char doc_f2py_rout__urqmd34_chromo_openlogfile[] = "\
chromo_openlogfile(fname,opunit)\n\nWrapper for ``chromo_openlogfile``.\
\n\nParameters\n----------\n"
"fname : input string(len=300)\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE)(string,int*,size_t); */
static PyObject *f2py_rout__urqmd34_chromo_openlogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string fname = NULL;
  int slen(fname);
  PyObject *fname_capi = Py_None;
  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"fname","opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:_urqmd34.chromo_openlogfile",\
    capi_kwlist,&fname_capi,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fname */
  slen(fname) = 300;
  f2py_success = string_from_pyobj(&fname,&slen(fname),"",fname_capi,"string_from_pyobj failed in converting 1st argument `fname' of _urqmd34.chromo_openlogfile to C string");
  if (f2py_success) {
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_urqmd34.chromo_openlogfile() 2nd argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(fname,&opunit,slen(fname));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
    STRINGFREE(fname);
  }  /*if (f2py_success) of fname*/
  /* End of cleaning variable fname */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_openlogfile *************************/

/**************************** chromo_closelogfile ****************************/
static char doc_f2py_rout__urqmd34_chromo_closelogfile[] = "\
chromo_closelogfile(opunit)\n\nWrapper for ``chromo_closelogfile``.\
\n\nParameters\n----------\n"
"opunit : input int";
/* extern void F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE)(int*); */
static PyObject *f2py_rout__urqmd34_chromo_closelogfile(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int opunit = 0;
  PyObject *opunit_capi = Py_None;
  static char *capi_kwlist[] = {"opunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.chromo_closelogfile",\
    capi_kwlist,&opunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable opunit */
    f2py_success = int_from_pyobj(&opunit,opunit_capi,"_urqmd34.chromo_closelogfile() 1st argument (opunit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&opunit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of opunit*/
  /* End of cleaning variable opunit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of chromo_closelogfile *************************/

/*********************************** npyrng ***********************************/
static char doc_f2py_rout__urqmd34_npyrng[] = "\
npyrng(rval)\n\nWrapper for ``npyrng``.\
\n\nParameters\n----------\n"
"rval : input float";
/* extern void F_FUNC(npyrng,NPYRNG)(double*); */
static PyObject *f2py_rout__urqmd34_npyrng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rval = 0;
  PyObject *rval_capi = Py_None;
  static char *capi_kwlist[] = {"rval",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:_urqmd34.npyrng",\
    capi_kwlist,&rval_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable rval */
    f2py_success = double_from_pyobj(&rval,rval_capi,"_urqmd34.npyrng() 1st argument (rval) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&rval);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of rval*/
  /* End of cleaning variable rval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of npyrng *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_versioning_def[] = {
  {"versiontag",1,{{45}},NPY_STRING},
  {NULL}
};
static void f2py_setup_versioning(char *versiontag) {
  int i_f2py=0;
  f2py_versioning_def[i_f2py++].data = versiontag;
}
extern void F_FUNC(f2pyinitversioning,F2PYINITVERSIONING)(void(*)(char*));
static void f2py_init_versioning(void) {
  F_FUNC(f2pyinitversioning,F2PYINITVERSIONING)(f2py_setup_versioning);
}

static FortranDataDef f2py_resonances_def[] = {
  {"massres",1,{{55}},NPY_DOUBLE},
  {"widres",1,{{55}},NPY_DOUBLE},
  {"massmes",1,{{40}},NPY_DOUBLE},
  {"widmes",1,{{40}},NPY_DOUBLE},
  {"mmesmn",1,{{40}},NPY_DOUBLE},
  {"branres",2,{{12,25}},NPY_DOUBLE},
  {"branmes",2,{{28,39}},NPY_DOUBLE},
  {"branbs1",2,{{11,21}},NPY_DOUBLE},
  {"branbs2",2,{{4,5}},NPY_DOUBLE},
  {"bs1type",2,{{4,11}},NPY_INT},
  {"bs2type",2,{{4,4}},NPY_INT},
  {"lbs1",2,{{11,21}},NPY_INT},
  {"lbs2",2,{{4,5}},NPY_INT},
  {"lbm",2,{{28,39}},NPY_INT},
  {"jres",1,{{55}},NPY_INT},
  {"jmes",1,{{40}},NPY_INT},
  {"lbr",2,{{12,25}},NPY_INT},
  {"brtype",2,{{4,12}},NPY_INT},
  {"pares",1,{{55}},NPY_INT},
  {"pames",1,{{40}},NPY_INT},
  {"bmtype",2,{{4,28}},NPY_INT},
  {"isores",1,{{55}},NPY_INT},
  {"isomes",1,{{40}},NPY_INT},
  {"strres",1,{{55}},NPY_INT},
  {"strmes",1,{{40}},NPY_INT},
  {"mlt2it",1,{{39}},NPY_INT},
  {"chrmres",1,{{55}},NPY_INT},
  {"chrmmes",1,{{40}},NPY_INT},
  {NULL}
};
static void f2py_setup_resonances(char *massres,char *widres,char *massmes,char *widmes,char *mmesmn,char *branres,char *branmes,char *branbs1,char *branbs2,char *bs1type,char *bs2type,char *lbs1,char *lbs2,char *lbm,char *jres,char *jmes,char *lbr,char *brtype,char *pares,char *pames,char *bmtype,char *isores,char *isomes,char *strres,char *strmes,char *mlt2it,char *chrmres,char *chrmmes) {
  int i_f2py=0;
  f2py_resonances_def[i_f2py++].data = massres;
  f2py_resonances_def[i_f2py++].data = widres;
  f2py_resonances_def[i_f2py++].data = massmes;
  f2py_resonances_def[i_f2py++].data = widmes;
  f2py_resonances_def[i_f2py++].data = mmesmn;
  f2py_resonances_def[i_f2py++].data = branres;
  f2py_resonances_def[i_f2py++].data = branmes;
  f2py_resonances_def[i_f2py++].data = branbs1;
  f2py_resonances_def[i_f2py++].data = branbs2;
  f2py_resonances_def[i_f2py++].data = bs1type;
  f2py_resonances_def[i_f2py++].data = bs2type;
  f2py_resonances_def[i_f2py++].data = lbs1;
  f2py_resonances_def[i_f2py++].data = lbs2;
  f2py_resonances_def[i_f2py++].data = lbm;
  f2py_resonances_def[i_f2py++].data = jres;
  f2py_resonances_def[i_f2py++].data = jmes;
  f2py_resonances_def[i_f2py++].data = lbr;
  f2py_resonances_def[i_f2py++].data = brtype;
  f2py_resonances_def[i_f2py++].data = pares;
  f2py_resonances_def[i_f2py++].data = pames;
  f2py_resonances_def[i_f2py++].data = bmtype;
  f2py_resonances_def[i_f2py++].data = isores;
  f2py_resonances_def[i_f2py++].data = isomes;
  f2py_resonances_def[i_f2py++].data = strres;
  f2py_resonances_def[i_f2py++].data = strmes;
  f2py_resonances_def[i_f2py++].data = mlt2it;
  f2py_resonances_def[i_f2py++].data = chrmres;
  f2py_resonances_def[i_f2py++].data = chrmmes;
}
extern void F_FUNC(f2pyinitresonances,F2PYINITRESONANCES)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_resonances(void) {
  F_FUNC(f2pyinitresonances,F2PYINITRESONANCES)(f2py_setup_resonances);
}

static FortranDataDef f2py_sigtabi_def[] = {
  {"sigmaln",3,{{21,2,15}},NPY_INT},
  {"sigmainf",2,{{10,20}},NPY_INT},
  {NULL}
};
static void f2py_setup_sigtabi(char *sigmaln,char *sigmainf) {
  int i_f2py=0;
  f2py_sigtabi_def[i_f2py++].data = sigmaln;
  f2py_sigtabi_def[i_f2py++].data = sigmainf;
}
extern void F_FUNC(f2pyinitsigtabi,F2PYINITSIGTABI)(void(*)(char*,char*));
static void f2py_init_sigtabi(void) {
  F_FUNC(f2pyinitsigtabi,F2PYINITSIGTABI)(f2py_setup_sigtabi);
}

static FortranDataDef f2py_sigtabr_def[] = {
  {"sigmas",2,{{10,100}},NPY_DOUBLE},
  {"sigmascal",2,{{10,5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_sigtabr(char *sigmas,char *sigmascal) {
  int i_f2py=0;
  f2py_sigtabr_def[i_f2py++].data = sigmas;
  f2py_sigtabr_def[i_f2py++].data = sigmascal;
}
extern void F_FUNC(f2pyinitsigtabr,F2PYINITSIGTABR)(void(*)(char*,char*));
static void f2py_init_sigtabr(void) {
  F_FUNC(f2pyinitsigtabr,F2PYINITSIGTABR)(f2py_setup_sigtabr);
}

static FortranDataDef f2py_normsplin_def[] = {
  {"x_norm",2,{{4,800}},NPY_DOUBLE},
  {"y_norm",2,{{4,800}},NPY_DOUBLE},
  {"dx",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_normsplin(char *x_norm,char *y_norm,char *dx) {
  int i_f2py=0;
  f2py_normsplin_def[i_f2py++].data = x_norm;
  f2py_normsplin_def[i_f2py++].data = y_norm;
  f2py_normsplin_def[i_f2py++].data = dx;
}
extern void F_FUNC(f2pyinitnormsplin,F2PYINITNORMSPLIN)(void(*)(char*,char*,char*));
static void f2py_init_normsplin(void) {
  F_FUNC(f2pyinitnormsplin,F2PYINITNORMSPLIN)(f2py_setup_normsplin);
}

static FortranDataDef f2py_cgks_def[] = {
  {"cgktab",5,{{8,8,15,15,8}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cgks(char *cgktab) {
  int i_f2py=0;
  f2py_cgks_def[i_f2py++].data = cgktab;
}
extern void F_FUNC(f2pyinitcgks,F2PYINITCGKS)(void(*)(char*));
static void f2py_init_cgks(void) {
  F_FUNC(f2pyinitcgks,F2PYINITCGKS)(f2py_setup_cgks);
}

static FortranDataDef f2py_factorials_def[] = {
  {"logfak",1,{{101}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_factorials(char *logfak) {
  int i_f2py=0;
  f2py_factorials_def[i_f2py++].data = logfak;
}
extern void F_FUNC(f2pyinitfactorials,F2PYINITFACTORIALS)(void(*)(char*));
static void f2py_init_factorials(void) {
  F_FUNC(f2pyinitfactorials,F2PYINITFACTORIALS)(f2py_setup_factorials);
}

static FortranDataDef f2py_pydat1_def[] = {
  {"mstu",1,{{200}},NPY_INT},
  {"paru",1,{{200}},NPY_DOUBLE},
  {"mstj",1,{{200}},NPY_INT},
  {"parj",1,{{200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pydat1(char *mstu,char *paru,char *mstj,char *parj) {
  int i_f2py=0;
  f2py_pydat1_def[i_f2py++].data = mstu;
  f2py_pydat1_def[i_f2py++].data = paru;
  f2py_pydat1_def[i_f2py++].data = mstj;
  f2py_pydat1_def[i_f2py++].data = parj;
}
extern void F_FUNC(f2pyinitpydat1,F2PYINITPYDAT1)(void(*)(char*,char*,char*,char*));
static void f2py_init_pydat1(void) {
  F_FUNC(f2pyinitpydat1,F2PYINITPYDAT1)(f2py_setup_pydat1);
}

static FortranDataDef f2py_pydat2_def[] = {
  {"kchg",2,{{500,4}},NPY_INT},
  {"pmas",2,{{500,4}},NPY_DOUBLE},
  {"parf",1,{{2000}},NPY_DOUBLE},
  {"vckm",2,{{4,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pydat2(char *kchg,char *pmas,char *parf,char *vckm) {
  int i_f2py=0;
  f2py_pydat2_def[i_f2py++].data = kchg;
  f2py_pydat2_def[i_f2py++].data = pmas;
  f2py_pydat2_def[i_f2py++].data = parf;
  f2py_pydat2_def[i_f2py++].data = vckm;
}
extern void F_FUNC(f2pyinitpydat2,F2PYINITPYDAT2)(void(*)(char*,char*,char*,char*));
static void f2py_init_pydat2(void) {
  F_FUNC(f2pyinitpydat2,F2PYINITPYDAT2)(f2py_setup_pydat2);
}

static FortranDataDef f2py_pydat3_def[] = {
  {"mdcy",2,{{500,3}},NPY_INT},
  {"mdme",2,{{8000,2}},NPY_INT},
  {"brat",1,{{8000}},NPY_DOUBLE},
  {"kfdp",2,{{8000,5}},NPY_INT},
  {NULL}
};
static void f2py_setup_pydat3(char *mdcy,char *mdme,char *brat,char *kfdp) {
  int i_f2py=0;
  f2py_pydat3_def[i_f2py++].data = mdcy;
  f2py_pydat3_def[i_f2py++].data = mdme;
  f2py_pydat3_def[i_f2py++].data = brat;
  f2py_pydat3_def[i_f2py++].data = kfdp;
}
extern void F_FUNC(f2pyinitpydat3,F2PYINITPYDAT3)(void(*)(char*,char*,char*,char*));
static void f2py_init_pydat3(void) {
  F_FUNC(f2pyinitpydat3,F2PYINITPYDAT3)(f2py_setup_pydat3);
}

static FortranDataDef f2py_pydat4_def[] = {
  {"chaf",3,{{500,2,16}},NPY_STRING},
  {NULL}
};
static void f2py_setup_pydat4(char *chaf) {
  int i_f2py=0;
  f2py_pydat4_def[i_f2py++].data = chaf;
}
extern void F_FUNC(f2pyinitpydat4,F2PYINITPYDAT4)(void(*)(char*));
static void f2py_init_pydat4(void) {
  F_FUNC(f2pyinitpydat4,F2PYINITPYDAT4)(f2py_setup_pydat4);
}

static FortranDataDef f2py_pydatr_def[] = {
  {"mrpy",1,{{6}},NPY_INT},
  {"rrpy",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pydatr(char *mrpy,char *rrpy) {
  int i_f2py=0;
  f2py_pydatr_def[i_f2py++].data = mrpy;
  f2py_pydatr_def[i_f2py++].data = rrpy;
}
extern void F_FUNC(f2pyinitpydatr,F2PYINITPYDATR)(void(*)(char*,char*));
static void f2py_init_pydatr(void) {
  F_FUNC(f2pyinitpydatr,F2PYINITPYDATR)(f2py_setup_pydatr);
}

static FortranDataDef f2py_pysubs_def[] = {
  {"msel",0,{{-1}},NPY_INT},
  {"mselpd",0,{{-1}},NPY_INT},
  {"msub",1,{{500}},NPY_INT},
  {"kfin",2,{{2,81}},NPY_INT},
  {"ckin",1,{{200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pysubs(char *msel,char *mselpd,char *msub,char *kfin,char *ckin) {
  int i_f2py=0;
  f2py_pysubs_def[i_f2py++].data = msel;
  f2py_pysubs_def[i_f2py++].data = mselpd;
  f2py_pysubs_def[i_f2py++].data = msub;
  f2py_pysubs_def[i_f2py++].data = kfin;
  f2py_pysubs_def[i_f2py++].data = ckin;
}
extern void F_FUNC(f2pyinitpysubs,F2PYINITPYSUBS)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_pysubs(void) {
  F_FUNC(f2pyinitpysubs,F2PYINITPYSUBS)(f2py_setup_pysubs);
}

static FortranDataDef f2py_pypars_def[] = {
  {"mstp",1,{{200}},NPY_INT},
  {"parp",1,{{200}},NPY_DOUBLE},
  {"msti",1,{{200}},NPY_INT},
  {"pari",1,{{200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pypars(char *mstp,char *parp,char *msti,char *pari) {
  int i_f2py=0;
  f2py_pypars_def[i_f2py++].data = mstp;
  f2py_pypars_def[i_f2py++].data = parp;
  f2py_pypars_def[i_f2py++].data = msti;
  f2py_pypars_def[i_f2py++].data = pari;
}
extern void F_FUNC(f2pyinitpypars,F2PYINITPYPARS)(void(*)(char*,char*,char*,char*));
static void f2py_init_pypars(void) {
  F_FUNC(f2pyinitpypars,F2PYINITPYPARS)(f2py_setup_pypars);
}

static FortranDataDef f2py_pyint1_def[] = {
  {"mint",1,{{400}},NPY_INT},
  {"vint",1,{{400}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint1(char *mint,char *vint) {
  int i_f2py=0;
  f2py_pyint1_def[i_f2py++].data = mint;
  f2py_pyint1_def[i_f2py++].data = vint;
}
extern void F_FUNC(f2pyinitpyint1,F2PYINITPYINT1)(void(*)(char*,char*));
static void f2py_init_pyint1(void) {
  F_FUNC(f2pyinitpyint1,F2PYINITPYINT1)(f2py_setup_pyint1);
}

static FortranDataDef f2py_pyint2_def[] = {
  {"iset",1,{{500}},NPY_INT},
  {"kfpr",2,{{500,2}},NPY_INT},
  {"coef",2,{{500,20}},NPY_DOUBLE},
  {"icol",3,{{40,4,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_pyint2(char *iset,char *kfpr,char *coef,char *icol) {
  int i_f2py=0;
  f2py_pyint2_def[i_f2py++].data = iset;
  f2py_pyint2_def[i_f2py++].data = kfpr;
  f2py_pyint2_def[i_f2py++].data = coef;
  f2py_pyint2_def[i_f2py++].data = icol;
}
extern void F_FUNC(f2pyinitpyint2,F2PYINITPYINT2)(void(*)(char*,char*,char*,char*));
static void f2py_init_pyint2(void) {
  F_FUNC(f2pyinitpyint2,F2PYINITPYINT2)(f2py_setup_pyint2);
}

static FortranDataDef f2py_pyint3_def[] = {
  {"xsfx",2,{{2,81}},NPY_DOUBLE},
  {"isig",2,{{1000,3}},NPY_INT},
  {"sigh",1,{{1000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint3(char *xsfx,char *isig,char *sigh) {
  int i_f2py=0;
  f2py_pyint3_def[i_f2py++].data = xsfx;
  f2py_pyint3_def[i_f2py++].data = isig;
  f2py_pyint3_def[i_f2py++].data = sigh;
}
extern void F_FUNC(f2pyinitpyint3,F2PYINITPYINT3)(void(*)(char*,char*,char*));
static void f2py_init_pyint3(void) {
  F_FUNC(f2pyinitpyint3,F2PYINITPYINT3)(f2py_setup_pyint3);
}

static FortranDataDef f2py_pyint4_def[] = {
  {"mwid",1,{{500}},NPY_INT},
  {"wids",2,{{500,5}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint4(char *mwid,char *wids) {
  int i_f2py=0;
  f2py_pyint4_def[i_f2py++].data = mwid;
  f2py_pyint4_def[i_f2py++].data = wids;
}
extern void F_FUNC(f2pyinitpyint4,F2PYINITPYINT4)(void(*)(char*,char*));
static void f2py_init_pyint4(void) {
  F_FUNC(f2pyinitpyint4,F2PYINITPYINT4)(f2py_setup_pyint4);
}

static FortranDataDef f2py_pyint5_def[] = {
  {"ngenpd",0,{{-1}},NPY_INT},
  {"ngen",2,{{501,3}},NPY_INT},
  {"xsec",2,{{501,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint5(char *ngenpd,char *ngen,char *xsec) {
  int i_f2py=0;
  f2py_pyint5_def[i_f2py++].data = ngenpd;
  f2py_pyint5_def[i_f2py++].data = ngen;
  f2py_pyint5_def[i_f2py++].data = xsec;
}
extern void F_FUNC(f2pyinitpyint5,F2PYINITPYINT5)(void(*)(char*,char*,char*));
static void f2py_init_pyint5(void) {
  F_FUNC(f2pyinitpyint5,F2PYINITPYINT5)(f2py_setup_pyint5);
}

static FortranDataDef f2py_pyint6_def[] = {
  {"proc",2,{{501,28}},NPY_STRING},
  {NULL}
};
static void f2py_setup_pyint6(char *proc) {
  int i_f2py=0;
  f2py_pyint6_def[i_f2py++].data = proc;
}
extern void F_FUNC(f2pyinitpyint6,F2PYINITPYINT6)(void(*)(char*));
static void f2py_init_pyint6(void) {
  F_FUNC(f2pyinitpyint6,F2PYINITPYINT6)(f2py_setup_pyint6);
}

static FortranDataDef f2py_pyint7_def[] = {
  {"sigt",3,{{7,7,6}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyint7(char *sigt) {
  int i_f2py=0;
  f2py_pyint7_def[i_f2py++].data = sigt;
}
extern void F_FUNC(f2pyinitpyint7,F2PYINITPYINT7)(void(*)(char*));
static void f2py_init_pyint7(void) {
  F_FUNC(f2pyinitpyint7,F2PYINITPYINT7)(f2py_setup_pyint7);
}

static FortranDataDef f2py_pymssm_def[] = {
  {"imss",1,{{100}},NPY_INT},
  {"rmss",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pymssm(char *imss,char *rmss) {
  int i_f2py=0;
  f2py_pymssm_def[i_f2py++].data = imss;
  f2py_pymssm_def[i_f2py++].data = rmss;
}
extern void F_FUNC(f2pyinitpymssm,F2PYINITPYMSSM)(void(*)(char*,char*));
static void f2py_init_pymssm(void) {
  F_FUNC(f2pyinitpymssm,F2PYINITPYMSSM)(f2py_setup_pymssm);
}

static FortranDataDef f2py_pyssmt_def[] = {
  {"zmix",2,{{4,4}},NPY_DOUBLE},
  {"umix",2,{{2,2}},NPY_DOUBLE},
  {"vmix",2,{{2,2}},NPY_DOUBLE},
  {"smz",1,{{4}},NPY_DOUBLE},
  {"smw",1,{{2}},NPY_DOUBLE},
  {"sfmix",2,{{16,4}},NPY_DOUBLE},
  {"zmixi",2,{{4,4}},NPY_DOUBLE},
  {"umixi",2,{{2,2}},NPY_DOUBLE},
  {"vmixi",2,{{2,2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pyssmt(char *zmix,char *umix,char *vmix,char *smz,char *smw,char *sfmix,char *zmixi,char *umixi,char *vmixi) {
  int i_f2py=0;
  f2py_pyssmt_def[i_f2py++].data = zmix;
  f2py_pyssmt_def[i_f2py++].data = umix;
  f2py_pyssmt_def[i_f2py++].data = vmix;
  f2py_pyssmt_def[i_f2py++].data = smz;
  f2py_pyssmt_def[i_f2py++].data = smw;
  f2py_pyssmt_def[i_f2py++].data = sfmix;
  f2py_pyssmt_def[i_f2py++].data = zmixi;
  f2py_pyssmt_def[i_f2py++].data = umixi;
  f2py_pyssmt_def[i_f2py++].data = vmixi;
}
extern void F_FUNC(f2pyinitpyssmt,F2PYINITPYSSMT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_pyssmt(void) {
  F_FUNC(f2pyinitpyssmt,F2PYINITPYSSMT)(f2py_setup_pyssmt);
}

static FortranDataDef f2py_pymsrv_def[] = {
  {"rvlam",3,{{3,3,3}},NPY_DOUBLE},
  {"rvlamp",3,{{3,3,3}},NPY_DOUBLE},
  {"rvlamb",3,{{3,3,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pymsrv(char *rvlam,char *rvlamp,char *rvlamb) {
  int i_f2py=0;
  f2py_pymsrv_def[i_f2py++].data = rvlam;
  f2py_pymsrv_def[i_f2py++].data = rvlamp;
  f2py_pymsrv_def[i_f2py++].data = rvlamb;
}
extern void F_FUNC(f2pyinitpymsrv,F2PYINITPYMSRV)(void(*)(char*,char*,char*));
static void f2py_init_pymsrv(void) {
  F_FUNC(f2pyinitpymsrv,F2PYINITPYMSRV)(f2py_setup_pymsrv);
}

static FortranDataDef f2py_pytcsm_def[] = {
  {"itcm",1,{{100}},NPY_INT},
  {"rtcm",1,{{100}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pytcsm(char *itcm,char *rtcm) {
  int i_f2py=0;
  f2py_pytcsm_def[i_f2py++].data = itcm;
  f2py_pytcsm_def[i_f2py++].data = rtcm;
}
extern void F_FUNC(f2pyinitpytcsm,F2PYINITPYTCSM)(void(*)(char*,char*));
static void f2py_init_pytcsm(void) {
  F_FUNC(f2pyinitpytcsm,F2PYINITPYTCSM)(f2py_setup_pytcsm);
}

static FortranDataDef f2py_pybins_def[] = {
  {"ihist",1,{{4}},NPY_INT},
  {"indx",1,{{1000}},NPY_INT},
  {"bin",1,{{20000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pybins(char *ihist,char *indx,char *bin) {
  int i_f2py=0;
  f2py_pybins_def[i_f2py++].data = ihist;
  f2py_pybins_def[i_f2py++].data = indx;
  f2py_pybins_def[i_f2py++].data = bin;
}
extern void F_FUNC(f2pyinitpybins,F2PYINITPYBINS)(void(*)(char*,char*,char*));
static void f2py_init_pybins(void) {
  F_FUNC(f2pyinitpybins,F2PYINITPYBINS)(f2py_setup_pybins);
}

static FortranDataDef f2py_pylh3p_def[] = {
  {"modsel",1,{{200}},NPY_INT},
  {"parmin",1,{{100}},NPY_DOUBLE},
  {"parext",1,{{200}},NPY_DOUBLE},
  {"rmsoft",1,{{101}},NPY_DOUBLE},
  {"au",2,{{3,3}},NPY_DOUBLE},
  {"ad",2,{{3,3}},NPY_DOUBLE},
  {"ae",2,{{3,3}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pylh3p(char *modsel,char *parmin,char *parext,char *rmsoft,char *au,char *ad,char *ae) {
  int i_f2py=0;
  f2py_pylh3p_def[i_f2py++].data = modsel;
  f2py_pylh3p_def[i_f2py++].data = parmin;
  f2py_pylh3p_def[i_f2py++].data = parext;
  f2py_pylh3p_def[i_f2py++].data = rmsoft;
  f2py_pylh3p_def[i_f2py++].data = au;
  f2py_pylh3p_def[i_f2py++].data = ad;
  f2py_pylh3p_def[i_f2py++].data = ae;
}
extern void F_FUNC(f2pyinitpylh3p,F2PYINITPYLH3P)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_pylh3p(void) {
  F_FUNC(f2pyinitpylh3p,F2PYINITPYLH3P)(f2py_setup_pylh3p);
}

static FortranDataDef f2py_pylh3c_def[] = {
  {"cpro",2,{{2,12}},NPY_STRING},
  {"cver",2,{{2,12}},NPY_STRING},
  {NULL}
};
static void f2py_setup_pylh3c(char *cpro,char *cver) {
  int i_f2py=0;
  f2py_pylh3c_def[i_f2py++].data = cpro;
  f2py_pylh3c_def[i_f2py++].data = cver;
}
extern void F_FUNC(f2pyinitpylh3c,F2PYINITPYLH3C)(void(*)(char*,char*));
static void f2py_init_pylh3c(void) {
  F_FUNC(f2pyinitpylh3c,F2PYINITPYLH3C)(f2py_setup_pylh3c);
}

static FortranDataDef f2py_sys_def[] = {
  {"npart",0,{{-1}},NPY_INT},
  {"nbar",0,{{-1}},NPY_INT},
  {"nmes",0,{{-1}},NPY_INT},
  {"ctag",0,{{-1}},NPY_INT},
  {"nsteps",0,{{-1}},NPY_INT},
  {"uid_cnt",0,{{-1}},NPY_INT},
  {"ranseed",0,{{-1}},NPY_INT},
  {"event",0,{{-1}},NPY_INT},
  {"ap",0,{{-1}},NPY_INT},
  {"at",0,{{-1}},NPY_INT},
  {"zp",0,{{-1}},NPY_INT},
  {"zt",0,{{-1}},NPY_INT},
  {"eos",0,{{-1}},NPY_INT},
  {"dectag",0,{{-1}},NPY_INT},
  {"nhardres",0,{{-1}},NPY_INT},
  {"nsoftres",0,{{-1}},NPY_INT},
  {"ndecres",0,{{-1}},NPY_INT},
  {"nelcoll",0,{{-1}},NPY_INT},
  {"nblcoll",0,{{-1}},NPY_INT},
  {"success",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_sys(char *npart,char *nbar,char *nmes,char *ctag,char *nsteps,char *uid_cnt,char *ranseed,char *event,char *ap,char *at,char *zp,char *zt,char *eos,char *dectag,char *nhardres,char *nsoftres,char *ndecres,char *nelcoll,char *nblcoll,char *success) {
  int i_f2py=0;
  f2py_sys_def[i_f2py++].data = npart;
  f2py_sys_def[i_f2py++].data = nbar;
  f2py_sys_def[i_f2py++].data = nmes;
  f2py_sys_def[i_f2py++].data = ctag;
  f2py_sys_def[i_f2py++].data = nsteps;
  f2py_sys_def[i_f2py++].data = uid_cnt;
  f2py_sys_def[i_f2py++].data = ranseed;
  f2py_sys_def[i_f2py++].data = event;
  f2py_sys_def[i_f2py++].data = ap;
  f2py_sys_def[i_f2py++].data = at;
  f2py_sys_def[i_f2py++].data = zp;
  f2py_sys_def[i_f2py++].data = zt;
  f2py_sys_def[i_f2py++].data = eos;
  f2py_sys_def[i_f2py++].data = dectag;
  f2py_sys_def[i_f2py++].data = nhardres;
  f2py_sys_def[i_f2py++].data = nsoftres;
  f2py_sys_def[i_f2py++].data = ndecres;
  f2py_sys_def[i_f2py++].data = nelcoll;
  f2py_sys_def[i_f2py++].data = nblcoll;
  f2py_sys_def[i_f2py++].data = success;
}
extern void F_FUNC(f2pyinitsys,F2PYINITSYS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_sys(void) {
  F_FUNC(f2pyinitsys,F2PYINITSYS)(f2py_setup_sys);
}

static FortranDataDef f2py_rsys_def[] = {
  {"time",0,{{-1}},NPY_DOUBLE},
  {"acttime",0,{{-1}},NPY_DOUBLE},
  {"bdist",0,{{-1}},NPY_DOUBLE},
  {"bimp",0,{{-1}},NPY_DOUBLE},
  {"bmin",0,{{-1}},NPY_DOUBLE},
  {"ebeam",0,{{-1}},NPY_DOUBLE},
  {"ecm",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_rsys(char *time,char *acttime,char *bdist,char *bimp,char *bmin,char *ebeam,char *ecm) {
  int i_f2py=0;
  f2py_rsys_def[i_f2py++].data = time;
  f2py_rsys_def[i_f2py++].data = acttime;
  f2py_rsys_def[i_f2py++].data = bdist;
  f2py_rsys_def[i_f2py++].data = bimp;
  f2py_rsys_def[i_f2py++].data = bmin;
  f2py_rsys_def[i_f2py++].data = ebeam;
  f2py_rsys_def[i_f2py++].data = ecm;
}
extern void F_FUNC(f2pyinitrsys,F2PYINITRSYS)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_rsys(void) {
  F_FUNC(f2pyinitrsys,F2PYINITRSYS)(f2py_setup_rsys);
}

static FortranDataDef f2py_comseed_def[] = {
  {"firstseed",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_comseed(char *firstseed) {
  int i_f2py=0;
  f2py_comseed_def[i_f2py++].data = firstseed;
}
extern void F_FUNC(f2pyinitcomseed,F2PYINITCOMSEED)(void(*)(char*));
static void f2py_init_comseed(void) {
  F_FUNC(f2pyinitcomseed,F2PYINITCOMSEED)(f2py_setup_comseed);
}

static FortranDataDef f2py_logic_def[] = {
  {"lsct",1,{{40000}},NPY_INT},
  {"logsky",0,{{-1}},NPY_INT},
  {"logyuk",0,{{-1}},NPY_INT},
  {"logcb",0,{{-1}},NPY_INT},
  {"logpau",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_logic(char *lsct,char *logsky,char *logyuk,char *logcb,char *logpau) {
  int i_f2py=0;
  f2py_logic_def[i_f2py++].data = lsct;
  f2py_logic_def[i_f2py++].data = logsky;
  f2py_logic_def[i_f2py++].data = logyuk;
  f2py_logic_def[i_f2py++].data = logcb;
  f2py_logic_def[i_f2py++].data = logpau;
}
extern void F_FUNC(f2pyinitlogic,F2PYINITLOGIC)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_logic(void) {
  F_FUNC(f2pyinitlogic,F2PYINITLOGIC)(f2py_setup_logic);
}

static FortranDataDef f2py_mdprop_def[] = {
  {"r0_t",1,{{40000}},NPY_DOUBLE},
  {"rx_t",1,{{40000}},NPY_DOUBLE},
  {"ry_t",1,{{40000}},NPY_DOUBLE},
  {"rz_t",1,{{40000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_mdprop(char *r0_t,char *rx_t,char *ry_t,char *rz_t) {
  int i_f2py=0;
  f2py_mdprop_def[i_f2py++].data = r0_t;
  f2py_mdprop_def[i_f2py++].data = rx_t;
  f2py_mdprop_def[i_f2py++].data = ry_t;
  f2py_mdprop_def[i_f2py++].data = rz_t;
}
extern void F_FUNC(f2pyinitmdprop,F2PYINITMDPROP)(void(*)(char*,char*,char*,char*));
static void f2py_init_mdprop(void) {
  F_FUNC(f2pyinitmdprop,F2PYINITMDPROP)(f2py_setup_mdprop);
}

static FortranDataDef f2py_cuts_def[] = {
  {"cutmax",0,{{-1}},NPY_DOUBLE},
  {"cutpau",0,{{-1}},NPY_DOUBLE},
  {"cutcb",0,{{-1}},NPY_DOUBLE},
  {"cutyuk",0,{{-1}},NPY_DOUBLE},
  {"cutsky",0,{{-1}},NPY_DOUBLE},
  {"cutdww",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_cuts(char *cutmax,char *cutpau,char *cutcb,char *cutyuk,char *cutsky,char *cutdww) {
  int i_f2py=0;
  f2py_cuts_def[i_f2py++].data = cutmax;
  f2py_cuts_def[i_f2py++].data = cutpau;
  f2py_cuts_def[i_f2py++].data = cutcb;
  f2py_cuts_def[i_f2py++].data = cutyuk;
  f2py_cuts_def[i_f2py++].data = cutsky;
  f2py_cuts_def[i_f2py++].data = cutdww;
}
extern void F_FUNC(f2pyinitcuts,F2PYINITCUTS)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_cuts(void) {
  F_FUNC(f2pyinitcuts,F2PYINITCUTS)(f2py_setup_cuts);
}

static FortranDataDef f2py_spdata_def[] = {
  {"spx",1,{{500}},NPY_DOUBLE},
  {"sppauy",1,{{500}},NPY_DOUBLE},
  {"outpau",1,{{500}},NPY_DOUBLE},
  {"spcby",1,{{500}},NPY_DOUBLE},
  {"outcb",1,{{500}},NPY_DOUBLE},
  {"spyuky",1,{{500}},NPY_DOUBLE},
  {"outyuk",1,{{500}},NPY_DOUBLE},
  {"spskyy",1,{{500}},NPY_DOUBLE},
  {"outsky",1,{{500}},NPY_DOUBLE},
  {"spdwwy",1,{{500}},NPY_DOUBLE},
  {"outdww",1,{{500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_spdata(char *spx,char *sppauy,char *outpau,char *spcby,char *outcb,char *spyuky,char *outyuk,char *spskyy,char *outsky,char *spdwwy,char *outdww) {
  int i_f2py=0;
  f2py_spdata_def[i_f2py++].data = spx;
  f2py_spdata_def[i_f2py++].data = sppauy;
  f2py_spdata_def[i_f2py++].data = outpau;
  f2py_spdata_def[i_f2py++].data = spcby;
  f2py_spdata_def[i_f2py++].data = outcb;
  f2py_spdata_def[i_f2py++].data = spyuky;
  f2py_spdata_def[i_f2py++].data = outyuk;
  f2py_spdata_def[i_f2py++].data = spskyy;
  f2py_spdata_def[i_f2py++].data = outsky;
  f2py_spdata_def[i_f2py++].data = spdwwy;
  f2py_spdata_def[i_f2py++].data = outdww;
}
extern void F_FUNC(f2pyinitspdata,F2PYINITSPDATA)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_spdata(void) {
  F_FUNC(f2pyinitspdata,F2PYINITSPDATA)(f2py_setup_spdata);
}

static FortranDataDef f2py_isys_def[] = {
  {"spin",1,{{40000}},NPY_INT},
  {"ncoll",1,{{40000}},NPY_INT},
  {"charge",1,{{40000}},NPY_INT},
  {"ityp",1,{{40000}},NPY_INT},
  {"lstcoll",1,{{40000}},NPY_INT},
  {"iso3",1,{{40000}},NPY_INT},
  {"origin",1,{{40000}},NPY_INT},
  {"uid",1,{{40000}},NPY_INT},
  {NULL}
};
static void f2py_setup_isys(char *spin,char *ncoll,char *charge,char *ityp,char *lstcoll,char *iso3,char *origin,char *uid) {
  int i_f2py=0;
  f2py_isys_def[i_f2py++].data = spin;
  f2py_isys_def[i_f2py++].data = ncoll;
  f2py_isys_def[i_f2py++].data = charge;
  f2py_isys_def[i_f2py++].data = ityp;
  f2py_isys_def[i_f2py++].data = lstcoll;
  f2py_isys_def[i_f2py++].data = iso3;
  f2py_isys_def[i_f2py++].data = origin;
  f2py_isys_def[i_f2py++].data = uid;
}
extern void F_FUNC(f2pyinitisys,F2PYINITISYS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_isys(void) {
  F_FUNC(f2pyinitisys,F2PYINITISYS)(f2py_setup_isys);
}

static FortranDataDef f2py_coor_def[] = {
  {"r0",1,{{40000}},NPY_DOUBLE},
  {"rx",1,{{40000}},NPY_DOUBLE},
  {"ry",1,{{40000}},NPY_DOUBLE},
  {"rz",1,{{40000}},NPY_DOUBLE},
  {"p0",1,{{40000}},NPY_DOUBLE},
  {"px",1,{{40000}},NPY_DOUBLE},
  {"py",1,{{40000}},NPY_DOUBLE},
  {"pz",1,{{40000}},NPY_DOUBLE},
  {"fmass",1,{{40000}},NPY_DOUBLE},
  {"rww",1,{{40000}},NPY_DOUBLE},
  {"dectime",1,{{40000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_coor(char *r0,char *rx,char *ry,char *rz,char *p0,char *px,char *py,char *pz,char *fmass,char *rww,char *dectime) {
  int i_f2py=0;
  f2py_coor_def[i_f2py++].data = r0;
  f2py_coor_def[i_f2py++].data = rx;
  f2py_coor_def[i_f2py++].data = ry;
  f2py_coor_def[i_f2py++].data = rz;
  f2py_coor_def[i_f2py++].data = p0;
  f2py_coor_def[i_f2py++].data = px;
  f2py_coor_def[i_f2py++].data = py;
  f2py_coor_def[i_f2py++].data = pz;
  f2py_coor_def[i_f2py++].data = fmass;
  f2py_coor_def[i_f2py++].data = rww;
  f2py_coor_def[i_f2py++].data = dectime;
}
extern void F_FUNC(f2pyinitcoor,F2PYINITCOOR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_coor(void) {
  F_FUNC(f2pyinitcoor,F2PYINITCOOR)(f2py_setup_coor);
}

static FortranDataDef f2py_frag_def[] = {
  {"tform",1,{{40000}},NPY_DOUBLE},
  {"xtotfac",1,{{40000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_frag(char *tform,char *xtotfac) {
  int i_f2py=0;
  f2py_frag_def[i_f2py++].data = tform;
  f2py_frag_def[i_f2py++].data = xtotfac;
}
extern void F_FUNC(f2pyinitfrag,F2PYINITFRAG)(void(*)(char*,char*));
static void f2py_init_frag(void) {
  F_FUNC(f2pyinitfrag,F2PYINITFRAG)(f2py_setup_frag);
}

static FortranDataDef f2py_aios_def[] = {
  {"airx",1,{{40000}},NPY_DOUBLE},
  {"airy",1,{{40000}},NPY_DOUBLE},
  {"airz",1,{{40000}},NPY_DOUBLE},
  {"aipx",1,{{40000}},NPY_DOUBLE},
  {"aipy",1,{{40000}},NPY_DOUBLE},
  {"aipz",1,{{40000}},NPY_DOUBLE},
  {"aorx",2,{{40000,4}},NPY_DOUBLE},
  {"aory",2,{{40000,4}},NPY_DOUBLE},
  {"aorz",2,{{40000,4}},NPY_DOUBLE},
  {"aopx",2,{{40000,4}},NPY_DOUBLE},
  {"aopy",2,{{40000,4}},NPY_DOUBLE},
  {"aopz",2,{{40000,4}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_aios(char *airx,char *airy,char *airz,char *aipx,char *aipy,char *aipz,char *aorx,char *aory,char *aorz,char *aopx,char *aopy,char *aopz) {
  int i_f2py=0;
  f2py_aios_def[i_f2py++].data = airx;
  f2py_aios_def[i_f2py++].data = airy;
  f2py_aios_def[i_f2py++].data = airz;
  f2py_aios_def[i_f2py++].data = aipx;
  f2py_aios_def[i_f2py++].data = aipy;
  f2py_aios_def[i_f2py++].data = aipz;
  f2py_aios_def[i_f2py++].data = aorx;
  f2py_aios_def[i_f2py++].data = aory;
  f2py_aios_def[i_f2py++].data = aorz;
  f2py_aios_def[i_f2py++].data = aopx;
  f2py_aios_def[i_f2py++].data = aopy;
  f2py_aios_def[i_f2py++].data = aopz;
}
extern void F_FUNC(f2pyinitaios,F2PYINITAIOS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_aios(void) {
  F_FUNC(f2pyinitaios,F2PYINITAIOS)(f2py_setup_aios);
}

static FortranDataDef f2py_pots_def[] = {
  {"cb0",0,{{-1}},NPY_DOUBLE},
  {"yuk0",0,{{-1}},NPY_DOUBLE},
  {"pau0",0,{{-1}},NPY_DOUBLE},
  {"sky20",0,{{-1}},NPY_DOUBLE},
  {"sky30",0,{{-1}},NPY_DOUBLE},
  {"gamsky",0,{{-1}},NPY_DOUBLE},
  {"gamyuk",0,{{-1}},NPY_DOUBLE},
  {"drpau",0,{{-1}},NPY_DOUBLE},
  {"dppau",0,{{-1}},NPY_DOUBLE},
  {"gw",0,{{-1}},NPY_DOUBLE},
  {"sgw",0,{{-1}},NPY_DOUBLE},
  {"delr",0,{{-1}},NPY_DOUBLE},
  {"fdel",0,{{-1}},NPY_DOUBLE},
  {"dt",0,{{-1}},NPY_DOUBLE},
  {"da",0,{{-1}},NPY_DOUBLE},
  {"db",0,{{-1}},NPY_DOUBLE},
  {"dtimestep",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_pots(char *cb0,char *yuk0,char *pau0,char *sky20,char *sky30,char *gamsky,char *gamyuk,char *drpau,char *dppau,char *gw,char *sgw,char *delr,char *fdel,char *dt,char *da,char *db,char *dtimestep) {
  int i_f2py=0;
  f2py_pots_def[i_f2py++].data = cb0;
  f2py_pots_def[i_f2py++].data = yuk0;
  f2py_pots_def[i_f2py++].data = pau0;
  f2py_pots_def[i_f2py++].data = sky20;
  f2py_pots_def[i_f2py++].data = sky30;
  f2py_pots_def[i_f2py++].data = gamsky;
  f2py_pots_def[i_f2py++].data = gamyuk;
  f2py_pots_def[i_f2py++].data = drpau;
  f2py_pots_def[i_f2py++].data = dppau;
  f2py_pots_def[i_f2py++].data = gw;
  f2py_pots_def[i_f2py++].data = sgw;
  f2py_pots_def[i_f2py++].data = delr;
  f2py_pots_def[i_f2py++].data = fdel;
  f2py_pots_def[i_f2py++].data = dt;
  f2py_pots_def[i_f2py++].data = da;
  f2py_pots_def[i_f2py++].data = db;
  f2py_pots_def[i_f2py++].data = dtimestep;
}
extern void F_FUNC(f2pyinitpots,F2PYINITPOTS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_pots(void) {
  F_FUNC(f2pyinitpots,F2PYINITPOTS)(f2py_setup_pots);
}

static FortranDataDef f2py_scoor_def[] = {
  {"r0s",1,{{500}},NPY_DOUBLE},
  {"rxs",1,{{500}},NPY_DOUBLE},
  {"rys",1,{{500}},NPY_DOUBLE},
  {"rzs",1,{{500}},NPY_DOUBLE},
  {"p0s",1,{{500}},NPY_DOUBLE},
  {"pxs",1,{{500}},NPY_DOUBLE},
  {"pys",1,{{500}},NPY_DOUBLE},
  {"pzs",1,{{500}},NPY_DOUBLE},
  {"sfmass",1,{{500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_scoor(char *r0s,char *rxs,char *rys,char *rzs,char *p0s,char *pxs,char *pys,char *pzs,char *sfmass) {
  int i_f2py=0;
  f2py_scoor_def[i_f2py++].data = r0s;
  f2py_scoor_def[i_f2py++].data = rxs;
  f2py_scoor_def[i_f2py++].data = rys;
  f2py_scoor_def[i_f2py++].data = rzs;
  f2py_scoor_def[i_f2py++].data = p0s;
  f2py_scoor_def[i_f2py++].data = pxs;
  f2py_scoor_def[i_f2py++].data = pys;
  f2py_scoor_def[i_f2py++].data = pzs;
  f2py_scoor_def[i_f2py++].data = sfmass;
}
extern void F_FUNC(f2pyinitscoor,F2PYINITSCOOR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_scoor(void) {
  F_FUNC(f2pyinitscoor,F2PYINITSCOOR)(f2py_setup_scoor);
}

static FortranDataDef f2py_sisys_def[] = {
  {"sspin",1,{{500}},NPY_INT},
  {"scharge",1,{{500}},NPY_INT},
  {"sityp",1,{{500}},NPY_INT},
  {"siso3",1,{{500}},NPY_INT},
  {"suid",1,{{500}},NPY_INT},
  {NULL}
};
static void f2py_setup_sisys(char *sspin,char *scharge,char *sityp,char *siso3,char *suid) {
  int i_f2py=0;
  f2py_sisys_def[i_f2py++].data = sspin;
  f2py_sisys_def[i_f2py++].data = scharge;
  f2py_sisys_def[i_f2py++].data = sityp;
  f2py_sisys_def[i_f2py++].data = siso3;
  f2py_sisys_def[i_f2py++].data = suid;
}
extern void F_FUNC(f2pyinitsisys,F2PYINITSISYS)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_sisys(void) {
  F_FUNC(f2pyinitsisys,F2PYINITSISYS)(f2py_setup_sisys);
}

static FortranDataDef f2py_ssys_def[] = {
  {"nspec",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ssys(char *nspec) {
  int i_f2py=0;
  f2py_ssys_def[i_f2py++].data = nspec;
}
extern void F_FUNC(f2pyinitssys,F2PYINITSSYS)(void(*)(char*));
static void f2py_init_ssys(void) {
  F_FUNC(f2pyinitssys,F2PYINITSSYS)(f2py_setup_ssys);
}

static FortranDataDef f2py_rtdelay_def[] = {
  {"p0td",2,{{2,40000}},NPY_DOUBLE},
  {"pxtd",2,{{2,40000}},NPY_DOUBLE},
  {"pytd",2,{{2,40000}},NPY_DOUBLE},
  {"pztd",2,{{2,40000}},NPY_DOUBLE},
  {"fmasstd",2,{{2,40000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_rtdelay(char *p0td,char *pxtd,char *pytd,char *pztd,char *fmasstd) {
  int i_f2py=0;
  f2py_rtdelay_def[i_f2py++].data = p0td;
  f2py_rtdelay_def[i_f2py++].data = pxtd;
  f2py_rtdelay_def[i_f2py++].data = pytd;
  f2py_rtdelay_def[i_f2py++].data = pztd;
  f2py_rtdelay_def[i_f2py++].data = fmasstd;
}
extern void F_FUNC(f2pyinitrtdelay,F2PYINITRTDELAY)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_rtdelay(void) {
  F_FUNC(f2pyinitrtdelay,F2PYINITRTDELAY)(f2py_setup_rtdelay);
}

static FortranDataDef f2py_itdelay_def[] = {
  {"ityptd",2,{{2,40000}},NPY_INT},
  {"iso3td",2,{{2,40000}},NPY_INT},
  {NULL}
};
static void f2py_setup_itdelay(char *ityptd,char *iso3td) {
  int i_f2py=0;
  f2py_itdelay_def[i_f2py++].data = ityptd;
  f2py_itdelay_def[i_f2py++].data = iso3td;
}
extern void F_FUNC(f2pyinititdelay,F2PYINITITDELAY)(void(*)(char*,char*));
static void f2py_init_itdelay(void) {
  F_FUNC(f2pyinititdelay,F2PYINITITDELAY)(f2py_setup_itdelay);
}

static FortranDataDef f2py_svinfo_def[] = {
  {"itypt",1,{{2}},NPY_INT},
  {"uidt",1,{{2}},NPY_INT},
  {"origint",1,{{2}},NPY_INT},
  {"iso3t",1,{{2}},NPY_INT},
  {NULL}
};
static void f2py_setup_svinfo(char *itypt,char *uidt,char *origint,char *iso3t) {
  int i_f2py=0;
  f2py_svinfo_def[i_f2py++].data = itypt;
  f2py_svinfo_def[i_f2py++].data = uidt;
  f2py_svinfo_def[i_f2py++].data = origint;
  f2py_svinfo_def[i_f2py++].data = iso3t;
}
extern void F_FUNC(f2pyinitsvinfo,F2PYINITSVINFO)(void(*)(char*,char*,char*,char*));
static void f2py_init_svinfo(void) {
  F_FUNC(f2pyinitsvinfo,F2PYINITSVINFO)(f2py_setup_svinfo);
}

static FortranDataDef f2py_ffermi_def[] = {
  {"ffermpx",1,{{40000}},NPY_DOUBLE},
  {"ffermpy",1,{{40000}},NPY_DOUBLE},
  {"ffermpz",1,{{40000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ffermi(char *ffermpx,char *ffermpy,char *ffermpz) {
  int i_f2py=0;
  f2py_ffermi_def[i_f2py++].data = ffermpx;
  f2py_ffermi_def[i_f2py++].data = ffermpy;
  f2py_ffermi_def[i_f2py++].data = ffermpz;
}
extern void F_FUNC(f2pyinitffermi,F2PYINITFFERMI)(void(*)(char*,char*,char*));
static void f2py_init_ffermi(void) {
  F_FUNC(f2pyinitffermi,F2PYINITFFERMI)(f2py_setup_ffermi);
}

static FortranDataDef f2py_peq_def[] = {
  {"peq1",0,{{-1}},NPY_DOUBLE},
  {"peq2",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_peq(char *peq1,char *peq2) {
  int i_f2py=0;
  f2py_peq_def[i_f2py++].data = peq1;
  f2py_peq_def[i_f2py++].data = peq2;
}
extern void F_FUNC(f2pyinitpeq,F2PYINITPEQ)(void(*)(char*,char*));
static void f2py_init_peq(void) {
  F_FUNC(f2pyinitpeq,F2PYINITPEQ)(f2py_setup_peq);
}

static FortranDataDef f2py__BLNK__def[] = {
  {"cross",1,{{60}},NPY_INT},
  {NULL}
};
static void f2py_setup__BLNK_(char *cross) {
  int i_f2py=0;
  f2py__BLNK__def[i_f2py++].data = cross;
}
extern void F_FUNC_US(f2pyinit_blnk_,F2PYINIT_BLNK_)(void(*)(char*));
static void f2py_init__BLNK_(void) {
  F_FUNC_US(f2pyinit_blnk_,F2PYINIT_BLNK_)(f2py_setup__BLNK_);
}

static FortranDataDef f2py_options_def[] = {
  {"ctoption",1,{{400}},NPY_INT},
  {"ctparam",1,{{400}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_options(char *ctoption,char *ctparam) {
  int i_f2py=0;
  f2py_options_def[i_f2py++].data = ctoption;
  f2py_options_def[i_f2py++].data = ctparam;
}
extern void F_FUNC(f2pyinitoptions,F2PYINITOPTIONS)(void(*)(char*,char*));
static void f2py_init_options(void) {
  F_FUNC(f2pyinitoptions,F2PYINITOPTIONS)(f2py_setup_options);
}

static FortranDataDef f2py_optstrings_def[] = {
  {"ctodc",2,{{400,2}},NPY_STRING},
  {"ctpdc",2,{{400,2}},NPY_STRING},
  {NULL}
};
static void f2py_setup_optstrings(char *ctodc,char *ctpdc) {
  int i_f2py=0;
  f2py_optstrings_def[i_f2py++].data = ctodc;
  f2py_optstrings_def[i_f2py++].data = ctpdc;
}
extern void F_FUNC(f2pyinitoptstrings,F2PYINITOPTSTRINGS)(void(*)(char*,char*));
static void f2py_init_optstrings(void) {
  F_FUNC(f2pyinitoptstrings,F2PYINITOPTSTRINGS)(f2py_setup_optstrings);
}

static FortranDataDef f2py_loptions_def[] = {
  {"fixedseed",0,{{-1}},NPY_INT},
  {"bf13",0,{{-1}},NPY_INT},
  {"bf14",0,{{-1}},NPY_INT},
  {"bf15",0,{{-1}},NPY_INT},
  {"bf16",0,{{-1}},NPY_INT},
  {"bf17",0,{{-1}},NPY_INT},
  {"bf18",0,{{-1}},NPY_INT},
  {"bf19",0,{{-1}},NPY_INT},
  {"bf20",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_loptions(char *fixedseed,char *bf13,char *bf14,char *bf15,char *bf16,char *bf17,char *bf18,char *bf19,char *bf20) {
  int i_f2py=0;
  f2py_loptions_def[i_f2py++].data = fixedseed;
  f2py_loptions_def[i_f2py++].data = bf13;
  f2py_loptions_def[i_f2py++].data = bf14;
  f2py_loptions_def[i_f2py++].data = bf15;
  f2py_loptions_def[i_f2py++].data = bf16;
  f2py_loptions_def[i_f2py++].data = bf17;
  f2py_loptions_def[i_f2py++].data = bf18;
  f2py_loptions_def[i_f2py++].data = bf19;
  f2py_loptions_def[i_f2py++].data = bf20;
}
extern void F_FUNC(f2pyinitloptions,F2PYINITLOPTIONS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_loptions(void) {
  F_FUNC(f2pyinitloptions,F2PYINITLOPTIONS)(f2py_setup_loptions);
}

static FortranDataDef f2py_stables_def[] = {
  {"nstable",0,{{-1}},NPY_INT},
  {"stabvec",1,{{20}},NPY_INT},
  {NULL}
};
static void f2py_setup_stables(char *nstable,char *stabvec) {
  int i_f2py=0;
  f2py_stables_def[i_f2py++].data = nstable;
  f2py_stables_def[i_f2py++].data = stabvec;
}
extern void F_FUNC(f2pyinitstables,F2PYINITSTABLES)(void(*)(char*,char*));
static void f2py_init_stables(void) {
  F_FUNC(f2pyinitstables,F2PYINITSTABLES)(f2py_setup_stables);
}

static FortranDataDef f2py_inputs_def[] = {
  {"nevents",0,{{-1}},NPY_INT},
  {"spityp",1,{{2}},NPY_INT},
  {"prspflg",0,{{-1}},NPY_INT},
  {"trspflg",0,{{-1}},NPY_INT},
  {"spiso3",1,{{2}},NPY_INT},
  {"outsteps",0,{{-1}},NPY_INT},
  {"bflag",0,{{-1}},NPY_INT},
  {"srtflag",0,{{-1}},NPY_INT},
  {"efuncflag",0,{{-1}},NPY_INT},
  {"nsrt",0,{{-1}},NPY_INT},
  {"firstev",0,{{-1}},NPY_INT},
  {"npb",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_inputs(char *nevents,char *spityp,char *prspflg,char *trspflg,char *spiso3,char *outsteps,char *bflag,char *srtflag,char *efuncflag,char *nsrt,char *firstev,char *npb) {
  int i_f2py=0;
  f2py_inputs_def[i_f2py++].data = nevents;
  f2py_inputs_def[i_f2py++].data = spityp;
  f2py_inputs_def[i_f2py++].data = prspflg;
  f2py_inputs_def[i_f2py++].data = trspflg;
  f2py_inputs_def[i_f2py++].data = spiso3;
  f2py_inputs_def[i_f2py++].data = outsteps;
  f2py_inputs_def[i_f2py++].data = bflag;
  f2py_inputs_def[i_f2py++].data = srtflag;
  f2py_inputs_def[i_f2py++].data = efuncflag;
  f2py_inputs_def[i_f2py++].data = nsrt;
  f2py_inputs_def[i_f2py++].data = firstev;
  f2py_inputs_def[i_f2py++].data = npb;
}
extern void F_FUNC(f2pyinitinputs,F2PYINITINPUTS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_inputs(void) {
  F_FUNC(f2pyinitinputs,F2PYINITINPUTS)(f2py_setup_inputs);
}

static FortranDataDef f2py_input2_def[] = {
  {"srtmin",0,{{-1}},NPY_DOUBLE},
  {"srtmax",0,{{-1}},NPY_DOUBLE},
  {"pbeam",0,{{-1}},NPY_DOUBLE},
  {"betann",0,{{-1}},NPY_DOUBLE},
  {"betatar",0,{{-1}},NPY_DOUBLE},
  {"betapro",0,{{-1}},NPY_DOUBLE},
  {"pbmin",0,{{-1}},NPY_DOUBLE},
  {"pbmax",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_input2(char *srtmin,char *srtmax,char *pbeam,char *betann,char *betatar,char *betapro,char *pbmin,char *pbmax) {
  int i_f2py=0;
  f2py_input2_def[i_f2py++].data = srtmin;
  f2py_input2_def[i_f2py++].data = srtmax;
  f2py_input2_def[i_f2py++].data = pbeam;
  f2py_input2_def[i_f2py++].data = betann;
  f2py_input2_def[i_f2py++].data = betatar;
  f2py_input2_def[i_f2py++].data = betapro;
  f2py_input2_def[i_f2py++].data = pbmin;
  f2py_input2_def[i_f2py++].data = pbmax;
}
extern void F_FUNC(f2pyinitinput2,F2PYINITINPUT2)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_input2(void) {
  F_FUNC(f2pyinitinput2,F2PYINITINPUT2)(f2py_setup_input2);
}

static FortranDataDef f2py_protarints_def[] = {
  {"pt_iso3",2,{{6000,2}},NPY_INT},
  {"pt_ityp",2,{{6000,2}},NPY_INT},
  {"pt_spin",2,{{6000,2}},NPY_INT},
  {"pt_charge",2,{{6000,2}},NPY_INT},
  {"pt_aa",1,{{2}},NPY_INT},
  {"pt_uid",2,{{6000,2}},NPY_INT},
  {NULL}
};
static void f2py_setup_protarints(char *pt_iso3,char *pt_ityp,char *pt_spin,char *pt_charge,char *pt_aa,char *pt_uid) {
  int i_f2py=0;
  f2py_protarints_def[i_f2py++].data = pt_iso3;
  f2py_protarints_def[i_f2py++].data = pt_ityp;
  f2py_protarints_def[i_f2py++].data = pt_spin;
  f2py_protarints_def[i_f2py++].data = pt_charge;
  f2py_protarints_def[i_f2py++].data = pt_aa;
  f2py_protarints_def[i_f2py++].data = pt_uid;
}
extern void F_FUNC(f2pyinitprotarints,F2PYINITPROTARINTS)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_protarints(void) {
  F_FUNC(f2pyinitprotarints,F2PYINITPROTARINTS)(f2py_setup_protarints);
}

static FortranDataDef f2py_protarreals_def[] = {
  {"pt_r0",2,{{6000,2}},NPY_DOUBLE},
  {"pt_rx",2,{{6000,2}},NPY_DOUBLE},
  {"pt_ry",2,{{6000,2}},NPY_DOUBLE},
  {"pt_rz",2,{{6000,2}},NPY_DOUBLE},
  {"pt_fmass",2,{{6000,2}},NPY_DOUBLE},
  {"pt_dectime",2,{{6000,2}},NPY_DOUBLE},
  {"pt_p0",2,{{6000,2}},NPY_DOUBLE},
  {"pt_px",2,{{6000,2}},NPY_DOUBLE},
  {"pt_py",2,{{6000,2}},NPY_DOUBLE},
  {"pt_pz",2,{{6000,2}},NPY_DOUBLE},
  {"pt_rho",2,{{6000,2}},NPY_DOUBLE},
  {"pt_pmax",2,{{6000,2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_protarreals(char *pt_r0,char *pt_rx,char *pt_ry,char *pt_rz,char *pt_fmass,char *pt_dectime,char *pt_p0,char *pt_px,char *pt_py,char *pt_pz,char *pt_rho,char *pt_pmax) {
  int i_f2py=0;
  f2py_protarreals_def[i_f2py++].data = pt_r0;
  f2py_protarreals_def[i_f2py++].data = pt_rx;
  f2py_protarreals_def[i_f2py++].data = pt_ry;
  f2py_protarreals_def[i_f2py++].data = pt_rz;
  f2py_protarreals_def[i_f2py++].data = pt_fmass;
  f2py_protarreals_def[i_f2py++].data = pt_dectime;
  f2py_protarreals_def[i_f2py++].data = pt_p0;
  f2py_protarreals_def[i_f2py++].data = pt_px;
  f2py_protarreals_def[i_f2py++].data = pt_py;
  f2py_protarreals_def[i_f2py++].data = pt_pz;
  f2py_protarreals_def[i_f2py++].data = pt_rho;
  f2py_protarreals_def[i_f2py++].data = pt_pmax;
}
extern void F_FUNC(f2pyinitprotarreals,F2PYINITPROTARREALS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_protarreals(void) {
  F_FUNC(f2pyinitprotarreals,F2PYINITPROTARREALS)(f2py_setup_protarreals);
}

static FortranDataDef f2py_inewpart_def[] = {
  {"itypnew",1,{{1000}},NPY_INT},
  {"i3new",1,{{1000}},NPY_INT},
  {"itot",1,{{1000}},NPY_INT},
  {"inew",1,{{1000}},NPY_INT},
  {"nexit",0,{{-1}},NPY_INT},
  {"iline",0,{{-1}},NPY_INT},
  {"strcount",0,{{-1}},NPY_INT},
  {"pslot",1,{{2}},NPY_INT},
  {"nstring1",0,{{-1}},NPY_INT},
  {"nstring2",0,{{-1}},NPY_INT},
  {"itypold",1,{{2}},NPY_INT},
  {"iso3old",1,{{2}},NPY_INT},
  {NULL}
};
static void f2py_setup_inewpart(char *itypnew,char *i3new,char *itot,char *inew,char *nexit,char *iline,char *strcount,char *pslot,char *nstring1,char *nstring2,char *itypold,char *iso3old) {
  int i_f2py=0;
  f2py_inewpart_def[i_f2py++].data = itypnew;
  f2py_inewpart_def[i_f2py++].data = i3new;
  f2py_inewpart_def[i_f2py++].data = itot;
  f2py_inewpart_def[i_f2py++].data = inew;
  f2py_inewpart_def[i_f2py++].data = nexit;
  f2py_inewpart_def[i_f2py++].data = iline;
  f2py_inewpart_def[i_f2py++].data = strcount;
  f2py_inewpart_def[i_f2py++].data = pslot;
  f2py_inewpart_def[i_f2py++].data = nstring1;
  f2py_inewpart_def[i_f2py++].data = nstring2;
  f2py_inewpart_def[i_f2py++].data = itypold;
  f2py_inewpart_def[i_f2py++].data = iso3old;
}
extern void F_FUNC(f2pyinitinewpart,F2PYINITINEWPART)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_inewpart(void) {
  F_FUNC(f2pyinitinewpart,F2PYINITINEWPART)(f2py_setup_inewpart);
}

static FortranDataDef f2py_rnewpart_def[] = {
  {"pnew",2,{{5,1000}},NPY_DOUBLE},
  {"xnew",2,{{4,1000}},NPY_DOUBLE},
  {"betax",0,{{-1}},NPY_DOUBLE},
  {"betay",0,{{-1}},NPY_DOUBLE},
  {"betaz",0,{{-1}},NPY_DOUBLE},
  {"pold",2,{{5,2}},NPY_DOUBLE},
  {"p0nn",0,{{-1}},NPY_DOUBLE},
  {"pxnn",0,{{-1}},NPY_DOUBLE},
  {"pynn",0,{{-1}},NPY_DOUBLE},
  {"pznn",0,{{-1}},NPY_DOUBLE},
  {"pnn",0,{{-1}},NPY_DOUBLE},
  {"mstring",1,{{2}},NPY_DOUBLE},
  {"pnnout",0,{{-1}},NPY_DOUBLE},
  {"xtotfacold",1,{{2}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_rnewpart(char *pnew,char *xnew,char *betax,char *betay,char *betaz,char *pold,char *p0nn,char *pxnn,char *pynn,char *pznn,char *pnn,char *mstring,char *pnnout,char *xtotfacold) {
  int i_f2py=0;
  f2py_rnewpart_def[i_f2py++].data = pnew;
  f2py_rnewpart_def[i_f2py++].data = xnew;
  f2py_rnewpart_def[i_f2py++].data = betax;
  f2py_rnewpart_def[i_f2py++].data = betay;
  f2py_rnewpart_def[i_f2py++].data = betaz;
  f2py_rnewpart_def[i_f2py++].data = pold;
  f2py_rnewpart_def[i_f2py++].data = p0nn;
  f2py_rnewpart_def[i_f2py++].data = pxnn;
  f2py_rnewpart_def[i_f2py++].data = pynn;
  f2py_rnewpart_def[i_f2py++].data = pznn;
  f2py_rnewpart_def[i_f2py++].data = pnn;
  f2py_rnewpart_def[i_f2py++].data = mstring;
  f2py_rnewpart_def[i_f2py++].data = pnnout;
  f2py_rnewpart_def[i_f2py++].data = xtotfacold;
}
extern void F_FUNC(f2pyinitrnewpart,F2PYINITRNEWPART)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_rnewpart(void) {
  F_FUNC(f2pyinitrnewpart,F2PYINITRNEWPART)(f2py_setup_rnewpart);
}

static FortranDataDef f2py_fnewpart_def[] = {
  {"leadfac",1,{{1000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_fnewpart(char *leadfac) {
  int i_f2py=0;
  f2py_fnewpart_def[i_f2py++].data = leadfac;
}
extern void F_FUNC(f2pyinitfnewpart,F2PYINITFNEWPART)(void(*)(char*));
static void f2py_init_fnewpart(void) {
  F_FUNC(f2pyinitfnewpart,F2PYINITFNEWPART)(f2py_setup_fnewpart);
}

static FortranDataDef f2py_frcoor_def[] = {
  {"frr0",1,{{40000}},NPY_DOUBLE},
  {"frrx",1,{{40000}},NPY_DOUBLE},
  {"frry",1,{{40000}},NPY_DOUBLE},
  {"frrz",1,{{40000}},NPY_DOUBLE},
  {"frp0",1,{{40000}},NPY_DOUBLE},
  {"frpx",1,{{40000}},NPY_DOUBLE},
  {"frpy",1,{{40000}},NPY_DOUBLE},
  {"frpz",1,{{40000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_frcoor(char *frr0,char *frrx,char *frry,char *frrz,char *frp0,char *frpx,char *frpy,char *frpz) {
  int i_f2py=0;
  f2py_frcoor_def[i_f2py++].data = frr0;
  f2py_frcoor_def[i_f2py++].data = frrx;
  f2py_frcoor_def[i_f2py++].data = frry;
  f2py_frcoor_def[i_f2py++].data = frrz;
  f2py_frcoor_def[i_f2py++].data = frp0;
  f2py_frcoor_def[i_f2py++].data = frpx;
  f2py_frcoor_def[i_f2py++].data = frpy;
  f2py_frcoor_def[i_f2py++].data = frpz;
}
extern void F_FUNC(f2pyinitfrcoor,F2PYINITFRCOOR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_frcoor(void) {
  F_FUNC(f2pyinitfrcoor,F2PYINITFRCOOR)(f2py_setup_frcoor);
}

static FortranDataDef f2py_boxic_def[] = {
  {"cbox",0,{{-1}},NPY_INT},
  {"boxflag",0,{{-1}},NPY_INT},
  {"mbox",0,{{-1}},NPY_INT},
  {"bptityp",1,{{20}},NPY_INT},
  {"bptiso3",1,{{20}},NPY_INT},
  {"bptpart",1,{{20}},NPY_INT},
  {"edensflag",0,{{-1}},NPY_INT},
  {"para",0,{{-1}},NPY_INT},
  {"solid",0,{{-1}},NPY_INT},
  {"mbflag",0,{{-1}},NPY_INT},
  {"mtest",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_boxic(char *cbox,char *boxflag,char *mbox,char *bptityp,char *bptiso3,char *bptpart,char *edensflag,char *para,char *solid,char *mbflag,char *mtest) {
  int i_f2py=0;
  f2py_boxic_def[i_f2py++].data = cbox;
  f2py_boxic_def[i_f2py++].data = boxflag;
  f2py_boxic_def[i_f2py++].data = mbox;
  f2py_boxic_def[i_f2py++].data = bptityp;
  f2py_boxic_def[i_f2py++].data = bptiso3;
  f2py_boxic_def[i_f2py++].data = bptpart;
  f2py_boxic_def[i_f2py++].data = edensflag;
  f2py_boxic_def[i_f2py++].data = para;
  f2py_boxic_def[i_f2py++].data = solid;
  f2py_boxic_def[i_f2py++].data = mbflag;
  f2py_boxic_def[i_f2py++].data = mtest;
}
extern void F_FUNC(f2pyinitboxic,F2PYINITBOXIC)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_boxic(void) {
  F_FUNC(f2pyinitboxic,F2PYINITBOXIC)(f2py_setup_boxic);
}

static FortranDataDef f2py_boxrc_def[] = {
  {"lbox",0,{{-1}},NPY_DOUBLE},
  {"lboxhalbe",0,{{-1}},NPY_DOUBLE},
  {"lboxd",0,{{-1}},NPY_DOUBLE},
  {"bptpmax",1,{{20}},NPY_DOUBLE},
  {"edens",0,{{-1}},NPY_DOUBLE},
  {"mbp0",0,{{-1}},NPY_DOUBLE},
  {"mbpx",0,{{-1}},NPY_DOUBLE},
  {"mbpy",0,{{-1}},NPY_DOUBLE},
  {"mbpz",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_boxrc(char *lbox,char *lboxhalbe,char *lboxd,char *bptpmax,char *edens,char *mbp0,char *mbpx,char *mbpy,char *mbpz) {
  int i_f2py=0;
  f2py_boxrc_def[i_f2py++].data = lbox;
  f2py_boxrc_def[i_f2py++].data = lboxhalbe;
  f2py_boxrc_def[i_f2py++].data = lboxd;
  f2py_boxrc_def[i_f2py++].data = bptpmax;
  f2py_boxrc_def[i_f2py++].data = edens;
  f2py_boxrc_def[i_f2py++].data = mbp0;
  f2py_boxrc_def[i_f2py++].data = mbpx;
  f2py_boxrc_def[i_f2py++].data = mbpy;
  f2py_boxrc_def[i_f2py++].data = mbpz;
}
extern void F_FUNC(f2pyinitboxrc,F2PYINITBOXRC)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_boxrc(void) {
  F_FUNC(f2pyinitboxrc,F2PYINITBOXRC)(f2py_setup_boxrc);
}

static FortranDataDef f2py_outco2_def[] = {
  {"sigmatot",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_outco2(char *sigmatot) {
  int i_f2py=0;
  f2py_outco2_def[i_f2py++].data = sigmatot;
}
extern void F_FUNC(f2pyinitoutco2,F2PYINITOUTCO2)(void(*)(char*));
static void f2py_init_outco2(void) {
  F_FUNC(f2pyinitoutco2,F2PYINITOUTCO2)(f2py_setup_outco2);
}

static FortranDataDef f2py_outcom_def[] = {
  {"tsqrts",0,{{-1}},NPY_DOUBLE},
  {"tstot",0,{{-1}},NPY_DOUBLE},
  {"tsigpart",0,{{-1}},NPY_DOUBLE},
  {"tr0",1,{{3}},NPY_DOUBLE},
  {"trx",1,{{3}},NPY_DOUBLE},
  {"try",1,{{3}},NPY_DOUBLE},
  {"trz",1,{{3}},NPY_DOUBLE},
  {"ttform",1,{{3}},NPY_DOUBLE},
  {"txtotfac",1,{{3}},NPY_DOUBLE},
  {"tp0",1,{{3}},NPY_DOUBLE},
  {"tpx",1,{{3}},NPY_DOUBLE},
  {"tpy",1,{{3}},NPY_DOUBLE},
  {"tpz",1,{{3}},NPY_DOUBLE},
  {"tm",1,{{3}},NPY_DOUBLE},
  {"tind",1,{{3}},NPY_INT},
  {"tityp",1,{{3}},NPY_INT},
  {"tiso3",1,{{3}},NPY_INT},
  {"tcoll",1,{{3}},NPY_INT},
  {"tstrange",1,{{3}},NPY_INT},
  {"tlcoll",1,{{3}},NPY_INT},
  {"tcharge",1,{{3}},NPY_INT},
  {"torigin",1,{{3}},NPY_INT},
  {"tuid",1,{{3}},NPY_INT},
  {NULL}
};
static void f2py_setup_outcom(char *tsqrts,char *tstot,char *tsigpart,char *tr0,char *trx,char *try,char *trz,char *ttform,char *txtotfac,char *tp0,char *tpx,char *tpy,char *tpz,char *tm,char *tind,char *tityp,char *tiso3,char *tcoll,char *tstrange,char *tlcoll,char *tcharge,char *torigin,char *tuid) {
  int i_f2py=0;
  f2py_outcom_def[i_f2py++].data = tsqrts;
  f2py_outcom_def[i_f2py++].data = tstot;
  f2py_outcom_def[i_f2py++].data = tsigpart;
  f2py_outcom_def[i_f2py++].data = tr0;
  f2py_outcom_def[i_f2py++].data = trx;
  f2py_outcom_def[i_f2py++].data = try;
  f2py_outcom_def[i_f2py++].data = trz;
  f2py_outcom_def[i_f2py++].data = ttform;
  f2py_outcom_def[i_f2py++].data = txtotfac;
  f2py_outcom_def[i_f2py++].data = tp0;
  f2py_outcom_def[i_f2py++].data = tpx;
  f2py_outcom_def[i_f2py++].data = tpy;
  f2py_outcom_def[i_f2py++].data = tpz;
  f2py_outcom_def[i_f2py++].data = tm;
  f2py_outcom_def[i_f2py++].data = tind;
  f2py_outcom_def[i_f2py++].data = tityp;
  f2py_outcom_def[i_f2py++].data = tiso3;
  f2py_outcom_def[i_f2py++].data = tcoll;
  f2py_outcom_def[i_f2py++].data = tstrange;
  f2py_outcom_def[i_f2py++].data = tlcoll;
  f2py_outcom_def[i_f2py++].data = tcharge;
  f2py_outcom_def[i_f2py++].data = torigin;
  f2py_outcom_def[i_f2py++].data = tuid;
}
extern void F_FUNC(f2pyinitoutcom,F2PYINITOUTCOM)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_outcom(void) {
  F_FUNC(f2pyinitoutcom,F2PYINITOUTCOM)(f2py_setup_outcom);
}

static FortranDataDef f2py_frgspa_def[] = {
  {"pjspns",0,{{-1}},NPY_DOUBLE},
  {"pmix1s",2,{{3,8}},NPY_DOUBLE},
  {"pmix2s",2,{{3,8}},NPY_DOUBLE},
  {"pbars",0,{{-1}},NPY_DOUBLE},
  {"parqls",0,{{-1}},NPY_DOUBLE},
  {"parrs",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_frgspa(char *pjspns,char *pmix1s,char *pmix2s,char *pbars,char *parqls,char *parrs) {
  int i_f2py=0;
  f2py_frgspa_def[i_f2py++].data = pjspns;
  f2py_frgspa_def[i_f2py++].data = pmix1s;
  f2py_frgspa_def[i_f2py++].data = pmix2s;
  f2py_frgspa_def[i_f2py++].data = pbars;
  f2py_frgspa_def[i_f2py++].data = parqls;
  f2py_frgspa_def[i_f2py++].data = parrs;
}
extern void F_FUNC(f2pyinitfrgspa,F2PYINITFRGSPA)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_frgspa(void) {
  F_FUNC(f2pyinitfrgspa,F2PYINITFRGSPA)(f2py_setup_frgspa);
}

static FortranDataDef f2py_frgcpa_def[] = {
  {"pjspnc",0,{{-1}},NPY_DOUBLE},
  {"pmix1c",2,{{3,8}},NPY_DOUBLE},
  {"pmix2c",2,{{3,8}},NPY_DOUBLE},
  {"pbarc",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_frgcpa(char *pjspnc,char *pmix1c,char *pmix2c,char *pbarc) {
  int i_f2py=0;
  f2py_frgcpa_def[i_f2py++].data = pjspnc;
  f2py_frgcpa_def[i_f2py++].data = pmix1c;
  f2py_frgcpa_def[i_f2py++].data = pmix2c;
  f2py_frgcpa_def[i_f2py++].data = pbarc;
}
extern void F_FUNC(f2pyinitfrgcpa,F2PYINITFRGCPA)(void(*)(char*,char*,char*,char*));
static void f2py_init_frgcpa(void) {
  F_FUNC(f2pyinitfrgcpa,F2PYINITFRGCPA)(f2py_setup_frgcpa);
}

static FortranDataDef f2py_coparm_def[] = {
  {"parm",1,{{8}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_coparm(char *parm) {
  int i_f2py=0;
  f2py_coparm_def[i_f2py++].data = parm;
}
extern void F_FUNC(f2pyinitcoparm,F2PYINITCOPARM)(void(*)(char*));
static void f2py_init_coparm(void) {
  F_FUNC(f2pyinitcoparm,F2PYINITCOPARM)(f2py_setup_coparm);
}

static FortranDataDef f2py_const_def[] = {
  {"pi",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_const(char *pi) {
  int i_f2py=0;
  f2py_const_def[i_f2py++].data = pi;
}
extern void F_FUNC(f2pyinitconst,F2PYINITCONST)(void(*)(char*));
static void f2py_init_const(void) {
  F_FUNC(f2pyinitconst,F2PYINITCONST)(f2py_setup_const);
}

static FortranDataDef f2py_kappa_def[] = {
  {"xap",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_kappa(char *xap) {
  int i_f2py=0;
  f2py_kappa_def[i_f2py++].data = xap;
}
extern void F_FUNC(f2pyinitkappa,F2PYINITKAPPA)(void(*)(char*));
static void f2py_init_kappa(void) {
  F_FUNC(f2pyinitkappa,F2PYINITKAPPA)(f2py_setup_kappa);
}

static FortranDataDef f2py_consti_def[] = {
  {"consti",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_consti(char *consti) {
  int i_f2py=0;
  f2py_consti_def[i_f2py++].data = consti;
}
extern void F_FUNC(f2pyinitconsti,F2PYINITCONSTI)(void(*)(char*));
static void f2py_init_consti(void) {
  F_FUNC(f2pyinitconsti,F2PYINITCONSTI)(f2py_setup_consti);
}

static FortranDataDef f2py_comtry_def[] = {
  {"ntries",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_comtry(char *ntries) {
  int i_f2py=0;
  f2py_comtry_def[i_f2py++].data = ntries;
}
extern void F_FUNC(f2pyinitcomtry,F2PYINITCOMTRY)(void(*)(char*));
static void f2py_init_comtry(void) {
  F_FUNC(f2pyinitcomtry,F2PYINITCOMTRY)(f2py_setup_comtry);
}

static FortranDataDef f2py_colltab_def[] = {
  {"cttime",1,{{20001}},NPY_DOUBLE},
  {"ctsqrts",1,{{20000}},NPY_DOUBLE},
  {"ctsigtot",1,{{20000}},NPY_DOUBLE},
  {"tmin",0,{{-1}},NPY_DOUBLE},
  {"cti1",1,{{20000}},NPY_INT},
  {"cti2",1,{{20000}},NPY_INT},
  {"nct",0,{{-1}},NPY_INT},
  {"actcol",0,{{-1}},NPY_INT},
  {"ctvalid",1,{{20000}},NPY_INT},
  {"ctsav",1,{{20000}},NPY_INT},
  {"nsav",0,{{-1}},NPY_INT},
  {"apt",0,{{-1}},NPY_INT},
  {"ctcolfluc",1,{{20000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_colltab(char *cttime,char *ctsqrts,char *ctsigtot,char *tmin,char *cti1,char *cti2,char *nct,char *actcol,char *ctvalid,char *ctsav,char *nsav,char *apt,char *ctcolfluc) {
  int i_f2py=0;
  f2py_colltab_def[i_f2py++].data = cttime;
  f2py_colltab_def[i_f2py++].data = ctsqrts;
  f2py_colltab_def[i_f2py++].data = ctsigtot;
  f2py_colltab_def[i_f2py++].data = tmin;
  f2py_colltab_def[i_f2py++].data = cti1;
  f2py_colltab_def[i_f2py++].data = cti2;
  f2py_colltab_def[i_f2py++].data = nct;
  f2py_colltab_def[i_f2py++].data = actcol;
  f2py_colltab_def[i_f2py++].data = ctvalid;
  f2py_colltab_def[i_f2py++].data = ctsav;
  f2py_colltab_def[i_f2py++].data = nsav;
  f2py_colltab_def[i_f2py++].data = apt;
  f2py_colltab_def[i_f2py++].data = ctcolfluc;
}
extern void F_FUNC(f2pyinitcolltab,F2PYINITCOLLTAB)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_colltab(void) {
  F_FUNC(f2pyinitcolltab,F2PYINITCOLLTAB)(f2py_setup_colltab);
}

static FortranDataDef f2py_energies_def[] = {
  {"ekinbar",0,{{-1}},NPY_DOUBLE},
  {"ekinmes",0,{{-1}},NPY_DOUBLE},
  {"esky2",0,{{-1}},NPY_DOUBLE},
  {"esky3",0,{{-1}},NPY_DOUBLE},
  {"eyuk",0,{{-1}},NPY_DOUBLE},
  {"ecb",0,{{-1}},NPY_DOUBLE},
  {"epau",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_energies(char *ekinbar,char *ekinmes,char *esky2,char *esky3,char *eyuk,char *ecb,char *epau) {
  int i_f2py=0;
  f2py_energies_def[i_f2py++].data = ekinbar;
  f2py_energies_def[i_f2py++].data = ekinmes;
  f2py_energies_def[i_f2py++].data = esky2;
  f2py_energies_def[i_f2py++].data = esky3;
  f2py_energies_def[i_f2py++].data = eyuk;
  f2py_energies_def[i_f2py++].data = ecb;
  f2py_energies_def[i_f2py++].data = epau;
}
extern void F_FUNC(f2pyinitenergies,F2PYINITENERGIES)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_energies(void) {
  F_FUNC(f2pyinitenergies,F2PYINITENERGIES)(f2py_setup_energies);
}

static FortranDataDef f2py_cncc_def[] = {
  {"ncc",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_cncc(char *ncc) {
  int i_f2py=0;
  f2py_cncc_def[i_f2py++].data = ncc;
}
extern void F_FUNC(f2pyinitcncc,F2PYINITCNCC)(void(*)(char*));
static void f2py_init_cncc(void) {
  F_FUNC(f2pyinitcncc,F2PYINITCNCC)(f2py_setup_cncc);
}

static FortranDataDef f2py_ini_def[] = {
  {"bcorr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ini(char *bcorr) {
  int i_f2py=0;
  f2py_ini_def[i_f2py++].data = bcorr;
}
extern void F_FUNC(f2pyinitini,F2PYINITINI)(void(*)(char*));
static void f2py_init_ini(void) {
  F_FUNC(f2pyinitini,F2PYINITINI)(f2py_setup_ini);
}

static FortranDataDef f2py_decaywidth_def[] = {
  {"tabx",1,{{120}},NPY_DOUBLE},
  {"fbtaby",3,{{120,55,2}},NPY_DOUBLE},
  {"pbtaby",4,{{120,2,55,12}},NPY_DOUBLE},
  {"fmtaby",3,{{120,40,2}},NPY_DOUBLE},
  {"pmtaby",4,{{120,2,40,28}},NPY_DOUBLE},
  {"wtabflg",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_decaywidth(char *tabx,char *fbtaby,char *pbtaby,char *fmtaby,char *pmtaby,char *wtabflg) {
  int i_f2py=0;
  f2py_decaywidth_def[i_f2py++].data = tabx;
  f2py_decaywidth_def[i_f2py++].data = fbtaby;
  f2py_decaywidth_def[i_f2py++].data = pbtaby;
  f2py_decaywidth_def[i_f2py++].data = fmtaby;
  f2py_decaywidth_def[i_f2py++].data = pmtaby;
  f2py_decaywidth_def[i_f2py++].data = wtabflg;
}
extern void F_FUNC(f2pyinitdecaywidth,F2PYINITDECAYWIDTH)(void(*)(char*,char*,char*,char*,char*,char*));
static void f2py_init_decaywidth(void) {
  F_FUNC(f2pyinitdecaywidth,F2PYINITDECAYWIDTH)(f2py_setup_decaywidth);
}

static FortranDataDef f2py_brwignorm_def[] = {
  {"bwbarnorm",1,{{55}},NPY_DOUBLE},
  {"bwmesnorm",1,{{40}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_brwignorm(char *bwbarnorm,char *bwmesnorm) {
  int i_f2py=0;
  f2py_brwignorm_def[i_f2py++].data = bwbarnorm;
  f2py_brwignorm_def[i_f2py++].data = bwmesnorm;
}
extern void F_FUNC(f2pyinitbrwignorm,F2PYINITBRWIGNORM)(void(*)(char*,char*));
static void f2py_init_brwignorm(void) {
  F_FUNC(f2pyinitbrwignorm,F2PYINITBRWIGNORM)(f2py_setup_brwignorm);
}

static FortranDataDef f2py_xsections_def[] = {
  {"tabxnd",1,{{120}},NPY_DOUBLE},
  {"frrtaby",4,{{120,2,2,25}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_xsections(char *tabxnd,char *frrtaby) {
  int i_f2py=0;
  f2py_xsections_def[i_f2py++].data = tabxnd;
  f2py_xsections_def[i_f2py++].data = frrtaby;
}
extern void F_FUNC(f2pyinitxsections,F2PYINITXSECTIONS)(void(*)(char*,char*));
static void f2py_init_xsections(void) {
  F_FUNC(f2pyinitxsections,F2PYINITXSECTIONS)(f2py_setup_xsections);
}

static FortranDataDef f2py_tabnames_def[] = {
  {"tabname",1,{{77}},NPY_STRING},
  {NULL}
};
static void f2py_setup_tabnames(char *tabname) {
  int i_f2py=0;
  f2py_tabnames_def[i_f2py++].data = tabname;
}
extern void F_FUNC(f2pyinittabnames,F2PYINITTABNAMES)(void(*)(char*));
static void f2py_init_tabnames(void) {
  F_FUNC(f2pyinittabnames,F2PYINITTABNAMES)(f2py_setup_tabnames);
}

static FortranDataDef f2py_hera_def[] = {
  {"a",1,{{16}},NPY_DOUBLE},
  {"b",1,{{16}},NPY_DOUBLE},
  {"n",1,{{16}},NPY_DOUBLE},
  {"c",1,{{16}},NPY_DOUBLE},
  {"d",1,{{16}},NPY_DOUBLE},
  {"p1",1,{{16}},NPY_DOUBLE},
  {"p2",1,{{16}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hera(char *a,char *b,char *n,char *c,char *d,char *p1,char *p2) {
  int i_f2py=0;
  f2py_hera_def[i_f2py++].data = a;
  f2py_hera_def[i_f2py++].data = b;
  f2py_hera_def[i_f2py++].data = n;
  f2py_hera_def[i_f2py++].data = c;
  f2py_hera_def[i_f2py++].data = d;
  f2py_hera_def[i_f2py++].data = p1;
  f2py_hera_def[i_f2py++].data = p2;
}
extern void F_FUNC(f2pyinithera,F2PYINITHERA)(void(*)(char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hera(void) {
  F_FUNC(f2pyinithera,F2PYINITHERA)(f2py_setup_hera);
}

static FortranDataDef f2py_regge_def[] = {
  {"z",1,{{16}},NPY_DOUBLE},
  {"y1",1,{{16}},NPY_DOUBLE},
  {"y2",1,{{16}},NPY_DOUBLE},
  {"s0",0,{{-1}},NPY_DOUBLE},
  {"s1",0,{{-1}},NPY_DOUBLE},
  {"eta1",0,{{-1}},NPY_DOUBLE},
  {"eta2",0,{{-1}},NPY_DOUBLE},
  {"bb",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_regge(char *z,char *y1,char *y2,char *s0,char *s1,char *eta1,char *eta2,char *bb) {
  int i_f2py=0;
  f2py_regge_def[i_f2py++].data = z;
  f2py_regge_def[i_f2py++].data = y1;
  f2py_regge_def[i_f2py++].data = y2;
  f2py_regge_def[i_f2py++].data = s0;
  f2py_regge_def[i_f2py++].data = s1;
  f2py_regge_def[i_f2py++].data = eta1;
  f2py_regge_def[i_f2py++].data = eta2;
  f2py_regge_def[i_f2py++].data = bb;
}
extern void F_FUNC(f2pyinitregge,F2PYINITREGGE)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_regge(void) {
  F_FUNC(f2pyinitregge,F2PYINITREGGE)(f2py_setup_regge);
}

static FortranDataDef f2py_hepevt_def[] = {
  {"nevhep",0,{{-1}},NPY_INT},
  {"nhep",0,{{-1}},NPY_INT},
  {"isthep",1,{{40000}},NPY_INT},
  {"idhep",1,{{40000}},NPY_INT},
  {"jmohep",2,{{2,40000}},NPY_INT},
  {"jdahep",2,{{2,40000}},NPY_INT},
  {"phep",2,{{5,40000}},NPY_DOUBLE},
  {"vhep",2,{{4,40000}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_hepevt(char *nevhep,char *nhep,char *isthep,char *idhep,char *jmohep,char *jdahep,char *phep,char *vhep) {
  int i_f2py=0;
  f2py_hepevt_def[i_f2py++].data = nevhep;
  f2py_hepevt_def[i_f2py++].data = nhep;
  f2py_hepevt_def[i_f2py++].data = isthep;
  f2py_hepevt_def[i_f2py++].data = idhep;
  f2py_hepevt_def[i_f2py++].data = jmohep;
  f2py_hepevt_def[i_f2py++].data = jdahep;
  f2py_hepevt_def[i_f2py++].data = phep;
  f2py_hepevt_def[i_f2py++].data = vhep;
}
extern void F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_hepevt(void) {
  F_FUNC(f2pyinithepevt,F2PYINITHEPEVT)(f2py_setup_hepevt);
}

static FortranDataDef f2py_uqchg_def[] = {
  {"ichg",1,{{40000}},NPY_INT},
  {NULL}
};
static void f2py_setup_uqchg(char *ichg) {
  int i_f2py=0;
  f2py_uqchg_def[i_f2py++].data = ichg;
}
extern void F_FUNC(f2pyinituqchg,F2PYINITUQCHG)(void(*)(char*));
static void f2py_init_uqchg(void) {
  F_FUNC(f2pyinituqchg,F2PYINITUQCHG)(f2py_setup_uqchg);
}

static FortranDataDef f2py_npy_def[] = {
  {"bitgen",0,{{-1}},NPY_LONGLONG},
  {NULL}
};
static void f2py_setup_npy(char *bitgen) {
  int i_f2py=0;
  f2py_npy_def[i_f2py++].data = bitgen;
}
extern void F_FUNC(f2pyinitnpy,F2PYINITNPY)(void(*)(char*));
static void f2py_init_npy(void) {
  F_FUNC(f2pyinitnpy,F2PYINITNPY)(f2py_setup_npy);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"norm_init",-1,{{-1}},0,(char *)F_FUNC_US(norm_init,NORM_INIT),(f2py_init_func)f2py_rout__urqmd34_norm_init,doc_f2py_rout__urqmd34_norm_init},
  {"loginit",-1,{{-1}},0,(char *)F_FUNC(loginit,LOGINIT),(f2py_init_func)f2py_rout__urqmd34_loginit,doc_f2py_rout__urqmd34_loginit},
  {"partname",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(partname,PARTNAME),(f2py_init_func)f2py_rout__urqmd34_partname,doc_f2py_rout__urqmd34_partname},
  {"output",-1,{{-1}},0,(char *)F_FUNC(output,OUTPUT),(f2py_init_func)f2py_rout__urqmd34_output,doc_f2py_rout__urqmd34_output},
  {"uounit",-1,{{-1}},0,(char *)F_FUNC(uounit,UOUNIT),(f2py_init_func)f2py_rout__urqmd34_uounit,doc_f2py_rout__urqmd34_uounit},
  {"file14out",-1,{{-1}},0,(char *)F_FUNC(file14out,FILE14OUT),(f2py_init_func)f2py_rout__urqmd34_file14out,doc_f2py_rout__urqmd34_file14out},
  {"file13out",-1,{{-1}},0,(char *)F_FUNC(file13out,FILE13OUT),(f2py_init_func)f2py_rout__urqmd34_file13out,doc_f2py_rout__urqmd34_file13out},
  {"file15out",-1,{{-1}},0,(char *)F_FUNC(file15out,FILE15OUT),(f2py_init_func)f2py_rout__urqmd34_file15out,doc_f2py_rout__urqmd34_file15out},
  {"f15outch",-1,{{-1}},0,(char *)F_FUNC(f15outch,F15OUTCH),(f2py_init_func)f2py_rout__urqmd34_f15outch,doc_f2py_rout__urqmd34_f15outch},
  {"f15hyin",-1,{{-1}},0,(char *)F_FUNC(f15hyin,F15HYIN),(f2py_init_func)f2py_rout__urqmd34_f15hyin,doc_f2py_rout__urqmd34_f15hyin},
  {"f15hyout",-1,{{-1}},0,(char *)F_FUNC(f15hyout,F15HYOUT),(f2py_init_func)f2py_rout__urqmd34_f15hyout,doc_f2py_rout__urqmd34_f15hyout},
  {"f15outhy",-1,{{-1}},0,(char *)F_FUNC(f15outhy,F15OUTHY),(f2py_init_func)f2py_rout__urqmd34_f15outhy,doc_f2py_rout__urqmd34_f15outhy},
  {"f16outch",-1,{{-1}},0,(char *)F_FUNC(f16outch,F16OUTCH),(f2py_init_func)f2py_rout__urqmd34_f16outch,doc_f2py_rout__urqmd34_f16outch},
  {"file16out",-1,{{-1}},0,(char *)F_FUNC(file16out,FILE16OUT),(f2py_init_func)f2py_rout__urqmd34_file16out,doc_f2py_rout__urqmd34_file16out},
  {"file16entry",-1,{{-1}},0,(char *)F_FUNC(file16entry,FILE16ENTRY),(f2py_init_func)f2py_rout__urqmd34_file16entry,doc_f2py_rout__urqmd34_file16entry},
  {"file16write",-1,{{-1}},0,(char *)F_FUNC(file16write,FILE16WRITE),(f2py_init_func)f2py_rout__urqmd34_file16write,doc_f2py_rout__urqmd34_file16write},
  {"osc_header",-1,{{-1}},0,(char *)F_FUNC_US(osc_header,OSC_HEADER),(f2py_init_func)f2py_rout__urqmd34_osc_header,doc_f2py_rout__urqmd34_osc_header},
  {"osc99_header",-1,{{-1}},0,(char *)F_FUNC_US(osc99_header,OSC99_HEADER),(f2py_init_func)f2py_rout__urqmd34_osc99_header,doc_f2py_rout__urqmd34_osc99_header},
  {"osc_event",-1,{{-1}},0,(char *)F_FUNC_US(osc_event,OSC_EVENT),(f2py_init_func)f2py_rout__urqmd34_osc_event,doc_f2py_rout__urqmd34_osc_event},
  {"osc_vis",-1,{{-1}},0,(char *)F_FUNC_US(osc_vis,OSC_VIS),(f2py_init_func)f2py_rout__urqmd34_osc_vis,doc_f2py_rout__urqmd34_osc_vis},
  {"osc99_event",-1,{{-1}},0,(char *)F_FUNC_US(osc99_event,OSC99_EVENT),(f2py_init_func)f2py_rout__urqmd34_osc99_event,doc_f2py_rout__urqmd34_osc99_event},
  {"osc99_coll",-1,{{-1}},0,(char *)F_FUNC_US(osc99_coll,OSC99_COLL),(f2py_init_func)f2py_rout__urqmd34_osc99_coll,doc_f2py_rout__urqmd34_osc99_coll},
  {"osc99_eoe",-1,{{-1}},0,(char *)F_FUNC_US(osc99_eoe,OSC99_EOE),(f2py_init_func)f2py_rout__urqmd34_osc99_eoe,doc_f2py_rout__urqmd34_osc99_eoe},
  {"getoldevent",-1,{{-1}},0,(char *)F_FUNC(getoldevent,GETOLDEVENT),(f2py_init_func)f2py_rout__urqmd34_getoldevent,doc_f2py_rout__urqmd34_getoldevent},
  {"specout",-1,{{-1}},0,(char *)F_FUNC(specout,SPECOUT),(f2py_init_func)f2py_rout__urqmd34_specout,doc_f2py_rout__urqmd34_specout},
  {"ptsigtot",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(ptsigtot,PTSIGTOT),(f2py_init_func)f2py_rout__urqmd34_ptsigtot,doc_f2py_rout__urqmd34_ptsigtot},
  {"strini",-1,{{-1}},0,(char *)F_FUNC(strini,STRINI),(f2py_init_func)f2py_rout__urqmd34_strini,doc_f2py_rout__urqmd34_strini},
  {"urqmd",-1,{{-1}},0,(char *)F_FUNC(urqmd,URQMD),(f2py_init_func)f2py_rout__urqmd34_urqmd,doc_f2py_rout__urqmd34_urqmd},
  {"init",-1,{{-1}},0,(char *)F_FUNC(init,INIT),(f2py_init_func)f2py_rout__urqmd34_init,doc_f2py_rout__urqmd34_init},
  {"loadwtab",-1,{{-1}},0,(char *)F_FUNC(loadwtab,LOADWTAB),(f2py_init_func)f2py_rout__urqmd34_loadwtab,doc_f2py_rout__urqmd34_loadwtab},
  {"cascinit",-1,{{-1}},0,(char *)F_FUNC(cascinit,CASCINIT),(f2py_init_func)f2py_rout__urqmd34_cascinit,doc_f2py_rout__urqmd34_cascinit},
  {"nucrad",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(nucrad,NUCRAD),(f2py_init_func)f2py_rout__urqmd34_nucrad,doc_f2py_rout__urqmd34_nucrad},
  {"params",-1,{{-1}},0,(char *)F_FUNC(params,PARAMS),(f2py_init_func)f2py_rout__urqmd34_params,doc_f2py_rout__urqmd34_params},
  {"set0",-1,{{-1}},0,(char *)F_FUNC(set0,SET0),(f2py_init_func)f2py_rout__urqmd34_set0,doc_f2py_rout__urqmd34_set0},
  {"urqini",-1,{{-1}},0,(char *)F_FUNC(urqini,URQINI),(f2py_init_func)f2py_rout__urqmd34_urqini,doc_f2py_rout__urqmd34_urqini},
  {"chepevt",-1,{{-1}},0,(char *)F_FUNC(chepevt,CHEPEVT),(f2py_init_func)f2py_rout__urqmd34_chepevt,doc_f2py_rout__urqmd34_chepevt},
  {"chromo_openlogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_openlogfile,CHROMO_OPENLOGFILE),(f2py_init_func)f2py_rout__urqmd34_chromo_openlogfile,doc_f2py_rout__urqmd34_chromo_openlogfile},
  {"chromo_closelogfile",-1,{{-1}},0,(char *)F_FUNC_US(chromo_closelogfile,CHROMO_CLOSELOGFILE),(f2py_init_func)f2py_rout__urqmd34_chromo_closelogfile,doc_f2py_rout__urqmd34_chromo_closelogfile},
  {"npyrng",-1,{{-1}},0,(char *)F_FUNC(npyrng,NPYRNG),(f2py_init_func)f2py_rout__urqmd34_npyrng,doc_f2py_rout__urqmd34_npyrng},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_urqmd34",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit__urqmd34(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = _urqmd34_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _urqmd34 (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module '_urqmd34' is auto-generated with f2py (version:2).\nFunctions:\n"
"  norm_init()\n"
"  loginit()\n"
"  partname = partname(ityp)\n"
"  output(iunit)\n"
"  uounit(iiunit,isunit)\n"
"  file14out(timestep)\n"
"  file13out(timestep)\n"
"  file15out(ind1,ind2,sqrts,stot,sigpart)\n"
"  f15outch(colldens)\n"
"  f15hyin(thydro_start)\n"
"  f15hyout(thydro_start,thydro)\n"
"  f15outhy(thydro_start,thydro)\n"
"  f16outch()\n"
"  file16out()\n"
"  file16entry(ind)\n"
"  file16write()\n"
"  osc_header()\n"
"  osc99_header()\n"
"  osc_event()\n"
"  osc_vis(timestep)\n"
"  osc99_event(ind)\n"
"  osc99_coll()\n"
"  osc99_eoe()\n"
"  getoldevent()\n"
"  specout(ind,iu)\n"
"  ptsigtot = ptsigtot()\n"
"  strini()\n"
"  urqmd(iflbmax)\n"
"  init()\n"
"  loadwtab(io)\n"
"  cascinit(zz,aa,nucleus)\n"
"  nucrad = nucrad(aa)\n"
"  params()\n"
"  set0()\n"
"  urqini(mdebug,iudebug)\n"
"  chepevt()\n"
"  chromo_openlogfile(fname,opunit)\n"
"  chromo_closelogfile(opunit)\n"
"  npyrng(rval)\n"
"COMMON blocks:\n""  /versioning/ versiontag(45)\n""  /resonances/ massres(55),widres(55),massmes(40),widmes(40),mmesmn(40),branres(12,25),branmes(28,39),branbs1(11,21),branbs2(4,5),bs1type(4,11),bs2type(4,4),lbs1(11,21),lbs2(4,5),lbm(28,39),jres(55),jmes(40),lbr(12,25),brtype(4,12),pares(55),pames(40),bmtype(4,28),isores(55),isomes(40),strres(55),strmes(40),mlt2it(39),chrmres(55),chrmmes(40)\n""  /sigtabi/ sigmaln(21,2,15),sigmainf(10,20)\n""  /sigtabr/ sigmas(10,100),sigmascal(10,5)\n""  /normsplin/ x_norm(4,800),y_norm(4,800),dx\n""  /cgks/ cgktab(8,8,15,15,8)\n""  /factorials/ logfak(101)\n""  /pydat1/ mstu(200),paru(200),mstj(200),parj(200)\n""  /pydat2/ kchg(500,4),pmas(500,4),parf(2000),vckm(4,4)\n""  /pydat3/ mdcy(500,3),mdme(8000,2),brat(8000),kfdp(8000,5)\n""  /pydat4/ chaf(500,2,16)\n""  /pydatr/ mrpy(6),rrpy(100)\n""  /pysubs/ msel,mselpd,msub(500),kfin(2,81),ckin(200)\n""  /pypars/ mstp(200),parp(200),msti(200),pari(200)\n""  /pyint1/ mint(400),vint(400)\n""  /pyint2/ iset(500),kfpr(500,2),coef(500,20),icol(40,4,2)\n""  /pyint3/ xsfx(2,81),isig(1000,3),sigh(1000)\n""  /pyint4/ mwid(500),wids(500,5)\n""  /pyint5/ ngenpd,ngen(501,3),xsec(501,3)\n""  /pyint6/ proc(501,28)\n""  /pyint7/ sigt(7,7,6)\n""  /pymssm/ imss(100),rmss(100)\n""  /pyssmt/ zmix(4,4),umix(2,2),vmix(2,2),smz(4),smw(2),sfmix(16,4),zmixi(4,4),umixi(2,2),vmixi(2,2)\n""  /pymsrv/ rvlam(3,3,3),rvlamp(3,3,3),rvlamb(3,3,3)\n""  /pytcsm/ itcm(100),rtcm(100)\n""  /pybins/ ihist(4),indx(1000),bin(20000)\n""  /pylh3p/ modsel(200),parmin(100),parext(200),rmsoft(101),au(3,3),ad(3,3),ae(3,3)\n""  /pylh3c/ cpro(2,12),cver(2,12)\n""  /sys/ npart,nbar,nmes,ctag,nsteps,uid_cnt,ranseed,event,ap,at,zp,zt,eos,dectag,nhardres,nsoftres,ndecres,nelcoll,nblcoll,success\n""  /rsys/ time,acttime,bdist,bimp,bmin,ebeam,ecm\n""  /comseed/ firstseed\n""  /logic/ lsct(40000),logsky,logyuk,logcb,logpau\n""  /mdprop/ r0_t(40000),rx_t(40000),ry_t(40000),rz_t(40000)\n""  /cuts/ cutmax,cutpau,cutcb,cutyuk,cutsky,cutdww\n""  /spdata/ spx(500),sppauy(500),outpau(500),spcby(500),outcb(500),spyuky(500),outyuk(500),spskyy(500),outsky(500),spdwwy(500),outdww(500)\n""  /isys/ spin(40000),ncoll(40000),charge(40000),ityp(40000),lstcoll(40000),iso3(40000),origin(40000),uid(40000)\n""  /coor/ r0(40000),rx(40000),ry(40000),rz(40000),p0(40000),px(40000),py(40000),pz(40000),fmass(40000),rww(40000),dectime(40000)\n""  /frag/ tform(40000),xtotfac(40000)\n""  /aios/ airx(40000),airy(40000),airz(40000),aipx(40000),aipy(40000),aipz(40000),aorx(40000,4),aory(40000,4),aorz(40000,4),aopx(40000,4),aopy(40000,4),aopz(40000,4)\n""  /pots/ cb0,yuk0,pau0,sky20,sky30,gamsky,gamyuk,drpau,dppau,gw,sgw,delr,fdel,dt,da,db,dtimestep\n""  /scoor/ r0s(500),rxs(500),rys(500),rzs(500),p0s(500),pxs(500),pys(500),pzs(500),sfmass(500)\n""  /sisys/ sspin(500),scharge(500),sityp(500),siso3(500),suid(500)\n""  /ssys/ nspec\n""  /rtdelay/ p0td(2,40000),pxtd(2,40000),pytd(2,40000),pztd(2,40000),fmasstd(2,40000)\n""  /itdelay/ ityptd(2,40000),iso3td(2,40000)\n""  /svinfo/ itypt(2),uidt(2),origint(2),iso3t(2)\n""  /ffermi/ ffermpx(40000),ffermpy(40000),ffermpz(40000)\n""  /peq/ peq1,peq2\n""  /_BLNK_/ cross(60)\n""  /options/ ctoption(400),ctparam(400)\n""  /optstrings/ ctodc(400,2),ctpdc(400,2)\n""  /loptions/ fixedseed,bf13,bf14,bf15,bf16,bf17,bf18,bf19,bf20\n""  /stables/ nstable,stabvec(20)\n""  /inputs/ nevents,spityp(2),prspflg,trspflg,spiso3(2),outsteps,bflag,srtflag,efuncflag,nsrt,firstev,npb\n""  /input2/ srtmin,srtmax,pbeam,betann,betatar,betapro,pbmin,pbmax\n""  /protarints/ pt_iso3(6000,2),pt_ityp(6000,2),pt_spin(6000,2),pt_charge(6000,2),pt_aa(2),pt_uid(6000,2)\n""  /protarreals/ pt_r0(6000,2),pt_rx(6000,2),pt_ry(6000,2),pt_rz(6000,2),pt_fmass(6000,2),pt_dectime(6000,2),pt_p0(6000,2),pt_px(6000,2),pt_py(6000,2),pt_pz(6000,2),pt_rho(6000,2),pt_pmax(6000,2)\n""  /inewpart/ itypnew(1000),i3new(1000),itot(1000),inew(1000),nexit,iline,strcount,pslot(2),nstring1,nstring2,itypold(2),iso3old(2)\n""  /rnewpart/ pnew(5,1000),xnew(4,1000),betax,betay,betaz,pold(5,2),p0nn,pxnn,pynn,pznn,pnn,mstring(2),pnnout,xtotfacold(2)\n""  /fnewpart/ leadfac(1000)\n""  /frcoor/ frr0(40000),frrx(40000),frry(40000),frrz(40000),frp0(40000),frpx(40000),frpy(40000),frpz(40000)\n""  /boxic/ cbox,boxflag,mbox,bptityp(20),bptiso3(20),bptpart(20),edensflag,para,solid,mbflag,mtest\n""  /boxrc/ lbox,lboxhalbe,lboxd,bptpmax(20),edens,mbp0,mbpx,mbpy,mbpz\n""  /outco2/ sigmatot\n""  /outcom/ tsqrts,tstot,tsigpart,tr0(3),trx(3),try(3),trz(3),ttform(3),txtotfac(3),tp0(3),tpx(3),tpy(3),tpz(3),tm(3),tind(3),tityp(3),tiso3(3),tcoll(3),tstrange(3),tlcoll(3),tcharge(3),torigin(3),tuid(3)\n""  /frgspa/ pjspns,pmix1s(3,8),pmix2s(3,8),pbars,parqls,parrs\n""  /frgcpa/ pjspnc,pmix1c(3,8),pmix2c(3,8),pbarc\n""  /coparm/ parm(8)\n""  /const/ pi\n""  /kappa/ xap\n""  /consti/ consti\n""  /comtry/ ntries\n""  /colltab/ cttime(20001),ctsqrts(20000),ctsigtot(20000),tmin,cti1(20000),cti2(20000),nct,actcol,ctvalid(20000),ctsav(20000),nsav,apt,ctcolfluc(20000)\n""  /energies/ ekinbar,ekinmes,esky2,esky3,eyuk,ecb,epau\n""  /cncc/ ncc\n""  /ini/ bcorr\n""  /decaywidth/ tabx(120),fbtaby(120,55,2),pbtaby(120,2,55,12),fmtaby(120,40,2),pmtaby(120,2,40,28),wtabflg\n""  /brwignorm/ bwbarnorm(55),bwmesnorm(40)\n""  /xsections/ tabxnd(120),frrtaby(120,2,2,25)\n""  /tabnames/ tabname(77)\n""  /hera/ a(16),b(16),n(16),c(16),d(16),p1(16),p2(16)\n""  /regge/ z(16),y1(16),y2(16),s0,s1,eta1,eta2,bb\n""  /hepevt/ nevhep,nhep,isthep(40000),idhep(40000),jmohep(2,40000),jdahep(2,40000),phep(5,40000),vhep(4,40000)\n""  /uqchg/ ichg(40000)\n""  /npy/ bitgen\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  _urqmd34_error = PyErr_NewException ("_urqmd34.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "__urqmd34_error", _urqmd34_error);
  Py_DECREF(_urqmd34_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }



    {
      extern string F_FUNC(partname,PARTNAME)(void);
      PyObject* o = PyDict_GetItemString(d,"partname");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(partname,PARTNAME),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("partname");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    























    {
      extern double F_FUNC(ptsigtot,PTSIGTOT)(void);
      PyObject* o = PyDict_GetItemString(d,"ptsigtot");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(ptsigtot,PTSIGTOT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("ptsigtot");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    






    {
      extern double F_FUNC(nucrad,NUCRAD)(void);
      PyObject* o = PyDict_GetItemString(d,"nucrad");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(nucrad,NUCRAD),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("nucrad");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    







/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_versioning_def,f2py_init_versioning);
  F2PyDict_SetItemString(d, "versioning", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_resonances_def,f2py_init_resonances);
  F2PyDict_SetItemString(d, "resonances", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_sigtabi_def,f2py_init_sigtabi);
  F2PyDict_SetItemString(d, "sigtabi", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_sigtabr_def,f2py_init_sigtabr);
  F2PyDict_SetItemString(d, "sigtabr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_normsplin_def,f2py_init_normsplin);
  F2PyDict_SetItemString(d, "normsplin", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cgks_def,f2py_init_cgks);
  F2PyDict_SetItemString(d, "cgks", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_factorials_def,f2py_init_factorials);
  F2PyDict_SetItemString(d, "factorials", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydat1_def,f2py_init_pydat1);
  F2PyDict_SetItemString(d, "pydat1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydat2_def,f2py_init_pydat2);
  F2PyDict_SetItemString(d, "pydat2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydat3_def,f2py_init_pydat3);
  F2PyDict_SetItemString(d, "pydat3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydat4_def,f2py_init_pydat4);
  F2PyDict_SetItemString(d, "pydat4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pydatr_def,f2py_init_pydatr);
  F2PyDict_SetItemString(d, "pydatr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pysubs_def,f2py_init_pysubs);
  F2PyDict_SetItemString(d, "pysubs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pypars_def,f2py_init_pypars);
  F2PyDict_SetItemString(d, "pypars", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint1_def,f2py_init_pyint1);
  F2PyDict_SetItemString(d, "pyint1", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint2_def,f2py_init_pyint2);
  F2PyDict_SetItemString(d, "pyint2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint3_def,f2py_init_pyint3);
  F2PyDict_SetItemString(d, "pyint3", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint4_def,f2py_init_pyint4);
  F2PyDict_SetItemString(d, "pyint4", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint5_def,f2py_init_pyint5);
  F2PyDict_SetItemString(d, "pyint5", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint6_def,f2py_init_pyint6);
  F2PyDict_SetItemString(d, "pyint6", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyint7_def,f2py_init_pyint7);
  F2PyDict_SetItemString(d, "pyint7", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pymssm_def,f2py_init_pymssm);
  F2PyDict_SetItemString(d, "pymssm", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pyssmt_def,f2py_init_pyssmt);
  F2PyDict_SetItemString(d, "pyssmt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pymsrv_def,f2py_init_pymsrv);
  F2PyDict_SetItemString(d, "pymsrv", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pytcsm_def,f2py_init_pytcsm);
  F2PyDict_SetItemString(d, "pytcsm", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pybins_def,f2py_init_pybins);
  F2PyDict_SetItemString(d, "pybins", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pylh3p_def,f2py_init_pylh3p);
  F2PyDict_SetItemString(d, "pylh3p", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pylh3c_def,f2py_init_pylh3c);
  F2PyDict_SetItemString(d, "pylh3c", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_sys_def,f2py_init_sys);
  F2PyDict_SetItemString(d, "sys", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_rsys_def,f2py_init_rsys);
  F2PyDict_SetItemString(d, "rsys", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_comseed_def,f2py_init_comseed);
  F2PyDict_SetItemString(d, "comseed", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_logic_def,f2py_init_logic);
  F2PyDict_SetItemString(d, "logic", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mdprop_def,f2py_init_mdprop);
  F2PyDict_SetItemString(d, "mdprop", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cuts_def,f2py_init_cuts);
  F2PyDict_SetItemString(d, "cuts", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_spdata_def,f2py_init_spdata);
  F2PyDict_SetItemString(d, "spdata", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_isys_def,f2py_init_isys);
  F2PyDict_SetItemString(d, "isys", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_coor_def,f2py_init_coor);
  F2PyDict_SetItemString(d, "coor", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frag_def,f2py_init_frag);
  F2PyDict_SetItemString(d, "frag", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_aios_def,f2py_init_aios);
  F2PyDict_SetItemString(d, "aios", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_pots_def,f2py_init_pots);
  F2PyDict_SetItemString(d, "pots", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_scoor_def,f2py_init_scoor);
  F2PyDict_SetItemString(d, "scoor", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_sisys_def,f2py_init_sisys);
  F2PyDict_SetItemString(d, "sisys", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ssys_def,f2py_init_ssys);
  F2PyDict_SetItemString(d, "ssys", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_rtdelay_def,f2py_init_rtdelay);
  F2PyDict_SetItemString(d, "rtdelay", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_itdelay_def,f2py_init_itdelay);
  F2PyDict_SetItemString(d, "itdelay", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_svinfo_def,f2py_init_svinfo);
  F2PyDict_SetItemString(d, "svinfo", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ffermi_def,f2py_init_ffermi);
  F2PyDict_SetItemString(d, "ffermi", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_peq_def,f2py_init_peq);
  F2PyDict_SetItemString(d, "peq", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py__BLNK__def,f2py_init__BLNK_);
  F2PyDict_SetItemString(d, "_BLNK_", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_options_def,f2py_init_options);
  F2PyDict_SetItemString(d, "options", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_optstrings_def,f2py_init_optstrings);
  F2PyDict_SetItemString(d, "optstrings", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_loptions_def,f2py_init_loptions);
  F2PyDict_SetItemString(d, "loptions", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_stables_def,f2py_init_stables);
  F2PyDict_SetItemString(d, "stables", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_inputs_def,f2py_init_inputs);
  F2PyDict_SetItemString(d, "inputs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_input2_def,f2py_init_input2);
  F2PyDict_SetItemString(d, "input2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_protarints_def,f2py_init_protarints);
  F2PyDict_SetItemString(d, "protarints", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_protarreals_def,f2py_init_protarreals);
  F2PyDict_SetItemString(d, "protarreals", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_inewpart_def,f2py_init_inewpart);
  F2PyDict_SetItemString(d, "inewpart", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_rnewpart_def,f2py_init_rnewpart);
  F2PyDict_SetItemString(d, "rnewpart", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_fnewpart_def,f2py_init_fnewpart);
  F2PyDict_SetItemString(d, "fnewpart", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frcoor_def,f2py_init_frcoor);
  F2PyDict_SetItemString(d, "frcoor", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_boxic_def,f2py_init_boxic);
  F2PyDict_SetItemString(d, "boxic", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_boxrc_def,f2py_init_boxrc);
  F2PyDict_SetItemString(d, "boxrc", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_outco2_def,f2py_init_outco2);
  F2PyDict_SetItemString(d, "outco2", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_outcom_def,f2py_init_outcom);
  F2PyDict_SetItemString(d, "outcom", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frgspa_def,f2py_init_frgspa);
  F2PyDict_SetItemString(d, "frgspa", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_frgcpa_def,f2py_init_frgcpa);
  F2PyDict_SetItemString(d, "frgcpa", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_coparm_def,f2py_init_coparm);
  F2PyDict_SetItemString(d, "coparm", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_const_def,f2py_init_const);
  F2PyDict_SetItemString(d, "const", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_kappa_def,f2py_init_kappa);
  F2PyDict_SetItemString(d, "kappa", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_consti_def,f2py_init_consti);
  F2PyDict_SetItemString(d, "consti", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_comtry_def,f2py_init_comtry);
  F2PyDict_SetItemString(d, "comtry", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_colltab_def,f2py_init_colltab);
  F2PyDict_SetItemString(d, "colltab", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_energies_def,f2py_init_energies);
  F2PyDict_SetItemString(d, "energies", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_cncc_def,f2py_init_cncc);
  F2PyDict_SetItemString(d, "cncc", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ini_def,f2py_init_ini);
  F2PyDict_SetItemString(d, "ini", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_decaywidth_def,f2py_init_decaywidth);
  F2PyDict_SetItemString(d, "decaywidth", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_brwignorm_def,f2py_init_brwignorm);
  F2PyDict_SetItemString(d, "brwignorm", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_xsections_def,f2py_init_xsections);
  F2PyDict_SetItemString(d, "xsections", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_tabnames_def,f2py_init_tabnames);
  F2PyDict_SetItemString(d, "tabnames", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hera_def,f2py_init_hera);
  F2PyDict_SetItemString(d, "hera", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_regge_def,f2py_init_regge);
  F2PyDict_SetItemString(d, "regge", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_hepevt_def,f2py_init_hepevt);
  F2PyDict_SetItemString(d, "hepevt", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_uqchg_def,f2py_init_uqchg);
  F2PyDict_SetItemString(d, "uqchg", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_npy_def,f2py_init_npy);
  F2PyDict_SetItemString(d, "npy", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_urqmd34");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
