
      SUBROUTINE DT_XSHN(Ip,It,Pl,Ecm,Stot,Sela)
 
C***********************************************************************
C Total and elastic hadron-nucleon cross section.                      *
C Below 5GeV cross sections are based on the '98 data compilation    *
C of the PDG. At higher energies PHOJET results are used (patched to   *
C the low energy data at 5GeV).                                      *
C     IP      projectile index (BAMJET numbering scheme)               *
C             (should be in the range 1..25)                           *
C     IT      target index (BAMJET numbering scheme)                   *
C             (1 = proton, 8 = neutron)                                *
C     PL      laboratory momentum                                      *
C     ECM     cm. energy (ignored if PL>0)                             *
C     STOT    total cross section                                      *
C     SELA    elastic cross section                                    *
C Last change: 24.4.99 by S. Roesler                                   *
C***********************************************************************
 
      IMPLICIT NONE
      DOUBLE PRECISION adp1 , adp2 , aphose , aphost , apl , aplab , 
     &                 aplabh , aplabl , apthre , asela , asela1 , 
     &                 asela2 , asigel , asigto , astot , astot1 , 
     &                 astot2 , dum0 , dum1 , dum2
      DOUBLE PRECISION Ecm , ecms , elab , fac , ONE , phoela , phopla , 
     &                 phosel , phosin , phosto , Pl , plab , PLABHI , 
     &                 PLABLO , PTHRE , Sela , Stot , ZERO
      INTEGER i , idx0 , idx1 , idxdat , idxp , idxs , idxs1 , idxs2 , 
     &        idxt , Ip , It , k , NPOINT
      SAVE 
 
      INCLUDE 'inc/dtflka'
 
Cf2py intent(out) STOT,SELA
 
      PARAMETER (ZERO=0.0D0,ONE=1.0D0)
      INTEGER npoin1 , npoin2 , npotot
      PARAMETER (PLABLO=0.1D0,PTHRE=3.D0,PLABHI=5.0D0)
      PARAMETER (NPOINT=63)
 
      LOGICAL lfirst
C particle properties (BAMJET index convention)
      INCLUDE 'inc/dtpart'
C nucleon-nucleon event-generator
      INCLUDE 'inc/dtmodl'
C*PHOJET105a
C     PARAMETER (IEETAB=10)
C     COMMON /XSETAB/ SIGTAB(4,70,IEETAB),SIGECM(4,IEETAB),ISIMAX
C*PHOJET110
C  current beam selection
      INCLUDE 'inc/pobeam'
C  energy-interpolation table
      INCLUDE 'inc/potabl'
 
      DIMENSION apl(NPOINT) , asigto(10,NPOINT) , asigel(10,NPOINT)
      DIMENSION idxdat(25,2)
 
C energy grid 0.1 GeV - 500 GeV
      DATA apl/ - 1.000 , -0.969 , -0.937 , -0.906 , -0.874 , -0.843 , 
     &     -0.811 , -0.780 , -0.748 , -0.717 , -0.685 , -0.654 , 
     &     -0.622 , -0.591 , -0.560 , -0.528 , -0.497 , -0.465 , 
     &     -0.434 , -0.402 , -0.371 , -0.339 , -0.308 , -0.276 , 
     &     -0.245 , -0.213 , -0.182 , -0.151 , -0.119 , -0.088 , 
     &     -0.056 , -0.025 , 0.007 , 0.038 , 0.070 , 0.101 , 0.133 , 
     &     0.164 , 0.196 , 0.227 , 0.258 , 0.290 , 0.321 , 0.353 , 
     &     0.384 , 0.416 , 0.447 , 0.479 , 0.510 , 0.542 , 0.573 , 
     &     0.605 , 0.636 , 0.668 , 0.699 , 0.949 , 1.199 , 1.449 , 
     &     1.699 , 1.949 , 2.199 , 2.449 , 2.699/
C
C total cross sections:
C p p
      DATA (asigto(1,k),k=1,NPOINT)/2.837 , 2.760 , 2.686 , 2.614 , 
     &      2.543 , 2.472 , 2.401 , 2.329 , 2.255 , 2.180 , 2.103 , 
     &      2.030 , 1.968 , 1.919 , 1.861 , 1.775 , 1.698 , 1.646 , 
     &      1.577 , 1.518 , 1.462 , 1.420 , 1.393 , 1.375 , 1.363 , 
     &      1.356 , 1.352 , 1.350 , 1.351 , 1.359 , 1.381 , 1.410 , 
     &      1.444 , 1.487 , 1.544 , 1.596 , 1.650 , 1.672 , 1.676 , 
     &      1.677 , 1.677 , 1.675 , 1.675 , 1.669 , 1.664 , 1.658 , 
     &      1.653 , 1.645 , 1.640 , 1.634 , 1.630 , 1.625 , 1.620 , 
     &      1.617 , 1.614 , 1.602 , 1.594 , 1.589 , 1.581 , 1.583 , 
     &      1.588 , 1.596 , 1.603/
C pbar p
      DATA (asigto(2,k),k=1,NPOINT)/2.778 , 2.759 , 2.739 , 2.718 , 
     &      2.697 , 2.675 , 2.651 , 2.626 , 2.598 , 2.569 , 2.537 , 
     &      2.502 , 2.471 , 2.443 , 2.420 , 2.389 , 2.361 , 2.329 , 
     &      2.313 , 2.304 , 2.268 , 2.244 , 2.222 , 2.212 , 2.178 , 
     &      2.162 , 2.151 , 2.132 , 2.109 , 2.097 , 2.089 , 2.078 , 
     &      2.063 , 2.049 , 2.035 , 2.024 , 2.014 , 2.004 , 1.993 , 
     &      1.981 , 1.970 , 1.958 , 1.946 , 1.933 , 1.921 , 1.909 , 
     &      1.894 , 1.885 , 1.871 , 1.854 , 1.836 , 1.825 , 1.816 , 
     &      1.802 , 1.790 , 1.744 , 1.694 , 1.663 , 1.642 , 1.614 , 
     &      1.623 , 1.623 , 1.630/
C n p
      DATA (asigto(3,k),k=1,NPOINT)/3.192 , 3.145 , 3.097 , 3.047 , 
     &      2.995 , 2.940 , 2.883 , 2.824 , 2.763 , 2.700 , 2.634 , 
     &      2.565 , 2.494 , 2.420 , 2.344 , 2.269 , 2.196 , 2.115 , 
     &      2.048 , 1.964 , 1.906 , 1.842 , 1.779 , 1.719 , 1.656 , 
     &      1.604 , 1.569 , 1.547 , 1.534 , 1.526 , 1.522 , 1.520 , 
     &      1.525 , 1.536 , 1.550 , 1.566 , 1.578 , 1.580 , 1.581 , 
     &      1.584 , 1.590 , 1.598 , 1.605 , 1.608 , 1.609 , 1.608 , 
     &      1.608 , 1.608 , 1.608 , 1.608 , 1.607 , 1.606 , 1.606 , 
     &      1.605 , 1.606 , 1.599 , 1.588 , 1.587 , 1.586 , 1.589 , 
     &      1.592 , 1.597 , 1.600/
C pi+ p
      DATA (asigto(4,k),k=1,NPOINT)/0.643 , 0.786 , 0.929 , 1.074 , 
     &      1.199 , 1.272 , 1.340 , 1.484 , 1.610 , 1.750 , 1.881 , 
     &      2.014 , 2.178 , 2.244 , 2.301 , 2.309 , 2.219 , 2.118 , 
     &      2.001 , 1.875 , 1.801 , 1.665 , 1.609 , 1.484 , 1.412 , 
     &      1.334 , 1.195 , 1.160 , 1.166 , 1.208 , 1.309 , 1.356 , 
     &      1.394 , 1.406 , 1.419 , 1.473 , 1.540 , 1.596 , 1.570 , 
     &      1.533 , 1.516 , 1.484 , 1.471 , 1.478 , 1.492 , 1.497 , 
     &      1.491 , 1.479 , 1.465 , 1.453 , 1.449 , 1.450 , 1.444 , 
     &      1.428 , 1.422 , 1.406 , 1.384 , 1.369 , 1.364 , 1.369 , 
     &      1.374 , 1.388 , 1.395/
C pi- p
      DATA (asigto(5,k),k=1,NPOINT)/0.458 , 0.540 , 0.626 , 0.718 , 
     &      0.819 , 0.933 , 1.063 , 1.208 , 1.226 , 1.436 , 1.470 , 
     &      1.594 , 1.708 , 1.786 , 1.852 , 1.836 , 1.763 , 1.679 , 
     &      1.590 , 1.492 , 1.445 , 1.426 , 1.423 , 1.433 , 1.473 , 
     &      1.506 , 1.547 , 1.660 , 1.671 , 1.545 , 1.591 , 1.687 , 
     &      1.808 , 1.656 , 1.582 , 1.543 , 1.562 , 1.560 , 1.537 , 
     &      1.540 , 1.549 , 1.557 , 1.557 , 1.551 , 1.535 , 1.527 , 
     &      1.511 , 1.510 , 1.507 , 1.500 , 1.491 , 1.483 , 1.478 , 
     &      1.468 , 1.463 , 1.435 , 1.408 , 1.394 , 1.384 , 1.380 , 
     &      1.383 , 1.393 , 1.411/
C K+ p
      DATA (asigto(6,k),k=1,NPOINT)/1.097 , 1.097 , 1.097 , 1.097 , 
     &      1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 
     &      1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 
     &      1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 1.097 , 
     &      1.096 , 1.095 , 1.098 , 1.105 , 1.111 , 1.139 , 1.169 , 
     &      1.209 , 1.248 , 1.259 , 1.268 , 1.262 , 1.257 , 1.254 , 
     &      1.252 , 1.250 , 1.249 , 1.246 , 1.244 , 1.244 , 1.243 , 
     &      1.240 , 1.238 , 1.237 , 1.236 , 1.235 , 1.235 , 1.236 , 
     &      1.236 , 1.236 , 1.233 , 1.238 , 1.248 , 1.257 , 1.272 , 
     &      1.292 , 1.311 , 1.336/
C K- p
      DATA (asigto(7,k),k=1,NPOINT)/2.003 , 2.002 , 2.001 , 2.000 , 
     &      1.999 , 1.998 , 1.998 , 1.997 , 1.997 , 1.996 , 1.995 , 
     &      1.993 , 1.990 , 1.992 , 1.974 , 1.912 , 1.865 , 1.847 , 
     &      1.896 , 1.950 , 1.827 , 1.681 , 1.637 , 1.616 , 1.589 , 
     &      1.545 , 1.543 , 1.532 , 1.603 , 1.604 , 1.616 , 1.658 , 
     &      1.700 , 1.658 , 1.595 , 1.508 , 1.493 , 1.514 , 1.531 , 
     &      1.523 , 1.501 , 1.479 , 1.474 , 1.467 , 1.463 , 1.450 , 
     &      1.444 , 1.435 , 1.426 , 1.424 , 1.423 , 1.415 , 1.401 , 
     &      1.396 , 1.384 , 1.364 , 1.330 , 1.313 , 1.310 , 1.309 , 
     &      1.317 , 1.329 , 1.338/
C K+ n
      DATA (asigto(8,k),k=1,NPOINT)/0.176 , 0.229 , 0.282 , 0.334 , 
     &      0.386 , 0.437 , 0.487 , 0.536 , 0.584 , 0.631 , 0.675 , 
     &      0.719 , 0.760 , 0.799 , 0.835 , 0.870 , 0.901 , 0.931 , 
     &      0.958 , 0.984 , 1.008 , 1.032 , 1.056 , 1.079 , 1.102 , 
     &      1.125 , 1.147 , 1.168 , 1.187 , 1.205 , 1.224 , 1.248 , 
     &      1.279 , 1.315 , 1.324 , 1.301 , 1.285 , 1.279 , 1.274 , 
     &      1.273 , 1.272 , 1.271 , 1.267 , 1.263 , 1.261 , 1.259 , 
     &      1.256 , 1.252 , 1.247 , 1.244 , 1.241 , 1.240 , 1.240 , 
     &      1.240 , 1.241 , 1.243 , 1.245 , 1.253 , 1.265 , 1.275 , 
     &      1.293 , 1.314 , 1.342/
C K- n
      DATA (asigto(9,k),k=1,NPOINT)/1.778 , 1.778 , 1.778 , 1.778 , 
     &      1.778 , 1.778 , 1.778 , 1.778 , 1.778 , 1.778 , 1.778 , 
     &      1.778 , 1.778 , 1.778 , 1.779 , 1.779 , 1.778 , 1.773 , 
     &      1.765 , 1.746 , 1.703 , 1.646 , 1.561 , 1.488 , 1.454 , 
     &      1.437 , 1.437 , 1.458 , 1.505 , 1.561 , 1.588 , 1.593 , 
     &      1.581 , 1.551 , 1.500 , 1.454 , 1.427 , 1.408 , 1.390 , 
     &      1.372 , 1.361 , 1.356 , 1.351 , 1.347 , 1.343 , 1.341 , 
     &      1.340 , 1.338 , 1.337 , 1.335 , 1.334 , 1.332 , 1.331 , 
     &      1.330 , 1.330 , 1.313 , 1.303 , 1.288 , 1.288 , 1.297 , 
     &      1.305 , 1.320 , 1.342/
C Lambda p
      DATA (asigto(10,k),k=1,NPOINT)/2.648 , 2.598 , 2.548 , 2.498 , 
     &      2.446 , 2.394 , 2.340 , 2.283 , 2.224 , 2.160 , 2.091 , 
     &      2.015 , 1.936 , 1.858 , 1.785 , 1.720 , 1.669 , 1.629 , 
     &      1.599 , 1.576 , 1.558 , 1.543 , 1.530 , 1.520 , 1.512 , 
     &      1.505 , 1.499 , 1.495 , 1.495 , 1.497 , 1.504 , 1.514 , 
     &      1.525 , 1.536 , 1.550 , 1.567 , 1.578 , 1.580 , 1.581 , 
     &      1.584 , 1.590 , 1.598 , 1.605 , 1.608 , 1.609 , 1.608 , 
     &      1.608 , 1.608 , 1.608 , 1.608 , 1.607 , 1.606 , 1.606 , 
     &      1.605 , 1.606 , 1.599 , 1.588 , 1.587 , 1.586 , 1.589 , 
     &      1.592 , 1.597 , 1.600/
C
C elastic cross sections:
C p p
      DATA (asigel(1,k),k=1,NPOINT)/2.837 , 2.760 , 2.686 , 2.614 , 
     &      2.543 , 2.472 , 2.401 , 2.329 , 2.255 , 2.180 , 2.103 , 
     &      2.030 , 1.968 , 1.919 , 1.861 , 1.775 , 1.698 , 1.646 , 
     &      1.577 , 1.518 , 1.462 , 1.420 , 1.393 , 1.374 , 1.360 , 
     &      1.353 , 1.350 , 1.351 , 1.356 , 1.362 , 1.369 , 1.376 , 
     &      1.384 , 1.385 , 1.399 , 1.397 , 1.389 , 1.385 , 1.379 , 
     &      1.366 , 1.358 , 1.344 , 1.320 , 1.294 , 1.275 , 1.260 , 
     &      1.248 , 1.235 , 1.219 , 1.199 , 1.172 , 1.144 , 1.126 , 
     &      1.115 , 1.104 , 1.013 , 0.962 , 0.905 , 0.869 , 0.845 , 
     &      0.846 , 0.850 , 0.868/
C pbar p
      DATA (asigel(2,k),k=1,NPOINT)/1.987 , 1.985 , 1.983 , 1.980 , 
     &      1.978 , 1.975 , 1.971 , 1.968 , 1.963 , 1.958 , 1.951 , 
     &      1.944 , 1.935 , 1.925 , 1.914 , 1.902 , 1.889 , 1.875 , 
     &      1.859 , 1.845 , 1.834 , 1.817 , 1.792 , 1.769 , 1.754 , 
     &      1.738 , 1.720 , 1.702 , 1.688 , 1.676 , 1.667 , 1.659 , 
     &      1.652 , 1.645 , 1.640 , 1.636 , 1.620 , 1.591 , 1.562 , 
     &      1.546 , 1.540 , 1.524 , 1.496 , 1.475 , 1.457 , 1.429 , 
     &      1.402 , 1.373 , 1.344 , 1.330 , 1.306 , 1.294 , 1.265 , 
     &      1.228 , 1.204 , 1.086 , 0.977 , 0.933 , 0.914 , 0.850 , 
     &      0.862 , 0.848 , 0.845/
C n p
      DATA (asigel(3,k),k=1,NPOINT)/3.192 , 3.145 , 3.097 , 3.047 , 
     &      2.995 , 2.940 , 2.883 , 2.824 , 2.763 , 2.700 , 2.634 , 
     &      2.565 , 2.494 , 2.420 , 2.344 , 2.269 , 2.196 , 2.115 , 
     &      2.048 , 1.964 , 1.906 , 1.842 , 1.779 , 1.719 , 1.656 , 
     &      1.604 , 1.569 , 1.544 , 1.527 , 1.514 , 1.504 , 1.495 , 
     &      1.486 , 1.476 , 1.466 , 1.454 , 1.440 , 1.425 , 1.409 , 
     &      1.392 , 1.375 , 1.358 , 1.340 , 1.322 , 1.304 , 1.285 , 
     &      1.267 , 1.250 , 1.234 , 1.219 , 1.202 , 1.181 , 1.158 , 
     &      1.136 , 1.116 , 0.727 , -2.128 , -10.0 , -10.0 , -10.0 , 
     &      -10.0 , -10.0 , -10.0/
C pi+ p
      DATA (asigel(4,k),k=1,NPOINT)/0.643 , 0.786 , 0.929 , 1.074 , 
     &      1.199 , 1.272 , 1.340 , 1.484 , 1.610 , 1.750 , 1.881 , 
     &      2.014 , 2.178 , 2.244 , 2.301 , 2.309 , 2.219 , 2.118 , 
     &      2.001 , 1.875 , 1.801 , 1.664 , 1.610 , 1.479 , 1.423 , 
     &      1.299 , 1.166 , 1.097 , 1.020 , 0.958 , 0.914 , 1.013 , 
     &      1.088 , 1.153 , 1.167 , 1.235 , 1.240 , 1.237 , 1.202 , 
     &      1.135 , 1.090 , 1.026 , 0.975 , 0.941 , 0.904 , 0.894 , 
     &      0.884 , 0.862 , 0.850 , 0.845 , 0.827 , 0.805 , 0.789 , 
     &      0.776 , 0.763 , 0.686 , 0.626 , 0.562 , 0.505 , 0.518 , 
     &      0.525 , 0.528 , 0.528/
C pi- p
      DATA (asigel(5,k),k=1,NPOINT)/0.266 , 0.278 , 0.294 , 0.320 , 
     &      0.360 , 0.419 , 0.503 , 0.608 , 0.727 , 0.850 , 0.968 , 
     &      1.071 , 1.167 , 1.305 , 1.369 , 1.404 , 1.446 , 1.217 , 
     &      1.112 , 1.071 , 1.014 , 1.002 , 0.996 , 1.008 , 1.070 , 
     &      1.126 , 1.209 , 1.300 , 1.281 , 1.188 , 1.156 , 1.341 , 
     &      1.423 , 1.314 , 1.171 , 1.140 , 1.106 , 1.071 , 1.011 , 
     &      1.037 , 1.026 , 1.024 , 0.988 , 0.953 , 0.895 , 0.894 , 
     &      0.880 , 0.871 , 0.864 , 0.853 , 0.837 , 0.820 , 0.809 , 
     &      0.800 , 0.782 , 0.674 , 0.612 , 0.530 , 0.521 , 0.528 , 
     &      0.524 , 0.542 , 0.569/
C K+ p
      DATA (asigel(6,k),k=1,NPOINT)/1.064 , 1.065 , 1.065 , 1.066 , 
     &      1.066 , 1.066 , 1.066 , 1.066 , 1.066 , 1.065 , 1.064 , 
     &      1.063 , 1.062 , 1.062 , 1.062 , 1.064 , 1.066 , 1.070 , 
     &      1.076 , 1.082 , 1.088 , 1.096 , 1.103 , 1.104 , 1.104 , 
     &      1.102 , 1.093 , 1.087 , 1.084 , 1.079 , 1.075 , 1.067 , 
     &      1.058 , 1.040 , 1.029 , 1.012 , 1.003 , 0.985 , 0.935 , 
     &      0.909 , 0.880 , 0.846 , 0.790 , 0.771 , 0.759 , 0.743 , 
     &      0.718 , 0.681 , 0.666 , 0.645 , 0.622 , 0.606 , 0.594 , 
     &      0.584 , 0.575 , 0.513 , 0.453 , 0.403 , 0.356 , 0.365 , 
     &      0.389 , 0.430 , 0.477/
C K- p
      DATA (asigel(7,k),k=1,NPOINT)/1.941 , 1.936 , 1.931 , 1.926 , 
     &      1.919 , 1.912 , 1.903 , 1.892 , 1.878 , 1.863 , 1.844 , 
     &      1.821 , 1.791 , 1.755 , 1.713 , 1.666 , 1.615 , 1.561 , 
     &      1.533 , 1.531 , 1.518 , 1.511 , 1.452 , 1.339 , 1.265 , 
     &      1.233 , 1.188 , 1.184 , 1.236 , 1.316 , 1.333 , 1.336 , 
     &      1.333 , 1.277 , 1.216 , 1.077 , 1.018 , 0.912 , 0.926 , 
     &      0.920 , 0.910 , 0.894 , 0.830 , 0.825 , 0.800 , 0.788 , 
     &      0.747 , 0.703 , 0.707 , 0.689 , 0.643 , 0.633 , 0.635 , 
     &      0.618 , 0.584 , 0.579 , 0.461 , 0.403 , 0.405 , 0.399 , 
     &      0.408 , 0.418 , 0.413/
C K+ n
      DATA (asigel(8,k),k=1,NPOINT)/0.176 , 0.229 , 0.282 , 0.334 , 
     &      0.386 , 0.437 , 0.487 , 0.536 , 0.584 , 0.631 , 0.676 , 
     &      0.719 , 0.760 , 0.799 , 0.835 , 0.870 , 0.901 , 0.931 , 
     &      0.958 , 0.984 , 1.008 , 1.032 , 1.056 , 1.079 , 1.103 , 
     &      1.126 , 1.148 , 1.168 , 1.187 , 1.205 , 1.223 , 1.248 , 
     &      1.282 , 1.269 , 1.185 , 1.111 , 1.063 , 1.031 , 0.998 , 
     &      0.964 , 0.928 , 0.889 , 0.849 , 0.814 , 0.785 , 0.760 , 
     &      0.738 , 0.720 , 0.703 , 0.688 , 0.674 , 0.660 , 0.648 , 
     &      0.635 , 0.624 , 0.536 , 0.473 , 0.442 , 0.428 , 0.428 , 
     &      0.436 , 0.453 , 0.477/
C K- n
      DATA (asigel(9,k),k=1,NPOINT)/1.613 , 1.613 , 1.613 , 1.613 , 
     &      1.613 , 1.613 , 1.613 , 1.613 , 1.613 , 1.613 , 1.613 , 
     &      1.613 , 1.612 , 1.613 , 1.614 , 1.614 , 1.612 , 1.606 , 
     &      1.593 , 1.564 , 1.498 , 1.402 , 1.240 , 1.071 , 0.977 , 
     &      0.922 , 0.914 , 0.961 , 1.077 , 1.214 , 1.271 , 1.290 , 
     &      1.281 , 1.217 , 1.096 , 0.979 , 0.896 , 0.822 , 0.736 , 
     &      0.655 , 0.608 , 0.591 , 0.580 , 0.569 , 0.559 , 0.550 , 
     &      0.540 , 0.531 , 0.522 , 0.514 , 0.507 , 0.500 , 0.494 , 
     &      0.489 , 0.485 , 0.477 , 0.477 , 0.477 , 0.477 , 0.477 , 
     &      0.477 , 0.477 , 0.477/
C Lambda p
      DATA (asigel(10,k),k=1,NPOINT)/2.648 , 2.598 , 2.548 , 2.498 , 
     &      2.446 , 2.394 , 2.340 , 2.283 , 2.224 , 2.160 , 2.091 , 
     &      2.015 , 1.936 , 1.858 , 1.785 , 1.720 , 1.669 , 1.630 , 
     &      1.600 , 1.577 , 1.558 , 1.542 , 1.528 , 1.518 , 1.510 , 
     &      1.505 , 1.502 , 1.501 , 1.500 , 1.499 , 1.496 , 1.491 , 
     &      1.485 , 1.477 , 1.466 , 1.454 , 1.440 , 1.425 , 1.408 , 
     &      1.392 , 1.375 , 1.358 , 1.340 , 1.322 , 1.304 , 1.285 , 
     &      1.267 , 1.250 , 1.234 , 1.219 , 1.202 , 1.181 , 1.158 , 
     &      1.136 , 1.116 , 0.727 , -2.128 , -10.0 , -10.0 , -10.0 , 
     &      -10.0 , -10.0 , -10.0/
 
      DATA (idxdat(k,1),k=1,25)/1 , 2 , 0 , 0 , 0 , 0 , 0 , 3 , 2 , 0 , 
     &      0 , 67 , 4 , 5 , 6 , 7 , 10 , 2 , 67 , 3 , 1 , 3 , 45 , 8 , 
     &      9/
      DATA (idxdat(k,2),k=1,25)/3 , 2 , 0 , 0 , 0 , 0 , 0 , 1 , 2 , 0 , 
     &      0 , 89 , 5 , 4 , 8 , 9 , 1 , 2 , 89 , 1 , 3 , 1 , 45 , 6 , 
     &      7/
 
      DATA lfirst/.TRUE./
 
 
      IF ( lfirst ) THEN
         aplabl = LOG10(PLABLO)
         aplabh = LOG10(PLABHI)
         apthre = LOG10(PTHRE)
 
C find energy bin where to join PHOJET and tables
         DO i = 1 , NPOINT
            IF ( apl(i).LE.apthre ) THEN
               npoin1 = i
            ELSE IF ( apl(i).LE.aplabh ) THEN
               npotot = i
            ELSE
               GOTO 50
            END IF
            npoin2 = npotot - npoin1
         END DO
 50      adp1 = (apthre-aplabl)/DBLE(npoin1)
         adp2 = (aplabh-apthre)/DBLE(npoin2)
         dum0 = ZERO
         phopla = PLABHI
         phoela = SQRT(AAM(1)**2+phopla**2)
         ecms = SQRT(2.0D0*AAM(1)**2+2.0D0*AAM(1)*phoela)
         IF ( (MCGene.EQ.2) .AND. 
     &        (ecms.LE.SIGecm(ISImax(IDXmpar),1,IDXmpar)) ) THEN
            CALL DT_PHOXS(Ip,It,dum0,phopla,phosto,phosin,dum1,dum2,0)
         ELSE
            CALL DT_PHOXS(Ip,It,dum0,phopla,phosto,phosin,dum1,dum2,1)
         END IF
         phosel = phosto - phosin
         aphost = LOG10(phosto)
         aphose = LOG10(phosel)
         lfirst = .FALSE.
      END IF
      Stot = ZERO
      Sela = ZERO
      plab = Pl
      ecms = Ecm
      IF ( (Ip.LT.1) .OR. ((It.NE.1) .AND. (It.NE.8)) ) THEN
 
         IF ( LPRi.GT.4 ) WRITE (LOUt,99010) Ip , It
99010    FORMAT (1X,'DT_XSHN: cross sections not implemented for ',
     &           'proj/target',2I4)
         STOP 'DT_XSHN: cross sections not implemented for proj/target'
      END IF
 
      IF ( (plab.LE.ZERO) .AND. (ecms.GT.ZERO) ) THEN
         elab = (ecms**2-AAM(Ip)**2-AAM(It)**2)/(2.0D0*AAM(It))
         plab = SQRT((elab-AAM(Ip))*(elab+AAM(Ip)))
      ELSE IF ( (plab.LE.ZERO) .AND. (ecms.LE.ZERO) ) THEN
 
         IF ( LPRi.GT.4 ) WRITE (LOUt,99020) plab , ecms
99020    FORMAT (1X,'DT_XSHN: invalid momentum/cm-energy ',2E15.5)
         STOP
      END IF
 
C index of spectrum
C map particles including strange baryons to the 10 available
C PDG cross-sections. Currently sigma is mapped onto lambda.
      idxp = Ip
      IF ( Ip.GT.25 ) THEN
         IF ( AAM(Ip).LE.ZERO ) THEN
            idxp = 7
         ELSE IF ( ABS(IIBar(Ip)).GT.0 ) THEN
            idxp = 1
         ELSE
            idxp = 13
         END IF
      END IF
      idxt = 1
      IF ( It.EQ.8 ) idxt = 2
C IDXS points to the PDG table entry
      idxs = idxdat(idxp,idxt)
 
C compute momentum bin indices
      IF ( idxs.EQ.0 ) RETURN
      IF ( plab.LT.PLABLO ) THEN
         idx0 = 1
         idx1 = 1
      ELSE IF ( plab.GE.PLABHI ) THEN
         idx0 = npotot
         idx1 = npotot
      ELSE
         aplab = LOG10(plab)
         IF ( (plab.GE.PLABLO) .AND. (plab.LT.PTHRE) ) THEN
            idx0 = INT((aplab-aplabl)/adp1) + 1
         ELSE IF ( (plab.GE.PTHRE) .AND. (plab.LT.PLABHI) ) THEN
            idx0 = INT((aplab-apthre)/adp2) + npoin1 + 1
         END IF
         idx1 = idx0 + 1
      END IF
C interpolate cross section
      IF ( idxs.GT.10 ) THEN
         idxs1 = idxs/10
         idxs2 = idxs - 10*idxs1
         IF ( idx0.NE.idx1 ) THEN
            fac = (aplab-apl(idx0))/(apl(idx1)-apl(idx0))
            astot1 = asigto(idxs1,idx0)
     &               + fac*(asigto(idxs1,idx1)-asigto(idxs1,idx0))
            astot2 = asigto(idxs2,idx0)
     &               + fac*(asigto(idxs2,idx1)-asigto(idxs2,idx0))
            astot = 0.5D0*(astot1+astot2)
            asela1 = asigel(idxs1,idx0)
     &               + fac*(asigel(idxs1,idx1)-asigel(idxs1,idx0))
            asela2 = asigel(idxs2,idx0)
     &               + fac*(asigel(idxs2,idx1)-asigel(idxs2,idx0))
            asela = 0.5D0*(asela1+asela2)
         ELSE IF ( idx0.EQ.1 ) THEN
            astot = 0.5D0*(asigto(idxs1,idx0)+asigto(idxs2,idx0))
            asela = 0.5D0*(asigel(idxs1,idx0)+asigel(idxs2,idx0))
         ELSE
            dum0 = ZERO
            CALL DT_PHOXS(Ip,It,dum0,plab,phosto,phosin,dum1,dum2,0)
            astot = LOG10(phosto)
            asela = LOG10(phosto-phosin)
         END IF
      ELSE IF ( idx0.EQ.idx1 ) THEN
         IF ( idx0.EQ.1 ) THEN
            astot = asigto(idxs,idx0)
            asela = asigel(idxs,idx0)
         ELSE
            dum0 = ZERO
            CALL DT_PHOXS(Ip,It,dum0,plab,phosto,phosin,dum1,dum2,0)
            phosel = phosto - phosin
            astot = LOG10(phosto)
            asela = LOG10(phosto-phosin)
         END IF
      ELSE
         fac = (aplab-apl(idx0))/(apl(idx1)-apl(idx0))
         astot = asigto(idxs,idx0)
     &           + fac*(asigto(idxs,idx1)-asigto(idxs,idx0))
         asela = asigel(idxs,idx0)
     &           + fac*(asigel(idxs,idx1)-asigel(idxs,idx0))
      END IF
      Stot = 10.0D0**astot
      Sela = 10.0D0**asela
 
      END SUBROUTINE
