
      DOUBLE PRECISION FUNCTION PHO_EXPINT(Rxm)
C***********************************************************************
C
C     function to calculate  E_i(x) = -E_1(-x)
C
C     based on CERNLIB C337   (changed by R.Engel 10/1993)
C
C***********************************************************************
      IMPLICIT NONE
      INTEGER i
      DOUBLE PRECISION Rxm
      SAVE 
 
C  input/output channels
      INCLUDE 'inc/poinou'
 
      DOUBLE PRECISION p1(5) , q1(5) , p2(7) , q2(7) , p3(6) , q3(6) , 
     &                 p4(8) , q4(8)
      DOUBLE PRECISION a1(8) , b1(8) , a2(8) , b2(8) , a3(6) , b3(6) , 
     &                 xl(6)
      DOUBLE PRECISION x , y , ap , bp , dp , aq , bq , dq , x0 , v
 
      DATA x0/0.37250741078137D0/
      DATA xl/ - 24.0D0 , -12.0D0 , -6.0D0 , 0.0D0 , 1.0D0 , 4.0D0/
      DATA p1/ + 4.2931252343210D+0 , +3.9894153870321D+1 , 
     &     +2.9252518866921D+2 , +4.2569682638592D+2 , 
     &     -4.3498143832952D+2/
      DATA q1/ + 1.0000000000000D+0 , +1.8899288395003D+1 , 
     &     +1.5095038744251D+2 , +5.6805252718987D+2 , 
     &     +7.5358564359843D+2/
      DATA p2/ + 4.3096783946939D-1 , +6.9052252278444D+0 , 
     &     +2.3019255939133D+1 , +2.4378408879132D+1 , 
     &     +9.0416155694633D+0 , +9.9997957705159D-1 , 
     &     +4.6562710797510D-7/
      DATA q2/ + 1.0340013040487D-1 , +3.3190921359330D+0 , 
     &     +2.0449478501379D+1 , +4.1280784189142D+1 , 
     &     +3.2426421069514D+1 , +1.0041164382905D+1 , 
     &     +1.0000000000000D+0/
      DATA p3/ - 2.3909964453136D+0 , -1.4798219500504D+2 , 
     &     -2.5437633976890D+2 , -1.1955761038372D+2 , 
     &     -1.9630408535939D+1 , -9.9999999990360D-1/
      DATA q3/ + 1.7760070940351D+2 , +5.3068509610812D+2 , 
     &     +4.6223027156148D+2 , +1.5681843364539D+2 , 
     &     +2.1630408494238D+1 , +1.0000000000000D+0/
      DATA p4/ - 8.6693733995107D+0 , -5.4914226552109D+2 , 
     &     -4.2100161535707D+3 , -2.4930139345865D+5 , 
     &     -1.1962366934925D+5 , -2.2174462775885D+7 , 
     &     +3.8928042131120D+6 , -3.9154607380910D+8/
      DATA q4/ + 3.4171875000000D+1 , -1.6070892658722D+3 , 
     &     +3.5730029805851D+4 , -4.8354743616216D+5 , 
     &     +4.2855962461175D+6 , -2.4903337574054D+7 , 
     &     +8.9192576757561D+7 , -1.6525429972521D+8/
      DATA a1/ - 2.1808638152072D+0 , -2.1901023385488D+1 , 
     &     +9.3081638566217D+0 , +2.5076281129356D+1 , 
     &     -3.3184253199722D+1 , +6.0121799083008D+1 , 
     &     -4.3253113287813D+1 , +1.0044310922808D+0/
      DATA b1/ + 0.0000000000000D+0 , +3.9370770185272D+0 , 
     &     +3.0089264837292D+2 , -6.2504116167188D+0 , 
     &     +1.0036743951673D+3 , +1.4325673812194D+1 , 
     &     +2.7362411988933D+3 , +5.2746885196291D-1/
      DATA a2/ - 3.4833465360285D+0 , -1.8654545488340D+1 , 
     &     -8.2856199414064D+0 , -3.2346733030540D+1 , 
     &     +1.7960168876925D+1 , +1.7565631546961D+0 , 
     &     -1.9502232128966D+0 , +9.9999429607471D-1/
      DATA b2/ + 0.0000000000000D+0 , +6.9500065588743D+1 , 
     &     +5.7283719383732D+1 , +2.5777638423844D+1 , 
     &     +7.6076114800773D+2 , +2.8951672792514D+1 , 
     &     -3.4394226689987D+0 , +1.0008386740264D+0/
      DATA a3/ - 2.7780928934438D+1 , -1.0104790815760D+1 , 
     &     -9.1483008216736D+0 , -5.0223317461851D+0 , 
     &     -3.0000077799358D+0 , +1.0000000000704D+0/
      DATA b3/ + 0.0000000000000D+0 , +1.2239993926823D+2 , 
     &     +2.7276100778779D+0 , -7.1897518395045D+0 , 
     &     -2.9990118065262D+0 , +1.9999999428260D+0/
C
C  conversion to E_i function
      x = -Rxm
C
      IF ( x.LE.xl(1) ) THEN
         ap = a3(1) - x
         DO i = 2 , 5
            ap = a3(i) - x + b3(i)/ap
         END DO
         y = (EXP(-x)/x)*(1.D0-(a3(6)+b3(6)/ap)/x)
      ELSE IF ( x.LE.xl(2) ) THEN
         ap = a2(1) - x
         DO i = 2 , 7
            ap = a2(i) - x + b2(i)/ap
         END DO
         y = (EXP(-x)/x)*(a2(8)+b2(8)/ap)
      ELSE IF ( x.LE.xl(3) ) THEN
         ap = a1(1) - x
         DO i = 2 , 7
            ap = a1(i) - x + b1(i)/ap
         END DO
         y = (EXP(-x)/x)*(a1(8)+b1(8)/ap)
      ELSE IF ( x.LT.xl(4) ) THEN
         v = -2.D0*(x/3.D0+1.D0)
         bp = 0.D0
         dp = p4(1)
         DO i = 2 , 8
            ap = bp
            bp = dp
            dp = p4(i) - ap + v*bp
         END DO
         bq = 0.D0
         dq = q4(1)
         DO i = 2 , 8
            aq = bq
            bq = dq
            dq = q4(i) - aq + v*bq
         END DO
         y = -LOG(-x/x0) + (x+x0)*(dp-ap)/(dq-aq)
      ELSE IF ( x.EQ.xl(4) ) THEN
C      CALL KERMTR('C337.1',LGFILE,MFLAG,RFLAG)
C      IF(MFLAG) THEN
C       IF(LGFILE .EQ. 0) THEN
C        WRITE(LO,100) ENAME
C       ELSE
C        WRITE(LGFILE,100) ENAME
C       ENDIF
C      ENDIF
C      IF(.NOT.RFLAG) CALL ABEND
         PHO_EXPINT = 0.D0
         RETURN
      ELSE IF ( x.LT.xl(5) ) THEN
         ap = p1(1)
         aq = q1(1)
         DO i = 2 , 5
            ap = p1(i) + x*ap
            aq = q1(i) + x*aq
         END DO
         y = -LOG(x) + ap/aq
      ELSE IF ( x.LE.xl(6) ) THEN
         y = 1.D0/x
         ap = p2(1)
         aq = q2(1)
         DO i = 2 , 7
            ap = p2(i) + y*ap
            aq = q2(i) + y*aq
         END DO
         y = EXP(-x)*ap/aq
      ELSE
         y = 1.D0/x
         ap = p3(1)
         aq = q3(1)
         DO i = 2 , 6
            ap = p3(i) + y*ap
            aq = q3(i) + y*aq
         END DO
         y = EXP(-x)*y*(1.D0+y*ap/aq)
      END IF
C  sign conversion to E_i
      PHO_EXPINT = -y
 
      END FUNCTION
