
      DOUBLE PRECISION FUNCTION PHO_GGFAUX(B1)
C*********************************************************************
C
C     auxiliary function for integration over b2,
C     semi-classical photon flux correction due to
C     overlap in impact parameter space (geometrical model)
C
C*********************************************************************
      IMPLICIT NONE
      DOUBLE PRECISION ACCUR , B1 , b2 , bmax , bmin , PHO_GGFNUC , PI , 
     &                 w1 , w2 , wgauss , xgauss , xint , xint2 , xint3
      INTEGER i , n
      SAVE 
 
      PARAMETER (PI=3.141592653589793238462643383279D+00,ACCUR=1D-2)
 
C  input/output channels
      INCLUDE 'inc/poinou'
C  gamma-lepton or gamma-hadron vertex information
      INCLUDE 'inc/pofsrc'
 
      DIMENSION xgauss(126) , wgauss(126)
 
      DATA xgauss(1)/.57735026918962576D0/
      DATA xgauss(2)/ - .57735026918962576D0/
      DATA wgauss(1)/1.00000000000000000D0/
      DATA wgauss(2)/1.00000000000000000D0/
 
      DATA xgauss(3)/.33998104358485627D0/
      DATA xgauss(4)/.86113631159405258D0/
      DATA xgauss(5)/ - .33998104358485627D0/
      DATA xgauss(6)/ - .86113631159405258D0/
      DATA wgauss(3)/.65214515486254613D0/
      DATA wgauss(4)/.34785484513745385D0/
      DATA wgauss(5)/.65214515486254613D0/
      DATA wgauss(6)/.34785484513745385D0/
 
      DATA xgauss(7)/.18343464249564981D0/
      DATA xgauss(8)/.52553240991632899D0/
      DATA xgauss(9)/.79666647741362674D0/
      DATA xgauss(10)/.96028985649753623D0/
      DATA xgauss(11)/ - .18343464249564981D0/
      DATA xgauss(12)/ - .52553240991632899D0/
      DATA xgauss(13)/ - .79666647741362674D0/
      DATA xgauss(14)/ - .96028985649753623D0/
      DATA wgauss(7)/.36268378337836198D0/
      DATA wgauss(8)/.31370664587788727D0/
      DATA wgauss(9)/.22238103445337448D0/
      DATA wgauss(10)/.10122853629037627D0/
      DATA wgauss(11)/.36268378337836198D0/
      DATA wgauss(12)/.31370664587788727D0/
      DATA wgauss(13)/.22238103445337448D0/
      DATA wgauss(14)/.10122853629037627D0/
 
      DATA xgauss(15)/.0950125098376374402D0/
      DATA xgauss(16)/.281603550779258913D0/
      DATA xgauss(17)/.458016777657227386D0/
      DATA xgauss(18)/.617876244402643748D0/
      DATA xgauss(19)/.755404408355003034D0/
      DATA xgauss(20)/.865631202387831744D0/
      DATA xgauss(21)/.944575023073232576D0/
      DATA xgauss(22)/.989400934991649933D0/
      DATA xgauss(23)/ - .0950125098376374402D0/
      DATA xgauss(24)/ - .281603550779258913D0/
      DATA xgauss(25)/ - .458016777657227386D0/
      DATA xgauss(26)/ - .617876244402643748D0/
      DATA xgauss(27)/ - .755404408355003034D0/
      DATA xgauss(28)/ - .865631202387831744D0/
      DATA xgauss(29)/ - .944575023073232576D0/
      DATA xgauss(30)/ - .989400934991649933D0/
      DATA wgauss(15)/.189450610455068496D0/
      DATA wgauss(16)/.182603415044923589D0/
      DATA wgauss(17)/.169156519395002538D0/
      DATA wgauss(18)/.149595988816576732D0/
      DATA wgauss(19)/.124628971255533872D0/
      DATA wgauss(20)/.0951585116824927848D0/
      DATA wgauss(21)/.0622535239386478929D0/
      DATA wgauss(22)/.0271524594117540949D0/
      DATA wgauss(23)/.189450610455068496D0/
      DATA wgauss(24)/.182603415044923589D0/
      DATA wgauss(25)/.169156519395002538D0/
      DATA wgauss(26)/.149595988816576732D0/
      DATA wgauss(27)/.124628971255533872D0/
      DATA wgauss(28)/.0951585116824927848D0/
      DATA wgauss(29)/.0622535239386478929D0/
      DATA wgauss(30)/.0271524594117540949D0/
 
      DATA xgauss(31)/.0483076656877383162D0/
      DATA xgauss(32)/.144471961582796493D0/
      DATA xgauss(33)/.239287362252137075D0/
      DATA xgauss(34)/.331868602282127650D0/
      DATA xgauss(35)/.421351276130635345D0/
      DATA xgauss(36)/.506899908932229390D0/
      DATA xgauss(37)/.587715757240762329D0/
      DATA xgauss(38)/.663044266930215201D0/
      DATA xgauss(39)/.732182118740289680D0/
      DATA xgauss(40)/.794483795967942407D0/
      DATA xgauss(41)/.849367613732569970D0/
      DATA xgauss(42)/.896321155766052124D0/
      DATA xgauss(43)/.934906075937739689D0/
      DATA xgauss(44)/.964762255587506430D0/
      DATA xgauss(45)/.985611511545268335D0/
      DATA xgauss(46)/.997263861849481564D0/
      DATA xgauss(47)/ - .0483076656877383162D0/
      DATA xgauss(48)/ - .144471961582796493D0/
      DATA xgauss(49)/ - .239287362252137075D0/
      DATA xgauss(50)/ - .331868602282127650D0/
      DATA xgauss(51)/ - .421351276130635345D0/
      DATA xgauss(52)/ - .506899908932229390D0/
      DATA xgauss(53)/ - .587715757240762329D0/
      DATA xgauss(54)/ - .663044266930215201D0/
      DATA xgauss(55)/ - .732182118740289680D0/
      DATA xgauss(56)/ - .794483795967942407D0/
      DATA xgauss(57)/ - .849367613732569970D0/
      DATA xgauss(58)/ - .896321155766052124D0/
      DATA xgauss(59)/ - .934906075937739689D0/
      DATA xgauss(60)/ - .964762255587506430D0/
      DATA xgauss(61)/ - .985611511545268335D0/
      DATA xgauss(62)/ - .997263861849481564D0/
      DATA wgauss(31)/.0965400885147278006D0/
      DATA wgauss(32)/.0956387200792748594D0/
      DATA wgauss(33)/.0938443990808045654D0/
      DATA wgauss(34)/.0911738786957638847D0/
      DATA wgauss(35)/.0876520930044038111D0/
      DATA wgauss(36)/.0833119242269467552D0/
      DATA wgauss(37)/.0781938957870703065D0/
      DATA wgauss(38)/.0723457941088485062D0/
      DATA wgauss(39)/.0658222227763618468D0/
      DATA wgauss(40)/.0586840934785355471D0/
      DATA wgauss(41)/.0509980592623761762D0/
      DATA wgauss(42)/.0428358980222266807D0/
      DATA wgauss(43)/.0342738629130214331D0/
      DATA wgauss(44)/.0253920653092620595D0/
      DATA wgauss(45)/.0162743947309056706D0/
      DATA wgauss(46)/.00701861000947009660D0/
      DATA wgauss(47)/.0965400885147278006D0/
      DATA wgauss(48)/.0956387200792748594D0/
      DATA wgauss(49)/.0938443990808045654D0/
      DATA wgauss(50)/.0911738786957638847D0/
      DATA wgauss(51)/.0876520930044038111D0/
      DATA wgauss(52)/.0833119242269467552D0/
      DATA wgauss(53)/.0781938957870703065D0/
      DATA wgauss(54)/.0723457941088485062D0/
      DATA wgauss(55)/.0658222227763618468D0/
      DATA wgauss(56)/.0586840934785355471D0/
      DATA wgauss(57)/.0509980592623761762D0/
      DATA wgauss(58)/.0428358980222266807D0/
      DATA wgauss(59)/.0342738629130214331D0/
      DATA wgauss(60)/.0253920653092620595D0/
      DATA wgauss(61)/.0162743947309056706D0/
      DATA wgauss(62)/.00701861000947009660D0/
 
      DATA xgauss(63)/.02435029266342443250D0/
      DATA xgauss(64)/.0729931217877990394D0/
      DATA xgauss(65)/.121462819296120554D0/
      DATA xgauss(66)/.169644420423992818D0/
      DATA xgauss(67)/.217423643740007084D0/
      DATA xgauss(68)/.264687162208767416D0/
      DATA xgauss(69)/.311322871990210956D0/
      DATA xgauss(70)/.357220158337668116D0/
      DATA xgauss(71)/.402270157963991604D0/
      DATA xgauss(72)/.446366017253464088D0/
      DATA xgauss(73)/.489403145707052957D0/
      DATA xgauss(74)/.531279464019894546D0/
      DATA xgauss(75)/.571895646202634034D0/
      DATA xgauss(76)/.611155355172393250D0/
      DATA xgauss(77)/.648965471254657340D0/
      DATA xgauss(78)/.685236313054233243D0/
      DATA xgauss(79)/.719881850171610827D0/
      DATA xgauss(80)/.752819907260531897D0/
      DATA xgauss(81)/.783972358943341408D0/
      DATA xgauss(82)/.813265315122797560D0/
      DATA xgauss(83)/.840629296252580363D0/
      DATA xgauss(84)/.865999398154092820D0/
      DATA xgauss(85)/.889315445995114106D0/
      DATA xgauss(86)/.910522137078502806D0/
      DATA xgauss(87)/.929569172131939576D0/
      DATA xgauss(88)/.946411374858402816D0/
      DATA xgauss(89)/.961008799652053719D0/
      DATA xgauss(90)/.973326827789910964D0/
      DATA xgauss(91)/.983336253884625957D0/
      DATA xgauss(92)/.991013371476744321D0/
      DATA xgauss(93)/.996340116771955279D0/
      DATA xgauss(94)/.999305041735772139D0/
      DATA xgauss(95)/ - .02435029266342443250D0/
      DATA xgauss(96)/ - .0729931217877990394D0/
      DATA xgauss(97)/ - .121462819296120554D0/
      DATA xgauss(98)/ - .169644420423992818D0/
      DATA xgauss(99)/ - .217423643740007084D0/
      DATA xgauss(100)/ - .264687162208767416D0/
      DATA xgauss(101)/ - .311322871990210956D0/
      DATA xgauss(102)/ - .357220158337668116D0/
      DATA xgauss(103)/ - .402270157963991604D0/
      DATA xgauss(104)/ - .446366017253464088D0/
      DATA xgauss(105)/ - .489403145707052957D0/
      DATA xgauss(106)/ - .531279464019894546D0/
      DATA xgauss(107)/ - .571895646202634034D0/
      DATA xgauss(108)/ - .611155355172393250D0/
      DATA xgauss(109)/ - .648965471254657340D0/
      DATA xgauss(110)/ - .685236313054233243D0/
      DATA xgauss(111)/ - .719881850171610827D0/
      DATA xgauss(112)/ - .752819907260531897D0/
      DATA xgauss(113)/ - .783972358943341408D0/
      DATA xgauss(114)/ - .813265315122797560D0/
      DATA xgauss(115)/ - .840629296252580363D0/
      DATA xgauss(116)/ - .865999398154092820D0/
      DATA xgauss(117)/ - .889315445995114106D0/
      DATA xgauss(118)/ - .910522137078502806D0/
      DATA xgauss(119)/ - .929569172131939576D0/
      DATA xgauss(120)/ - .946411374858402816D0/
      DATA xgauss(121)/ - .961008799652053719D0/
      DATA xgauss(122)/ - .973326827789910964D0/
      DATA xgauss(123)/ - .983336253884625957D0/
      DATA xgauss(124)/ - .991013371476744321D0/
      DATA xgauss(125)/ - .996340116771955279D0/
      DATA xgauss(126)/ - .999305041735772139D0/
      DATA wgauss(63)/.0486909570091397204D0/
      DATA wgauss(64)/.0485754674415034269D0/
      DATA wgauss(65)/.0483447622348029572D0/
      DATA wgauss(66)/.0479993885964583077D0/
      DATA wgauss(67)/.0475401657148303087D0/
      DATA wgauss(68)/.0469681828162100173D0/
      DATA wgauss(69)/.0462847965813144172D0/
      DATA wgauss(70)/.0454916279274181445D0/
      DATA wgauss(71)/.0445905581637565631D0/
      DATA wgauss(72)/.0435837245293234534D0/
      DATA wgauss(73)/.0424735151236535890D0/
      DATA wgauss(74)/.0412625632426235286D0/
      DATA wgauss(75)/.0399537411327203414D0/
      DATA wgauss(76)/.0385501531786156291D0/
      DATA wgauss(77)/.0370551285402400460D0/
      DATA wgauss(78)/.0354722132568823838D0/
      DATA wgauss(79)/.0338051618371416094D0/
      DATA wgauss(80)/.0320579283548515535D0/
      DATA wgauss(81)/.0302346570724024789D0/
      DATA wgauss(82)/.0283396726142594832D0/
      DATA wgauss(83)/.0263774697150546587D0/
      DATA wgauss(84)/.0243527025687108733D0/
      DATA wgauss(85)/.0222701738083832542D0/
      DATA wgauss(86)/.0201348231535302094D0/
      DATA wgauss(87)/.0179517157756973431D0/
      DATA wgauss(88)/.0157260304760247193D0/
      DATA wgauss(89)/.0134630478967186426D0/
      DATA wgauss(90)/.0111681394601311288D0/
      DATA wgauss(91)/.00884675982636394772D0/
      DATA wgauss(92)/.00650445796897836286D0/
      DATA wgauss(93)/.00414703326056246764D0/
      DATA wgauss(94)/.00178328072169643295D0/
      DATA wgauss(95)/.0486909570091397204D0/
      DATA wgauss(96)/.0485754674415034269D0/
      DATA wgauss(97)/.0483447622348029572D0/
      DATA wgauss(98)/.0479993885964583077D0/
      DATA wgauss(99)/.0475401657148303087D0/
      DATA wgauss(100)/.0469681828162100173D0/
      DATA wgauss(101)/.0462847965813144172D0/
      DATA wgauss(102)/.0454916279274181445D0/
      DATA wgauss(103)/.0445905581637565631D0/
      DATA wgauss(104)/.0435837245293234534D0/
      DATA wgauss(105)/.0424735151236535890D0/
      DATA wgauss(106)/.0412625632426235286D0/
      DATA wgauss(107)/.0399537411327203414D0/
      DATA wgauss(108)/.0385501531786156291D0/
      DATA wgauss(109)/.0370551285402400460D0/
      DATA wgauss(110)/.0354722132568823838D0/
      DATA wgauss(111)/.0338051618371416094D0/
      DATA wgauss(112)/.0320579283548515535D0/
      DATA wgauss(113)/.0302346570724024789D0/
      DATA wgauss(114)/.0283396726142594832D0/
      DATA wgauss(115)/.0263774697150546587D0/
      DATA wgauss(116)/.0243527025687108733D0/
      DATA wgauss(117)/.0222701738083832542D0/
      DATA wgauss(118)/.0201348231535302094D0/
      DATA wgauss(119)/.0179517157756973431D0/
      DATA wgauss(120)/.0157260304760247193D0/
      DATA wgauss(121)/.0134630478967186426D0/
      DATA wgauss(122)/.0111681394601311288D0/
      DATA wgauss(123)/.00884675982636394772D0/
      DATA wgauss(124)/.00650445796897836286D0/
      DATA wgauss(125)/.00414703326056246764D0/
      DATA wgauss(126)/.00178328072169643295D0/
C
      w1 = PGAm(4,1)
      w2 = PGAm(4,2)
      bmin = B1 - 2.D0*RADsrc(1)
      IF ( RADsrc(1).GT.bmin ) bmin = RADsrc(1)
      bmax = B1 + 2.D0*RADsrc(1)
 
      xint = 0.D0
      DO n = 1 , 6
         xint2 = xint
         xint = 0.D0
         DO i = 2**n - 1 , 2**(n+1) - 2
            b2 = (bmax-bmin)/2.D0*xgauss(i) + (bmax+bmin)/2.D0
            xint3 = PHO_GGFNUC(w1,B1,GAMsrc(1))
     &              *PHO_GGFNUC(w2,b2,GAMsrc(2))
     &              *ACOS((B1**2+b2**2-4.D0*RADsrc(1)**2)/(2.D0*B1*b2))
            xint = xint + wgauss(i)*b2*xint3
         END DO
         xint = (bmax-bmin)/2.D0*xint
         IF ( ABS((xint2-xint)/xint).LT.ACCUR ) GOTO 100
      END DO
      IF ( LPRi.GT.4 ) WRITE (LO,*) ' (b2) GAUSS MAY BE INACCURATE'
 
 100  PHO_GGFAUX = xint
 
      END FUNCTION
