
      SUBROUTINE DT_USRHIS(Mode)
 
      IMPLICIT NONE
      INTEGER Mode
      SAVE 
C
C COMMON /DTEVT1/ :
C                   NHKK         number of entries in common block
C                   NEVHKK       number of the event
C                   ISTHKK(i)    status code for entry i
C                   IDHKK(i)     identifier for the entry
C                                (for particles: identifier according
C                                 to the PDG numbering scheme)
C                   JMOHKK(1,i)  pointer to the entry of the first mother
C                                of entry i
C                   JMOHKK(2,i)  pointer to the entry of the second mother
C                                of entry i
C                   JDAHKK(1,i)  pointer to the entry of the first daughter
C                                of entry i
C                   JDAHKK(2,i)  pointer to the entry of the second daughter
C                                of entry i
C                   PHKK(1..3,i) 3-momentum
C                   PHKK(4,i)    energy
C                   PHKK(5,i)    mass
C
C event history
 
      INCLUDE 'inc/dtevt1'
      INCLUDE 'inc/dtevt2'
 
      IF ( Mode.EQ.2 ) THEN
      ELSE IF ( Mode.NE.3 ) THEN
 
C------------------------------------------------------------------
C
C
C initializations
C
C  Called with MODE=1 once at the beginning of the run.
C
         RETURN
      END IF
C
C------------------------------------------------------------------
C
C
C scoring of the present event
C
C  Called with MODE=2 every time one event has been finished.
C
C  The final state particles from the actual event (number NEVHKK)
C  can be found in DTEVT1 and identified by their status:
C
C     ISTHKK(i) = 1    final state particle produced in
C                      photon-/hadron-/nucleon-nucleon collisions or
C                      in intranuclear cascade processes
C                -1    nucleons, deuterons, H-3, He-3, He-4 evaporated
C                      from excited nucleus and
C                      photons produced in nuclear deexcitation processes
C                1001  residual nucleus (ground state)
C
C  The types of these particles/nuclei are given in IDHKK as follows
C
C     all final state part. except nuclei :
C       IDHKK(i)=particle identifier according to PDG numbering scheme
C     nuclei (evaporation products, and residual nucleus) :
C       IDHKK(i)=80000, IDRES(i)=mass number, IDXRES(i)=charge number
C
C  The 4-momenta and masses can be found in PHKK (target nucleus rest frame):
C                   PHKK(1..3,i) 3-momentum (p_x,p_y,p_z)
C                   PHKK(4,i)    energy
C                   PHKK(5,i)    mass
C
C
C
C  Pick out the final state particles from DTEVT1 in each event for
C  instance by the following loop (NHKK=number of entries in the present
C  event) and fill your histograms
C     DO 20 I=1,NHKK
C        IF (ABS(ISTHKK(I)).EQ.1) THEN
C        ELSEIF (ABS(ISTHKK(I)).EQ.1001) THEN
C        ENDIF
C  20 CONTINUE
 
C  At any time during the run a list of the actual entries in DTEVT1 and
C  DTEVT2 can be obtained (output unit 6) by the following statement:
C     CALL DT_EVTOUT(4)
 
C
C------------------------------------------------------------------
C
C
C output/statistics/histograms etc.
C
C  Called with MODE=3 once after all events have been sampled.
C
 
      END SUBROUTINE
