
      SUBROUTINE PHO_DOR98LO(Xinp,Q2inp,Uv,Dv,Us,Ds,Ss,Gl)
C***********************************************************************
C
C   GRV98 parton densities, leading order set
C
C                  For a detailed explanation see
C                   M. Glueck, E. Reya, A. Vogt :
C        hep-ph/9806404  =  DO-TH 98/07  =  WUE-ITP-98-019
C                  (To appear in Eur. Phys. J. C)
C
C   interpolation routine based on the original GRV98PA routine,
C   adapted to define interpolation table as DATA statements
C
C                                                   (R.Engel, 09/98)
C
C
C   INPUT:   X  =  Bjorken-x        (between  1.E-9 and 1.)
C            Q2 =  scale in GeV**2  (between  0.8 and 1.E6)
C
C   OUTPUT:  UV = u - u(bar),  DV = d - d(bar),  US = u(bar),
C            DS = d(bar),  SS = s = s(bar),  GL = gluon.
C            Always x times the distribution is returned.
C
C******************************************************i****************
      IMPLICIT NONE
      DOUBLE PRECISION arrf , de , Ds , Dv , Gl , PHO_DBFINT , q2 , 
     &                 Q2inp , Ss , ud , Us , Uv , x , x1 , xdef , 
     &                 xdef_l , xdvf , xdvf_l , xgf , xgf_l
      DOUBLE PRECISION Xinp , xs , xsf , xsf_l , xt , xudf , xudf_l , 
     &                 xuvf , xuvf_l , xv
      INTEGER k , na , NARG , NPART , NQ , NX
      SAVE 
 
C  input/output channels
      INCLUDE 'inc/poinou'
 
      PARAMETER (NPART=6,NX=68,NQ=27,NARG=2)
      DIMENSION xuvf(NX,NQ) , xdvf(NX,NQ) , xdef(NX,NQ) , xudf(NX,NQ) , 
     &          xsf(NX,NQ) , xgf(NX,NQ) , xt(NARG) , na(NARG) , 
     &          arrf(NX+NQ)
 
      DIMENSION xuvf_l(NX*NQ) , xdvf_l(NX*NQ) , xdef_l(NX*NQ) , 
     &          xudf_l(NX*NQ) , xsf_l(NX*NQ) , xgf_l(NX*NQ)
 
      EQUIVALENCE (xuvf(1,1),xuvf_l(1))
      EQUIVALENCE (xdvf(1,1),xdvf_l(1))
      EQUIVALENCE (xdef(1,1),xdef_l(1))
      EQUIVALENCE (xudf(1,1),xudf_l(1))
      EQUIVALENCE (xsf(1,1),xsf_l(1))
      EQUIVALENCE (xgf(1,1),xgf_l(1))
 
      DATA (arrf(k),k=1,95)/ - 2.0723D+01 , -2.0135D+01 , -1.9560D+01 , 
     &      -1.8983D+01 , -1.8421D+01 , -1.7833D+01 , -1.7258D+01 , 
     &      -1.6680D+01 , -1.6118D+01 , -1.5530D+01 , -1.4955D+01 , 
     &      -1.4378D+01 , -1.3816D+01 , -1.3479D+01 , -1.3122D+01 , 
     &      -1.2717D+01 , -1.2311D+01 , -1.1913D+01 , -1.1513D+01 , 
     &      -1.1176D+01 , -1.0820D+01 , -1.0414D+01 , -1.0009D+01 , 
     &      -9.6108D+00 , -9.2103D+00 , -8.8739D+00 , -8.5172D+00 , 
     &      -8.1117D+00 , -7.7063D+00 , -7.3082D+00 , -6.9078D+00 , 
     &      -6.5713D+00 , -6.2146D+00 , -5.8091D+00 , -5.4037D+00 , 
     &      -5.0056D+00 , -4.6052D+00 , -4.2687D+00 , -3.9120D+00 , 
     &      -3.5066D+00 , -3.1011D+00 , -2.8134D+00 , -2.5257D+00 , 
     &      -2.3026D+00 , -2.0794D+00 , -1.8971D+00 , -1.7430D+00 , 
     &      -1.6094D+00 , -1.4917D+00 , -1.3863D+00 , -1.2910D+00 , 
     &      -1.2040D+00 , -1.1239D+00 , -1.0498D+00 , -9.8083D-01 , 
     &      -9.1629D-01 , -7.9851D-01 , -6.9315D-01 , -5.9784D-01 , 
     &      -5.1083D-01 , -4.3078D-01 , -3.5667D-01 , -2.8768D-01 , 
     &      -2.2314D-01 , -1.6252D-01 , -1.0536D-01 , -5.1293D-02 , 
     &      0.0000D+00 , -2.2314D-01 , 0.0000D+00 , 2.6236D-01 , 
     &      5.8779D-01 , 9.9325D-01 , 1.3863D+00 , 1.8563D+00 , 
     &      2.3026D+00 , 2.7726D+00 , 3.2189D+00 , 3.6889D+00 , 
     &      4.1589D+00 , 4.6052D+00 , 5.1930D+00 , 5.7683D+00 , 
     &      6.3456D+00 , 6.9078D+00 , 7.4955D+00 , 8.0709D+00 , 
     &      8.6482D+00 , 9.2103D+00 , 9.9988D+00 , 1.0736D+01 , 
     &      1.1513D+01 , 1.2301D+01 , 1.3039D+01 , 1.3816D+01/
      DATA (xuvf_l(k),k=1,114)/2.3186D+00 , 2.2915D+00 , 2.2645D+00 , 
     &      2.2385D+00 , 2.2140D+00 , 2.1876D+00 , 2.1623D+00 , 
     &      2.1366D+00 , 2.1121D+00 , 2.0862D+00 , 2.0612D+00 , 
     &      2.0358D+00 , 2.0110D+00 , 1.9963D+00 , 1.9806D+00 , 
     &      1.9624D+00 , 1.9446D+00 , 1.9263D+00 , 1.9072D+00 , 
     &      1.8904D+00 , 1.8724D+00 , 1.8515D+00 , 1.8294D+00 , 
     &      1.8085D+00 , 1.7865D+00 , 1.7680D+00 , 1.7483D+00 , 
     &      1.7249D+00 , 1.6993D+00 , 1.6715D+00 , 1.6385D+00 , 
     &      1.6141D+00 , 1.5884D+00 , 1.5597D+00 , 1.5337D+00 , 
     &      1.5121D+00 , 1.4985D+00 , 1.4980D+00 , 1.5116D+00 , 
     &      1.5555D+00 , 1.6432D+00 , 1.7434D+00 , 1.8861D+00 , 
     &      2.0327D+00 , 2.2174D+00 , 2.4015D+00 , 2.5849D+00 , 
     &      2.7671D+00 , 2.9488D+00 , 3.1308D+00 , 3.3142D+00 , 
     &      3.4998D+00 , 3.6885D+00 , 3.8826D+00 , 4.0815D+00 , 
     &      4.2069D+00 , 4.5481D+00 , 4.8830D+00 , 5.2116D+00 , 
     &      5.5351D+00 , 5.8553D+00 , 6.1665D+00 , 6.4745D+00 , 
     &      6.7767D+00 , 7.0735D+00 , 7.3628D+00 , 7.6283D+00 , 
     &      0.0000D+00 , 2.3948D+00 , 2.3665D+00 , 2.3388D+00 , 
     &      2.3126D+00 , 2.2860D+00 , 2.2592D+00 , 2.2327D+00 , 
     &      2.2065D+00 , 2.1810D+00 , 2.1541D+00 , 2.1284D+00 , 
     &      2.1020D+00 , 2.0760D+00 , 2.0605D+00 , 2.0443D+00 , 
     &      2.0259D+00 , 2.0068D+00 , 1.9873D+00 , 1.9676D+00 , 
     &      1.9500D+00 , 1.9312D+00 , 1.9081D+00 , 1.8860D+00 , 
     &      1.8635D+00 , 1.8406D+00 , 1.8221D+00 , 1.8007D+00 , 
     &      1.7764D+00 , 1.7489D+00 , 1.7195D+00 , 1.6855D+00 , 
     &      1.6600D+00 , 1.6332D+00 , 1.6031D+00 , 1.5760D+00 , 
     &      1.5532D+00 , 1.5397D+00 , 1.5376D+00 , 1.5507D+00 , 
     &      1.5929D+00 , 1.6784D+00 , 1.7759D+00 , 1.9129D+00 , 
     &      2.0531D+00 , 2.2292D+00 , 2.4032D+00/
      DATA (xuvf_l(k),k=115,228)/2.5752D+00 , 2.7449D+00 , 2.9135D+00 , 
     &      3.0810D+00 , 3.2491D+00 , 3.4183D+00 , 3.5898D+00 , 
     &      3.7650D+00 , 3.9437D+00 , 4.0443D+00 , 4.3402D+00 , 
     &      4.6262D+00 , 4.9009D+00 , 5.1640D+00 , 5.4156D+00 , 
     &      5.6530D+00 , 5.8759D+00 , 6.0779D+00 , 6.2540D+00 , 
     &      6.3836D+00 , 6.4062D+00 , 0.0000D+00 , 2.4808D+00 , 
     &      2.4513D+00 , 2.4236D+00 , 2.3948D+00 , 2.3680D+00 , 
     &      2.3397D+00 , 2.3127D+00 , 2.2853D+00 , 2.2585D+00 , 
     &      2.2307D+00 , 2.2026D+00 , 2.1762D+00 , 2.1490D+00 , 
     &      2.1332D+00 , 2.1164D+00 , 2.0964D+00 , 2.0766D+00 , 
     &      2.0565D+00 , 2.0353D+00 , 2.0171D+00 , 1.9969D+00 , 
     &      1.9738D+00 , 1.9501D+00 , 1.9258D+00 , 1.9026D+00 , 
     &      1.8821D+00 , 1.8594D+00 , 1.8330D+00 , 1.8046D+00 , 
     &      1.7734D+00 , 1.7378D+00 , 1.7112D+00 , 1.6829D+00 , 
     &      1.6514D+00 , 1.6228D+00 , 1.5994D+00 , 1.5840D+00 , 
     &      1.5808D+00 , 1.5927D+00 , 1.6334D+00 , 1.7157D+00 , 
     &      1.8093D+00 , 1.9406D+00 , 2.0735D+00 , 2.2394D+00 , 
     &      2.4019D+00 , 2.5615D+00 , 2.7178D+00 , 2.8718D+00 , 
     &      3.0246D+00 , 3.1766D+00 , 3.3284D+00 , 3.4820D+00 , 
     &      3.6370D+00 , 3.7952D+00 , 3.8716D+00 , 4.1225D+00 , 
     &      4.3580D+00 , 4.5798D+00 , 4.7847D+00 , 4.9730D+00 , 
     &      5.1395D+00 , 5.2832D+00 , 5.3945D+00 , 5.4634D+00 , 
     &      5.4612D+00 , 5.2940D+00 , 0.0000D+00 , 2.5823D+00 , 
     &      2.5527D+00 , 2.5226D+00 , 2.4928D+00 , 2.4650D+00 , 
     &      2.4358D+00 , 2.4071D+00 , 2.3783D+00 , 2.3505D+00 , 
     &      2.3212D+00 , 2.2928D+00 , 2.2636D+00 , 2.2360D+00 , 
     &      2.2185D+00 , 2.2005D+00 , 2.1801D+00 , 2.1591D+00 , 
     &      2.1376D+00 , 2.1153D+00 , 2.0960D+00 , 2.0747D+00 , 
     &      2.0505D+00 , 2.0247D+00 , 1.9991D+00/
      DATA (xuvf_l(k),k=229,342)/1.9746D+00 , 1.9523D+00 , 1.9287D+00 , 
     &      1.9000D+00 , 1.8693D+00 , 1.8361D+00 , 1.7994D+00 , 
     &      1.7711D+00 , 1.7409D+00 , 1.7076D+00 , 1.6772D+00 , 
     &      1.6517D+00 , 1.6345D+00 , 1.6302D+00 , 1.6408D+00 , 
     &      1.6789D+00 , 1.7574D+00 , 1.8457D+00 , 1.9692D+00 , 
     &      2.0939D+00 , 2.2474D+00 , 2.3969D+00 , 2.5419D+00 , 
     &      2.6837D+00 , 2.8216D+00 , 2.9573D+00 , 3.0915D+00 , 
     &      3.2246D+00 , 3.3583D+00 , 3.4917D+00 , 3.6273D+00 , 
     &      3.6791D+00 , 3.8823D+00 , 4.0673D+00 , 4.2350D+00 , 
     &      4.3813D+00 , 4.5072D+00 , 4.6083D+00 , 4.6757D+00 , 
     &      4.7055D+00 , 4.6825D+00 , 4.5674D+00 , 4.2566D+00 , 
     &      0.0000D+00 , 2.7025D+00 , 2.6705D+00 , 2.6393D+00 , 
     &      2.6093D+00 , 2.5790D+00 , 2.5484D+00 , 2.5184D+00 , 
     &      2.4880D+00 , 2.4590D+00 , 2.4277D+00 , 2.3971D+00 , 
     &      2.3669D+00 , 2.3380D+00 , 2.3200D+00 , 2.3002D+00 , 
     &      2.2782D+00 , 2.2557D+00 , 2.2331D+00 , 2.2092D+00 , 
     &      2.1887D+00 , 2.1660D+00 , 2.1400D+00 , 2.1126D+00 , 
     &      2.0859D+00 , 2.0586D+00 , 2.0351D+00 , 2.0094D+00 , 
     &      1.9786D+00 , 1.9453D+00 , 1.9096D+00 , 1.8707D+00 , 
     &      1.8406D+00 , 1.8084D+00 , 1.7728D+00 , 1.7392D+00 , 
     &      1.7128D+00 , 1.6933D+00 , 1.6875D+00 , 1.6949D+00 , 
     &      1.7295D+00 , 1.8023D+00 , 1.8845D+00 , 1.9991D+00 , 
     &      2.1134D+00 , 2.2525D+00 , 2.3868D+00 , 2.5160D+00 , 
     &      2.6405D+00 , 2.7609D+00 , 2.8781D+00 , 2.9929D+00 , 
     &      3.1059D+00 , 3.2180D+00 , 3.3292D+00 , 3.4407D+00 , 
     &      3.4675D+00 , 3.6225D+00 , 3.7573D+00 , 3.8710D+00 , 
     &      3.9617D+00 , 4.0270D+00 , 4.0642D+00 , 4.0675D+00 , 
     &      4.0263D+00 , 3.9240D+00 , 3.7262D+00 , 3.3217D+00 , 
     &      0.0000D+00 , 2.8135D+00 , 2.7813D+00/
      DATA (xuvf_l(k),k=343,456)/2.7489D+00 , 2.7166D+00 , 2.6850D+00 , 
     &      2.6527D+00 , 2.6212D+00 , 2.5898D+00 , 2.5592D+00 , 
     &      2.5267D+00 , 2.4943D+00 , 2.4636D+00 , 2.4320D+00 , 
     &      2.4129D+00 , 2.3929D+00 , 2.3695D+00 , 2.3453D+00 , 
     &      2.3211D+00 , 2.2959D+00 , 2.2740D+00 , 2.2496D+00 , 
     &      2.2221D+00 , 2.1931D+00 , 2.1653D+00 , 2.1356D+00 , 
     &      2.1112D+00 , 2.0830D+00 , 2.0503D+00 , 2.0147D+00 , 
     &      1.9766D+00 , 1.9361D+00 , 1.9037D+00 , 1.8696D+00 , 
     &      1.8318D+00 , 1.7966D+00 , 1.7677D+00 , 1.7459D+00 , 
     &      1.7378D+00 , 1.7430D+00 , 1.7738D+00 , 1.8407D+00 , 
     &      1.9169D+00 , 2.0223D+00 , 2.1273D+00 , 2.2537D+00 , 
     &      2.3742D+00 , 2.4892D+00 , 2.5990D+00 , 2.7043D+00 , 
     &      2.8056D+00 , 2.9038D+00 , 3.0000D+00 , 3.0936D+00 , 
     &      3.1864D+00 , 3.2782D+00 , 3.2867D+00 , 3.4021D+00 , 
     &      3.4971D+00 , 3.5691D+00 , 3.6188D+00 , 3.6422D+00 , 
     &      3.6335D+00 , 3.5908D+00 , 3.5036D+00 , 3.3552D+00 , 
     &      3.1085D+00 , 2.6634D+00 , 0.0000D+00 , 2.9406D+00 , 
     &      2.9062D+00 , 2.8726D+00 , 2.8385D+00 , 2.8060D+00 , 
     &      2.7720D+00 , 2.7392D+00 , 2.7058D+00 , 2.6734D+00 , 
     &      2.6399D+00 , 2.6057D+00 , 2.5722D+00 , 2.5390D+00 , 
     &      2.5194D+00 , 2.4975D+00 , 2.4728D+00 , 2.4471D+00 , 
     &      2.4216D+00 , 2.3945D+00 , 2.3712D+00 , 2.3458D+00 , 
     &      2.3152D+00 , 2.2856D+00 , 2.2545D+00 , 2.2237D+00 , 
     &      2.1966D+00 , 2.1672D+00 , 2.1312D+00 , 2.0926D+00 , 
     &      2.0521D+00 , 2.0093D+00 , 1.9748D+00 , 1.9384D+00 , 
     &      1.8975D+00 , 1.8601D+00 , 1.8275D+00 , 1.8036D+00 , 
     &      1.7924D+00 , 1.7948D+00 , 1.8206D+00 , 1.8808D+00 , 
     &      1.9499D+00 , 2.0450D+00 , 2.1390D+00 , 2.2512D+00 , 
     &      2.3570D+00 , 2.4564D+00 , 2.5501D+00/
      DATA (xuvf_l(k),k=457,570)/2.6391D+00 , 2.7240D+00 , 2.8053D+00 , 
     &      2.8834D+00 , 2.9590D+00 , 3.0326D+00 , 3.1042D+00 , 
     &      3.0942D+00 , 3.1727D+00 , 3.2289D+00 , 3.2628D+00 , 
     &      3.2739D+00 , 3.2574D+00 , 3.2103D+00 , 3.1297D+00 , 
     &      3.0047D+00 , 2.8211D+00 , 2.5467D+00 , 2.0897D+00 , 
     &      0.0000D+00 , 3.0557D+00 , 3.0193D+00 , 2.9840D+00 , 
     &      2.9497D+00 , 2.9150D+00 , 2.8801D+00 , 2.8454D+00 , 
     &      2.8109D+00 , 2.7771D+00 , 2.7412D+00 , 2.7065D+00 , 
     &      2.6716D+00 , 2.6360D+00 , 2.6149D+00 , 2.5923D+00 , 
     &      2.5663D+00 , 2.5395D+00 , 2.5120D+00 , 2.4834D+00 , 
     &      2.4589D+00 , 2.4330D+00 , 2.4011D+00 , 2.3676D+00 , 
     &      2.3363D+00 , 2.3027D+00 , 2.2736D+00 , 2.2422D+00 , 
     &      2.2040D+00 , 2.1629D+00 , 2.1194D+00 , 2.0750D+00 , 
     &      2.0384D+00 , 1.9996D+00 , 1.9565D+00 , 1.9160D+00 , 
     &      1.8811D+00 , 1.8541D+00 , 1.8409D+00 , 1.8399D+00 , 
     &      1.8611D+00 , 1.9143D+00 , 1.9764D+00 , 2.0622D+00 , 
     &      2.1459D+00 , 2.2457D+00 , 2.3385D+00 , 2.4249D+00 , 
     &      2.5051D+00 , 2.5806D+00 , 2.6515D+00 , 2.7182D+00 , 
     &      2.7823D+00 , 2.8427D+00 , 2.9008D+00 , 2.9564D+00 , 
     &      2.9332D+00 , 2.9828D+00 , 3.0094D+00 , 3.0142D+00 , 
     &      2.9955D+00 , 2.9537D+00 , 2.8796D+00 , 2.7735D+00 , 
     &      2.6260D+00 , 2.4242D+00 , 2.1388D+00 , 1.6900D+00 , 
     &      0.0000D+00 , 3.1718D+00 , 3.1348D+00 , 3.0971D+00 , 
     &      3.0610D+00 , 3.0260D+00 , 2.9896D+00 , 2.9533D+00 , 
     &      2.9173D+00 , 2.8818D+00 , 2.8449D+00 , 2.8072D+00 , 
     &      2.7709D+00 , 2.7340D+00 , 2.7121D+00 , 2.6877D+00 , 
     &      2.6605D+00 , 2.6319D+00 , 2.6032D+00 , 2.5732D+00 , 
     &      2.5471D+00 , 2.5180D+00 , 2.4851D+00 , 2.4511D+00 , 
     &      2.4170D+00 , 2.3817D+00 , 2.3505D+00/
      DATA (xuvf_l(k),k=571,684)/2.3172D+00 , 2.2762D+00 , 2.2328D+00 , 
     &      2.1868D+00 , 2.1400D+00 , 2.1012D+00 , 2.0601D+00 , 
     &      2.0136D+00 , 1.9704D+00 , 1.9335D+00 , 1.9035D+00 , 
     &      1.8868D+00 , 1.8827D+00 , 1.8990D+00 , 1.9452D+00 , 
     &      2.0005D+00 , 2.0763D+00 , 2.1507D+00 , 2.2377D+00 , 
     &      2.3179D+00 , 2.3917D+00 , 2.4592D+00 , 2.5218D+00 , 
     &      2.5799D+00 , 2.6336D+00 , 2.6843D+00 , 2.7314D+00 , 
     &      2.7753D+00 , 2.8166D+00 , 2.7824D+00 , 2.8054D+00 , 
     &      2.8081D+00 , 2.7893D+00 , 2.7474D+00 , 2.6818D+00 , 
     &      2.5888D+00 , 2.4646D+00 , 2.3032D+00 , 2.0902D+00 , 
     &      1.8025D+00 , 1.3740D+00 , 0.0000D+00 , 3.2793D+00 , 
     &      3.2385D+00 , 3.2014D+00 , 3.1643D+00 , 3.1270D+00 , 
     &      3.0888D+00 , 3.0517D+00 , 3.0141D+00 , 2.9773D+00 , 
     &      2.9392D+00 , 2.9009D+00 , 2.8610D+00 , 2.8230D+00 , 
     &      2.8000D+00 , 2.7754D+00 , 2.7459D+00 , 2.7163D+00 , 
     &      2.6858D+00 , 2.6545D+00 , 2.6270D+00 , 2.5962D+00 , 
     &      2.5617D+00 , 2.5271D+00 , 2.4903D+00 , 2.4527D+00 , 
     &      2.4207D+00 , 2.3851D+00 , 2.3421D+00 , 2.2960D+00 , 
     &      2.2476D+00 , 2.1987D+00 , 2.1578D+00 , 2.1146D+00 , 
     &      2.0670D+00 , 2.0202D+00 , 1.9796D+00 , 1.9468D+00 , 
     &      1.9282D+00 , 1.9203D+00 , 1.9319D+00 , 1.9712D+00 , 
     &      2.0197D+00 , 2.0872D+00 , 2.1524D+00 , 2.2288D+00 , 
     &      2.2981D+00 , 2.3606D+00 , 2.4177D+00 , 2.4692D+00 , 
     &      2.5159D+00 , 2.5591D+00 , 2.5981D+00 , 2.6339D+00 , 
     &      2.6669D+00 , 2.6962D+00 , 2.6528D+00 , 2.6566D+00 , 
     &      2.6395D+00 , 2.6028D+00 , 2.5437D+00 , 2.4622D+00 , 
     &      2.3555D+00 , 2.2200D+00 , 2.0488D+00 , 1.8335D+00 , 
     &      1.5506D+00 , 1.1442D+00 , 0.0000D+00 , 3.3868D+00 , 
     &      3.3470D+00 , 3.3075D+00 , 3.2689D+00/
      DATA (xuvf_l(k),k=685,798)/3.2300D+00 , 3.1909D+00 , 3.1517D+00 , 
     &      3.1129D+00 , 3.0747D+00 , 3.0335D+00 , 2.9946D+00 , 
     &      2.9537D+00 , 2.9140D+00 , 2.8896D+00 , 2.8638D+00 , 
     &      2.8337D+00 , 2.8021D+00 , 2.7705D+00 , 2.7373D+00 , 
     &      2.7075D+00 , 2.6767D+00 , 2.6403D+00 , 2.6031D+00 , 
     &      2.5649D+00 , 2.5258D+00 , 2.4917D+00 , 2.4537D+00 , 
     &      2.4080D+00 , 2.3597D+00 , 2.3091D+00 , 2.2580D+00 , 
     &      2.2150D+00 , 2.1692D+00 , 2.1186D+00 , 2.0701D+00 , 
     &      2.0257D+00 , 1.9901D+00 , 1.9679D+00 , 1.9571D+00 , 
     &      1.9629D+00 , 1.9955D+00 , 2.0378D+00 , 2.0963D+00 , 
     &      2.1529D+00 , 2.2178D+00 , 2.2766D+00 , 2.3287D+00 , 
     &      2.3749D+00 , 2.4162D+00 , 2.4529D+00 , 2.4850D+00 , 
     &      2.5140D+00 , 2.5392D+00 , 2.5617D+00 , 2.5798D+00 , 
     &      2.5298D+00 , 2.5151D+00 , 2.4811D+00 , 2.4282D+00 , 
     &      2.3561D+00 , 2.2611D+00 , 2.1439D+00 , 2.0005D+00 , 
     &      1.8252D+00 , 1.6091D+00 , 1.3345D+00 , 9.5375D-01 , 
     &      0.0000D+00 , 3.4912D+00 , 3.4507D+00 , 3.4100D+00 , 
     &      3.3696D+00 , 3.3310D+00 , 3.2893D+00 , 3.2496D+00 , 
     &      3.2088D+00 , 3.1686D+00 , 3.1278D+00 , 3.0865D+00 , 
     &      3.0438D+00 , 3.0020D+00 , 2.9766D+00 , 2.9494D+00 , 
     &      2.9180D+00 , 2.8850D+00 , 2.8520D+00 , 2.8174D+00 , 
     &      2.7877D+00 , 2.7550D+00 , 2.7169D+00 , 2.6762D+00 , 
     &      2.6369D+00 , 2.5958D+00 , 2.5594D+00 , 2.5195D+00 , 
     &      2.4721D+00 , 2.4211D+00 , 2.3680D+00 , 2.3145D+00 , 
     &      2.2695D+00 , 2.2214D+00 , 2.1684D+00 , 2.1154D+00 , 
     &      2.0706D+00 , 2.0303D+00 , 2.0058D+00 , 1.9909D+00 , 
     &      1.9920D+00 , 2.0177D+00 , 2.0531D+00 , 2.1031D+00 , 
     &      2.1511D+00 , 2.2060D+00 , 2.2548D+00 , 2.2972D+00 , 
     &      2.3339D+00 , 2.3655D+00 , 2.3927D+00/
      DATA (xuvf_l(k),k=799,912)/2.4159D+00 , 2.4357D+00 , 2.4520D+00 , 
     &      2.4644D+00 , 2.4735D+00 , 2.4171D+00 , 2.3878D+00 , 
     &      2.3397D+00 , 2.2743D+00 , 2.1907D+00 , 2.0861D+00 , 
     &      1.9611D+00 , 1.8128D+00 , 1.6351D+00 , 1.4227D+00 , 
     &      1.1584D+00 , 8.0371D-01 , 0.0000D+00 , 3.5892D+00 , 
     &      3.5473D+00 , 3.5055D+00 , 3.4637D+00 , 3.4230D+00 , 
     &      3.3809D+00 , 3.3396D+00 , 3.2976D+00 , 3.2571D+00 , 
     &      3.2126D+00 , 3.1696D+00 , 3.1272D+00 , 3.0840D+00 , 
     &      3.0569D+00 , 3.0286D+00 , 2.9959D+00 , 2.9619D+00 , 
     &      2.9273D+00 , 2.8910D+00 , 2.8598D+00 , 2.8266D+00 , 
     &      2.7863D+00 , 2.7448D+00 , 2.7029D+00 , 2.6598D+00 , 
     &      2.6219D+00 , 2.5804D+00 , 2.5305D+00 , 2.4773D+00 , 
     &      2.4214D+00 , 2.3662D+00 , 2.3191D+00 , 2.2698D+00 , 
     &      2.2126D+00 , 2.1577D+00 , 2.1092D+00 , 2.0674D+00 , 
     &      2.0393D+00 , 2.0210D+00 , 2.0173D+00 , 2.0367D+00 , 
     &      2.0654D+00 , 2.1076D+00 , 2.1485D+00 , 2.1942D+00 , 
     &      2.2338D+00 , 2.2678D+00 , 2.2959D+00 , 2.3193D+00 , 
     &      2.3386D+00 , 2.3539D+00 , 2.3660D+00 , 2.3738D+00 , 
     &      2.3789D+00 , 2.3799D+00 , 2.3197D+00 , 2.2776D+00 , 
     &      2.2186D+00 , 2.1426D+00 , 2.0495D+00 , 1.9397D+00 , 
     &      1.8097D+00 , 1.6583D+00 , 1.4814D+00 , 1.2736D+00 , 
     &      1.0200D+00 , 6.8880D-01 , 0.0000D+00 , 3.7157D+00 , 
     &      3.6699D+00 , 3.6275D+00 , 3.5842D+00 , 3.5420D+00 , 
     &      3.4972D+00 , 3.4542D+00 , 3.4107D+00 , 3.3678D+00 , 
     &      3.3234D+00 , 3.2774D+00 , 3.2332D+00 , 3.1870D+00 , 
     &      3.1600D+00 , 3.1297D+00 , 3.0952D+00 , 3.0595D+00 , 
     &      3.0231D+00 , 2.9850D+00 , 2.9534D+00 , 2.9160D+00 , 
     &      2.8740D+00 , 2.8312D+00 , 2.7872D+00 , 2.7408D+00 , 
     &      2.7014D+00 , 2.6568D+00 , 2.6045D+00/
      DATA (xuvf_l(k),k=913,1026)/2.5481D+00 , 2.4895D+00 , 2.4315D+00 , 
     &      2.3817D+00 , 2.3283D+00 , 2.2697D+00 , 2.2106D+00 , 
     &      2.1591D+00 , 2.1128D+00 , 2.0807D+00 , 2.0578D+00 , 
     &      2.0477D+00 , 2.0583D+00 , 2.0796D+00 , 2.1122D+00 , 
     &      2.1433D+00 , 2.1777D+00 , 2.2069D+00 , 2.2299D+00 , 
     &      2.2483D+00 , 2.2618D+00 , 2.2718D+00 , 2.2778D+00 , 
     &      2.2803D+00 , 2.2797D+00 , 2.2749D+00 , 2.2668D+00 , 
     &      2.2019D+00 , 2.1468D+00 , 2.0761D+00 , 1.9902D+00 , 
     &      1.8883D+00 , 1.7711D+00 , 1.6370D+00 , 1.4847D+00 , 
     &      1.3103D+00 , 1.1091D+00 , 8.7047D-01 , 5.6856D-01 , 
     &      0.0000D+00 , 3.8327D+00 , 3.7877D+00 , 3.7424D+00 , 
     &      3.6981D+00 , 3.6540D+00 , 3.6083D+00 , 3.5637D+00 , 
     &      3.5184D+00 , 3.4753D+00 , 3.4271D+00 , 3.3800D+00 , 
     &      3.3325D+00 , 3.2860D+00 , 3.2564D+00 , 3.2258D+00 , 
     &      3.1893D+00 , 3.1519D+00 , 3.1135D+00 , 3.0738D+00 , 
     &      3.0389D+00 , 3.0010D+00 , 2.9580D+00 , 2.9118D+00 , 
     &      2.8654D+00 , 2.8178D+00 , 2.7758D+00 , 2.7289D+00 , 
     &      2.6738D+00 , 2.6146D+00 , 2.5530D+00 , 2.4924D+00 , 
     &      2.4399D+00 , 2.3845D+00 , 2.3213D+00 , 2.2605D+00 , 
     &      2.2040D+00 , 2.1540D+00 , 2.1186D+00 , 2.0908D+00 , 
     &      2.0749D+00 , 2.0772D+00 , 2.0914D+00 , 2.1145D+00 , 
     &      2.1368D+00 , 2.1613D+00 , 2.1804D+00 , 2.1941D+00 , 
     &      2.2037D+00 , 2.2088D+00 , 2.2101D+00 , 2.2083D+00 , 
     &      2.2031D+00 , 2.1942D+00 , 2.1826D+00 , 2.1665D+00 , 
     &      2.0987D+00 , 2.0321D+00 , 1.9516D+00 , 1.8571D+00 , 
     &      1.7497D+00 , 1.6281D+00 , 1.4923D+00 , 1.3406D+00 , 
     &      1.1697D+00 , 9.7635D-01 , 7.5209D-01 , 4.7638D-01 , 
     &      0.0000D+00 , 3.9497D+00 , 3.9009D+00 , 3.8555D+00 , 
     &      3.8080D+00 , 3.7630D+00 , 3.7163D+00/
      DATA (xuvf_l(k),k=1027,1140)/3.6699D+00 , 3.6231D+00 , 
     &      3.5765D+00 , 3.5285D+00 , 3.4807D+00 , 3.4305D+00 , 
     &      3.3810D+00 , 3.3511D+00 , 3.3185D+00 , 3.2805D+00 , 
     &      3.2414D+00 , 3.2016D+00 , 3.1598D+00 , 3.1244D+00 , 
     &      3.0837D+00 , 3.0383D+00 , 2.9908D+00 , 2.9424D+00 , 
     &      2.8919D+00 , 2.8477D+00 , 2.7990D+00 , 2.7403D+00 , 
     &      2.6784D+00 , 2.6142D+00 , 2.5507D+00 , 2.4960D+00 , 
     &      2.4362D+00 , 2.3710D+00 , 2.3058D+00 , 2.2463D+00 , 
     &      2.1931D+00 , 2.1539D+00 , 2.1216D+00 , 2.0996D+00 , 
     &      2.0940D+00 , 2.1012D+00 , 2.1154D+00 , 2.1294D+00 , 
     &      2.1444D+00 , 2.1543D+00 , 2.1597D+00 , 2.1610D+00 , 
     &      2.1585D+00 , 2.1523D+00 , 2.1432D+00 , 2.1307D+00 , 
     &      2.1155D+00 , 2.0964D+00 , 2.0742D+00 , 2.0035D+00 , 
     &      1.9273D+00 , 1.8396D+00 , 1.7387D+00 , 1.6273D+00 , 
     &      1.5032D+00 , 1.3665D+00 , 1.2164D+00 , 1.0501D+00 , 
     &      8.6515D-01 , 6.5470D-01 , 4.0284D-01 , 0.0000D+00 , 
     &      4.0572D+00 , 4.0093D+00 , 3.9616D+00 , 3.9140D+00 , 
     &      3.8670D+00 , 3.8185D+00 , 3.7706D+00 , 3.7224D+00 , 
     &      3.6746D+00 , 3.6251D+00 , 3.5744D+00 , 3.5233D+00 , 
     &      3.4720D+00 , 3.4406D+00 , 3.4062D+00 , 3.3671D+00 , 
     &      3.3263D+00 , 3.2847D+00 , 3.2414D+00 , 3.2046D+00 , 
     &      3.1620D+00 , 3.1150D+00 , 3.0653D+00 , 3.0145D+00 , 
     &      2.9619D+00 , 2.9153D+00 , 2.8641D+00 , 2.8032D+00 , 
     &      2.7388D+00 , 2.6715D+00 , 2.6056D+00 , 2.5481D+00 , 
     &      2.4880D+00 , 2.4171D+00 , 2.3496D+00 , 2.2862D+00 , 
     &      2.2282D+00 , 2.1865D+00 , 2.1502D+00 , 2.1217D+00 , 
     &      2.1086D+00 , 2.1086D+00 , 2.1149D+00 , 2.1216D+00 , 
     &      2.1275D+00 , 2.1295D+00 , 2.1273D+00 , 2.1212D+00 , 
     &      2.1119D+00 , 2.0992D+00 , 2.0837D+00 , 2.0653D+00/
      DATA (xuvf_l(k),k=1141,1254)/2.0442D+00 , 2.0194D+00 , 
     &      1.9912D+00 , 1.9193D+00 , 1.8359D+00 , 1.7412D+00 , 
     &      1.6366D+00 , 1.5214D+00 , 1.3956D+00 , 1.2594D+00 , 
     &      1.1115D+00 , 9.5033D-01 , 7.7356D-01 , 5.7585D-01 , 
     &      3.4506D-01 , 0.0000D+00 , 4.1710D+00 , 4.1201D+00 , 
     &      4.0712D+00 , 4.0213D+00 , 3.9730D+00 , 3.9228D+00 , 
     &      3.8734D+00 , 3.8233D+00 , 3.7726D+00 , 3.7217D+00 , 
     &      3.6699D+00 , 3.6160D+00 , 3.5640D+00 , 3.5311D+00 , 
     &      3.4960D+00 , 3.4549D+00 , 3.4121D+00 , 3.3689D+00 , 
     &      3.3237D+00 , 3.2848D+00 , 3.2425D+00 , 3.1917D+00 , 
     &      3.1399D+00 , 3.0866D+00 , 3.0319D+00 , 2.9838D+00 , 
     &      2.9306D+00 , 2.8668D+00 , 2.7992D+00 , 2.7291D+00 , 
     &      2.6605D+00 , 2.6007D+00 , 2.5375D+00 , 2.4631D+00 , 
     &      2.3919D+00 , 2.3261D+00 , 2.2643D+00 , 2.2183D+00 , 
     &      2.1772D+00 , 2.1426D+00 , 2.1222D+00 , 2.1155D+00 , 
     &      2.1135D+00 , 2.1130D+00 , 2.1102D+00 , 2.1039D+00 , 
     &      2.0941D+00 , 2.0815D+00 , 2.0652D+00 , 2.0466D+00 , 
     &      2.0251D+00 , 2.0014D+00 , 1.9746D+00 , 1.9450D+00 , 
     &      1.9116D+00 , 1.8381D+00 , 1.7481D+00 , 1.6484D+00 , 
     &      1.5404D+00 , 1.4225D+00 , 1.2963D+00 , 1.1611D+00 , 
     &      1.0161D+00 , 8.6047D-01 , 6.9193D-01 , 5.0691D-01 , 
     &      2.9581D-01 , 0.0000D+00 , 4.2754D+00 , 4.2238D+00 , 
     &      4.1737D+00 , 4.1233D+00 , 4.0740D+00 , 4.0219D+00 , 
     &      3.9713D+00 , 3.9196D+00 , 3.8675D+00 , 3.8160D+00 , 
     &      3.7618D+00 , 3.7060D+00 , 3.6510D+00 , 3.6173D+00 , 
     &      3.5808D+00 , 3.5380D+00 , 3.4941D+00 , 3.4493D+00 , 
     &      3.4027D+00 , 3.3623D+00 , 3.3163D+00 , 3.2647D+00 , 
     &      3.2114D+00 , 3.1563D+00 , 3.0989D+00 , 3.0489D+00 , 
     &      2.9929D+00 , 2.9263D+00 , 2.8563D+00 , 2.7837D+00/
      DATA (xuvf_l(k),k=1255,1368)/2.7122D+00 , 2.6501D+00 , 
     &      2.5825D+00 , 2.5073D+00 , 2.4327D+00 , 2.3623D+00 , 
     &      2.2962D+00 , 2.2474D+00 , 2.2020D+00 , 2.1616D+00 , 
     &      2.1335D+00 , 2.1209D+00 , 2.1113D+00 , 2.1034D+00 , 
     &      2.0929D+00 , 2.0795D+00 , 2.0634D+00 , 2.0439D+00 , 
     &      2.0222D+00 , 1.9982D+00 , 1.9716D+00 , 1.9428D+00 , 
     &      1.9113D+00 , 1.8773D+00 , 1.8394D+00 , 1.7649D+00 , 
     &      1.6692D+00 , 1.5658D+00 , 1.4547D+00 , 1.3360D+00 , 
     &      1.2095D+00 , 1.0761D+00 , 9.3485D-01 , 7.8430D-01 , 
     &      6.2380D-01 , 4.5010D-01 , 2.5625D-01 , 0.0000D+00 , 
     &      4.3798D+00 , 4.3275D+00 , 4.2762D+00 , 4.2239D+00 , 
     &      4.1730D+00 , 4.1196D+00 , 4.0674D+00 , 4.0143D+00 , 
     &      3.9623D+00 , 3.9056D+00 , 3.8502D+00 , 3.7935D+00 , 
     &      3.7370D+00 , 3.7018D+00 , 3.6642D+00 , 3.6200D+00 , 
     &      3.5742D+00 , 3.5277D+00 , 3.4786D+00 , 3.4371D+00 , 
     &      3.3901D+00 , 3.3359D+00 , 3.2800D+00 , 3.2235D+00 , 
     &      3.1639D+00 , 3.1115D+00 , 3.0537D+00 , 2.9847D+00 , 
     &      2.9116D+00 , 2.8364D+00 , 2.7623D+00 , 2.6973D+00 , 
     &      2.6275D+00 , 2.5497D+00 , 2.4705D+00 , 2.3972D+00 , 
     &      2.3281D+00 , 2.2747D+00 , 2.2253D+00 , 2.1793D+00 , 
     &      2.1444D+00 , 2.1253D+00 , 2.1081D+00 , 2.0939D+00 , 
     &      2.0755D+00 , 2.0555D+00 , 2.0332D+00 , 2.0081D+00 , 
     &      1.9814D+00 , 1.9522D+00 , 1.9205D+00 , 1.8875D+00 , 
     &      1.8520D+00 , 1.8139D+00 , 1.7725D+00 , 1.6968D+00 , 
     &      1.5976D+00 , 1.4911D+00 , 1.3772D+00 , 1.2577D+00 , 
     &      1.1320D+00 , 1.0005D+00 , 8.6242D-01 , 7.1750D-01 , 
     &      5.6466D-01 , 4.0150D-01 , 2.2333D-01 , 0.0000D+00 , 
     &      4.4809D+00 , 4.4265D+00 , 4.3735D+00 , 4.3193D+00 , 
     &      4.2670D+00 , 4.2128D+00 , 4.1585D+00 , 4.1039D+00/
      DATA (xuvf_l(k),k=1369,1482)/4.0509D+00 , 3.9928D+00 , 
     &      3.9351D+00 , 3.8769D+00 , 3.8180D+00 , 3.7821D+00 , 
     &      3.7434D+00 , 3.6974D+00 , 3.6501D+00 , 3.6019D+00 , 
     &      3.5513D+00 , 3.5093D+00 , 3.4594D+00 , 3.4035D+00 , 
     &      3.3456D+00 , 3.2870D+00 , 3.2250D+00 , 3.1715D+00 , 
     &      3.1110D+00 , 3.0396D+00 , 2.9639D+00 , 2.8863D+00 , 
     &      2.8096D+00 , 2.7429D+00 , 2.6702D+00 , 2.5884D+00 , 
     &      2.5068D+00 , 2.4296D+00 , 2.3560D+00 , 2.3003D+00 , 
     &      2.2464D+00 , 2.1951D+00 , 2.1530D+00 , 2.1283D+00 , 
     &      2.1045D+00 , 2.0843D+00 , 2.0591D+00 , 2.0328D+00 , 
     &      2.0047D+00 , 1.9749D+00 , 1.9429D+00 , 1.9096D+00 , 
     &      1.8740D+00 , 1.8369D+00 , 1.7978D+00 , 1.7560D+00 , 
     &      1.7116D+00 , 1.6360D+00 , 1.5322D+00 , 1.4233D+00 , 
     &      1.3084D+00 , 1.1885D+00 , 1.0637D+00 , 9.3449D-01 , 
     &      7.9961D-01 , 6.6020D-01 , 5.1453D-01 , 3.6103D-01 , 
     &      1.9641D-01 , 0.0000D+00 , 4.6169D+00 , 4.5608D+00 , 
     &      4.5060D+00 , 4.4504D+00 , 4.3960D+00 , 4.3395D+00 , 
     &      4.2837D+00 , 4.2262D+00 , 4.1710D+00 , 4.1106D+00 , 
     &      4.0517D+00 , 3.9908D+00 , 3.9300D+00 , 3.8920D+00 , 
     &      3.8509D+00 , 3.8030D+00 , 3.7538D+00 , 3.7035D+00 , 
     &      3.6494D+00 , 3.6055D+00 , 3.5556D+00 , 3.4966D+00 , 
     &      3.4351D+00 , 3.3738D+00 , 3.3090D+00 , 3.2518D+00 , 
     &      3.1888D+00 , 3.1141D+00 , 3.0348D+00 , 2.9533D+00 , 
     &      2.8730D+00 , 2.8020D+00 , 2.7264D+00 , 2.6400D+00 , 
     &      2.5551D+00 , 2.4732D+00 , 2.3941D+00 , 2.3329D+00 , 
     &      2.2742D+00 , 2.2147D+00 , 2.1644D+00 , 2.1317D+00 , 
     &      2.0986D+00 , 2.0700D+00 , 2.0363D+00 , 2.0021D+00 , 
     &      1.9668D+00 , 1.9299D+00 , 1.8922D+00 , 1.8532D+00 , 
     &      1.8125D+00 , 1.7704D+00 , 1.7270D+00 , 1.6809D+00/
      DATA (xuvf_l(k),k=1483,1596)/1.6327D+00 , 1.5570D+00 , 
     &      1.4497D+00 , 1.3373D+00 , 1.2215D+00 , 1.1020D+00 , 
     &      9.7897D-01 , 8.5304D-01 , 7.2349D-01 , 5.9074D-01 , 
     &      4.5411D-01 , 3.1307D-01 , 1.6547D-01 , 0.0000D+00 , 
     &      4.7403D+00 , 4.6834D+00 , 4.6262D+00 , 4.5696D+00 , 
     &      4.5140D+00 , 4.4557D+00 , 4.3978D+00 , 4.3393D+00 , 
     &      4.2817D+00 , 4.2191D+00 , 4.1578D+00 , 4.0941D+00 , 
     &      4.0310D+00 , 3.9917D+00 , 3.9492D+00 , 3.8995D+00 , 
     &      3.8481D+00 , 3.7958D+00 , 3.7411D+00 , 3.6937D+00 , 
     &      3.6405D+00 , 3.5806D+00 , 3.5171D+00 , 3.4520D+00 , 
     &      3.3840D+00 , 3.3254D+00 , 3.2596D+00 , 3.1812D+00 , 
     &      3.0985D+00 , 3.0137D+00 , 2.9301D+00 , 2.8556D+00 , 
     &      2.7782D+00 , 2.6879D+00 , 2.5974D+00 , 2.5119D+00 , 
     &      2.4281D+00 , 2.3629D+00 , 2.2982D+00 , 2.2324D+00 , 
     &      2.1730D+00 , 2.1332D+00 , 2.0922D+00 , 2.0570D+00 , 
     &      2.0152D+00 , 1.9739D+00 , 1.9323D+00 , 1.8902D+00 , 
     &      1.8474D+00 , 1.8039D+00 , 1.7589D+00 , 1.7129D+00 , 
     &      1.6654D+00 , 1.6163D+00 , 1.5652D+00 , 1.4896D+00 , 
     &      1.3789D+00 , 1.2649D+00 , 1.1487D+00 , 1.0300D+00 , 
     &      9.0896D-01 , 7.8619D-01 , 6.6149D-01 , 5.3498D-01 , 
     &      4.0654D-01 , 2.7586D-01 , 1.4208D-01 , 0.0000D+00 , 
     &      4.8699D+00 , 4.8107D+00 , 4.7518D+00 , 4.6928D+00 , 
     &      4.6350D+00 , 4.5750D+00 , 4.5152D+00 , 4.4524D+00 , 
     &      4.3956D+00 , 4.3299D+00 , 4.2674D+00 , 4.2014D+00 , 
     &      4.1350D+00 , 4.0939D+00 , 4.0503D+00 , 3.9982D+00 , 
     &      3.9448D+00 , 3.8905D+00 , 3.8328D+00 , 3.7846D+00 , 
     &      3.7300D+00 , 3.6664D+00 , 3.5991D+00 , 3.5326D+00 , 
     &      3.4620D+00 , 3.3998D+00 , 3.3311D+00 , 3.2494D+00 , 
     &      3.1632D+00 , 3.0752D+00 , 2.9881D+00 , 2.9120D+00/
      DATA (xuvf_l(k),k=1597,1710)/2.8299D+00 , 2.7339D+00 , 
     &      2.6398D+00 , 2.5493D+00 , 2.4611D+00 , 2.3911D+00 , 
     &      2.3215D+00 , 2.2482D+00 , 2.1812D+00 , 2.1342D+00 , 
     &      2.0854D+00 , 2.0427D+00 , 1.9932D+00 , 1.9453D+00 , 
     &      1.8978D+00 , 1.8504D+00 , 1.8030D+00 , 1.7545D+00 , 
     &      1.7059D+00 , 1.6565D+00 , 1.6056D+00 , 1.5535D+00 , 
     &      1.4989D+00 , 1.4245D+00 , 1.3108D+00 , 1.1959D+00 , 
     &      1.0798D+00 , 9.6219D-01 , 8.4358D-01 , 7.2422D-01 , 
     &      6.0451D-01 , 4.8425D-01 , 3.6380D-01 , 2.4286D-01 , 
     &      1.2189D-01 , 0.0000D+00 , 4.9964D+00 , 4.9356D+00 , 
     &      4.8755D+00 , 4.8147D+00 , 4.7550D+00 , 4.6935D+00 , 
     &      4.6315D+00 , 4.5697D+00 , 4.5062D+00 , 4.4406D+00 , 
     &      4.3752D+00 , 4.3061D+00 , 4.2380D+00 , 4.1962D+00 , 
     &      4.1500D+00 , 4.0963D+00 , 4.0405D+00 , 3.9832D+00 , 
     &      3.9245D+00 , 3.8728D+00 , 3.8172D+00 , 3.7504D+00 , 
     &      3.6811D+00 , 3.6108D+00 , 3.5381D+00 , 3.4734D+00 , 
     &      3.4018D+00 , 3.3164D+00 , 3.2269D+00 , 3.1352D+00 , 
     &      3.0446D+00 , 2.9657D+00 , 2.8794D+00 , 2.7800D+00 , 
     &      2.6821D+00 , 2.5867D+00 , 2.4930D+00 , 2.4184D+00 , 
     &      2.3433D+00 , 2.2634D+00 , 2.1877D+00 , 2.1342D+00 , 
     &      2.0772D+00 , 2.0279D+00 , 1.9713D+00 , 1.9172D+00 , 
     &      1.8642D+00 , 1.8120D+00 , 1.7600D+00 , 1.7076D+00 , 
     &      1.6553D+00 , 1.6027D+00 , 1.5491D+00 , 1.4938D+00 , 
     &      1.4374D+00 , 1.3637D+00 , 1.2481D+00 , 1.1325D+00 , 
     &      1.0166D+00 , 9.0047D-01 , 7.8428D-01 , 6.6889D-01 , 
     &      5.5381D-01 , 4.3953D-01 , 3.2652D-01 , 2.1461D-01 , 
     &      1.0498D-01 , 0.0000D+00 , 5.1134D+00 , 5.0511D+00 , 
     &      4.9886D+00 , 4.9273D+00 , 4.8660D+00 , 4.8016D+00 , 
     &      4.7382D+00 , 4.6744D+00 , 4.6106D+00 , 4.5420D+00/
      DATA (xuvf_l(k),k=1711,1824)/4.4742D+00 , 4.4028D+00 , 
     &      4.3320D+00 , 4.2892D+00 , 4.2413D+00 , 4.1858D+00 , 
     &      4.1281D+00 , 4.0682D+00 , 4.0067D+00 , 3.9556D+00 , 
     &      3.8955D+00 , 3.8271D+00 , 3.7556D+00 , 3.6829D+00 , 
     &      3.6071D+00 , 3.5401D+00 , 3.4662D+00 , 3.3777D+00 , 
     &      3.2849D+00 , 3.1898D+00 , 3.0960D+00 , 3.0140D+00 , 
     &      2.9244D+00 , 2.8224D+00 , 2.7183D+00 , 2.6191D+00 , 
     &      2.5219D+00 , 2.4431D+00 , 2.3628D+00 , 2.2767D+00 , 
     &      2.1931D+00 , 2.1332D+00 , 2.0695D+00 , 2.0145D+00 , 
     &      1.9514D+00 , 1.8920D+00 , 1.8340D+00 , 1.7775D+00 , 
     &      1.7215D+00 , 1.6664D+00 , 1.6108D+00 , 1.5553D+00 , 
     &      1.4995D+00 , 1.4421D+00 , 1.3839D+00 , 1.3103D+00 , 
     &      1.1944D+00 , 1.0782D+00 , 9.6271D-01 , 8.4822D-01 , 
     &      7.3481D-01 , 6.2240D-01 , 5.1184D-01 , 4.0291D-01 , 
     &      2.9618D-01 , 1.9206D-01 , 9.1846D-02 , 0.0000D+00 , 
     &      5.2367D+00 , 5.1713D+00 , 5.1071D+00 , 5.0425D+00 , 
     &      4.9800D+00 , 4.9141D+00 , 4.8489D+00 , 4.7833D+00 , 
     &      4.7181D+00 , 4.6457D+00 , 4.5768D+00 , 4.5034D+00 , 
     &      4.4300D+00 , 4.3847D+00 , 4.3353D+00 , 4.2782D+00 , 
     &      4.2182D+00 , 4.1570D+00 , 4.0921D+00 , 4.0385D+00 , 
     &      3.9782D+00 , 3.9074D+00 , 3.8331D+00 , 3.7575D+00 , 
     &      3.6781D+00 , 3.6086D+00 , 3.5313D+00 , 3.4401D+00 , 
     &      3.3439D+00 , 3.2455D+00 , 3.1483D+00 , 3.0623D+00 , 
     &      2.9694D+00 , 2.8629D+00 , 2.7561D+00 , 2.6527D+00 , 
     &      2.5508D+00 , 2.4669D+00 , 2.3816D+00 , 2.2887D+00 , 
     &      2.1979D+00 , 2.1317D+00 , 2.0613D+00 , 2.0002D+00 , 
     &      1.9307D+00 , 1.8659D+00 , 1.8033D+00 , 1.7426D+00 , 
     &      1.6834D+00 , 1.6247D+00 , 1.5668D+00 , 1.5085D+00 , 
     &      1.4504D+00 , 1.3916D+00 , 1.3311D+00 , 1.2591D+00/
      DATA (xuvf_l(k),k=1825,1836)/1.1415D+00 , 1.0256D+00 , 
     &      9.1107D-01 , 7.9840D-01 , 6.8736D-01 , 5.7902D-01 , 
     &      4.7260D-01 , 3.6895D-01 , 2.6838D-01 , 1.7161D-01 , 
     &      8.0264D-02 , 0.0000D+00/
      DATA (xdvf_l(k),k=1,114)/1.4230D+00 , 1.4064D+00 , 1.3903D+00 , 
     &      1.3749D+00 , 1.3590D+00 , 1.3424D+00 , 1.3271D+00 , 
     &      1.3114D+00 , 1.2962D+00 , 1.2803D+00 , 1.2647D+00 , 
     &      1.2492D+00 , 1.2340D+00 , 1.2246D+00 , 1.2155D+00 , 
     &      1.2044D+00 , 1.1927D+00 , 1.1814D+00 , 1.1695D+00 , 
     &      1.1589D+00 , 1.1479D+00 , 1.1347D+00 , 1.1214D+00 , 
     &      1.1080D+00 , 1.0944D+00 , 1.0824D+00 , 1.0700D+00 , 
     &      1.0544D+00 , 1.0371D+00 , 1.0188D+00 , 9.9884D-01 , 
     &      9.8287D-01 , 9.6563D-01 , 9.4645D-01 , 9.2847D-01 , 
     &      9.1313D-01 , 9.0246D-01 , 8.9955D-01 , 9.0461D-01 , 
     &      9.2737D-01 , 9.7648D-01 , 1.0343D+00 , 1.1168D+00 , 
     &      1.2030D+00 , 1.3129D+00 , 1.4240D+00 , 1.5357D+00 , 
     &      1.6492D+00 , 1.7643D+00 , 1.8818D+00 , 2.0016D+00 , 
     &      2.1253D+00 , 2.2535D+00 , 2.3853D+00 , 2.5225D+00 , 
     &      2.5620D+00 , 2.7906D+00 , 3.0230D+00 , 3.2574D+00 , 
     &      3.4983D+00 , 3.7459D+00 , 4.0062D+00 , 4.2803D+00 , 
     &      4.5790D+00 , 4.9150D+00 , 5.3263D+00 , 5.9228D+00 , 
     &      0.0000D+00 , 1.4698D+00 , 1.4526D+00 , 1.4360D+00 , 
     &      1.4199D+00 , 1.4030D+00 , 1.3864D+00 , 1.3702D+00 , 
     &      1.3542D+00 , 1.3386D+00 , 1.3221D+00 , 1.3059D+00 , 
     &      1.2896D+00 , 1.2740D+00 , 1.2644D+00 , 1.2544D+00 , 
     &      1.2425D+00 , 1.2309D+00 , 1.2185D+00 , 1.2061D+00 , 
     &      1.1953D+00 , 1.1836D+00 , 1.1697D+00 , 1.1558D+00 , 
     &      1.1417D+00 , 1.1275D+00 , 1.1154D+00 , 1.1011D+00 , 
     &      1.0844D+00 , 1.0663D+00 , 1.0471D+00 , 1.0261D+00 , 
     &      1.0092D+00 , 9.9133D-01 , 9.7103D-01 , 9.5184D-01 , 
     &      9.3560D-01 , 9.2380D-01 , 9.1922D-01 , 9.2378D-01 , 
     &      9.4563D-01 , 9.9235D-01 , 1.0474D+00 , 1.1262D+00 , 
     &      1.2078D+00 , 1.3110D+00 , 1.4146D+00/
      DATA (xdvf_l(k),k=115,228)/1.5192D+00 , 1.6241D+00 , 1.7298D+00 , 
     &      1.8375D+00 , 1.9471D+00 , 2.0592D+00 , 2.1741D+00 , 
     &      2.2925D+00 , 2.4144D+00 , 2.4425D+00 , 2.6407D+00 , 
     &      2.8375D+00 , 3.0361D+00 , 3.2345D+00 , 3.4343D+00 , 
     &      3.6388D+00 , 3.8488D+00 , 4.0682D+00 , 4.3043D+00 , 
     &      4.5737D+00 , 4.9280D+00 , 0.0000D+00 , 1.5226D+00 , 
     &      1.5047D+00 , 1.4874D+00 , 1.4702D+00 , 1.4530D+00 , 
     &      1.4363D+00 , 1.4193D+00 , 1.4023D+00 , 1.3860D+00 , 
     &      1.3690D+00 , 1.3520D+00 , 1.3351D+00 , 1.3190D+00 , 
     &      1.3083D+00 , 1.2983D+00 , 1.2858D+00 , 1.2733D+00 , 
     &      1.2606D+00 , 1.2476D+00 , 1.2362D+00 , 1.2237D+00 , 
     &      1.2092D+00 , 1.1943D+00 , 1.1795D+00 , 1.1645D+00 , 
     &      1.1509D+00 , 1.1365D+00 , 1.1185D+00 , 1.0994D+00 , 
     &      1.0784D+00 , 1.0566D+00 , 1.0388D+00 , 1.0195D+00 , 
     &      9.9801D-01 , 9.7765D-01 , 9.6019D-01 , 9.4712D-01 , 
     &      9.4158D-01 , 9.4524D-01 , 9.6454D-01 , 1.0088D+00 , 
     &      1.0604D+00 , 1.1346D+00 , 1.2112D+00 , 1.3076D+00 , 
     &      1.4038D+00 , 1.4995D+00 , 1.5957D+00 , 1.6918D+00 , 
     &      1.7888D+00 , 1.8877D+00 , 1.9877D+00 , 2.0896D+00 , 
     &      2.1940D+00 , 2.2999D+00 , 2.3168D+00 , 2.4844D+00 , 
     &      2.6497D+00 , 2.8098D+00 , 2.9678D+00 , 3.1219D+00 , 
     &      3.2743D+00 , 3.4260D+00 , 3.5742D+00 , 3.7237D+00 , 
     &      3.8717D+00 , 4.0300D+00 , 0.0000D+00 , 1.5849D+00 , 
     &      1.5662D+00 , 1.5482D+00 , 1.5298D+00 , 1.5130D+00 , 
     &      1.4944D+00 , 1.4769D+00 , 1.4593D+00 , 1.4423D+00 , 
     &      1.4243D+00 , 1.4066D+00 , 1.3894D+00 , 1.3720D+00 , 
     &      1.3607D+00 , 1.3499D+00 , 1.3366D+00 , 1.3237D+00 , 
     &      1.3101D+00 , 1.2963D+00 , 1.2840D+00 , 1.2709D+00 , 
     &      1.2553D+00 , 1.2396D+00 , 1.2232D+00/
      DATA (xdvf_l(k),k=229,342)/1.2075D+00 , 1.1932D+00 , 1.1776D+00 , 
     &      1.1584D+00 , 1.1377D+00 , 1.1152D+00 , 1.0922D+00 , 
     &      1.0729D+00 , 1.0524D+00 , 1.0294D+00 , 1.0074D+00 , 
     &      9.8843D-01 , 9.7377D-01 , 9.6751D-01 , 9.6901D-01 , 
     &      9.8606D-01 , 1.0264D+00 , 1.0745D+00 , 1.1435D+00 , 
     &      1.2136D+00 , 1.3018D+00 , 1.3894D+00 , 1.4758D+00 , 
     &      1.5619D+00 , 1.6474D+00 , 1.7332D+00 , 1.8194D+00 , 
     &      1.9063D+00 , 1.9941D+00 , 2.0832D+00 , 2.1725D+00 , 
     &      2.1789D+00 , 2.3166D+00 , 2.4460D+00 , 2.5708D+00 , 
     &      2.6884D+00 , 2.7987D+00 , 2.9025D+00 , 2.9974D+00 , 
     &      3.0823D+00 , 3.1538D+00 , 3.2013D+00 , 3.2043D+00 , 
     &      0.0000D+00 , 1.6586D+00 , 1.6391D+00 , 1.6202D+00 , 
     &      1.6014D+00 , 1.5830D+00 , 1.5638D+00 , 1.5457D+00 , 
     &      1.5267D+00 , 1.5087D+00 , 1.4899D+00 , 1.4711D+00 , 
     &      1.4517D+00 , 1.4340D+00 , 1.4224D+00 , 1.4107D+00 , 
     &      1.3972D+00 , 1.3827D+00 , 1.3684D+00 , 1.3535D+00 , 
     &      1.3404D+00 , 1.3263D+00 , 1.3096D+00 , 1.2927D+00 , 
     &      1.2758D+00 , 1.2575D+00 , 1.2422D+00 , 1.2250D+00 , 
     &      1.2046D+00 , 1.1821D+00 , 1.1579D+00 , 1.1331D+00 , 
     &      1.1127D+00 , 1.0905D+00 , 1.0655D+00 , 1.0415D+00 , 
     &      1.0207D+00 , 1.0042D+00 , 9.9612D-01 , 9.9507D-01 , 
     &      1.0089D+00 , 1.0451D+00 , 1.0887D+00 , 1.1514D+00 , 
     &      1.2146D+00 , 1.2936D+00 , 1.3711D+00 , 1.4469D+00 , 
     &      1.5220D+00 , 1.5960D+00 , 1.6694D+00 , 1.7428D+00 , 
     &      1.8159D+00 , 1.8894D+00 , 1.9620D+00 , 2.0344D+00 , 
     &      2.0313D+00 , 2.1357D+00 , 2.2333D+00 , 2.3215D+00 , 
     &      2.4009D+00 , 2.4706D+00 , 2.5292D+00 , 2.5750D+00 , 
     &      2.6036D+00 , 2.6096D+00 , 2.5783D+00 , 2.4673D+00 , 
     &      0.0000D+00 , 1.7269D+00 , 1.7065D+00/
      DATA (xdvf_l(k),k=343,456)/1.6866D+00 , 1.6676D+00 , 1.6480D+00 , 
     &      1.6279D+00 , 1.6089D+00 , 1.5891D+00 , 1.5701D+00 , 
     &      1.5502D+00 , 1.5307D+00 , 1.5113D+00 , 1.4910D+00 , 
     &      1.4799D+00 , 1.4673D+00 , 1.4526D+00 , 1.4373D+00 , 
     &      1.4221D+00 , 1.4060D+00 , 1.3922D+00 , 1.3771D+00 , 
     &      1.3596D+00 , 1.3414D+00 , 1.3234D+00 , 1.3045D+00 , 
     &      1.2879D+00 , 1.2689D+00 , 1.2468D+00 , 1.2227D+00 , 
     &      1.1966D+00 , 1.1706D+00 , 1.1487D+00 , 1.1248D+00 , 
     &      1.0980D+00 , 1.0724D+00 , 1.0495D+00 , 1.0310D+00 , 
     &      1.0212D+00 , 1.0181D+00 , 1.0291D+00 , 1.0609D+00 , 
     &      1.1002D+00 , 1.1563D+00 , 1.2136D+00 , 1.2840D+00 , 
     &      1.3528D+00 , 1.4201D+00 , 1.4854D+00 , 1.5492D+00 , 
     &      1.6125D+00 , 1.6751D+00 , 1.7368D+00 , 1.7981D+00 , 
     &      1.8579D+00 , 1.9157D+00 , 1.9057D+00 , 1.9875D+00 , 
     &      2.0577D+00 , 2.1190D+00 , 2.1700D+00 , 2.2094D+00 , 
     &      2.2370D+00 , 2.2484D+00 , 2.2403D+00 , 2.2047D+00 , 
     &      2.1261D+00 , 1.9567D+00 , 0.0000D+00 , 1.8047D+00 , 
     &      1.7833D+00 , 1.7626D+00 , 1.7418D+00 , 1.7220D+00 , 
     &      1.7009D+00 , 1.6810D+00 , 1.6603D+00 , 1.6403D+00 , 
     &      1.6193D+00 , 1.5986D+00 , 1.5775D+00 , 1.5570D+00 , 
     &      1.5441D+00 , 1.5309D+00 , 1.5156D+00 , 1.4991D+00 , 
     &      1.4828D+00 , 1.4658D+00 , 1.4510D+00 , 1.4350D+00 , 
     &      1.4160D+00 , 1.3966D+00 , 1.3772D+00 , 1.3565D+00 , 
     &      1.3386D+00 , 1.3184D+00 , 1.2942D+00 , 1.2680D+00 , 
     &      1.2404D+00 , 1.2125D+00 , 1.1887D+00 , 1.1631D+00 , 
     &      1.1342D+00 , 1.1064D+00 , 1.0813D+00 , 1.0608D+00 , 
     &      1.0480D+00 , 1.0426D+00 , 1.0500D+00 , 1.0774D+00 , 
     &      1.1111D+00 , 1.1608D+00 , 1.2107D+00 , 1.2719D+00 , 
     &      1.3315D+00 , 1.3886D+00 , 1.4445D+00/
      DATA (xdvf_l(k),k=457,570)/1.4984D+00 , 1.5505D+00 , 1.6020D+00 , 
     &      1.6524D+00 , 1.7009D+00 , 1.7480D+00 , 1.7926D+00 , 
     &      1.7763D+00 , 1.8327D+00 , 1.8794D+00 , 1.9154D+00 , 
     &      1.9405D+00 , 1.9531D+00 , 1.9537D+00 , 1.9362D+00 , 
     &      1.8986D+00 , 1.8325D+00 , 1.7203D+00 , 1.5163D+00 , 
     &      0.0000D+00 , 1.8755D+00 , 1.8533D+00 , 1.8314D+00 , 
     &      1.8106D+00 , 1.7890D+00 , 1.7672D+00 , 1.7464D+00 , 
     &      1.7248D+00 , 1.7038D+00 , 1.6817D+00 , 1.6601D+00 , 
     &      1.6385D+00 , 1.6160D+00 , 1.6033D+00 , 1.5889D+00 , 
     &      1.5721D+00 , 1.5552D+00 , 1.5380D+00 , 1.5199D+00 , 
     &      1.5042D+00 , 1.4871D+00 , 1.4670D+00 , 1.4463D+00 , 
     &      1.4249D+00 , 1.4036D+00 , 1.3843D+00 , 1.3630D+00 , 
     &      1.3364D+00 , 1.3086D+00 , 1.2791D+00 , 1.2500D+00 , 
     &      1.2245D+00 , 1.1971D+00 , 1.1662D+00 , 1.1361D+00 , 
     &      1.1090D+00 , 1.0858D+00 , 1.0721D+00 , 1.0641D+00 , 
     &      1.0676D+00 , 1.0898D+00 , 1.1195D+00 , 1.1627D+00 , 
     &      1.2069D+00 , 1.2603D+00 , 1.3118D+00 , 1.3607D+00 , 
     &      1.4079D+00 , 1.4534D+00 , 1.4968D+00 , 1.5392D+00 , 
     &      1.5794D+00 , 1.6181D+00 , 1.6552D+00 , 1.6888D+00 , 
     &      1.6690D+00 , 1.7073D+00 , 1.7353D+00 , 1.7530D+00 , 
     &      1.7595D+00 , 1.7531D+00 , 1.7338D+00 , 1.6988D+00 , 
     &      1.6428D+00 , 1.5583D+00 , 1.4293D+00 , 1.2136D+00 , 
     &      0.0000D+00 , 1.9470D+00 , 1.9238D+00 , 1.9021D+00 , 
     &      1.8782D+00 , 1.8570D+00 , 1.8343D+00 , 1.8123D+00 , 
     &      1.7898D+00 , 1.7680D+00 , 1.7449D+00 , 1.7222D+00 , 
     &      1.6994D+00 , 1.6760D+00 , 1.6624D+00 , 1.6469D+00 , 
     &      1.6299D+00 , 1.6118D+00 , 1.5933D+00 , 1.5742D+00 , 
     &      1.5574D+00 , 1.5392D+00 , 1.5179D+00 , 1.4955D+00 , 
     &      1.4738D+00 , 1.4506D+00 , 1.4300D+00/
      DATA (xdvf_l(k),k=571,684)/1.4069D+00 , 1.3792D+00 , 1.3492D+00 , 
     &      1.3178D+00 , 1.2868D+00 , 1.2597D+00 , 1.2307D+00 , 
     &      1.1976D+00 , 1.1654D+00 , 1.1363D+00 , 1.1108D+00 , 
     &      1.0945D+00 , 1.0840D+00 , 1.0845D+00 , 1.1017D+00 , 
     &      1.1268D+00 , 1.1637D+00 , 1.2016D+00 , 1.2473D+00 , 
     &      1.2910D+00 , 1.3324D+00 , 1.3719D+00 , 1.4090D+00 , 
     &      1.4450D+00 , 1.4784D+00 , 1.5109D+00 , 1.5404D+00 , 
     &      1.5681D+00 , 1.5925D+00 , 1.5689D+00 , 1.5916D+00 , 
     &      1.6043D+00 , 1.6067D+00 , 1.5981D+00 , 1.5779D+00 , 
     &      1.5449D+00 , 1.4949D+00 , 1.4262D+00 , 1.3303D+00 , 
     &      1.1932D+00 , 9.7657D-01 , 0.0000D+00 , 2.0122D+00 , 
     &      1.9881D+00 , 1.9640D+00 , 1.9418D+00 , 1.9190D+00 , 
     &      1.8954D+00 , 1.8721D+00 , 1.8492D+00 , 1.8262D+00 , 
     &      1.8024D+00 , 1.7784D+00 , 1.7550D+00 , 1.7300D+00 , 
     &      1.7157D+00 , 1.6999D+00 , 1.6818D+00 , 1.6627D+00 , 
     &      1.6435D+00 , 1.6233D+00 , 1.6058D+00 , 1.5866D+00 , 
     &      1.5643D+00 , 1.5417D+00 , 1.5178D+00 , 1.4926D+00 , 
     &      1.4705D+00 , 1.4465D+00 , 1.4174D+00 , 1.3856D+00 , 
     &      1.3527D+00 , 1.3198D+00 , 1.2914D+00 , 1.2605D+00 , 
     &      1.2257D+00 , 1.1915D+00 , 1.1601D+00 , 1.1326D+00 , 
     &      1.1142D+00 , 1.1016D+00 , 1.0982D+00 , 1.1114D+00 , 
     &      1.1321D+00 , 1.1637D+00 , 1.1958D+00 , 1.2352D+00 , 
     &      1.2722D+00 , 1.3071D+00 , 1.3397D+00 , 1.3704D+00 , 
     &      1.3995D+00 , 1.4267D+00 , 1.4516D+00 , 1.4736D+00 , 
     &      1.4942D+00 , 1.5100D+00 , 1.4848D+00 , 1.4955D+00 , 
     &      1.4964D+00 , 1.4873D+00 , 1.4675D+00 , 1.4366D+00 , 
     &      1.3933D+00 , 1.3349D+00 , 1.2585D+00 , 1.1565D+00 , 
     &      1.0171D+00 , 8.0601D-01 , 0.0000D+00 , 2.0789D+00 , 
     &      2.0539D+00 , 2.0294D+00 , 2.0053D+00/
      DATA (xdvf_l(k),k=685,798)/1.9820D+00 , 1.9581D+00 , 1.9336D+00 , 
     &      1.9096D+00 , 1.8860D+00 , 1.8609D+00 , 1.8367D+00 , 
     &      1.8106D+00 , 1.7860D+00 , 1.7706D+00 , 1.7543D+00 , 
     &      1.7350D+00 , 1.7150D+00 , 1.6945D+00 , 1.6735D+00 , 
     &      1.6550D+00 , 1.6349D+00 , 1.6112D+00 , 1.5864D+00 , 
     &      1.5617D+00 , 1.5356D+00 , 1.5128D+00 , 1.4868D+00 , 
     &      1.4555D+00 , 1.4224D+00 , 1.3876D+00 , 1.3532D+00 , 
     &      1.3231D+00 , 1.2904D+00 , 1.2536D+00 , 1.2173D+00 , 
     &      1.1838D+00 , 1.1545D+00 , 1.1338D+00 , 1.1185D+00 , 
     &      1.1113D+00 , 1.1199D+00 , 1.1362D+00 , 1.1627D+00 , 
     &      1.1895D+00 , 1.2222D+00 , 1.2529D+00 , 1.2813D+00 , 
     &      1.3080D+00 , 1.3324D+00 , 1.3546D+00 , 1.3756D+00 , 
     &      1.3938D+00 , 1.4103D+00 , 1.4232D+00 , 1.4319D+00 , 
     &      1.4055D+00 , 1.4052D+00 , 1.3959D+00 , 1.3768D+00 , 
     &      1.3480D+00 , 1.3084D+00 , 1.2576D+00 , 1.1928D+00 , 
     &      1.1110D+00 , 1.0066D+00 , 8.6804D-01 , 6.6615D-01 , 
     &      0.0000D+00 , 2.1434D+00 , 2.1178D+00 , 2.0930D+00 , 
     &      2.0676D+00 , 2.0440D+00 , 2.0184D+00 , 1.9935D+00 , 
     &      1.9686D+00 , 1.9439D+00 , 1.9179D+00 , 1.8915D+00 , 
     &      1.8663D+00 , 1.8400D+00 , 1.8239D+00 , 1.8067D+00 , 
     &      1.7863D+00 , 1.7654D+00 , 1.7440D+00 , 1.7219D+00 , 
     &      1.7025D+00 , 1.6814D+00 , 1.6565D+00 , 1.6311D+00 , 
     &      1.6045D+00 , 1.5766D+00 , 1.5526D+00 , 1.5250D+00 , 
     &      1.4925D+00 , 1.4574D+00 , 1.4213D+00 , 1.3849D+00 , 
     &      1.3532D+00 , 1.3191D+00 , 1.2800D+00 , 1.2418D+00 , 
     &      1.2062D+00 , 1.1743D+00 , 1.1517D+00 , 1.1338D+00 , 
     &      1.1237D+00 , 1.1272D+00 , 1.1399D+00 , 1.1608D+00 , 
     &      1.1828D+00 , 1.2092D+00 , 1.2341D+00 , 1.2570D+00 , 
     &      1.2774D+00 , 1.2962D+00 , 1.3135D+00/
      DATA (xdvf_l(k),k=799,912)/1.3280D+00 , 1.3406D+00 , 1.3511D+00 , 
     &      1.3588D+00 , 1.3613D+00 , 1.3335D+00 , 1.3246D+00 , 
     &      1.3067D+00 , 1.2801D+00 , 1.2441D+00 , 1.1985D+00 , 
     &      1.1418D+00 , 1.0724D+00 , 9.8806D-01 , 8.8293D-01 , 
     &      7.4746D-01 , 5.5665D-01 , 0.0000D+00 , 2.2035D+00 , 
     &      2.1769D+00 , 2.1514D+00 , 2.1259D+00 , 2.1000D+00 , 
     &      2.0743D+00 , 2.0488D+00 , 2.0226D+00 , 1.9973D+00 , 
     &      1.9702D+00 , 1.9428D+00 , 1.9166D+00 , 1.8890D+00 , 
     &      1.8729D+00 , 1.8548D+00 , 1.8337D+00 , 1.8116D+00 , 
     &      1.7895D+00 , 1.7662D+00 , 1.7461D+00 , 1.7239D+00 , 
     &      1.6980D+00 , 1.6714D+00 , 1.6436D+00 , 1.6146D+00 , 
     &      1.5889D+00 , 1.5604D+00 , 1.5266D+00 , 1.4895D+00 , 
     &      1.4515D+00 , 1.4138D+00 , 1.3806D+00 , 1.3448D+00 , 
     &      1.3040D+00 , 1.2638D+00 , 1.2261D+00 , 1.1920D+00 , 
     &      1.1669D+00 , 1.1469D+00 , 1.1341D+00 , 1.1335D+00 , 
     &      1.1420D+00 , 1.1583D+00 , 1.1760D+00 , 1.1971D+00 , 
     &      1.2168D+00 , 1.2343D+00 , 1.2501D+00 , 1.2640D+00 , 
     &      1.2762D+00 , 1.2866D+00 , 1.2942D+00 , 1.2996D+00 , 
     &      1.3020D+00 , 1.3003D+00 , 1.2725D+00 , 1.2557D+00 , 
     &      1.2312D+00 , 1.1982D+00 , 1.1569D+00 , 1.1068D+00 , 
     &      1.0465D+00 , 9.7460D-01 , 8.8884D-01 , 7.8459D-01 , 
     &      6.5333D-01 , 4.7359D-01 , 0.0000D+00 , 2.2800D+00 , 
     &      2.2524D+00 , 2.2256D+00 , 2.1987D+00 , 2.1730D+00 , 
     &      2.1459D+00 , 2.1192D+00 , 2.0922D+00 , 2.0656D+00 , 
     &      2.0374D+00 , 2.0100D+00 , 1.9802D+00 , 1.9520D+00 , 
     &      1.9346D+00 , 1.9156D+00 , 1.8937D+00 , 1.8706D+00 , 
     &      1.8475D+00 , 1.8228D+00 , 1.8017D+00 , 1.7783D+00 , 
     &      1.7509D+00 , 1.7221D+00 , 1.6937D+00 , 1.6627D+00 , 
     &      1.6354D+00 , 1.6050D+00 , 1.5688D+00/
      DATA (xdvf_l(k),k=913,1026)/1.5301D+00 , 1.4898D+00 , 1.4503D+00 , 
     &      1.4150D+00 , 1.3772D+00 , 1.3339D+00 , 1.2911D+00 , 
     &      1.2510D+00 , 1.2138D+00 , 1.1866D+00 , 1.1637D+00 , 
     &      1.1458D+00 , 1.1403D+00 , 1.1441D+00 , 1.1548D+00 , 
     &      1.1669D+00 , 1.1817D+00 , 1.1950D+00 , 1.2065D+00 , 
     &      1.2163D+00 , 1.2249D+00 , 1.2313D+00 , 1.2355D+00 , 
     &      1.2379D+00 , 1.2379D+00 , 1.2348D+00 , 1.2275D+00 , 
     &      1.1987D+00 , 1.1744D+00 , 1.1427D+00 , 1.1035D+00 , 
     &      1.0570D+00 , 1.0018D+00 , 9.3862D-01 , 8.6494D-01 , 
     &      7.7913D-01 , 6.7747D-01 , 5.5266D-01 , 3.8741D-01 , 
     &      0.0000D+00 , 2.3524D+00 , 2.3243D+00 , 2.2963D+00 , 
     &      2.2689D+00 , 2.2420D+00 , 2.2137D+00 , 2.1858D+00 , 
     &      2.1579D+00 , 2.1301D+00 , 2.1011D+00 , 2.0718D+00 , 
     &      2.0424D+00 , 2.0120D+00 , 1.9937D+00 , 1.9743D+00 , 
     &      1.9509D+00 , 1.9267D+00 , 1.9020D+00 , 1.8763D+00 , 
     &      1.8541D+00 , 1.8295D+00 , 1.8006D+00 , 1.7713D+00 , 
     &      1.7402D+00 , 1.7077D+00 , 1.6794D+00 , 1.6475D+00 , 
     &      1.6087D+00 , 1.5679D+00 , 1.5259D+00 , 1.4840D+00 , 
     &      1.4470D+00 , 1.4072D+00 , 1.3615D+00 , 1.3163D+00 , 
     &      1.2738D+00 , 1.2336D+00 , 1.2045D+00 , 1.1783D+00 , 
     &      1.1563D+00 , 1.1459D+00 , 1.1457D+00 , 1.1504D+00 , 
     &      1.1577D+00 , 1.1662D+00 , 1.1742D+00 , 1.1807D+00 , 
     &      1.1857D+00 , 1.1886D+00 , 1.1902D+00 , 1.1899D+00 , 
     &      1.1878D+00 , 1.1830D+00 , 1.1751D+00 , 1.1633D+00 , 
     &      1.1345D+00 , 1.1039D+00 , 1.0667D+00 , 1.0230D+00 , 
     &      9.7228D-01 , 9.1417D-01 , 8.4905D-01 , 7.7478D-01 , 
     &      6.9004D-01 , 5.9155D-01 , 4.7371D-01 , 3.2191D-01 , 
     &      0.0000D+00 , 2.4233D+00 , 2.3947D+00 , 2.3653D+00 , 
     &      2.3365D+00 , 2.3090D+00 , 2.2800D+00/
      DATA (xdvf_l(k),k=1027,1140)/2.2512D+00 , 2.2220D+00 , 
     &      2.1934D+00 , 2.1628D+00 , 2.1319D+00 , 2.1007D+00 , 
     &      2.0700D+00 , 2.0512D+00 , 2.0301D+00 , 2.0057D+00 , 
     &      1.9809D+00 , 1.9549D+00 , 1.9281D+00 , 1.9049D+00 , 
     &      1.8791D+00 , 1.8497D+00 , 1.8175D+00 , 1.7854D+00 , 
     &      1.7507D+00 , 1.7209D+00 , 1.6878D+00 , 1.6474D+00 , 
     &      1.6047D+00 , 1.5603D+00 , 1.5164D+00 , 1.4777D+00 , 
     &      1.4358D+00 , 1.3879D+00 , 1.3403D+00 , 1.2952D+00 , 
     &      1.2523D+00 , 1.2206D+00 , 1.1913D+00 , 1.1661D+00 , 
     &      1.1505D+00 , 1.1462D+00 , 1.1460D+00 , 1.1481D+00 , 
     &      1.1518D+00 , 1.1545D+00 , 1.1559D+00 , 1.1562D+00 , 
     &      1.1548D+00 , 1.1523D+00 , 1.1478D+00 , 1.1414D+00 , 
     &      1.1331D+00 , 1.1212D+00 , 1.1055D+00 , 1.0763D+00 , 
     &      1.0405D+00 , 9.9877D-01 , 9.5130D-01 , 8.9815D-01 , 
     &      8.3813D-01 , 7.7188D-01 , 6.9792D-01 , 6.1492D-01 , 
     &      5.2020D-01 , 4.0920D-01 , 2.7020D-01 , 0.0000D+00 , 
     &      2.4906D+00 , 2.4607D+00 , 2.4307D+00 , 2.4014D+00 , 
     &      2.3730D+00 , 2.3427D+00 , 2.3127D+00 , 2.2828D+00 , 
     &      2.2528D+00 , 2.2213D+00 , 2.1903D+00 , 2.1577D+00 , 
     &      2.1250D+00 , 2.1053D+00 , 2.0839D+00 , 2.0583D+00 , 
     &      2.0318D+00 , 2.0051D+00 , 1.9771D+00 , 1.9527D+00 , 
     &      1.9259D+00 , 1.8935D+00 , 1.8607D+00 , 1.8269D+00 , 
     &      1.7917D+00 , 1.7606D+00 , 1.7253D+00 , 1.6833D+00 , 
     &      1.6387D+00 , 1.5925D+00 , 1.5465D+00 , 1.5061D+00 , 
     &      1.4624D+00 , 1.4121D+00 , 1.3623D+00 , 1.3152D+00 , 
     &      1.2700D+00 , 1.2349D+00 , 1.2036D+00 , 1.1745D+00 , 
     &      1.1544D+00 , 1.1457D+00 , 1.1410D+00 , 1.1389D+00 , 
     &      1.1378D+00 , 1.1357D+00 , 1.1332D+00 , 1.1290D+00 , 
     &      1.1244D+00 , 1.1176D+00 , 1.1099D+00 , 1.0996D+00/
      DATA (xdvf_l(k),k=1141,1254)/1.0875D+00 , 1.0729D+00 , 
     &      1.0538D+00 , 1.0249D+00 , 9.8511D-01 , 9.3994D-01 , 
     &      8.8948D-01 , 8.3410D-01 , 7.7332D-01 , 7.0681D-01 , 
     &      6.3377D-01 , 5.5280D-01 , 4.6214D-01 , 3.5755D-01 , 
     &      2.2965D-01 , 0.0000D+00 , 2.5589D+00 , 2.5291D+00 , 
     &      2.4979D+00 , 2.4676D+00 , 2.4370D+00 , 2.4060D+00 , 
     &      2.3753D+00 , 2.3443D+00 , 2.3135D+00 , 2.2809D+00 , 
     &      2.2486D+00 , 2.2146D+00 , 2.1810D+00 , 2.1602D+00 , 
     &      2.1376D+00 , 2.1114D+00 , 2.0841D+00 , 2.0557D+00 , 
     &      2.0265D+00 , 2.0011D+00 , 1.9730D+00 , 1.9392D+00 , 
     &      1.9055D+00 , 1.8697D+00 , 1.8327D+00 , 1.8003D+00 , 
     &      1.7635D+00 , 1.7197D+00 , 1.6727D+00 , 1.6246D+00 , 
     &      1.5770D+00 , 1.5346D+00 , 1.4890D+00 , 1.4363D+00 , 
     &      1.3841D+00 , 1.3341D+00 , 1.2867D+00 , 1.2492D+00 , 
     &      1.2151D+00 , 1.1824D+00 , 1.1578D+00 , 1.1451D+00 , 
     &      1.1356D+00 , 1.1298D+00 , 1.1233D+00 , 1.1169D+00 , 
     &      1.1105D+00 , 1.1027D+00 , 1.0940D+00 , 1.0840D+00 , 
     &      1.0726D+00 , 1.0592D+00 , 1.0444D+00 , 1.0265D+00 , 
     &      1.0045D+00 , 9.7613D-01 , 9.3249D-01 , 8.8451D-01 , 
     &      8.3193D-01 , 7.7510D-01 , 7.1373D-01 , 6.4749D-01 , 
     &      5.7554D-01 , 4.9725D-01 , 4.1072D-01 , 3.1254D-01 , 
     &      1.9551D-01 , 0.0000D+00 , 2.6244D+00 , 2.5927D+00 , 
     &      2.5615D+00 , 2.5299D+00 , 2.4990D+00 , 2.4671D+00 , 
     &      2.4356D+00 , 2.4034D+00 , 2.3717D+00 , 2.3377D+00 , 
     &      2.3034D+00 , 2.2689D+00 , 2.2340D+00 , 2.2126D+00 , 
     &      2.1892D+00 , 2.1616D+00 , 2.1331D+00 , 2.1040D+00 , 
     &      2.0736D+00 , 2.0471D+00 , 2.0180D+00 , 1.9830D+00 , 
     &      1.9472D+00 , 1.9112D+00 , 1.8717D+00 , 1.8375D+00 , 
     &      1.7996D+00 , 1.7538D+00 , 1.7053D+00 , 1.6548D+00/
      DATA (xdvf_l(k),k=1255,1368)/1.6053D+00 , 1.5612D+00 , 
     &      1.5138D+00 , 1.4590D+00 , 1.4045D+00 , 1.3516D+00 , 
     &      1.3023D+00 , 1.2626D+00 , 1.2251D+00 , 1.1889D+00 , 
     &      1.1601D+00 , 1.1441D+00 , 1.1302D+00 , 1.1201D+00 , 
     &      1.1098D+00 , 1.0996D+00 , 1.0888D+00 , 1.0782D+00 , 
     &      1.0659D+00 , 1.0531D+00 , 1.0388D+00 , 1.0228D+00 , 
     &      1.0047D+00 , 9.8480D-01 , 9.6040D-01 , 9.3234D-01 , 
     &      8.8589D-01 , 8.3563D-01 , 7.8162D-01 , 7.2366D-01 , 
     &      6.6215D-01 , 5.9658D-01 , 5.2617D-01 , 4.5043D-01 , 
     &      3.6787D-01 , 2.7575D-01 , 1.6826D-01 , 0.0000D+00 , 
     &      2.6886D+00 , 2.6564D+00 , 2.6234D+00 , 2.5908D+00 , 
     &      2.5600D+00 , 2.5268D+00 , 2.4943D+00 , 2.4612D+00 , 
     &      2.4283D+00 , 2.3924D+00 , 2.3582D+00 , 2.3219D+00 , 
     &      2.2860D+00 , 2.2642D+00 , 2.2394D+00 , 2.2113D+00 , 
     &      2.1817D+00 , 2.1512D+00 , 2.1198D+00 , 2.0920D+00 , 
     &      2.0618D+00 , 2.0268D+00 , 1.9890D+00 , 1.9503D+00 , 
     &      1.9098D+00 , 1.8739D+00 , 1.8343D+00 , 1.7867D+00 , 
     &      1.7365D+00 , 1.6843D+00 , 1.6329D+00 , 1.5870D+00 , 
     &      1.5377D+00 , 1.4807D+00 , 1.4239D+00 , 1.3692D+00 , 
     &      1.3169D+00 , 1.2751D+00 , 1.2350D+00 , 1.1954D+00 , 
     &      1.1624D+00 , 1.1425D+00 , 1.1247D+00 , 1.1110D+00 , 
     &      1.0963D+00 , 1.0827D+00 , 1.0687D+00 , 1.0547D+00 , 
     &      1.0396D+00 , 1.0240D+00 , 1.0070D+00 , 9.8853D-01 , 
     &      9.6834D-01 , 9.4569D-01 , 9.1962D-01 , 8.9220D-01 , 
     &      8.4321D-01 , 7.9105D-01 , 7.3592D-01 , 6.7777D-01 , 
     &      6.1620D-01 , 5.5143D-01 , 4.8272D-01 , 4.0962D-01 , 
     &      3.3102D-01 , 2.4455D-01 , 1.4574D-01 , 0.0000D+00 , 
     &      2.7496D+00 , 2.7153D+00 , 2.6835D+00 , 2.6504D+00 , 
     &      2.6180D+00 , 2.5834D+00 , 2.5502D+00 , 2.5161D+00/
      DATA (xdvf_l(k),k=1369,1482)/2.4824D+00 , 2.4466D+00 , 
     &      2.4095D+00 , 2.3736D+00 , 2.3360D+00 , 2.3124D+00 , 
     &      2.2875D+00 , 2.2580D+00 , 2.2274D+00 , 2.1960D+00 , 
     &      2.1631D+00 , 2.1347D+00 , 2.1032D+00 , 2.0670D+00 , 
     &      2.0277D+00 , 1.9882D+00 , 1.9458D+00 , 1.9086D+00 , 
     &      1.8675D+00 , 1.8179D+00 , 1.7658D+00 , 1.7122D+00 , 
     &      1.6586D+00 , 1.6112D+00 , 1.5600D+00 , 1.5010D+00 , 
     &      1.4420D+00 , 1.3855D+00 , 1.3294D+00 , 1.2858D+00 , 
     &      1.2435D+00 , 1.2006D+00 , 1.1641D+00 , 1.1410D+00 , 
     &      1.1193D+00 , 1.1023D+00 , 1.0837D+00 , 1.0664D+00 , 
     &      1.0496D+00 , 1.0329D+00 , 1.0157D+00 , 9.9745D-01 , 
     &      9.7803D-01 , 9.5735D-01 , 9.3539D-01 , 9.1075D-01 , 
     &      8.8302D-01 , 8.5608D-01 , 8.0509D-01 , 7.5168D-01 , 
     &      6.9580D-01 , 6.3743D-01 , 5.7619D-01 , 5.1233D-01 , 
     &      4.4547D-01 , 3.7496D-01 , 2.9995D-01 , 2.1862D-01 , 
     &      1.2745D-01 , 0.0000D+00 , 2.8331D+00 , 2.7978D+00 , 
     &      2.7648D+00 , 2.7299D+00 , 2.6960D+00 , 2.6609D+00 , 
     &      2.6263D+00 , 2.5910D+00 , 2.5561D+00 , 2.5197D+00 , 
     &      2.4802D+00 , 2.4424D+00 , 2.4030D+00 , 2.3791D+00 , 
     &      2.3526D+00 , 2.3216D+00 , 2.2897D+00 , 2.2570D+00 , 
     &      2.2225D+00 , 2.1925D+00 , 2.1595D+00 , 2.1199D+00 , 
     &      2.0799D+00 , 2.0383D+00 , 1.9938D+00 , 1.9551D+00 , 
     &      1.9121D+00 , 1.8601D+00 , 1.8054D+00 , 1.7494D+00 , 
     &      1.6932D+00 , 1.6435D+00 , 1.5898D+00 , 1.5280D+00 , 
     &      1.4659D+00 , 1.4056D+00 , 1.3471D+00 , 1.3010D+00 , 
     &      1.2550D+00 , 1.2078D+00 , 1.1652D+00 , 1.1383D+00 , 
     &      1.1114D+00 , 1.0902D+00 , 1.0668D+00 , 1.0451D+00 , 
     &      1.0248D+00 , 1.0039D+00 , 9.8353D-01 , 9.6205D-01 , 
     &      9.4076D-01 , 9.1705D-01 , 8.9229D-01 , 8.6577D-01/
      DATA (xdvf_l(k),k=1483,1596)/8.3604D-01 , 8.0985D-01 , 
     &      7.5687D-01 , 7.0190D-01 , 6.4516D-01 , 5.8700D-01 , 
     &      5.2660D-01 , 4.6452D-01 , 3.9995D-01 , 3.3310D-01 , 
     &      2.6289D-01 , 1.8826D-01 , 1.0655D-01 , 0.0000D+00 , 
     &      2.9096D+00 , 2.8732D+00 , 2.8390D+00 , 2.8027D+00 , 
     &      2.7690D+00 , 2.7325D+00 , 2.6961D+00 , 2.6597D+00 , 
     &      2.6231D+00 , 2.5833D+00 , 2.5456D+00 , 2.5047D+00 , 
     &      2.4650D+00 , 2.4391D+00 , 2.4120D+00 , 2.3799D+00 , 
     &      2.3462D+00 , 2.3123D+00 , 2.2763D+00 , 2.2451D+00 , 
     &      2.2108D+00 , 2.1692D+00 , 2.1276D+00 , 2.0835D+00 , 
     &      2.0378D+00 , 1.9974D+00 , 1.9525D+00 , 1.8983D+00 , 
     &      1.8413D+00 , 1.7827D+00 , 1.7243D+00 , 1.6725D+00 , 
     &      1.6166D+00 , 1.5520D+00 , 1.4872D+00 , 1.4244D+00 , 
     &      1.3627D+00 , 1.3136D+00 , 1.2649D+00 , 1.2130D+00 , 
     &      1.1663D+00 , 1.1352D+00 , 1.1040D+00 , 1.0787D+00 , 
     &      1.0514D+00 , 1.0264D+00 , 1.0021D+00 , 9.7883D-01 , 
     &      9.5548D-01 , 9.3171D-01 , 9.0763D-01 , 8.8283D-01 , 
     &      8.5596D-01 , 8.2732D-01 , 7.9601D-01 , 7.7056D-01 , 
     &      7.1598D-01 , 6.6027D-01 , 6.0340D-01 , 5.4514D-01 , 
     &      4.8601D-01 , 4.2556D-01 , 3.6359D-01 , 2.9984D-01 , 
     &      2.3396D-01 , 1.6486D-01 , 9.0844D-02 , 0.0000D+00 , 
     &      2.9880D+00 , 2.9510D+00 , 2.9150D+00 , 2.8782D+00 , 
     &      2.8430D+00 , 2.8048D+00 , 2.7677D+00 , 2.7301D+00 , 
     &      2.6924D+00 , 2.6517D+00 , 2.6110D+00 , 2.5696D+00 , 
     &      2.5280D+00 , 2.5017D+00 , 2.4728D+00 , 2.4393D+00 , 
     &      2.4042D+00 , 2.3687D+00 , 2.3313D+00 , 2.2988D+00 , 
     &      2.2631D+00 , 2.2204D+00 , 2.1768D+00 , 2.1312D+00 , 
     &      2.0828D+00 , 2.0405D+00 , 1.9928D+00 , 1.9364D+00 , 
     &      1.8772D+00 , 1.8164D+00 , 1.7558D+00 , 1.7018D+00/
      DATA (xdvf_l(k),k=1597,1710)/1.6434D+00 , 1.5762D+00 , 
     &      1.5084D+00 , 1.4432D+00 , 1.3783D+00 , 1.3261D+00 , 
     &      1.2741D+00 , 1.2182D+00 , 1.1669D+00 , 1.1315D+00 , 
     &      1.0961D+00 , 1.0671D+00 , 1.0360D+00 , 1.0071D+00 , 
     &      9.7992D-01 , 9.5371D-01 , 9.2801D-01 , 9.0200D-01 , 
     &      8.7588D-01 , 8.4862D-01 , 8.2038D-01 , 7.9020D-01 , 
     &      7.5770D-01 , 7.3298D-01 , 6.7721D-01 , 6.2090D-01 , 
     &      5.6394D-01 , 5.0631D-01 , 4.4841D-01 , 3.8970D-01 , 
     &      3.3019D-01 , 2.6973D-01 , 2.0791D-01 , 1.4420D-01 , 
     &      7.7416D-02 , 0.0000D+00 , 3.0661D+00 , 3.0288D+00 , 
     &      2.9911D+00 , 2.9537D+00 , 2.9160D+00 , 2.8778D+00 , 
     &      2.8392D+00 , 2.8000D+00 , 2.7610D+00 , 2.7200D+00 , 
     &      2.6782D+00 , 2.6345D+00 , 2.5900D+00 , 2.5625D+00 , 
     &      2.5329D+00 , 2.4982D+00 , 2.4617D+00 , 2.4247D+00 , 
     &      2.3857D+00 , 2.3518D+00 , 2.3145D+00 , 2.2697D+00 , 
     &      2.2245D+00 , 2.1764D+00 , 2.1269D+00 , 2.0819D+00 , 
     &      2.0331D+00 , 1.9746D+00 , 1.9126D+00 , 1.8497D+00 , 
     &      1.7862D+00 , 1.7303D+00 , 1.6696D+00 , 1.5995D+00 , 
     &      1.5285D+00 , 1.4608D+00 , 1.3929D+00 , 1.3377D+00 , 
     &      1.2826D+00 , 1.2228D+00 , 1.1669D+00 , 1.1279D+00 , 
     &      1.0882D+00 , 1.0555D+00 , 1.0205D+00 , 9.8876D-01 , 
     &      9.5876D-01 , 9.2969D-01 , 9.0171D-01 , 8.7356D-01 , 
     &      8.4551D-01 , 8.1668D-01 , 7.8701D-01 , 7.5564D-01 , 
     &      7.2196D-01 , 6.9797D-01 , 6.4121D-01 , 5.8469D-01 , 
     &      5.2810D-01 , 4.7131D-01 , 4.1460D-01 , 3.5783D-01 , 
     &      3.0063D-01 , 2.4338D-01 , 1.8544D-01 , 1.2660D-01 , 
     &      6.6270D-02 , 0.0000D+00 , 3.1379D+00 , 3.0995D+00 , 
     &      3.0600D+00 , 3.0213D+00 , 2.9840D+00 , 2.9442D+00 , 
     &      2.9047D+00 , 2.8641D+00 , 2.8239D+00 , 2.7813D+00/
      DATA (xdvf_l(k),k=1711,1824)/2.7383D+00 , 2.6928D+00 , 
     &      2.6470D+00 , 2.6191D+00 , 2.5880D+00 , 2.5519D+00 , 
     &      2.5145D+00 , 2.4761D+00 , 2.4357D+00 , 2.4004D+00 , 
     &      2.3615D+00 , 2.3153D+00 , 2.2678D+00 , 2.2180D+00 , 
     &      2.1669D+00 , 2.1208D+00 , 2.0699D+00 , 2.0087D+00 , 
     &      1.9447D+00 , 1.8795D+00 , 1.8139D+00 , 1.7558D+00 , 
     &      1.6930D+00 , 1.6205D+00 , 1.5467D+00 , 1.4759D+00 , 
     &      1.4054D+00 , 1.3484D+00 , 1.2895D+00 , 1.2267D+00 , 
     &      1.1663D+00 , 1.1242D+00 , 1.0808D+00 , 1.0449D+00 , 
     &      1.0065D+00 , 9.7194D-01 , 9.3967D-01 , 9.0840D-01 , 
     &      8.7834D-01 , 8.4891D-01 , 8.1928D-01 , 7.8930D-01 , 
     &      7.5803D-01 , 7.2562D-01 , 6.9124D-01 , 6.6796D-01 , 
     &      6.1058D-01 , 5.5392D-01 , 4.9752D-01 , 4.4176D-01 , 
     &      3.8633D-01 , 3.3127D-01 , 2.7648D-01 , 2.2186D-01 , 
     &      1.6735D-01 , 1.1268D-01 , 5.7652D-02 , 0.0000D+00 , 
     &      3.2129D+00 , 3.1726D+00 , 3.1325D+00 , 3.0928D+00 , 
     &      3.0540D+00 , 3.0127D+00 , 2.9717D+00 , 2.9303D+00 , 
     &      2.8887D+00 , 2.8449D+00 , 2.8001D+00 , 2.7537D+00 , 
     &      2.7060D+00 , 2.6766D+00 , 2.6453D+00 , 2.6073D+00 , 
     &      2.5683D+00 , 2.5286D+00 , 2.4866D+00 , 2.4501D+00 , 
     &      2.4107D+00 , 2.3628D+00 , 2.3125D+00 , 2.2620D+00 , 
     &      2.2079D+00 , 2.1597D+00 , 2.1067D+00 , 2.0440D+00 , 
     &      1.9778D+00 , 1.9097D+00 , 1.8421D+00 , 1.7819D+00 , 
     &      1.7169D+00 , 1.6416D+00 , 1.5664D+00 , 1.4922D+00 , 
     &      1.4189D+00 , 1.3583D+00 , 1.2971D+00 , 1.2300D+00 , 
     &      1.1652D+00 , 1.1200D+00 , 1.0729D+00 , 1.0343D+00 , 
     &      9.9254D-01 , 9.5513D-01 , 9.2006D-01 , 8.8711D-01 , 
     &      8.5555D-01 , 8.2426D-01 , 7.9305D-01 , 7.6193D-01 , 
     &      7.2963D-01 , 6.9636D-01 , 6.6128D-01 , 6.3868D-01/
      DATA (xdvf_l(k),k=1825,1836)/5.8093D-01 , 5.2428D-01 , 
     &      4.6858D-01 , 4.1372D-01 , 3.5972D-01 , 3.0648D-01 , 
     &      2.5392D-01 , 2.0208D-01 , 1.5083D-01 , 1.0018D-01 , 
     &      5.0068D-02 , 0.0000D+00/
      DATA (xdef_l(k),k=1,114)/4.3007D-01 , 4.2474D-01 , 4.1967D-01 , 
     &      4.1458D-01 , 4.0970D-01 , 4.0443D-01 , 3.9925D-01 , 
     &      3.9397D-01 , 3.8864D-01 , 3.8302D-01 , 3.7707D-01 , 
     &      3.7100D-01 , 3.6470D-01 , 3.6080D-01 , 3.5639D-01 , 
     &      3.5109D-01 , 3.4531D-01 , 3.3914D-01 , 3.3238D-01 , 
     &      3.2609D-01 , 3.1913D-01 , 3.1062D-01 , 3.0152D-01 , 
     &      2.9176D-01 , 2.8100D-01 , 2.7114D-01 , 2.5952D-01 , 
     &      2.4467D-01 , 2.2784D-01 , 2.0937D-01 , 1.9117D-01 , 
     &      1.7470D-01 , 1.5685D-01 , 1.3678D-01 , 1.1825D-01 , 
     &      1.0349D-01 , 9.4854D-02 , 9.5054D-02 , 1.0589D-01 , 
     &      1.3527D-01 , 1.8584D-01 , 2.3426D-01 , 2.9021D-01 , 
     &      3.3527D-01 , 3.7670D-01 , 4.0255D-01 , 4.1326D-01 , 
     &      4.0880D-01 , 3.8831D-01 , 3.5045D-01 , 2.9287D-01 , 
     &      2.1298D-01 , 1.0773D-01 , 0.0000D+00 , 0.0000D+00 , 
     &      2.0644D-01 , 1.5422D-01 , 1.0950D-01 , 7.3614D-02 , 
     &      4.6726D-02 , 2.7433D-02 , 1.4144D-02 , 6.5080D-03 , 
     &      2.4719D-03 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 4.4398D-01 , 4.3864D-01 , 4.3346D-01 , 
     &      4.2809D-01 , 4.2290D-01 , 4.1747D-01 , 4.1205D-01 , 
     &      4.0650D-01 , 4.0098D-01 , 3.9480D-01 , 3.8873D-01 , 
     &      3.8226D-01 , 3.7560D-01 , 3.7145D-01 , 3.6678D-01 , 
     &      3.6108D-01 , 3.5488D-01 , 3.4833D-01 , 3.4123D-01 , 
     &      3.3464D-01 , 3.2718D-01 , 3.1811D-01 , 3.0838D-01 , 
     &      2.9811D-01 , 2.8670D-01 , 2.7630D-01 , 2.6412D-01 , 
     &      2.4861D-01 , 2.3110D-01 , 2.1209D-01 , 1.9355D-01 , 
     &      1.7681D-01 , 1.5878D-01 , 1.3870D-01 , 1.2044D-01 , 
     &      1.0620D-01 , 9.8341D-02 , 9.9345D-02 , 1.1086D-01 , 
     &      1.4055D-01 , 1.9033D-01 , 2.3696D-01 , 2.8983D-01 , 
     &      3.3137D-01 , 3.6834D-01 , 3.8982D-01/
      DATA (xdef_l(k),k=115,228)/3.9672D-01 , 3.8896D-01 , 3.6609D-01 , 
     &      3.2678D-01 , 2.6933D-01 , 1.9181D-01 , 9.1683D-02 , 
     &      0.0000D+00 , 0.0000D+00 , 1.8955D-01 , 1.4041D-01 , 
     &      9.8873D-02 , 6.5928D-02 , 4.1462D-02 , 2.3905D-02 , 
     &      1.2324D-02 , 5.6113D-03 , 2.1050D-03 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 4.5980D-01 , 
     &      4.5420D-01 , 4.4884D-01 , 4.4319D-01 , 4.3780D-01 , 
     &      4.3208D-01 , 4.2642D-01 , 4.2053D-01 , 4.1457D-01 , 
     &      4.0824D-01 , 4.0181D-01 , 3.9484D-01 , 3.8780D-01 , 
     &      3.8328D-01 , 3.7831D-01 , 3.7223D-01 , 3.6559D-01 , 
     &      3.5853D-01 , 3.5072D-01 , 3.4400D-01 , 3.3590D-01 , 
     &      3.2633D-01 , 3.1598D-01 , 3.0508D-01 , 2.9301D-01 , 
     &      2.8197D-01 , 2.6915D-01 , 2.5289D-01 , 2.3470D-01 , 
     &      2.1511D-01 , 1.9623D-01 , 1.7918D-01 , 1.6098D-01 , 
     &      1.4092D-01 , 1.2294D-01 , 1.0928D-01 , 1.0224D-01 , 
     &      1.0401D-01 , 1.1623D-01 , 1.4620D-01 , 1.9488D-01 , 
     &      2.3948D-01 , 2.8894D-01 , 3.2681D-01 , 3.5905D-01 , 
     &      3.7613D-01 , 3.7908D-01 , 3.6817D-01 , 3.4299D-01 , 
     &      3.0266D-01 , 2.4596D-01 , 1.7115D-01 , 7.6792D-02 , 
     &      0.0000D+00 , 0.0000D+00 , 1.7267D-01 , 1.2670D-01 , 
     &      8.8446D-02 , 5.8458D-02 , 3.6380D-02 , 2.0551D-02 , 
     &      1.0608D-02 , 4.7732D-03 , 1.7670D-03 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 4.7845D-01 , 
     &      4.7258D-01 , 4.6687D-01 , 4.6107D-01 , 4.5540D-01 , 
     &      4.4938D-01 , 4.4336D-01 , 4.3728D-01 , 4.3070D-01 , 
     &      4.2403D-01 , 4.1702D-01 , 4.0968D-01 , 4.0210D-01 , 
     &      3.9723D-01 , 3.9181D-01 , 3.8522D-01 , 3.7808D-01 , 
     &      3.7047D-01 , 3.6211D-01 , 3.5469D-01 , 3.4619D-01 , 
     &      3.3582D-01 , 3.2478D-01 , 3.1314D-01/
      DATA (xdef_l(k),k=229,342)/3.0021D-01 , 2.8848D-01 , 2.7488D-01 , 
     &      2.5781D-01 , 2.3886D-01 , 2.1865D-01 , 1.9932D-01 , 
     &      1.8196D-01 , 1.6359D-01 , 1.4359D-01 , 1.2596D-01 , 
     &      1.1295D-01 , 1.0678D-01 , 1.0933D-01 , 1.2234D-01 , 
     &      1.5242D-01 , 1.9969D-01 , 2.4187D-01 , 2.8742D-01 , 
     &      3.2112D-01 , 3.4825D-01 , 3.6067D-01 , 3.5959D-01 , 
     &      3.4546D-01 , 3.1813D-01 , 2.7719D-01 , 2.2151D-01 , 
     &      1.5037D-01 , 6.2862D-02 , 0.0000D+00 , 0.0000D+00 , 
     &      1.5516D-01 , 1.1270D-01 , 7.7856D-02 , 5.0916D-02 , 
     &      3.1337D-02 , 1.7279D-02 , 8.9355D-03 , 3.9672D-03 , 
     &      1.4465D-03 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 5.0059D-01 , 4.9450D-01 , 4.8826D-01 , 
     &      4.8213D-01 , 4.7610D-01 , 4.6972D-01 , 4.6326D-01 , 
     &      4.5655D-01 , 4.4999D-01 , 4.4265D-01 , 4.3505D-01 , 
     &      4.2703D-01 , 4.1870D-01 , 4.1345D-01 , 4.0758D-01 , 
     &      4.0034D-01 , 3.9260D-01 , 3.8434D-01 , 3.7539D-01 , 
     &      3.6725D-01 , 3.5804D-01 , 3.4696D-01 , 3.3492D-01 , 
     &      3.2231D-01 , 3.0852D-01 , 2.9601D-01 , 2.8154D-01 , 
     &      2.6348D-01 , 2.4363D-01 , 2.2272D-01 , 2.0295D-01 , 
     &      1.8526D-01 , 1.6669D-01 , 1.4678D-01 , 1.2956D-01 , 
     &      1.1726D-01 , 1.1212D-01 , 1.1548D-01 , 1.2910D-01 , 
     &      1.5906D-01 , 2.0458D-01 , 2.4395D-01 , 2.8508D-01 , 
     &      3.1418D-01 , 3.3593D-01 , 3.4343D-01 , 3.3827D-01 , 
     &      3.2104D-01 , 2.9189D-01 , 2.5067D-01 , 1.9688D-01 , 
     &      1.3016D-01 , 5.0498D-02 , 0.0000D+00 , 0.0000D+00 , 
     &      1.3742D-01 , 9.8602D-02 , 6.7357D-02 , 4.3555D-02 , 
     &      2.6444D-02 , 1.4175D-02 , 7.3561D-03 , 3.2181D-03 , 
     &      1.1530D-03 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 5.2114D-01 , 5.1454D-01/
      DATA (xdef_l(k),k=343,456)/5.0806D-01 , 5.0160D-01 , 4.9520D-01 , 
     &      4.8843D-01 , 4.8165D-01 , 4.7456D-01 , 4.6738D-01 , 
     &      4.5962D-01 , 4.5149D-01 , 4.4293D-01 , 4.3400D-01 , 
     &      4.2833D-01 , 4.2194D-01 , 4.1420D-01 , 4.0580D-01 , 
     &      3.9678D-01 , 3.8741D-01 , 3.7848D-01 , 3.6878D-01 , 
     &      3.5682D-01 , 3.4416D-01 , 3.3062D-01 , 3.1602D-01 , 
     &      3.0269D-01 , 2.8749D-01 , 2.6857D-01 , 2.4798D-01 , 
     &      2.2641D-01 , 2.0626D-01 , 1.8828D-01 , 1.6960D-01 , 
     &      1.4976D-01 , 1.3293D-01 , 1.2126D-01 , 1.1684D-01 , 
     &      1.2099D-01 , 1.3505D-01 , 1.6471D-01 , 2.0841D-01 , 
     &      2.4521D-01 , 2.8248D-01 , 3.0770D-01 , 3.2484D-01 , 
     &      3.2845D-01 , 3.1999D-01 , 3.0047D-01 , 2.7030D-01 , 
     &      2.2924D-01 , 1.7739D-01 , 1.1482D-01 , 4.2174D-02 , 
     &      0.0000D+00 , 0.0000D+00 , 1.2330D-01 , 8.7586D-02 , 
     &      5.9211D-02 , 3.7890D-02 , 2.2733D-02 , 1.1877D-02 , 
     &      6.1865D-03 , 2.6713D-03 , 9.4247D-04 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 5.4423D-01 , 
     &      5.3740D-01 , 5.3068D-01 , 5.2385D-01 , 5.1700D-01 , 
     &      5.0982D-01 , 5.0256D-01 , 4.9509D-01 , 4.8731D-01 , 
     &      4.7895D-01 , 4.7023D-01 , 4.6094D-01 , 4.5130D-01 , 
     &      4.4506D-01 , 4.3820D-01 , 4.2973D-01 , 4.2069D-01 , 
     &      4.1108D-01 , 4.0069D-01 , 3.9131D-01 , 3.8063D-01 , 
     &      3.6796D-01 , 3.5430D-01 , 3.3991D-01 , 3.2433D-01 , 
     &      3.1014D-01 , 2.9407D-01 , 2.7418D-01 , 2.5281D-01 , 
     &      2.3056D-01 , 2.0999D-01 , 1.9171D-01 , 1.7291D-01 , 
     &      1.5321D-01 , 1.3677D-01 , 1.2578D-01 , 1.2220D-01 , 
     &      1.2696D-01 , 1.4132D-01 , 1.7056D-01 , 2.1212D-01 , 
     &      2.4603D-01 , 2.7912D-01 , 3.0023D-01 , 3.1274D-01 , 
     &      3.1234D-01 , 3.0087D-01 , 2.7925D-01/
      DATA (xdef_l(k),k=457,570)/2.4820D-01 , 2.0782D-01 , 1.5841D-01 , 
     &      1.0056D-01 , 3.5470D-02 , 0.0000D+00 , 0.0000D+00 , 
     &      1.0941D-01 , 7.6864D-02 , 5.1391D-02 , 3.2506D-02 , 
     &      1.9250D-02 , 9.7741D-03 , 5.1192D-03 , 2.1775D-03 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 5.6542D-01 , 5.5814D-01 , 5.5101D-01 , 
     &      5.4385D-01 , 5.3670D-01 , 5.2913D-01 , 5.2140D-01 , 
     &      5.1352D-01 , 5.0533D-01 , 4.9639D-01 , 4.8702D-01 , 
     &      4.7710D-01 , 4.6670D-01 , 4.6011D-01 , 4.5270D-01 , 
     &      4.4365D-01 , 4.3394D-01 , 4.2383D-01 , 4.1271D-01 , 
     &      4.0253D-01 , 3.9137D-01 , 3.7783D-01 , 3.6325D-01 , 
     &      3.4810D-01 , 3.3163D-01 , 3.1674D-01 , 2.9988D-01 , 
     &      2.7922D-01 , 2.5706D-01 , 2.3429D-01 , 2.1333D-01 , 
     &      1.9484D-01 , 1.7592D-01 , 1.5634D-01 , 1.4028D-01 , 
     &      1.2985D-01 , 1.2692D-01 , 1.3218D-01 , 1.4678D-01 , 
     &      1.7535D-01 , 2.1492D-01 , 2.4628D-01 , 2.7582D-01 , 
     &      2.9349D-01 , 3.0215D-01 , 2.9865D-01 , 2.8479D-01 , 
     &      2.6176D-01 , 2.3025D-01 , 1.9073D-01 , 1.4372D-01 , 
     &      9.0030D-02 , 3.1431D-02 , 0.0000D+00 , 0.0000D+00 , 
     &      9.8561D-02 , 6.8571D-02 , 4.5400D-02 , 2.8439D-02 , 
     &      1.6650D-02 , 8.2414D-03 , 4.3377D-03 , 1.8226D-03 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 5.8660D-01 , 5.7912D-01 , 5.7170D-01 , 
     &      5.6412D-01 , 5.5660D-01 , 5.4858D-01 , 5.4040D-01 , 
     &      5.3194D-01 , 5.2336D-01 , 5.1383D-01 , 5.0381D-01 , 
     &      4.9326D-01 , 4.8220D-01 , 4.7515D-01 , 4.6719D-01 , 
     &      4.5756D-01 , 4.4719D-01 , 4.3619D-01 , 4.2441D-01 , 
     &      4.1376D-01 , 4.0188D-01 , 3.8750D-01 , 3.7220D-01 , 
     &      3.5617D-01 , 3.3884D-01 , 3.2317D-01/
      DATA (xdef_l(k),k=571,684)/3.0561D-01 , 2.8413D-01 , 2.6132D-01 , 
     &      2.3801D-01 , 2.1667D-01 , 1.9794D-01 , 1.7898D-01 , 
     &      1.5951D-01 , 1.4381D-01 , 1.3395D-01 , 1.3154D-01 , 
     &      1.3722D-01 , 1.5183D-01 , 1.7978D-01 , 2.1726D-01 , 
     &      2.4615D-01 , 2.7227D-01 , 2.8668D-01 , 2.9185D-01 , 
     &      2.8560D-01 , 2.6981D-01 , 2.4566D-01 , 2.1405D-01 , 
     &      1.7560D-01 , 1.3093D-01 , 8.1317D-02 , 2.8821D-02 , 
     &      0.0000D+00 , 0.0000D+00 , 8.9016D-02 , 6.1335D-02 , 
     &      4.0241D-02 , 2.4960D-02 , 1.4451D-02 , 6.9787D-03 , 
     &      3.6912D-03 , 1.5320D-03 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 6.0621D-01 , 
     &      5.9821D-01 , 5.9043D-01 , 5.8253D-01 , 5.7470D-01 , 
     &      5.6625D-01 , 5.5768D-01 , 5.4870D-01 , 5.3948D-01 , 
     &      5.2962D-01 , 5.1919D-01 , 5.0796D-01 , 4.9620D-01 , 
     &      4.8867D-01 , 4.8027D-01 , 4.7003D-01 , 4.5907D-01 , 
     &      4.4740D-01 , 4.3484D-01 , 4.2392D-01 , 4.1127D-01 , 
     &      3.9627D-01 , 3.8010D-01 , 3.6326D-01 , 3.4524D-01 , 
     &      3.2900D-01 , 3.1064D-01 , 2.8853D-01 , 2.6510D-01 , 
     &      2.4135D-01 , 2.1970D-01 , 2.0080D-01 , 1.8175D-01 , 
     &      1.6242D-01 , 1.4701D-01 , 1.3753D-01 , 1.3572D-01 , 
     &      1.4160D-01 , 1.5623D-01 , 1.8343D-01 , 2.1902D-01 , 
     &      2.4571D-01 , 2.6885D-01 , 2.8059D-01 , 2.8292D-01 , 
     &      2.7441D-01 , 2.5704D-01 , 2.3223D-01 , 2.0062D-01 , 
     &      1.6317D-01 , 1.2079D-01 , 7.4733D-02 , 2.7461D-02 , 
     &      0.0000D+00 , 0.0000D+00 , 8.1334D-02 , 5.5577D-02 , 
     &      3.6150D-02 , 2.2243D-02 , 1.2749D-02 , 6.0264D-03 , 
     &      3.2009D-03 , 1.3143D-03 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 6.2581D-01 , 
     &      6.1778D-01 , 6.0953D-01 , 6.0134D-01/
      DATA (xdef_l(k),k=685,798)/5.9310D-01 , 5.8428D-01 , 5.7523D-01 , 
     &      5.6587D-01 , 5.5625D-01 , 5.4565D-01 , 5.3457D-01 , 
     &      5.2280D-01 , 5.1030D-01 , 5.0236D-01 , 4.9350D-01 , 
     &      4.8267D-01 , 4.7104D-01 , 4.5899D-01 , 4.4560D-01 , 
     &      4.3381D-01 , 4.2066D-01 , 4.0485D-01 , 3.8801D-01 , 
     &      3.7047D-01 , 3.5165D-01 , 3.3476D-01 , 3.1574D-01 , 
     &      2.9293D-01 , 2.6889D-01 , 2.4469D-01 , 2.2279D-01 , 
     &      2.0369D-01 , 1.8458D-01 , 1.6537D-01 , 1.5025D-01 , 
     &      1.4125D-01 , 1.3980D-01 , 1.4589D-01 , 1.6046D-01 , 
     &      1.8686D-01 , 2.2052D-01 , 2.4502D-01 , 2.6530D-01 , 
     &      2.7444D-01 , 2.7406D-01 , 2.6361D-01 , 2.4491D-01 , 
     &      2.1954D-01 , 1.8819D-01 , 1.5193D-01 , 1.1170D-01 , 
     &      6.9146D-02 , 2.6829D-02 , 0.0000D+00 , 0.0000D+00 , 
     &      7.4387D-02 , 5.0398D-02 , 3.2529D-02 , 1.9840D-02 , 
     &      1.1260D-02 , 5.2109D-03 , 2.7796D-03 , 1.1291D-03 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 6.4510D-01 , 6.3663D-01 , 6.2809D-01 , 
     &      6.1948D-01 , 6.1090D-01 , 6.0165D-01 , 5.9256D-01 , 
     &      5.8263D-01 , 5.7237D-01 , 5.6121D-01 , 5.4960D-01 , 
     &      5.3710D-01 , 5.2390D-01 , 5.1555D-01 , 5.0615D-01 , 
     &      4.9474D-01 , 4.8273D-01 , 4.6980D-01 , 4.5603D-01 , 
     &      4.4343D-01 , 4.2983D-01 , 4.1325D-01 , 3.9561D-01 , 
     &      3.7731D-01 , 3.5765D-01 , 3.4017D-01 , 3.2063D-01 , 
     &      2.9709D-01 , 2.7258D-01 , 2.4795D-01 , 2.2572D-01 , 
     &      2.0647D-01 , 1.8735D-01 , 1.6824D-01 , 1.5339D-01 , 
     &      1.4470D-01 , 1.4366D-01 , 1.4990D-01 , 1.6437D-01 , 
     &      1.8986D-01 , 2.2169D-01 , 2.4408D-01 , 2.6175D-01 , 
     &      2.6863D-01 , 2.6585D-01 , 2.5363D-01 , 2.3397D-01 , 
     &      2.0813D-01 , 1.7714D-01 , 1.4205D-01/
      DATA (xdef_l(k),k=799,912)/1.0396D-01 , 6.4602D-02 , 2.6785D-02 , 
     &      0.0000D+00 , 0.0000D+00 , 6.8343D-02 , 4.5962D-02 , 
     &      2.9434D-02 , 1.7812D-02 , 1.0015D-02 , 4.5458D-03 , 
     &      2.4331D-03 , 9.7866D-04 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 6.6281D-01 , 
     &      6.5407D-01 , 6.4523D-01 , 6.3631D-01 , 6.2740D-01 , 
     &      6.1775D-01 , 6.0821D-01 , 5.9770D-01 , 5.8724D-01 , 
     &      5.7535D-01 , 5.6321D-01 , 5.5021D-01 , 5.3640D-01 , 
     &      5.2763D-01 , 5.1775D-01 , 5.0583D-01 , 4.9310D-01 , 
     &      4.7946D-01 , 4.6520D-01 , 4.5225D-01 , 4.3811D-01 , 
     &      4.2074D-01 , 4.0247D-01 , 3.8355D-01 , 3.6315D-01 , 
     &      3.4516D-01 , 3.2502D-01 , 3.0091D-01 , 2.7589D-01 , 
     &      2.5090D-01 , 2.2842D-01 , 2.0903D-01 , 1.8987D-01 , 
     &      1.7087D-01 , 1.5631D-01 , 1.4790D-01 , 1.4709D-01 , 
     &      1.5345D-01 , 1.6771D-01 , 1.9243D-01 , 2.2253D-01 , 
     &      2.4307D-01 , 2.5846D-01 , 2.6327D-01 , 2.5857D-01 , 
     &      2.4493D-01 , 2.2441D-01 , 1.9832D-01 , 1.6773D-01 , 
     &      1.3380D-01 , 9.7606D-02 , 6.1077D-02 , 2.7123D-02 , 
     &      4.1687D-04 , 0.0000D+00 , 6.3316D-02 , 4.2290D-02 , 
     &      2.6899D-02 , 1.6166D-02 , 9.0143D-03 , 4.0214D-03 , 
     &      2.1587D-03 , 8.6042D-04 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 6.8558D-01 , 
     &      6.7623D-01 , 6.6716D-01 , 6.5776D-01 , 6.4840D-01 , 
     &      6.3825D-01 , 6.2778D-01 , 6.1697D-01 , 6.0589D-01 , 
     &      5.9350D-01 , 5.8071D-01 , 5.6677D-01 , 5.5220D-01 , 
     &      5.4293D-01 , 5.3246D-01 , 5.1980D-01 , 5.0630D-01 , 
     &      4.9221D-01 , 4.7690D-01 , 4.6348D-01 , 4.4839D-01 , 
     &      4.3024D-01 , 4.1112D-01 , 3.9125D-01 , 3.7016D-01 , 
     &      3.5134D-01 , 3.3054D-01 , 3.0571D-01/
      DATA (xdef_l(k),k=913,1026)/2.8005D-01 , 2.5463D-01 , 2.3186D-01 , 
     &      2.1230D-01 , 1.9311D-01 , 1.7422D-01 , 1.5985D-01 , 
     &      1.5187D-01 , 1.5138D-01 , 1.5783D-01 , 1.7178D-01 , 
     &      1.9543D-01 , 2.2331D-01 , 2.4162D-01 , 2.5415D-01 , 
     &      2.5666D-01 , 2.4964D-01 , 2.3438D-01 , 2.1293D-01 , 
     &      1.8681D-01 , 1.5680D-01 , 1.2430D-01 , 9.0488D-02 , 
     &      5.7352D-02 , 2.7942D-02 , 7.0995D-03 , 2.4780D-03 , 
     &      5.7612D-02 , 3.8138D-02 , 2.4057D-02 , 1.4329D-02 , 
     &      7.9111D-03 , 3.4566D-03 , 1.8603D-03 , 7.3347D-04 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 7.0709D-01 , 6.9744D-01 , 6.8784D-01 , 
     &      6.7803D-01 , 6.6830D-01 , 6.5763D-01 , 6.4678D-01 , 
     &      6.3540D-01 , 6.2360D-01 , 6.1071D-01 , 5.9715D-01 , 
     &      5.8240D-01 , 5.6710D-01 , 5.5722D-01 , 5.4625D-01 , 
     &      5.3291D-01 , 5.1856D-01 , 5.0380D-01 , 4.8797D-01 , 
     &      4.7363D-01 , 4.5801D-01 , 4.3900D-01 , 4.1917D-01 , 
     &      3.9846D-01 , 3.7656D-01 , 3.5717D-01 , 3.3564D-01 , 
     &      3.1017D-01 , 2.8397D-01 , 2.5816D-01 , 2.3508D-01 , 
     &      2.1538D-01 , 1.9615D-01 , 1.7737D-01 , 1.6324D-01 , 
     &      1.5559D-01 , 1.5535D-01 , 1.6175D-01 , 1.7537D-01 , 
     &      1.9793D-01 , 2.2384D-01 , 2.4005D-01 , 2.5009D-01 , 
     &      2.5051D-01 , 2.4150D-01 , 2.2495D-01 , 2.0291D-01 , 
     &      1.7668D-01 , 1.4739D-01 , 1.1625D-01 , 8.4583D-02 , 
     &      5.4470D-02 , 2.9013D-02 , 1.3147D-02 , 1.4553D-02 , 
     &      5.2777D-02 , 3.4672D-02 , 2.1686D-02 , 1.2821D-02 , 
     &      7.0105D-03 , 3.0093D-03 , 1.6226D-03 , 6.3321D-04 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 7.2796D-01 , 7.1795D-01 , 7.0799D-01 , 
     &      6.9776D-01 , 6.8760D-01 , 6.7649D-01/
      DATA (xdef_l(k),k=1027,1140)/6.6523D-01 , 6.5299D-01 , 
     &      6.4099D-01 , 6.2720D-01 , 6.1289D-01 , 5.9763D-01 , 
     &      5.8140D-01 , 5.7108D-01 , 5.5954D-01 , 5.4555D-01 , 
     &      5.3082D-01 , 5.1501D-01 , 4.9841D-01 , 4.8352D-01 , 
     &      4.6718D-01 , 4.4758D-01 , 4.2678D-01 , 4.0543D-01 , 
     &      3.8267D-01 , 3.6267D-01 , 3.4052D-01 , 3.1445D-01 , 
     &      2.8771D-01 , 2.6154D-01 , 2.3817D-01 , 2.1835D-01 , 
     &      1.9910D-01 , 1.8043D-01 , 1.6662D-01 , 1.5905D-01 , 
     &      1.5900D-01 , 1.6548D-01 , 1.7871D-01 , 2.0015D-01 , 
     &      2.2403D-01 , 2.3835D-01 , 2.4610D-01 , 2.4469D-01 , 
     &      2.3394D-01 , 2.1634D-01 , 1.9372D-01 , 1.6761D-01 , 
     &      1.3910D-01 , 1.0920D-01 , 7.9530D-02 , 5.2165D-02 , 
     &      3.0250D-02 , 1.8723D-02 , 2.5275D-02 , 4.8575D-02 , 
     &      3.1676D-02 , 1.9677D-02 , 1.1540D-02 , 6.2533D-03 , 
     &      2.6411D-03 , 1.4253D-03 , 5.5072D-04 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      7.4788D-01 , 7.3751D-01 , 7.2708D-01 , 7.1644D-01 , 
     &      7.0580D-01 , 6.9430D-01 , 6.8256D-01 , 6.6975D-01 , 
     &      6.5712D-01 , 6.4276D-01 , 6.2791D-01 , 6.1180D-01 , 
     &      5.9490D-01 , 5.8409D-01 , 5.7199D-01 , 5.5739D-01 , 
     &      5.4166D-01 , 5.2544D-01 , 5.0821D-01 , 4.9288D-01 , 
     &      4.7590D-01 , 4.5544D-01 , 4.3393D-01 , 4.1178D-01 , 
     &      3.8837D-01 , 3.6775D-01 , 3.4513D-01 , 3.1844D-01 , 
     &      2.9125D-01 , 2.6472D-01 , 2.4110D-01 , 2.2115D-01 , 
     &      2.0189D-01 , 1.8330D-01 , 1.6955D-01 , 1.6237D-01 , 
     &      1.6243D-01 , 1.6875D-01 , 1.8164D-01 , 2.0201D-01 , 
     &      2.2410D-01 , 2.3665D-01 , 2.4236D-01 , 2.3927D-01 , 
     &      2.2710D-01 , 2.0852D-01 , 1.8563D-01 , 1.5962D-01 , 
     &      1.3170D-01 , 1.0314D-01 , 7.5292D-02 , 5.0347D-02/
      DATA (xdef_l(k),k=1141,1254)/3.1513D-02 , 2.3688D-02 , 
     &      3.4520D-02 , 4.4988D-02 , 2.9140D-02 , 1.7975D-02 , 
     &      1.0472D-02 , 5.6268D-03 , 2.3442D-03 , 1.2646D-03 , 
     &      4.8432D-04 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 7.6812D-01 , 7.5731D-01 , 
     &      7.4653D-01 , 7.3551D-01 , 7.2440D-01 , 7.1234D-01 , 
     &      6.9989D-01 , 6.8692D-01 , 6.7357D-01 , 6.5855D-01 , 
     &      6.4312D-01 , 6.2624D-01 , 6.0850D-01 , 5.9719D-01 , 
     &      5.8457D-01 , 5.6934D-01 , 5.5297D-01 , 5.3626D-01 , 
     &      5.1802D-01 , 5.0223D-01 , 4.8440D-01 , 4.6329D-01 , 
     &      4.4109D-01 , 4.1826D-01 , 3.9408D-01 , 3.7291D-01 , 
     &      3.4966D-01 , 3.2243D-01 , 2.9475D-01 , 2.6790D-01 , 
     &      2.4406D-01 , 2.2399D-01 , 2.0470D-01 , 1.8621D-01 , 
     &      1.7262D-01 , 1.6558D-01 , 1.6576D-01 , 1.7201D-01 , 
     &      1.8441D-01 , 2.0372D-01 , 2.2403D-01 , 2.3482D-01 , 
     &      2.3856D-01 , 2.3398D-01 , 2.2040D-01 , 2.0103D-01 , 
     &      1.7782D-01 , 1.5205D-01 , 1.2492D-01 , 9.7540D-02 , 
     &      7.1452D-02 , 4.8817D-02 , 3.2832D-02 , 2.8412D-02 , 
     &      4.3068D-02 , 4.1684D-02 , 2.6819D-02 , 1.6431D-02 , 
     &      9.5049D-03 , 5.0674D-03 , 2.0840D-03 , 1.1231D-03 , 
     &      4.2643D-04 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 7.8709D-01 , 7.7617D-01 , 
     &      7.6509D-01 , 7.5353D-01 , 7.4210D-01 , 7.2955D-01 , 
     &      7.1666D-01 , 7.0326D-01 , 6.8906D-01 , 6.7364D-01 , 
     &      6.5743D-01 , 6.3988D-01 , 6.2140D-01 , 6.0962D-01 , 
     &      5.9645D-01 , 5.8083D-01 , 5.6382D-01 , 5.4630D-01 , 
     &      5.2750D-01 , 5.1079D-01 , 4.9267D-01 , 4.7078D-01 , 
     &      4.4780D-01 , 4.2425D-01 , 3.9948D-01 , 3.7773D-01 , 
     &      3.5398D-01 , 3.2619D-01 , 2.9811D-01 , 2.7093D-01/
      DATA (xdef_l(k),k=1255,1368)/2.4686D-01 , 2.2668D-01 , 
     &      2.0735D-01 , 1.8888D-01 , 1.7555D-01 , 1.6865D-01 , 
     &      1.6887D-01 , 1.7500D-01 , 1.8693D-01 , 2.0522D-01 , 
     &      2.2377D-01 , 2.3300D-01 , 2.3501D-01 , 2.2902D-01 , 
     &      2.1428D-01 , 1.9427D-01 , 1.7084D-01 , 1.4533D-01 , 
     &      1.1889D-01 , 9.2655D-02 , 6.8174D-02 , 4.7575D-02 , 
     &      3.4123D-02 , 3.2605D-02 , 5.0454D-02 , 3.8820D-02 , 
     &      2.4822D-02 , 1.5113D-02 , 8.6857D-03 , 4.5962D-03 , 
     &      1.8704D-03 , 1.0050D-03 , 3.7856D-04 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      8.0606D-01 , 7.9455D-01 , 7.8312D-01 , 7.7128D-01 , 
     &      7.5940D-01 , 7.4610D-01 , 7.3287D-01 , 7.1917D-01 , 
     &      7.0456D-01 , 6.8825D-01 , 6.7140D-01 , 6.5313D-01 , 
     &      6.3390D-01 , 6.2170D-01 , 6.0798D-01 , 5.9180D-01 , 
     &      5.7419D-01 , 5.5596D-01 , 5.3636D-01 , 5.1934D-01 , 
     &      5.0050D-01 , 4.7790D-01 , 4.5436D-01 , 4.3012D-01 , 
     &      4.0458D-01 , 3.8238D-01 , 3.5808D-01 , 3.2984D-01 , 
     &      3.0133D-01 , 2.7388D-01 , 2.4957D-01 , 2.2930D-01 , 
     &      2.0996D-01 , 1.9168D-01 , 1.7832D-01 , 1.7159D-01 , 
     &      1.7177D-01 , 1.7770D-01 , 1.8921D-01 , 2.0651D-01 , 
     &      2.2344D-01 , 2.3117D-01 , 2.3152D-01 , 2.2426D-01 , 
     &      2.0844D-01 , 1.8790D-01 , 1.6440D-01 , 1.3914D-01 , 
     &      1.1342D-01 , 8.8280D-02 , 6.5276D-02 , 4.6578D-02 , 
     &      3.5360D-02 , 3.6411D-02 , 5.6986D-02 , 3.6256D-02 , 
     &      2.3040D-02 , 1.3948D-02 , 7.9676D-03 , 4.1856D-03 , 
     &      1.6876D-03 , 9.0394D-04 , 3.3789D-04 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      8.2409D-01 , 8.1223D-01 , 8.0027D-01 , 7.8810D-01 , 
     &      7.7580D-01 , 7.6250D-01 , 7.4852D-01 , 7.3383D-01/
      DATA (xdef_l(k),k=1369,1482)/7.1879D-01 , 7.0216D-01 , 
     &      6.8466D-01 , 6.6571D-01 , 6.4580D-01 , 6.3303D-01 , 
     &      6.1887D-01 , 6.0161D-01 , 5.8362D-01 , 5.6485D-01 , 
     &      5.4490D-01 , 5.2736D-01 , 5.0788D-01 , 4.8465D-01 , 
     &      4.6048D-01 , 4.3549D-01 , 4.0949D-01 , 3.8678D-01 , 
     &      3.6198D-01 , 3.3325D-01 , 3.0435D-01 , 2.7667D-01 , 
     &      2.5212D-01 , 2.3179D-01 , 2.1241D-01 , 1.9410D-01 , 
     &      1.8093D-01 , 1.7428D-01 , 1.7445D-01 , 1.8022D-01 , 
     &      1.9133D-01 , 2.0758D-01 , 2.2299D-01 , 2.2941D-01 , 
     &      2.2823D-01 , 2.1990D-01 , 2.0319D-01 , 1.8211D-01 , 
     &      1.5852D-01 , 1.3371D-01 , 1.0856D-01 , 8.4430D-02 , 
     &      6.2776D-02 , 4.5758D-02 , 3.6514D-02 , 3.9756D-02 , 
     &      6.2597D-02 , 3.4019D-02 , 2.1502D-02 , 1.2943D-02 , 
     &      7.3506D-03 , 3.8366D-03 , 1.5351D-03 , 8.1923D-04 , 
     &      3.0383D-04 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 8.4844D-01 , 8.3627D-01 , 
     &      8.2378D-01 , 8.1114D-01 , 7.9820D-01 , 7.8411D-01 , 
     &      7.6977D-01 , 7.5436D-01 , 7.3871D-01 , 7.2101D-01 , 
     &      7.0269D-01 , 6.8280D-01 , 6.6180D-01 , 6.4849D-01 , 
     &      6.3365D-01 , 6.1605D-01 , 5.9682D-01 , 5.7721D-01 , 
     &      5.5628D-01 , 5.3805D-01 , 5.1772D-01 , 4.9378D-01 , 
     &      4.6868D-01 , 4.4295D-01 , 4.1599D-01 , 3.9262D-01 , 
     &      3.6722D-01 , 3.3788D-01 , 3.0847D-01 , 2.8040D-01 , 
     &      2.5562D-01 , 2.3513D-01 , 2.1572D-01 , 1.9746D-01 , 
     &      1.8447D-01 , 1.7787D-01 , 1.7810D-01 , 1.8358D-01 , 
     &      1.9394D-01 , 2.0894D-01 , 2.2227D-01 , 2.2689D-01 , 
     &      2.2385D-01 , 2.1408D-01 , 1.9620D-01 , 1.7461D-01 , 
     &      1.5108D-01 , 1.2667D-01 , 1.0243D-01 , 7.9635D-02 , 
     &      5.9715D-02 , 4.4804D-02 , 3.7997D-02 , 4.3894D-02/
      DATA (xdef_l(k),k=1483,1596)/6.9391D-02 , 3.1240D-02 , 
     &      1.9603D-02 , 1.1712D-02 , 6.6036D-03 , 3.4150D-03 , 
     &      1.3549D-03 , 7.1812D-04 , 2.6373D-04 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      8.7089D-01 , 8.5819D-01 , 8.4535D-01 , 8.3207D-01 , 
     &      8.1860D-01 , 8.0424D-01 , 7.8877D-01 , 7.7320D-01 , 
     &      7.5642D-01 , 7.3822D-01 , 7.1895D-01 , 6.9816D-01 , 
     &      6.7640D-01 , 6.6244D-01 , 6.4701D-01 , 6.2817D-01 , 
     &      6.0860D-01 , 5.8841D-01 , 5.6672D-01 , 5.4767D-01 , 
     &      5.2667D-01 , 5.0182D-01 , 4.7599D-01 , 4.4955D-01 , 
     &      4.2190D-01 , 3.9787D-01 , 3.7196D-01 , 3.4199D-01 , 
     &      3.1220D-01 , 2.8382D-01 , 2.5874D-01 , 2.3816D-01 , 
     &      2.1874D-01 , 2.0063D-01 , 1.8770D-01 , 1.8107D-01 , 
     &      1.8121D-01 , 1.8638D-01 , 1.9622D-01 , 2.0994D-01 , 
     &      2.2156D-01 , 2.2456D-01 , 2.1986D-01 , 2.0892D-01 , 
     &      1.9015D-01 , 1.6817D-01 , 1.4465D-01 , 1.2070D-01 , 
     &      9.7309D-02 , 7.5665D-02 , 5.7234D-02 , 4.4095D-02 , 
     &      3.9289D-02 , 4.7307D-02 , 7.4739D-02 , 2.8958D-02 , 
     &      1.8046D-02 , 1.0716D-02 , 6.0010D-03 , 3.0801D-03 , 
     &      1.2145D-03 , 6.3833D-04 , 2.3251D-04 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      8.9366D-01 , 8.8058D-01 , 8.6727D-01 , 8.5353D-01 , 
     &      8.3950D-01 , 8.2436D-01 , 8.0890D-01 , 7.9205D-01 , 
     &      7.7476D-01 , 7.5566D-01 , 7.3557D-01 , 7.1393D-01 , 
     &      6.9120D-01 , 6.7672D-01 , 6.6059D-01 , 6.4145D-01 , 
     &      6.2086D-01 , 5.9962D-01 , 5.7716D-01 , 5.5756D-01 , 
     &      5.3584D-01 , 5.1022D-01 , 4.8344D-01 , 4.5615D-01 , 
     &      4.2780D-01 , 4.0320D-01 , 3.7671D-01 , 3.4621D-01 , 
     &      3.1594D-01 , 2.8727D-01 , 2.6196D-01 , 2.4126D-01/
      DATA (xdef_l(k),k=1597,1710)/2.2177D-01 , 2.0361D-01 , 
     &      1.9078D-01 , 1.8427D-01 , 1.8432D-01 , 1.8918D-01 , 
     &      1.9834D-01 , 2.1079D-01 , 2.2065D-01 , 2.2210D-01 , 
     &      2.1587D-01 , 2.0383D-01 , 1.8424D-01 , 1.6197D-01 , 
     &      1.3849D-01 , 1.1505D-01 , 9.2463D-02 , 7.1949D-02 , 
     &      5.4952D-02 , 4.3474D-02 , 4.0525D-02 , 5.0376D-02 , 
     &      7.9517D-02 , 2.6835D-02 , 1.6616D-02 , 9.8004D-03 , 
     &      5.4489D-03 , 2.7768D-03 , 1.0900D-03 , 5.6728D-04 , 
     &      2.0489D-04 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 9.1643D-01 , 9.0298D-01 , 
     &      8.8901D-01 , 8.7472D-01 , 8.6030D-01 , 8.4449D-01 , 
     &      8.2790D-01 , 8.1090D-01 , 7.9278D-01 , 7.7287D-01 , 
     &      7.5201D-01 , 7.2942D-01 , 7.0580D-01 , 6.9067D-01 , 
     &      6.7395D-01 , 6.5357D-01 , 6.3264D-01 , 6.1082D-01 , 
     &      5.8728D-01 , 5.6718D-01 , 5.4478D-01 , 5.1825D-01 , 
     &      4.9075D-01 , 4.6263D-01 , 4.3360D-01 , 4.0844D-01 , 
     &      3.8138D-01 , 3.5032D-01 , 3.1963D-01 , 2.9065D-01 , 
     &      2.6511D-01 , 2.4428D-01 , 2.2479D-01 , 2.0678D-01 , 
     &      1.9385D-01 , 1.8735D-01 , 1.8722D-01 , 1.9179D-01 , 
     &      2.0029D-01 , 2.1158D-01 , 2.1961D-01 , 2.1971D-01 , 
     &      2.1194D-01 , 1.9894D-01 , 1.7862D-01 , 1.5609D-01 , 
     &      1.3279D-01 , 1.0972D-01 , 8.8007D-02 , 6.8578D-02 , 
     &      5.2905D-02 , 4.2942D-02 , 4.1624D-02 , 5.3065D-02 , 
     &      8.3506D-02 , 2.4920D-02 , 1.5334D-02 , 8.9876D-03 , 
     &      4.9653D-03 , 2.5112D-03 , 9.8300D-04 , 5.0629D-04 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 9.3762D-01 , 9.2325D-01 , 
     &      9.0916D-01 , 8.9432D-01 , 8.7930D-01 , 8.6312D-01 , 
     &      8.4579D-01 , 8.2807D-01 , 8.0954D-01 , 7.8866D-01/
      DATA (xdef_l(k),k=1711,1824)/7.6704D-01 , 7.4360D-01 , 
     &      7.1911D-01 , 7.0343D-01 , 6.8612D-01 , 6.6512D-01 , 
     &      6.4349D-01 , 6.2048D-01 , 5.9676D-01 , 5.7574D-01 , 
     &      5.5261D-01 , 5.2556D-01 , 4.9731D-01 , 4.6862D-01 , 
     &      4.3881D-01 , 4.1318D-01 , 3.8556D-01 , 3.5408D-01 , 
     &      3.2299D-01 , 2.9375D-01 , 2.6794D-01 , 2.4706D-01 , 
     &      2.2744D-01 , 2.0939D-01 , 1.9662D-01 , 1.9016D-01 , 
     &      1.8990D-01 , 1.9412D-01 , 2.0192D-01 , 2.1208D-01 , 
     &      2.1863D-01 , 2.1745D-01 , 2.0845D-01 , 1.9458D-01 , 
     &      1.7365D-01 , 1.5094D-01 , 1.2783D-01 , 1.0526D-01 , 
     &      8.4228D-02 , 6.5746D-02 , 5.1203D-02 , 4.2521D-02 , 
     &      4.2531D-02 , 5.5238D-02 , 8.6619D-02 , 2.3321D-02 , 
     &      1.4266D-02 , 8.3142D-03 , 4.5684D-03 , 2.2945D-03 , 
     &      8.9721D-04 , 4.5700D-04 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      9.5912D-01 , 9.4446D-01 , 9.2967D-01 , 9.1446D-01 , 
     &      8.9890D-01 , 8.8176D-01 , 8.6424D-01 , 8.4567D-01 , 
     &      8.2630D-01 , 8.0492D-01 , 7.8242D-01 , 7.5817D-01 , 
     &      7.3271D-01 , 7.1653D-01 , 6.9849D-01 , 6.7725D-01 , 
     &      6.5433D-01 , 6.3091D-01 , 6.0625D-01 , 5.8456D-01 , 
     &      5.6088D-01 , 5.3305D-01 , 5.0402D-01 , 4.7461D-01 , 
     &      4.4411D-01 , 4.1800D-01 , 3.8988D-01 , 3.5790D-01 , 
     &      3.2644D-01 , 2.9690D-01 , 2.7087D-01 , 2.4987D-01 , 
     &      2.3039D-01 , 2.1219D-01 , 1.9955D-01 , 1.9298D-01 , 
     &      1.9248D-01 , 1.9636D-01 , 2.0355D-01 , 2.1258D-01 , 
     &      2.1752D-01 , 2.1512D-01 , 2.0490D-01 , 1.9021D-01 , 
     &      1.6876D-01 , 1.4586D-01 , 1.2296D-01 , 1.0090D-01 , 
     &      8.0587D-02 , 6.3034D-02 , 4.9591D-02 , 4.2122D-02 , 
     &      4.3355D-02 , 5.7203D-02 , 8.9336D-02 , 2.1802D-02/
      DATA (xdef_l(k),k=1825,1836)/1.3258D-02 , 7.6843D-03 , 
     &      4.1967D-03 , 2.0952D-03 , 8.1932D-04 , 4.1202D-04 , 
     &      0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 0.0000D+00/
      DATA (xudf_l(k),k=1,114)/1.8987D-02 , 1.9947D-02 , 2.0980D-02 , 
     &      2.2068D-02 , 2.3225D-02 , 2.4540D-02 , 2.5957D-02 , 
     &      2.7526D-02 , 2.9229D-02 , 3.1232D-02 , 3.3453D-02 , 
     &      3.6003D-02 , 3.8855D-02 , 4.0763D-02 , 4.2980D-02 , 
     &      4.5778D-02 , 4.8895D-02 , 5.2320D-02 , 5.6174D-02 , 
     &      5.9765D-02 , 6.3980D-02 , 6.9315D-02 , 7.5299D-02 , 
     &      8.1888D-02 , 8.9292D-02 , 9.6162D-02 , 1.0414D-01 , 
     &      1.1410D-01 , 1.2505D-01 , 1.3674D-01 , 1.4937D-01 , 
     &      1.6060D-01 , 1.7296D-01 , 1.8730D-01 , 2.0166D-01 , 
     &      2.1531D-01 , 2.2821D-01 , 2.3833D-01 , 2.4848D-01 , 
     &      2.6049D-01 , 2.7586D-01 , 2.9166D-01 , 3.1456D-01 , 
     &      3.3942D-01 , 3.7230D-01 , 4.0597D-01 , 4.3921D-01 , 
     &      4.7071D-01 , 4.9846D-01 , 5.2057D-01 , 5.3433D-01 , 
     &      5.3610D-01 , 5.2141D-01 , 4.8433D-01 , 4.1719D-01 , 
     &      6.3794D-01 , 6.7411D-01 , 7.2040D-01 , 7.8812D-01 , 
     &      8.9495D-01 , 1.0702D+00 , 1.3629D+00 , 1.8763D+00 , 
     &      2.8399D+00 , 4.8968D+00 , 1.0506D+01 , 3.7793D+01 , 
     &      0.0000D+00 , 3.1111D-02 , 3.2336D-02 , 3.3580D-02 , 
     &      3.4906D-02 , 3.6247D-02 , 3.7773D-02 , 3.9337D-02 , 
     &      4.1056D-02 , 4.2876D-02 , 4.5001D-02 , 4.7299D-02 , 
     &      4.9897D-02 , 5.2761D-02 , 5.4666D-02 , 5.6867D-02 , 
     &      5.9620D-02 , 6.2679D-02 , 6.6018D-02 , 6.9775D-02 , 
     &      7.3275D-02 , 7.7353D-02 , 8.2522D-02 , 8.8327D-02 , 
     &      9.4694D-02 , 1.0184D-01 , 1.0846D-01 , 1.1615D-01 , 
     &      1.2575D-01 , 1.3628D-01 , 1.4752D-01 , 1.5964D-01 , 
     &      1.7036D-01 , 1.8215D-01 , 1.9580D-01 , 2.0933D-01 , 
     &      2.2213D-01 , 2.3411D-01 , 2.4341D-01 , 2.5275D-01 , 
     &      2.6387D-01 , 2.7831D-01 , 2.9333D-01 , 3.1510D-01 , 
     &      3.3876D-01 , 3.6995D-01 , 4.0170D-01/
      DATA (xudf_l(k),k=115,228)/4.3298D-01 , 4.6172D-01 , 4.8742D-01 , 
     &      5.0700D-01 , 5.1856D-01 , 5.1873D-01 , 5.0352D-01 , 
     &      4.6746D-01 , 4.0418D-01 , 6.1801D-01 , 6.5339D-01 , 
     &      6.9923D-01 , 7.6627D-01 , 8.7125D-01 , 1.0408D+00 , 
     &      1.3199D+00 , 1.8020D+00 , 2.6920D+00 , 4.5574D+00 , 
     &      9.5310D+00 , 3.2877D+01 , 0.0000D+00 , 5.1176D-02 , 
     &      5.2640D-02 , 5.4100D-02 , 5.5603D-02 , 5.7095D-02 , 
     &      5.8737D-02 , 6.0416D-02 , 6.2154D-02 , 6.4016D-02 , 
     &      6.6046D-02 , 6.8273D-02 , 7.0765D-02 , 7.3444D-02 , 
     &      7.5182D-02 , 7.7263D-02 , 7.9781D-02 , 8.2626D-02 , 
     &      8.5707D-02 , 8.9176D-02 , 9.2402D-02 , 9.6182D-02 , 
     &      1.0098D-01 , 1.0635D-01 , 1.1227D-01 , 1.1893D-01 , 
     &      1.2513D-01 , 1.3230D-01 , 1.4128D-01 , 1.5115D-01 , 
     &      1.6164D-01 , 1.7300D-01 , 1.8301D-01 , 1.9397D-01 , 
     &      2.0660D-01 , 2.1907D-01 , 2.3072D-01 , 2.4154D-01 , 
     &      2.4985D-01 , 2.5817D-01 , 2.6810D-01 , 2.8136D-01 , 
     &      2.9535D-01 , 3.1585D-01 , 3.3824D-01 , 3.6743D-01 , 
     &      3.9701D-01 , 4.2565D-01 , 4.5205D-01 , 4.7460D-01 , 
     &      4.9184D-01 , 5.0110D-01 , 4.9954D-01 , 4.8363D-01 , 
     &      4.4878D-01 , 3.8940D-01 , 5.9452D-01 , 6.2820D-01 , 
     &      6.7181D-01 , 7.3612D-01 , 8.3598D-01 , 9.9560D-01 , 
     &      1.2543D+00 , 1.6953D+00 , 2.4947D+00 , 4.1415D+00 , 
     &      8.4275D+00 , 2.7797D+01 , 0.0000D+00 , 8.6266D-02 , 
     &      8.7847D-02 , 8.9380D-02 , 9.0869D-02 , 9.2337D-02 , 
     &      9.3826D-02 , 9.5315D-02 , 9.6842D-02 , 9.8333D-02 , 
     &      1.0003D-01 , 1.0178D-01 , 1.0370D-01 , 1.0575D-01 , 
     &      1.0710D-01 , 1.0872D-01 , 1.1075D-01 , 1.1295D-01 , 
     &      1.1538D-01 , 1.1821D-01 , 1.2088D-01 , 1.2396D-01 , 
     &      1.2796D-01 , 1.3252D-01 , 1.3756D-01/
      DATA (xudf_l(k),k=229,342)/1.4331D-01 , 1.4870D-01 , 1.5500D-01 , 
     &      1.6291D-01 , 1.7166D-01 , 1.8100D-01 , 1.9111D-01 , 
     &      2.0002D-01 , 2.0977D-01 , 2.2095D-01 , 2.3189D-01 , 
     &      2.4200D-01 , 2.5123D-01 , 2.5821D-01 , 2.6512D-01 , 
     &      2.7351D-01 , 2.8514D-01 , 2.9789D-01 , 3.1683D-01 , 
     &      3.3731D-01 , 3.6424D-01 , 3.9124D-01 , 4.1697D-01 , 
     &      4.4030D-01 , 4.6002D-01 , 4.7419D-01 , 4.8085D-01 , 
     &      4.7740D-01 , 4.6086D-01 , 4.2728D-01 , 3.7241D-01 , 
     &      5.6656D-01 , 5.9684D-01 , 6.3694D-01 , 6.9622D-01 , 
     &      7.8804D-01 , 9.3343D-01 , 1.1653D+00 , 1.5545D+00 , 
     &      2.2504D+00 , 3.6537D+00 , 7.2124D+00 , 2.2653D+01 , 
     &      0.0000D+00 , 1.4838D-01 , 1.4960D-01 , 1.5068D-01 , 
     &      1.5161D-01 , 1.5242D-01 , 1.5316D-01 , 1.5373D-01 , 
     &      1.5426D-01 , 1.5470D-01 , 1.5511D-01 , 1.5554D-01 , 
     &      1.5602D-01 , 1.5660D-01 , 1.5698D-01 , 1.5750D-01 , 
     &      1.5830D-01 , 1.5923D-01 , 1.6034D-01 , 1.6181D-01 , 
     &      1.6324D-01 , 1.6509D-01 , 1.6746D-01 , 1.7054D-01 , 
     &      1.7402D-01 , 1.7811D-01 , 1.8208D-01 , 1.8687D-01 , 
     &      1.9296D-01 , 1.9986D-01 , 2.0734D-01 , 2.1554D-01 , 
     &      2.2281D-01 , 2.3075D-01 , 2.3983D-01 , 2.4863D-01 , 
     &      2.5660D-01 , 2.6366D-01 , 2.6883D-01 , 2.7387D-01 , 
     &      2.8026D-01 , 2.8982D-01 , 3.0088D-01 , 3.1780D-01 , 
     &      3.3626D-01 , 3.6021D-01 , 3.8399D-01 , 4.0666D-01 , 
     &      4.2682D-01 , 4.4278D-01 , 4.5386D-01 , 4.5774D-01 , 
     &      4.5230D-01 , 4.3509D-01 , 4.0314D-01 , 3.5321D-01 , 
     &      5.3325D-01 , 5.5916D-01 , 5.9448D-01 , 6.4707D-01 , 
     &      7.2797D-01 , 8.5557D-01 , 1.0563D+00 , 1.3882D+00 , 
     &      1.9717D+00 , 3.1223D+00 , 5.9601D+00 , 1.7750D+01 , 
     &      0.0000D+00 , 2.3139D-01 , 2.3138D-01/
      DATA (xudf_l(k),k=343,456)/2.3120D-01 , 2.3076D-01 , 2.3006D-01 , 
     &      2.2907D-01 , 2.2788D-01 , 2.2645D-01 , 2.2489D-01 , 
     &      2.2308D-01 , 2.2120D-01 , 2.1929D-01 , 2.1743D-01 , 
     &      2.1630D-01 , 2.1526D-01 , 2.1411D-01 , 2.1311D-01 , 
     &      2.1231D-01 , 2.1171D-01 , 2.1148D-01 , 2.1150D-01 , 
     &      2.1182D-01 , 2.1271D-01 , 2.1412D-01 , 2.1601D-01 , 
     &      2.1822D-01 , 2.2096D-01 , 2.2496D-01 , 2.2961D-01 , 
     &      2.3481D-01 , 2.4086D-01 , 2.4622D-01 , 2.5214D-01 , 
     &      2.5891D-01 , 2.6537D-01 , 2.7104D-01 , 2.7588D-01 , 
     &      2.7922D-01 , 2.8235D-01 , 2.8664D-01 , 2.9413D-01 , 
     &      3.0352D-01 , 3.1845D-01 , 3.3481D-01 , 3.5617D-01 , 
     &      3.7737D-01 , 3.9689D-01 , 4.1403D-01 , 4.2736D-01 , 
     &      4.3558D-01 , 4.3712D-01 , 4.3016D-01 , 4.1245D-01 , 
     &      3.8197D-01 , 3.3645D-01 , 5.0322D-01 , 5.2507D-01 , 
     &      5.5559D-01 , 6.0172D-01 , 6.7286D-01 , 7.8413D-01 , 
     &      9.5797D-01 , 1.2422D+00 , 1.7341D+00 , 2.6883D+00 , 
     &      4.9868D+00 , 1.4177D+01 , 0.0000D+00 , 3.6389D-01 , 
     &      3.6098D-01 , 3.5780D-01 , 3.5400D-01 , 3.5016D-01 , 
     &      3.4553D-01 , 3.4044D-01 , 3.3521D-01 , 3.2971D-01 , 
     &      3.2369D-01 , 3.1755D-01 , 3.1120D-01 , 3.0494D-01 , 
     &      3.0120D-01 , 2.9724D-01 , 2.9287D-01 , 2.8855D-01 , 
     &      2.8449D-01 , 2.8072D-01 , 2.7770D-01 , 2.7469D-01 , 
     &      2.7175D-01 , 2.6933D-01 , 2.6740D-01 , 2.6613D-01 , 
     &      2.6556D-01 , 2.6563D-01 , 2.6631D-01 , 2.6763D-01 , 
     &      2.6975D-01 , 2.7268D-01 , 2.7539D-01 , 2.7857D-01 , 
     &      2.8224D-01 , 2.8565D-01 , 2.8841D-01 , 2.9040D-01 , 
     &      2.9139D-01 , 2.9220D-01 , 2.9395D-01 , 2.9888D-01 , 
     &      3.0633D-01 , 3.1877D-01 , 3.3296D-01 , 3.5147D-01 , 
     &      3.6947D-01 , 3.8604D-01 , 3.9986D-01/
      DATA (xudf_l(k),k=457,570)/4.1008D-01 , 4.1548D-01 , 4.1467D-01 , 
     &      4.0620D-01 , 3.8830D-01 , 3.5965D-01 , 3.1902D-01 , 
     &      4.7020D-01 , 4.8772D-01 , 5.1303D-01 , 5.5185D-01 , 
     &      6.1224D-01 , 7.0699D-01 , 8.5323D-01 , 1.0903D+00 , 
     &      1.4950D+00 , 2.2640D+00 , 4.0723D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 5.2666D-01 , 5.1909D-01 , 5.1100D-01 , 
     &      5.0238D-01 , 4.9333D-01 , 4.8312D-01 , 4.7293D-01 , 
     &      4.6180D-01 , 4.5066D-01 , 4.3890D-01 , 4.2692D-01 , 
     &      4.1467D-01 , 4.0262D-01 , 3.9542D-01 , 3.8784D-01 , 
     &      3.7925D-01 , 3.7080D-01 , 3.6267D-01 , 3.5482D-01 , 
     &      3.4841D-01 , 3.4190D-01 , 3.3492D-01 , 3.2852D-01 , 
     &      3.2287D-01 , 3.1768D-01 , 3.1409D-01 , 3.1066D-01 , 
     &      3.0785D-01 , 3.0564D-01 , 3.0446D-01 , 3.0380D-01 , 
     &      3.0388D-01 , 3.0402D-01 , 3.0458D-01 , 3.0488D-01 , 
     &      3.0475D-01 , 3.0386D-01 , 3.0263D-01 , 3.0116D-01 , 
     &      3.0045D-01 , 3.0296D-01 , 3.0852D-01 , 3.1888D-01 , 
     &      3.3085D-01 , 3.4677D-01 , 3.6222D-01 , 3.7600D-01 , 
     &      3.8707D-01 , 3.9488D-01 , 3.9799D-01 , 3.9530D-01 , 
     &      3.8568D-01 , 3.6791D-01 , 3.4080D-01 , 3.0424D-01 , 
     &      4.4195D-01 , 4.5570D-01 , 4.7648D-01 , 5.0935D-01 , 
     &      5.6099D-01 , 6.4225D-01 , 7.6680D-01 , 9.6736D-01 , 
     &      1.3053D+00 , 1.9393D+00 , 3.3976D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 7.4015D-01 , 7.2498D-01 , 7.0940D-01 , 
     &      6.9297D-01 , 6.7620D-01 , 6.5800D-01 , 6.3935D-01 , 
     &      6.2047D-01 , 6.0114D-01 , 5.8076D-01 , 5.6065D-01 , 
     &      5.4030D-01 , 5.2035D-01 , 5.0839D-01 , 4.9583D-01 , 
     &      4.8167D-01 , 4.6773D-01 , 4.5434D-01 , 4.4113D-01 , 
     &      4.3035D-01 , 4.1922D-01 , 4.0719D-01 , 3.9582D-01 , 
     &      3.8536D-01 , 3.7557D-01 , 3.6805D-01/
      DATA (xudf_l(k),k=571,684)/3.6079D-01 , 3.5336D-01 , 3.4710D-01 , 
     &      3.4173D-01 , 3.3719D-01 , 3.3400D-01 , 3.3124D-01 , 
     &      3.2819D-01 , 3.2494D-01 , 3.2158D-01 , 3.1765D-01 , 
     &      3.1400D-01 , 3.1011D-01 , 3.0684D-01 , 3.0682D-01 , 
     &      3.1046D-01 , 3.1856D-01 , 3.2861D-01 , 3.4189D-01 , 
     &      3.5475D-01 , 3.6597D-01 , 3.7463D-01 , 3.8003D-01 , 
     &      3.8108D-01 , 3.7681D-01 , 3.6631D-01 , 3.4865D-01 , 
     &      3.2327D-01 , 2.9078D-01 , 4.1488D-01 , 4.2529D-01 , 
     &      4.4193D-01 , 4.6945D-01 , 5.1322D-01 , 5.8236D-01 , 
     &      6.8846D-01 , 8.5739D-01 , 1.1394D+00 , 1.6617D+00 , 
     &      2.8395D+00 , 0.0000D+00 , 0.0000D+00 , 9.8501D-01 , 
     &      9.5975D-01 , 9.3420D-01 , 9.0757D-01 , 8.8092D-01 , 
     &      8.5237D-01 , 8.2383D-01 , 7.9445D-01 , 7.6556D-01 , 
     &      7.3524D-01 , 7.0484D-01 , 6.7495D-01 , 6.4547D-01 , 
     &      6.2798D-01 , 6.0969D-01 , 5.8904D-01 , 5.6882D-01 , 
     &      5.4932D-01 , 5.3014D-01 , 5.1443D-01 , 4.9826D-01 , 
     &      4.8058D-01 , 4.6380D-01 , 4.4815D-01 , 4.3330D-01 , 
     &      4.2167D-01 , 4.1020D-01 , 3.9827D-01 , 3.8748D-01 , 
     &      3.7784D-01 , 3.6931D-01 , 3.6303D-01 , 3.5669D-01 , 
     &      3.4992D-01 , 3.4358D-01 , 3.3710D-01 , 3.3025D-01 , 
     &      3.2429D-01 , 3.1817D-01 , 3.1242D-01 , 3.1001D-01 , 
     &      3.1195D-01 , 3.1802D-01 , 3.2610D-01 , 3.3719D-01 , 
     &      3.4770D-01 , 3.5674D-01 , 3.6357D-01 , 3.6695D-01 , 
     &      3.6631D-01 , 3.6075D-01 , 3.4960D-01 , 3.3214D-01 , 
     &      3.0855D-01 , 2.7931D-01 , 3.9198D-01 , 3.9931D-01 , 
     &      4.1263D-01 , 4.3550D-01 , 4.7310D-01 , 5.3259D-01 , 
     &      6.2375D-01 , 7.6876D-01 , 1.0087D+00 , 1.4464D+00 , 
     &      2.4185D+00 , 0.0000D+00 , 0.0000D+00 , 1.2917D+00 , 
     &      1.2523D+00 , 1.2128D+00 , 1.1722D+00/
      DATA (xudf_l(k),k=685,798)/1.1321D+00 , 1.0894D+00 , 1.0473D+00 , 
     &      1.0044D+00 , 9.6262D-01 , 9.1838D-01 , 8.7565D-01 , 
     &      8.3283D-01 , 7.9186D-01 , 7.6734D-01 , 7.4146D-01 , 
     &      7.1300D-01 , 6.8484D-01 , 6.5787D-01 , 6.3134D-01 , 
     &      6.0963D-01 , 5.8730D-01 , 5.6294D-01 , 5.3947D-01 , 
     &      5.1767D-01 , 4.9689D-01 , 4.8039D-01 , 4.6398D-01 , 
     &      4.4675D-01 , 4.3087D-01 , 4.1650D-01 , 4.0371D-01 , 
     &      3.9342D-01 , 3.8361D-01 , 3.7293D-01 , 3.6284D-01 , 
     &      3.5305D-01 , 3.4307D-01 , 3.3468D-01 , 3.2613D-01 , 
     &      3.1788D-01 , 3.1306D-01 , 3.1309D-01 , 3.1715D-01 , 
     &      3.2346D-01 , 3.3232D-01 , 3.4066D-01 , 3.4779D-01 , 
     &      3.5251D-01 , 3.5401D-01 , 3.5184D-01 , 3.4519D-01 , 
     &      3.3347D-01 , 3.1650D-01 , 2.9433D-01 , 2.6872D-01 , 
     &      3.6968D-01 , 3.7446D-01 , 3.8477D-01 , 4.0368D-01 , 
     &      4.3551D-01 , 4.8654D-01 , 5.6457D-01 , 6.8832D-01 , 
     &      8.9135D-01 , 1.2583D+00 , 2.0601D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 1.6499D+00 , 1.5928D+00 , 1.5356D+00 , 
     &      1.4773D+00 , 1.4202D+00 , 1.3601D+00 , 1.3009D+00 , 
     &      1.2413D+00 , 1.1836D+00 , 1.1235D+00 , 1.0650D+00 , 
     &      1.0076D+00 , 9.5212D-01 , 9.1919D-01 , 8.8569D-01 , 
     &      8.4733D-01 , 8.1006D-01 , 7.7436D-01 , 7.3955D-01 , 
     &      7.1104D-01 , 6.8173D-01 , 6.4966D-01 , 6.1893D-01 , 
     &      5.9026D-01 , 5.6287D-01 , 5.4114D-01 , 5.1941D-01 , 
     &      4.9621D-01 , 4.7490D-01 , 4.5564D-01 , 4.3786D-01 , 
     &      4.2408D-01 , 4.1024D-01 , 3.9562D-01 , 3.8175D-01 , 
     &      3.6853D-01 , 3.5541D-01 , 3.4455D-01 , 3.3366D-01 , 
     &      3.2286D-01 , 3.1565D-01 , 3.1397D-01 , 3.1618D-01 , 
     &      3.2069D-01 , 3.2744D-01 , 3.3383D-01 , 3.3911D-01 , 
     &      3.4194D-01 , 3.4194D-01 , 3.3844D-01/
      DATA (xudf_l(k),k=799,912)/3.3088D-01 , 3.1887D-01 , 3.0224D-01 , 
     &      2.8177D-01 , 2.5901D-01 , 3.4945D-01 , 3.5200D-01 , 
     &      3.5959D-01 , 3.7518D-01 , 4.0212D-01 , 4.4590D-01 , 
     &      5.1305D-01 , 6.1934D-01 , 7.9273D-01 , 1.1025D+00 , 
     &      1.7693D+00 , 0.0000D+00 , 0.0000D+00 , 2.0413D+00 , 
     &      1.9626D+00 , 1.8840D+00 , 1.8053D+00 , 1.7284D+00 , 
     &      1.6480D+00 , 1.5697D+00 , 1.4911D+00 , 1.4157D+00 , 
     &      1.3375D+00 , 1.2620D+00 , 1.1875D+00 , 1.1168D+00 , 
     &      1.0751D+00 , 1.0321D+00 , 9.8410D-01 , 9.3682D-01 , 
     &      8.9196D-01 , 8.4816D-01 , 8.1245D-01 , 7.7582D-01 , 
     &      7.3576D-01 , 6.9745D-01 , 6.6154D-01 , 6.2742D-01 , 
     &      6.0036D-01 , 5.7319D-01 , 5.4409D-01 , 5.1721D-01 , 
     &      4.9291D-01 , 4.7049D-01 , 4.5284D-01 , 4.3541D-01 , 
     &      4.1671D-01 , 3.9926D-01 , 3.8274D-01 , 3.6660D-01 , 
     &      3.5348D-01 , 3.4035D-01 , 3.2727D-01 , 3.1788D-01 , 
     &      3.1459D-01 , 3.1499D-01 , 3.1792D-01 , 3.2291D-01 , 
     &      3.2764D-01 , 3.3124D-01 , 3.3250D-01 , 3.3120D-01 , 
     &      3.2663D-01 , 3.1834D-01 , 3.0608D-01 , 2.8998D-01 , 
     &      2.7085D-01 , 2.5085D-01 , 3.3191D-01 , 3.3258D-01 , 
     &      3.3808D-01 , 3.5072D-01 , 3.7379D-01 , 4.1182D-01 , 
     &      4.7005D-01 , 5.6257D-01 , 7.1233D-01 , 9.7788D-01 , 
     &      1.5412D+00 , 0.0000D+00 , 0.0000D+00 , 2.6325D+00 , 
     &      2.5188D+00 , 2.4060D+00 , 2.2942D+00 , 2.1863D+00 , 
     &      2.0740D+00 , 1.9650D+00 , 1.8571D+00 , 1.7537D+00 , 
     &      1.6473D+00 , 1.5453D+00 , 1.4458D+00 , 1.3515D+00 , 
     &      1.2965D+00 , 1.2394D+00 , 1.1767D+00 , 1.1150D+00 , 
     &      1.0560D+00 , 9.9927D-01 , 9.5301D-01 , 9.0565D-01 , 
     &      8.5400D-01 , 8.0462D-01 , 7.5858D-01 , 7.1481D-01 , 
     &      6.7994D-01 , 6.4502D-01 , 6.0799D-01/
      DATA (xudf_l(k),k=913,1026)/5.7349D-01 , 5.4206D-01 , 5.1299D-01 , 
     &      4.9028D-01 , 4.6789D-01 , 4.4387D-01 , 4.2168D-01 , 
     &      4.0096D-01 , 3.8070D-01 , 3.6457D-01 , 3.4857D-01 , 
     &      3.3249D-01 , 3.2026D-01 , 3.1503D-01 , 3.1326D-01 , 
     &      3.1423D-01 , 3.1703D-01 , 3.1974D-01 , 3.2120D-01 , 
     &      3.2086D-01 , 3.1799D-01 , 3.1221D-01 , 3.0315D-01 , 
     &      2.9072D-01 , 2.7522D-01 , 2.5796D-01 , 2.4114D-01 , 
     &      3.1079D-01 , 3.0956D-01 , 3.1267D-01 , 3.2223D-01 , 
     &      3.4089D-01 , 3.7246D-01 , 4.2134D-01 , 4.9853D-01 , 
     &      6.2305D-01 , 8.4191D-01 , 1.2983D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 3.2997D+00 , 3.1427D+00 , 2.9900D+00 , 
     &      2.8374D+00 , 2.6927D+00 , 2.5421D+00 , 2.3973D+00 , 
     &      2.2549D+00 , 2.1191D+00 , 1.9809D+00 , 1.8488D+00 , 
     &      1.7209D+00 , 1.6001D+00 , 1.5300D+00 , 1.4576D+00 , 
     &      1.3771D+00 , 1.2999D+00 , 1.2268D+00 , 1.1551D+00 , 
     &      1.0975D+00 , 1.0385D+00 , 9.7437D-01 , 9.1327D-01 , 
     &      8.5649D-01 , 8.0236D-01 , 7.5952D-01 , 7.1667D-01 , 
     &      6.7091D-01 , 6.2847D-01 , 5.9005D-01 , 5.5422D-01 , 
     &      5.2636D-01 , 4.9890D-01 , 4.6976D-01 , 4.4269D-01 , 
     &      4.1752D-01 , 3.9377D-01 , 3.7477D-01 , 3.5594D-01 , 
     &      3.3710D-01 , 3.2226D-01 , 3.1511D-01 , 3.1131D-01 , 
     &      3.1067D-01 , 3.1132D-01 , 3.1227D-01 , 3.1198D-01 , 
     &      3.1021D-01 , 3.0606D-01 , 2.9926D-01 , 2.8958D-01 , 
     &      2.7716D-01 , 2.6233D-01 , 2.4655D-01 , 2.3275D-01 , 
     &      2.9229D-01 , 2.8941D-01 , 2.9061D-01 , 2.9753D-01 , 
     &      3.1273D-01 , 3.3909D-01 , 3.8034D-01 , 4.4548D-01 , 
     &      5.5028D-01 , 7.3256D-01 , 1.1074D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 4.0557D+00 , 3.8486D+00 , 3.6460D+00 , 
     &      3.4480D+00 , 3.2579D+00 , 3.0626D+00/
      DATA (xudf_l(k),k=1027,1140)/2.8756D+00 , 2.6929D+00 , 
     &      2.5196D+00 , 2.3441D+00 , 2.1778D+00 , 2.0170D+00 , 
     &      1.8670D+00 , 1.7797D+00 , 1.6902D+00 , 1.5909D+00 , 
     &      1.4960D+00 , 1.4058D+00 , 1.3191D+00 , 1.2484D+00 , 
     &      1.1764D+00 , 1.0991D+00 , 1.0253D+00 , 9.5689D-01 , 
     &      8.9197D-01 , 8.4046D-01 , 7.8904D-01 , 7.3442D-01 , 
     &      6.8367D-01 , 6.3780D-01 , 5.9520D-01 , 5.6218D-01 , 
     &      5.2934D-01 , 4.9500D-01 , 4.6300D-01 , 4.3370D-01 , 
     &      4.0611D-01 , 3.8431D-01 , 3.6284D-01 , 3.4121D-01 , 
     &      3.2389D-01 , 3.1494D-01 , 3.0926D-01 , 3.0697D-01 , 
     &      3.0594D-01 , 3.0501D-01 , 3.0330D-01 , 3.0019D-01 , 
     &      2.9492D-01 , 2.8734D-01 , 2.7718D-01 , 2.6476D-01 , 
     &      2.5057D-01 , 2.3646D-01 , 2.2503D-01 , 2.7558D-01 , 
     &      2.7132D-01 , 2.7089D-01 , 2.7569D-01 , 2.8794D-01 , 
     &      3.1000D-01 , 3.4491D-01 , 4.0016D-01 , 4.8886D-01 , 
     &      6.4191D-01 , 9.5232D-01 , 0.0000D+00 , 0.0000D+00 , 
     &      4.8799D+00 , 4.6116D+00 , 4.3560D+00 , 4.1035D+00 , 
     &      3.8608D+00 , 3.6163D+00 , 3.3822D+00 , 3.1557D+00 , 
     &      2.9412D+00 , 2.7247D+00 , 2.5209D+00 , 2.3248D+00 , 
     &      2.1421D+00 , 2.0368D+00 , 1.9287D+00 , 1.8094D+00 , 
     &      1.6955D+00 , 1.5877D+00 , 1.4841D+00 , 1.4003D+00 , 
     &      1.3154D+00 , 1.2237D+00 , 1.1368D+00 , 1.0563D+00 , 
     &      9.8015D-01 , 9.2005D-01 , 8.5978D-01 , 7.9615D-01 , 
     &      7.3715D-01 , 6.8369D-01 , 6.3441D-01 , 5.9609D-01 , 
     &      5.5830D-01 , 5.1865D-01 , 4.8192D-01 , 4.4872D-01 , 
     &      4.1747D-01 , 3.9300D-01 , 3.6895D-01 , 3.4483D-01 , 
     &      3.2508D-01 , 3.1459D-01 , 3.0709D-01 , 3.0328D-01 , 
     &      3.0056D-01 , 2.9840D-01 , 2.9543D-01 , 2.9107D-01 , 
     &      2.8485D-01 , 2.7655D-01 , 2.6610D-01 , 2.5368D-01/
      DATA (xudf_l(k),k=1141,1254)/2.4019D-01 , 2.2736D-01 , 
     &      2.1837D-01 , 2.6080D-01 , 2.5542D-01 , 2.5362D-01 , 
     &      2.5693D-01 , 2.6661D-01 , 2.8505D-01 , 3.1490D-01 , 
     &      3.6226D-01 , 4.3798D-01 , 5.6769D-01 , 8.2836D-01 , 
     &      0.0000D+00 , 0.0000D+00 , 5.8340D+00 , 5.4940D+00 , 
     &      5.1700D+00 , 4.8532D+00 , 4.5515D+00 , 4.2463D+00 , 
     &      3.9559D+00 , 3.6752D+00 , 3.4138D+00 , 3.1496D+00 , 
     &      2.9022D+00 , 2.6648D+00 , 2.4450D+00 , 2.3189D+00 , 
     &      2.1896D+00 , 2.0476D+00 , 1.9120D+00 , 1.7843D+00 , 
     &      1.6621D+00 , 1.5639D+00 , 1.4648D+00 , 1.3569D+00 , 
     &      1.2556D+00 , 1.1618D+00 , 1.0734D+00 , 1.0037D+00 , 
     &      9.3416D-01 , 8.6065D-01 , 7.9257D-01 , 7.3145D-01 , 
     &      6.7463D-01 , 6.3082D-01 , 5.8786D-01 , 5.4262D-01 , 
     &      5.0118D-01 , 4.6374D-01 , 4.2883D-01 , 4.0146D-01 , 
     &      3.7490D-01 , 3.4814D-01 , 3.2612D-01 , 3.1397D-01 , 
     &      3.0482D-01 , 2.9958D-01 , 2.9536D-01 , 2.9178D-01 , 
     &      2.8756D-01 , 2.8208D-01 , 2.7504D-01 , 2.6611D-01 , 
     &      2.5539D-01 , 2.4319D-01 , 2.3031D-01 , 2.1877D-01 , 
     &      2.1195D-01 , 2.4673D-01 , 2.4036D-01 , 2.3746D-01 , 
     &      2.3912D-01 , 2.4677D-01 , 2.6223D-01 , 2.8748D-01 , 
     &      3.2792D-01 , 3.9255D-01 , 5.0271D-01 , 7.2095D-01 , 
     &      0.0000D+00 , 0.0000D+00 , 6.8578D+00 , 6.4388D+00 , 
     &      6.0380D+00 , 5.6501D+00 , 5.2825D+00 , 4.9103D+00 , 
     &      4.5613D+00 , 4.2230D+00 , 3.9070D+00 , 3.5911D+00 , 
     &      3.2966D+00 , 3.0156D+00 , 2.7567D+00 , 2.6078D+00 , 
     &      2.4563D+00 , 2.2905D+00 , 2.1319D+00 , 1.9837D+00 , 
     &      1.8421D+00 , 1.7287D+00 , 1.6141D+00 , 1.4902D+00 , 
     &      1.3730D+00 , 1.2663D+00 , 1.1652D+00 , 1.0858D+00 , 
     &      1.0067D+00 , 9.2337D-01 , 8.4648D-01 , 7.7710D-01/
      DATA (xudf_l(k),k=1255,1368)/7.1333D-01 , 6.6392D-01 , 
     &      6.1566D-01 , 5.6531D-01 , 5.1904D-01 , 4.7761D-01 , 
     &      4.3908D-01 , 4.0927D-01 , 3.8022D-01 , 3.5109D-01 , 
     &      3.2686D-01 , 3.1318D-01 , 3.0244D-01 , 2.9602D-01 , 
     &      2.9031D-01 , 2.8538D-01 , 2.8024D-01 , 2.7382D-01 , 
     &      2.6607D-01 , 2.5668D-01 , 2.4571D-01 , 2.3364D-01 , 
     &      2.2155D-01 , 2.1116D-01 , 2.0617D-01 , 2.3421D-01 , 
     &      2.2704D-01 , 2.2320D-01 , 2.2366D-01 , 2.2952D-01 , 
     &      2.4241D-01 , 2.6402D-01 , 2.9884D-01 , 3.5437D-01 , 
     &      4.4860D-01 , 6.3331D-01 , 0.0000D+00 , 0.0000D+00 , 
     &      7.9784D+00 , 7.4673D+00 , 6.9820D+00 , 6.5121D+00 , 
     &      6.0712D+00 , 5.6250D+00 , 5.2080D+00 , 4.8065D+00 , 
     &      4.4309D+00 , 4.0590D+00 , 3.7131D+00 , 3.3843D+00 , 
     &      3.0816D+00 , 2.9094D+00 , 2.7332D+00 , 2.5420D+00 , 
     &      2.3595D+00 , 2.1895D+00 , 2.0271D+00 , 1.8966D+00 , 
     &      1.7658D+00 , 1.6248D+00 , 1.4933D+00 , 1.3718D+00 , 
     &      1.2579D+00 , 1.1683D+00 , 1.0795D+00 , 9.8589D-01 , 
     &      8.9996D-01 , 8.2253D-01 , 7.5153D-01 , 6.9648D-01 , 
     &      6.4287D-01 , 5.8736D-01 , 5.3655D-01 , 4.9109D-01 , 
     &      4.4891D-01 , 4.1655D-01 , 3.8518D-01 , 3.5367D-01 , 
     &      3.2738D-01 , 3.1221D-01 , 3.0006D-01 , 2.9246D-01 , 
     &      2.8544D-01 , 2.7940D-01 , 2.7319D-01 , 2.6601D-01 , 
     &      2.5763D-01 , 2.4782D-01 , 2.3676D-01 , 2.2486D-01 , 
     &      2.1329D-01 , 2.0405D-01 , 2.0083D-01 , 2.2267D-01 , 
     &      2.1489D-01 , 2.1027D-01 , 2.0967D-01 , 2.1409D-01 , 
     &      2.2473D-01 , 2.4320D-01 , 2.7316D-01 , 3.2113D-01 , 
     &      4.0209D-01 , 5.5899D-01 , 0.0000D+00 , 0.0000D+00 , 
     &      9.1575D+00 , 8.5458D+00 , 7.9700D+00 , 7.4123D+00 , 
     &      6.8876D+00 , 6.3653D+00 , 5.8736D+00 , 5.4042D+00/
      DATA (xudf_l(k),k=1369,1482)/4.9684D+00 , 4.5359D+00 , 
     &      4.1366D+00 , 3.7576D+00 , 3.4110D+00 , 3.2138D+00 , 
     &      3.0122D+00 , 2.7943D+00 , 2.5871D+00 , 2.3944D+00 , 
     &      2.2102D+00 , 2.0646D+00 , 1.9163D+00 , 1.7581D+00 , 
     &      1.6109D+00 , 1.4753D+00 , 1.3483D+00 , 1.2486D+00 , 
     &      1.1500D+00 , 1.0462D+00 , 9.5130D-01 , 8.6585D-01 , 
     &      7.8770D-01 , 7.2741D-01 , 6.6891D-01 , 6.0781D-01 , 
     &      5.5266D-01 , 5.0342D-01 , 4.5788D-01 , 4.2322D-01 , 
     &      3.8960D-01 , 3.5594D-01 , 3.2768D-01 , 3.1125D-01 , 
     &      2.9779D-01 , 2.8890D-01 , 2.8091D-01 , 2.7385D-01 , 
     &      2.6670D-01 , 2.5886D-01 , 2.4989D-01 , 2.3976D-01 , 
     &      2.2861D-01 , 2.1703D-01 , 2.0604D-01 , 1.9777D-01 , 
     &      1.9598D-01 , 2.1238D-01 , 2.0408D-01 , 1.9879D-01 , 
     &      1.9735D-01 , 2.0048D-01 , 2.0933D-01 , 2.2523D-01 , 
     &      2.5120D-01 , 2.9296D-01 , 3.6305D-01 , 4.9711D-01 , 
     &      0.0000D+00 , 0.0000D+00 , 1.0956D+01 , 1.0188D+01 , 
     &      9.4660D+00 , 8.7704D+00 , 8.1209D+00 , 7.4727D+00 , 
     &      6.8721D+00 , 6.2972D+00 , 5.7646D+00 , 5.2434D+00 , 
     &      4.7595D+00 , 4.3051D+00 , 3.8911D+00 , 3.6559D+00 , 
     &      3.4174D+00 , 3.1598D+00 , 2.9153D+00 , 2.6889D+00 , 
     &      2.4732D+00 , 2.3031D+00 , 2.1311D+00 , 1.9475D+00 , 
     &      1.7771D+00 , 1.6202D+00 , 1.4748D+00 , 1.3609D+00 , 
     &      1.2481D+00 , 1.1301D+00 , 1.0222D+00 , 9.2549D-01 , 
     &      8.3728D-01 , 7.6947D-01 , 7.0373D-01 , 6.3561D-01 , 
     &      5.7438D-01 , 5.1959D-01 , 4.6984D-01 , 4.3187D-01 , 
     &      3.9529D-01 , 3.5864D-01 , 3.2783D-01 , 3.0967D-01 , 
     &      2.9444D-01 , 2.8428D-01 , 2.7469D-01 , 2.6638D-01 , 
     &      2.5813D-01 , 2.4942D-01 , 2.3986D-01 , 2.2937D-01 , 
     &      2.1819D-01 , 2.0682D-01 , 1.9665D-01 , 1.8966D-01/
      DATA (xudf_l(k),k=1483,1596)/1.8971D-01 , 1.9926D-01 , 
     &      1.9036D-01 , 1.8442D-01 , 1.8192D-01 , 1.8362D-01 , 
     &      1.9037D-01 , 2.0318D-01 , 2.2459D-01 , 2.5904D-01 , 
     &      3.1665D-01 , 4.2407D-01 , 0.0000D+00 , 0.0000D+00 , 
     &      1.2798D+01 , 1.1861D+01 , 1.0986D+01 , 1.0144D+01 , 
     &      9.3643D+00 , 8.5887D+00 , 7.8706D+00 , 7.1866D+00 , 
     &      6.5568D+00 , 5.9419D+00 , 5.3754D+00 , 4.8419D+00 , 
     &      4.3593D+00 , 4.0864D+00 , 3.8109D+00 , 3.5127D+00 , 
     &      3.2315D+00 , 2.9714D+00 , 2.7252D+00 , 2.5309D+00 , 
     &      2.3356D+00 , 2.1269D+00 , 1.9338D+00 , 1.7578D+00 , 
     &      1.5939D+00 , 1.4656D+00 , 1.3394D+00 , 1.2075D+00 , 
     &      1.0875D+00 , 9.8023D-01 , 8.8256D-01 , 8.0772D-01 , 
     &      7.3533D-01 , 6.6054D-01 , 5.9364D-01 , 5.3423D-01 , 
     &      4.8009D-01 , 4.3930D-01 , 4.0003D-01 , 3.6079D-01 , 
     &      3.2768D-01 , 3.0809D-01 , 2.9130D-01 , 2.7993D-01 , 
     &      2.6898D-01 , 2.5976D-01 , 2.5062D-01 , 2.4123D-01 , 
     &      2.3116D-01 , 2.2040D-01 , 2.0917D-01 , 1.9814D-01 , 
     &      1.8865D-01 , 1.8272D-01 , 1.8428D-01 , 1.8820D-01 , 
     &      1.7883D-01 , 1.7238D-01 , 1.6914D-01 , 1.6979D-01 , 
     &      1.7482D-01 , 1.8534D-01 , 2.0325D-01 , 2.3214D-01 , 
     &      2.8022D-01 , 3.6659D-01 , 0.0000D+00 , 0.0000D+00 , 
     &      1.4900D+01 , 1.3767D+01 , 1.2708D+01 , 1.1700D+01 , 
     &      1.0766D+01 , 9.8403D+00 , 8.9832D+00 , 8.1757D+00 , 
     &      7.4366D+00 , 6.7121D+00 , 6.0486D+00 , 5.4300D+00 , 
     &      4.8704D+00 , 4.5555D+00 , 4.2371D+00 , 3.8955D+00 , 
     &      3.5734D+00 , 3.2760D+00 , 2.9952D+00 , 2.7738D+00 , 
     &      2.5528D+00 , 2.3175D+00 , 2.1001D+00 , 1.9012D+00 , 
     &      1.7176D+00 , 1.5750D+00 , 1.4344D+00 , 1.2880D+00 , 
     &      1.1547D+00 , 1.0364D+00 , 9.2859D-01 , 8.4652D-01/
      DATA (xudf_l(k),k=1597,1710)/7.6723D-01 , 6.8578D-01 , 
     &      6.1255D-01 , 5.4848D-01 , 4.9034D-01 , 4.4649D-01 , 
     &      4.0456D-01 , 3.6275D-01 , 3.2738D-01 , 3.0624D-01 , 
     &      2.8805D-01 , 2.7544D-01 , 2.6343D-01 , 2.5315D-01 , 
     &      2.4318D-01 , 2.3314D-01 , 2.2263D-01 , 2.1166D-01 , 
     &      2.0051D-01 , 1.8983D-01 , 1.8102D-01 , 1.7610D-01 , 
     &      1.7901D-01 , 1.7764D-01 , 1.6791D-01 , 1.6102D-01 , 
     &      1.5715D-01 , 1.5684D-01 , 1.6056D-01 , 1.6899D-01 , 
     &      1.8376D-01 , 2.0786D-01 , 2.4776D-01 , 3.1470D-01 , 
     &      0.0000D+00 , 0.0000D+00 , 1.7212D+01 , 1.5853D+01 , 
     &      1.4590D+01 , 1.3390D+01 , 1.2283D+01 , 1.1191D+01 , 
     &      1.0185D+01 , 9.2395D+00 , 8.3762D+00 , 7.5315D+00 , 
     &      6.7670D+00 , 6.0503D+00 , 5.4086D+00 , 5.0481D+00 , 
     &      4.6843D+00 , 4.2940D+00 , 3.9280D+00 , 3.5917D+00 , 
     &      3.2752D+00 , 3.0252D+00 , 2.7768D+00 , 2.5132D+00 , 
     &      2.2690D+00 , 2.0490D+00 , 1.8445D+00 , 1.6857D+00 , 
     &      1.5301D+00 , 1.3685D+00 , 1.2219D+00 , 1.0920D+00 , 
     &      9.7438D-01 , 8.8478D-01 , 7.9825D-01 , 7.1007D-01 , 
     &      6.3111D-01 , 5.6196D-01 , 5.0016D-01 , 4.5321D-01 , 
     &      4.0867D-01 , 3.6435D-01 , 3.2686D-01 , 3.0431D-01 , 
     &      2.8470D-01 , 2.7109D-01 , 2.5789D-01 , 2.4674D-01 , 
     &      2.3605D-01 , 2.2547D-01 , 2.1459D-01 , 2.0348D-01 , 
     &      1.9237D-01 , 1.8201D-01 , 1.7376D-01 , 1.6982D-01 , 
     &      1.7398D-01 , 1.6789D-01 , 1.5795D-01 , 1.5065D-01 , 
     &      1.4630D-01 , 1.4521D-01 , 1.4773D-01 , 1.5443D-01 , 
     &      1.6659D-01 , 1.8664D-01 , 2.1966D-01 , 2.6878D-01 , 
     &      0.0000D+00 , 0.0000D+00 , 1.9526D+01 , 1.7951D+01 , 
     &      1.6470D+01 , 1.5074D+01 , 1.3790D+01 , 1.2527D+01 , 
     &      1.1370D+01 , 1.0282D+01 , 9.2958D+00 , 8.3330D+00/
      DATA (xudf_l(k),k=1711,1824)/7.4603D+00 , 6.6536D+00 , 
     &      5.9285D+00 , 5.5219D+00 , 5.1141D+00 , 4.6768D+00 , 
     &      4.2681D+00 , 3.8926D+00 , 3.5402D+00 , 3.2626D+00 , 
     &      2.9882D+00 , 2.6963D+00 , 2.4284D+00 , 2.1851D+00 , 
     &      1.9619D+00 , 1.7885D+00 , 1.6187D+00 , 1.4429D+00 , 
     &      1.2838D+00 , 1.1431D+00 , 1.0159D+00 , 9.1924D-01 , 
     &      8.2663D-01 , 7.3180D-01 , 6.4793D-01 , 5.7429D-01 , 
     &      5.0828D-01 , 4.5904D-01 , 4.1215D-01 , 3.6558D-01 , 
     &      3.2620D-01 , 3.0238D-01 , 2.8167D-01 , 2.6700D-01 , 
     &      2.5302D-01 , 2.4098D-01 , 2.2975D-01 , 2.1873D-01 , 
     &      2.0756D-01 , 1.9633D-01 , 1.8532D-01 , 1.7533D-01 , 
     &      1.6763D-01 , 1.6450D-01 , 1.6959D-01 , 1.5953D-01 , 
     &      1.4943D-01 , 1.4185D-01 , 1.3716D-01 , 1.3545D-01 , 
     &      1.3705D-01 , 1.4238D-01 , 1.5258D-01 , 1.6945D-01 , 
     &      1.9705D-01 , 2.3049D-01 , 0.0000D+00 , 0.0000D+00 , 
     &      2.2141D+01 , 2.0286D+01 , 1.8570D+01 , 1.6948D+01 , 
     &      1.5466D+01 , 1.4010D+01 , 1.2679D+01 , 1.1431D+01 , 
     &      1.0303D+01 , 9.2106D+00 , 8.2239D+00 , 7.3077D+00 , 
     &      6.4926D+00 , 6.0348D+00 , 5.5765D+00 , 5.0879D+00 , 
     &      4.6321D+00 , 4.2138D+00 , 3.8233D+00 , 3.5162D+00 , 
     &      3.2122D+00 , 2.8907D+00 , 2.5960D+00 , 2.3300D+00 , 
     &      2.0856D+00 , 1.8954D+00 , 1.7110D+00 , 1.5199D+00 , 
     &      1.3476D+00 , 1.1955D+00 , 1.0584D+00 , 9.5478D-01 , 
     &      8.5531D-01 , 7.5417D-01 , 6.6439D-01 , 5.8623D-01 , 
     &      5.1682D-01 , 4.6468D-01 , 4.1541D-01 , 3.6662D-01 , 
     &      3.2538D-01 , 3.0035D-01 , 2.7843D-01 , 2.6291D-01 , 
     &      2.4798D-01 , 2.3522D-01 , 2.2346D-01 , 2.1203D-01 , 
     &      2.0062D-01 , 1.8935D-01 , 1.7843D-01 , 1.6874D-01 , 
     &      1.6163D-01 , 1.5920D-01 , 1.6520D-01 , 1.5147D-01/
      DATA (xudf_l(k),k=1825,1836)/1.4120D-01 , 1.3349D-01 , 
     &      1.2844D-01 , 1.2620D-01 , 1.2701D-01 , 1.3118D-01 , 
     &      1.3954D-01 , 1.5369D-01 , 1.7631D-01 , 1.9416D-01 , 
     &      0.0000D+00 , 0.0000D+00/
      DATA (xsf_l(k),k=1,114)/8.9277D-03 , 9.2838D-03 , 9.6380D-03 , 
     &      9.9960D-03 , 1.0349D-02 , 1.0719D-02 , 1.1082D-02 , 
     &      1.1442D-02 , 1.1792D-02 , 1.2148D-02 , 1.2489D-02 , 
     &      1.2817D-02 , 1.3124D-02 , 1.3295D-02 , 1.3474D-02 , 
     &      1.3661D-02 , 1.3835D-02 , 1.3985D-02 , 1.4121D-02 , 
     &      1.4217D-02 , 1.4303D-02 , 1.4379D-02 , 1.4419D-02 , 
     &      1.4434D-02 , 1.4412D-02 , 1.4366D-02 , 1.4286D-02 , 
     &      1.4158D-02 , 1.3991D-02 , 1.3790D-02 , 1.3553D-02 , 
     &      1.3335D-02 , 1.3094D-02 , 1.2821D-02 , 1.2580D-02 , 
     &      1.2410D-02 , 1.2357D-02 , 1.2459D-02 , 1.2790D-02 , 
     &      1.3571D-02 , 1.5018D-02 , 1.6665D-02 , 1.9113D-02 , 
     &      2.1832D-02 , 2.5587D-02 , 2.9818D-02 , 3.4535D-02 , 
     &      3.9813D-02 , 4.5737D-02 , 5.2358D-02 , 5.9765D-02 , 
     &      6.8021D-02 , 7.7185D-02 , 8.7258D-02 , 9.8198D-02 , 
     &      1.1073D-01 , 1.4216D-01 , 1.8364D-01 , 2.3959D-01 , 
     &      3.1758D-01 , 4.3050D-01 , 6.0203D-01 , 8.8214D-01 , 
     &      1.3845D+00 , 2.4294D+00 , 5.2463D+00 , 1.8903D+01 , 
     &      0.0000D+00 , 1.4987D-02 , 1.5468D-02 , 1.5936D-02 , 
     &      1.6403D-02 , 1.6855D-02 , 1.7319D-02 , 1.7760D-02 , 
     &      1.8194D-02 , 1.8600D-02 , 1.9008D-02 , 1.9382D-02 , 
     &      1.9730D-02 , 2.0033D-02 , 2.0199D-02 , 2.0359D-02 , 
     &      2.0523D-02 , 2.0654D-02 , 2.0760D-02 , 2.0831D-02 , 
     &      2.0870D-02 , 2.0886D-02 , 2.0858D-02 , 2.0798D-02 , 
     &      2.0680D-02 , 2.0523D-02 , 2.0363D-02 , 2.0127D-02 , 
     &      1.9825D-02 , 1.9464D-02 , 1.9060D-02 , 1.8607D-02 , 
     &      1.8200D-02 , 1.7750D-02 , 1.7240D-02 , 1.6759D-02 , 
     &      1.6362D-02 , 1.6103D-02 , 1.6050D-02 , 1.6240D-02 , 
     &      1.6916D-02 , 1.8336D-02 , 2.0030D-02 , 2.2586D-02 , 
     &      2.5447D-02 , 2.9418D-02 , 3.3874D-02/
      DATA (xsf_l(k),k=115,228)/3.8821D-02 , 4.4375D-02 , 5.0509D-02 , 
     &      5.7343D-02 , 6.4974D-02 , 7.3385D-02 , 8.2640D-02 , 
     &      9.2732D-02 , 1.0354D-01 , 1.1667D-01 , 1.4809D-01 , 
     &      1.8910D-01 , 2.4387D-01 , 3.1940D-01 , 4.2764D-01 , 
     &      5.9054D-01 , 8.5228D-01 , 1.3150D+00 , 2.2623D+00 , 
     &      4.7596D+00 , 1.6445D+01 , 0.0000D+00 , 2.5010D-02 , 
     &      2.5616D-02 , 2.6180D-02 , 2.6758D-02 , 2.7279D-02 , 
     &      2.7792D-02 , 2.8274D-02 , 2.8729D-02 , 2.9134D-02 , 
     &      2.9513D-02 , 2.9836D-02 , 3.0110D-02 , 3.0324D-02 , 
     &      3.0417D-02 , 3.0492D-02 , 3.0537D-02 , 3.0551D-02 , 
     &      3.0517D-02 , 3.0432D-02 , 3.0326D-02 , 3.0181D-02 , 
     &      2.9954D-02 , 2.9663D-02 , 2.9316D-02 , 2.8913D-02 , 
     &      2.8508D-02 , 2.8021D-02 , 2.7422D-02 , 2.6741D-02 , 
     &      2.5997D-02 , 2.5204D-02 , 2.4500D-02 , 2.3734D-02 , 
     &      2.2858D-02 , 2.2019D-02 , 2.1281D-02 , 2.0698D-02 , 
     &      2.0402D-02 , 2.0365D-02 , 2.0844D-02 , 2.2137D-02 , 
     &      2.3807D-02 , 2.6404D-02 , 2.9338D-02 , 3.3433D-02 , 
     &      3.8036D-02 , 4.3135D-02 , 4.8799D-02 , 5.5061D-02 , 
     &      6.1999D-02 , 6.9633D-02 , 7.8024D-02 , 8.7156D-02 , 
     &      9.6998D-02 , 1.0742D-01 , 1.2099D-01 , 1.5162D-01 , 
     &      1.9121D-01 , 2.4363D-01 , 3.1510D-01 , 4.1638D-01 , 
     &      5.6669D-01 , 8.0557D-01 , 1.2216D+00 , 2.0572D+00 , 
     &      4.2084D+00 , 1.3911D+01 , 0.0000D+00 , 4.2554D-02 , 
     &      4.3210D-02 , 4.3820D-02 , 4.4379D-02 , 4.4862D-02 , 
     &      4.5317D-02 , 4.5708D-02 , 4.6037D-02 , 4.6300D-02 , 
     &      4.6434D-02 , 4.6540D-02 , 4.6530D-02 , 4.6426D-02 , 
     &      4.6317D-02 , 4.6155D-02 , 4.5919D-02 , 4.5622D-02 , 
     &      4.5267D-02 , 4.4833D-02 , 4.4425D-02 , 4.3932D-02 , 
     &      4.3298D-02 , 4.2582D-02 , 4.1785D-02/
      DATA (xsf_l(k),k=229,342)/4.0903D-02 , 4.0097D-02 , 3.9179D-02 , 
     &      3.8047D-02 , 3.6815D-02 , 3.5547D-02 , 3.4199D-02 , 
     &      3.3020D-02 , 3.1748D-02 , 3.0298D-02 , 2.8905D-02 , 
     &      2.7644D-02 , 2.6563D-02 , 2.5882D-02 , 2.5485D-02 , 
     &      2.5614D-02 , 2.6651D-02 , 2.8199D-02 , 3.0731D-02 , 
     &      3.3652D-02 , 3.7768D-02 , 4.2390D-02 , 4.7530D-02 , 
     &      5.3188D-02 , 5.9436D-02 , 6.6257D-02 , 7.3734D-02 , 
     &      8.1918D-02 , 9.0696D-02 , 1.0004D-01 , 1.0978D-01 , 
     &      1.2357D-01 , 1.5274D-01 , 1.8999D-01 , 2.3888D-01 , 
     &      3.0452D-01 , 3.9656D-01 , 5.3136D-01 , 7.4246D-01 , 
     &      1.1043D+00 , 1.8158D+00 , 3.6023D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 7.3602D-02 , 7.4085D-02 , 7.4460D-02 , 
     &      7.4729D-02 , 7.4904D-02 , 7.4982D-02 , 7.4902D-02 , 
     &      7.4713D-02 , 7.4446D-02 , 7.3972D-02 , 7.3397D-02 , 
     &      7.2626D-02 , 7.1803D-02 , 7.1200D-02 , 7.0479D-02 , 
     &      6.9610D-02 , 6.8654D-02 , 6.7624D-02 , 6.6495D-02 , 
     &      6.5467D-02 , 6.4313D-02 , 6.2898D-02 , 6.1380D-02 , 
     &      5.9788D-02 , 5.8079D-02 , 5.6557D-02 , 5.4876D-02 , 
     &      5.2866D-02 , 5.0733D-02 , 4.8592D-02 , 4.6341D-02 , 
     &      4.4415D-02 , 4.2370D-02 , 4.0073D-02 , 3.7825D-02 , 
     &      3.5778D-02 , 3.3956D-02 , 3.2702D-02 , 3.1749D-02 , 
     &      3.1334D-02 , 3.1922D-02 , 3.3216D-02 , 3.5534D-02 , 
     &      3.8322D-02 , 4.2321D-02 , 4.6830D-02 , 5.1816D-02 , 
     &      5.7335D-02 , 6.3369D-02 , 6.9947D-02 , 7.7109D-02 , 
     &      8.4752D-02 , 9.2948D-02 , 1.0153D-01 , 1.1031D-01 , 
     &      1.2405D-01 , 1.5100D-01 , 1.8509D-01 , 2.2905D-01 , 
     &      2.8761D-01 , 3.6847D-01 , 4.8537D-01 , 6.6543D-01 , 
     &      9.6831D-01 , 1.5524D+00 , 2.9766D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 1.1509D-01 , 1.1500D-01/
      DATA (xsf_l(k),k=343,456)/1.1474D-01 , 1.1430D-01 , 1.1371D-01 , 
     &      1.1292D-01 , 1.1196D-01 , 1.1079D-01 , 1.0948D-01 , 
     &      1.0791D-01 , 1.0620D-01 , 1.0426D-01 , 1.0215D-01 , 
     &      1.0076D-01 , 9.9224D-02 , 9.7466D-02 , 9.5472D-02 , 
     &      9.3507D-02 , 9.1346D-02 , 8.9460D-02 , 8.7382D-02 , 
     &      8.4914D-02 , 8.2326D-02 , 7.9663D-02 , 7.6874D-02 , 
     &      7.4459D-02 , 7.1794D-02 , 6.8694D-02 , 6.5489D-02 , 
     &      6.2266D-02 , 5.8964D-02 , 5.6164D-02 , 5.3226D-02 , 
     &      4.9916D-02 , 4.6721D-02 , 4.3794D-02 , 4.1128D-02 , 
     &      3.9225D-02 , 3.7654D-02 , 3.6613D-02 , 3.6666D-02 , 
     &      3.7626D-02 , 3.9655D-02 , 4.2227D-02 , 4.6000D-02 , 
     &      5.0288D-02 , 5.5044D-02 , 6.0308D-02 , 6.6020D-02 , 
     &      7.2218D-02 , 7.8943D-02 , 8.6079D-02 , 9.3611D-02 , 
     &      1.0141D-01 , 1.0925D-01 , 1.2274D-01 , 1.4748D-01 , 
     &      1.7840D-01 , 2.1791D-01 , 2.6997D-01 , 3.4109D-01 , 
     &      4.4280D-01 , 5.9706D-01 , 8.5325D-01 , 1.3371D+00 , 
     &      2.4909D+00 , 0.0000D+00 , 0.0000D+00 , 1.8131D-01 , 
     &      1.7986D-01 , 1.7802D-01 , 1.7597D-01 , 1.7372D-01 , 
     &      1.7110D-01 , 1.6825D-01 , 1.6515D-01 , 1.6187D-01 , 
     &      1.5820D-01 , 1.5428D-01 , 1.5016D-01 , 1.4582D-01 , 
     &      1.4314D-01 , 1.4017D-01 , 1.3677D-01 , 1.3315D-01 , 
     &      1.2951D-01 , 1.2571D-01 , 1.2248D-01 , 1.1891D-01 , 
     &      1.1472D-01 , 1.1045D-01 , 1.0615D-01 , 1.0173D-01 , 
     &      9.7944D-02 , 9.3854D-02 , 8.9131D-02 , 8.4347D-02 , 
     &      7.9597D-02 , 7.4799D-02 , 7.0788D-02 , 6.6599D-02 , 
     &      6.1932D-02 , 5.7438D-02 , 5.3307D-02 , 4.9546D-02 , 
     &      4.6816D-02 , 4.4417D-02 , 4.2536D-02 , 4.1862D-02 , 
     &      4.2361D-02 , 4.3960D-02 , 4.6198D-02 , 4.9612D-02 , 
     &      5.3553D-02 , 5.7974D-02 , 6.2830D-02/
      DATA (xsf_l(k),k=457,570)/6.8141D-02 , 7.3865D-02 , 7.9970D-02 , 
     &      8.6422D-02 , 9.3160D-02 , 1.0006D-01 , 1.0685D-01 , 
     &      1.1989D-01 , 1.4199D-01 , 1.6937D-01 , 2.0407D-01 , 
     &      2.4925D-01 , 3.1029D-01 , 3.9635D-01 , 5.2529D-01 , 
     &      7.3579D-01 , 1.1263D+00 , 2.0347D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 2.6278D-01 , 2.5883D-01 , 2.5460D-01 , 
     &      2.5007D-01 , 2.4526D-01 , 2.3995D-01 , 2.3437D-01 , 
     &      2.2848D-01 , 2.2242D-01 , 2.1578D-01 , 2.0894D-01 , 
     &      2.0181D-01 , 1.9465D-01 , 1.9018D-01 , 1.8540D-01 , 
     &      1.7984D-01 , 1.7415D-01 , 1.6846D-01 , 1.6261D-01 , 
     &      1.5768D-01 , 1.5234D-01 , 1.4615D-01 , 1.3987D-01 , 
     &      1.3368D-01 , 1.2736D-01 , 1.2199D-01 , 1.1628D-01 , 
     &      1.0975D-01 , 1.0321D-01 , 9.6788D-02 , 9.0380D-02 , 
     &      8.5059D-02 , 7.9532D-02 , 7.3436D-02 , 6.7594D-02 , 
     &      6.2243D-02 , 5.7363D-02 , 5.3720D-02 , 5.0502D-02 , 
     &      4.7772D-02 , 4.6346D-02 , 4.6358D-02 , 4.7497D-02 , 
     &      4.9377D-02 , 5.2401D-02 , 5.5965D-02 , 6.0009D-02 , 
     &      6.4489D-02 , 6.9334D-02 , 7.4546D-02 , 8.0117D-02 , 
     &      8.5936D-02 , 9.1972D-02 , 9.8056D-02 , 1.0398D-01 , 
     &      1.1644D-01 , 1.3628D-01 , 1.6068D-01 , 1.9127D-01 , 
     &      2.3085D-01 , 2.8377D-01 , 3.5756D-01 , 4.6698D-01 , 
     &      6.4315D-01 , 9.6485D-01 , 1.6969D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 3.6944D-01 , 3.6187D-01 , 3.5380D-01 , 
     &      3.4525D-01 , 3.3659D-01 , 3.2716D-01 , 3.1761D-01 , 
     &      3.0767D-01 , 2.9759D-01 , 2.8675D-01 , 2.7586D-01 , 
     &      2.6462D-01 , 2.5339D-01 , 2.4660D-01 , 2.3933D-01 , 
     &      2.3101D-01 , 2.2257D-01 , 2.1415D-01 , 2.0571D-01 , 
     &      1.9854D-01 , 1.9083D-01 , 1.8216D-01 , 1.7338D-01 , 
     &      1.6480D-01 , 1.5613D-01 , 1.4885D-01/
      DATA (xsf_l(k),k=571,684)/1.4115D-01 , 1.3244D-01 , 1.2380D-01 , 
     &      1.1542D-01 , 1.0713D-01 , 1.0031D-01 , 9.3226D-02 , 
     &      8.5515D-02 , 7.8171D-02 , 7.1449D-02 , 6.5307D-02 , 
     &      6.0723D-02 , 5.6523D-02 , 5.2878D-02 , 5.0622D-02 , 
     &      5.0109D-02 , 5.0720D-02 , 5.2187D-02 , 5.4770D-02 , 
     &      5.7950D-02 , 6.1582D-02 , 6.5595D-02 , 6.9997D-02 , 
     &      7.4716D-02 , 7.9677D-02 , 8.4886D-02 , 9.0221D-02 , 
     &      9.5543D-02 , 1.0065D-01 , 1.1245D-01 , 1.3012D-01 , 
     &      1.5166D-01 , 1.7859D-01 , 2.1305D-01 , 2.5881D-01 , 
     &      3.2188D-01 , 4.1454D-01 , 5.6186D-01 , 8.2718D-01 , 
     &      1.4188D+00 , 0.0000D+00 , 0.0000D+00 , 4.9195D-01 , 
     &      4.7916D-01 , 4.6620D-01 , 4.5277D-01 , 4.3908D-01 , 
     &      4.2463D-01 , 4.0985D-01 , 3.9491D-01 , 3.7975D-01 , 
     &      3.6377D-01 , 3.4790D-01 , 3.3178D-01 , 3.1592D-01 , 
     &      3.0640D-01 , 2.9622D-01 , 2.8462D-01 , 2.7303D-01 , 
     &      2.6160D-01 , 2.5012D-01 , 2.4047D-01 , 2.3023D-01 , 
     &      2.1867D-01 , 2.0717D-01 , 1.9597D-01 , 1.8477D-01 , 
     &      1.7546D-01 , 1.6568D-01 , 1.5468D-01 , 1.4387D-01 , 
     &      1.3343D-01 , 1.2319D-01 , 1.1482D-01 , 1.0622D-01 , 
     &      9.6828D-02 , 8.7978D-02 , 7.9884D-02 , 7.2526D-02 , 
     &      6.6973D-02 , 6.1948D-02 , 5.7359D-02 , 5.4304D-02 , 
     &      5.3263D-02 , 5.3381D-02 , 5.4456D-02 , 5.6601D-02 , 
     &      5.9380D-02 , 6.2613D-02 , 6.6252D-02 , 7.0174D-02 , 
     &      7.4432D-02 , 7.8943D-02 , 8.3559D-02 , 8.8282D-02 , 
     &      9.2963D-02 , 9.7382D-02 , 1.0858D-01 , 1.2441D-01 , 
     &      1.4363D-01 , 1.6745D-01 , 1.9778D-01 , 2.3771D-01 , 
     &      2.9246D-01 , 3.7200D-01 , 4.9738D-01 , 7.2010D-01 , 
     &      1.2083D+00 , 0.0000D+00 , 0.0000D+00 , 6.4521D-01 , 
     &      6.2534D-01 , 6.0540D-01 , 5.8499D-01/
      DATA (xsf_l(k),k=685,798)/5.6467D-01 , 5.4301D-01 , 5.2143D-01 , 
     &      4.9951D-01 , 4.7813D-01 , 4.5538D-01 , 4.3325D-01 , 
     &      4.1083D-01 , 3.8899D-01 , 3.7591D-01 , 3.6210D-01 , 
     &      3.4648D-01 , 3.3091D-01 , 3.1578D-01 , 3.0062D-01 , 
     &      2.8797D-01 , 2.7469D-01 , 2.5979D-01 , 2.4501D-01 , 
     &      2.3066D-01 , 2.1649D-01 , 2.0481D-01 , 1.9252D-01 , 
     &      1.7884D-01 , 1.6549D-01 , 1.5274D-01 , 1.4029D-01 , 
     &      1.3018D-01 , 1.1985D-01 , 1.0865D-01 , 9.8135D-02 , 
     &      8.8550D-02 , 7.9829D-02 , 7.3318D-02 , 6.7269D-02 , 
     &      6.1748D-02 , 5.7838D-02 , 5.6250D-02 , 5.5826D-02 , 
     &      5.6474D-02 , 5.8181D-02 , 6.0533D-02 , 6.3373D-02 , 
     &      6.6563D-02 , 7.0085D-02 , 7.3865D-02 , 7.7842D-02 , 
     &      8.1937D-02 , 8.6092D-02 , 9.0169D-02 , 9.3962D-02 , 
     &      1.0448D-01 , 1.1858D-01 , 1.3561D-01 , 1.5663D-01 , 
     &      1.8318D-01 , 2.1803D-01 , 2.6529D-01 , 3.3349D-01 , 
     &      4.3985D-01 , 6.2661D-01 , 1.0291D+00 , 0.0000D+00 , 
     &      0.0000D+00 , 8.2462D-01 , 7.9558D-01 , 7.6680D-01 , 
     &      7.3764D-01 , 7.0860D-01 , 6.7834D-01 , 6.4822D-01 , 
     &      6.1798D-01 , 5.8880D-01 , 5.5792D-01 , 5.2800D-01 , 
     &      4.9801D-01 , 4.6912D-01 , 4.5197D-01 , 4.3393D-01 , 
     &      4.1360D-01 , 3.9348D-01 , 3.7394D-01 , 3.5462D-01 , 
     &      3.3856D-01 , 3.2180D-01 , 3.0303D-01 , 2.8460D-01 , 
     &      2.6681D-01 , 2.4932D-01 , 2.3502D-01 , 2.2005D-01 , 
     &      2.0359D-01 , 1.8747D-01 , 1.7224D-01 , 1.5746D-01 , 
     &      1.4551D-01 , 1.3337D-01 , 1.2028D-01 , 1.0805D-01 , 
     &      9.6986D-02 , 8.6877D-02 , 7.9334D-02 , 7.2326D-02 , 
     &      6.5799D-02 , 6.1060D-02 , 5.8911D-02 , 5.7957D-02 , 
     &      5.8189D-02 , 5.9441D-02 , 6.1387D-02 , 6.3834D-02 , 
     &      6.6632D-02 , 6.9732D-02 , 7.3070D-02/
      DATA (xsf_l(k),k=799,912)/7.6595D-02 , 8.0190D-02 , 8.3816D-02 , 
     &      8.7358D-02 , 9.0631D-02 , 1.0046D-01 , 1.1304D-01 , 
     &      1.2815D-01 , 1.4670D-01 , 1.7006D-01 , 2.0049D-01 , 
     &      2.4154D-01 , 3.0039D-01 , 3.9121D-01 , 5.4894D-01 , 
     &      8.8378D-01 , 0.0000D+00 , 0.0000D+00 , 1.0199D+00 , 
     &      9.8025D-01 , 9.4100D-01 , 9.0151D-01 , 8.6283D-01 , 
     &      8.2243D-01 , 7.8262D-01 , 7.4321D-01 , 7.0465D-01 , 
     &      6.6494D-01 , 6.2647D-01 , 5.8811D-01 , 5.5152D-01 , 
     &      5.2985D-01 , 5.0721D-01 , 4.8183D-01 , 4.5681D-01 , 
     &      4.3274D-01 , 4.0883D-01 , 3.8916D-01 , 3.6878D-01 , 
     &      3.4589D-01 , 3.2366D-01 , 3.0238D-01 , 2.8152D-01 , 
     &      2.6437D-01 , 2.4685D-01 , 2.2733D-01 , 2.0858D-01 , 
     &      1.9085D-01 , 1.7375D-01 , 1.6000D-01 , 1.4607D-01 , 
     &      1.3115D-01 , 1.1722D-01 , 1.0469D-01 , 9.3284D-02 , 
     &      8.4739D-02 , 7.6803D-02 , 6.9420D-02 , 6.3844D-02 , 
     &      6.1178D-02 , 5.9720D-02 , 5.9561D-02 , 6.0398D-02 , 
     &      6.1984D-02 , 6.4051D-02 , 6.6494D-02 , 6.9202D-02 , 
     &      7.2161D-02 , 7.5274D-02 , 7.8453D-02 , 8.1651D-02 , 
     &      8.4728D-02 , 8.7564D-02 , 9.6777D-02 , 1.0806D-01 , 
     &      1.2157D-01 , 1.3806D-01 , 1.5882D-01 , 1.8566D-01 , 
     &      2.2170D-01 , 2.7301D-01 , 3.5168D-01 , 4.8696D-01 , 
     &      7.7010D-01 , 0.0000D+00 , 0.0000D+00 , 1.3158D+00 , 
     &      1.2585D+00 , 1.2024D+00 , 1.1462D+00 , 1.0919D+00 , 
     &      1.0352D+00 , 9.8042D-01 , 9.2608D-01 , 8.7345D-01 , 
     &      8.1987D-01 , 7.6814D-01 , 7.1724D-01 , 6.6882D-01 , 
     &      6.4053D-01 , 6.1093D-01 , 5.7796D-01 , 5.4572D-01 , 
     &      5.1470D-01 , 4.8433D-01 , 4.5934D-01 , 4.3358D-01 , 
     &      4.0495D-01 , 3.7717D-01 , 3.5082D-01 , 3.2513D-01 , 
     &      3.0408D-01 , 2.8258D-01 , 2.5918D-01/
      DATA (xsf_l(k),k=913,1026)/2.3648D-01 , 2.1538D-01 , 1.9510D-01 , 
     &      1.7888D-01 , 1.6255D-01 , 1.4508D-01 , 1.2895D-01 , 
     &      1.1443D-01 , 1.0131D-01 , 9.1507D-02 , 8.2387D-02 , 
     &      7.3778D-02 , 6.7147D-02 , 6.3813D-02 , 6.1721D-02 , 
     &      6.1065D-02 , 6.1373D-02 , 6.2475D-02 , 6.4105D-02 , 
     &      6.6079D-02 , 6.8362D-02 , 7.0856D-02 , 7.3440D-02 , 
     &      7.6143D-02 , 7.8812D-02 , 8.1388D-02 , 8.3726D-02 , 
     &      9.2167D-02 , 1.0190D-01 , 1.1355D-01 , 1.2780D-01 , 
     &      1.4554D-01 , 1.6841D-01 , 1.9900D-01 , 2.4223D-01 , 
     &      3.0775D-01 , 4.1920D-01 , 6.4849D-01 , 0.0000D+00 , 
     &      0.0000D+00 , 1.6483D+00 , 1.5703D+00 , 1.4940D+00 , 
     &      1.4180D+00 , 1.3449D+00 , 1.2694D+00 , 1.1966D+00 , 
     &      1.1250D+00 , 1.0566D+00 , 9.8644D-01 , 9.1985D-01 , 
     &      8.5482D-01 , 7.9312D-01 , 7.5722D-01 , 7.1986D-01 , 
     &      6.7849D-01 , 6.3821D-01 , 5.9972D-01 , 5.6214D-01 , 
     &      5.3143D-01 , 4.9987D-01 , 4.6500D-01 , 4.3136D-01 , 
     &      3.9956D-01 , 3.6875D-01 , 3.4379D-01 , 3.1832D-01 , 
     &      2.9044D-01 , 2.6397D-01 , 2.3923D-01 , 2.1580D-01 , 
     &      1.9706D-01 , 1.7829D-01 , 1.5838D-01 , 1.3999D-01 , 
     &      1.2356D-01 , 1.0875D-01 , 9.7664D-02 , 8.7392D-02 , 
     &      7.7645D-02 , 7.0035D-02 , 6.6062D-02 , 6.3365D-02 , 
     &      6.2239D-02 , 6.2062D-02 , 6.2731D-02 , 6.3942D-02 , 
     &      6.5526D-02 , 6.7390D-02 , 6.9436D-02 , 7.1635D-02 , 
     &      7.3891D-02 , 7.6122D-02 , 7.8246D-02 , 8.0196D-02 , 
     &      8.7884D-02 , 9.6357D-02 , 1.0648D-01 , 1.1880D-01 , 
     &      1.3413D-01 , 1.5386D-01 , 1.7993D-01 , 2.1655D-01 , 
     &      2.7189D-01 , 3.6486D-01 , 5.5332D-01 , 0.0000D+00 , 
     &      0.0000D+00 , 2.0271D+00 , 1.9234D+00 , 1.8224D+00 , 
     &      1.7226D+00 , 1.6272D+00 , 1.5293D+00/
      DATA (xsf_l(k),k=1027,1140)/1.4356D+00 , 1.3438D+00 , 1.2568D+00 , 
     &      1.1682D+00 , 1.0841D+00 , 1.0026D+00 , 9.2625D-01 , 
     &      8.8207D-01 , 8.3568D-01 , 7.8523D-01 , 7.3607D-01 , 
     &      6.8926D-01 , 6.4385D-01 , 6.0685D-01 , 5.6892D-01 , 
     &      5.2730D-01 , 4.8731D-01 , 4.4961D-01 , 4.1331D-01 , 
     &      3.8417D-01 , 3.5441D-01 , 3.2210D-01 , 2.9168D-01 , 
     &      2.6323D-01 , 2.3631D-01 , 2.1500D-01 , 1.9374D-01 , 
     &      1.7129D-01 , 1.5067D-01 , 1.3231D-01 , 1.1579D-01 , 
     &      1.0349D-01 , 9.2080D-02 , 8.1205D-02 , 7.2626D-02 , 
     &      6.8039D-02 , 6.4761D-02 , 6.3188D-02 , 6.2549D-02 , 
     &      6.2795D-02 , 6.3617D-02 , 6.4835D-02 , 6.6329D-02 , 
     &      6.8017D-02 , 6.9809D-02 , 7.1667D-02 , 7.3520D-02 , 
     &      7.5270D-02 , 7.6864D-02 , 8.3899D-02 , 9.1206D-02 , 
     &      1.0002D-01 , 1.1070D-01 , 1.2399D-01 , 1.4094D-01 , 
     &      1.6341D-01 , 1.9474D-01 , 2.4163D-01 , 3.1971D-01 , 
     &      4.7587D-01 , 0.0000D+00 , 0.0000D+00 , 2.4392D+00 , 
     &      2.3049D+00 , 2.1760D+00 , 2.0502D+00 , 1.9296D+00 , 
     &      1.8065D+00 , 1.6895D+00 , 1.5750D+00 , 1.4674D+00 , 
     &      1.3585D+00 , 1.2554D+00 , 1.1565D+00 , 1.0638D+00 , 
     &      1.0103D+00 , 9.5527D-01 , 8.9449D-01 , 8.3572D-01 , 
     &      7.8018D-01 , 7.2635D-01 , 6.8280D-01 , 6.3819D-01 , 
     &      5.8948D-01 , 5.4299D-01 , 4.9923D-01 , 4.5740D-01 , 
     &      4.2371D-01 , 3.8978D-01 , 3.5296D-01 , 3.1832D-01 , 
     &      2.8629D-01 , 2.5599D-01 , 2.3212D-01 , 2.0840D-01 , 
     &      1.8346D-01 , 1.6065D-01 , 1.4043D-01 , 1.2229D-01 , 
     &      1.0880D-01 , 9.6294D-02 , 8.4335D-02 , 7.4905D-02 , 
     &      6.9717D-02 , 6.5897D-02 , 6.3914D-02 , 6.2851D-02 , 
     &      6.2731D-02 , 6.3183D-02 , 6.4075D-02 , 6.5225D-02 , 
     &      6.6597D-02 , 6.8048D-02 , 6.9577D-02/
      DATA (xsf_l(k),k=1141,1254)/7.1093D-02 , 7.2525D-02 , 7.3842D-02 , 
     &      8.0241D-02 , 8.6615D-02 , 9.4292D-02 , 1.0360D-01 , 
     &      1.1517D-01 , 1.2992D-01 , 1.4936D-01 , 1.7633D-01 , 
     &      2.1652D-01 , 2.8294D-01 , 4.1389D-01 , 0.0000D+00 , 
     &      0.0000D+00 , 2.9162D+00 , 2.7470D+00 , 2.5840D+00 , 
     &      2.4244D+00 , 2.2743D+00 , 2.1215D+00 , 1.9764D+00 , 
     &      1.8358D+00 , 1.7035D+00 , 1.5708D+00 , 1.4463D+00 , 
     &      1.3268D+00 , 1.2152D+00 , 1.1514D+00 , 1.0857D+00 , 
     &      1.0132D+00 , 9.4449D-01 , 8.7867D-01 , 8.1556D-01 , 
     &      7.6453D-01 , 7.1252D-01 , 6.5602D-01 , 6.0218D-01 , 
     &      5.5192D-01 , 5.0387D-01 , 4.6545D-01 , 4.2679D-01 , 
     &      3.8521D-01 , 3.4602D-01 , 3.1005D-01 , 2.7623D-01 , 
     &      2.4962D-01 , 2.2332D-01 , 1.9577D-01 , 1.7070D-01 , 
     &      1.4856D-01 , 1.2874D-01 , 1.1402D-01 , 1.0040D-01 , 
     &      8.7343D-02 , 7.6984D-02 , 7.1254D-02 , 6.6892D-02 , 
     &      6.4508D-02 , 6.3019D-02 , 6.2518D-02 , 6.2667D-02 , 
     &      6.3211D-02 , 6.4031D-02 , 6.5064D-02 , 6.6243D-02 , 
     &      6.7458D-02 , 6.8679D-02 , 6.9830D-02 , 7.0885D-02 , 
     &      7.6672D-02 , 8.2192D-02 , 8.8844D-02 , 9.6930D-02 , 
     &      1.0696D-01 , 1.1972D-01 , 1.3654D-01 , 1.5978D-01 , 
     &      1.9411D-01 , 2.5048D-01 , 3.6023D-01 , 0.0000D+00 , 
     &      0.0000D+00 , 3.4281D+00 , 3.2194D+00 , 3.0180D+00 , 
     &      2.8239D+00 , 2.6400D+00 , 2.4537D+00 , 2.2781D+00 , 
     &      2.1087D+00 , 1.9503D+00 , 1.7915D+00 , 1.6433D+00 , 
     &      1.5021D+00 , 1.3711D+00 , 1.2958D+00 , 1.2191D+00 , 
     &      1.1350D+00 , 1.0536D+00 , 9.7846D-01 , 9.0526D-01 , 
     &      8.4668D-01 , 7.8697D-01 , 7.2243D-01 , 6.6110D-01 , 
     &      6.0402D-01 , 5.4971D-01 , 5.0652D-01 , 4.6307D-01 , 
     &      4.1647D-01 , 3.7287D-01 , 3.3288D-01/
      DATA (xsf_l(k),k=1255,1368)/2.9545D-01 , 2.6636D-01 , 2.3751D-01 , 
     &      2.0740D-01 , 1.8012D-01 , 1.5611D-01 , 1.3467D-01 , 
     &      1.1881D-01 , 1.0414D-01 , 9.0105D-02 , 7.8839D-02 , 
     &      7.2563D-02 , 6.7703D-02 , 6.4930D-02 , 6.3070D-02 , 
     &      6.2241D-02 , 6.2071D-02 , 6.2347D-02 , 6.2882D-02 , 
     &      6.3645D-02 , 6.4526D-02 , 6.5473D-02 , 6.6427D-02 , 
     &      6.7333D-02 , 6.8194D-02 , 7.3430D-02 , 7.8217D-02 , 
     &      8.3974D-02 , 9.1017D-02 , 9.9745D-02 , 1.1088D-01 , 
     &      1.2552D-01 , 1.4563D-01 , 1.7528D-01 , 2.2351D-01 , 
     &      3.1636D-01 , 0.0000D+00 , 0.0000D+00 , 3.9892D+00 , 
     &      3.7328D+00 , 3.4900D+00 , 3.2549D+00 , 3.0344D+00 , 
     &      2.8108D+00 , 2.6014D+00 , 2.4001D+00 , 2.2123D+00 , 
     &      2.0253D+00 , 1.8518D+00 , 1.6860D+00 , 1.5339D+00 , 
     &      1.4463D+00 , 1.3575D+00 , 1.2608D+00 , 1.1678D+00 , 
     &      1.0809D+00 , 9.9767D-01 , 9.3087D-01 , 8.6314D-01 , 
     &      7.8996D-01 , 7.2083D-01 , 6.5671D-01 , 5.9602D-01 , 
     &      5.4775D-01 , 4.9935D-01 , 4.4773D-01 , 3.9951D-01 , 
     &      3.5571D-01 , 3.1467D-01 , 2.8272D-01 , 2.5135D-01 , 
     &      2.1871D-01 , 1.8923D-01 , 1.6331D-01 , 1.4031D-01 , 
     &      1.2332D-01 , 1.0762D-01 , 9.2560D-02 , 8.0473D-02 , 
     &      7.3714D-02 , 6.8385D-02 , 6.5246D-02 , 6.3019D-02 , 
     &      6.1878D-02 , 6.1420D-02 , 6.1413D-02 , 6.1734D-02 , 
     &      6.2226D-02 , 6.2861D-02 , 6.3564D-02 , 6.4288D-02 , 
     &      6.4985D-02 , 6.5657D-02 , 7.0367D-02 , 7.4522D-02 , 
     &      7.9506D-02 , 8.5651D-02 , 9.3297D-02 , 1.0298D-01 , 
     &      1.1572D-01 , 1.3323D-01 , 1.5884D-01 , 2.0039D-01 , 
     &      2.7925D-01 , 0.0000D+00 , 0.0000D+00 , 4.5788D+00 , 
     &      4.2729D+00 , 3.9840D+00 , 3.7039D+00 , 3.4438D+00 , 
     &      3.1812D+00 , 2.9349D+00 , 2.6996D+00/
      DATA (xsf_l(k),k=1369,1482)/2.4810D+00 , 2.2644D+00 , 2.0633D+00 , 
     &      1.8732D+00 , 1.6979D+00 , 1.5988D+00 , 1.4974D+00 , 
     &      1.3865D+00 , 1.2812D+00 , 1.1834D+00 , 1.0891D+00 , 
     &      1.0143D+00 , 9.3839D-01 , 8.5662D-01 , 7.7948D-01 , 
     &      7.0838D-01 , 6.4106D-01 , 5.8780D-01 , 5.3454D-01 , 
     &      4.7781D-01 , 4.2528D-01 , 3.7737D-01 , 3.3289D-01 , 
     &      2.9818D-01 , 2.6446D-01 , 2.2932D-01 , 1.9770D-01 , 
     &      1.7005D-01 , 1.4552D-01 , 1.2746D-01 , 1.1078D-01 , 
     &      9.4770D-02 , 8.1957D-02 , 7.4689D-02 , 6.8915D-02 , 
     &      6.5457D-02 , 6.2902D-02 , 6.1493D-02 , 6.0768D-02 , 
     &      6.0515D-02 , 6.0585D-02 , 6.0863D-02 , 6.1298D-02 , 
     &      6.1789D-02 , 6.2311D-02 , 6.2835D-02 , 6.3340D-02 , 
     &      6.7601D-02 , 7.1162D-02 , 7.5516D-02 , 8.0878D-02 , 
     &      8.7566D-02 , 9.6095D-02 , 1.0725D-01 , 1.2258D-01 , 
     &      1.4495D-01 , 1.8090D-01 , 2.4841D-01 , 0.0000D+00 , 
     &      0.0000D+00 , 5.4774D+00 , 5.0929D+00 , 4.7320D+00 , 
     &      4.3841D+00 , 4.0592D+00 , 3.7350D+00 , 3.4329D+00 , 
     &      3.1454D+00 , 2.8799D+00 , 2.6172D+00 , 2.3747D+00 , 
     &      2.1466D+00 , 1.9383D+00 , 1.8195D+00 , 1.6996D+00 , 
     &      1.5689D+00 , 1.4457D+00 , 1.3301D+00 , 1.2211D+00 , 
     &      1.1339D+00 , 1.0456D+00 , 9.5119D-01 , 8.6259D-01 , 
     &      7.8097D-01 , 7.0419D-01 , 6.4380D-01 , 5.8358D-01 , 
     &      5.1955D-01 , 4.6051D-01 , 4.0719D-01 , 3.5768D-01 , 
     &      3.1962D-01 , 2.8220D-01 , 2.4360D-01 , 2.0909D-01 , 
     &      1.7895D-01 , 1.5240D-01 , 1.3282D-01 , 1.1484D-01 , 
     &      9.7655D-02 , 8.3739D-02 , 7.5857D-02 , 6.9509D-02 , 
     &      6.5616D-02 , 6.2633D-02 , 6.0853D-02 , 5.9819D-02 , 
     &      5.9271D-02 , 5.9038D-02 , 5.9046D-02 , 5.9192D-02 , 
     &      5.9432D-02 , 5.9709D-02 , 6.0008D-02/
      DATA (xsf_l(k),k=1483,1596)/6.0340D-02 , 6.4032D-02 , 6.6851D-02 , 
     &      7.0446D-02 , 7.4870D-02 , 8.0457D-02 , 8.7554D-02 , 
     &      9.6862D-02 , 1.0964D-01 , 1.2821D-01 , 1.5779D-01 , 
     &      2.1189D-01 , 0.0000D+00 , 0.0000D+00 , 6.3982D+00 , 
     &      5.9307D+00 , 5.4920D+00 , 5.0710D+00 , 4.6822D+00 , 
     &      4.2915D+00 , 3.9337D+00 , 3.5898D+00 , 3.2756D+00 , 
     &      2.9660D+00 , 2.6817D+00 , 2.4150D+00 , 2.1724D+00 , 
     &      2.0348D+00 , 1.8961D+00 , 1.7457D+00 , 1.6034D+00 , 
     &      1.4714D+00 , 1.3471D+00 , 1.2473D+00 , 1.1476D+00 , 
     &      1.0408D+00 , 9.4083D-01 , 8.4932D-01 , 7.6350D-01 , 
     &      6.9606D-01 , 6.2897D-01 , 5.5833D-01 , 4.9315D-01 , 
     &      4.3444D-01 , 3.8044D-01 , 3.3861D-01 , 2.9817D-01 , 
     &      2.5642D-01 , 2.1917D-01 , 1.8685D-01 , 1.5838D-01 , 
     &      1.3752D-01 , 1.1831D-01 , 9.9987D-02 , 8.5224D-02 , 
     &      7.6762D-02 , 6.9910D-02 , 6.5655D-02 , 6.2297D-02 , 
     &      6.0213D-02 , 5.8897D-02 , 5.8096D-02 , 5.7624D-02 , 
     &      5.7400D-02 , 5.7322D-02 , 5.7351D-02 , 5.7432D-02 , 
     &      5.7560D-02 , 5.7758D-02 , 6.0939D-02 , 6.3212D-02 , 
     &      6.6167D-02 , 6.9884D-02 , 7.4560D-02 , 8.0552D-02 , 
     &      8.8432D-02 , 9.9242D-02 , 1.1491D-01 , 1.3966D-01 , 
     &      1.8320D-01 , 0.0000D+00 , 0.0000D+00 , 7.4490D+00 , 
     &      6.8826D+00 , 6.3540D+00 , 5.8477D+00 , 5.3805D+00 , 
     &      4.9187D+00 , 4.4884D+00 , 4.0843D+00 , 3.7147D+00 , 
     &      3.3516D+00 , 3.0193D+00 , 2.7088D+00 , 2.4279D+00 , 
     &      2.2696D+00 , 2.1091D+00 , 1.9368D+00 , 1.7739D+00 , 
     &      1.6237D+00 , 1.4821D+00 , 1.3692D+00 , 1.2557D+00 , 
     &      1.1358D+00 , 1.0238D+00 , 9.2133D-01 , 8.2567D-01 , 
     &      7.5070D-01 , 6.7656D-01 , 5.9850D-01 , 5.2688D-01 , 
     &      4.6263D-01 , 4.0371D-01 , 3.5842D-01/
      DATA (xsf_l(k),k=1597,1710)/3.1427D-01 , 2.6933D-01 , 2.2930D-01 , 
     &      1.9466D-01 , 1.6427D-01 , 1.4208D-01 , 1.2168D-01 , 
     &      1.0226D-01 , 8.6560D-02 , 7.7553D-02 , 7.0202D-02 , 
     &      6.5576D-02 , 6.1860D-02 , 5.9487D-02 , 5.7920D-02 , 
     &      5.6852D-02 , 5.6166D-02 , 5.5736D-02 , 5.5458D-02 , 
     &      5.5289D-02 , 5.5193D-02 , 5.5163D-02 , 5.5243D-02 , 
     &      5.7935D-02 , 5.9740D-02 , 6.2111D-02 , 6.5158D-02 , 
     &      6.9050D-02 , 7.4078D-02 , 8.0683D-02 , 8.9776D-02 , 
     &      1.0288D-01 , 1.2351D-01 , 1.5725D-01 , 0.0000D+00 , 
     &      0.0000D+00 , 8.6044D+00 , 7.9255D+00 , 7.2940D+00 , 
     &      6.6940D+00 , 6.1391D+00 , 5.5940D+00 , 5.0907D+00 , 
     &      4.6180D+00 , 4.1841D+00 , 3.7622D+00 , 3.3775D+00 , 
     &      3.0195D+00 , 2.6967D+00 , 2.5153D+00 , 2.3331D+00 , 
     &      2.1364D+00 , 1.9521D+00 , 1.7815D+00 , 1.6211D+00 , 
     &      1.4944D+00 , 1.3683D+00 , 1.2334D+00 , 1.1084D+00 , 
     &      9.9465D-01 , 8.8864D-01 , 8.0585D-01 , 7.2432D-01 , 
     &      6.3866D-01 , 5.6038D-01 , 4.9058D-01 , 4.2648D-01 , 
     &      3.7768D-01 , 3.3036D-01 , 2.8189D-01 , 2.3907D-01 , 
     &      2.0214D-01 , 1.6987D-01 , 1.4635D-01 , 1.2479D-01 , 
     &      1.0428D-01 , 8.7748D-02 , 7.8203D-02 , 7.0386D-02 , 
     &      6.5431D-02 , 6.1373D-02 , 5.8719D-02 , 5.6916D-02 , 
     &      5.5642D-02 , 5.4751D-02 , 5.4118D-02 , 5.3653D-02 , 
     &      5.3314D-02 , 5.3067D-02 , 5.2897D-02 , 5.2861D-02 , 
     &      5.5140D-02 , 5.6493D-02 , 5.8378D-02 , 6.0860D-02 , 
     &      6.4090D-02 , 6.8261D-02 , 7.3828D-02 , 8.1439D-02 , 
     &      9.2423D-02 , 1.0952D-01 , 1.3424D-01 , 0.0000D+00 , 
     &      0.0000D+00 , 9.7645D+00 , 8.9701D+00 , 8.2340D+00 , 
     &      7.5357D+00 , 6.8926D+00 , 6.2607D+00 , 5.6834D+00 , 
     &      5.1374D+00 , 4.6459D+00 , 4.1625D+00/
      DATA (xsf_l(k),k=1711,1824)/3.7261D+00 , 3.3206D+00 , 2.9567D+00 , 
     &      2.7529D+00 , 2.5476D+00 , 2.3274D+00 , 2.1217D+00 , 
     &      1.9320D+00 , 1.7541D+00 , 1.6131D+00 , 1.4740D+00 , 
     &      1.3257D+00 , 1.1879D+00 , 1.0631D+00 , 9.4732D-01 , 
     &      8.5726D-01 , 7.6844D-01 , 6.7586D-01 , 5.9131D-01 , 
     &      5.1597D-01 , 4.4748D-01 , 3.9504D-01 , 3.4470D-01 , 
     &      2.9317D-01 , 2.4779D-01 , 2.0880D-01 , 1.7478D-01 , 
     &      1.5007D-01 , 1.2748D-01 , 1.0600D-01 , 8.8713D-02 , 
     &      7.8704D-02 , 7.0472D-02 , 6.5220D-02 , 6.0885D-02 , 
     &      5.7993D-02 , 5.5967D-02 , 5.4536D-02 , 5.3470D-02 , 
     &      5.2665D-02 , 5.2054D-02 , 5.1577D-02 , 5.1203D-02 , 
     &      5.0930D-02 , 5.0809D-02 , 5.2731D-02 , 5.3716D-02 , 
     &      5.5192D-02 , 5.7203D-02 , 5.9902D-02 , 6.3412D-02 , 
     &      6.8123D-02 , 7.4602D-02 , 8.3905D-02 , 9.8185D-02 , 
     &      1.1515D-01 , 0.0000D+00 , 0.0000D+00 , 1.1069D+01 , 
     &      1.0141D+01 , 9.2840D+00 , 8.4741D+00 , 7.7316D+00 , 
     &      7.0038D+00 , 6.3364D+00 , 5.7137D+00 , 5.1475D+00 , 
     &      4.6031D+00 , 4.1059D+00 , 3.6477D+00 , 3.2381D+00 , 
     &      3.0086D+00 , 2.7788D+00 , 2.5333D+00 , 2.3033D+00 , 
     &      2.0926D+00 , 1.8951D+00 , 1.7404D+00 , 1.5854D+00 , 
     &      1.4229D+00 , 1.2715D+00 , 1.1352D+00 , 1.0089D+00 , 
     &      9.1089D-01 , 8.1457D-01 , 7.1424D-01 , 6.2332D-01 , 
     &      5.4229D-01 , 4.6872D-01 , 4.1295D-01 , 3.5903D-01 , 
     &      3.0454D-01 , 2.5654D-01 , 2.1539D-01 , 1.7965D-01 , 
     &      1.5373D-01 , 1.3011D-01 , 1.0766D-01 , 8.9530D-02 , 
     &      7.9108D-02 , 7.0483D-02 , 6.4943D-02 , 6.0331D-02 , 
     &      5.7203D-02 , 5.4990D-02 , 5.3395D-02 , 5.2144D-02 , 
     &      5.1206D-02 , 5.0454D-02 , 4.9840D-02 , 4.9351D-02 , 
     &      4.8978D-02 , 4.8801D-02 , 5.0351D-02/
      DATA (xsf_l(k),k=1825,1836)/5.1017D-02 , 5.2127D-02 , 5.3737D-02 , 
     &      5.5934D-02 , 5.8835D-02 , 6.2800D-02 , 6.8260D-02 , 
     &      7.6135D-02 , 8.7873D-02 , 0.0000D+00 , 0.0000D+00 , 
     &      0.0000D+00/
      DATA (xgf_l(k),k=1,114)/1.0646D+00 , 1.0934D+00 , 1.1214D+00 , 
     &      1.1484D+00 , 1.1741D+00 , 1.1999D+00 , 1.2242D+00 , 
     &      1.2466D+00 , 1.2676D+00 , 1.2873D+00 , 1.3042D+00 , 
     &      1.3194D+00 , 1.3313D+00 , 1.3376D+00 , 1.3430D+00 , 
     &      1.3472D+00 , 1.3502D+00 , 1.3504D+00 , 1.3501D+00 , 
     &      1.3478D+00 , 1.3430D+00 , 1.3356D+00 , 1.3267D+00 , 
     &      1.3149D+00 , 1.3003D+00 , 1.2857D+00 , 1.2680D+00 , 
     &      1.2451D+00 , 1.2189D+00 , 1.1899D+00 , 1.1575D+00 , 
     &      1.1282D+00 , 1.0947D+00 , 1.0543D+00 , 1.0121D+00 , 
     &      9.6983D-01 , 9.2809D-01 , 8.9556D-01 , 8.6663D-01 , 
     &      8.4606D-01 , 8.4971D-01 , 8.7714D-01 , 9.3569D-01 , 
     &      1.0140D+00 , 1.1325D+00 , 1.2706D+00 , 1.4268D+00 , 
     &      1.6005D+00 , 1.7918D+00 , 2.0014D+00 , 2.2301D+00 , 
     &      2.4791D+00 , 2.7490D+00 , 3.0404D+00 , 3.3541D+00 , 
     &      3.5718D+00 , 4.2579D+00 , 5.0478D+00 , 5.9674D+00 , 
     &      7.0458D+00 , 8.3375D+00 , 9.9284D+00 , 1.1949D+01 , 
     &      1.4650D+01 , 1.8560D+01 , 2.5096D+01 , 4.0067D+01 , 
     &      0.0000D+00 , 1.6404D+00 , 1.6723D+00 , 1.7014D+00 , 
     &      1.7287D+00 , 1.7533D+00 , 1.7768D+00 , 1.7973D+00 , 
     &      1.8152D+00 , 1.8297D+00 , 1.8417D+00 , 1.8498D+00 , 
     &      1.8540D+00 , 1.8544D+00 , 1.8526D+00 , 1.8489D+00 , 
     &      1.8424D+00 , 1.8335D+00 , 1.8221D+00 , 1.8091D+00 , 
     &      1.7949D+00 , 1.7784D+00 , 1.7555D+00 , 1.7310D+00 , 
     &      1.7034D+00 , 1.6713D+00 , 1.6428D+00 , 1.6093D+00 , 
     &      1.5680D+00 , 1.5230D+00 , 1.4754D+00 , 1.4241D+00 , 
     &      1.3785D+00 , 1.3278D+00 , 1.2681D+00 , 1.2068D+00 , 
     &      1.1462D+00 , 1.0867D+00 , 1.0400D+00 , 9.9665D-01 , 
     &      9.6041D-01 , 9.4923D-01 , 9.6563D-01 , 1.0117D+00 , 
     &      1.0781D+00 , 1.1816D+00 , 1.3028D+00/
      DATA (xgf_l(k),k=115,228)/1.4397D+00 , 1.5912D+00 , 1.7573D+00 , 
     &      1.9376D+00 , 2.1326D+00 , 2.3425D+00 , 2.5677D+00 , 
     &      2.8078D+00 , 3.0611D+00 , 3.2398D+00 , 3.7904D+00 , 
     &      4.4126D+00 , 5.1162D+00 , 5.9322D+00 , 6.8841D+00 , 
     &      8.0278D+00 , 9.4403D+00 , 1.1276D+01 , 1.3844D+01 , 
     &      1.7948D+01 , 2.6821D+01 , 0.0000D+00 , 2.5295D+00 , 
     &      2.5563D+00 , 2.5800D+00 , 2.5995D+00 , 2.6174D+00 , 
     &      2.6286D+00 , 2.6363D+00 , 2.6395D+00 , 2.6379D+00 , 
     &      2.6306D+00 , 2.6184D+00 , 2.6000D+00 , 2.5768D+00 , 
     &      2.5598D+00 , 2.5397D+00 , 2.5137D+00 , 2.4839D+00 , 
     &      2.4516D+00 , 2.4161D+00 , 2.3833D+00 , 2.3459D+00 , 
     &      2.3000D+00 , 2.2499D+00 , 2.1966D+00 , 2.1407D+00 , 
     &      2.0900D+00 , 2.0320D+00 , 1.9647D+00 , 1.8929D+00 , 
     &      1.8190D+00 , 1.7411D+00 , 1.6734D+00 , 1.5997D+00 , 
     &      1.5142D+00 , 1.4279D+00 , 1.3438D+00 , 1.2617D+00 , 
     &      1.1967D+00 , 1.1353D+00 , 1.0800D+00 , 1.0501D+00 , 
     &      1.0526D+00 , 1.0849D+00 , 1.1369D+00 , 1.2228D+00 , 
     &      1.3250D+00 , 1.4410D+00 , 1.5691D+00 , 1.7085D+00 , 
     &      1.8587D+00 , 2.0200D+00 , 2.1915D+00 , 2.3728D+00 , 
     &      2.5633D+00 , 2.7603D+00 , 2.9047D+00 , 3.3315D+00 , 
     &      3.8026D+00 , 4.3243D+00 , 4.9121D+00 , 5.5828D+00 , 
     &      6.3648D+00 , 7.3038D+00 , 8.4817D+00 , 1.0068D+01 , 
     &      1.2484D+01 , 1.7398D+01 , 0.0000D+00 , 3.9781D+00 , 
     &      3.9859D+00 , 3.9880D+00 , 3.9845D+00 , 3.9763D+00 , 
     &      3.9582D+00 , 3.9337D+00 , 3.9028D+00 , 3.8636D+00 , 
     &      3.8159D+00 , 3.7613D+00 , 3.6984D+00 , 3.6287D+00 , 
     &      3.5836D+00 , 3.5326D+00 , 3.4703D+00 , 3.4046D+00 , 
     &      3.3350D+00 , 3.2612D+00 , 3.1962D+00 , 3.1248D+00 , 
     &      3.0388D+00 , 2.9485D+00 , 2.8565D+00/
      DATA (xgf_l(k),k=229,342)/2.7591D+00 , 2.6752D+00 , 2.5823D+00 , 
     &      2.4756D+00 , 2.3627D+00 , 2.2510D+00 , 2.1352D+00 , 
     &      2.0365D+00 , 1.9308D+00 , 1.8097D+00 , 1.6896D+00 , 
     &      1.5737D+00 , 1.4618D+00 , 1.3735D+00 , 1.2886D+00 , 
     &      1.2087D+00 , 1.1551D+00 , 1.1411D+00 , 1.1545D+00 , 
     &      1.1903D+00 , 1.2550D+00 , 1.3356D+00 , 1.4282D+00 , 
     &      1.5306D+00 , 1.6419D+00 , 1.7606D+00 , 1.8869D+00 , 
     &      2.0194D+00 , 2.1574D+00 , 2.2992D+00 , 2.4432D+00 , 
     &      2.5568D+00 , 2.8674D+00 , 3.2008D+00 , 3.5626D+00 , 
     &      3.9572D+00 , 4.3932D+00 , 4.8857D+00 , 5.4544D+00 , 
     &      6.1386D+00 , 7.0188D+00 , 8.2895D+00 , 1.0709D+01 , 
     &      0.0000D+00 , 6.3697D+00 , 6.3265D+00 , 6.2740D+00 , 
     &      6.2091D+00 , 6.1391D+00 , 6.0517D+00 , 5.9560D+00 , 
     &      5.8525D+00 , 5.7367D+00 , 5.6106D+00 , 5.4709D+00 , 
     &      5.3235D+00 , 5.1695D+00 , 5.0724D+00 , 4.9662D+00 , 
     &      4.8411D+00 , 4.7105D+00 , 4.5784D+00 , 4.4412D+00 , 
     &      4.3226D+00 , 4.1943D+00 , 4.0442D+00 , 3.8903D+00 , 
     &      3.7360D+00 , 3.5773D+00 , 3.4420D+00 , 3.2967D+00 , 
     &      3.1301D+00 , 2.9593D+00 , 2.7916D+00 , 2.6229D+00 , 
     &      2.4802D+00 , 2.3301D+00 , 2.1613D+00 , 1.9957D+00 , 
     &      1.8382D+00 , 1.6875D+00 , 1.5691D+00 , 1.4545D+00 , 
     &      1.3433D+00 , 1.2614D+00 , 1.2264D+00 , 1.2177D+00 , 
     &      1.2342D+00 , 1.2749D+00 , 1.3313D+00 , 1.3987D+00 , 
     &      1.4740D+00 , 1.5559D+00 , 1.6431D+00 , 1.7346D+00 , 
     &      1.8295D+00 , 1.9260D+00 , 2.0232D+00 , 2.1174D+00 , 
     &      2.2034D+00 , 2.4118D+00 , 2.6289D+00 , 2.8563D+00 , 
     &      3.0948D+00 , 3.3486D+00 , 3.6231D+00 , 3.9250D+00 , 
     &      4.2677D+00 , 4.6847D+00 , 5.2492D+00 , 6.2650D+00 , 
     &      0.0000D+00 , 9.3778D+00 , 9.2428D+00/
      DATA (xgf_l(k),k=343,456)/9.0960D+00 , 8.9365D+00 , 8.7665D+00 , 
     &      8.5746D+00 , 8.3714D+00 , 8.1544D+00 , 7.9343D+00 , 
     &      7.6882D+00 , 7.4352D+00 , 7.1724D+00 , 6.9027D+00 , 
     &      6.7360D+00 , 6.5571D+00 , 6.3494D+00 , 6.1374D+00 , 
     &      5.9260D+00 , 5.7093D+00 , 5.5249D+00 , 5.3270D+00 , 
     &      5.0995D+00 , 4.8700D+00 , 4.6419D+00 , 4.4114D+00 , 
     &      4.2173D+00 , 4.0129D+00 , 3.7786D+00 , 3.5451D+00 , 
     &      3.3173D+00 , 3.0900D+00 , 2.9004D+00 , 2.7040D+00 , 
     &      2.4853D+00 , 2.2734D+00 , 2.0742D+00 , 1.8851D+00 , 
     &      1.7372D+00 , 1.5941D+00 , 1.4536D+00 , 1.3433D+00 , 
     &      1.2893D+00 , 1.2607D+00 , 1.2587D+00 , 1.2792D+00 , 
     &      1.3153D+00 , 1.3616D+00 , 1.4149D+00 , 1.4736D+00 , 
     &      1.5361D+00 , 1.6012D+00 , 1.6677D+00 , 1.7344D+00 , 
     &      1.7990D+00 , 1.8589D+00 , 1.9261D+00 , 2.0646D+00 , 
     &      2.2044D+00 , 2.3456D+00 , 2.4882D+00 , 2.6342D+00 , 
     &      2.7823D+00 , 2.9370D+00 , 3.1022D+00 , 3.2902D+00 , 
     &      3.5288D+00 , 3.9528D+00 , 0.0000D+00 , 1.3926D+01 , 
     &      1.3617D+01 , 1.3298D+01 , 1.2959D+01 , 1.2612D+01 , 
     &      1.2230D+01 , 1.1845D+01 , 1.1442D+01 , 1.1036D+01 , 
     &      1.0599D+01 , 1.0158D+01 , 9.7041D+00 , 9.2562D+00 , 
     &      8.9827D+00 , 8.6974D+00 , 8.3632D+00 , 8.0255D+00 , 
     &      7.6946D+00 , 7.3614D+00 , 7.0802D+00 , 6.7814D+00 , 
     &      6.4439D+00 , 6.1064D+00 , 5.7775D+00 , 5.4468D+00 , 
     &      5.1723D+00 , 4.8858D+00 , 4.5617D+00 , 4.2425D+00 , 
     &      3.9361D+00 , 3.6353D+00 , 3.3874D+00 , 3.1301D+00 , 
     &      2.8506D+00 , 2.5816D+00 , 2.3318D+00 , 2.0965D+00 , 
     &      1.9136D+00 , 1.7368D+00 , 1.5622D+00 , 1.4211D+00 , 
     &      1.3452D+00 , 1.2937D+00 , 1.2737D+00 , 1.2719D+00 , 
     &      1.2868D+00 , 1.3119D+00 , 1.3437D+00/
      DATA (xgf_l(k),k=457,570)/1.3799D+00 , 1.4189D+00 , 1.4596D+00 , 
     &      1.5003D+00 , 1.5401D+00 , 1.5761D+00 , 1.6073D+00 , 
     &      1.6574D+00 , 1.7377D+00 , 1.8158D+00 , 1.8902D+00 , 
     &      1.9601D+00 , 2.0263D+00 , 2.0884D+00 , 2.1452D+00 , 
     &      2.1990D+00 , 2.2512D+00 , 2.3118D+00 , 2.4354D+00 , 
     &      0.0000D+00 , 1.9256D+01 , 1.8699D+01 , 1.8142D+01 , 
     &      1.7563D+01 , 1.6980D+01 , 1.6355D+01 , 1.5725D+01 , 
     &      1.5081D+01 , 1.4443D+01 , 1.3769D+01 , 1.3097D+01 , 
     &      1.2422D+01 , 1.1755D+01 , 1.1358D+01 , 1.0937D+01 , 
     &      1.0454D+01 , 9.9818D+00 , 9.5167D+00 , 9.0465D+00 , 
     &      8.6570D+00 , 8.2473D+00 , 7.7870D+00 , 7.3320D+00 , 
     &      6.8911D+00 , 6.4569D+00 , 6.0969D+00 , 5.7223D+00 , 
     &      5.3051D+00 , 4.8992D+00 , 4.5131D+00 , 4.1351D+00 , 
     &      3.8285D+00 , 3.5148D+00 , 3.1749D+00 , 2.8517D+00 , 
     &      2.5534D+00 , 2.2748D+00 , 2.0598D+00 , 1.8527D+00 , 
     &      1.6465D+00 , 1.4780D+00 , 1.3832D+00 , 1.3129D+00 , 
     &      1.2758D+00 , 1.2566D+00 , 1.2544D+00 , 1.2628D+00 , 
     &      1.2778D+00 , 1.2971D+00 , 1.3186D+00 , 1.3412D+00 , 
     &      1.3637D+00 , 1.3845D+00 , 1.4021D+00 , 1.4142D+00 , 
     &      1.4518D+00 , 1.4945D+00 , 1.5327D+00 , 1.5661D+00 , 
     &      1.5941D+00 , 1.6160D+00 , 1.6309D+00 , 1.6386D+00 , 
     &      1.6381D+00 , 1.6291D+00 , 1.6176D+00 , 1.6271D+00 , 
     &      0.0000D+00 , 2.5945D+01 , 2.5063D+01 , 2.4160D+01 , 
     &      2.3234D+01 , 2.2336D+01 , 2.1370D+01 , 2.0417D+01 , 
     &      1.9450D+01 , 1.8508D+01 , 1.7517D+01 , 1.6548D+01 , 
     &      1.5580D+01 , 1.4645D+01 , 1.4085D+01 , 1.3496D+01 , 
     &      1.2836D+01 , 1.2181D+01 , 1.1547D+01 , 1.0921D+01 , 
     &      1.0404D+01 , 9.8614D+00 , 9.2547D+00 , 8.6616D+00 , 
     &      8.0926D+00 , 7.5352D+00 , 7.0774D+00/
      DATA (xgf_l(k),k=571,684)/6.6043D+00 , 6.0842D+00 , 5.5816D+00 , 
     &      5.1040D+00 , 4.6450D+00 , 4.2749D+00 , 3.8995D+00 , 
     &      3.4941D+00 , 3.1134D+00 , 2.7651D+00 , 2.4423D+00 , 
     &      2.1941D+00 , 1.9564D+00 , 1.7198D+00 , 1.5241D+00 , 
     &      1.4112D+00 , 1.3220D+00 , 1.2705D+00 , 1.2348D+00 , 
     &      1.2175D+00 , 1.2113D+00 , 1.2119D+00 , 1.2167D+00 , 
     &      1.2238D+00 , 1.2321D+00 , 1.2398D+00 , 1.2460D+00 , 
     &      1.2491D+00 , 1.2470D+00 , 1.2752D+00 , 1.2894D+00 , 
     &      1.2998D+00 , 1.3055D+00 , 1.3049D+00 , 1.2991D+00 , 
     &      1.2860D+00 , 1.2655D+00 , 1.2370D+00 , 1.1998D+00 , 
     &      1.1564D+00 , 1.1181D+00 , 0.0000D+00 , 3.3362D+01 , 
     &      3.2051D+01 , 3.0740D+01 , 2.9429D+01 , 2.8133D+01 , 
     &      2.6758D+01 , 2.5422D+01 , 2.4082D+01 , 2.2784D+01 , 
     &      2.1435D+01 , 2.0130D+01 , 1.8839D+01 , 1.7597D+01 , 
     &      1.6865D+01 , 1.6098D+01 , 1.5241D+01 , 1.4397D+01 , 
     &      1.3587D+01 , 1.2791D+01 , 1.2130D+01 , 1.1444D+01 , 
     &      1.0687D+01 , 9.9507D+00 , 9.2501D+00 , 8.5659D+00 , 
     &      8.0104D+00 , 7.4390D+00 , 6.8118D+00 , 6.2125D+00 , 
     &      5.6506D+00 , 5.1096D+00 , 4.6780D+00 , 4.2434D+00 , 
     &      3.7769D+00 , 3.3424D+00 , 2.9475D+00 , 2.5842D+00 , 
     &      2.3061D+00 , 2.0409D+00 , 1.7770D+00 , 1.5572D+00 , 
     &      1.4290D+00 , 1.3248D+00 , 1.2609D+00 , 1.2112D+00 , 
     &      1.1814D+00 , 1.1636D+00 , 1.1530D+00 , 1.1469D+00 , 
     &      1.1433D+00 , 1.1407D+00 , 1.1378D+00 , 1.1337D+00 , 
     &      1.1269D+00 , 1.1152D+00 , 1.1360D+00 , 1.1320D+00 , 
     &      1.1243D+00 , 1.1127D+00 , 1.0960D+00 , 1.0739D+00 , 
     &      1.0461D+00 , 1.0122D+00 , 9.7100D-01 , 9.2292D-01 , 
     &      8.6909D-01 , 8.1432D-01 , 0.0000D+00 , 4.2364D+01 , 
     &      4.0483D+01 , 3.8640D+01 , 3.6792D+01/
      DATA (xgf_l(k),k=685,798)/3.4991D+01 , 3.3112D+01 , 3.1295D+01 , 
     &      2.9487D+01 , 2.7748D+01 , 2.5953D+01 , 2.4235D+01 , 
     &      2.2543D+01 , 2.0935D+01 , 1.9990D+01 , 1.9011D+01 , 
     &      1.7921D+01 , 1.6852D+01 , 1.5830D+01 , 1.4831D+01 , 
     &      1.4013D+01 , 1.3165D+01 , 1.2236D+01 , 1.1337D+01 , 
     &      1.0485D+01 , 9.6616D+00 , 8.9943D+00 , 8.3137D+00 , 
     &      7.5711D+00 , 6.8670D+00 , 6.2090D+00 , 5.5842D+00 , 
     &      5.0866D+00 , 4.5873D+00 , 4.0564D+00 , 3.5646D+00 , 
     &      3.1234D+00 , 2.7185D+00 , 2.4107D+00 , 2.1172D+00 , 
     &      1.8273D+00 , 1.5836D+00 , 1.4407D+00 , 1.3211D+00 , 
     &      1.2459D+00 , 1.1839D+00 , 1.1433D+00 , 1.1153D+00 , 
     &      1.0949D+00 , 1.0794D+00 , 1.0667D+00 , 1.0555D+00 , 
     &      1.0443D+00 , 1.0317D+00 , 1.0172D+00 , 9.9883D-01 , 
     &      1.0131D+00 , 9.9503D-01 , 9.7446D-01 , 9.5064D-01 , 
     &      9.2316D-01 , 8.9156D-01 , 8.5528D-01 , 8.1439D-01 , 
     &      7.6837D-01 , 7.1718D-01 , 6.6210D-01 , 6.0243D-01 , 
     &      0.0000D+00 , 5.2603D+01 , 5.0038D+01 , 4.7540D+01 , 
     &      4.5053D+01 , 4.2652D+01 , 4.0175D+01 , 3.7784D+01 , 
     &      3.5407D+01 , 3.3154D+01 , 3.0851D+01 , 2.8651D+01 , 
     &      2.6507D+01 , 2.4488D+01 , 2.3310D+01 , 2.2084D+01 , 
     &      2.0735D+01 , 1.9418D+01 , 1.8166D+01 , 1.6951D+01 , 
     &      1.5960D+01 , 1.4935D+01 , 1.3817D+01 , 1.2742D+01 , 
     &      1.1732D+01 , 1.0759D+01 , 9.9749D+00 , 9.1794D+00 , 
     &      8.3186D+00 , 7.5044D+00 , 6.7510D+00 , 6.0386D+00 , 
     &      5.4762D+00 , 4.9137D+00 , 4.3200D+00 , 3.7728D+00 , 
     &      3.2842D+00 , 2.8391D+00 , 2.5026D+00 , 2.1835D+00 , 
     &      1.8677D+00 , 1.6033D+00 , 1.4461D+00 , 1.3138D+00 , 
     &      1.2277D+00 , 1.1557D+00 , 1.1057D+00 , 1.0689D+00 , 
     &      1.0407D+00 , 1.0176D+00 , 9.9768D-01/
      DATA (xgf_l(k),k=799,912)/9.7951D-01 , 9.6199D-01 , 9.4331D-01 , 
     &      9.2359D-01 , 9.0058D-01 , 9.0921D-01 , 8.8156D-01 , 
     &      8.5244D-01 , 8.2081D-01 , 7.8702D-01 , 7.5025D-01 , 
     &      7.1005D-01 , 6.6667D-01 , 6.1984D-01 , 5.6969D-01 , 
     &      5.1748D-01 , 4.5895D-01 , 0.0000D+00 , 6.3459D+01 , 
     &      6.0127D+01 , 5.6900D+01 , 5.3695D+01 , 5.0615D+01 , 
     &      4.7464D+01 , 4.4440D+01 , 4.1483D+01 , 3.8684D+01 , 
     &      3.5826D+01 , 3.3122D+01 , 3.0500D+01 , 2.8040D+01 , 
     &      2.6617D+01 , 2.5143D+01 , 2.3518D+01 , 2.1950D+01 , 
     &      2.0455D+01 , 1.9011D+01 , 1.7842D+01 , 1.6646D+01 , 
     &      1.5337D+01 , 1.4094D+01 , 1.2920D+01 , 1.1799D+01 , 
     &      1.0903D+01 , 9.9940D+00 , 9.0166D+00 , 8.0967D+00 , 
     &      7.2512D+00 , 6.4551D+00 , 5.8279D+00 , 5.2081D+00 , 
     &      4.5519D+00 , 3.9568D+00 , 3.4237D+00 , 2.9425D+00 , 
     &      2.5798D+00 , 2.2371D+00 , 1.8995D+00 , 1.6161D+00 , 
     &      1.4477D+00 , 1.3046D+00 , 1.2096D+00 , 1.1285D+00 , 
     &      1.0709D+00 , 1.0274D+00 , 9.9290D-01 , 9.6399D-01 , 
     &      9.3860D-01 , 9.1550D-01 , 8.9324D-01 , 8.7036D-01 , 
     &      8.4674D-01 , 8.2129D-01 , 8.2506D-01 , 7.9094D-01 , 
     &      7.5633D-01 , 7.2031D-01 , 6.8307D-01 , 6.4387D-01 , 
     &      6.0237D-01 , 5.5907D-01 , 5.1344D-01 , 4.6618D-01 , 
     &      4.1810D-01 , 3.6329D-01 , 0.0000D+00 , 7.9498D+01 , 
     &      7.4941D+01 , 7.0580D+01 , 6.6266D+01 , 6.2169D+01 , 
     &      5.8002D+01 , 5.4045D+01 , 5.0164D+01 , 4.6539D+01 , 
     &      4.2847D+01 , 3.9386D+01 , 3.6065D+01 , 3.2968D+01 , 
     &      3.1180D+01 , 2.9347D+01 , 2.7330D+01 , 2.5394D+01 , 
     &      2.3566D+01 , 2.1811D+01 , 2.0388D+01 , 1.8944D+01 , 
     &      1.7368D+01 , 1.5877D+01 , 1.4488D+01 , 1.3164D+01 , 
     &      1.2111D+01 , 1.1051D+01 , 9.9162D+00/
      DATA (xgf_l(k),k=913,1026)/8.8542D+00 , 7.8839D+00 , 6.9777D+00 , 
     &      6.2689D+00 , 5.5695D+00 , 4.8410D+00 , 4.1789D+00 , 
     &      3.5909D+00 , 3.0635D+00 , 2.6689D+00 , 2.2973D+00 , 
     &      1.9324D+00 , 1.6270D+00 , 1.4446D+00 , 1.2882D+00 , 
     &      1.1839D+00 , 1.0926D+00 , 1.0266D+00 , 9.7585D-01 , 
     &      9.3473D-01 , 8.9976D-01 , 8.6898D-01 , 8.4068D-01 , 
     &      8.1374D-01 , 7.8714D-01 , 7.6011D-01 , 7.3262D-01 , 
     &      7.3148D-01 , 6.9170D-01 , 6.5270D-01 , 6.1357D-01 , 
     &      5.7426D-01 , 5.3417D-01 , 4.9316D-01 , 4.5166D-01 , 
     &      4.0914D-01 , 3.6649D-01 , 3.2429D-01 , 2.7651D-01 , 
     &      0.0000D+00 , 9.7091D+01 , 9.1127D+01 , 8.5440D+01 , 
     &      7.9869D+01 , 7.4603D+01 , 6.9275D+01 , 6.4220D+01 , 
     &      5.9343D+01 , 5.4780D+01 , 5.0195D+01 , 4.5912D+01 , 
     &      4.1816D+01 , 3.8028D+01 , 3.5857D+01 , 3.3637D+01 , 
     &      3.1205D+01 , 2.8880D+01 , 2.6695D+01 , 2.4601D+01 , 
     &      2.2923D+01 , 2.1219D+01 , 1.9374D+01 , 1.7634D+01 , 
     &      1.6009D+01 , 1.4488D+01 , 1.3276D+01 , 1.2064D+01 , 
     &      1.0772D+01 , 9.5709D+00 , 8.4795D+00 , 7.4649D+00 , 
     &      6.6775D+00 , 5.9046D+00 , 5.1015D+00 , 4.3733D+00 , 
     &      3.7372D+00 , 3.1677D+00 , 2.7434D+00 , 2.3459D+00 , 
     &      1.9566D+00 , 1.6317D+00 , 1.4368D+00 , 1.2699D+00 , 
     &      1.1572D+00 , 1.0581D+00 , 9.8558D-01 , 9.2913D-01 , 
     &      8.8297D-01 , 8.4349D-01 , 8.0862D-01 , 7.7667D-01 , 
     &      7.4686D-01 , 7.1760D-01 , 6.8906D-01 , 6.6005D-01 , 
     &      6.5493D-01 , 6.1209D-01 , 5.7080D-01 , 5.3038D-01 , 
     &      4.9085D-01 , 4.5137D-01 , 4.1231D-01 , 3.7316D-01 , 
     &      3.3442D-01 , 2.9613D-01 , 2.5928D-01 , 2.1912D-01 , 
     &      0.0000D+00 , 1.1660D+02 , 1.0899D+02 , 1.0178D+02 , 
     &      9.4752D+01 , 8.8142D+01 , 8.1480D+01/
      DATA (xgf_l(k),k=1027,1140)/7.5219D+01 , 6.9198D+01 , 6.3578D+01 , 
     &      5.7986D+01 , 5.2800D+01 , 4.7867D+01 , 4.3328D+01 , 
     &      4.0736D+01 , 3.8088D+01 , 3.5213D+01 , 3.2469D+01 , 
     &      2.9907D+01 , 2.7451D+01 , 2.5501D+01 , 2.3516D+01 , 
     &      2.1392D+01 , 1.9391D+01 , 1.7546D+01 , 1.5800D+01 , 
     &      1.4426D+01 , 1.3057D+01 , 1.1607D+01 , 1.0266D+01 , 
     &      9.0517D+00 , 7.9294D+00 , 7.0617D+00 , 6.2165D+00 , 
     &      5.3397D+00 , 4.5572D+00 , 3.8687D+00 , 3.2598D+00 , 
     &      2.8078D+00 , 2.3859D+00 , 1.9745D+00 , 1.6317D+00 , 
     &      1.4267D+00 , 1.2497D+00 , 1.1305D+00 , 1.0247D+00 , 
     &      9.4657D-01 , 8.8556D-01 , 8.3542D-01 , 7.9253D-01 , 
     &      7.5465D-01 , 7.2037D-01 , 6.8840D-01 , 6.5775D-01 , 
     &      6.2793D-01 , 5.9852D-01 , 5.9015D-01 , 5.4553D-01 , 
     &      5.0339D-01 , 4.6306D-01 , 4.2411D-01 , 3.8622D-01 , 
     &      3.4909D-01 , 3.1294D-01 , 2.7773D-01 , 2.4373D-01 , 
     &      2.1150D-01 , 1.7848D-01 , 0.0000D+00 , 1.3738D+02 , 
     &      1.2796D+02 , 1.1904D+02 , 1.1042D+02 , 1.0233D+02 , 
     &      9.4222D+01 , 8.6662D+01 , 7.9409D+01 , 7.2655D+01 , 
     &      6.6001D+01 , 5.9833D+01 , 5.4007D+01 , 4.8672D+01 , 
     &      4.5642D+01 , 4.2552D+01 , 3.9214D+01 , 3.6040D+01 , 
     &      3.3082D+01 , 3.0272D+01 , 2.8026D+01 , 2.5779D+01 , 
     &      2.3361D+01 , 2.1093D+01 , 1.9009D+01 , 1.7062D+01 , 
     &      1.5526D+01 , 1.4003D+01 , 1.2396D+01 , 1.0916D+01 , 
     &      9.5845D+00 , 8.3611D+00 , 7.4188D+00 , 6.5021D+00 , 
     &      5.5589D+00 , 4.7169D+00 , 3.9865D+00 , 3.3389D+00 , 
     &      2.8617D+00 , 2.4178D+00 , 1.9872D+00 , 1.6283D+00 , 
     &      1.4143D+00 , 1.2296D+00 , 1.1049D+00 , 9.9315D-01 , 
     &      9.1079D-01 , 8.4623D-01 , 7.9317D-01 , 7.4768D-01 , 
     &      7.0802D-01 , 6.7178D-01 , 6.3836D-01/
      DATA (xgf_l(k),k=1141,1254)/6.0703D-01 , 5.7658D-01 , 5.4733D-01 , 
     &      5.3630D-01 , 4.9100D-01 , 4.4879D-01 , 4.0920D-01 , 
     &      3.7138D-01 , 3.3521D-01 , 3.0054D-01 , 2.6721D-01 , 
     &      2.3523D-01 , 2.0485D-01 , 1.7634D-01 , 1.4852D-01 , 
     &      0.0000D+00 , 1.6103D+02 , 1.4938D+02 , 1.3848D+02 , 
     &      1.2798D+02 , 1.1818D+02 , 1.0840D+02 , 9.9309D+01 , 
     &      9.0651D+01 , 8.2647D+01 , 7.4733D+01 , 6.7469D+01 , 
     &      6.0672D+01 , 5.4433D+01 , 5.0913D+01 , 4.7343D+01 , 
     &      4.3482D+01 , 3.9833D+01 , 3.6452D+01 , 3.3242D+01 , 
     &      3.0689D+01 , 2.8134D+01 , 2.5404D+01 , 2.2863D+01 , 
     &      2.0531D+01 , 1.8362D+01 , 1.6652D+01 , 1.4967D+01 , 
     &      1.3197D+01 , 1.1573D+01 , 1.0120D+01 , 8.7877D+00 , 
     &      7.7679D+00 , 6.7819D+00 , 5.7685D+00 , 4.8731D+00 , 
     &      4.0967D+00 , 3.4122D+00 , 2.9097D+00 , 2.4451D+00 , 
     &      1.9953D+00 , 1.6222D+00 , 1.3995D+00 , 1.2076D+00 , 
     &      1.0771D+00 , 9.6151D-01 , 8.7563D-01 , 8.0819D-01 , 
     &      7.5269D-01 , 7.0548D-01 , 6.6395D-01 , 6.2666D-01 , 
     &      5.9253D-01 , 5.6034D-01 , 5.3005D-01 , 5.0122D-01 , 
     &      4.8790D-01 , 4.4273D-01 , 4.0115D-01 , 3.6251D-01 , 
     &      3.2632D-01 , 2.9224D-01 , 2.5988D-01 , 2.2931D-01 , 
     &      2.0039D-01 , 1.7324D-01 , 1.4805D-01 , 1.2201D-01 , 
     &      0.0000D+00 , 1.8591D+02 , 1.7193D+02 , 1.5886D+02 , 
     &      1.4632D+02 , 1.3469D+02 , 1.2310D+02 , 1.1237D+02 , 
     &      1.0218D+02 , 9.2839D+01 , 8.3643D+01 , 7.5256D+01 , 
     &      6.7382D+01 , 6.0231D+01 , 5.6204D+01 , 5.2127D+01 , 
     &      4.7743D+01 , 4.3601D+01 , 3.9784D+01 , 3.6172D+01 , 
     &      3.3310D+01 , 3.0455D+01 , 2.7410D+01 , 2.4579D+01 , 
     &      2.2009D+01 , 1.9599D+01 , 1.7727D+01 , 1.5886D+01 , 
     &      1.3956D+01 , 1.2193D+01 , 1.0620D+01/
      DATA (xgf_l(k),k=1255,1368)/9.1866D+00 , 8.0925D+00 , 7.0383D+00 , 
     &      5.9623D+00 , 5.0119D+00 , 4.1917D+00 , 3.4750D+00 , 
     &      2.9503D+00 , 2.4663D+00 , 1.9999D+00 , 1.6141D+00 , 
     &      1.3840D+00 , 1.1856D+00 , 1.0518D+00 , 9.3192D-01 , 
     &      8.4324D-01 , 7.7348D-01 , 7.1642D-01 , 6.6779D-01 , 
     &      6.2531D-01 , 5.8732D-01 , 5.5231D-01 , 5.2039D-01 , 
     &      4.9037D-01 , 4.6218D-01 , 4.4711D-01 , 4.0225D-01 , 
     &      3.6159D-01 , 3.2438D-01 , 2.8982D-01 , 2.5765D-01 , 
     &      2.2765D-01 , 1.9954D-01 , 1.7331D-01 , 1.4889D-01 , 
     &      1.2621D-01 , 9.6984D-02 , 0.0000D+00 , 2.1269D+02 , 
     &      1.9609D+02 , 1.8060D+02 , 1.6582D+02 , 1.5214D+02 , 
     &      1.3863D+02 , 1.2613D+02 , 1.1431D+02 , 1.0351D+02 , 
     &      9.2957D+01 , 8.3294D+01 , 7.4318D+01 , 6.6188D+01 , 
     &      6.1617D+01 , 5.7019D+01 , 5.2073D+01 , 4.7428D+01 , 
     &      4.3153D+01 , 3.9122D+01 , 3.5941D+01 , 3.2764D+01 , 
     &      2.9404D+01 , 2.6282D+01 , 2.3458D+01 , 2.0836D+01 , 
     &      1.8796D+01 , 1.6786D+01 , 1.4693D+01 , 1.2792D+01 , 
     &      1.1101D+01 , 9.5678D+00 , 8.4010D+00 , 7.2773D+00 , 
     &      6.1402D+00 , 5.1403D+00 , 4.2791D+00 , 3.5311D+00 , 
     &      2.9851D+00 , 2.4835D+00 , 2.0017D+00 , 1.6039D+00 , 
     &      1.3677D+00 , 1.1646D+00 , 1.0265D+00 , 9.0375D-01 , 
     &      8.1271D-01 , 7.4135D-01 , 6.8280D-01 , 6.3328D-01 , 
     &      5.9018D-01 , 5.5184D-01 , 5.1677D-01 , 4.8494D-01 , 
     &      4.5537D-01 , 4.2797D-01 , 4.1146D-01 , 3.6736D-01 , 
     &      3.2788D-01 , 2.9207D-01 , 2.5923D-01 , 2.2901D-01 , 
     &      2.0110D-01 , 1.7527D-01 , 1.5131D-01 , 1.2926D-01 , 
     &      1.0839D-01 , 6.9776D-02 , 0.0000D+00 , 2.4043D+02 , 
     &      2.2104D+02 , 2.0300D+02 , 1.8582D+02 , 1.7003D+02 , 
     &      1.5443D+02 , 1.4007D+02 , 1.2658D+02/
      DATA (xgf_l(k),k=1369,1482)/1.1426D+02 , 1.0227D+02 , 9.1332D+01 , 
     &      8.1197D+01 , 7.2119D+01 , 6.6989D+01 , 6.1846D+01 , 
     &      5.6342D+01 , 5.1188D+01 , 4.6448D+01 , 4.2002D+01 , 
     &      3.8498D+01 , 3.5016D+01 , 3.1335D+01 , 2.7931D+01 , 
     &      2.4848D+01 , 2.2009D+01 , 1.9797D+01 , 1.7637D+01 , 
     &      1.5389D+01 , 1.3354D+01 , 1.1550D+01 , 9.9187D+00 , 
     &      8.6824D+00 , 7.4988D+00 , 6.3022D+00 , 5.2549D+00 , 
     &      4.3589D+00 , 3.5788D+00 , 3.0139D+00 , 2.4962D+00 , 
     &      2.0005D+00 , 1.5931D+00 , 1.3514D+00 , 1.1435D+00 , 
     &      1.0028D+00 , 8.7751D-01 , 7.8479D-01 , 7.1218D-01 , 
     &      6.5272D-01 , 6.0250D-01 , 5.5920D-01 , 5.2061D-01 , 
     &      4.8590D-01 , 4.5422D-01 , 4.2519D-01 , 3.9858D-01 , 
     &      3.8094D-01 , 3.3789D-01 , 2.9975D-01 , 2.6524D-01 , 
     &      2.3401D-01 , 2.0560D-01 , 1.7956D-01 , 1.5565D-01 , 
     &      1.3374D-01 , 1.1354D-01 , 9.4096D-02 , 3.9275D-02 , 
     &      0.0000D+00 , 2.8195D+02 , 2.5830D+02 , 2.3640D+02 , 
     &      2.1554D+02 , 1.9645D+02 , 1.7774D+02 , 1.6058D+02 , 
     &      1.4448D+02 , 1.2990D+02 , 1.1575D+02 , 1.0299D+02 , 
     &      9.1121D+01 , 8.0574D+01 , 7.4642D+01 , 6.8724D+01 , 
     &      6.2402D+01 , 5.6498D+01 , 5.1101D+01 , 4.6042D+01 , 
     &      4.2081D+01 , 3.8152D+01 , 3.4014D+01 , 3.0201D+01 , 
     &      2.6780D+01 , 2.3611D+01 , 2.1171D+01 , 1.8789D+01 , 
     &      1.6329D+01 , 1.4107D+01 , 1.2148D+01 , 1.0386D+01 , 
     &      9.0557D+00 , 7.7874D+00 , 6.5118D+00 , 5.4006D+00 , 
     &      4.4539D+00 , 3.6370D+00 , 3.0467D+00 , 2.5088D+00 , 
     &      1.9959D+00 , 1.5762D+00 , 1.3274D+00 , 1.1142D+00 , 
     &      9.7065D-01 , 8.4265D-01 , 7.4825D-01 , 6.7451D-01 , 
     &      6.1445D-01 , 5.6374D-01 , 5.2024D-01 , 4.8166D-01 , 
     &      4.4741D-01 , 4.1643D-01 , 3.8830D-01/
      DATA (xgf_l(k),k=1483,1596)/3.6282D-01 , 3.4411D-01 , 3.0249D-01 , 
     &      2.6607D-01 , 2.3369D-01 , 2.0474D-01 , 1.7852D-01 , 
     &      1.5489D-01 , 1.3341D-01 , 1.1384D-01 , 9.5862D-02 , 
     &      7.7509D-02 , 0.0000D+00 , 0.0000D+00 , 3.2379D+02 , 
     &      2.9556D+02 , 2.6960D+02 , 2.4513D+02 , 2.2265D+02 , 
     &      2.0073D+02 , 1.8071D+02 , 1.6202D+02 , 1.4515D+02 , 
     &      1.2887D+02 , 1.1419D+02 , 1.0071D+02 , 8.8650D+01 , 
     &      8.1931D+01 , 7.5233D+01 , 6.8140D+01 , 6.1510D+01 , 
     &      5.5467D+01 , 4.9832D+01 , 4.5419D+01 , 4.1070D+01 , 
     &      3.6493D+01 , 3.2295D+01 , 2.8536D+01 , 2.5086D+01 , 
     &      2.2426D+01 , 1.9846D+01 , 1.7175D+01 , 1.4781D+01 , 
     &      1.2681D+01 , 1.0797D+01 , 9.3831D+00 , 8.0380D+00 , 
     &      6.6897D+00 , 5.5221D+00 , 4.5337D+00 , 3.6831D+00 , 
     &      3.0714D+00 , 2.5159D+00 , 1.9884D+00 , 1.5586D+00 , 
     &      1.3048D+00 , 1.0886D+00 , 9.4191D-01 , 8.1217D-01 , 
     &      7.1679D-01 , 6.4238D-01 , 5.8194D-01 , 5.3136D-01 , 
     &      4.8766D-01 , 4.4965D-01 , 4.1594D-01 , 3.8570D-01 , 
     &      3.5847D-01 , 3.3403D-01 , 3.1456D-01 , 2.7454D-01 , 
     &      2.3977D-01 , 2.0922D-01 , 1.8216D-01 , 1.5795D-01 , 
     &      1.3622D-01 , 1.1669D-01 , 9.9012D-02 , 8.2668D-02 , 
     &      6.4604D-02 , 0.0000D+00 , 0.0000D+00 , 3.7071D+02 , 
     &      3.3727D+02 , 3.0660D+02 , 2.7790D+02 , 2.5169D+02 , 
     &      2.2608D+02 , 2.0283D+02 , 1.8123D+02 , 1.6179D+02 , 
     &      1.4311D+02 , 1.2635D+02 , 1.1097D+02 , 9.7357D+01 , 
     &      8.9759D+01 , 8.2263D+01 , 7.4239D+01 , 6.6821D+01 , 
     &      6.0073D+01 , 5.3813D+01 , 4.8927D+01 , 4.4114D+01 , 
     &      3.9072D+01 , 3.4471D+01 , 3.0351D+01 , 2.6592D+01 , 
     &      2.3699D+01 , 2.0903D+01 , 1.8031D+01 , 1.5459D+01 , 
     &      1.3211D+01 , 1.1204D+01 , 9.7024D+00/
      DATA (xgf_l(k),k=1597,1710)/8.2828D+00 , 6.8644D+00 , 5.6367D+00 , 
     &      4.6059D+00 , 3.7241D+00 , 3.0915D+00 , 2.5189D+00 , 
     &      1.9786D+00 , 1.5396D+00 , 1.2816D+00 , 1.0611D+00 , 
     &      9.1306D-01 , 7.8207D-01 , 6.8594D-01 , 6.1118D-01 , 
     &      5.5075D-01 , 5.0031D-01 , 4.5732D-01 , 4.1996D-01 , 
     &      3.8671D-01 , 3.5732D-01 , 3.3101D-01 , 3.0775D-01 , 
     &      2.8769D-01 , 2.4931D-01 , 2.1637D-01 , 1.8763D-01 , 
     &      1.6241D-01 , 1.4002D-01 , 1.2013D-01 , 1.0238D-01 , 
     &      8.6311D-02 , 7.1348D-02 , 5.2982D-02 , 0.0000D+00 , 
     &      0.0000D+00 , 4.2142D+02 , 3.8237D+02 , 3.4660D+02 , 
     &      3.1292D+02 , 2.8259D+02 , 2.5300D+02 , 2.2626D+02 , 
     &      2.0148D+02 , 1.7927D+02 , 1.5797D+02 , 1.3896D+02 , 
     &      1.2163D+02 , 1.0632D+02 , 9.7858D+01 , 8.9366D+01 , 
     &      8.0488D+01 , 7.2234D+01 , 6.4771D+01 , 5.7843D+01 , 
     &      5.2468D+01 , 4.7182D+01 , 4.1663D+01 , 3.6633D+01 , 
     &      3.2165D+01 , 2.8082D+01 , 2.4971D+01 , 2.1960D+01 , 
     &      1.8866D+01 , 1.6118D+01 , 1.3723D+01 , 1.1595D+01 , 
     &      1.0008D+01 , 8.5101D+00 , 7.0232D+00 , 5.7443D+00 , 
     &      4.6705D+00 , 3.7584D+00 , 3.1066D+00 , 2.5189D+00 , 
     &      1.9659D+00 , 1.5193D+00 , 1.2575D+00 , 1.0346D+00 , 
     &      8.8517D-01 , 7.5338D-01 , 6.5695D-01 , 5.8219D-01 , 
     &      5.2200D-01 , 4.7218D-01 , 4.2954D-01 , 3.9258D-01 , 
     &      3.6043D-01 , 3.3190D-01 , 3.0663D-01 , 2.8431D-01 , 
     &      2.6413D-01 , 2.2746D-01 , 1.9612D-01 , 1.6912D-01 , 
     &      1.4557D-01 , 1.2488D-01 , 1.0660D-01 , 9.0362D-02 , 
     &      7.5731D-02 , 6.1890D-02 , 4.2720D-02 , 0.0000D+00 , 
     &      0.0000D+00 , 4.7166D+02 , 4.2676D+02 , 3.8580D+02 , 
     &      3.4749D+02 , 3.1273D+02 , 2.7927D+02 , 2.4899D+02 , 
     &      2.2108D+02 , 1.9611D+02 , 1.7230D+02/
      DATA (xgf_l(k),k=1711,1824)/1.5107D+02 , 1.3178D+02 , 1.1483D+02 , 
     &      1.0548D+02 , 9.6179D+01 , 8.6383D+01 , 7.7331D+01 , 
     &      6.9156D+01 , 6.1613D+01 , 5.5763D+01 , 5.0019D+01 , 
     &      4.4056D+01 , 3.8633D+01 , 3.3819D+01 , 2.9446D+01 , 
     &      2.6108D+01 , 2.2889D+01 , 1.9617D+01 , 1.6706D+01 , 
     &      1.4179D+01 , 1.1938D+01 , 1.0276D+01 , 8.7112D+00 , 
     &      7.1630D+00 , 5.8345D+00 , 4.7275D+00 , 3.7856D+00 , 
     &      3.1171D+00 , 2.5164D+00 , 1.9532D+00 , 1.4997D+00 , 
     &      1.2350D+00 , 1.0108D+00 , 8.6027D-01 , 7.2804D-01 , 
     &      6.3166D-01 , 5.5726D-01 , 4.9745D-01 , 4.4802D-01 , 
     &      4.0623D-01 , 3.7002D-01 , 3.3850D-01 , 3.1081D-01 , 
     &      2.8644D-01 , 2.6509D-01 , 2.4476D-01 , 2.0951D-01 , 
     &      1.7979D-01 , 1.5426D-01 , 1.3217D-01 , 1.1290D-01 , 
     &      9.5951D-02 , 8.0975D-02 , 6.7483D-02 , 5.4483D-02 , 
     &      3.4309D-02 , 0.0000D+00 , 0.0000D+00 , 5.2745D+02 , 
     &      4.7595D+02 , 4.2900D+02 , 3.8543D+02 , 3.4589D+02 , 
     &      3.0795D+02 , 2.7377D+02 , 2.4235D+02 , 2.1434D+02 , 
     &      1.8771D+02 , 1.6408D+02 , 1.4266D+02 , 1.2392D+02 , 
     &      1.1358D+02 , 1.0335D+02 , 9.2593D+01 , 8.2702D+01 , 
     &      7.3780D+01 , 6.5553D+01 , 5.9207D+01 , 5.2983D+01 , 
     &      4.6535D+01 , 4.0700D+01 , 3.5531D+01 , 3.0842D+01 , 
     &      2.7278D+01 , 2.3855D+01 , 2.0386D+01 , 1.7301D+01 , 
     &      1.4635D+01 , 1.2282D+01 , 1.0538D+01 , 8.9065D+00 , 
     &      7.2932D+00 , 5.9178D+00 , 4.7769D+00 , 3.8086D+00 , 
     &      3.1240D+00 , 2.5114D+00 , 1.9387D+00 , 1.4794D+00 , 
     &      1.2125D+00 , 9.8604D-01 , 8.3538D-01 , 7.0309D-01 , 
     &      6.0683D-01 , 5.3289D-01 , 4.7378D-01 , 4.2493D-01 , 
     &      3.8387D-01 , 3.4846D-01 , 3.1778D-01 , 2.9097D-01 , 
     &      2.6744D-01 , 2.4699D-01 , 2.2688D-01/
      DATA (xgf_l(k),k=1825,1836)/1.9308D-01 , 1.6489D-01 , 1.4079D-01 , 
     &      1.2009D-01 , 1.0214D-01 , 8.6447D-02 , 7.2603D-02 , 
     &      6.0131D-02 , 4.7893D-02 , 2.6613D-02 , 0.0000D+00 , 
     &      0.0000D+00/
 
C
      x = Xinp
C...CHECK OF X AND Q2 VALUES :
C        WRITE(LO,91) X
C 91     FORMAT (2X,'GRV98: x out of range',1p,E12.4)
C        STOP
      IF ( (x.LT.0.99D-09) .OR. (x.GT.1.D+00) ) x = 0.99D-09
 
      q2 = Q2inp
C        WRITE(LO,92) Q2
C 92     FORMAT (2X,'GRV98: Q2 out of range',1p,E12.4)
C        STOP
      IF ( (q2.LT.0.799D+00) .OR. (q2.GT.1.D+06) ) q2 = 0.99D+06
 
C
C...INTERPOLATION :
      na(1) = NX
      na(2) = NQ
      xt(1) = LOG(x)
      xt(2) = LOG(q2)
      x1 = 1.D+00 - x
      xv = x**0.5D+00
      xs = x**(-0.2D+00)
      Uv = PHO_DBFINT(NARG,xt,na,arrf,xuvf)*x1**3*xv
      Dv = PHO_DBFINT(NARG,xt,na,arrf,xdvf)*x1**4*xv
      de = PHO_DBFINT(NARG,xt,na,arrf,xdef)*x1**7*xv
      ud = PHO_DBFINT(NARG,xt,na,arrf,xudf)*x1**7*xs
      Us = 0.5*(ud-de)
      Ds = 0.5*(ud+de)
      Ss = PHO_DBFINT(NARG,xt,na,arrf,xsf)*x1**7*xs
      Gl = PHO_DBFINT(NARG,xt,na,arrf,xgf)*x1**5*xs
 
      END SUBROUTINE
