
      SUBROUTINE PHO_PARDAT
C***********************************************************************
C
C     particle data (based on 1996 PDG naming scheme and data tables)
C
C***********************************************************************
 
      IMPLICIT NONE
 
      SAVE 
 
C  input/output channels
      INCLUDE 'inc/poinou'
C  event debugging information
      INCLUDE 'inc/podebg'
C  particle ID translation table
      INCLUDE 'inc/popar1'
C  general particle data
      INCLUDE 'inc/popar2'
C  particle decay data
      INCLUDE 'inc/popar3'
 
C  external functions
 
      INTEGER IPHO_PDG2ID
      DOUBLE PRECISION PHO_PMASS
 
C  local variables for storing data tables
 
      INTEGER number , ich3 , iba3 , iq_linear , idec_linear , 
     &        isec_linear , id_psm_linear , id_vem_linear , 
     &        id_b8_linear , id_b10_linear
 
      DIMENSION number(300) , ich3(300) , iba3(300) , iq_linear(900) , 
     &          idec_linear(900) , isec_linear(900) , id_psm_linear(36)
     &          , id_vem_linear(36) , id_b8_linear(216) , 
     &          id_b10_linear(216)
 
      DOUBLE PRECISION xmass , gamma , wg_chan
      DIMENSION xmass(300) , gamma(300) , wg_chan(300)
 
      CHARACTER*12 name
      DIMENSION name(300)
 
      INTEGER i , i1 , i2 , ii , j , jj , k , l , ichan , i_tab_max , 
     &        k8 , k10 , l8 , l10
      DOUBLE PRECISION am1 , am2 , am2p , am2v , am82 , am102 , amm
 
      INTEGER itmp
 
      DATA i_tab_max/260/
 
      DATA (number(K),K=    1,  171) /
     &     1,     2,     3,     4,     5,     6,  1103,  2101,  2103,
     &  2203,  3101,  3103,  3201,  3203,  3303,  4101,  4103,  4201,
     &  4203,  4301,  4303,  4403,    81,    82,    90,    91,    92,
     &   110,   990,    21,    22,    24,    23,    11,    13,    15,
     &    12,    14,    16,   211,   111,   221,   113,   213,   223,
     &   331, 10221, 10111, 10211,   333, 10223, 10113, 10213, 20113,
     & 20213,   225, 20223, 20221, 20111, 20211,   115,   215, 30223,
     & 50223, 40113, 40213, 50221,   335, 60223,   227, 10115, 10215,
     & 10333,   117,   217, 30113, 30213, 60221,   337, 20225,   229,
     & 30225, 40225,   321,   311,   310,   130,   323,   313, 10313,
     & 10323, 20313, 20323, 30313, 30323, 10311, 10321,   325,   315,
     & 40313, 40323, 10315, 10325,   317,   327, 20315, 20325,   319,
     &   329,   411,   421,   423,   413, 10423,   425,   415,   431,
     &   433, 10433,   521,   511,   513,   523,   531,   441,   443,
     & 10441, 10443,   445, 20443, 30443, 40443, 50443, 60443,   553,
     &   551, 10553,   555, 20553, 10551, 70553, 10555, 30553, 40553,
     & 50553, 60553,  2212,  2112, 12112, 12212,  1214,  2124, 22112,
     & 22212, 32112, 32212,  2116,  2216, 12116, 12216, 21214, 22124,
     & 42112, 42212, 31214, 32124,  1218,  2128,  1114,  2114,  2214/
      DATA (number(K),K=  172,  260) /
     &  2224, 31114, 32114, 32214, 32224,  1112,  1212,  2122,  2222,
     & 11114, 12114, 12214, 12224,  1116,  1216,  2126,  2226, 21112,
     & 21212, 22122, 22222, 21114, 22114, 22214, 22224, 11116, 11216,
     & 12126, 12226,  1118,  2118,  2218,  2228,  3122, 13122,  3124,
     & 23122, 33122, 13124, 43122, 53122,  3126, 13126, 23124,  3128,
     & 23126,  3222,  3212,  3112,  3224,  3214,  3114, 13112, 13212,
     & 13222, 13114, 13214, 13224, 23112, 23212, 23222,  3116,  3216,
     &  3226, 13116, 13216, 13226, 23114, 23214, 23224,  3118,  3218,
     &  3228,  3322,  3312,  3324,  3314, 13314, 13324,  3334,  4122,
     & 14122,  4222,  4212,  4112,  4232,  4132,  4332,  5122/
      DATA (name(K),K=    1,   76) /
     &'d           ','u           ','s           ','c           ',
     &'b           ','t           ','(dd)_1      ','(ud)_0      ',
     &'(ud)_1      ','(uu)_1      ','(sd)_0      ','(sd)_1      ',
     &'(su)_0      ','(su)_1      ','(ss)_1      ','(cd)_0      ',
     &'(cd)_1      ','(cu)_0      ','(cu)_1      ','(cs)_0      ',
     &'(cs)_1      ','(cc)_1      ','remnant 1   ','remnant 2   ',
     &'string      ','mod. string ','coll. string','reggeon     ',
     &'pomeron     ','gluon       ','gamma       ','W           ',
     &'Z           ','e           ','mu          ','tau         ',
     &'nu(e)       ','nu(mu)      ','nu(tau)     ','pi          ',
     &'pi          ','eta         ','rho(770)    ','rho(770)    ',
     &'ome(782)    ','etap(958)   ','f(0)(980)   ','a(0)(980)   ',
     &'a(0)(980)   ','phi(1020)   ','h(1)(1170)  ','b(1)(1235)  ',
     &'b(1)(1235)  ','a(1)(1260)  ','a(1)(1260)  ','f(2)(1270)  ',
     &'f(1)(1285)  ','eta(1295)   ','pi(1300)    ','pi(1300)    ',
     &'a(2)(1320)  ','a(2)(1320)  ','f(1)(1420)  ','ome(1420)   ',
     &'rho(1450)   ','rho(1450)   ','f(0)(1500)  ','f(2)p(1525) ',
     &'ome(1600)   ','ome(3)(1670)','pi(2)(1670) ','pi(2)(1670) ',
     &'phi(1680)   ','rho(3)(1690)','rho(3)(1690)','rho(1700)   '/
      DATA (name(K),K=   77,  152) /
     &'rho(1700)   ','f(J)(1710)  ','phi(3)(1850)','f(2)(2010)  ',
     &'f(4)(2050)  ','f(2)(2300)  ','f(2)(2340)  ','K           ',
     &'K           ','K(S)        ','K(L)        ','K*(892)     ',
     &'K*(892)     ','K(1)(1270)  ','K(1)(1270)  ','K(1)(1400)  ',
     &'K(1)(1400)  ','K*(1410)    ','K*(1410)    ','K(0)*(1430) ',
     &'K(0)*(1430) ','K(2)*(1430) ','K(2)*(1430) ','K*(1680)    ',
     &'K*(1680)    ','K(2)(1770)  ','K(2)(1770)  ','K(3)*(1780) ',
     &'K(3)*(1780) ','K(2)(1820)  ','K(2)(1820)  ','K(4)*(2045) ',
     &'K(4)*(2045) ','D           ','D           ','D*(2007)    ',
     &'D*(2010)    ','D(1)(2420)  ','D(2)*(2460) ','D(2)*(2460) ',
     &'D(s)        ','D(s)*       ','D(s1)(2536) ','B           ',
     &'B           ','B*          ','B*          ','B(s)        ',
     &'eta(c)(1S)  ','J/psi(1S)   ','chi(c0)(1P) ','chi(c1)(1P) ',
     &'chi(c2)(1P) ','psi(2S)     ','psi(3770)   ','psi(4040)   ',
     &'psi(4160)   ','psi(4415)   ','Ups(1S)     ','chi(b0)(1P) ',
     &'chi(b1)(1P) ','chi(b2)(1P) ','Ups(2S)     ','chi(b0)(2P) ',
     &'chi(b1)(2P) ','chi(b2)(2P) ','Ups(3S)     ','Ups(4S)     ',
     &'Ups(10860)  ','Ups(11020)  ','p           ','n           ',
     &'N(1440)     ','N(1440)     ','N(1520)     ','N(1520)     '/
      DATA (name(K),K=  153,  228) /
     &'N(1535)     ','N(1535)     ','N(1650)     ','N(1650)     ',
     &'N(1675)     ','N(1675)     ','N(1680)     ','N(1680)     ',
     &'N(1700)     ','N(1700)     ','N(1710)     ','N(1710)     ',
     &'N(1720)     ','N(1720)     ','N(2190)     ','N(2190)     ',
     &'Del(1232)   ','Del(1232)   ','Del(1232)   ','Del(1232)   ',
     &'Del(1600)   ','Del(1600)   ','Del(1600)   ','Del(1600)   ',
     &'Del(1620)   ','Del(1620)   ','Del(1620)   ','Del(1620)   ',
     &'Del(1700)   ','Del(1700)   ','Del(1700)   ','Del(1700)   ',
     &'Del(1905)   ','Del(1905)   ','Del(1905)   ','Del(1905)   ',
     &'Del(1910)   ','Del(1910)   ','Del(1910)   ','Del(1910)   ',
     &'Del(1920)   ','Del(1920)   ','Del(1920)   ','Del(1920)   ',
     &'Del(1930)   ','Del(1930)   ','Del(1930)   ','Del(1930)   ',
     &'Del(1950)   ','Del(1950)   ','Del(1950)   ','Del(1950)   ',
     &'Lambda      ','Lam(1405)   ','Lam(1520)   ','Lam(1600)   ',
     &'Lam(1670)   ','Lam(1690)   ','Lam(1800)   ','Lam(1810)   ',
     &'Lam(1820)   ','Lam(1830)   ','Lam(1890)   ','Lam(2100)   ',
     &'Lam(2110)   ','Sigma       ','Sigma       ','Sigma       ',
     &'Sig(1385)   ','Sig(1385)   ','Sig(1385)   ','Sig(1660)   ',
     &'Sig(1660)   ','Sig(1660)   ','Sig(1670)   ','Sig(1670)   '/
      DATA (name(K),K=  229,  260) /
     &'Sig(1670)   ','Sig(1750)   ','Sig(1750)   ','Sig(1750)   ',
     &'Sig(1775)   ','Sig(1775)   ','Sig(1775)   ','Sig(1915)   ',
     &'Sig(1915)   ','Sig(1915)   ','Sig(1940)   ','Sig(1940)   ',
     &'Sig(1940)   ','Sig(2030)   ','Sig(2030)   ','Sig(2030)   ',
     &'Xi          ','Xi          ','Xi(1530)    ','Xi(1530)    ',
     &'Xi(1820)    ','Xi(1820)    ','Omega       ','Lam(c)      ',
     &'Lam(c)(2593)','Sig(c)(2455)','Sig(c)(2455)','Sig(c)(2455)',
     &'Xi(c)       ','Xi(c)       ','Ome(c)      ','Lam(b)      '/
      DATA (ich3(K),K=    1,  260) /
     &-1, 2,-1, 2,-1, 2,-2, 1, 1, 4,-2,-2, 1, 1,-2, 1, 1, 4, 4, 1, 1, 4,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,-3,-3,-3, 0, 0, 0, 3, 0, 0, 0, 3,
     & 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 3,
     & 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3,
     & 0, 0, 3, 0, 3, 0, 3, 0, 3, 3, 0, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 3,
     & 0, 0, 3, 0, 0, 3, 3, 3, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 3,
     & 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,-3, 0, 3, 6,-3, 0, 3, 6,
     &-3, 0, 3, 6,-3, 0, 3, 6,-3, 0, 3, 6,-3, 0, 3, 6,-3, 0, 3, 6,-3, 0,
     & 3, 6,-3, 0, 3, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,-3,
     & 3, 0,-3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3,
     & 0, 3, 0,-3, 0,-3,-3, 0,-3, 3, 3, 6, 3, 0, 3, 0, 0, 0/
      DATA (iba3(K),K=    1,  260) /
     &1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
     &3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
     &3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
     &3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3/
      DATA (iq_linear(K),K=    1,  418) /
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 2,
     & 1, 0, 2, 1, 0, 2, 2, 0, 3, 1, 0, 3, 1, 0, 3, 2, 0, 3, 2, 0, 3, 3,
     & 0, 4, 1, 0, 4, 1, 0, 4, 2, 0, 4, 2, 0, 4, 3, 0, 4, 3, 0, 4, 4, 0,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     & 0, 0, 0, 0, 0, 0, 0, 2,-1, 0, 1,-1, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0,
     & 2,-2, 0, 3,-3, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0, 3,-3, 0, 2,-2, 0, 1,
     &-1, 0, 2,-1, 0, 1,-1, 0, 2, 1, 0, 2,-2, 0, 2,-2, 0, 2,-2, 0, 1,-1,
     & 0, 2,-1, 0, 1,-1, 0, 2,-1, 0, 2,-2, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0,
     & 2,-2, 0, 3,-3, 0, 2,-2, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0, 3,-3, 0, 1,
     &-1, 0, 2,-1, 0, 1,-1, 0, 2,-1, 0, 2,-2, 0, 3,-3, 0, 2,-2, 0, 2,-2,
     & 0, 2,-2, 0, 2,-2, 0, 2,-3, 0, 1,-3, 0, 1,-3, 0, 3,-1, 0, 2,-3, 0,
     & 1,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 1,
     &-3, 0, 2,-3, 0, 2,-3, 0, 1,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3,
     & 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 4,-1, 0,
     & 4,-2, 0, 4,-2, 0, 4,-1, 0, 4,-2, 0, 4,-2, 0, 4,-1, 0, 4,-3, 0, 4,
     &-3, 0, 4,-3, 0, 2,-5, 0, 1,-5, 0, 1,-5, 0, 2,-5, 0, 3,-5, 0, 4,-4,
     & 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0,
     & 4,-4, 0, 4,-4, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5/
      DATA (iq_linear(K),K=  419,  780) /
     &-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 2, 2,
     & 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 2, 1,
     & 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2,
     & 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1,
     & 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2,
     & 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2,
     & 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1,
     & 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 2, 1,
     & 2, 1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 3, 1, 2, 3,
     & 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1,
     & 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 2, 2, 3, 2, 1, 3, 1, 1, 3,
     & 3, 2, 2, 3, 2, 1, 3, 1, 1, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1, 3,
     & 2, 1, 3, 2, 2, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1, 3, 2, 1, 3, 2,
     & 2, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1,
     & 3, 2, 1, 3, 2, 2, 2, 3, 3, 1, 3, 3, 2, 3, 3, 1, 3, 3, 3, 3, 1, 3,
     & 3, 2, 3, 3, 3, 2, 1, 4, 4, 1, 2, 2, 2, 4, 2, 1, 2, 1, 1, 4, 3, 2,
     & 2, 3, 1, 2, 3, 3, 4, 5, 1, 2/
      DATA (xmass(K),K=    1,  114) /
     &3.0000E-01,3.0000E-01,3.5000E-01,1.4500E+00,4.5000E+00,1.7400E+02,
     &7.7133E-01,5.7933E-01,7.7133E-01,7.7133E-01,8.0473E-01,9.2953E-01,
     &8.0473E-01,9.2953E-01,1.0936E+00,1.9691E+00,2.0081E+00,1.9691E+00,
     &2.0081E+00,2.1543E+00,2.1797E+00,3.2753E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,8.0410E+01,9.1187E+01,5.1100E-04,1.0566E-01,1.7771E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,1.3957E-01,1.3498E-01,5.4730E-01,
     &7.7000E-01,7.7000E-01,7.8194E-01,9.5778E-01,9.8000E-01,9.8340E-01,
     &9.8340E-01,1.0194E+00,1.1700E+00,1.2295E+00,1.2295E+00,1.2300E+00,
     &1.2300E+00,1.2750E+00,1.2819E+00,1.2970E+00,1.3000E+00,1.3000E+00,
     &1.3181E+00,1.3181E+00,1.4262E+00,1.4190E+00,1.4650E+00,1.4650E+00,
     &1.5000E+00,1.5250E+00,1.6490E+00,1.6670E+00,1.6700E+00,1.6700E+00,
     &1.6800E+00,1.6910E+00,1.6910E+00,1.7000E+00,1.7000E+00,1.7120E+00,
     &1.8540E+00,2.0100E+00,2.0440E+00,2.2970E+00,2.3400E+00,4.9368E-01,
     &4.9767E-01,4.9767E-01,4.9767E-01,8.9166E-01,8.9610E-01,1.2720E+00,
     &1.2720E+00,1.4020E+00,1.4020E+00,1.4140E+00,1.4140E+00,1.4290E+00,
     &1.4290E+00,1.4256E+00,1.4324E+00,1.7170E+00,1.7170E+00,1.7730E+00,
     &1.7730E+00,1.7760E+00,1.7760E+00,1.8160E+00,1.8160E+00,2.0450E+00,
     &2.0450E+00,1.8693E+00,1.8646E+00,2.0067E+00,2.0100E+00,2.4222E+00/
      DATA (xmass(K),K=  115,  228) /
     &2.4589E+00,2.4590E+00,1.9685E+00,2.1124E+00,2.5353E+00,5.2789E+00,
     &5.2792E+00,5.3249E+00,5.3249E+00,5.3693E+00,2.9798E+00,3.0969E+00,
     &3.4173E+00,3.5105E+00,3.5562E+00,3.6860E+00,3.7699E+00,4.0400E+00,
     &4.1590E+00,4.4150E+00,9.4604E+00,9.8598E+00,9.8919E+00,9.9132E+00,
     &1.0023E+01,1.0232E+01,1.0255E+01,1.0268E+01,1.0355E+01,1.0580E+01,
     &1.0865E+01,1.1019E+01,9.3827E-01,9.3957E-01,1.4400E+00,1.4400E+00,
     &1.5200E+00,1.5200E+00,1.5350E+00,1.5350E+00,1.6500E+00,1.6500E+00,
     &1.6750E+00,1.6750E+00,1.6800E+00,1.6800E+00,1.7000E+00,1.7000E+00,
     &1.7100E+00,1.7100E+00,1.7200E+00,1.7200E+00,2.1900E+00,2.1900E+00,
     &1.2320E+00,1.2320E+00,1.2320E+00,1.2320E+00,1.6000E+00,1.6000E+00,
     &1.6000E+00,1.6000E+00,1.6200E+00,1.6200E+00,1.6200E+00,1.6200E+00,
     &1.7000E+00,1.7000E+00,1.7000E+00,1.7000E+00,1.9050E+00,1.9050E+00,
     &1.9050E+00,1.9050E+00,1.9100E+00,1.9100E+00,1.9100E+00,1.9100E+00,
     &1.9200E+00,1.9200E+00,1.9200E+00,1.9200E+00,1.9300E+00,1.9300E+00,
     &1.9300E+00,1.9300E+00,1.9500E+00,1.9500E+00,1.9500E+00,1.9500E+00,
     &1.1157E+00,1.4070E+00,1.5195E+00,1.6000E+00,1.6700E+00,1.6900E+00,
     &1.8000E+00,1.8100E+00,1.8200E+00,1.8300E+00,1.8900E+00,2.1000E+00,
     &2.1100E+00,1.1894E+00,1.1926E+00,1.1974E+00,1.3828E+00,1.3837E+00,
     &1.3872E+00,1.6600E+00,1.6600E+00,1.6600E+00,1.6700E+00,1.6700E+00/
      DATA (xmass(K),K=  229,  260) /
     &1.6700E+00,1.7500E+00,1.7500E+00,1.7500E+00,1.7750E+00,1.7750E+00,
     &1.7750E+00,1.9150E+00,1.9150E+00,1.9150E+00,1.9400E+00,1.9400E+00,
     &1.9400E+00,2.0300E+00,2.0300E+00,2.0300E+00,1.3149E+00,1.3213E+00,
     &1.5318E+00,1.5350E+00,1.8230E+00,1.8230E+00,1.6724E+00,2.2849E+00,
     &2.5939E+00,2.4528E+00,2.4536E+00,2.4522E+00,2.4656E+00,2.4703E+00,
     &2.7040E+00,5.6240E+00/
      DATA (gamma(K),K=    1,  114) /
     &8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,
     &8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,
     &8.0000E-01,8.0000E-01,8.0000E-01,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,2.0600E+00,2.4900E+00,0.0000E+00,2.9959E-19,2.2700E-12,
     &0.0000E+00,0.0000E+00,0.0000E+00,2.5284E-17,7.8000E-09,1.1800E-06,
     &1.5070E-01,1.5070E-01,8.4100E-03,2.0300E-04,0.0000E+00,0.0000E+00,
     &0.0000E+00,4.4300E-03,3.6000E-01,1.4200E-01,1.4200E-01,0.0000E+00,
     &0.0000E+00,1.8550E-01,2.4000E-02,5.3000E-02,0.0000E+00,0.0000E+00,
     &1.0700E-01,1.0700E-01,5.5000E-02,1.7000E-01,3.1000E-01,3.1000E-01,
     &1.1200E-01,7.6000E-02,2.2000E-01,1.6800E-01,2.5800E-01,2.5800E-01,
     &1.5000E-01,1.6000E-01,1.6000E-01,2.4000E-01,2.4000E-01,1.3300E-01,
     &8.7000E-02,2.0000E-01,2.0800E-01,1.5000E-01,3.2000E-01,5.3140E-17,
     &0.0000E+00,7.3730E-15,1.2730E-17,5.0800E-02,5.0500E-02,9.0000E-02,
     &9.0000E-02,1.7400E-01,1.7400E-01,2.3200E-01,2.3200E-01,2.8700E-01,
     &2.8700E-01,9.8500E-02,1.0900E-01,3.2000E-01,3.2000E-01,1.8600E-01,
     &1.8600E-01,1.5900E-01,1.5900E-01,2.7600E-01,2.7600E-01,1.9800E-01,
     &1.9800E-01,6.2300E-13,1.5860E-12,5.0000E-03,2.0000E-03,1.8900E-02/
      DATA (gamma(K),K=  115,  228) /
     &2.3000E-02,2.5000E-02,1.4100E-12,2.0000E-03,0.0000E+00,3.9900E-13,
     &4.2200E-13,0.0000E+00,0.0000E+00,4.2700E-13,1.3200E-02,8.7000E-05,
     &1.4000E-02,8.8000E-04,2.0000E-03,2.7700E-04,2.3600E-02,5.2000E-02,
     &7.8000E-02,4.3000E-02,5.2500E-05,0.0000E+00,0.0000E+00,0.0000E+00,
     &4.4000E-05,0.0000E+00,0.0000E+00,0.0000E+00,2.6300E-05,1.0000E-02,
     &1.1000E-01,7.9000E-02,0.0000E+00,7.4240E-28,3.5000E-01,3.5000E-01,
     &1.2000E-01,1.2000E-01,1.5000E-01,1.5000E-01,1.5000E-01,1.5000E-01,
     &1.5000E-01,1.5000E-01,1.3000E-01,1.3000E-01,1.0000E-01,1.0000E-01,
     &1.0000E-01,1.0000E-01,1.5000E-01,1.5000E-01,4.5000E-01,4.5000E-01,
     &1.2000E-01,1.2000E-01,1.2000E-01,1.2000E-01,3.5000E-01,3.5000E-01,
     &3.5000E-01,3.5000E-01,1.5000E-01,1.5000E-01,1.5000E-01,1.5000E-01,
     &3.0000E-01,3.0000E-01,3.0000E-01,3.0000E-01,3.5000E-01,3.5000E-01,
     &3.5000E-01,3.5000E-01,2.5000E-01,2.5000E-01,2.5000E-01,2.5000E-01,
     &2.0000E-01,2.0000E-01,2.0000E-01,2.0000E-01,3.5000E-01,3.5000E-01,
     &3.5000E-01,3.5000E-01,3.0000E-01,3.0000E-01,3.0000E-01,3.0000E-01,
     &2.5010E-15,5.0000E-02,1.5600E-02,1.5000E-01,3.5000E-02,6.0000E-02,
     &3.0000E-01,1.5000E-01,8.0000E-02,9.5000E-02,1.0000E-01,2.0000E-01,
     &2.0000E-01,8.2400E-15,8.9000E-06,4.4500E-15,3.5800E-02,3.6000E-02,
     &3.9400E-02,1.0000E-01,1.0000E-01,1.0000E-01,6.0000E-02,6.0000E-02/
      DATA (gamma(K),K=  229,  260) /
     &6.0000E-02,9.0000E-02,9.0000E-02,9.0000E-02,1.2000E-01,1.2000E-01,
     &1.2000E-01,1.2000E-01,1.2000E-01,1.2000E-01,2.2000E-01,2.2000E-01,
     &2.2000E-01,1.8000E-01,1.8000E-01,1.8000E-01,2.2700E-15,4.0200E-15,
     &9.1000E-03,9.9000E-03,2.4000E-02,2.4000E-02,8.0100E-15,3.1900E-12,
     &3.6000E-03,0.0000E+00,0.0000E+00,0.0000E+00,1.8600E-12,6.7000E-12,
     &1.0200E-11,5.3100E-13/
      DATA (idec_linear(K),K=    1,  304) /
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  3,  1,  1,  2,  2,  6,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  3,  7,  7,  3,  8,  9,  1, 10, 14,  1, 15,
     & 16,  1, 17, 17,  1, 18, 20,  1, 21, 24,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  1, 25, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 30, 32,
     &  1, 33, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 35, 37,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  1, 38, 39,  0,  0,  0,  0,  0,
     &  0,  1, 40, 40,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  3, 41, 46,  0,  0,  0,  3,
     & 47, 48,  3, 49, 52,  1, 53, 54,  1, 55, 56,  1, 57, 58,  1, 59,
     & 60,  0,  0,  0,  0,  0,  0,  1, 61, 68,  1, 69, 76,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/
      DATA (idec_linear(K),K=  305,  608) /
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  2, 77, 78,  2, 79, 82,  1, 83, 84,
     &  1, 85, 87,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2, 88, 90,  1,
     & 91, 92,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  2, 93, 95,  1, 96, 98,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  1, 99,101,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,102,102,  1,103,112,  1,
     &113,122,  0,  0,  0,  0,  0,  0,  1,123,129,  1,130,136,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  1,137,144,  1,145,152,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  1,153,153,  1,154,155,  1,156,
     &157,  1,158,158,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,159,162,  1,
     &163,169,  1,170,176,  1,177,180,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/
      DATA (idec_linear(K),K=  609,  780) /
     &  0,  0,  0,  0,  3,181,182,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,183,184,  3,185,
     &185,  3,186,186,  1,187,189,  1,190,192,  1,193,194,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,195,203,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  1,204,216,  0,  0,  0,  3,217,217,  3,
     &218,218,  1,219,220,  1,221,222,  0,  0,  0,  0,  0,  0,  2,223,
     &225,  2,226,239,  0,  0,  0,  2,240,240,  2,241,241,  2,242,242,
     &  2,243,246,  2,247,251,  2,252,255,  0,  0,  0/
      DATA (isec_linear(K),K=    1,  152) /
     &     11,     12,    -12,     13,    -14,     16,     11,    -12,
     &     16,   -213,     16,      0,   -211,     16,      0,   -323,
     &     16,      0,    -13,     12,      0,     22,     22,      0,
     &     22,    -11,     11,     22,     22,      0,    111,     22,
     &     22,    111,    111,    111,    211,   -211,    111,    211,
     &   -211,     22,    211,   -211,      0,    111,    111,      0,
     &    211,    111,      0,    211,   -211,    111,    211,   -211,
     &      0,    111,     22,      0,    221,    211,   -211,    221,
     &    111,    111,    211,   -211,     22,     22,     22,      0,
     &    321,   -321,      0,    130,    310,      0,    113,    111,
     &      0,    211,   -211,    111,    221,     22,      0,    113,
     &    111,      0,   -213,    211,      0,    213,   -211,      0,
     &    211,   -211,      0,    111,    111,      0,    113,    111,
     &      0,   -213,    211,      0,    213,   -211,      0,    311,
     &   -313,      0,   -311,    313,      0,    113,    211,   -211,
     &    -13,     12,      0,    211,    111,      0,    211,    211,
     &   -211,    211,    111,    111,    -13,    111,     12,    -11,
     &    111,     12,    211,   -211,      0,    111,    111,      0,
     &    111,    111,    111,    211,   -211,    111,    211,     13/
      DATA (isec_linear(K),K=  153,  304) /
     &     12,    211,     11,     12,    321,    111,      0,    311,
     &    211,      0,    311,    111,      0,    321,   -211,      0,
     &    311,    111,      0,    321,   -211,      0,    321,    111,
     &      0,    311,    211,      0,    311,    111,      0,    321,
     &   -211,      0,    313,    111,      0,    323,   -211,      0,
     &    311,    113,      0,    321,   -213,      0,    311,    223,
     &      0,    311,    221,      0,    321,    111,      0,    311,
     &    211,      0,    323,    111,      0,    313,    211,      0,
     &    321,    113,      0,    311,    213,      0,    321,    223,
     &      0,    321,    221,      0,   -321,    211,    211,   -311,
     &    211,      0,   -321,    211,      0,   -321,    211,    111,
     &    311,    211,   -211,    311,    111,      0,    421,    111,
     &      0,    421,     22,      0,    421,    211,      0,    411,
     &    111,      0,    411,     22,      0,    221,    211,      0,
     &    321,   -321,    321,    321,   -311,      0,    431,     22,
     &      0,    431,     22,      0,    111,    111,      0,    211,
     &   -211,      0,     22,     22,      0,    -11,     11,      0,
     &    -13,     13,      0,    211,   -211,    111,    443,    211,
     &   -211,    443,    111,    111,    443,    221,      0,   2212/
      DATA (isec_linear(K),K=  305,  456) /
     &     11,     12,   2112,    111,      0,   2212,   -211,      0,
     &   2112,    111,    111,   2112,    211,   -211,   1114,    211,
     &      0,   2114,    111,      0,   2214,   -211,      0,   2112,
     &    113,      0,   2212,   -213,      0,   2112,    221,      0,
     &   2212,    111,      0,   2112,    211,      0,   2212,    111,
     &    111,   2212,    211,   -211,   2224,   -211,      0,   2214,
     &    111,      0,   2114,    211,      0,   2212,    113,      0,
     &   2112,    213,      0,   2212,    221,      0,   2212,   -211,
     &      0,   2112,    111,      0,   2214,   -211,      0,   2114,
     &    111,      0,   1114,    211,      0,   2212,   -213,      0,
     &   2112,    113,      0,   2212,    111,      0,   2112,    211,
     &      0,   2224,   -211,      0,   2214,    111,      0,   2114,
     &    211,      0,   2212,    113,      0,   2112,    213,      0,
     &   2212,   -211,      0,   2112,    111,      0,   2212,   -213,
     &      0,   2112,    113,      0,   3122,    311,      0,   3212,
     &    311,      0,   3112,    321,      0,   2112,    221,      0,
     &   2212,    111,      0,   2112,    211,      0,   2212,    113,
     &      0,   2112,    213,      0,   3122,    321,      0,   3222,
     &    311,      0,   3212,    321,      0,   2212,    221,      0/
      DATA (isec_linear(K),K=  457,  608) /
     &   2112,   -211,      0,   2212,   -211,      0,   2112,    111,
     &      0,   2212,    111,      0,   2112,    211,      0,   2212,
     &    211,      0,   2112,   -211,      0,   2114,   -211,      0,
     &   1114,    111,      0,   2112,   -213,      0,   2212,   -211,
     &      0,   2112,    111,      0,   2214,   -211,      0,   2114,
     &    111,      0,   1114,    211,      0,   2212,   -213,      0,
     &   2112,    113,      0,   2212,    111,      0,   2112,    211,
     &      0,   2224,   -211,      0,   2214,    111,      0,   2114,
     &    211,      0,   2212,    113,      0,   2112,    213,      0,
     &   2212,    211,      0,   2224,    111,      0,   2214,    211,
     &      0,   2212,    213,      0,   2212,   -211,      0,   2112,
     &    111,      0,   2212,    111,      0,   2112,    211,      0,
     &   3122,     22,      0,   2112,   -211,      0,   3122,    211,
     &      0,   3212,    211,      0,   3222,    111,      0,   3122,
     &    111,      0,   3222,   -211,      0,   3112,    211,      0,
     &   3122,   -211,      0,   3212,   -211,      0,   2112,   -311,
     &      0,   2212,   -321,      0,   3222,   -211,      0,   3212,
     &    111,      0,   3112,    211,      0,   3122,    221,      0,
     &   3224,   -211,      0,   3114,    211,      0,   3214,    111/
      DATA (isec_linear(K),K=  609,  760) /
     &      0,   2112,   -311,      0,   2212,   -321,      0,   3122,
     &    111,      0,   3122,    223,      0,   3122,    113,      0,
     &   3222,   -213,      0,   3112,    213,      0,   3212,    113,
     &      0,   3122,    221,      0,   3212,    221,      0,   3222,
     &   -211,      0,   3112,    211,      0,   3212,    111,      0,
     &   3122,    111,      0,   3122,   -211,      0,   3322,    111,
     &      0,   3312,    211,      0,   3322,   -211,      0,   3312,
     &    111,      0,   3322,   -211,      0,   3312,    111,      0,
     &   3122,   -321,      0,   3222,    221,      0,   3222,    331,
     &      0,   2212,   -311,      0,   3322,    321,      0,   3224,
     &    221,      0,   2214,    331,      0,   2224,   -321,      0,
     &   3122,    213,      0,   3212,    213,      0,   3222,    113,
     &      0,   3222,    223,      0,   2212,   -313,      0,   2214,
     &   -313,      0,   2224,   -323,      0,   4122,    211,      0,
     &   4122,    111,      0,   4122,   -211,      0,   3222,   -311,
     &      0,   3322,    211,      0,   3222,   -313,      0,   3322,
     &    213,      0,   3212,   -313,      0,   3222,   -323,      0,
     &   3322,    223,      0,   3312,    213,      0,   3214,   -313,
     &      0,   3322,   -311,      0,   3322,    313,      0,   3334/
      DATA (isec_linear(K),K=  761,  765) /
     &    213,      0,   3334,    211,      0/
      DATA (wg_chan(K),K=    1,  114) /
     &1.0000E+00,2.8000E-01,2.8000E-01,3.5000E-01,7.0000E-02,2.0000E-02,
     &1.0000E+00,9.9000E-01,1.0000E-02,3.8000E-01,3.0000E-02,3.0000E-01,
     &2.4000E-01,5.0000E-02,1.0000E+00,0.0000E+00,1.0000E+00,8.8800E-01,
     &2.5000E-02,8.7000E-02,4.8000E-01,2.4000E-01,2.6000E-01,2.0000E-02,
     &4.9100E-01,3.4400E-01,1.2900E-01,2.4000E-02,1.2000E-02,4.0000E-01,
     &3.0000E-01,3.0000E-01,6.0000E-01,4.0000E-01,4.0000E-01,3.0000E-01,
     &3.0000E-01,5.0000E-01,5.0000E-01,1.0000E+00,6.4000E-01,2.1000E-01,
     &6.0000E-02,2.0000E-02,3.0000E-02,4.0000E-02,6.9000E-01,3.1000E-01,
     &2.1000E-01,1.2000E-01,2.7000E-01,4.0000E-01,3.3000E-01,6.7000E-01,
     &3.3000E-01,6.7000E-01,3.3000E-01,6.7000E-01,3.3000E-01,6.7000E-01,
     &1.9000E-01,3.8000E-01,9.0000E-02,2.0000E-01,3.0000E-02,4.0000E-02,
     &5.0000E-02,2.0000E-02,1.9000E-01,3.8000E-01,9.0000E-02,2.0000E-01,
     &3.0000E-02,4.0000E-02,5.0000E-02,2.0000E-02,7.0000E-01,3.0000E-01,
     &1.0000E-01,5.0000E-01,1.6000E-01,2.4000E-01,5.5000E-01,4.5000E-01,
     &6.8000E-01,3.0000E-01,2.0000E-02,3.0000E-01,4.0000E-01,3.0000E-01,
     &9.0000E-01,1.0000E-01,4.9000E-01,4.9000E-01,2.0000E-02,1.0000E-01,
     &1.0000E-01,8.0000E-01,6.0000E-01,3.0000E-01,1.0000E-01,1.0000E+00,
     &1.5000E-01,3.5000E-01,7.0000E-02,1.8000E-01,1.1000E-01,6.0000E-02,
     &3.0000E-02,1.0000E-02,3.0000E-02,1.0000E-02,1.5000E-01,3.5000E-01/
      DATA (wg_chan(K),K=  115,  228) /
     &7.0000E-02,1.8000E-01,1.1000E-01,6.0000E-02,3.0000E-02,1.0000E-02,
     &3.0000E-02,1.0000E-02,3.7000E-01,1.8000E-01,4.0000E-02,8.0000E-02,
     &1.3000E-01,1.3000E-01,7.0000E-02,1.8000E-01,3.7000E-01,1.3000E-01,
     &8.0000E-02,4.0000E-02,7.0000E-02,1.3000E-01,1.3000E-01,7.0000E-02,
     &4.7000E-01,2.3000E-01,5.0000E-02,1.0000E-02,2.0000E-02,2.0000E-02,
     &7.0000E-02,1.3000E-01,2.3000E-01,4.7000E-01,5.0000E-02,2.0000E-02,
     &1.0000E-02,2.0000E-02,1.0000E+00,3.3000E-01,6.7000E-01,6.7000E-01,
     &3.3000E-01,1.0000E+00,2.5000E-01,1.8000E-01,2.7000E-01,3.0000E-01,
     &8.0000E-02,1.7000E-01,2.4000E-01,3.0000E-02,1.8000E-01,1.0000E-01,
     &2.0000E-01,1.7000E-01,8.0000E-02,1.8000E-01,3.0000E-02,2.4000E-01,
     &2.0000E-01,1.0000E-01,2.5000E-01,2.7000E-01,1.8000E-01,3.0000E-01,
     &6.4000E-01,3.6000E-01,5.2000E-01,4.8000E-01,1.0000E+00,1.0000E+00,
     &8.8000E-01,6.0000E-02,6.0000E-02,8.8000E-01,6.0000E-02,6.0000E-02,
     &8.8000E-01,1.2000E-01,1.9000E-01,1.9000E-01,1.6000E-01,1.6000E-01,
     &1.7000E-01,3.0000E-02,3.0000E-02,3.0000E-02,4.0000E-02,1.0000E-01,
     &1.0000E-01,2.0000E-01,1.2000E-01,1.0000E-01,4.0000E-02,4.0000E-02,
     &5.0000E-02,7.5000E-02,7.5000E-02,3.0000E-02,3.0000E-02,4.0000E-02,
     &1.0000E+00,1.0000E+00,3.3000E-01,6.7000E-01,6.7000E-01,3.3000E-01,
     &2.5000E-01,2.5000E-01,5.0000E-01,2.0000E-02,3.0000E-02,7.0000E-02/
      DATA (wg_chan(K),K=  229,  255) /
     &2.0000E-02,2.0000E-02,4.0000E-02,1.3000E-01,7.0000E-02,6.0000E-02,
     &6.0000E-02,2.0000E-01,1.4000E-01,4.0000E-02,1.0000E-01,1.0000E+00,
     &1.0000E+00,1.0000E+00,2.5000E-01,3.0000E-02,3.0000E-01,4.2000E-01,
     &2.2000E-01,3.5000E-01,1.9000E-01,1.6000E-01,8.0000E-02,3.7000E-01,
     &2.0000E-01,3.6000E-01,7.0000E-02/
      DATA (id_psm_linear(K),K=    1,   36) /
     &    111,    211,   -311,    411,      0,      0,   -211,    111,
     &   -321,    421,      0,      0,    311,    321,    221,    431,
     &      0,      0,   -411,   -421,   -431,    441,      0,      0,
     &      0,      0,      0,      0,      0,      0,      0,      0,
     &      0,      0,      0,      0/
      DATA (id_vem_linear(K),K=    1,   36) /
     &    113,    213,   -313,    413,      0,      0,   -213,    113,
     &   -323,    423,      0,      0,    313,    323,    333,    433,
     &      0,      0,   -413,   -423,   -433,  20443,      0,      0,
     &      0,      0,      0,      0,      0,      0,      0,      0,
     &      0,      0,      0,      0/
      DATA (id_b8_linear(K),K=    1,  171) /
     &  1114,  2112,  3112,  4112,     0,     0,  2112,  2212,  3212,
     &  4122,     0,     0,  3112,  3212,  3312,  4132,     0,     0,
     &  4112,  4122,  4132,  4412,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  2112,  2212,  3212,  4122,     0,     0,  2212,  2224,  3222,
     &  4222,     0,     0,  3212,  3222,  3322,  4232,     0,     0,
     &  4122,  4222,  4232,  4422,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  3112,  3212,  3312,  4132,     0,     0,  3212,  3222,  3322,
     &  4232,     0,     0,  3312,  3322,  3334,  4332,     0,     0,
     &  4132,  4232,  4332,  4432,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  4112,  4122,  4132,  4412,     0,     0,  4122,  4222,  4232,
     &  4422,     0,     0,  4132,  4232,  4332,  4432,     0,     0,
     &  4412,  4422,  4432,  4444,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/
      DATA (id_b8_linear(K),K=  172,  216) /
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/
      DATA (id_b10_linear(K),K=    1,  171) /
     &  1114,  2114,  3114,  4114,     0,     0,  2114,  2214,  3214,
     &  4214,     0,     0,  3114,  3214,  3314,  4314,     0,     0,
     &  4114,  4214,  4314,  4414,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  2114,  2214,  3214,  4214,     0,     0,  2214,  2224,  3224,
     &  4224,     0,     0,  3214,  3224,  3324,  4324,     0,     0,
     &  4214,  4224,  4324,  4424,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  3114,  3214,  3314,  4314,     0,     0,  3214,  3224,  3324,
     &  4324,     0,     0,  3314,  3324,  3334,  4334,     0,     0,
     &  4314,  4324,  4334,  4434,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  4114,  4214,  4314,  4414,     0,     0,  4214,  4224,  4324,
     &  4424,     0,     0,  4314,  4324,  4334,  4434,     0,     0,
     &  4414,  4424,  4434,  4444,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/
      DATA (id_b10_linear(K),K=  172,  216) /
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/
 
      ID_pdg_max = i_tab_max
 
C  copy from local to global variables
      DO i = 1 , i_tab_max
         ID_pdg_list(i) = number(i)
         NAMe_list(i) = name(i)
         XM_list(i) = xmass(i)
         GAM_list(i) = gamma(i)
         ICH3_list(i) = ich3(i)
         IBA3_list(i) = iba3(i)
         DO j = 1 , 3
            IQ_list(j,i) = iq_linear(3*(i-1)+j)
            IDEc_list(j,i) = idec_linear(3*(i-1)+j)
         END DO
      END DO
 
C  initialize hash table
      CALL PHO_CPCINI(ID_pdg_max,ID_pdg_list,ID_list)
 
      itmp = IDEb(71)
      IDEb(71) = -1
 
C  quark index table for mesons
      DO i = 1 , 6
         DO j = 1 , 6
            ID_psm_list(i,j) = IPHO_PDG2ID(id_psm_linear(6*(j-1)+i))
            ID_vem_list(i,j) = IPHO_PDG2ID(id_vem_linear(6*(j-1)+i))
         END DO
      END DO
 
C  quark index table for baryons
      DO i = 1 , 6
         DO j = 1 , 6
            DO k = 1 , 6
               ID_b8_list(i,j,k)
     &            = IPHO_PDG2ID(id_b8_linear(36*(k-1)+6*(j-1)+i))
               ID_b10_list(i,j,k)
     &            = IPHO_PDG2ID(id_b10_linear(36*(k-1)+6*(j-1)+i))
            END DO
         END DO
      END DO
 
      IDEb(71) = itmp
 
C  copy secondary particles
C  (translate PDG-ID to CPC and sort according to CPC)
      ichan = 0
      DO i = 1 , i_tab_max
         IF ( IDEc_list(1,i).NE.0 ) THEN
            DO j = IDEc_list(2,i) , IDEc_list(3,i)
               ichan = ichan + 1
               WG_sec_list(ichan) = wg_chan(j)
               DO k = 1 , 3
                  IF ( isec_linear(3*(j-1)+k).NE.0 ) THEN
                     ISEc_list(k,ichan)
     &                  = IPHO_PDG2ID(isec_linear(3*(j-1)+k))
                  ELSE
                     ISEc_list(k,ichan) = 0
                  END IF
               END DO
            END DO
         END IF
      END DO
 
C  add two-pion background (low-mass photon dissociation)
      i = IPHO_PDG2ID(92)
      ichan = ichan + 1
      IDEc_list(1,i) = 1
      IDEc_list(2,i) = ichan
      IDEc_list(3,i) = ichan
      WG_sec_list(ichan) = 1.D0
      ISEc_list(1,ichan) = IPHO_PDG2ID(211)
      ISEc_list(2,ichan) = IPHO_PDG2ID(-211)
      ISEc_list(3,ichan) = 0
 
C  min. mass limits for strings: q-qbar
      DO i = 1 , 6
         DO j = 1 , 6
            am2p = 1000.D0
            am2v = 1000.D0
            DO k = 1 , 3
C  pseudo-scalar mesons
               i1 = ABS(ID_psm_list(i,k))
               IF ( i1.NE.0 ) THEN
                  am1 = XM_list(i1)
               ELSE
                  am1 = PHO_PMASS(i,3) + PHO_PMASS(k,3)
               END IF
               i2 = ABS(ID_psm_list(k,j))
               IF ( i2.NE.0 ) THEN
                  am2 = XM_list(i2)
               ELSE
                  am2 = PHO_PMASS(k,3) + PHO_PMASS(j,3)
               END IF
               am2p = MIN(am2p,am1+am2)
C  vector mesons
               i1 = ABS(ID_vem_list(i,k))
               IF ( i1.NE.0 ) THEN
                  am1 = XM_list(i1)
               ELSE
                  am1 = PHO_PMASS(i,3) + PHO_PMASS(k,3)
               END IF
               i2 = ABS(ID_vem_list(k,j))
               IF ( i2.NE.0 ) THEN
                  am2 = XM_list(i2)
               ELSE
                  am2 = PHO_PMASS(k,3) + PHO_PMASS(j,3)
               END IF
               am2v = MIN(am2v,am1+am2)
            END DO
            XM_psm2_list(i,j) = am2p
            XM_vem2_list(i,j) = am2v
         END DO
      END DO
 
C  min. mass limits for strings: qq-q
      DO i = 1 , 6
         DO j = 1 , 6
            DO k = 1 , 6
               am82 = 1000.D0
               am102 = 1000.D0
               DO l = 1 , 3
C  pseudo-scalar meson
                  i1 = ABS(ID_psm_list(k,l))
                  IF ( i1.NE.0 ) THEN
                     am1 = XM_list(i1)
                  ELSE
                     am1 = PHO_PMASS(i,3) + PHO_PMASS(k,3)
                  END IF
C  vector meson
                  i2 = ABS(ID_vem_list(k,l))
                  IF ( i2.NE.0 ) THEN
                     am2 = XM_list(i2)
                  ELSE
                     am2 = PHO_PMASS(i,3) + PHO_PMASS(k,3)
                  END IF
C  octet baryon
                  amm = MIN(am1,am2)
                  k8 = ID_b8_list(i,j,l)
                  IF ( k8.NE.0 ) THEN
                     am1 = XM_list(k8)
                  ELSE
                     am1 = PHO_PMASS(i,3) + PHO_PMASS(j,3)
     &                     + PHO_PMASS(l,3)
                  END IF
                  am82 = MIN(am82,am1+amm)
C  decuplet baryon
                  k10 = ID_b10_list(i,j,l)
                  IF ( k10.NE.0 ) THEN
                     am2 = XM_list(k10)
                  ELSE
                     am2 = PHO_PMASS(i,3) + PHO_PMASS(j,3)
     &                     + PHO_PMASS(l,3)
                  END IF
                  am102 = MIN(am102,am2+amm)
               END DO
               XM_b82_list(i,j,k) = am82
               XM_b102_list(i,j,k) = am102
            END DO
         END DO
      END DO
 
C  min. mass limits for strings: qq-qbarqbar
      DO i = 1 , 6
         DO j = 1 , 6
            DO ii = 1 , 6
               DO jj = 1 , 6
                  am82 = 1000.D0
                  am102 = 1000.D0
                  DO l = 1 , 3
C  octet baryons
                     k8 = ID_b8_list(i,j,l)
                     IF ( k8.NE.0 ) THEN
                        am1 = XM_list(k8)
                     ELSE
                        am1 = PHO_PMASS(i,3) + PHO_PMASS(j,3)
     &                        + PHO_PMASS(l,3)
                     END IF
                     l8 = ID_b8_list(ii,jj,l)
                     IF ( l8.NE.0 ) THEN
                        am2 = XM_list(l8)
                     ELSE
                        am2 = PHO_PMASS(ii,3) + PHO_PMASS(jj,3)
     &                        + PHO_PMASS(l,3)
                     END IF
                     am82 = MIN(am82,am1+am2)
C  decuplet baryons
                     k10 = ID_b10_list(i,j,l)
                     IF ( k10.NE.0 ) THEN
                        am1 = XM_list(k10)
                     ELSE
                        am1 = PHO_PMASS(i,3) + PHO_PMASS(j,3)
     &                        + PHO_PMASS(l,3)
                     END IF
                     l10 = ID_b10_list(ii,jj,l)
                     IF ( l10.NE.0 ) THEN
                        am2 = XM_list(l10)
                     ELSE
                        am2 = PHO_PMASS(ii,3) + PHO_PMASS(jj,3)
     &                        + PHO_PMASS(l,3)
                     END IF
                     am102 = MIN(am102,am1+am2)
                  END DO
                  XM_bb82_list(i,j,ii,jj) = am82
                  XM_bb102_list(i,j,ii,jj) = am102
               END DO
            END DO
         END DO
      END DO
 
      END SUBROUTINE
